/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.persist;

import com.sleepycat.client.SDatabaseConfig;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SEnvironment;
import com.sleepycat.client.SSecondaryConfig;
import com.sleepycat.client.SSequence;
import com.sleepycat.client.SSequenceConfig;
import com.sleepycat.client.STransaction;
import com.sleepycat.client.persist.IndexNotAvailableException;
import com.sleepycat.client.persist.PrimaryIndex;
import com.sleepycat.client.persist.SecondaryIndex;
import com.sleepycat.client.persist.StoreConfig;
import com.sleepycat.client.persist.StoreExistsException;
import com.sleepycat.client.persist.StoreNotFoundException;
import com.sleepycat.client.persist.evolve.EvolveConfig;
import com.sleepycat.client.persist.evolve.EvolveStats;
import com.sleepycat.client.persist.evolve.IncompatibleClassException;
import com.sleepycat.client.persist.evolve.Mutations;
import com.sleepycat.client.persist.impl.Store;
import com.sleepycat.client.persist.model.EntityModel;

public class EntityStore {
    private Store store;

    public EntityStore(SEnvironment sEnvironment, String string, StoreConfig storeConfig) throws StoreExistsException, StoreNotFoundException, IncompatibleClassException, SDatabaseException {
        this.store = new Store(sEnvironment, string, storeConfig, false);
    }

    public SEnvironment getEnvironment() {
        return this.store.getEnvironment();
    }

    public StoreConfig getConfig() {
        return this.store.getConfig();
    }

    public String getStoreName() {
        return this.store.getStoreName();
    }

    public EntityModel getModel() {
        return this.store.getModel();
    }

    public Mutations getMutations() {
        return this.store.getMutations();
    }

    public <PK, E> PrimaryIndex<PK, E> getPrimaryIndex(Class<PK> clazz, Class<E> clazz2) throws SDatabaseException {
        try {
            return this.store.getPrimaryIndex(clazz, clazz.getName(), clazz2, clazz2.getName());
        }
        catch (IndexNotAvailableException indexNotAvailableException) {
            if (!this.store.attemptRefresh()) {
                throw indexNotAvailableException;
            }
            return this.store.getPrimaryIndex(clazz, clazz.getName(), clazz2, clazz2.getName());
        }
    }

    public <SK, PK, E> SecondaryIndex<SK, PK, E> getSecondaryIndex(PrimaryIndex<PK, E> primaryIndex, Class<SK> clazz, String string) throws SDatabaseException {
        try {
            return this.store.getSecondaryIndex(primaryIndex, primaryIndex.getEntityClass(), primaryIndex.getEntityClass().getName(), clazz, clazz.getName(), string);
        }
        catch (IndexNotAvailableException indexNotAvailableException) {
            if (!this.store.attemptRefresh()) {
                throw indexNotAvailableException;
            }
            return this.store.getSecondaryIndex(primaryIndex, primaryIndex.getEntityClass(), primaryIndex.getEntityClass().getName(), clazz, clazz.getName(), string);
        }
    }

    public <SK, PK, E1, E2 extends E1> SecondaryIndex<SK, PK, E2> getSubclassIndex(PrimaryIndex<PK, E1> primaryIndex, Class<E2> clazz, Class<SK> clazz2, String string) throws SDatabaseException {
        this.getModel().getClassMetadata(clazz.getName());
        try {
            return this.store.getSecondaryIndex(primaryIndex, clazz, primaryIndex.getEntityClass().getName(), clazz2, clazz2.getName(), string);
        }
        catch (IndexNotAvailableException indexNotAvailableException) {
            if (!this.store.attemptRefresh()) {
                throw indexNotAvailableException;
            }
            return this.store.getSecondaryIndex(primaryIndex, clazz, primaryIndex.getEntityClass().getName(), clazz2, clazz2.getName(), string);
        }
    }

    public EvolveStats evolve(EvolveConfig evolveConfig) throws SDatabaseException {
        return this.store.evolve(evolveConfig);
    }

    public void truncateClass(Class clazz) throws SDatabaseException {
        this.store.truncateClass(null, clazz);
    }

    public void truncateClass(STransaction sTransaction, Class clazz) throws SDatabaseException {
        this.store.truncateClass(sTransaction, clazz);
    }

    public void closeClass(Class clazz) throws SDatabaseException {
        this.store.closeClass(clazz);
    }

    public void close() throws SDatabaseException {
        this.store.close();
    }

    public SSequence getSequence(String string) throws SDatabaseException {
        return this.store.getSequence(string);
    }

    public SSequenceConfig getSequenceConfig(String string) {
        return this.store.getSequenceConfig(string);
    }

    public void setSequenceConfig(String string, SSequenceConfig sSequenceConfig) {
        this.store.setSequenceConfig(string, sSequenceConfig);
    }

    public SDatabaseConfig getPrimaryConfig(Class clazz) {
        return this.store.getPrimaryConfig(clazz);
    }

    public void setPrimaryConfig(Class clazz, SDatabaseConfig sDatabaseConfig) {
        this.store.setPrimaryConfig(clazz, sDatabaseConfig);
    }

    public SSecondaryConfig getSecondaryConfig(Class clazz, String string) {
        return this.store.getSecondaryConfig(clazz, string);
    }

    public void setSecondaryConfig(Class clazz, String string, SSecondaryConfig sSecondaryConfig) {
        this.store.setSecondaryConfig(clazz, string, sSecondaryConfig);
    }
}

