/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.bind.tuple;

import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.bind.tuple.TupleBinding;
import com.sleepycat.client.bind.tuple.TupleInput;
import com.sleepycat.client.bind.tuple.TupleOutput;

public class CharacterBinding
extends TupleBinding<Character> {
    private static final int CHAR_SIZE = 2;

    @Override
    public Character entryToObject(TupleInput tupleInput) {
        return Character.valueOf(tupleInput.readChar());
    }

    @Override
    public void objectToEntry(Character c, TupleOutput tupleOutput) {
        tupleOutput.writeChar(c.charValue());
    }

    @Override
    protected TupleOutput getTupleOutput(Character c) {
        return CharacterBinding.sizedOutput();
    }

    public static char entryToChar(SDatabaseEntry sDatabaseEntry) {
        return CharacterBinding.entryToInput(sDatabaseEntry).readChar();
    }

    public static void charToEntry(char c, SDatabaseEntry sDatabaseEntry) {
        CharacterBinding.outputToEntry(CharacterBinding.sizedOutput().writeChar(c), sDatabaseEntry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[2]);
    }
}

