/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.server.util;

import com.sleepycat.server.config.EnvDirType;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);
    private static final Path ROOT = Paths.get("/", new String[0]);

    public static boolean hasAnyPermission(String string, PosixFilePermission ... posixFilePermissionArray) throws IOException {
        Set<PosixFilePermission> set = Files.getPosixFilePermissions(Paths.get(string, new String[0]), new LinkOption[0]);
        set.retainAll(Arrays.asList(posixFilePermissionArray));
        return !set.isEmpty();
    }

    public static String checkAndNormalize(String string) throws IllegalArgumentException {
        Path path = Paths.get(string, new String[0]).normalize();
        if (path.isAbsolute()) {
            throw new IllegalArgumentException("Absolute path is not allowed.");
        }
        if (path.toString().trim().isEmpty()) {
            throw new IllegalArgumentException("Empty path is not allowed.");
        }
        Path path2 = ROOT.relativize(ROOT.resolve(path).normalize());
        if (!path.equals(path2)) {
            throw new IllegalArgumentException("Paths that escape parent is not allowed.");
        }
        return path.toString();
    }

    public static Map<EnvDirType, File> resolveDirectories(Map<EnvDirType, File> map, String string, boolean bl) throws IOException {
        String string2 = FileUtils.checkAndNormalize(string);
        HashMap<EnvDirType, File> hashMap = new HashMap<EnvDirType, File>();
        for (EnvDirType envDirType : map.keySet()) {
            File file = new File(map.get((Object)envDirType), string2);
            if (FileUtils.isType(file, FileType.directory, bl)) {
                hashMap.put(envDirType, file);
                continue;
            }
            throw new IOException("Cannot access " + (Object)((Object)envDirType) + " directory.");
        }
        return hashMap;
    }

    public static File resolveDirectory(File file, String string) {
        return FileUtils.resolve(file, string, FileType.directory, false);
    }

    public static File resolveFile(File file, String string, boolean bl) {
        return FileUtils.resolve(file, string, FileType.file, bl);
    }

    private static File resolve(File file, String string, FileType fileType, boolean bl) {
        File file2 = new File(file, FileUtils.checkAndNormalize(string));
        return FileUtils.isType(file2, fileType, bl) ? file2 : null;
    }

    private static boolean isType(File file, FileType fileType, boolean bl) {
        boolean bl2;
        Predicate<File> predicate = fileType == FileType.file ? File::isFile : File::isDirectory;
        boolean bl3 = file.exists() && predicate.test(file);
        boolean bl4 = bl2 = bl && !file.exists();
        if (bl3 || bl2) {
            return true;
        }
        if (file.exists()) {
            logger.info(file.getPath() + "is not a " + (Object)((Object)fileType) + ".");
        } else {
            logger.info(file.getPath() + "does not exist.");
        }
        return false;
    }

    public static void createDirectories(Collection<File> collection) throws IOException {
        try {
            for (File file : collection) {
                Files.createDirectories(file.toPath(), new FileAttribute[0]);
            }
        }
        catch (IOException iOException) {
            logger.info("Cannot create directory", (Throwable)iOException);
            throw new IOException("Cannot access directory.", iOException);
        }
    }

    public static void deleteFileTree(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                if (iOException == null) {
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }
                throw iOException;
            }
        });
    }

    private static enum FileType {
        file,
        directory;

    }
}

