/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.server.handle;

import com.sleepycat.server.handle.ResourceKey;
import java.io.File;
import java.io.IOException;
import java.util.Objects;

public abstract class FileKey
implements ResourceKey {
    private final String canonicalPath;

    protected FileKey(File file) throws IOException {
        this.canonicalPath = file.getCanonicalPath();
    }

    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FileKey fileKey = (FileKey)object;
        return Objects.equals(this.canonicalPath, fileKey.canonicalPath);
    }

    public int hashCode() {
        return Objects.hash(this.canonicalPath);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "canonicalPath='" + this.canonicalPath + '\'' + '}';
    }
}

