/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cvsgrab.web;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import net.sourceforge.cvsgrab.CVSGrab;
import net.sourceforge.cvsgrab.CvsWebInterface;
import net.sourceforge.cvsgrab.InvalidVersionException;
import net.sourceforge.cvsgrab.MarkerNotFoundException;
import net.sourceforge.cvsgrab.RemoteFile;
import net.sourceforge.cvsgrab.WebBrowser;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.w3c.dom.Document;

public abstract class ViewCvsInterface
extends CvsWebInterface {
    private String _type;
    private String _filesXpath = "//TR[TD/A/IMG/@alt = '(file)']";
    private String _fileNameXpath = "TD[1]/A/@name";
    private String _fileVersionXpath = "TD[A/IMG/@alt != '(graph)'][2]/A/B";
    private String _directoriesXpath = "//TR[TD/A/IMG/@alt = '(dir)'][TD/A/@name != 'Attic']";
    private String _directoryXpath = "TD[1]/A/@name";
    private String _checkoutPath = "*checkout*/";
    private String _webInterfaceType = "viewcvs";
    private String _tagParam = "only_with_tag";
    private String _cvsrootParam = "cvsroot";

    public ViewCvsInterface(CVSGrab grabber) {
        super(grabber);
    }

    public void init() throws Exception {
        this._type = this.getId();
    }

    public void detect(Document htmlPage) throws MarkerNotFoundException, InvalidVersionException {
        JXPathContext context = JXPathContext.newContext(htmlPage);
        Iterator viewCvsTexts = context.iterate("//META[@name = 'generator']/@content[starts-with(.,'ViewCVS')] | //A[@href]/text()[starts-with(.,'ViewCVS')]");
        this._type = null;
        String viewCvsVersion = null;
        while (viewCvsTexts.hasNext()) {
            viewCvsVersion = (String)viewCvsTexts.next();
            if (!viewCvsVersion.startsWith(this.getVersionMarker())) continue;
            this._type = viewCvsVersion;
            break;
        }
        if (this._type == null) {
            throw new MarkerNotFoundException("Expected marker " + this.getVersionMarker() + ", found " + viewCvsVersion);
        }
    }

    public String getId() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        className = className.substring(0, className.indexOf("Interface"));
        return className;
    }

    public String getType() {
        return this._type;
    }

    public String getBaseUrl() {
        String url = WebBrowser.forceFinalSlash(this.getGrabber().getRootUrl());
        url = url + this.getGrabber().getPackagePath();
        if (this.getProjectRoot() != null) {
            url = WebBrowser.addQueryParam(url, this._cvsrootParam, this.getProjectRoot());
        }
        url = WebBrowser.addQueryParam(url, this.getGrabber().getQueryParams());
        return url;
    }

    public String getDirectoryUrl(String rootUrl, String directoryName) {
        try {
            String tag2 = this.getVersionTag();
            String url = WebBrowser.forceFinalSlash(rootUrl);
            url = url + WebBrowser.forceFinalSlash(this.quote(directoryName));
            if (this.getProjectRoot() != null) {
                url = WebBrowser.addQueryParam(url, this._cvsrootParam, this.getProjectRoot());
            }
            url = WebBrowser.addQueryParam(url, this._tagParam, tag2);
            url = WebBrowser.addQueryParam(url, this.getQueryParams());
            return url;
        }
        catch (URIException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Cannot create URI");
        }
    }

    public RemoteFile[] getFiles(Document htmlPage) {
        JXPathContext context = JXPathContext.newContext(htmlPage);
        ArrayList<RemoteFile> files = new ArrayList<RemoteFile>();
        Iterator i = context.iteratePointers(this.getFilesXpath());
        while (i.hasNext()) {
            Pointer pointer = (Pointer)i.next();
            JXPathContext nodeContext = context.getRelativeContext(pointer);
            String fileName = (String)nodeContext.getValue(this.getFileNameXpath());
            String version = (String)nodeContext.getValue(this.getFileVersionXpath());
            RemoteFile file = new RemoteFile(fileName, version);
            this.adjustFile(file, nodeContext);
            files.add(file);
        }
        return files.toArray(new RemoteFile[files.size()]);
    }

    public String[] getDirectories(Document htmlPage) {
        JXPathContext context = JXPathContext.newContext(htmlPage);
        context.registerNamespace("HTML", "http://www.w3.org/1999/xhtml");
        context.registerNamespace("", "http://www.w3.org/1999/xhtml");
        ArrayList<String> directories = new ArrayList<String>();
        Iterator i = context.iteratePointers(this.getDirectoriesXpath());
        while (i.hasNext()) {
            Pointer pointer = (Pointer)i.next();
            JXPathContext nodeContext = context.getRelativeContext(pointer);
            try {
                String dir = (String)nodeContext.getValue(this.getDirectoryXpath());
                directories.add(dir);
            }
            catch (RuntimeException e) {
                CVSGrab.getLog().error("Cannot localise directory name in document location " + nodeContext.getPointer("."), e);
            }
        }
        return directories.toArray(new String[directories.size()]);
    }

    public String getDownloadUrl(RemoteFile file) {
        try {
            String url = WebBrowser.forceFinalSlash(file.getDirectory().getRemoteRepository().getRootUrl());
            String dir = file.getDirectory().getDirectoryPath();
            url = url + this.getCheckoutPath();
            url = url + WebBrowser.forceFinalSlash(this.quote(dir));
            if (file.isInAttic()) {
                url = url + "Attic/";
            }
            url = url + this.quote(file.getName());
            if (this.getProjectRoot() != null) {
                url = WebBrowser.addQueryParam(url, this._cvsrootParam, this.getProjectRoot());
            }
            url = WebBrowser.addQueryParam(url, "rev", file.getVersion());
            url = WebBrowser.addQueryParam(url, this.getQueryParams());
            return url;
        }
        catch (URIException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Cannot create URI");
        }
    }

    public Properties guessWebProperties(String url) {
        Properties properties = new Properties();
        int keywordPosition = url.toLowerCase().indexOf(this._webInterfaceType);
        if (keywordPosition > 0) {
            int rootUrlPosition = url.indexOf(47, keywordPosition) + 1;
            int cgiFolderPos = url.indexOf("cgi/", rootUrlPosition);
            if (cgiFolderPos > 0) {
                rootUrlPosition = cgiFolderPos + 4;
            }
            int nextSlashPos = url.indexOf(47, rootUrlPosition) + 1;
            int magicScriptPos = url.indexOf(".cgi", rootUrlPosition);
            if (magicScriptPos < 0) {
                magicScriptPos = url.indexOf(".py", rootUrlPosition);
            }
            if (magicScriptPos > 0 && magicScriptPos < nextSlashPos) {
                rootUrlPosition = nextSlashPos;
            }
            String guessedRootUrl = url.substring(0, rootUrlPosition);
            String guessedPackagePath = url.substring(rootUrlPosition);
            String versionTag = null;
            String cvsroot = null;
            String query = null;
            int queryPos = guessedPackagePath.indexOf(63);
            if (queryPos >= 0) {
                query = guessedPackagePath.substring(queryPos + 1);
                guessedPackagePath = guessedPackagePath.substring(0, queryPos);
                Properties queryItems = WebBrowser.getQueryParams(query);
                versionTag = (String)queryItems.remove(this._tagParam);
                cvsroot = (String)queryItems.remove(this._cvsrootParam);
                query = WebBrowser.toQueryParams(queryItems);
            }
            properties.put("rootUrl", guessedRootUrl);
            properties.put("packagePath", guessedPackagePath);
            if (versionTag != null && versionTag.trim().length() > 0) {
                properties.put("tag", versionTag);
            }
            if (cvsroot != null && cvsroot.trim().length() > 0) {
                properties.put("projectRoot", cvsroot);
            }
            if (query != null && query.trim().length() > 0) {
                properties.put("queryParams", query);
            }
        }
        return properties;
    }

    public String getFilesXpath() {
        return this._filesXpath;
    }

    public String getFileNameXpath() {
        return this._fileNameXpath;
    }

    public String getFileVersionXpath() {
        return this._fileVersionXpath;
    }

    public String getDirectoriesXpath() {
        return this._directoriesXpath;
    }

    public String getDirectoryXpath() {
        return this._directoryXpath;
    }

    protected String getCheckoutPath() {
        return this._checkoutPath;
    }

    protected void setCheckoutPath(String checkoutPath) {
        this._checkoutPath = checkoutPath;
    }

    public void setDirectoryXpath(String directoryXpath) {
        this._directoryXpath = directoryXpath;
    }

    public void setDirectoriesXpath(String directoriesXpath) {
        this._directoriesXpath = directoriesXpath;
    }

    public void setFileVersionXpath(String fileVersionXpath) {
        this._fileVersionXpath = fileVersionXpath;
    }

    public void setFileNameXpath(String fileNameXpath) {
        this._fileNameXpath = fileNameXpath;
    }

    public void setFilesXpath(String filesXpath) {
        this._filesXpath = filesXpath;
    }

    public String getTagParam() {
        return this._tagParam;
    }

    public void setTagParam(String param) {
        this._tagParam = param;
    }

    public String getWebInterfaceType() {
        return this._webInterfaceType;
    }

    protected void setWebInterfaceType(String webInterfaceType) {
        this._webInterfaceType = webInterfaceType;
    }

    public String getCvsrootParam() {
        return this._cvsrootParam;
    }

    public void setCvsrootParam(String cvsrootParam) {
        this._cvsrootParam = cvsrootParam;
    }

    protected void setType(String type) {
        this._type = type;
    }

    protected abstract String getVersionMarker();

    protected void adjustFile(RemoteFile file, JXPathContext nodeContext) {
        String fileName = file.getName();
        if (fileName.startsWith("Attic/")) {
            file.setName(fileName.substring(6));
            file.setInAttic(true);
        }
    }

    protected String quote(String original) throws URIException {
        return URIUtil.encodePath(original, "ISO-8859-1");
    }

    protected String getProjectRoot() {
        return this.getGrabber().getProjectRoot();
    }
}

