/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cvsgrab.web;

import net.sourceforge.cvsgrab.CVSGrab;
import net.sourceforge.cvsgrab.InvalidVersionException;
import net.sourceforge.cvsgrab.MarkerNotFoundException;
import net.sourceforge.cvsgrab.RemoteFile;
import net.sourceforge.cvsgrab.WebBrowser;
import net.sourceforge.cvsgrab.web.ViewCvsInterface;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.jxpath.JXPathContext;
import org.w3c.dom.Document;

public class ViewCvs1_0Interface
extends ViewCvsInterface {
    private String _root;

    public ViewCvs1_0Interface(CVSGrab grabber) {
        super(grabber);
        this.setFileVersionXpath("TD/A/B");
        this.setFilesXpath("//TR[TD/A/IMG/@alt = '(file)' or contains(TD/A/IMG/@src, 'text')]");
        this.setDirectoriesXpath("//TR[TD/A/IMG/@alt = '(dir)' or contains(TD/A/IMG/@src, 'dir')][TD/A/@name != 'Attic']");
    }

    public void detect(Document htmlPage) throws MarkerNotFoundException, InvalidVersionException {
        super.detect(htmlPage);
        this._root = this.getGrabber().getProjectRoot();
        if (this._root == null) {
            JXPathContext context = JXPathContext.newContext(htmlPage);
            context.setLenient(true);
            String href = (String)context.getValue("//A/@href[contains(., 'root=')]");
            if (href == null) {
                CVSGrab.getLog().info("CVS Root not found, there may be issues if ViewCvs is used with multiple repositories");
                CVSGrab.getLog().info("Use the parameter -projectRoot <root> to remove this warning");
            } else {
                this._root = href.substring(href.indexOf("root=") + 5);
                if (this._root.indexOf(35) > 0) {
                    this._root = this._root.substring(0, this._root.indexOf(35));
                }
                if (this._root.indexOf(38) > 0) {
                    this._root = this._root.substring(0, this._root.indexOf(38));
                }
            }
        }
        if (this.getGrabber().getRootUrl() != null && this.getGrabber().getRootUrl().startsWith("http://cvs.apache.org/viewcvs.cgi/") && this._root != null && this._root.indexOf("SVN") >= 0) {
            throw new InvalidVersionException("CVSGrab cannot be used on projects hosted in a SVN repository");
        }
    }

    public String getBaseUrl() {
        String url = WebBrowser.forceFinalSlash(this.getGrabber().getRootUrl());
        url = url + this.getGrabber().getPackagePath();
        url = WebBrowser.addQueryParam(url, this.getGrabber().getQueryParams());
        if (this.getGrabber().getProjectRoot() != null) {
            url = WebBrowser.addQueryParam(url, "root", this.getGrabber().getProjectRoot());
        }
        return url;
    }

    public String getAltBaseUrl() {
        String url = WebBrowser.forceFinalSlash(this.getGrabber().getRootUrl());
        url = WebBrowser.addQueryParam(url, this.getGrabber().getQueryParams());
        return url;
    }

    public String getDirectoryUrl(String rootUrl, String directoryName) {
        try {
            String url = super.getDirectoryUrl(rootUrl, directoryName);
            if (this._root != null) {
                url = WebBrowser.addQueryParam(url, "root", this.quote(this._root));
            }
            url = WebBrowser.addQueryParam(url, this.getQueryParams());
            return url;
        }
        catch (URIException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Cannot create URI");
        }
    }

    public String getDownloadUrl(RemoteFile file) {
        try {
            String url = super.getDownloadUrl(file);
            if (this._root != null) {
                url = WebBrowser.addQueryParam(url, "root", this.quote(this._root));
            }
            url = WebBrowser.addQueryParam(url, this.getQueryParams());
            return url;
        }
        catch (URIException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Cannot create URI");
        }
    }

    public String getRoot() {
        return this._root;
    }

    public void setRoot(String root) {
        this._root = root;
    }

    protected String getVersionMarker() {
        return "ViewCVS 1.0";
    }

    protected void adjustFile(RemoteFile file, JXPathContext nodeContext) {
        super.adjustFile(file, nodeContext);
        String href = (String)nodeContext.getValue("TD[1]/A/@href");
        if (href.indexOf("/Attic/" + file.getName()) >= 0) {
            file.setInAttic(true);
        }
    }
}

