/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cvsgrab.web;

import net.sourceforge.cvsgrab.CVSGrab;
import net.sourceforge.cvsgrab.RemoteFile;
import net.sourceforge.cvsgrab.WebBrowser;
import net.sourceforge.cvsgrab.web.ViewCvsInterface;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.jxpath.JXPathContext;

public class ViewCvs0_7Interface
extends ViewCvsInterface {
    public ViewCvs0_7Interface(CVSGrab grabber) {
        super(grabber);
        this.setFilesXpath("//TR[TD//A/IMG/@alt = '[FILE_ICON]']");
        this.setFileNameXpath("TD[1]/A/@name");
        this.setDirectoriesXpath("//TR[TD//A/IMG/@alt = '[DIR_ICON]'][TD/A/@name != 'Attic']");
        this.setDirectoryXpath("TD[1]/A/@name");
        this.setCheckoutPath("~checkout~/");
    }

    public String getDownloadUrl(String rootUrl, RemoteFile file) {
        try {
            String url = WebBrowser.forceFinalSlash(rootUrl);
            String dir = file.getDirectory().getDirectoryPath();
            url = url + this.getCheckoutPath();
            url = url + WebBrowser.forceFinalSlash(this.quote(dir));
            url = url + this.quote(file.getName());
            url = WebBrowser.addQueryParam(url, "rev", this.quote(file.getVersion()));
            url = WebBrowser.addQueryParam(url, this.getQueryParams());
            return url;
        }
        catch (URIException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Cannot create URI");
        }
    }

    protected String getVersionMarker() {
        return "ViewCVS 0.7";
    }

    protected void adjustFile(RemoteFile file, JXPathContext nodeContext) {
        super.adjustFile(file, nodeContext);
        String href = (String)nodeContext.getValue("TD/A/@href");
        if (href.startsWith("Attic/")) {
            file.setInAttic(true);
        }
    }
}

