/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cvsgrab.web;

import net.sourceforge.cvsgrab.CVSGrab;
import net.sourceforge.cvsgrab.InvalidVersionException;
import net.sourceforge.cvsgrab.MarkerNotFoundException;
import net.sourceforge.cvsgrab.RemoteFile;
import net.sourceforge.cvsgrab.WebBrowser;
import net.sourceforge.cvsgrab.web.ViewCvsInterface;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.jxpath.JXPathContext;
import org.w3c.dom.Document;

public class CvsWeb1_0Interface
extends ViewCvsInterface {
    private String _root;

    public CvsWeb1_0Interface(CVSGrab grabber) {
        super(grabber);
        this.setFilesXpath("//TR[TD//IMG/@alt = '[TXT]']");
        this.setDirectoriesXpath("//TR[TD//IMG/@alt = '[DIR]'][TD/A/@name != 'Attic']");
        this.setCheckoutPath("~checkout~/");
        this.setWebInterfaceType("cvsweb");
    }

    public void detect(Document htmlPage) throws MarkerNotFoundException, InvalidVersionException {
        String href;
        JXPathContext context = JXPathContext.newContext(htmlPage);
        context.setLenient(true);
        String generator = (String)context.getValue("//comment()[starts-with(normalize-space(.),'hennerik CVSweb')]");
        if (generator == null) {
            throw new MarkerNotFoundException("Not CvsWeb, did not found comment containing 'hennerik CVSweb'");
        }
        this.setType(generator);
        this._root = this.getGrabber().getProjectRoot();
        if (this._root == null && (href = (String)context.getValue("//A/@href[contains(., 'cvsroot=')]")) != null) {
            this._root = href.substring(href.indexOf("cvsroot=") + 8);
            if (this._root.indexOf(35) > 0) {
                this._root = this._root.substring(0, this._root.indexOf(35));
            }
            if (this._root.indexOf(38) > 0) {
                this._root = this._root.substring(0, this._root.indexOf(38));
            }
        }
    }

    protected String getVersionMarker() {
        return null;
    }

    public String getBaseUrl() {
        String url = WebBrowser.forceFinalSlash(this.getGrabber().getRootUrl());
        url = url + this.getGrabber().getPackagePath();
        url = WebBrowser.addQueryParam(url, this.getGrabber().getQueryParams());
        if (this.getGrabber().getProjectRoot() != null) {
            url = WebBrowser.addQueryParam(url, "cvsroot", this.getGrabber().getProjectRoot());
        }
        return url;
    }

    public String getAltBaseUrl() {
        String url = WebBrowser.forceFinalSlash(this.getGrabber().getRootUrl());
        url = WebBrowser.addQueryParam(url, this.getGrabber().getQueryParams());
        return url;
    }

    public String getDirectoryUrl(String rootUrl, String directoryName) {
        try {
            String url = super.getDirectoryUrl(rootUrl, directoryName);
            if (this._root != null) {
                url = WebBrowser.addQueryParam(url, "cvsroot", this.quote(this._root));
            }
            url = WebBrowser.addQueryParam(url, this.getQueryParams());
            return url;
        }
        catch (URIException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Cannot create URI");
        }
    }

    public String getDownloadUrl(RemoteFile file) {
        try {
            String url = super.getDownloadUrl(file);
            if (this._root != null) {
                url = WebBrowser.addQueryParam(url, "cvsroot", this.quote(this._root));
            }
            url = WebBrowser.addQueryParam(url, this.getQueryParams());
            return url;
        }
        catch (URIException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Cannot create URI");
        }
    }

    public String getRoot() {
        return this._root;
    }

    public void setRoot(String root) {
        this._root = root;
    }
}

