/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cvsgrab.util;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.cvsgrab.CVSGrab;

public class ThreadPool {
    private static ThreadPool _instance;
    private final boolean _debugging = false;
    private List _allThreads = new ArrayList();
    private List _pool = new ArrayList();
    private boolean _stopped = false;

    public static void init(int maxThreads) {
        CVSGrab.getLog().info("Using up to " + maxThreads + " simultaneous connections to load files");
        _instance = new ThreadPool(maxThreads);
    }

    public static ThreadPool getInstance() {
        return _instance;
    }

    public ThreadPool(int max) {
        for (int i = 0; i < max; ++i) {
            WorkerThread worker = new WorkerThread(i);
            this._pool.add(worker);
            this._allThreads.add(worker);
            worker.start();
        }
    }

    public void destroy() {
        this._stopped = true;
        for (int i = 0; i < this._allThreads.size(); ++i) {
            WorkerThread wt = (WorkerThread)this._allThreads.get(i);
            wt.kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTask(Runnable task) {
        WorkerThread worker = null;
        List list = this.getPool();
        synchronized (list) {
            while (this.getPool().isEmpty()) {
                if (this.isStopped()) {
                    return;
                }
                try {
                    this.getPool().wait();
                }
                catch (InterruptedException ex) {
                    System.err.println(ex.getMessage());
                    return;
                }
            }
            worker = (WorkerThread)this.getPool().remove(0);
        }
        worker.runTask(task);
    }

    protected List getPool() {
        return this._pool;
    }

    protected boolean isStopped() {
        return this._stopped;
    }

    private class WorkerThread
    extends Thread {
        private boolean stop = false;
        private Runnable task;

        public WorkerThread(int i) {
            this.setName("Worker" + i);
        }

        public synchronized void kill() {
            this.stop = true;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runTask(Runnable runnable) {
            this.task = runnable;
            WorkerThread workerThread = this;
            synchronized (workerThread) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.stop) {
                Object object;
                if (this.task == null) {
                    try {
                        object = this;
                        synchronized (object) {
                            this.wait();
                            continue;
                        }
                    }
                    catch (InterruptedException ex) {
                        continue;
                    }
                }
                try {
                    this.task.run();
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                }
                this.task = null;
                if (ThreadPool.this.isStopped()) {
                    return;
                }
                object = ThreadPool.this.getPool();
                synchronized (object) {
                    ThreadPool.this.getPool().add(this);
                    ThreadPool.this.getPool().notifyAll();
                }
            }
        }
    }
}

