/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cvsgrab.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import org.apache.commons.logging.impl.SimpleLog;

public class CVSGrabLog
extends SimpleLog {
    private static final long serialVersionUID = 8484066163771525005L;
    private String prefix;

    public CVSGrabLog(String arg0) {
        super(arg0);
    }

    protected void log(int type, Object message, Throwable t) {
        StringBuffer buf = new StringBuffer();
        if (showDateTime) {
            buf.append(dateFormatter.format(new Date()));
            buf.append(" ");
        }
        switch (type) {
            case 1: {
                buf.append("[TRACE] ");
                break;
            }
            case 2: {
                buf.append("[DEBUG] ");
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                buf.append("[WARN] ");
                break;
            }
            case 5: {
                buf.append("[ERROR] ");
                break;
            }
            case 6: {
                buf.append("[FATAL] ");
            }
        }
        if (showShortName) {
            if (this.prefix == null) {
                this.prefix = this.logName.substring(this.logName.lastIndexOf(".") + 1) + " - ";
                this.prefix = this.prefix.substring(this.prefix.lastIndexOf("/") + 1) + "-";
            }
            buf.append(this.prefix);
        } else if (showLogName) {
            buf.append(String.valueOf(this.logName)).append(" - ");
        }
        buf.append(String.valueOf(message));
        if (t != null) {
            buf.append(" <");
            buf.append(t.toString());
            buf.append(">");
            StringWriter sw = new StringWriter(1024);
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            buf.append(sw.toString());
        }
        System.err.println(buf.toString());
    }
}

