/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cvsgrab;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.sourceforge.cvsgrab.CVSGrab;
import net.sourceforge.cvsgrab.LocalRepository;
import net.sourceforge.cvsgrab.RemoteDirectory;
import net.sourceforge.cvsgrab.RemoteRepository;
import net.sourceforge.cvsgrab.WebBrowser;
import net.sourceforge.cvsgrab.util.ThreadPool;
import org.apache.commons.jrcs.diff.Revision;
import org.apache.commons.jrcs.diff.myers.MyersDiff;
import org.apache.commons.jrcs.diff.print.UnifiedPrint;

public class RemoteFile {
    public static final String TEXT_TYPE = "text";
    public static final String BINARY_TYPE = "binary";
    private static List textMatches = new ArrayList();
    private static List binaryMatches = new ArrayList();
    private RemoteDirectory _directory;
    private String _name;
    private String _version;
    private boolean _inAttic = false;
    private Date _lastModified;

    public static void setFileTypes(Properties fileTypes) {
        Iterator<Object> i = fileTypes.keySet().iterator();
        while (i.hasNext()) {
            String pattern = (String)i.next();
            String fileType = (String)fileTypes.get(pattern);
            if (TEXT_TYPE.equalsIgnoreCase(fileType)) {
                textMatches.add(new FileMatcher(pattern));
                continue;
            }
            if (BINARY_TYPE.equals(fileType)) {
                binaryMatches.add(new FileMatcher(pattern));
                continue;
            }
            CVSGrab.getLog().error("Invalid file type for pattern " + pattern + ". Was expecting text or binary instead of " + fileType);
        }
    }

    public RemoteFile(String name, String version) {
        this._name = name;
        this._version = version;
    }

    public String getName() {
        return this._name;
    }

    public String getVersion() {
        return this._version;
    }

    public RemoteDirectory getDirectory() {
        return this._directory;
    }

    public boolean isInAttic() {
        return this._inAttic;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setInAttic(boolean inAttic) {
        this._inAttic = inAttic;
    }

    public void setDirectory(RemoteDirectory directory) {
        this._directory = directory;
    }

    public Date getLastModified() {
        return this._lastModified;
    }

    public void grab(LocalRepository repository) {
        this._directory.registerRemoteFile(this);
        RemoteRepository remoteRepository = this._directory.getRemoteRepository();
        LocalRepository localRepository = remoteRepository.getLocalRepository();
        int updateStatus = localRepository.checkUpdateStatus(this);
        switch (updateStatus) {
            case 2: {
                return;
            }
            case 3: {
                CVSGrab.getLog().info("M " + this);
                return;
            }
            case 5: {
                CVSGrab.getLog().warn("cvs update: warning: cannot update " + this + ". A file with the same name is in the way.");
                break;
            }
            case 1: {
                CVSGrab.getLog().info("U " + this);
                this.doUpload();
                break;
            }
            case 4: {
                if (repository.isCleanUpdate()) {
                    repository.backupFile(this);
                    CVSGrab.getLog().info("U " + this);
                    this.doUpload();
                    break;
                }
                CVSGrab.getLog().info("C " + this);
                CVSGrab.getLog().warn("cvs update: warning: cannot merge this modified file with the new remote version, feature not yet supported");
                break;
            }
            default: {
                throw new RuntimeException("Invalid status " + updateStatus);
            }
        }
    }

    public void diff(LocalRepository repository, PrintWriter writer, CVSGrab grabber) {
        RemoteRepository remoteRepository = this._directory.getRemoteRepository();
        LocalRepository localRepository = remoteRepository.getLocalRepository();
        String localVersion = localRepository.getLocalVersion(this);
        if (localVersion != null) {
            this._version = localVersion;
        }
        int updateStatus = localRepository.checkUpdateStatus(this);
        switch (updateStatus) {
            case 2: {
                CVSGrab.getLog().debug("File not updated " + this);
                return;
            }
            case 5: {
                CVSGrab.getLog().warn("cvs update: warning: cannot update " + this + ". A file with the same name is in the way.");
                return;
            }
            case 1: {
                CVSGrab.getLog().info("U " + this);
                return;
            }
            case 3: 
            case 4: {
                CVSGrab.getLog().info("M " + this);
                if (this.isBinary()) {
                    CVSGrab.getLog().warn("File is modified locally but its type is binary. Update FileTypes.properties if needed.");
                    return;
                }
                try {
                    Object[] rev;
                    MyersDiff diff2;
                    Revision revision;
                    String url = remoteRepository.getDownloadUrl(this);
                    File origFile = File.createTempFile(this._name, null);
                    File revFile = localRepository.getLocalFile(this);
                    Object[] orig = new String[]{};
                    if (localVersion != null) {
                        WebBrowser.getInstance().loadFile(url, origFile);
                        orig = RemoteFile.loadFile(origFile.getAbsolutePath());
                    }
                    if ((revision = (diff2 = new MyersDiff()).diff(orig, rev = RemoteFile.loadFile(revFile.getAbsolutePath()))).size() == 0) break;
                    StringBuffer sb = new StringBuffer();
                    UnifiedPrint print = new UnifiedPrint(sb, orig, rev);
                    String localName = localRepository.getLocalFile(this).getCanonicalPath();
                    localName = localName.substring(new File(grabber.getDestDir()).getCanonicalPath().length() + 1);
                    print.setFileName(localName);
                    String rcsName = WebBrowser.forceFinalSlash(grabber.getCvsRoot()) + WebBrowser.forceFinalSlash(this.getDirectory().getDirectoryPath()) + this.getName();
                    rcsName = rcsName.substring(rcsName.lastIndexOf(58) + 1);
                    print.setRCSFileName(rcsName);
                    print.setOriginalVersion(localRepository.getLocalVersion(this));
                    print.setRevisedModifDate(new Date(revFile.lastModified()));
                    revision.accept(print);
                    print.close();
                    writer.print(sb.toString());
                }
                catch (Exception ex) {
                    CVSGrab.getLog().error("IO Error: " + ex);
                    ex.printStackTrace();
                }
                break;
            }
            default: {
                throw new RuntimeException("Invalid status " + updateStatus);
            }
        }
    }

    public boolean isBinary() {
        FileMatcher matcher;
        Iterator i = textMatches.iterator();
        while (i.hasNext()) {
            matcher = (FileMatcher)i.next();
            if (!matcher.match(this.getName())) continue;
            return false;
        }
        i = binaryMatches.iterator();
        while (i.hasNext()) {
            matcher = (FileMatcher)i.next();
            if (!matcher.match(this.getName())) continue;
            return true;
        }
        CVSGrab.getLog().warn("Unknown file type for " + this.getName() + ", assuming it's binary");
        return true;
    }

    private void doUpload() {
        if (ThreadPool.getInstance() != null) {
            ThreadPool.getInstance().doTask(new Runnable(){

                public void run() {
                    RemoteFile.this.upload();
                }
            });
        } else {
            this.upload();
        }
    }

    public String toString() {
        return this.getDirectory().toString() + this.getName();
    }

    protected void upload() {
        RemoteRepository remoteRepository = this._directory.getRemoteRepository();
        LocalRepository localRepository = remoteRepository.getLocalRepository();
        try {
            File localDir = localRepository.getLocalDir(this._directory);
            localDir.mkdirs();
            File destFile = new File(localDir, this._name);
            String url = remoteRepository.getDownloadUrl(this);
            WebBrowser.getInstance().loadFile(url, destFile);
            this._lastModified = new Date();
            localRepository.updateFileVersion(this);
        }
        catch (Exception ex) {
            localRepository.unregisterFile(this);
            this._directory.unregisterRemoteFile(this);
            CVSGrab.getLog().error("IO Error: " + ex);
            ex.printStackTrace();
        }
    }

    private static final String[] loadFile(String name) throws IOException {
        String s;
        BufferedReader data = new BufferedReader(new FileReader(name));
        ArrayList<String> lines = new ArrayList<String>();
        while ((s = data.readLine()) != null) {
            lines.add(s);
        }
        return lines.toArray(new String[lines.size()]);
    }

    private static class FileMatcher {
        private String pattern;

        public FileMatcher(String pattern) {
            this.pattern = pattern;
        }

        public boolean match(String fileName) {
            if (this.pattern.startsWith("*")) {
                return fileName.endsWith(this.pattern.substring(1));
            }
            return this.pattern.equalsIgnoreCase(fileName);
        }
    }
}

