/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cvsgrab;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import net.sourceforge.cvsgrab.CVSGrab;
import net.sourceforge.cvsgrab.CVSGrabAdminHandler;
import net.sourceforge.cvsgrab.RemoteDirectory;
import net.sourceforge.cvsgrab.RemoteFile;
import net.sourceforge.cvsgrab.WebBrowser;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.GlobalOptions;

public class LocalRepository {
    public static final int UPDATE_NEEDED = 1;
    public static final int UPDATE_NO_CHANGES = 2;
    public static final int UPDATE_LOCAL_CHANGE = 3;
    public static final int UPDATE_MERGE_NEEDED = 4;
    public static final int UPDATE_IMPOSSIBLE = 5;
    private AdminHandler _handler;
    private GlobalOptions _globalOptions = new GlobalOptions();
    private File _localRootDir;
    private File _localProjectDir;
    private int _newFiles = 0;
    private int _updatedFiles = 0;
    private int _removedFiles = 0;
    private int _failedUpdates = 0;
    private boolean _cleanUpdate;

    public LocalRepository(CVSGrab cvsGrab) {
        this._handler = new CVSGrabAdminHandler(cvsGrab);
        this._globalOptions.setCVSRoot(cvsGrab.getCvsRoot());
        this._globalOptions.setCheckedOutFilesReadOnly(true);
        this._localRootDir = new File(cvsGrab.getDestDir());
        this._cleanUpdate = cvsGrab.isCleanUpdate();
        this._localProjectDir = new File(this._localRootDir, cvsGrab.getPackagePath());
    }

    public File getLocalRootDir() {
        return this._localRootDir;
    }

    public File getLocalDir(RemoteDirectory remoteDir) {
        return new File(this.getLocalRootDir(), remoteDir.getLocalDir());
    }

    public File getLocalFile(RemoteFile remoteFile) {
        File dir = this.getLocalDir(remoteFile.getDirectory());
        File file = new File(dir, remoteFile.getName());
        return file;
    }

    public int getNewFileCount() {
        return this._newFiles;
    }

    public int getUpdatedFileCount() {
        return this._updatedFiles;
    }

    public int getRemovedFileCount() {
        return this._removedFiles;
    }

    public int getFailedUpdateCount() {
        return this._failedUpdates;
    }

    public boolean isCleanUpdate() {
        return this._cleanUpdate;
    }

    public void resetFileCounts() {
        this._newFiles = 0;
        this._updatedFiles = 0;
        this._removedFiles = 0;
        this._failedUpdates = 0;
    }

    public int checkUpdateStatus(RemoteFile remoteFile) {
        boolean needUpdate = true;
        File file = this.getLocalFile(remoteFile);
        if (file.exists()) {
            try {
                Entry entry = this._handler.getEntry(file);
                if (entry == null) {
                    CVSGrab.getLog().debug("No entry for file " + file);
                    ++this._failedUpdates;
                    return 5;
                }
                needUpdate = !remoteFile.getVersion().equals(entry.getRevision());
                boolean locallyModified = this.isLocallyModified(file, entry);
                if (locallyModified) {
                    CVSGrab.getLog().debug("File " + file + " is locally modified");
                }
                if (needUpdate) {
                    if (locallyModified) {
                        CVSGrab.getLog().debug("File " + file + " was modified since last update, cannot upload the new version of this file");
                        CVSGrab.getLog().debug("Last modified date on disk: " + new Date(file.lastModified()));
                        CVSGrab.getLog().debug("Last modified date on cvs: " + entry.getLastModified());
                        ++this._failedUpdates;
                        return 4;
                    }
                    CVSGrab.getLog().debug("New version available on the remote repository for file " + file);
                    return 1;
                }
                if (locallyModified) {
                    CVSGrab.getLog().debug("File " + file + " was modified since last update, cannot upload the new version of this file");
                    CVSGrab.getLog().debug("Last modified date on disk: " + new Date(file.lastModified()));
                    CVSGrab.getLog().debug("Last modified date on cvs: " + entry.getLastModified());
                }
                return locallyModified ? 3 : 2;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                ++this._failedUpdates;
                return 5;
            }
        }
        return 1;
    }

    public String getLocalVersion(RemoteFile remoteFile) {
        File file = this.getLocalFile(remoteFile);
        if (file.exists()) {
            try {
                Entry entry = this._handler.getEntry(file);
                if (entry == null) {
                    return null;
                }
                return entry.getRevision();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private boolean isLocallyModified(File file, Entry entry) {
        return file.lastModified() > entry.getLastModified().getTime() + 60000L;
    }

    public synchronized void updateFileVersion(RemoteFile remoteFile) {
        File dir = this.getLocalDir(remoteFile.getDirectory());
        File file = this.getLocalFile(remoteFile);
        Entry entry = null;
        Date lastModified = remoteFile.getLastModified();
        if (lastModified == null) {
            lastModified = new Date();
        }
        try {
            entry = this._handler.getEntry(file);
            if (entry == null) {
                throw new IOException("Entry not found");
            }
            entry.setRevision(remoteFile.getVersion());
            entry.setDate(lastModified);
            ++this._updatedFiles;
        }
        catch (IOException ex) {
            boolean binary = remoteFile.isBinary();
            String lastModifiedStr = Entry.getLastModifiedDateFormatter().format(lastModified);
            entry = new Entry("/" + remoteFile.getName() + "/" + remoteFile.getVersion() + "/" + lastModifiedStr + "/" + (binary ? "-kb/" : "/"));
            ++this._newFiles;
        }
        String localDirectory = WebBrowser.removeFinalSlash(dir.getAbsolutePath());
        String repositoryPath = remoteFile.getDirectory().getDirectoryPath();
        try {
            this._handler.updateAdminData(localDirectory, repositoryPath, entry, this._globalOptions);
        }
        catch (IOException ex) {
            ++this._failedUpdates;
            CVSGrab.getLog().error("Cannot update CVS entry for file " + file, ex);
            throw new RuntimeException("Cannot update CVS entry for file " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backupFile(RemoteFile remoteFile) {
        File dir = this.getLocalDir(remoteFile.getDirectory());
        File file = this.getLocalFile(remoteFile);
        File backupFile = new File(dir, ".#" + remoteFile.getName() + "." + remoteFile.getVersion());
        CVSGrab.getLog().info("Move " + remoteFile.getName() + " to " + backupFile.getName());
        BufferedInputStream in = null;
        FileOutputStream out = null;
        try {
            try {
                in = new BufferedInputStream(new FileInputStream(file));
                out = new FileOutputStream(backupFile);
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    out.write(buffer, 0, count);
                } while ((count = ((InputStream)in).read(buffer, 0, buffer.length)) != -1);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
        }
        catch (IOException ex) {
            ++this._failedUpdates;
            ex.printStackTrace();
            CVSGrab.getLog().error("Cannot create backup for file " + file);
            throw new RuntimeException("Cannot create backup for file " + file);
        }
    }

    public void unregisterFile(RemoteFile remoteFile) {
        File file = this.getLocalFile(remoteFile);
        try {
            this._handler.removeEntry(file);
            ++this._failedUpdates;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public synchronized void cleanRemovedFiles(RemoteDirectory remoteDirectory) {
        try {
            File dir = this.getLocalDir(remoteDirectory);
            Entry dirEntry = this._handler.getEntry(dir);
            Vector<String> dirFiles = new Vector<String>();
            if (dirEntry == null) {
                return;
            }
            Iterator i = this._handler.getEntries(dir);
            while (i.hasNext()) {
                Entry cvsFile = (Entry)i.next();
                if (cvsFile.isDirectory()) continue;
                dirFiles.add(cvsFile.getName());
            }
            RemoteFile[] lastDirFiles = remoteDirectory.getRemoteFiles();
            for (int i2 = 0; i2 < lastDirFiles.length; ++i2) {
                dirFiles.remove(lastDirFiles[i2].getName());
            }
            this._removedFiles += dirFiles.size();
            Iterator i3 = dirFiles.iterator();
            while (i3.hasNext()) {
                String fileName = (String)i3.next();
                File file = new File(this.getLocalDir(remoteDirectory), fileName);
                CVSGrab.getLog().debug("Removing " + file);
                this._handler.removeEntry(file);
                file.delete();
            }
        }
        catch (IOException ex) {
            ++this._failedUpdates;
            ex.printStackTrace();
            CVSGrab.getLog().error("Error while removing files marked for deletion");
        }
    }

    public void pruneEmptyDirectories() throws IOException {
        this.pruneEmptyDirectory(this._localProjectDir);
    }

    private boolean pruneEmptyDirectory(File directory) {
        boolean empty = true;
        File[] contents = directory.listFiles();
        if (contents != null) {
            File entriesFile;
            for (int i = 0; i < contents.length; ++i) {
                if (contents[i].isFile()) {
                    empty = false;
                    continue;
                }
                if (contents[i].getName().equals("CVS")) continue;
                empty = this.pruneEmptyDirectory(contents[i]);
            }
            if (empty && (entriesFile = new File(directory, "CVS/Entries")).exists()) {
                File adminDir = new File(directory, "CVS");
                File[] adminFiles = adminDir.listFiles();
                for (int i = 0; i < adminFiles.length; ++i) {
                    adminFiles[i].delete();
                }
                CVSGrab.getLog().debug("Removing empty directory " + directory);
                adminDir.delete();
                try {
                    this._handler.removeEntry(directory);
                }
                catch (IOException ex) {
                    ++this._failedUpdates;
                    ex.printStackTrace();
                    CVSGrab.getLog().error("Error while removing empty directory");
                }
                directory.delete();
                ++this._removedFiles;
            }
        }
        return empty;
    }

    public synchronized void add(RemoteDirectory remoteDir) {
        File dir = this.getLocalDir(remoteDir);
        if (dir.equals(this._localProjectDir)) {
            return;
        }
        Entry entry = null;
        String dirName = WebBrowser.removeFinalSlash(dir.getName());
        if (dirName.equals(".")) {
            return;
        }
        try {
            entry = this._handler.getEntry(dir);
            if (entry == null) {
                throw new IOException("Entry not found");
            }
        }
        catch (IOException ex) {
            entry = new Entry("D/" + dirName + "////");
        }
        String localDirectory = WebBrowser.removeFinalSlash(dir.getParent());
        String repositoryPath = WebBrowser.removeFinalSlash(remoteDir.getDirectoryPath());
        int lastSlash = repositoryPath.lastIndexOf(47);
        if (lastSlash > 0) {
            repositoryPath = repositoryPath.substring(0, lastSlash);
        }
        try {
            this._handler.updateAdminData(localDirectory, repositoryPath, entry, this._globalOptions);
        }
        catch (IOException ex) {
            ++this._failedUpdates;
            ex.printStackTrace();
            CVSGrab.getLog().error("Cannot update CVS entry for directory " + dir);
            throw new RuntimeException("Cannot update CVS entry for directory " + dir);
        }
    }
}

