/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cvsgrab;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sourceforge.cvsgrab.CVSGrab;
import net.sourceforge.cvsgrab.DetectException;
import net.sourceforge.cvsgrab.InvalidVersionException;
import net.sourceforge.cvsgrab.MarkerNotFoundException;
import net.sourceforge.cvsgrab.RemoteFile;
import net.sourceforge.cvsgrab.WebBrowser;
import net.sourceforge.cvsgrab.web.Chora2_0Interface;
import net.sourceforge.cvsgrab.web.CvsWeb1_0Interface;
import net.sourceforge.cvsgrab.web.CvsWeb2_0Interface;
import net.sourceforge.cvsgrab.web.CvsWeb3_0Interface;
import net.sourceforge.cvsgrab.web.FishEye1_0Interface;
import net.sourceforge.cvsgrab.web.FishEye1_2Interface;
import net.sourceforge.cvsgrab.web.Sourcecast1_0Interface;
import net.sourceforge.cvsgrab.web.Sourcecast2_0Interface;
import net.sourceforge.cvsgrab.web.Sourcecast3_0Interface;
import net.sourceforge.cvsgrab.web.ViewCvs0_7Interface;
import net.sourceforge.cvsgrab.web.ViewCvs0_8Interface;
import net.sourceforge.cvsgrab.web.ViewCvs0_9Interface;
import net.sourceforge.cvsgrab.web.ViewCvs1_0Interface;
import net.sourceforge.cvsgrab.web.ViewVC1_0Interface;
import net.sourceforge.cvsgrab.web.ViewVC1_1Interface;
import org.w3c.dom.Document;

public abstract class CvsWebInterface {
    public static final String DETECTED_WEB_INTERFACE = "detectedWebInterface";
    private static Map documents = new HashMap();
    private String _versionTag;
    private String _queryParams;
    private CVSGrab _grabber;

    private static CvsWebInterface[] getWebInterfaces(CVSGrab grabber) {
        return new CvsWebInterface[]{new ViewCvs0_7Interface(grabber), new ViewCvs0_8Interface(grabber), new ViewCvs0_9Interface(grabber), new ViewCvs1_0Interface(grabber), new ViewVC1_0Interface(grabber), new ViewVC1_1Interface(grabber), new Sourcecast1_0Interface(grabber), new Sourcecast2_0Interface(grabber), new Sourcecast3_0Interface(grabber), new CvsWeb1_0Interface(grabber), new CvsWeb2_0Interface(grabber), new CvsWeb3_0Interface(grabber), new Chora2_0Interface(grabber), new FishEye1_0Interface(grabber), new FishEye1_2Interface(grabber)};
    }

    public static final CvsWebInterface getInterface(CVSGrab grabber, String interfaceId) throws Exception {
        CvsWebInterface[] webInterfaces = CvsWebInterface.getWebInterfaces(grabber);
        for (int i = 0; i < webInterfaces.length; ++i) {
            if (!webInterfaces[i].getId().equals(interfaceId)) continue;
            webInterfaces[i].init();
            return webInterfaces[i];
        }
        return null;
    }

    public static final String[] getInterfaceIds(CVSGrab grabber) {
        CvsWebInterface[] webInterfaces = CvsWebInterface.getWebInterfaces(grabber);
        String[] ids = new String[webInterfaces.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = webInterfaces[i].getId();
        }
        return ids;
    }

    public static final String[] getBaseUrls(CVSGrab grabber) {
        CvsWebInterface[] webInterfaces = CvsWebInterface.getWebInterfaces(grabber);
        HashSet<String> urls = new HashSet<String>();
        for (int i = 0; i < webInterfaces.length; ++i) {
            CvsWebInterface webInterface = webInterfaces[i];
            urls.add(webInterface.getBaseUrl());
            urls.add(webInterface.getAltBaseUrl());
        }
        urls.remove(null);
        String[] listOfUrls = urls.toArray(new String[urls.size()]);
        Arrays.sort(listOfUrls, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                if (s1.length() > s2.length()) {
                    return -1;
                }
                if (s1.length() < s2.length()) {
                    return 1;
                }
                return 0;
            }
        });
        return listOfUrls;
    }

    public static CvsWebInterface findInterface(CVSGrab grabber) throws Exception {
        CvsWebInterface webInterface;
        int i;
        CvsWebInterface.checkRootUrl(grabber.getRootUrl());
        CvsWebInterface[] webInterfaces = CvsWebInterface.getWebInterfaces(grabber);
        ArrayList errors = new ArrayList();
        for (i = 0; i < webInterfaces.length; ++i) {
            webInterface = webInterfaces[i];
            if (!webInterface.presetMatch(grabber.getRootUrl(), grabber.getPackagePath())) continue;
            return webInterface;
        }
        for (i = 0; i < webInterfaces.length; ++i) {
            webInterface = webInterfaces[i];
            if (!webInterface.validate(errors)) continue;
            return webInterface;
        }
        CVSGrab.getLog().info("Tried to connect to the following urls: ");
        Iterator<Object> i2 = documents.keySet().iterator();
        while (i2.hasNext()) {
            CVSGrab.getLog().info(i2.next());
        }
        CVSGrab.getLog().info("Problems found during automatic detection: ");
        i2 = errors.iterator();
        while (i2.hasNext()) {
            String msg = (String)i2.next();
            CVSGrab.getLog().info(msg);
        }
        return null;
    }

    public static Properties getWebProperties(CVSGrab grabber, String rootUrl) {
        CvsWebInterface[] webInterfaces = CvsWebInterface.getWebInterfaces(grabber);
        for (int i = 0; i < webInterfaces.length; ++i) {
            Document doc;
            CvsWebInterface webInterface = webInterfaces[i];
            Properties webProperties = webInterface.guessWebProperties(rootUrl);
            if (webProperties.isEmpty() || (doc = CvsWebInterface.loadDocument(rootUrl)) == null) continue;
            try {
                grabber.getWebOptions().readProperties(webProperties);
                webInterface.detect(doc);
                webProperties.put(DETECTED_WEB_INTERFACE, webInterface);
                return webProperties;
            }
            catch (InvalidVersionException e) {
                grabber.getWebOptions().clearLocation();
                continue;
            }
            catch (MarkerNotFoundException e) {
                grabber.getWebOptions().clearLocation();
            }
        }
        return new Properties();
    }

    private static Document loadDocument(String url) {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        Document doc = (Document)documents.get(url);
        if (doc == null) {
            documents.put(url, null);
            try {
                doc = WebBrowser.getInstance().getDocument(url);
                documents.put(url, doc);
            }
            catch (Exception ex) {
                CVSGrab.getLog().debug("Error when loading page " + url, ex);
            }
        }
        return doc;
    }

    private static void checkRootUrl(String url) {
        int slash = url.indexOf(47, 8);
        if (slash > 0) {
            String path = url.substring(slash);
            String beforeLastPart = "";
            String lastPart = null;
            StringTokenizer st = new StringTokenizer(path, "/", false);
            while (st.hasMoreTokens()) {
                if (lastPart != null) {
                    beforeLastPart = beforeLastPart + "/" + lastPart;
                }
                lastPart = st.nextToken();
            }
            if (lastPart != null) {
                lastPart = lastPart.toLowerCase();
                if (beforeLastPart.length() > 0 && lastPart.indexOf("cvs") < 0 && lastPart.indexOf(".") < 0 && lastPart.indexOf("source") < 0 && lastPart.indexOf("src") < 0 && lastPart.indexOf("browse") < 0) {
                    CVSGrab.getLog().warn("The root url " + url + " doesn't seem valid");
                    String newRootUrl = url.substring(0, slash) + beforeLastPart;
                    CVSGrab.getLog().warn("Try " + newRootUrl + " as the root url instead");
                }
            }
        }
    }

    public static void registerDocument(String url, Document doc) {
        documents.put(url, doc);
    }

    public CvsWebInterface(CVSGrab grabber) {
        this._grabber = grabber;
    }

    public CVSGrab getGrabber() {
        return this._grabber;
    }

    public boolean presetMatch(String rootUrl, String packagePath) {
        return false;
    }

    public boolean validate(List errors) {
        if (this.presetMatch(this._grabber.getRootUrl(), this._grabber.getPackagePath())) {
            return true;
        }
        Document doc = null;
        String[] urls = new String[]{this.getBaseUrl(), this.getAltBaseUrl()};
        for (int j = 0; j < urls.length; ++j) {
            String url = urls[j];
            if (url == null) continue;
            try {
                CVSGrab.getLog().debug(this.getId() + ": Loading for validation " + url);
                doc = CvsWebInterface.loadDocument(url);
                if (doc != null) {
                    this.detect(doc);
                    return true;
                }
                errors.add(this.getId() + " tried to match page " + url + " but page doesn't exist");
                continue;
            }
            catch (DetectException ex) {
                CVSGrab.getLog().debug(this.getId() + " doesn't match, cause is " + ex.toString());
                errors.add(this.getId() + " tried to match page " + url + " but found error " + ex.getMessage());
                continue;
            }
            catch (RuntimeException ex) {
                CVSGrab.getLog().debug(this.getId() + " doesn't match, cause is " + ex.toString());
                errors.add(this.getId() + " tried to match page " + url + " but found error " + ex.getMessage());
            }
        }
        return false;
    }

    public String getVersionTag() {
        return this._versionTag;
    }

    public void setVersionTag(String versionTag) {
        this._versionTag = versionTag;
    }

    public String getQueryParams() {
        return this._queryParams;
    }

    public void setQueryParams(String params) {
        this._queryParams = params;
    }

    public abstract void init() throws Exception;

    public abstract void detect(Document var1) throws MarkerNotFoundException, InvalidVersionException;

    public abstract String getId();

    public abstract String getType();

    public abstract String getBaseUrl();

    public String getAltBaseUrl() {
        return null;
    }

    public abstract String getDirectoryUrl(String var1, String var2);

    public abstract RemoteFile[] getFiles(Document var1);

    public abstract String[] getDirectories(Document var1);

    public abstract String getDownloadUrl(RemoteFile var1);

    public abstract Properties guessWebProperties(String var1);
}

