/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cvsgrab;

import net.sourceforge.cvsgrab.CVSGrab;
import net.sourceforge.cvsgrab.WebBrowser;
import net.sourceforge.cvsgrab.WebOptions;
import net.sourceforge.cvsgrab.util.ThreadPool;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class CVSGrabTask
extends Task {
    private CVSGrab _grabber = new CVSGrab();
    private boolean _verbose = true;
    private int _connections;
    private WebOptions _webOptions = this._grabber.getWebOptions();

    public void setUrl(String value) {
        this._grabber.setUrl(value);
    }

    public void setRootUrl(String value) {
        this._webOptions.setRootUrl(value);
    }

    public void setPackagePath(String value) {
        this._webOptions.setPackagePath(value);
    }

    public void setProjectRoot(String value) {
        this._webOptions.setProjectRoot(value);
    }

    public void setDestDir(String value) {
        this._grabber.setDestDir(value);
    }

    public void setPackageDir(String value) {
        this._grabber.setPackageDir(value);
    }

    public void setCvsRoot(String value) {
        this._grabber.setCvsRoot(value);
    }

    public void setTag(String value) {
        this._webOptions.setVersionTag(value);
    }

    public void setWebInterface(String value) {
        this._webOptions.setWebInterfaceId(value);
    }

    public void setVerbose(boolean value) {
        this._verbose = value;
    }

    public void setPruneEmptyDirs(boolean value) {
        this._grabber.setPruneEmptyDirs(value);
    }

    public void setCleanUpdate(boolean value) {
        this._grabber.setCleanUpdate(value);
    }

    public void setConnections(int connections) {
        this._connections = connections;
    }

    public WebOptions.HttpProxy createProxy() {
        WebOptions.HttpProxy proxy = this._webOptions.new WebOptions.HttpProxy();
        this._webOptions.setHttpProxy(proxy);
        return proxy;
    }

    public WebOptions.WebAuthentification createWeb() {
        WebOptions.WebAuthentification auth = this._webOptions.new WebOptions.WebAuthentification();
        this._webOptions.setWebAuthentification(auth);
        return auth;
    }

    public void execute() throws BuildException {
        if (this._grabber.getRootUrl() == null) {
            throw new BuildException("rootUrl argument is not specified");
        }
        if (this._grabber.getDestDir() == null) {
            throw new BuildException("destDir argument is not specified");
        }
        if (this._grabber.getPackagePath() == null) {
            throw new BuildException("packagePath argument is not specified");
        }
        AntLogger log2 = new AntLogger(this.getProject());
        log2.setVerbose(this._verbose);
        CVSGrab.setLog(log2);
        this._webOptions.setupConnectionSettings();
        if (this._connections > 1) {
            ThreadPool.init(this._connections);
            WebBrowser.getInstance().useMultithreading();
        }
        this._grabber.grabCVSRepository();
    }

    class AntLogger
    implements Log {
        private boolean verbose;
        private Project antProject;

        public AntLogger(Project project) {
            this.antProject = project;
        }

        public void setVerbose(boolean value) {
            this.verbose = value;
        }

        public void setDebug(boolean value) {
        }

        public void debug(Object msg) {
            this.antProject.log(msg.toString(), 3);
        }

        public void verbose(Object msg) {
            if (this.verbose) {
                this.antProject.log(msg.toString(), 2);
            } else {
                this.antProject.log(msg.toString(), 3);
            }
        }

        public void info(Object msg) {
            this.antProject.log(msg.toString(), 2);
        }

        public void warn(Object msg) {
            this.antProject.log(msg.toString(), 1);
        }

        public void error(Object msg) {
            this.antProject.log(msg.toString(), 0);
        }

        public boolean isDebugEnabled() {
            return true;
        }

        public boolean isErrorEnabled() {
            return true;
        }

        public boolean isFatalEnabled() {
            return true;
        }

        public boolean isInfoEnabled() {
            return true;
        }

        public boolean isTraceEnabled() {
            return false;
        }

        public boolean isWarnEnabled() {
            return true;
        }

        public void trace(Object arg0) {
        }

        public void trace(Object arg0, Throwable arg1) {
        }

        public void debug(Object arg0, Throwable arg1) {
        }

        public void info(Object arg0, Throwable arg1) {
        }

        public void warn(Object arg0, Throwable arg1) {
        }

        public void error(Object arg0, Throwable arg1) {
        }

        public void fatal(Object arg0) {
        }

        public void fatal(Object arg0, Throwable arg1) {
        }
    }
}

