require "spec"
require "crystal/compiler_rt/shift"
require "./spec_helper"

# Ported from https://github.com/llvm/llvm-project/blob/ce59ccd04023cab3a837da14079ca2dcbfebb70c/compiler-rt/test/builtins/Unit/ashrti3_test.c

it ".__ashrti3" do
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 0).should eq make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 1).should eq make_ti(0xFF6E5D4C3B2A190A, 0xFF6E5D4C3B2A190A)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 2).should eq make_ti(0xFFB72EA61D950C85, 0x7FB72EA61D950C85)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 3).should eq make_ti(0xFFDB97530ECA8642, 0xBFDB97530ECA8642)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 4).should eq make_ti(0xFFEDCBA987654321, 0x5FEDCBA987654321)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 28).should eq make_ti(0xFFFFFFFFEDCBA987, 0x6543215FEDCBA987)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 29).should eq make_ti(0xFFFFFFFFF6E5D4C3, 0xB2A190AFF6E5D4C3)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 30).should eq make_ti(0xFFFFFFFFFB72EA61, 0xD950C857FB72EA61)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 31).should eq make_ti(0xFFFFFFFFFDB97530, 0xECA8642BFDB97530)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 32).should eq make_ti(0xFFFFFFFFFEDCBA98, 0x76543215FEDCBA98)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 33).should eq make_ti(0xFFFFFFFFFF6E5D4C, 0x3B2A190AFF6E5D4C)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 34).should eq make_ti(0xFFFFFFFFFFB72EA6, 0x1D950C857FB72EA6)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 35).should eq make_ti(0xFFFFFFFFFFDB9753, 0x0ECA8642BFDB9753)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 36).should eq make_ti(0xFFFFFFFFFFEDCBA9, 0x876543215FEDCBA9)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 60).should eq make_ti(0xFFFFFFFFFFFFFFFF, 0xEDCBA9876543215F)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 61).should eq make_ti(0xFFFFFFFFFFFFFFFF, 0xF6E5D4C3B2A190AF)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 62).should eq make_ti(0xFFFFFFFFFFFFFFFF, 0xFB72EA61D950C857)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 63).should eq make_ti(0xFFFFFFFFFFFFFFFF, 0xFDB97530ECA8642B)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 64).should eq make_ti(0xFFFFFFFFFFFFFFFF, 0xFEDCBA9876543215)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 65).should eq make_ti(0xFFFFFFFFFFFFFFFF, 0xFF6E5D4C3B2A190A)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 66).should eq make_ti(0xFFFFFFFFFFFFFFFF, 0xFFB72EA61D950C85)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 67).should eq make_ti(0xFFFFFFFFFFFFFFFF, 0xFFDB97530ECA8642)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 68).should eq make_ti(0xFFFFFFFFFFFFFFFF, 0xFFEDCBA987654321)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 92).should eq make_ti(0xFFFFFFFFFFFFFFFF, 0xFFFFFFFFEDCBA987)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 93).should eq make_ti(0xFFFFFFFFFFFFFFFF, 0xFFFFFFFFF6E5D4C3)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 94).should eq make_ti(0xFFFFFFFFFFFFFFFF, 0xFFFFFFFFFB72EA61)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 95).should eq make_ti(0xFFFFFFFFFFFFFFFF, 0xFFFFFFFFFDB97530)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 96).should eq make_ti(0xFFFFFFFFFFFFFFFF, 0xFFFFFFFFFEDCBA98)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 97).should eq make_ti(0xFFFFFFFFFFFFFFFF, 0xFFFFFFFFFF6E5D4C)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 98).should eq make_ti(0xFFFFFFFFFFFFFFFF, 0xFFFFFFFFFFB72EA6)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 99).should eq make_ti(0xFFFFFFFFFFFFFFFF, 0xFFFFFFFFFFDB9753)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 100).should eq make_ti(0xFFFFFFFFFFFFFFFF, 0xFFFFFFFFFFEDCBA9)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 124).should eq make_ti(0xFFFFFFFFFFFFFFFF, 0xFFFFFFFFFFFFFFFF)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 125).should eq make_ti(0xFFFFFFFFFFFFFFFF, 0xFFFFFFFFFFFFFFFF)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 126).should eq make_ti(0xFFFFFFFFFFFFFFFF, 0xFFFFFFFFFFFFFFFF)
  __ashrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 127).should eq make_ti(0xFFFFFFFFFFFFFFFF, 0xFFFFFFFFFFFFFFFF)
end
