/*
 *  Copyright (c) 2012 Shirou Maruyama
 * 
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 * 
 *   1. Redistributions of source code must retain the above Copyright
 *      notice, this list of conditions and the following disclaimer.
 *
 *   2. Redistributions in binary form must reproduce the above Copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *
 *   3. Neither the name of the authors nor the names of its contributors
 *      may be used to endorse or promote products derived from this
 *      software without specific prior written permission.
 */

#include <gtest/gtest.h>
#include <string>
#include <vector>
#include "MultikeyQsort.hpp"

using namespace cpi00;
using namespace std;

TEST(MultikeyQsort, sort) {
  vector<string> strs;
  strs.push_back("piojapjdf");
  strs.push_back("ii;afksdjf;kjg");
  strs.push_back("ii;afkda;ka;dfj");
  strs.push_back("aabakd;laksdfja;");
  strs.push_back("l;awei;gajffasld");
  strs.push_back("さいたま");
  strs.push_back("piojapjdf");
  strs.push_back("ii;afkda;ka;dfj");
  strs.push_back("aabakd;laksdfja;");
  strs.push_back("kdaeiga;dkfa;f");
  strs.push_back("piojapjdf");
  strs.push_back("ぐんま");
  strs.push_back("kdl;asdf;aljeif");
  strs.push_back("ii;afkda;lfkje");
  strs.push_back("aabakd;laksdfja;");
  strs.push_back("ii;afkda;ka;dfj");
  strs.push_back("piojapjdf");
  strs.push_back("せんだい");
  strs.push_back("kdaeiga;akldfja;");
  strs.push_back("piojapjdf");

  MultikeyQsort(strs, 0, strs.size(), 0);
  ASSERT_EQ(true, IsSorted(strs));
}
