/*
 *  Copyright (c) 2012 Shirou Maruyama
 * 
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 * 
 *   1. Redistributions of source code must retain the above Copyright
 *      notice, this list of conditions and the following disclaimer.
 *
 *   2. Redistributions in binary form must reproduce the above Copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *
 *   3. Neither the name of the authors nor the names of its contributors
 *      may be used to endorse or promote products derived from this
 *      software without specific prior written permission.
 */

#include <string>
#include <vector>
#include <sstream>
#include <gtest/gtest.h>
#include "CompPermIdx.hpp"

using namespace cpi00;
using namespace std;

TEST(cpi, test) {
  vector<string> strs;
  strs.push_back("hip");
  strs.push_back("hot");
  strs.push_back("hope");
  strs.push_back("hat");

  CompPermIdx cpi;
  cpi.Build(strs);

  string prefix = "ho";
  vector<string> prefix_ret;
  cpi.PrefixSearch(prefix, prefix_ret);
  ASSERT_EQ(2ULL, prefix_ret.size());
  ASSERT_STREQ("hope", prefix_ret[0].c_str());
  ASSERT_STREQ("hot",  prefix_ret[1].c_str());

  string suffix = "pe";
  vector<string> suffix_ret;
  cpi.SuffixSearch(suffix, suffix_ret);
  ASSERT_EQ(1ULL, suffix_ret.size());
  ASSERT_STREQ("hope", suffix_ret[0].c_str());

  string query1 = "h";
  string query2 = "ot";
  vector<string> prefix_suffix_ret;
  cpi.PrefixSuffixSearch(query1, query2, prefix_suffix_ret);
  ASSERT_EQ(1ULL, prefix_suffix_ret.size());
  ASSERT_STREQ("hot", prefix_suffix_ret[0].c_str());

  string substr = "o";
  vector<string> substr_ret;
  cpi.SubstringSearch(substr, substr_ret);
  ASSERT_EQ(2ULL, substr_ret.size());
  ASSERT_STREQ("hope", substr_ret[0].c_str());
  ASSERT_STREQ("hot",  substr_ret[1].c_str());

  ASSERT_EQ(1ULL, cpi.Rank("hat"));
  ASSERT_EQ(2ULL, cpi.Rank("hip"));
  ASSERT_EQ(3ULL, cpi.Rank("hope"));
  ASSERT_EQ(4ULL, cpi.Rank("hot"));
  ASSERT_EQ(UINT64_MAX, cpi.Rank("hut"));
 
  ASSERT_EQ(true, cpi.Membership("hat"));
  ASSERT_EQ(true, cpi.Membership("hip"));
  ASSERT_EQ(true, cpi.Membership("hope"));
  ASSERT_EQ(true, cpi.Membership("hot"));
  ASSERT_EQ(false, cpi.Membership("hut"));

  string select_str;
  cpi.Select(1ULL, select_str);
  ASSERT_STREQ("hat",  select_str.c_str());
  cpi.Select(2ULL, select_str);  
  ASSERT_STREQ("hip",  select_str.c_str());
  cpi.Select(3ULL, select_str);
  ASSERT_STREQ("hope", select_str.c_str());
  cpi.Select(4ULL, select_str);
  ASSERT_STREQ("hot",  select_str.c_str());

  ostringstream os;
  cpi.Write(os);
  cpi.Clear();
  
  CompPermIdx cpi2;
  istringstream is(os.str());
  cpi2.Read(is);

  string prefix2 = "ho";
  vector<string> prefix2_ret;
  cpi2.PrefixSearch(prefix2, prefix2_ret);
  ASSERT_EQ(2ULL, prefix2_ret.size());
  ASSERT_STREQ("hope", prefix2_ret[0].c_str());
  ASSERT_STREQ("hot",  prefix2_ret[1].c_str());  
}
