% Licensed under the Apache License, Version 2.0 (the "License"); you may not
% use this file except in compliance with the License. You may obtain a copy of
% the License at
%
%   http://www.apache.org/licenses/LICENSE-2.0
%
% Unless required by applicable law or agreed to in writing, software
% distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
% WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
% License for the specific language governing permissions and limitations under
% the License.

-include_lib("eunit/include/eunit.hrl").

-define(BUILDDIR, "/Users/jan/Work/couchdb").
-define(SOURCEDIR, "/Users/jan/Work/couchdb").
-define(CONFIG_CHAIN, [
    filename:join([?BUILDDIR, "etc", "couchdb", "default_dev.ini"]),
    filename:join([?BUILDDIR, "etc", "couchdb", "local_dev.ini"]),
    filename:join([?SOURCEDIR, "test", "couchdb", "eunit.ini"])]).
-define(FIXTURESDIR,
    filename:join([?SOURCEDIR, "test", "couchdb", "fixtures"])).
-define(TEMPDIR,
    filename:join([?BUILDDIR, "test", "couchdb", "temp"])).

-define(tempfile,
    fun() ->
        {A, B, C} = erlang:now(),
        N = node(),
        FileName = lists:flatten(io_lib:format("~p-~p.~p.~p", [N, A, B, C])),
        filename:join([?TEMPDIR, FileName])
    end).
-define(tempdb,
    fun() ->
            Nums = tuple_to_list(erlang:now()),
            Prefix = "eunit-test-db",
            Suffix = lists:concat([integer_to_list(Num) || Num <- Nums]),
            list_to_binary(Prefix ++ "-" ++ Suffix)
    end).
-define(docid,
    fun() ->
        {A, B, C} = erlang:now(),
        lists:flatten(io_lib:format("~p~p~p", [A, B, C]))
    end).

%% Borrowed from https://github.com/richcarl/eunit/blob/master/include/eunit.hrl#L200-L219
%% TODO: get rid of this once R14* is no longer supported
-ifndef(assertNotMatch).
-define(assertNotMatch(Guard, Expr),
    begin
        ((fun () ->
            __V = (Expr),
            case __V of
                Guard -> erlang:error({assertNotMatch_failed,
                    [{module, ?MODULE},
                    {line, ?LINE},
                    {expression, (??Expr)},
                    {pattern, (??Guard)},
                    {value, __V}]});
                _ -> ok
            end
        end)())
    end).
-endif.
