/*
 * Decompiled with CFR 0.152.
 */
package vrml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import netscape.security.ForbiddenTargetException;
import netscape.security.Principal;
import netscape.security.PrivilegeManager;
import netscape.security.Target;
import vrml.CacheObject;
import vrml.PendingObject;

public class NSCosmoClassLoader
extends ClassLoader
implements Runnable {
    static boolean debug;
    static CacheObject cache;
    boolean bInNav = false;
    URL url;
    Class clazz;
    String urlName;
    Thread thread;
    private String className;
    private long javaLangObj;

    public static void clearCaches() {
        if (debug) {
            System.out.println("Clearing caches");
        }
        cache.clearCaches();
    }

    public void debugp(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    public NSCosmoClassLoader() {
        if (debug) {
            System.out.println("NS Cosmo Class Loader constructor-1");
        }
    }

    public synchronized void setUrl(String string) throws MalformedURLException {
        block4: {
            this.urlName = new String(string);
            if (debug) {
                System.out.println("NS Cosmo Class Loader setUrl : " + string);
            }
            try {
                this.url = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                if (!debug) break block4;
                System.out.println("NS Cosmo Class Loader setUrl: new URL threw an exception");
            }
        }
        if (debug) {
            System.out.println("NS Cosmo Class Loader returning - " + string);
        }
    }

    public NSCosmoClassLoader(URL uRL) {
        if (debug) {
            System.out.println("NS Cosmo Class Loader constructor-2");
        }
        this.url = uRL;
    }

    public NSCosmoClassLoader(String string) throws MalformedURLException {
        if (debug) {
            System.out.println("NS Cosmo Class Loader constructor-3");
        }
        this.url = new URL(string);
    }

    public void startLoadClass(String string) {
        if (System.getProperty("java.version").startsWith("1.1")) {
            this.bInNav = false;
            this.className = string;
            this.thread = new Thread((Runnable)this, "loadclass");
            this.thread.start();
            return;
        }
        this.startLoadClassInNav(string);
    }

    public void startLoadClassInNav(String string) {
        this.bInNav = true;
        this.className = string;
        this.thread = Thread.currentThread();
        if (debug) {
            System.out.println("Start Load Class for " + this.className);
        }
        this.run();
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.stop();
        }
        this.thread = null;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        if (thread == this.thread) {
            block6: {
                if (debug) {
                    System.out.println("Run - Start Load Class for " + this.className);
                }
                try {
                    this.clazz = this.loadClass(this.className, true);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!debug) break block6;
                    System.out.println("Could not load class " + this.className);
                }
            }
            if (this.clazz != null) {
                if (debug) {
                    System.out.println("LOADED CLASS for " + this.className);
                }
                this.loadFinished(this.clazz, this.clazz.getName());
                return;
            }
            this.loadFinished(null, null);
        }
    }

    private native void loadFinished(Class var1, String var2);

    private native byte[] fetchURL(String var1) throws IllegalArgumentException;

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Object object;
        int n = 0;
        n = string.indexOf(46);
        if (n != -1) {
            string = string.replace('.', '/');
        }
        this.debugp("Calling getCache for " + string + " on " + Thread.currentThread());
        Class<?> clazz = cache.getCache(string);
        this.debugp("returned from getCache for " + string + " on " + Thread.currentThread() + " c = " + clazz);
        if (clazz == null) {
            this.debugp("Calling checkPendingCache for " + string + " on " + Thread.currentThread());
            object = cache.checkPendingCache(string);
            if (object != null) {
                try {
                    this.debugp("Waiting for " + string + " on " + Thread.currentThread());
                    ((PendingObject)object).doWait(NSCosmoClassLoader.cache.cachePending);
                }
                catch (InterruptedException interruptedException) {
                    this.debugp("InterruptedException while waiting on thread " + Thread.currentThread() + " exception = " + interruptedException);
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    this.debugp("IllegalMonitorStateException when calling wait on " + string + " on object " + object + " on thread " + Thread.currentThread() + " exception = " + illegalMonitorStateException);
                }
                this.debugp("End of wait, calling getCache for " + string + " on " + Thread.currentThread());
                clazz = cache.getCache(string);
            }
        }
        if (clazz == null) {
            block24: {
                try {
                    this.debugp("Calling findSystemClass for " + string + " on " + Thread.currentThread());
                    clazz = this.findSystemClass(string);
                }
                catch (Throwable throwable) {
                    this.debugp("NS Loading : " + string + " find system class threw exception.");
                }
                if (clazz == null) {
                    try {
                        this.debugp("Checking the PrivilegeManager");
                        try {
                            object = null;
                            Principal principal = null;
                            PrivilegeManager privilegeManager = null;
                            privilegeManager = PrivilegeManager.getPrivilegeManager();
                            principal = PrivilegeManager.getSystemPrincipal();
                            object = Target.findTarget((String)"UniversalConnect", (Principal)principal);
                            privilegeManager.enablePrivilege((Target)object);
                            object = Target.findTarget((String)"UniversalFileRead", (Principal)principal);
                            privilegeManager.enablePrivilege((Target)object);
                            object = Target.findTarget((String)"UniversalThreadAccess", (Principal)principal);
                            privilegeManager.enablePrivilege((Target)object);
                        }
                        catch (ForbiddenTargetException forbiddenTargetException) {
                            this.debugp("NS Privilege request Failed !");
                        }
                        catch (Exception exception) {
                            this.debugp("NS Unknown exception while enabling privileges.");
                        }
                        this.debugp("Calling readClassBytes for " + string + " on " + Thread.currentThread());
                        object = null;
                        if (this.bInNav) {
                            try {
                                this.debugp("Calling fetchURL for " + string + " on " + Thread.currentThread());
                                object = this.fetchURL(String.valueOf(string) + ".class");
                                this.debugp("Returned from fetchURL for " + string + " on " + Thread.currentThread());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                this.debugp("Could not get the class IOException " + illegalArgumentException);
                                return null;
                            }
                        }
                        try {
                            object = this.readClassBytes(string);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.debugp("readClassBytes threw an exception " + illegalArgumentException);
                            return null;
                        }
                        if (object == null) {
                            return null;
                        }
                        this.debugp("Returned from readClassBytes length = " + ((Object)object).length);
                        clazz = this.defineClass(null, (byte[])object, 0, ((Object)object).length);
                        if (clazz == null) {
                            this.debugp("Define class returned null");
                            return null;
                        }
                        this.debugp("Defined class");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (clazz != null) break block24;
                        this.debugp("Trying to load class threw an exception " + classNotFoundException);
                        return null;
                    }
                }
            }
            this.debugp("Calling putCache for " + string + " on " + Thread.currentThread());
            cache.putCache(string, clazz);
        } else {
            this.debugp("GOT FROM CACHE...:-)) class " + clazz + " " + Thread.currentThread());
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        this.debugp("Returning class -" + string + "- from loadClass" + Thread.currentThread());
        return clazz;
    }

    private byte[] readClassBytes(String string) throws ClassNotFoundException {
        if (debug) {
            System.out.println("In readClassBytes");
        }
        try {
            int n;
            URL uRL = new URL(this.url, String.valueOf(string) + ".class");
            if (debug) {
                System.out.println("NS reading class : " + string + "created URL.");
            }
            URLConnection uRLConnection = uRL.openConnection();
            if (debug) {
                System.out.println("NS reading class : " + string + "opened connection.");
            }
            uRLConnection.connect();
            if (debug) {
                System.out.println("NS reading class : " + string + "connected.");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InputStream inputStream = uRLConnection.getInputStream();
            byte[] byArray = new byte[2048];
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (MalformedURLException malformedURLException) {
            if (debug) {
                System.out.println("MalformedURLException");
            }
            throw new ClassNotFoundException("Bad class name: " + string);
        }
        catch (IOException iOException) {
            if (debug) {
                System.out.println("IOException");
            }
            throw new ClassNotFoundException("Couldn't read class " + string);
        }
    }

    static {
        cache = new CacheObject();
    }
}

