from distutils.core import setup
import os, glob

version = '1.0.0'

data_files = []
doc_root = 'share/doc/consodoc-%s' % version
for root, dirs, files in os.walk('doc'):
  to_dir    = os.path.join(doc_root, root[4:])
  doc_files = [os.path.join(root, file) for file in files]
  data_files.append((to_dir, doc_files))
data_files.append((doc_root, ['license.txt']))

setup(
  name = 'consodoc',
  version = version ,
  description = 'XML to beautiful documents',
  long_description = '''Automatically generated documentation isn't necessary ugly. The only excuse is the current state of the art with tools that suck. Consodoc is probably the only publishing tool that concentrates on the beauty of the result.''',
    author="Datahansa, Oleg Parashchenko",
    author_email="olpa@ http://consodoc.com/",
    license = 'Dual, commercial and GPL with add-on',
    url = 'http://consodoc.com/',
    packages = ['Consodoc', 'Consodoc/Builders'],
    scripts = ['bin/cdoc'],
    data_files = data_files
  )

