<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<!-- -->

<xsl:output indent="no" />

<xsl:template match="article">
  <TeXML>
    <xsl:call-template name="latex-header" />
    <env name="document">
      <xsl:apply-templates select="*" />
    </env>
  </TeXML>
</xsl:template>

<xsl:template name="latex-header">
<TeXML escape="0">
\documentclass{guide}
\usepackage[T1]{fontenc}
\usepackage{hyperref}
</TeXML>
</xsl:template>

<xsl:template match="*">
  <xsl:message>Unknown element <xsl:value-of select="name()" /></xsl:message>
  <env name="para">
    <cmd name="textbf">
      <parm>???: <xsl:value-of select="name()" /></parm>
    </cmd>
  </env>
</xsl:template>

<xsl:template match="article/title">
  <env name="mytitle">
    <xsl:apply-templates/>
  </env>
  <cmd name="mytableofcontents" />
</xsl:template>

<xsl:template match="para">
  <env name="para">
    <xsl:apply-templates />
  </env>
</xsl:template>

<xsl:template match="title">
  <xsl:apply-templates />
</xsl:template>

<xsl:template match="section">
  <xsl:variable name="sectlevel">
    <xsl:choose>
      <xsl:when test="count(ancestor::section)=0">section</xsl:when>
      <xsl:when test="count(ancestor::section)=1">subsection</xsl:when>
      <xsl:when test="count(ancestor::section)=2">subsubsection</xsl:when>
      <xsl:otherwise>
        <xsl:message terminate="yes">Too deeply nested 'section'</xsl:message>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <cmd name="{$sectlevel}">
    <parm>
      <xsl:choose>
        <xsl:when test="../parent::section[@id='license']"><xsl:value-of select="substring-after(title,' ')"/></xsl:when>
        <xsl:otherwise><xsl:apply-templates select="title"/></xsl:otherwise>
      </xsl:choose>
    </parm>
  </cmd>
  <xsl:apply-templates select="*[not(self::title)]" />
</xsl:template>

<xsl:template match="list">
  <env name="itemize">
    <xsl:apply-templates />
  </env>
</xsl:template>

<xsl:template match="list-item">
  <cmd name="item" gr="0" />
  <xsl:apply-templates />
</xsl:template>

<xsl:template match="a">
  <cmd name="href">
    <parm><xsl:value-of select="@href" /></parm>
    <parm><xsl:apply-templates /></parm>
  </cmd>
</xsl:template>

<xsl:template match="b">
  <cmd name="textbf">
    <parm><xsl:apply-templates /></parm>
  </cmd>
</xsl:template>

<xsl:template match="tt | variabledefinition | variableusage">
  <cmd name="texttt">
    <parm><xsl:apply-templates /></parm>
  </cmd>
</xsl:template>

<xsl:template match="todo">
  <cmd name="textbf">
    <parm><xsl:apply-templates /></parm>
  </cmd>
</xsl:template>

<xsl:template match="br">
  <ctrl ch="\" />
  <cmd name="hbox"><parm></parm></cmd>
</xsl:template>

<xsl:template match="literallayout">
  <TeXML emptylines="1" ws="1">
    <env name="literallayout" nl2="0" nl3="0">
      <xsl:apply-templates />
    </env>
  </TeXML>
</xsl:template>

<xsl:template match="quote">
  <xsl:text>&#8220;</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>&#8221;</xsl:text>
</xsl:template>

</xsl:stylesheet>
