# Consodoc Publishing Server
# Copyright (c) Oleg Parashchenko, <olpa consodoc com>
import sys, os, re, string
import SCons.Action, SCons.Script, SCons.SConsign

#
# When a Python function is changed, SCons signals "the contents
# of the build action changed" and re-builds the target. It breaks
# all the functional tests, so let's use customized signature
# when in the test mode.
#
def change_function_signature():
  #
  # Customized signature calculation: if "f" is function, return
  # "str(f)" with masked pointers plus something I don't know.
  #
  re_drop_pointer = re.compile('0x[0123456789ABCDEFabcdef]{8}')
  def get_contents(self, target, source, env):
    s = str(self.execfunction)
    s = re.sub(re_drop_pointer, '0xXXXXXXXX', s)
    s = s + env.subst(string.join(map(lambda v: '${'+v+'}', self.varlist)))
    return s
  #
  # Setup the function
  #
  SCons.Action.FunctionAction.get_contents = get_contents

#
# Getting build and default targets
# *_TARGETS exist in 0.96.90, but don't exist in 0.96.1
#
def get_build_targets():
  try:
    return SCons.Script.BUILD_TARGETS
  except AttributeError:
    return SCons.Script.SConscript.DefaultTargets

def get_default_targets():
  try:
    return SCons.Script.DEFAULT_TARGETS
  except:
    return SCons.Script.SConscript.BuildTargets

#
# Creating an enrironment
#
def create_environment(*ls, **kw):
  # First try the 0.96.1 and 0.96.90 version, then the branch-core one
  try:
    return SCons.Script.SConscript.SConsEnvironment(*ls, **kw)
  except AttributeError:
    return SCons.Script.Environment(*ls, **kw)

#
# Work correctly under different versions of SCons
#
def tune_scons():
  #
  # Detect if Consodoc is run by functional testing process
  #
  under_test = os.getenv('cdoc_testtest_sconscript')
  if under_test:
    change_function_signature()
    SCons.SConsign.ForDirectory = SCons.SConsign.DirFile
