# Consodoc Publishing Server
# Copyright (c) Oleg Parashchenko, <olpa consodoc com>
import os.path
import UserDict
import Builders.preprocess
import Builders.texml
import Builders.pretex
import Builders.patch
import Builders.tmpout
import Builders.out
import SCons.Environment
import SCons.Errors
import Consodoc.compat

ConsodocError = SCons.Errors.BuildError
Consodoc.compat.tune_scons()

#
# Consodoc environment
#
class Vars(UserDict.UserDict):

  #
  # Setup default
  #
  def __init__(self, *ls, **kw):
    UserDict.UserDict.__init__(self)
    
    #
    # Directories
    #
    self['indir']      = 'in'
    self['outdir']     = 'out'
    self['tmpdir']     = 'tmp'
    self['supportdir'] = 'support'

    #
    # Input files, mandatory
    #
    self['in_file']    = 'in/no-such-file.xml'
    self['in_xslt']    = 'support/no-such-file.xsl'
    self['in_patch']   = None

    #
    # Program locations
    #
    self['xmllint']    = 'xmllint'
    self['xsltproc']   = 'xsltproc'
    self['texml']      = 'texml'
    self['diff']       = 'diff'
    self['patch']      = 'patch'
    self['dvilatex']   = 'latex'
    self['pdflatex']   = 'pdflatex'
    
    # Override defaults with the user-defined data
    for k in kw:
      self[k] = kw[k]

    # Set further defaults
    if None == self.get('in_patch', None):
      basename = os.path.splitext(self['in_file'])[0]
      self['in_patch'] = basename + '.patch'

#
# Define the build process. Return the environment.
#
def default_process(*ls, **kw):
  vars = Vars(**kw)
  Builders.preprocess.updateVars(vars)
  Builders.texml.updateVars(vars)
  Builders.pretex.updateVars(vars)
  Builders.patch.updateVars(vars)
  Builders.tmpout.updateVars(vars)
  Builders.out.updateVars(vars)
  env = Consodoc.compat.create_environment(CONSODOC = vars)
  Builders.preprocess.updateEnvironment(env)
  Builders.texml.updateEnvironment(env)
  Builders.pretex.updateEnvironment(env)
  Builders.patch.updateEnvironment(env)
  Builders.tmpout.updateEnvironment(env)
  Builders.out.updateEnvironment(env)
  return env
