# Consodoc Publishing Server
# Copyright (c) Oleg Parashchenko, <olpa consodoc com>
import os.path
import SCons.Builder

def updateVars(vars):
  if None == vars.get('texml_in', None):
    vars['texml_in'] = vars['pp_out']
  if None == vars.get('texml_out', None):
    basename = os.path.basename(vars['texml_in'])
    basename = os.path.splitext(basename)[0]
    vars['texml_out'] = os.path.join(vars['tmpdir'], basename + '.texml')
  if None == vars.get('texml_xslt', None):
    vars['texml_xslt'] = vars['in_xslt']

def updateEnvironment(env):
  vars     = env['CONSODOC']
  exec_str = vars['xsltproc'] + ' --nonet -o $TARGET '
  params   = vars.get('texml_params', None)
  if params:
    keys     = params.keys()
    keys.sort()
    for k in keys:
      exec_str = exec_str + "--stringparam %s '%s' " % (k, params[k])
  exec_str = exec_str + vars['texml_xslt'] + ' $SOURCE'
  env['BUILDERS']['cdoc_texml']  = SCons.Builder.Builder(action = exec_str)
  out  = vars['texml_out']
  env.cdoc_texml(out, vars['texml_in'])
  env.Depends(out, vars['texml_xslt'])
  env.Alias('texml', out)
