# Consodoc Publishing Server
# Copyright (c) Oleg Parashchenko, <olpa consodoc com>
import os.path
import string
import SCons.Builder

def updateVars(vars):
  if None == vars.get('pretex_in', None):
    vars['pretex_in'] = vars['texml_out']
  if not vars.get('pretex_out'):
    basename = os.path.basename(vars['pretex_in'])
    basename = os.path.splitext(basename)[0]
    vars['pretex_out'] = os.path.join(vars['tmpdir'], basename + '.tex.orig')

def updateEnvironment(env):
  vars = env['CONSODOC']
  params = vars.get('pretex_params', None)
  if params:
    params = string.join(params, ' ')
    params = ' ' + params
  else:
    params = ''
  env['BUILDERS']['cdoc_pretex'] = SCons.Builder.Builder(action = vars['texml'] + params + ' $SOURCE $TARGET')
  out  = vars['pretex_out']
  env.cdoc_pretex(out, vars['pretex_in'])
  env.Alias('pretex', out)
