# Consodoc Publishing Server
# Copyright (c) Oleg Parashchenko, <olpa consodoc com>
import os.path
import SCons.Builder

def updateVars(vars):
  if None == vars.get('pp_in', None):
    vars['pp_in'] = vars['in_file']
  if None == vars.get('pp_out', None):
    basename = os.path.basename(vars['pp_in'])
    vars['pp_out'] = os.path.join(vars['tmpdir'], basename)

def updateEnvironment(env):
  vars = env['CONSODOC']
  env['BUILDERS']['cdoc_preprocess'] = SCons.Builder.Builder(action = vars['xmllint'] + ' --noent --xinclude --nonet -o $TARGET $SOURCE')
  out  = vars['pp_out']
  env.cdoc_preprocess(out, vars['pp_in'])
  env.Alias('pp', out)
