# Consodoc Publishing Server
# Copyright (c) Oleg Parashchenko, <olpa consodoc com>
import os, os.path, shutil
import SCons.Builder, SCons.Script
import Consodoc, Consodoc.compat

def _updateVars(vars, xxx):
  key_in  = xxx + '_in'
  key_out = xxx + '_out'
  if None == vars.get(key_in, None):
    vars[key_in] = vars['tmp%s_out' % xxx]
  if None == vars.get(key_out, None):
    basename = os.path.basename(vars[key_in])
    vars[key_out] = os.path.join(vars['outdir'], basename)
  
def updateVars(vars):
  _updateVars(vars, 'pdf')
  _updateVars(vars, 'dvi')

def copy_file(target, source, env):
  vars = env['CONSODOC']
  if os.path.isfile(vars['patch_error']):
    raise Consodoc.ConsodocError(target, vars['patch_error_message'])
  shutil.copyfile(str(source[0]), str(target[0]))

def updateEnvironment(env):
  vars = env['CONSODOC']
  env['BUILDERS']['cdoc_copy_pdf'] = SCons.Builder.Builder(action = copy_file)
  env['BUILDERS']['cdoc_copy_dvi'] = SCons.Builder.Builder(action = copy_file)
  env.cdoc_copy_pdf(vars['pdf_out'], vars['pdf_in'])
  env.cdoc_copy_dvi(vars['dvi_out'], vars['dvi_in'])
  pdf = env.Alias('pdf', vars['pdf_out'])
  env.Alias('dvi', vars['dvi_out'])
  # On cleaning, delete temporary and output folders
  env.Clean(vars['pdf_out'], vars['tmpdir'])
  env.Clean(vars['pdf_out'], vars['outdir'])
  env.Clean(vars['dvi_out'], vars['tmpdir'])
  env.Clean(vars['dvi_out'], vars['outdir'])
  # Set the target 'pdf' to be default
  if [] == Consodoc.compat.get_default_targets():
    env.Default(pdf)
