/*
 *  Copyright 2002 Adrian Thurston <thurston@complang.org>
 */

#ifndef _AAPL_SBSTSET_H
#define _AAPL_SBSTSET_H

/**
 * \addtogroup bst 
 * @{
 */

/** 
 * \class SBstSet
 * \brief Copy-on-write binary search table for types that are the key.
 *
 * This is a set style binary search table that employs the copy-on-write
 * mechanism for storing table data. BstSet is suitable for types that
 * comprise the entire key. Rather than look into the element to retrieve the
 * key, the element is the key.  A class that contains a comparison routine
 * for the key must be given.
 */

/*@}*/

#include "compare.h"
#include "svector.h"

#define BST_TEMPL_DECLARE class Key, class Compare = CmpOrd<Key>, \
		class Resize = ResizeExpn
#define BST_TEMPL_DEF class Key, class Compare, class Resize
#define BST_TEMPL_USE Key, Compare, Resize
#define GET_KEY(el) (el)
#define BstTable SBstSet
#define Vector SVector
#define Table STable
#define Element Key
#define BSTSET
#define SHARED_BST

#include "bstcommon.h"

#undef BST_TEMPL_DECLARE
#undef BST_TEMPL_DEF
#undef BST_TEMPL_USE
#undef GET_KEY
#undef BstTable
#undef Vector
#undef Table
#undef Element
#undef BSTSET
#undef SHARED_BST

/**
 * \fn SBstSet::insert(const Key &key, Key **lastFound)
 * \brief Insert the given key.
 *
 * If the given key does not already exist in the table then it is inserted.
 * The key's copy constructor is used to place the item in the table. If
 * lastFound is given, it is set to the new entry created. If the insert fails
 * then lastFound is set to the existing key of the same value.
 *
 * \returns The new element created upon success, null upon failure.
 */

/**
 * \fn SBstSet::insertMulti(const Key &key)
 * \brief Insert the given key even if it exists already.
 *
 * If the key exists already then it is placed next to some other key of the
 * same value. InsertMulti cannot fail. The key's copy constructor is used to
 * place the item in the table.
 *
 * \returns The new element created.
 */

#endif /* _AAPL_SBSTSET_H */
