/*
  COnfigurator for Gnome
  Copyright (C) 2004 Mads Villadsen <maxximum@krakoa.dk>
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <glib.h>
#include <gnome.h>
#include <glade/glade.h>
#include "setup-metacity.h"
#include "gconf-convenience.h"

extern GString *GLADE_FILE;
extern GladeXML *main_window_xml;
gchar *other_button_layout = "";

/*
Standard
WindowMaker
OSX
Amiga
Other
*/

gchar *int2layout (gint i)
{
  gchar *return_val;

  switch (i)
    {
    case 0:
      return_val = "menu:minimize,maximize,close";
      break;
    case 1:
      return_val = "minimize:close";
      break;
    case 2:
      return_val = "close,maximize,minimize:";
      break;
    case 3: 
      return_val = "close:minimize,maximize,menu";
      break;
    case 4: 
      return_val = other_button_layout;
      break;
    default:
      return_val = "";
      break;
    }
    
  return return_val;
}

gint layout2int (gchar *layout)
{
  gint return_val;

  if (strcmp (layout, "menu:minimize,maximize,close") == 0)
    {
      return_val = 0;
    }
  else if (strcmp (layout, "minimize:close") == 0)
    {
      return_val = 1;
    }
  else if (strcmp (layout, "close,maximize,minimize:") == 0)
    {
      return_val = 2;
    }
  else if (strcmp (layout, "close:minimize,maximize,menu") == 0)
    {
      return_val = 3;
    }
  else 
    {
      other_button_layout = g_strdup (layout);
      return_val = 4;
    }

  return return_val;
}

void button_layout_combo_box_config_notify (GConfClient *client,
					   guint        cnxn_id,
					   GConfEntry  *entry,
					   gpointer     user_data)
{
  GtkWidget *w = user_data;
  gchar *s = NULL;

  s = gconf_value_get_string (gconf_entry_get_value (entry));
 
  gtk_combo_box_set_active (GTK_COMBO_BOX(w), layout2int (s));
}

void button_layout_combo_box_changed_callback (GtkWidget* w, gpointer user_data)
{
  GConfClient *client;
  gint i;
  gchar *layout = NULL;

  client = GCONF_CLIENT(g_object_get_data (G_OBJECT (w), "client"));
  i = gtk_combo_box_get_active (GTK_COMBO_BOX(w));

  layout = int2layout (i);
 
  // only set the layout if it is one that we support - ie. one that int2layout understands
  if (strcmp (layout, "") != 0) {
    gconf_client_set_string (client, (gchar *) user_data, layout, NULL);
  }
}

void setup_metacity ()
{
  GtkWidget *w;
  gchar *gconf_key;

  gconf_key = "/apps/metacity/general/button_layout";
  w = glade_xml_get_widget (main_window_xml, "metacity_button_layout_combobox");

  if (!gconf_key_is_string (gconf_key))
    {
      gtk_widget_set_sensitive (w, FALSE);
    }
  else
    {
      setup_setting_widget (w, gconf_key, button_layout_combo_box_config_notify);
      g_signal_connect (G_OBJECT (w), "changed",
			G_CALLBACK (button_layout_combo_box_changed_callback),
			gconf_key);
      /* Set correct initial value of widget */
      gtk_combo_box_set_active (GTK_COMBO_BOX(w), layout2int (gconf_key_get_string (gconf_key)));
    }

  gconf_key = "/apps/metacity/general/reduced_resources";
  w = glade_xml_get_widget (main_window_xml, "metacity_reduced_ressources_checkbutton");

  if (!gconf_key_is_bool (gconf_key))
    {
      gtk_widget_set_sensitive (w, FALSE);
    }
  else
    {
      setup_setting_widget (w, gconf_key, bool_config_notify);
      g_signal_connect (G_OBJECT (w), "toggled",
			G_CALLBACK (entry_bool_toggled_callback),
			gconf_key);
      /* Set correct initial value of widget */
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), gconf_key_get_bool (gconf_key));
    }

}
