/*
  COnfigurator for Gnome
  Copyright (C) 2004 Mads Villadsen <maxximum@krakoa.dk>
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <glib.h>
#include <gnome.h>
#include <glade/glade.h>
#include "setup-epiphany.h"
#include "gconf-convenience.h"

extern GString *GLADE_FILE;
extern GladeXML *main_window_xml;

void setup_epiphany ()
{
  GtkWidget *w;
  gchar *gconf_key;

  gconf_key = "/apps/epiphany/general/always_show_tabs_bar";
  w = glade_xml_get_widget (main_window_xml, "epiphany_always_show_tab_bar_checkbutton");

  if (!gconf_key_is_bool (gconf_key))
    {
      gtk_widget_set_sensitive (w, FALSE);
    }
  else
    {
      setup_setting_widget (w, gconf_key, bool_config_notify);
      g_signal_connect (G_OBJECT (w), "toggled",
			G_CALLBACK (entry_bool_toggled_callback),
			gconf_key);
      /* Set correct initial value of widget */
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), gconf_key_get_bool (gconf_key));
    }
}
