/*
  COnfigurator for Gnome
  Copyright (C) 2002 Mads Villadsen <maxximum@krakoa.dk>
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib.h>
#include <gnome.h>
#include <glade/glade.h>
#include "callbacks.h"
#include "setup-widgets.h"
#include "gtkrc-util.h"

GladeXML *main_window_xml;
GString *GLADE_FILE;

int main (int argc, char *argv[])
{
  GtkWidget *main_window;
  FILE *fp;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
                      argc, argv,
                      GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR,
                      NULL);
  glade_gnome_init();

  GLADE_FILE = g_string_new (NULL);
  g_string_sprintf (GLADE_FILE, "%s/%s", COG_GLADEDIR, "cog.glade");


  fp = fopen (GLADE_FILE->str, "r");
  if (fp == NULL)
    {
      /* The glade file wasn't found - try in .. (for ease of development/testing only) */

      g_string_sprintf (GLADE_FILE, "%s/%s", "..", "cog.glade");
    }

  main_window_xml = glade_xml_new (GLADE_FILE->str, "main_window", NULL);
  if (main_window_xml == NULL)
    {
      g_warning ("Unable to load the interface.");
      return 1;
    }

  /* glade_xml_signal_autoconnect (main_window_xml); */
  glade_xml_signal_connect (main_window_xml, "on_close_button_clicked", on_close_button_clicked);
  glade_xml_signal_connect (main_window_xml, "on_about_button_clicked", on_about_button_clicked);
  glade_xml_signal_connect (main_window_xml, "on_main_window_delete_event", on_main_window_delete_event);

  /* Hook up all the settings widgets to GConf */
  setup_widgets ();

  gtk_main ();

  /* Control returns here when gtk_main_quit() is called, but not when
   * gtk_exit is used. */

  return 0;
}
