/*
  COnfigurator for Gnome (COG)
  Copyright (C) 2002 Mads Villadsen <maxximum@krakoa.dk>
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <gconf/gconf-client.h>
#include <gnome.h>
#include "debug.h"

const gchar *gconf_key_get_short_desc (gchar *key);
const gchar *gconf_key_get_long_desc (gchar *key);

gboolean gconf_key_get_bool (gchar *key);
gint gconf_key_get_int (gchar *key);
gchar *gconf_key_get_string (gchar *key);

gboolean gconf_key_is_writable (gchar *key);
gboolean gconf_key_is_valid (gchar *key);

/* gboolean gconf_key_is_float (gchar *key); */
gboolean gconf_key_is_int (gchar *key);
gboolean gconf_key_is_string (gchar *key);
gboolean gconf_key_is_bool (gchar *key);
/* gboolean gconf_key_is_list (gchar *key); */
/* gboolean gconf_key_is_pair (gchar *key); */
/* gboolean gconf_key_is_schema (gchar *key); */
/* gboolean gconf_key_is_invalid (gchar *key); */

void entry_bool_toggled_callback(GtkWidget *w, gpointer user_data);
void bool_config_notify (GConfClient *client,
			 guint        cnxn_id,
			 GConfEntry  *entry,
			 gpointer     user_data);
void entry_spin_button_value_changed_callback (GtkWidget* w, gpointer user_data);
void int_spin_button_config_notify (GConfClient *client,
				    guint        cnxn_id,
				    GConfEntry  *entry,
				    gpointer     user_data);
