%define ver      0.8.0
%define rel      1
%define prefix   /usr

Summary: GNOME Configurator
Name: cog
Version: %ver
Release: %rel
Copyright: GPL
Group: Applications
Source: http://www.krakoa.dk/progs/cog/cog-%{ver}.tar.gz
BuildRoot: /tmp/cog-root
URL: http://www.krakoa.dk/linux-software.html
Docdir: %{prefix}/doc

Requires: gtk2 >= 2.4.0
Requires: glib2 >= 2.4.0
Requires: GConf2 >= 2.6.0
Requires: libglade2 >= 2.3.0

%description
GNOME Configurator

Edit advanced GNOME settings in an easy way

%prep
%setup

%build
# Needed for snapshot releases.
if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --prefix=%prefix --localstatedir=/var/lib
else
  CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix --localstatedir=/var/lib
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} \
	localstatedir=$RPM_BUILD_ROOT/var/lib install

strip $RPM_BUILD_ROOT%{prefix}/bin/* || :

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)

%doc AUTHORS COPYING NEWS README TODO
%{prefix}/bin/*
%{prefix}/share/cog/%{ver}/*
%{prefix}/share/pixmaps/*
%{prefix}/share/applications/*
%{prefix}/share/locale/*/*/cog.*
