/// \file pdfglyphnames.inc Definition of glyph names.

typedef struct _wxGlyphDesc
{
  int           unicode;
  const wxChar* glyphname;
} wxGlyphDesc;

static const wxGlyphDesc gs_glyphName2UnicodeTable[] =
{
  { 0x0041, wxT("A") },
  { 0x00C6, wxT("AE") },
  { 0x01FC, wxT("AEacute") },
  { 0x01E2, wxT("AEmacron") },
  { 0xF7E6, wxT("AEsmall") },
  { 0x00C1, wxT("Aacute") },
  { 0xF7E1, wxT("Aacutesmall") },
  { 0x0102, wxT("Abreve") },
  { 0x1EAE, wxT("Abreveacute") },
  { 0x04D0, wxT("Abrevecyrillic") },
  { 0x1EB6, wxT("Abrevedotbelow") },
  { 0x1EB0, wxT("Abrevegrave") },
  { 0x1EB2, wxT("Abrevehookabove") },
  { 0x1EB4, wxT("Abrevetilde") },
  { 0x01CD, wxT("Acaron") },
  { 0x24B6, wxT("Acircle") },
  { 0x00C2, wxT("Acircumflex") },
  { 0x1EA4, wxT("Acircumflexacute") },
  { 0x1EAC, wxT("Acircumflexdotbelow") },
  { 0x1EA6, wxT("Acircumflexgrave") },
  { 0x1EA8, wxT("Acircumflexhookabove") },
  { 0xF7E2, wxT("Acircumflexsmall") },
  { 0x1EAA, wxT("Acircumflextilde") },
  { 0xF6C9, wxT("Acute") },
  { 0xF7B4, wxT("Acutesmall") },
  { 0x0410, wxT("Acyrillic") },
  { 0x0200, wxT("Adblgrave") },
  { 0x00C4, wxT("Adieresis") },
  { 0x04D2, wxT("Adieresiscyrillic") },
  { 0x01DE, wxT("Adieresismacron") },
  { 0xF7E4, wxT("Adieresissmall") },
  { 0x1EA0, wxT("Adotbelow") },
  { 0x01E0, wxT("Adotmacron") },
  { 0x00C0, wxT("Agrave") },
  { 0xF7E0, wxT("Agravesmall") },
  { 0x1EA2, wxT("Ahookabove") },
  { 0x04D4, wxT("Aiecyrillic") },
  { 0x0202, wxT("Ainvertedbreve") },
  { 0x0391, wxT("Alpha") },
  { 0x0386, wxT("Alphatonos") },
  { 0x0100, wxT("Amacron") },
  { 0xFF21, wxT("Amonospace") },
  { 0x0104, wxT("Aogonek") },
  { 0x00C5, wxT("Aring") },
  { 0x01FA, wxT("Aringacute") },
  { 0x1E00, wxT("Aringbelow") },
  { 0xF7E5, wxT("Aringsmall") },
  { 0xF761, wxT("Asmall") },
  { 0x00C3, wxT("Atilde") },
  { 0xF7E3, wxT("Atildesmall") },
  { 0x0531, wxT("Aybarmenian") },
  { 0x0042, wxT("B") },
  { 0x24B7, wxT("Bcircle") },
  { 0x1E02, wxT("Bdotaccent") },
  { 0x1E04, wxT("Bdotbelow") },
  { 0x0411, wxT("Becyrillic") },
  { 0x0532, wxT("Benarmenian") },
  { 0x0392, wxT("Beta") },
  { 0x0181, wxT("Bhook") },
  { 0x1E06, wxT("Blinebelow") },
  { 0xFF22, wxT("Bmonospace") },
  { 0xF6F4, wxT("Brevesmall") },
  { 0xF762, wxT("Bsmall") },
  { 0x0182, wxT("Btopbar") },
  { 0x0043, wxT("C") },
  { 0x053E, wxT("Caarmenian") },
  { 0x0106, wxT("Cacute") },
  { 0xF6CA, wxT("Caron") },
  { 0xF6F5, wxT("Caronsmall") },
  { 0x010C, wxT("Ccaron") },
  { 0x00C7, wxT("Ccedilla") },
  { 0x1E08, wxT("Ccedillaacute") },
  { 0xF7E7, wxT("Ccedillasmall") },
  { 0x24B8, wxT("Ccircle") },
  { 0x0108, wxT("Ccircumflex") },
  { 0x010A, wxT("Cdot") },
  { 0x010A, wxT("Cdotaccent") },
  { 0xF7B8, wxT("Cedillasmall") },
  { 0x0549, wxT("Chaarmenian") },
  { 0x04BC, wxT("Cheabkhasiancyrillic") },
  { 0x0427, wxT("Checyrillic") },
  { 0x04BE, wxT("Chedescenderabkhasiancyrillic") },
  { 0x04B6, wxT("Chedescendercyrillic") },
  { 0x04F4, wxT("Chedieresiscyrillic") },
  { 0x0543, wxT("Cheharmenian") },
  { 0x04CB, wxT("Chekhakassiancyrillic") },
  { 0x04B8, wxT("Cheverticalstrokecyrillic") },
  { 0x03A7, wxT("Chi") },
  { 0x0187, wxT("Chook") },
  { 0xF6F6, wxT("Circumflexsmall") },
  { 0xFF23, wxT("Cmonospace") },
  { 0x0551, wxT("Coarmenian") },
  { 0xF763, wxT("Csmall") },
  { 0x0044, wxT("D") },
  { 0x01F1, wxT("DZ") },
  { 0x01C4, wxT("DZcaron") },
  { 0x0534, wxT("Daarmenian") },
  { 0x0189, wxT("Dafrican") },
  { 0x010E, wxT("Dcaron") },
  { 0x1E10, wxT("Dcedilla") },
  { 0x24B9, wxT("Dcircle") },
  { 0x1E12, wxT("Dcircumflexbelow") },
  { 0x0110, wxT("Dcroat") },
  { 0x1E0A, wxT("Ddotaccent") },
  { 0x1E0C, wxT("Ddotbelow") },
  { 0x0414, wxT("Decyrillic") },
  { 0x03EE, wxT("Deicoptic") },
  { 0x0394, wxT("Delta") },
  { 0x0394, wxT("Deltagreek") },
  { 0x018A, wxT("Dhook") },
  { 0xF6CB, wxT("Dieresis") },
  { 0xF6CC, wxT("DieresisAcute") },
  { 0xF6CD, wxT("DieresisGrave") },
  { 0xF7A8, wxT("Dieresissmall") },
  { 0x03DC, wxT("Digammagreek") },
  { 0x0402, wxT("Djecyrillic") },
  { 0x1E0E, wxT("Dlinebelow") },
  { 0xFF24, wxT("Dmonospace") },
  { 0xF6F7, wxT("Dotaccentsmall") },
  { 0x0110, wxT("Dslash") },
  { 0xF764, wxT("Dsmall") },
  { 0x018B, wxT("Dtopbar") },
  { 0x01F2, wxT("Dz") },
  { 0x01C5, wxT("Dzcaron") },
  { 0x04E0, wxT("Dzeabkhasiancyrillic") },
  { 0x0405, wxT("Dzecyrillic") },
  { 0x040F, wxT("Dzhecyrillic") },
  { 0x0045, wxT("E") },
  { 0x00C9, wxT("Eacute") },
  { 0xF7E9, wxT("Eacutesmall") },
  { 0x0114, wxT("Ebreve") },
  { 0x011A, wxT("Ecaron") },
  { 0x1E1C, wxT("Ecedillabreve") },
  { 0x0535, wxT("Echarmenian") },
  { 0x24BA, wxT("Ecircle") },
  { 0x00CA, wxT("Ecircumflex") },
  { 0x1EBE, wxT("Ecircumflexacute") },
  { 0x1E18, wxT("Ecircumflexbelow") },
  { 0x1EC6, wxT("Ecircumflexdotbelow") },
  { 0x1EC0, wxT("Ecircumflexgrave") },
  { 0x1EC2, wxT("Ecircumflexhookabove") },
  { 0xF7EA, wxT("Ecircumflexsmall") },
  { 0x1EC4, wxT("Ecircumflextilde") },
  { 0x0404, wxT("Ecyrillic") },
  { 0x0204, wxT("Edblgrave") },
  { 0x00CB, wxT("Edieresis") },
  { 0xF7EB, wxT("Edieresissmall") },
  { 0x0116, wxT("Edot") },
  { 0x0116, wxT("Edotaccent") },
  { 0x1EB8, wxT("Edotbelow") },
  { 0x0424, wxT("Efcyrillic") },
  { 0x00C8, wxT("Egrave") },
  { 0xF7E8, wxT("Egravesmall") },
  { 0x0537, wxT("Eharmenian") },
  { 0x1EBA, wxT("Ehookabove") },
  { 0x2167, wxT("Eightroman") },
  { 0x0206, wxT("Einvertedbreve") },
  { 0x0464, wxT("Eiotifiedcyrillic") },
  { 0x041B, wxT("Elcyrillic") },
  { 0x216A, wxT("Elevenroman") },
  { 0x0112, wxT("Emacron") },
  { 0x1E16, wxT("Emacronacute") },
  { 0x1E14, wxT("Emacrongrave") },
  { 0x041C, wxT("Emcyrillic") },
  { 0xFF25, wxT("Emonospace") },
  { 0x041D, wxT("Encyrillic") },
  { 0x04A2, wxT("Endescendercyrillic") },
  { 0x014A, wxT("Eng") },
  { 0x04A4, wxT("Enghecyrillic") },
  { 0x04C7, wxT("Enhookcyrillic") },
  { 0x0118, wxT("Eogonek") },
  { 0x0190, wxT("Eopen") },
  { 0x0395, wxT("Epsilon") },
  { 0x0388, wxT("Epsilontonos") },
  { 0x0420, wxT("Ercyrillic") },
  { 0x018E, wxT("Ereversed") },
  { 0x042D, wxT("Ereversedcyrillic") },
  { 0x0421, wxT("Escyrillic") },
  { 0x04AA, wxT("Esdescendercyrillic") },
  { 0x01A9, wxT("Esh") },
  { 0xF765, wxT("Esmall") },
  { 0x0397, wxT("Eta") },
  { 0x0538, wxT("Etarmenian") },
  { 0x0389, wxT("Etatonos") },
  { 0x00D0, wxT("Eth") },
  { 0xF7F0, wxT("Ethsmall") },
  { 0x1EBC, wxT("Etilde") },
  { 0x1E1A, wxT("Etildebelow") },
  { 0x20AC, wxT("Euro") },
  { 0x01B7, wxT("Ezh") },
  { 0x01EE, wxT("Ezhcaron") },
  { 0x01B8, wxT("Ezhreversed") },
  { 0x0046, wxT("F") },
  { 0x24BB, wxT("Fcircle") },
  { 0x1E1E, wxT("Fdotaccent") },
  { 0x0556, wxT("Feharmenian") },
  { 0x03E4, wxT("Feicoptic") },
  { 0x0191, wxT("Fhook") },
  { 0x0472, wxT("Fitacyrillic") },
  { 0x2164, wxT("Fiveroman") },
  { 0xFF26, wxT("Fmonospace") },
  { 0x2163, wxT("Fourroman") },
  { 0xF766, wxT("Fsmall") },
  { 0x0047, wxT("G") },
  { 0x3387, wxT("GBsquare") },
  { 0x01F4, wxT("Gacute") },
  { 0x0393, wxT("Gamma") },
  { 0x0194, wxT("Gammaafrican") },
  { 0x03EA, wxT("Gangiacoptic") },
  { 0x011E, wxT("Gbreve") },
  { 0x01E6, wxT("Gcaron") },
  { 0x0122, wxT("Gcedilla") },
  { 0x24BC, wxT("Gcircle") },
  { 0x011C, wxT("Gcircumflex") },
  { 0x0122, wxT("Gcommaaccent") },
  { 0x0120, wxT("Gdot") },
  { 0x0120, wxT("Gdotaccent") },
  { 0x0413, wxT("Gecyrillic") },
  { 0x0542, wxT("Ghadarmenian") },
  { 0x0494, wxT("Ghemiddlehookcyrillic") },
  { 0x0492, wxT("Ghestrokecyrillic") },
  { 0x0490, wxT("Gheupturncyrillic") },
  { 0x0193, wxT("Ghook") },
  { 0x0533, wxT("Gimarmenian") },
  { 0x0403, wxT("Gjecyrillic") },
  { 0x1E20, wxT("Gmacron") },
  { 0xFF27, wxT("Gmonospace") },
  { 0xF6CE, wxT("Grave") },
  { 0xF760, wxT("Gravesmall") },
  { 0xF767, wxT("Gsmall") },
  { 0x029B, wxT("Gsmallhook") },
  { 0x01E4, wxT("Gstroke") },
  { 0x0048, wxT("H") },
  { 0x25CF, wxT("H18533") },
  { 0x25AA, wxT("H18543") },
  { 0x25AB, wxT("H18551") },
  { 0x25A1, wxT("H22073") },
  { 0x33CB, wxT("HPsquare") },
  { 0x04A8, wxT("Haabkhasiancyrillic") },
  { 0x04B2, wxT("Hadescendercyrillic") },
  { 0x042A, wxT("Hardsigncyrillic") },
  { 0x0126, wxT("Hbar") },
  { 0x1E2A, wxT("Hbrevebelow") },
  { 0x1E28, wxT("Hcedilla") },
  { 0x24BD, wxT("Hcircle") },
  { 0x0124, wxT("Hcircumflex") },
  { 0x1E26, wxT("Hdieresis") },
  { 0x1E22, wxT("Hdotaccent") },
  { 0x1E24, wxT("Hdotbelow") },
  { 0xFF28, wxT("Hmonospace") },
  { 0x0540, wxT("Hoarmenian") },
  { 0x03E8, wxT("Horicoptic") },
  { 0xF768, wxT("Hsmall") },
  { 0xF6CF, wxT("Hungarumlaut") },
  { 0xF6F8, wxT("Hungarumlautsmall") },
  { 0x3390, wxT("Hzsquare") },
  { 0x0049, wxT("I") },
  { 0x042F, wxT("IAcyrillic") },
  { 0x0132, wxT("IJ") },
  { 0x042E, wxT("IUcyrillic") },
  { 0x00CD, wxT("Iacute") },
  { 0xF7ED, wxT("Iacutesmall") },
  { 0x012C, wxT("Ibreve") },
  { 0x01CF, wxT("Icaron") },
  { 0x24BE, wxT("Icircle") },
  { 0x00CE, wxT("Icircumflex") },
  { 0xF7EE, wxT("Icircumflexsmall") },
  { 0x0406, wxT("Icyrillic") },
  { 0x0208, wxT("Idblgrave") },
  { 0x00CF, wxT("Idieresis") },
  { 0x1E2E, wxT("Idieresisacute") },
  { 0x04E4, wxT("Idieresiscyrillic") },
  { 0xF7EF, wxT("Idieresissmall") },
  { 0x0130, wxT("Idot") },
  { 0x0130, wxT("Idotaccent") },
  { 0x1ECA, wxT("Idotbelow") },
  { 0x04D6, wxT("Iebrevecyrillic") },
  { 0x0415, wxT("Iecyrillic") },
  { 0x2111, wxT("Ifraktur") },
  { 0x00CC, wxT("Igrave") },
  { 0xF7EC, wxT("Igravesmall") },
  { 0x1EC8, wxT("Ihookabove") },
  { 0x0418, wxT("Iicyrillic") },
  { 0x020A, wxT("Iinvertedbreve") },
  { 0x0419, wxT("Iishortcyrillic") },
  { 0x012A, wxT("Imacron") },
  { 0x04E2, wxT("Imacroncyrillic") },
  { 0xFF29, wxT("Imonospace") },
  { 0x053B, wxT("Iniarmenian") },
  { 0x0401, wxT("Iocyrillic") },
  { 0x012E, wxT("Iogonek") },
  { 0x0399, wxT("Iota") },
  { 0x0196, wxT("Iotaafrican") },
  { 0x03AA, wxT("Iotadieresis") },
  { 0x038A, wxT("Iotatonos") },
  { 0xF769, wxT("Ismall") },
  { 0x0197, wxT("Istroke") },
  { 0x0128, wxT("Itilde") },
  { 0x1E2C, wxT("Itildebelow") },
  { 0x0474, wxT("Izhitsacyrillic") },
  { 0x0476, wxT("Izhitsadblgravecyrillic") },
  { 0x004A, wxT("J") },
  { 0x0541, wxT("Jaarmenian") },
  { 0x24BF, wxT("Jcircle") },
  { 0x0134, wxT("Jcircumflex") },
  { 0x0408, wxT("Jecyrillic") },
  { 0x054B, wxT("Jheharmenian") },
  { 0xFF2A, wxT("Jmonospace") },
  { 0xF76A, wxT("Jsmall") },
  { 0x004B, wxT("K") },
  { 0x3385, wxT("KBsquare") },
  { 0x33CD, wxT("KKsquare") },
  { 0x04A0, wxT("Kabashkircyrillic") },
  { 0x1E30, wxT("Kacute") },
  { 0x041A, wxT("Kacyrillic") },
  { 0x049A, wxT("Kadescendercyrillic") },
  { 0x04C3, wxT("Kahookcyrillic") },
  { 0x039A, wxT("Kappa") },
  { 0x049E, wxT("Kastrokecyrillic") },
  { 0x049C, wxT("Kaverticalstrokecyrillic") },
  { 0x01E8, wxT("Kcaron") },
  { 0x0136, wxT("Kcedilla") },
  { 0x24C0, wxT("Kcircle") },
  { 0x0136, wxT("Kcommaaccent") },
  { 0x1E32, wxT("Kdotbelow") },
  { 0x0554, wxT("Keharmenian") },
  { 0x053F, wxT("Kenarmenian") },
  { 0x0425, wxT("Khacyrillic") },
  { 0x03E6, wxT("Kheicoptic") },
  { 0x0198, wxT("Khook") },
  { 0x040C, wxT("Kjecyrillic") },
  { 0x1E34, wxT("Klinebelow") },
  { 0xFF2B, wxT("Kmonospace") },
  { 0x0480, wxT("Koppacyrillic") },
  { 0x03DE, wxT("Koppagreek") },
  { 0x046E, wxT("Ksicyrillic") },
  { 0xF76B, wxT("Ksmall") },
  { 0x004C, wxT("L") },
  { 0x01C7, wxT("LJ") },
  { 0xF6BF, wxT("LL") },
  { 0x0139, wxT("Lacute") },
  { 0x039B, wxT("Lambda") },
  { 0x013D, wxT("Lcaron") },
  { 0x013B, wxT("Lcedilla") },
  { 0x24C1, wxT("Lcircle") },
  { 0x1E3C, wxT("Lcircumflexbelow") },
  { 0x013B, wxT("Lcommaaccent") },
  { 0x013F, wxT("Ldot") },
  { 0x013F, wxT("Ldotaccent") },
  { 0x1E36, wxT("Ldotbelow") },
  { 0x1E38, wxT("Ldotbelowmacron") },
  { 0x053C, wxT("Liwnarmenian") },
  { 0x01C8, wxT("Lj") },
  { 0x0409, wxT("Ljecyrillic") },
  { 0x1E3A, wxT("Llinebelow") },
  { 0xFF2C, wxT("Lmonospace") },
  { 0x0141, wxT("Lslash") },
  { 0xF6F9, wxT("Lslashsmall") },
  { 0xF76C, wxT("Lsmall") },
  { 0x004D, wxT("M") },
  { 0x3386, wxT("MBsquare") },
  { 0xF6D0, wxT("Macron") },
  { 0xF7AF, wxT("Macronsmall") },
  { 0x1E3E, wxT("Macute") },
  { 0x24C2, wxT("Mcircle") },
  { 0x1E40, wxT("Mdotaccent") },
  { 0x1E42, wxT("Mdotbelow") },
  { 0x0544, wxT("Menarmenian") },
  { 0xFF2D, wxT("Mmonospace") },
  { 0xF76D, wxT("Msmall") },
  { 0x019C, wxT("Mturned") },
  { 0x039C, wxT("Mu") },
  { 0x004E, wxT("N") },
  { 0x01CA, wxT("NJ") },
  { 0x0143, wxT("Nacute") },
  { 0x0147, wxT("Ncaron") },
  { 0x0145, wxT("Ncedilla") },
  { 0x24C3, wxT("Ncircle") },
  { 0x1E4A, wxT("Ncircumflexbelow") },
  { 0x0145, wxT("Ncommaaccent") },
  { 0x1E44, wxT("Ndotaccent") },
  { 0x1E46, wxT("Ndotbelow") },
  { 0x019D, wxT("Nhookleft") },
  { 0x2168, wxT("Nineroman") },
  { 0x01CB, wxT("Nj") },
  { 0x040A, wxT("Njecyrillic") },
  { 0x1E48, wxT("Nlinebelow") },
  { 0xFF2E, wxT("Nmonospace") },
  { 0x0546, wxT("Nowarmenian") },
  { 0xF76E, wxT("Nsmall") },
  { 0x00D1, wxT("Ntilde") },
  { 0xF7F1, wxT("Ntildesmall") },
  { 0x039D, wxT("Nu") },
  { 0x004F, wxT("O") },
  { 0x0152, wxT("OE") },
  { 0xF6FA, wxT("OEsmall") },
  { 0x00D3, wxT("Oacute") },
  { 0xF7F3, wxT("Oacutesmall") },
  { 0x04E8, wxT("Obarredcyrillic") },
  { 0x04EA, wxT("Obarreddieresiscyrillic") },
  { 0x014E, wxT("Obreve") },
  { 0x01D1, wxT("Ocaron") },
  { 0x019F, wxT("Ocenteredtilde") },
  { 0x24C4, wxT("Ocircle") },
  { 0x00D4, wxT("Ocircumflex") },
  { 0x1ED0, wxT("Ocircumflexacute") },
  { 0x1ED8, wxT("Ocircumflexdotbelow") },
  { 0x1ED2, wxT("Ocircumflexgrave") },
  { 0x1ED4, wxT("Ocircumflexhookabove") },
  { 0xF7F4, wxT("Ocircumflexsmall") },
  { 0x1ED6, wxT("Ocircumflextilde") },
  { 0x041E, wxT("Ocyrillic") },
  { 0x0150, wxT("Odblacute") },
  { 0x020C, wxT("Odblgrave") },
  { 0x00D6, wxT("Odieresis") },
  { 0x04E6, wxT("Odieresiscyrillic") },
  { 0xF7F6, wxT("Odieresissmall") },
  { 0x1ECC, wxT("Odotbelow") },
  { 0xF6FB, wxT("Ogoneksmall") },
  { 0x00D2, wxT("Ograve") },
  { 0xF7F2, wxT("Ogravesmall") },
  { 0x0555, wxT("Oharmenian") },
  { 0x2126, wxT("Ohm") },
  { 0x1ECE, wxT("Ohookabove") },
  { 0x01A0, wxT("Ohorn") },
  { 0x1EDA, wxT("Ohornacute") },
  { 0x1EE2, wxT("Ohorndotbelow") },
  { 0x1EDC, wxT("Ohorngrave") },
  { 0x1EDE, wxT("Ohornhookabove") },
  { 0x1EE0, wxT("Ohorntilde") },
  { 0x0150, wxT("Ohungarumlaut") },
  { 0x01A2, wxT("Oi") },
  { 0x020E, wxT("Oinvertedbreve") },
  { 0x014C, wxT("Omacron") },
  { 0x1E52, wxT("Omacronacute") },
  { 0x1E50, wxT("Omacrongrave") },
  { 0x03A9, wxT("Omega") },
  { 0x0460, wxT("Omegacyrillic") },
  { 0x03A9, wxT("Omegagreek") },
  { 0x047A, wxT("Omegaroundcyrillic") },
  { 0x047C, wxT("Omegatitlocyrillic") },
  { 0x038F, wxT("Omegatonos") },
  { 0x039F, wxT("Omicron") },
  { 0x038C, wxT("Omicrontonos") },
  { 0xFF2F, wxT("Omonospace") },
  { 0x2160, wxT("Oneroman") },
  { 0x01EA, wxT("Oogonek") },
  { 0x01EC, wxT("Oogonekmacron") },
  { 0x0186, wxT("Oopen") },
  { 0x00D8, wxT("Oslash") },
  { 0x01FE, wxT("Oslashacute") },
  { 0xF7F8, wxT("Oslashsmall") },
  { 0xF76F, wxT("Osmall") },
  { 0x01FE, wxT("Ostrokeacute") },
  { 0x047E, wxT("Otcyrillic") },
  { 0x00D5, wxT("Otilde") },
  { 0x1E4C, wxT("Otildeacute") },
  { 0x1E4E, wxT("Otildedieresis") },
  { 0xF7F5, wxT("Otildesmall") },
  { 0x0050, wxT("P") },
  { 0x1E54, wxT("Pacute") },
  { 0x24C5, wxT("Pcircle") },
  { 0x1E56, wxT("Pdotaccent") },
  { 0x041F, wxT("Pecyrillic") },
  { 0x054A, wxT("Peharmenian") },
  { 0x04A6, wxT("Pemiddlehookcyrillic") },
  { 0x03A6, wxT("Phi") },
  { 0x01A4, wxT("Phook") },
  { 0x03A0, wxT("Pi") },
  { 0x0553, wxT("Piwrarmenian") },
  { 0xFF30, wxT("Pmonospace") },
  { 0x03A8, wxT("Psi") },
  { 0x0470, wxT("Psicyrillic") },
  { 0xF770, wxT("Psmall") },
  { 0x0051, wxT("Q") },
  { 0x24C6, wxT("Qcircle") },
  { 0xFF31, wxT("Qmonospace") },
  { 0xF771, wxT("Qsmall") },
  { 0x0052, wxT("R") },
  { 0x054C, wxT("Raarmenian") },
  { 0x0154, wxT("Racute") },
  { 0x0158, wxT("Rcaron") },
  { 0x0156, wxT("Rcedilla") },
  { 0x24C7, wxT("Rcircle") },
  { 0x0156, wxT("Rcommaaccent") },
  { 0x0210, wxT("Rdblgrave") },
  { 0x1E58, wxT("Rdotaccent") },
  { 0x1E5A, wxT("Rdotbelow") },
  { 0x1E5C, wxT("Rdotbelowmacron") },
  { 0x0550, wxT("Reharmenian") },
  { 0x211C, wxT("Rfraktur") },
  { 0x03A1, wxT("Rho") },
  { 0xF6FC, wxT("Ringsmall") },
  { 0x0212, wxT("Rinvertedbreve") },
  { 0x1E5E, wxT("Rlinebelow") },
  { 0xFF32, wxT("Rmonospace") },
  { 0xF772, wxT("Rsmall") },
  { 0x0281, wxT("Rsmallinverted") },
  { 0x02B6, wxT("Rsmallinvertedsuperior") },
  { 0x0053, wxT("S") },
  { 0x250C, wxT("SF010000") },
  { 0x2514, wxT("SF020000") },
  { 0x2510, wxT("SF030000") },
  { 0x2518, wxT("SF040000") },
  { 0x253C, wxT("SF050000") },
  { 0x252C, wxT("SF060000") },
  { 0x2534, wxT("SF070000") },
  { 0x251C, wxT("SF080000") },
  { 0x2524, wxT("SF090000") },
  { 0x2500, wxT("SF100000") },
  { 0x2502, wxT("SF110000") },
  { 0x2561, wxT("SF190000") },
  { 0x2562, wxT("SF200000") },
  { 0x2556, wxT("SF210000") },
  { 0x2555, wxT("SF220000") },
  { 0x2563, wxT("SF230000") },
  { 0x2551, wxT("SF240000") },
  { 0x2557, wxT("SF250000") },
  { 0x255D, wxT("SF260000") },
  { 0x255C, wxT("SF270000") },
  { 0x255B, wxT("SF280000") },
  { 0x255E, wxT("SF360000") },
  { 0x255F, wxT("SF370000") },
  { 0x255A, wxT("SF380000") },
  { 0x2554, wxT("SF390000") },
  { 0x2569, wxT("SF400000") },
  { 0x2566, wxT("SF410000") },
  { 0x2560, wxT("SF420000") },
  { 0x2550, wxT("SF430000") },
  { 0x256C, wxT("SF440000") },
  { 0x2567, wxT("SF450000") },
  { 0x2568, wxT("SF460000") },
  { 0x2564, wxT("SF470000") },
  { 0x2565, wxT("SF480000") },
  { 0x2559, wxT("SF490000") },
  { 0x2558, wxT("SF500000") },
  { 0x2552, wxT("SF510000") },
  { 0x2553, wxT("SF520000") },
  { 0x256B, wxT("SF530000") },
  { 0x256A, wxT("SF540000") },
  { 0x015A, wxT("Sacute") },
  { 0x1E64, wxT("Sacutedotaccent") },
  { 0x03E0, wxT("Sampigreek") },
  { 0x0160, wxT("Scaron") },
  { 0x1E66, wxT("Scarondotaccent") },
  { 0xF6FD, wxT("Scaronsmall") },
  { 0x015E, wxT("Scedilla") },
  { 0x018F, wxT("Schwa") },
  { 0x04D8, wxT("Schwacyrillic") },
  { 0x04DA, wxT("Schwadieresiscyrillic") },
  { 0x24C8, wxT("Scircle") },
  { 0x015C, wxT("Scircumflex") },
  { 0x0218, wxT("Scommaaccent") },
  { 0x1E60, wxT("Sdotaccent") },
  { 0x1E62, wxT("Sdotbelow") },
  { 0x1E68, wxT("Sdotbelowdotaccent") },
  { 0x054D, wxT("Seharmenian") },
  { 0x2166, wxT("Sevenroman") },
  { 0x0547, wxT("Shaarmenian") },
  { 0x0428, wxT("Shacyrillic") },
  { 0x0429, wxT("Shchacyrillic") },
  { 0x03E2, wxT("Sheicoptic") },
  { 0x04BA, wxT("Shhacyrillic") },
  { 0x03EC, wxT("Shimacoptic") },
  { 0x03A3, wxT("Sigma") },
  { 0x2165, wxT("Sixroman") },
  { 0xFF33, wxT("Smonospace") },
  { 0x042C, wxT("Softsigncyrillic") },
  { 0xF773, wxT("Ssmall") },
  { 0x03DA, wxT("Stigmagreek") },
  { 0x0054, wxT("T") },
  { 0x03A4, wxT("Tau") },
  { 0x0166, wxT("Tbar") },
  { 0x0164, wxT("Tcaron") },
  { 0x0162, wxT("Tcedilla") },
  { 0x24C9, wxT("Tcircle") },
  { 0x1E70, wxT("Tcircumflexbelow") },
  { 0x0162, wxT("Tcommaaccent") },
  { 0x1E6A, wxT("Tdotaccent") },
  { 0x1E6C, wxT("Tdotbelow") },
  { 0x0422, wxT("Tecyrillic") },
  { 0x04AC, wxT("Tedescendercyrillic") },
  { 0x2169, wxT("Tenroman") },
  { 0x04B4, wxT("Tetsecyrillic") },
  { 0x0398, wxT("Theta") },
  { 0x01AC, wxT("Thook") },
  { 0x00DE, wxT("Thorn") },
  { 0xF7FE, wxT("Thornsmall") },
  { 0x2162, wxT("Threeroman") },
  { 0xF6FE, wxT("Tildesmall") },
  { 0x054F, wxT("Tiwnarmenian") },
  { 0x1E6E, wxT("Tlinebelow") },
  { 0xFF34, wxT("Tmonospace") },
  { 0x0539, wxT("Toarmenian") },
  { 0x01BC, wxT("Tonefive") },
  { 0x0184, wxT("Tonesix") },
  { 0x01A7, wxT("Tonetwo") },
  { 0x01AE, wxT("Tretroflexhook") },
  { 0x0426, wxT("Tsecyrillic") },
  { 0x040B, wxT("Tshecyrillic") },
  { 0xF774, wxT("Tsmall") },
  { 0x216B, wxT("Twelveroman") },
  { 0x2161, wxT("Tworoman") },
  { 0x0055, wxT("U") },
  { 0x00DA, wxT("Uacute") },
  { 0xF7FA, wxT("Uacutesmall") },
  { 0x016C, wxT("Ubreve") },
  { 0x01D3, wxT("Ucaron") },
  { 0x24CA, wxT("Ucircle") },
  { 0x00DB, wxT("Ucircumflex") },
  { 0x1E76, wxT("Ucircumflexbelow") },
  { 0xF7FB, wxT("Ucircumflexsmall") },
  { 0x0423, wxT("Ucyrillic") },
  { 0x0170, wxT("Udblacute") },
  { 0x0214, wxT("Udblgrave") },
  { 0x00DC, wxT("Udieresis") },
  { 0x01D7, wxT("Udieresisacute") },
  { 0x1E72, wxT("Udieresisbelow") },
  { 0x01D9, wxT("Udieresiscaron") },
  { 0x04F0, wxT("Udieresiscyrillic") },
  { 0x01DB, wxT("Udieresisgrave") },
  { 0x01D5, wxT("Udieresismacron") },
  { 0xF7FC, wxT("Udieresissmall") },
  { 0x1EE4, wxT("Udotbelow") },
  { 0x00D9, wxT("Ugrave") },
  { 0xF7F9, wxT("Ugravesmall") },
  { 0x1EE6, wxT("Uhookabove") },
  { 0x01AF, wxT("Uhorn") },
  { 0x1EE8, wxT("Uhornacute") },
  { 0x1EF0, wxT("Uhorndotbelow") },
  { 0x1EEA, wxT("Uhorngrave") },
  { 0x1EEC, wxT("Uhornhookabove") },
  { 0x1EEE, wxT("Uhorntilde") },
  { 0x0170, wxT("Uhungarumlaut") },
  { 0x04F2, wxT("Uhungarumlautcyrillic") },
  { 0x0216, wxT("Uinvertedbreve") },
  { 0x0478, wxT("Ukcyrillic") },
  { 0x016A, wxT("Umacron") },
  { 0x04EE, wxT("Umacroncyrillic") },
  { 0x1E7A, wxT("Umacrondieresis") },
  { 0xFF35, wxT("Umonospace") },
  { 0x0172, wxT("Uogonek") },
  { 0x03A5, wxT("Upsilon") },
  { 0x03D2, wxT("Upsilon1") },
  { 0x03D3, wxT("Upsilonacutehooksymbolgreek") },
  { 0x01B1, wxT("Upsilonafrican") },
  { 0x03AB, wxT("Upsilondieresis") },
  { 0x03D4, wxT("Upsilondieresishooksymbolgreek") },
  { 0x03D2, wxT("Upsilonhooksymbol") },
  { 0x038E, wxT("Upsilontonos") },
  { 0x016E, wxT("Uring") },
  { 0x040E, wxT("Ushortcyrillic") },
  { 0xF775, wxT("Usmall") },
  { 0x04AE, wxT("Ustraightcyrillic") },
  { 0x04B0, wxT("Ustraightstrokecyrillic") },
  { 0x0168, wxT("Utilde") },
  { 0x1E78, wxT("Utildeacute") },
  { 0x1E74, wxT("Utildebelow") },
  { 0x0056, wxT("V") },
  { 0x24CB, wxT("Vcircle") },
  { 0x1E7E, wxT("Vdotbelow") },
  { 0x0412, wxT("Vecyrillic") },
  { 0x054E, wxT("Vewarmenian") },
  { 0x01B2, wxT("Vhook") },
  { 0xFF36, wxT("Vmonospace") },
  { 0x0548, wxT("Voarmenian") },
  { 0xF776, wxT("Vsmall") },
  { 0x1E7C, wxT("Vtilde") },
  { 0x0057, wxT("W") },
  { 0x1E82, wxT("Wacute") },
  { 0x24CC, wxT("Wcircle") },
  { 0x0174, wxT("Wcircumflex") },
  { 0x1E84, wxT("Wdieresis") },
  { 0x1E86, wxT("Wdotaccent") },
  { 0x1E88, wxT("Wdotbelow") },
  { 0x1E80, wxT("Wgrave") },
  { 0xFF37, wxT("Wmonospace") },
  { 0xF777, wxT("Wsmall") },
  { 0x0058, wxT("X") },
  { 0x24CD, wxT("Xcircle") },
  { 0x1E8C, wxT("Xdieresis") },
  { 0x1E8A, wxT("Xdotaccent") },
  { 0x053D, wxT("Xeharmenian") },
  { 0x039E, wxT("Xi") },
  { 0xFF38, wxT("Xmonospace") },
  { 0xF778, wxT("Xsmall") },
  { 0x0059, wxT("Y") },
  { 0x00DD, wxT("Yacute") },
  { 0xF7FD, wxT("Yacutesmall") },
  { 0x0462, wxT("Yatcyrillic") },
  { 0x24CE, wxT("Ycircle") },
  { 0x0176, wxT("Ycircumflex") },
  { 0x0178, wxT("Ydieresis") },
  { 0xF7FF, wxT("Ydieresissmall") },
  { 0x1E8E, wxT("Ydotaccent") },
  { 0x1EF4, wxT("Ydotbelow") },
  { 0x042B, wxT("Yericyrillic") },
  { 0x04F8, wxT("Yerudieresiscyrillic") },
  { 0x1EF2, wxT("Ygrave") },
  { 0x01B3, wxT("Yhook") },
  { 0x1EF6, wxT("Yhookabove") },
  { 0x0545, wxT("Yiarmenian") },
  { 0x0407, wxT("Yicyrillic") },
  { 0x0552, wxT("Yiwnarmenian") },
  { 0xFF39, wxT("Ymonospace") },
  { 0xF779, wxT("Ysmall") },
  { 0x1EF8, wxT("Ytilde") },
  { 0x046A, wxT("Yusbigcyrillic") },
  { 0x046C, wxT("Yusbigiotifiedcyrillic") },
  { 0x0466, wxT("Yuslittlecyrillic") },
  { 0x0468, wxT("Yuslittleiotifiedcyrillic") },
  { 0x005A, wxT("Z") },
  { 0x0536, wxT("Zaarmenian") },
  { 0x0179, wxT("Zacute") },
  { 0x017D, wxT("Zcaron") },
  { 0xF6FF, wxT("Zcaronsmall") },
  { 0x24CF, wxT("Zcircle") },
  { 0x1E90, wxT("Zcircumflex") },
  { 0x017B, wxT("Zdot") },
  { 0x017B, wxT("Zdotaccent") },
  { 0x1E92, wxT("Zdotbelow") },
  { 0x0417, wxT("Zecyrillic") },
  { 0x0498, wxT("Zedescendercyrillic") },
  { 0x04DE, wxT("Zedieresiscyrillic") },
  { 0x0396, wxT("Zeta") },
  { 0x053A, wxT("Zhearmenian") },
  { 0x04C1, wxT("Zhebrevecyrillic") },
  { 0x0416, wxT("Zhecyrillic") },
  { 0x0496, wxT("Zhedescendercyrillic") },
  { 0x04DC, wxT("Zhedieresiscyrillic") },
  { 0x1E94, wxT("Zlinebelow") },
  { 0xFF3A, wxT("Zmonospace") },
  { 0xF77A, wxT("Zsmall") },
  { 0x01B5, wxT("Zstroke") },
  { 0x0061, wxT("a") },
  { 0x0986, wxT("aabengali") },
  { 0x00E1, wxT("aacute") },
  { 0x0906, wxT("aadeva") },
  { 0x0A86, wxT("aagujarati") },
  { 0x0A06, wxT("aagurmukhi") },
  { 0x0A3E, wxT("aamatragurmukhi") },
  { 0x3303, wxT("aarusquare") },
  { 0x09BE, wxT("aavowelsignbengali") },
  { 0x093E, wxT("aavowelsigndeva") },
  { 0x0ABE, wxT("aavowelsigngujarati") },
  { 0x055F, wxT("abbreviationmarkarmenian") },
  { 0x0970, wxT("abbreviationsigndeva") },
  { 0x0985, wxT("abengali") },
  { 0x311A, wxT("abopomofo") },
  { 0x0103, wxT("abreve") },
  { 0x1EAF, wxT("abreveacute") },
  { 0x04D1, wxT("abrevecyrillic") },
  { 0x1EB7, wxT("abrevedotbelow") },
  { 0x1EB1, wxT("abrevegrave") },
  { 0x1EB3, wxT("abrevehookabove") },
  { 0x1EB5, wxT("abrevetilde") },
  { 0x01CE, wxT("acaron") },
  { 0x24D0, wxT("acircle") },
  { 0x00E2, wxT("acircumflex") },
  { 0x1EA5, wxT("acircumflexacute") },
  { 0x1EAD, wxT("acircumflexdotbelow") },
  { 0x1EA7, wxT("acircumflexgrave") },
  { 0x1EA9, wxT("acircumflexhookabove") },
  { 0x1EAB, wxT("acircumflextilde") },
  { 0x00B4, wxT("acute") },
  { 0x0317, wxT("acutebelowcmb") },
  { 0x0301, wxT("acutecmb") },
  { 0x0301, wxT("acutecomb") },
  { 0x0954, wxT("acutedeva") },
  { 0x02CF, wxT("acutelowmod") },
  { 0x0341, wxT("acutetonecmb") },
  { 0x0430, wxT("acyrillic") },
  { 0x0201, wxT("adblgrave") },
  { 0x0A71, wxT("addakgurmukhi") },
  { 0x0905, wxT("adeva") },
  { 0x00E4, wxT("adieresis") },
  { 0x04D3, wxT("adieresiscyrillic") },
  { 0x01DF, wxT("adieresismacron") },
  { 0x1EA1, wxT("adotbelow") },
  { 0x01E1, wxT("adotmacron") },
  { 0x00E6, wxT("ae") },
  { 0x01FD, wxT("aeacute") },
  { 0x3150, wxT("aekorean") },
  { 0x01E3, wxT("aemacron") },
  { 0x2015, wxT("afii00208") },
  { 0x20A4, wxT("afii08941") },
  { 0x0410, wxT("afii10017") },
  { 0x0411, wxT("afii10018") },
  { 0x0412, wxT("afii10019") },
  { 0x0413, wxT("afii10020") },
  { 0x0414, wxT("afii10021") },
  { 0x0415, wxT("afii10022") },
  { 0x0401, wxT("afii10023") },
  { 0x0416, wxT("afii10024") },
  { 0x0417, wxT("afii10025") },
  { 0x0418, wxT("afii10026") },
  { 0x0419, wxT("afii10027") },
  { 0x041A, wxT("afii10028") },
  { 0x041B, wxT("afii10029") },
  { 0x041C, wxT("afii10030") },
  { 0x041D, wxT("afii10031") },
  { 0x041E, wxT("afii10032") },
  { 0x041F, wxT("afii10033") },
  { 0x0420, wxT("afii10034") },
  { 0x0421, wxT("afii10035") },
  { 0x0422, wxT("afii10036") },
  { 0x0423, wxT("afii10037") },
  { 0x0424, wxT("afii10038") },
  { 0x0425, wxT("afii10039") },
  { 0x0426, wxT("afii10040") },
  { 0x0427, wxT("afii10041") },
  { 0x0428, wxT("afii10042") },
  { 0x0429, wxT("afii10043") },
  { 0x042A, wxT("afii10044") },
  { 0x042B, wxT("afii10045") },
  { 0x042C, wxT("afii10046") },
  { 0x042D, wxT("afii10047") },
  { 0x042E, wxT("afii10048") },
  { 0x042F, wxT("afii10049") },
  { 0x0490, wxT("afii10050") },
  { 0x0402, wxT("afii10051") },
  { 0x0403, wxT("afii10052") },
  { 0x0404, wxT("afii10053") },
  { 0x0405, wxT("afii10054") },
  { 0x0406, wxT("afii10055") },
  { 0x0407, wxT("afii10056") },
  { 0x0408, wxT("afii10057") },
  { 0x0409, wxT("afii10058") },
  { 0x040A, wxT("afii10059") },
  { 0x040B, wxT("afii10060") },
  { 0x040C, wxT("afii10061") },
  { 0x040E, wxT("afii10062") },
  { 0xF6C4, wxT("afii10063") },
  { 0xF6C5, wxT("afii10064") },
  { 0x0430, wxT("afii10065") },
  { 0x0431, wxT("afii10066") },
  { 0x0432, wxT("afii10067") },
  { 0x0433, wxT("afii10068") },
  { 0x0434, wxT("afii10069") },
  { 0x0435, wxT("afii10070") },
  { 0x0451, wxT("afii10071") },
  { 0x0436, wxT("afii10072") },
  { 0x0437, wxT("afii10073") },
  { 0x0438, wxT("afii10074") },
  { 0x0439, wxT("afii10075") },
  { 0x043A, wxT("afii10076") },
  { 0x043B, wxT("afii10077") },
  { 0x043C, wxT("afii10078") },
  { 0x043D, wxT("afii10079") },
  { 0x043E, wxT("afii10080") },
  { 0x043F, wxT("afii10081") },
  { 0x0440, wxT("afii10082") },
  { 0x0441, wxT("afii10083") },
  { 0x0442, wxT("afii10084") },
  { 0x0443, wxT("afii10085") },
  { 0x0444, wxT("afii10086") },
  { 0x0445, wxT("afii10087") },
  { 0x0446, wxT("afii10088") },
  { 0x0447, wxT("afii10089") },
  { 0x0448, wxT("afii10090") },
  { 0x0449, wxT("afii10091") },
  { 0x044A, wxT("afii10092") },
  { 0x044B, wxT("afii10093") },
  { 0x044C, wxT("afii10094") },
  { 0x044D, wxT("afii10095") },
  { 0x044E, wxT("afii10096") },
  { 0x044F, wxT("afii10097") },
  { 0x0491, wxT("afii10098") },
  { 0x0452, wxT("afii10099") },
  { 0x0453, wxT("afii10100") },
  { 0x0454, wxT("afii10101") },
  { 0x0455, wxT("afii10102") },
  { 0x0456, wxT("afii10103") },
  { 0x0457, wxT("afii10104") },
  { 0x0458, wxT("afii10105") },
  { 0x0459, wxT("afii10106") },
  { 0x045A, wxT("afii10107") },
  { 0x045B, wxT("afii10108") },
  { 0x045C, wxT("afii10109") },
  { 0x045E, wxT("afii10110") },
  { 0x040F, wxT("afii10145") },
  { 0x0462, wxT("afii10146") },
  { 0x0472, wxT("afii10147") },
  { 0x0474, wxT("afii10148") },
  { 0xF6C6, wxT("afii10192") },
  { 0x045F, wxT("afii10193") },
  { 0x0463, wxT("afii10194") },
  { 0x0473, wxT("afii10195") },
  { 0x0475, wxT("afii10196") },
  { 0xF6C7, wxT("afii10831") },
  { 0xF6C8, wxT("afii10832") },
  { 0x04D9, wxT("afii10846") },
  { 0x200E, wxT("afii299") },
  { 0x200F, wxT("afii300") },
  { 0x200D, wxT("afii301") },
  { 0x066A, wxT("afii57381") },
  { 0x060C, wxT("afii57388") },
  { 0x0660, wxT("afii57392") },
  { 0x0661, wxT("afii57393") },
  { 0x0662, wxT("afii57394") },
  { 0x0663, wxT("afii57395") },
  { 0x0664, wxT("afii57396") },
  { 0x0665, wxT("afii57397") },
  { 0x0666, wxT("afii57398") },
  { 0x0667, wxT("afii57399") },
  { 0x0668, wxT("afii57400") },
  { 0x0669, wxT("afii57401") },
  { 0x061B, wxT("afii57403") },
  { 0x061F, wxT("afii57407") },
  { 0x0621, wxT("afii57409") },
  { 0x0622, wxT("afii57410") },
  { 0x0623, wxT("afii57411") },
  { 0x0624, wxT("afii57412") },
  { 0x0625, wxT("afii57413") },
  { 0x0626, wxT("afii57414") },
  { 0x0627, wxT("afii57415") },
  { 0x0628, wxT("afii57416") },
  { 0x0629, wxT("afii57417") },
  { 0x062A, wxT("afii57418") },
  { 0x062B, wxT("afii57419") },
  { 0x062C, wxT("afii57420") },
  { 0x062D, wxT("afii57421") },
  { 0x062E, wxT("afii57422") },
  { 0x062F, wxT("afii57423") },
  { 0x0630, wxT("afii57424") },
  { 0x0631, wxT("afii57425") },
  { 0x0632, wxT("afii57426") },
  { 0x0633, wxT("afii57427") },
  { 0x0634, wxT("afii57428") },
  { 0x0635, wxT("afii57429") },
  { 0x0636, wxT("afii57430") },
  { 0x0637, wxT("afii57431") },
  { 0x0638, wxT("afii57432") },
  { 0x0639, wxT("afii57433") },
  { 0x063A, wxT("afii57434") },
  { 0x0640, wxT("afii57440") },
  { 0x0641, wxT("afii57441") },
  { 0x0642, wxT("afii57442") },
  { 0x0643, wxT("afii57443") },
  { 0x0644, wxT("afii57444") },
  { 0x0645, wxT("afii57445") },
  { 0x0646, wxT("afii57446") },
  { 0x0648, wxT("afii57448") },
  { 0x0649, wxT("afii57449") },
  { 0x064A, wxT("afii57450") },
  { 0x064B, wxT("afii57451") },
  { 0x064C, wxT("afii57452") },
  { 0x064D, wxT("afii57453") },
  { 0x064E, wxT("afii57454") },
  { 0x064F, wxT("afii57455") },
  { 0x0650, wxT("afii57456") },
  { 0x0651, wxT("afii57457") },
  { 0x0652, wxT("afii57458") },
  { 0x0647, wxT("afii57470") },
  { 0x06A4, wxT("afii57505") },
  { 0x067E, wxT("afii57506") },
  { 0x0686, wxT("afii57507") },
  { 0x0698, wxT("afii57508") },
  { 0x06AF, wxT("afii57509") },
  { 0x0679, wxT("afii57511") },
  { 0x0688, wxT("afii57512") },
  { 0x0691, wxT("afii57513") },
  { 0x06BA, wxT("afii57514") },
  { 0x06D2, wxT("afii57519") },
  { 0x06D5, wxT("afii57534") },
  { 0x20AA, wxT("afii57636") },
  { 0x05BE, wxT("afii57645") },
  { 0x05C3, wxT("afii57658") },
  { 0x05D0, wxT("afii57664") },
  { 0x05D1, wxT("afii57665") },
  { 0x05D2, wxT("afii57666") },
  { 0x05D3, wxT("afii57667") },
  { 0x05D4, wxT("afii57668") },
  { 0x05D5, wxT("afii57669") },
  { 0x05D6, wxT("afii57670") },
  { 0x05D7, wxT("afii57671") },
  { 0x05D8, wxT("afii57672") },
  { 0x05D9, wxT("afii57673") },
  { 0x05DA, wxT("afii57674") },
  { 0x05DB, wxT("afii57675") },
  { 0x05DC, wxT("afii57676") },
  { 0x05DD, wxT("afii57677") },
  { 0x05DE, wxT("afii57678") },
  { 0x05DF, wxT("afii57679") },
  { 0x05E0, wxT("afii57680") },
  { 0x05E1, wxT("afii57681") },
  { 0x05E2, wxT("afii57682") },
  { 0x05E3, wxT("afii57683") },
  { 0x05E4, wxT("afii57684") },
  { 0x05E5, wxT("afii57685") },
  { 0x05E6, wxT("afii57686") },
  { 0x05E7, wxT("afii57687") },
  { 0x05E8, wxT("afii57688") },
  { 0x05E9, wxT("afii57689") },
  { 0x05EA, wxT("afii57690") },
  { 0xFB2A, wxT("afii57694") },
  { 0xFB2B, wxT("afii57695") },
  { 0xFB4B, wxT("afii57700") },
  { 0xFB1F, wxT("afii57705") },
  { 0x05F0, wxT("afii57716") },
  { 0x05F1, wxT("afii57717") },
  { 0x05F2, wxT("afii57718") },
  { 0xFB35, wxT("afii57723") },
  { 0x05B4, wxT("afii57793") },
  { 0x05B5, wxT("afii57794") },
  { 0x05B6, wxT("afii57795") },
  { 0x05BB, wxT("afii57796") },
  { 0x05B8, wxT("afii57797") },
  { 0x05B7, wxT("afii57798") },
  { 0x05B0, wxT("afii57799") },
  { 0x05B2, wxT("afii57800") },
  { 0x05B1, wxT("afii57801") },
  { 0x05B3, wxT("afii57802") },
  { 0x05C2, wxT("afii57803") },
  { 0x05C1, wxT("afii57804") },
  { 0x05B9, wxT("afii57806") },
  { 0x05BC, wxT("afii57807") },
  { 0x05BD, wxT("afii57839") },
  { 0x05BF, wxT("afii57841") },
  { 0x05C0, wxT("afii57842") },
  { 0x02BC, wxT("afii57929") },
  { 0x2105, wxT("afii61248") },
  { 0x2113, wxT("afii61289") },
  { 0x2116, wxT("afii61352") },
  { 0x202C, wxT("afii61573") },
  { 0x202D, wxT("afii61574") },
  { 0x202E, wxT("afii61575") },
  { 0x200C, wxT("afii61664") },
  { 0x066D, wxT("afii63167") },
  { 0x02BD, wxT("afii64937") },
  { 0x00E0, wxT("agrave") },
  { 0x0A85, wxT("agujarati") },
  { 0x0A05, wxT("agurmukhi") },
  { 0x3042, wxT("ahiragana") },
  { 0x1EA3, wxT("ahookabove") },
  { 0x0990, wxT("aibengali") },
  { 0x311E, wxT("aibopomofo") },
  { 0x0910, wxT("aideva") },
  { 0x04D5, wxT("aiecyrillic") },
  { 0x0A90, wxT("aigujarati") },
  { 0x0A10, wxT("aigurmukhi") },
  { 0x0A48, wxT("aimatragurmukhi") },
  { 0x0639, wxT("ainarabic") },
  { 0xFECA, wxT("ainfinalarabic") },
  { 0xFECB, wxT("aininitialarabic") },
  { 0xFECC, wxT("ainmedialarabic") },
  { 0x0203, wxT("ainvertedbreve") },
  { 0x09C8, wxT("aivowelsignbengali") },
  { 0x0948, wxT("aivowelsigndeva") },
  { 0x0AC8, wxT("aivowelsigngujarati") },
  { 0x30A2, wxT("akatakana") },
  { 0xFF71, wxT("akatakanahalfwidth") },
  { 0x314F, wxT("akorean") },
  { 0x05D0, wxT("alef") },
  { 0x0627, wxT("alefarabic") },
  { 0xFB30, wxT("alefdageshhebrew") },
  { 0xFE8E, wxT("aleffinalarabic") },
  { 0x0623, wxT("alefhamzaabovearabic") },
  { 0xFE84, wxT("alefhamzaabovefinalarabic") },
  { 0x0625, wxT("alefhamzabelowarabic") },
  { 0xFE88, wxT("alefhamzabelowfinalarabic") },
  { 0x05D0, wxT("alefhebrew") },
  { 0xFB4F, wxT("aleflamedhebrew") },
  { 0x0622, wxT("alefmaddaabovearabic") },
  { 0xFE82, wxT("alefmaddaabovefinalarabic") },
  { 0x0649, wxT("alefmaksuraarabic") },
  { 0xFEF0, wxT("alefmaksurafinalarabic") },
  { 0xFEF3, wxT("alefmaksurainitialarabic") },
  { 0xFEF4, wxT("alefmaksuramedialarabic") },
  { 0xFB2E, wxT("alefpatahhebrew") },
  { 0xFB2F, wxT("alefqamatshebrew") },
  { 0x2135, wxT("aleph") },
  { 0x224C, wxT("allequal") },
  { 0x03B1, wxT("alpha") },
  { 0x03AC, wxT("alphatonos") },
  { 0x0101, wxT("amacron") },
  { 0xFF41, wxT("amonospace") },
  { 0x0026, wxT("ampersand") },
  { 0xFF06, wxT("ampersandmonospace") },
  { 0xF726, wxT("ampersandsmall") },
  { 0x33C2, wxT("amsquare") },
  { 0x3122, wxT("anbopomofo") },
  { 0x3124, wxT("angbopomofo") },
  { 0x0E5A, wxT("angkhankhuthai") },
  { 0x2220, wxT("angle") },
  { 0x3008, wxT("anglebracketleft") },
  { 0xFE3F, wxT("anglebracketleftvertical") },
  { 0x3009, wxT("anglebracketright") },
  { 0xFE40, wxT("anglebracketrightvertical") },
  { 0x2329, wxT("angleleft") },
  { 0x232A, wxT("angleright") },
  { 0x212B, wxT("angstrom") },
  { 0x0387, wxT("anoteleia") },
  { 0x0952, wxT("anudattadeva") },
  { 0x0982, wxT("anusvarabengali") },
  { 0x0902, wxT("anusvaradeva") },
  { 0x0A82, wxT("anusvaragujarati") },
  { 0x0105, wxT("aogonek") },
  { 0x3300, wxT("apaatosquare") },
  { 0x249C, wxT("aparen") },
  { 0x055A, wxT("apostrophearmenian") },
  { 0x02BC, wxT("apostrophemod") },
  { 0xF8FF, wxT("apple") },
  { 0x2250, wxT("approaches") },
  { 0x2248, wxT("approxequal") },
  { 0x2252, wxT("approxequalorimage") },
  { 0x2245, wxT("approximatelyequal") },
  { 0x318E, wxT("araeaekorean") },
  { 0x318D, wxT("araeakorean") },
  { 0x2312, wxT("arc") },
  { 0x1E9A, wxT("arighthalfring") },
  { 0x00E5, wxT("aring") },
  { 0x01FB, wxT("aringacute") },
  { 0x1E01, wxT("aringbelow") },
  { 0x2194, wxT("arrowboth") },
  { 0x21E3, wxT("arrowdashdown") },
  { 0x21E0, wxT("arrowdashleft") },
  { 0x21E2, wxT("arrowdashright") },
  { 0x21E1, wxT("arrowdashup") },
  { 0x21D4, wxT("arrowdblboth") },
  { 0x21D3, wxT("arrowdbldown") },
  { 0x21D0, wxT("arrowdblleft") },
  { 0x21D2, wxT("arrowdblright") },
  { 0x21D1, wxT("arrowdblup") },
  { 0x2193, wxT("arrowdown") },
  { 0x2199, wxT("arrowdownleft") },
  { 0x2198, wxT("arrowdownright") },
  { 0x21E9, wxT("arrowdownwhite") },
  { 0x02C5, wxT("arrowheaddownmod") },
  { 0x02C2, wxT("arrowheadleftmod") },
  { 0x02C3, wxT("arrowheadrightmod") },
  { 0x02C4, wxT("arrowheadupmod") },
  { 0xF8E7, wxT("arrowhorizex") },
  { 0x2190, wxT("arrowleft") },
  { 0x21D0, wxT("arrowleftdbl") },
  { 0x21CD, wxT("arrowleftdblstroke") },
  { 0x21C6, wxT("arrowleftoverright") },
  { 0x21E6, wxT("arrowleftwhite") },
  { 0x2192, wxT("arrowright") },
  { 0x21CF, wxT("arrowrightdblstroke") },
  { 0x279E, wxT("arrowrightheavy") },
  { 0x21C4, wxT("arrowrightoverleft") },
  { 0x21E8, wxT("arrowrightwhite") },
  { 0x21E4, wxT("arrowtableft") },
  { 0x21E5, wxT("arrowtabright") },
  { 0x2191, wxT("arrowup") },
  { 0x2195, wxT("arrowupdn") },
  { 0x21A8, wxT("arrowupdnbse") },
  { 0x21A8, wxT("arrowupdownbase") },
  { 0x2196, wxT("arrowupleft") },
  { 0x21C5, wxT("arrowupleftofdown") },
  { 0x2197, wxT("arrowupright") },
  { 0x21E7, wxT("arrowupwhite") },
  { 0xF8E6, wxT("arrowvertex") },
  { 0x005E, wxT("asciicircum") },
  { 0xFF3E, wxT("asciicircummonospace") },
  { 0x007E, wxT("asciitilde") },
  { 0xFF5E, wxT("asciitildemonospace") },
  { 0x0251, wxT("ascript") },
  { 0x0252, wxT("ascriptturned") },
  { 0x3041, wxT("asmallhiragana") },
  { 0x30A1, wxT("asmallkatakana") },
  { 0xFF67, wxT("asmallkatakanahalfwidth") },
  { 0x002A, wxT("asterisk") },
  { 0x066D, wxT("asteriskaltonearabic") },
  { 0x066D, wxT("asteriskarabic") },
  { 0x2217, wxT("asteriskmath") },
  { 0xFF0A, wxT("asteriskmonospace") },
  { 0xFE61, wxT("asterisksmall") },
  { 0x2042, wxT("asterism") },
  { 0xF6E9, wxT("asuperior") },
  { 0x2243, wxT("asymptoticallyequal") },
  { 0x0040, wxT("at") },
  { 0x00E3, wxT("atilde") },
  { 0xFF20, wxT("atmonospace") },
  { 0xFE6B, wxT("atsmall") },
  { 0x0250, wxT("aturned") },
  { 0x0994, wxT("aubengali") },
  { 0x3120, wxT("aubopomofo") },
  { 0x0914, wxT("audeva") },
  { 0x0A94, wxT("augujarati") },
  { 0x0A14, wxT("augurmukhi") },
  { 0x09D7, wxT("aulengthmarkbengali") },
  { 0x0A4C, wxT("aumatragurmukhi") },
  { 0x09CC, wxT("auvowelsignbengali") },
  { 0x094C, wxT("auvowelsigndeva") },
  { 0x0ACC, wxT("auvowelsigngujarati") },
  { 0x093D, wxT("avagrahadeva") },
  { 0x0561, wxT("aybarmenian") },
  { 0x05E2, wxT("ayin") },
  { 0xFB20, wxT("ayinaltonehebrew") },
  { 0x05E2, wxT("ayinhebrew") },
  { 0x0062, wxT("b") },
  { 0x09AC, wxT("babengali") },
  { 0x005C, wxT("backslash") },
  { 0xFF3C, wxT("backslashmonospace") },
  { 0x092C, wxT("badeva") },
  { 0x0AAC, wxT("bagujarati") },
  { 0x0A2C, wxT("bagurmukhi") },
  { 0x3070, wxT("bahiragana") },
  { 0x0E3F, wxT("bahtthai") },
  { 0x30D0, wxT("bakatakana") },
  { 0x007C, wxT("bar") },
  { 0xFF5C, wxT("barmonospace") },
  { 0x3105, wxT("bbopomofo") },
  { 0x24D1, wxT("bcircle") },
  { 0x1E03, wxT("bdotaccent") },
  { 0x1E05, wxT("bdotbelow") },
  { 0x266C, wxT("beamedsixteenthnotes") },
  { 0x2235, wxT("because") },
  { 0x0431, wxT("becyrillic") },
  { 0x0628, wxT("beharabic") },
  { 0xFE90, wxT("behfinalarabic") },
  { 0xFE91, wxT("behinitialarabic") },
  { 0x3079, wxT("behiragana") },
  { 0xFE92, wxT("behmedialarabic") },
  { 0xFC9F, wxT("behmeeminitialarabic") },
  { 0xFC08, wxT("behmeemisolatedarabic") },
  { 0xFC6D, wxT("behnoonfinalarabic") },
  { 0x30D9, wxT("bekatakana") },
  { 0x0562, wxT("benarmenian") },
  { 0x05D1, wxT("bet") },
  { 0x03B2, wxT("beta") },
  { 0x03D0, wxT("betasymbolgreek") },
  { 0xFB31, wxT("betdagesh") },
  { 0xFB31, wxT("betdageshhebrew") },
  { 0x05D1, wxT("bethebrew") },
  { 0xFB4C, wxT("betrafehebrew") },
  { 0x09AD, wxT("bhabengali") },
  { 0x092D, wxT("bhadeva") },
  { 0x0AAD, wxT("bhagujarati") },
  { 0x0A2D, wxT("bhagurmukhi") },
  { 0x0253, wxT("bhook") },
  { 0x3073, wxT("bihiragana") },
  { 0x30D3, wxT("bikatakana") },
  { 0x0298, wxT("bilabialclick") },
  { 0x0A02, wxT("bindigurmukhi") },
  { 0x3331, wxT("birusquare") },
  { 0x25CF, wxT("blackcircle") },
  { 0x25C6, wxT("blackdiamond") },
  { 0x25BC, wxT("blackdownpointingtriangle") },
  { 0x25C4, wxT("blackleftpointingpointer") },
  { 0x25C0, wxT("blackleftpointingtriangle") },
  { 0x3010, wxT("blacklenticularbracketleft") },
  { 0xFE3B, wxT("blacklenticularbracketleftvertical") },
  { 0x3011, wxT("blacklenticularbracketright") },
  { 0xFE3C, wxT("blacklenticularbracketrightvertical") },
  { 0x25E3, wxT("blacklowerlefttriangle") },
  { 0x25E2, wxT("blacklowerrighttriangle") },
  { 0x25AC, wxT("blackrectangle") },
  { 0x25BA, wxT("blackrightpointingpointer") },
  { 0x25B6, wxT("blackrightpointingtriangle") },
  { 0x25AA, wxT("blacksmallsquare") },
  { 0x263B, wxT("blacksmilingface") },
  { 0x25A0, wxT("blacksquare") },
  { 0x2605, wxT("blackstar") },
  { 0x25E4, wxT("blackupperlefttriangle") },
  { 0x25E5, wxT("blackupperrighttriangle") },
  { 0x25B4, wxT("blackuppointingsmalltriangle") },
  { 0x25B2, wxT("blackuppointingtriangle") },
  { 0x2423, wxT("blank") },
  { 0x1E07, wxT("blinebelow") },
  { 0x2588, wxT("block") },
  { 0xFF42, wxT("bmonospace") },
  { 0x0E1A, wxT("bobaimaithai") },
  { 0x307C, wxT("bohiragana") },
  { 0x30DC, wxT("bokatakana") },
  { 0x249D, wxT("bparen") },
  { 0x33C3, wxT("bqsquare") },
  { 0xF8F4, wxT("braceex") },
  { 0x007B, wxT("braceleft") },
  { 0xF8F3, wxT("braceleftbt") },
  { 0xF8F2, wxT("braceleftmid") },
  { 0xFF5B, wxT("braceleftmonospace") },
  { 0xFE5B, wxT("braceleftsmall") },
  { 0xF8F1, wxT("bracelefttp") },
  { 0xFE37, wxT("braceleftvertical") },
  { 0x007D, wxT("braceright") },
  { 0xF8FE, wxT("bracerightbt") },
  { 0xF8FD, wxT("bracerightmid") },
  { 0xFF5D, wxT("bracerightmonospace") },
  { 0xFE5C, wxT("bracerightsmall") },
  { 0xF8FC, wxT("bracerighttp") },
  { 0xFE38, wxT("bracerightvertical") },
  { 0x005B, wxT("bracketleft") },
  { 0xF8F0, wxT("bracketleftbt") },
  { 0xF8EF, wxT("bracketleftex") },
  { 0xFF3B, wxT("bracketleftmonospace") },
  { 0xF8EE, wxT("bracketlefttp") },
  { 0x005D, wxT("bracketright") },
  { 0xF8FB, wxT("bracketrightbt") },
  { 0xF8FA, wxT("bracketrightex") },
  { 0xFF3D, wxT("bracketrightmonospace") },
  { 0xF8F9, wxT("bracketrighttp") },
  { 0x02D8, wxT("breve") },
  { 0x032E, wxT("brevebelowcmb") },
  { 0x0306, wxT("brevecmb") },
  { 0x032F, wxT("breveinvertedbelowcmb") },
  { 0x0311, wxT("breveinvertedcmb") },
  { 0x0361, wxT("breveinverteddoublecmb") },
  { 0x032A, wxT("bridgebelowcmb") },
  { 0x033A, wxT("bridgeinvertedbelowcmb") },
  { 0x00A6, wxT("brokenbar") },
  { 0x0180, wxT("bstroke") },
  { 0xF6EA, wxT("bsuperior") },
  { 0x0183, wxT("btopbar") },
  { 0x3076, wxT("buhiragana") },
  { 0x30D6, wxT("bukatakana") },
  { 0x2022, wxT("bullet") },
  { 0x25D8, wxT("bulletinverse") },
  { 0x2219, wxT("bulletoperator") },
  { 0x25CE, wxT("bullseye") },
  { 0x0063, wxT("c") },
  { 0x056E, wxT("caarmenian") },
  { 0x099A, wxT("cabengali") },
  { 0x0107, wxT("cacute") },
  { 0x091A, wxT("cadeva") },
  { 0x0A9A, wxT("cagujarati") },
  { 0x0A1A, wxT("cagurmukhi") },
  { 0x3388, wxT("calsquare") },
  { 0x0981, wxT("candrabindubengali") },
  { 0x0310, wxT("candrabinducmb") },
  { 0x0901, wxT("candrabindudeva") },
  { 0x0A81, wxT("candrabindugujarati") },
  { 0x21EA, wxT("capslock") },
  { 0x2105, wxT("careof") },
  { 0x02C7, wxT("caron") },
  { 0x032C, wxT("caronbelowcmb") },
  { 0x030C, wxT("caroncmb") },
  { 0x21B5, wxT("carriagereturn") },
  { 0x3118, wxT("cbopomofo") },
  { 0x010D, wxT("ccaron") },
  { 0x00E7, wxT("ccedilla") },
  { 0x1E09, wxT("ccedillaacute") },
  { 0x24D2, wxT("ccircle") },
  { 0x0109, wxT("ccircumflex") },
  { 0x0255, wxT("ccurl") },
  { 0x010B, wxT("cdot") },
  { 0x010B, wxT("cdotaccent") },
  { 0x33C5, wxT("cdsquare") },
  { 0x00B8, wxT("cedilla") },
  { 0x0327, wxT("cedillacmb") },
  { 0x00A2, wxT("cent") },
  { 0x2103, wxT("centigrade") },
  { 0xF6DF, wxT("centinferior") },
  { 0xFFE0, wxT("centmonospace") },
  { 0xF7A2, wxT("centoldstyle") },
  { 0xF6E0, wxT("centsuperior") },
  { 0x0579, wxT("chaarmenian") },
  { 0x099B, wxT("chabengali") },
  { 0x091B, wxT("chadeva") },
  { 0x0A9B, wxT("chagujarati") },
  { 0x0A1B, wxT("chagurmukhi") },
  { 0x3114, wxT("chbopomofo") },
  { 0x04BD, wxT("cheabkhasiancyrillic") },
  { 0x2713, wxT("checkmark") },
  { 0x0447, wxT("checyrillic") },
  { 0x04BF, wxT("chedescenderabkhasiancyrillic") },
  { 0x04B7, wxT("chedescendercyrillic") },
  { 0x04F5, wxT("chedieresiscyrillic") },
  { 0x0573, wxT("cheharmenian") },
  { 0x04CC, wxT("chekhakassiancyrillic") },
  { 0x04B9, wxT("cheverticalstrokecyrillic") },
  { 0x03C7, wxT("chi") },
  { 0x3277, wxT("chieuchacirclekorean") },
  { 0x3217, wxT("chieuchaparenkorean") },
  { 0x3269, wxT("chieuchcirclekorean") },
  { 0x314A, wxT("chieuchkorean") },
  { 0x3209, wxT("chieuchparenkorean") },
  { 0x0E0A, wxT("chochangthai") },
  { 0x0E08, wxT("chochanthai") },
  { 0x0E09, wxT("chochingthai") },
  { 0x0E0C, wxT("chochoethai") },
  { 0x0188, wxT("chook") },
  { 0x3276, wxT("cieucacirclekorean") },
  { 0x3216, wxT("cieucaparenkorean") },
  { 0x3268, wxT("cieuccirclekorean") },
  { 0x3148, wxT("cieuckorean") },
  { 0x3208, wxT("cieucparenkorean") },
  { 0x321C, wxT("cieucuparenkorean") },
  { 0x25CB, wxT("circle") },
  { 0x2297, wxT("circlemultiply") },
  { 0x2299, wxT("circleot") },
  { 0x2295, wxT("circleplus") },
  { 0x3036, wxT("circlepostalmark") },
  { 0x25D0, wxT("circlewithlefthalfblack") },
  { 0x25D1, wxT("circlewithrighthalfblack") },
  { 0x02C6, wxT("circumflex") },
  { 0x032D, wxT("circumflexbelowcmb") },
  { 0x0302, wxT("circumflexcmb") },
  { 0x2327, wxT("clear") },
  { 0x01C2, wxT("clickalveolar") },
  { 0x01C0, wxT("clickdental") },
  { 0x01C1, wxT("clicklateral") },
  { 0x01C3, wxT("clickretroflex") },
  { 0x2663, wxT("club") },
  { 0x2663, wxT("clubsuitblack") },
  { 0x2667, wxT("clubsuitwhite") },
  { 0x33A4, wxT("cmcubedsquare") },
  { 0xFF43, wxT("cmonospace") },
  { 0x33A0, wxT("cmsquaredsquare") },
  { 0x0581, wxT("coarmenian") },
  { 0x003A, wxT("colon") },
  { 0x20A1, wxT("colonmonetary") },
  { 0xFF1A, wxT("colonmonospace") },
  { 0x20A1, wxT("colonsign") },
  { 0xFE55, wxT("colonsmall") },
  { 0x02D1, wxT("colontriangularhalfmod") },
  { 0x02D0, wxT("colontriangularmod") },
  { 0x002C, wxT("comma") },
  { 0x0313, wxT("commaabovecmb") },
  { 0x0315, wxT("commaaboverightcmb") },
  { 0xF6C3, wxT("commaaccent") },
  { 0x060C, wxT("commaarabic") },
  { 0x055D, wxT("commaarmenian") },
  { 0xF6E1, wxT("commainferior") },
  { 0xFF0C, wxT("commamonospace") },
  { 0x0314, wxT("commareversedabovecmb") },
  { 0x02BD, wxT("commareversedmod") },
  { 0xFE50, wxT("commasmall") },
  { 0xF6E2, wxT("commasuperior") },
  { 0x0312, wxT("commaturnedabovecmb") },
  { 0x02BB, wxT("commaturnedmod") },
  { 0x263C, wxT("compass") },
  { 0x2245, wxT("congruent") },
  { 0x222E, wxT("contourintegral") },
  { 0x2303, wxT("control") },
  { 0x0006, wxT("controlACK") },
  { 0x0007, wxT("controlBEL") },
  { 0x0008, wxT("controlBS") },
  { 0x0018, wxT("controlCAN") },
  { 0x000D, wxT("controlCR") },
  { 0x0011, wxT("controlDC1") },
  { 0x0012, wxT("controlDC2") },
  { 0x0013, wxT("controlDC3") },
  { 0x0014, wxT("controlDC4") },
  { 0x007F, wxT("controlDEL") },
  { 0x0010, wxT("controlDLE") },
  { 0x0019, wxT("controlEM") },
  { 0x0005, wxT("controlENQ") },
  { 0x0004, wxT("controlEOT") },
  { 0x001B, wxT("controlESC") },
  { 0x0017, wxT("controlETB") },
  { 0x0003, wxT("controlETX") },
  { 0x000C, wxT("controlFF") },
  { 0x001C, wxT("controlFS") },
  { 0x001D, wxT("controlGS") },
  { 0x0009, wxT("controlHT") },
  { 0x000A, wxT("controlLF") },
  { 0x0015, wxT("controlNAK") },
  { 0x001E, wxT("controlRS") },
  { 0x000F, wxT("controlSI") },
  { 0x000E, wxT("controlSO") },
  { 0x0002, wxT("controlSOT") },
  { 0x0001, wxT("controlSTX") },
  { 0x001A, wxT("controlSUB") },
  { 0x0016, wxT("controlSYN") },
  { 0x001F, wxT("controlUS") },
  { 0x000B, wxT("controlVT") },
  { 0x00A9, wxT("copyright") },
  { 0xF8E9, wxT("copyrightsans") },
  { 0xF6D9, wxT("copyrightserif") },
  { 0x300C, wxT("cornerbracketleft") },
  { 0xFF62, wxT("cornerbracketlefthalfwidth") },
  { 0xFE41, wxT("cornerbracketleftvertical") },
  { 0x300D, wxT("cornerbracketright") },
  { 0xFF63, wxT("cornerbracketrighthalfwidth") },
  { 0xFE42, wxT("cornerbracketrightvertical") },
  { 0x337F, wxT("corporationsquare") },
  { 0x33C7, wxT("cosquare") },
  { 0x33C6, wxT("coverkgsquare") },
  { 0x249E, wxT("cparen") },
  { 0x20A2, wxT("cruzeiro") },
  { 0x0297, wxT("cstretched") },
  { 0x22CF, wxT("curlyand") },
  { 0x22CE, wxT("curlyor") },
  { 0x00A4, wxT("currency") },
  { 0xF6D1, wxT("cyrBreve") },
  { 0xF6D2, wxT("cyrFlex") },
  { 0xF6D4, wxT("cyrbreve") },
  { 0xF6D5, wxT("cyrflex") },
  { 0x0064, wxT("d") },
  { 0x0564, wxT("daarmenian") },
  { 0x09A6, wxT("dabengali") },
  { 0x0636, wxT("dadarabic") },
  { 0x0926, wxT("dadeva") },
  { 0xFEBE, wxT("dadfinalarabic") },
  { 0xFEBF, wxT("dadinitialarabic") },
  { 0xFEC0, wxT("dadmedialarabic") },
  { 0x05BC, wxT("dagesh") },
  { 0x05BC, wxT("dageshhebrew") },
  { 0x2020, wxT("dagger") },
  { 0x2021, wxT("daggerdbl") },
  { 0x0AA6, wxT("dagujarati") },
  { 0x0A26, wxT("dagurmukhi") },
  { 0x3060, wxT("dahiragana") },
  { 0x30C0, wxT("dakatakana") },
  { 0x062F, wxT("dalarabic") },
  { 0x05D3, wxT("dalet") },
  { 0xFB33, wxT("daletdagesh") },
  { 0xFB33, wxT("daletdageshhebrew") },
  { 0x05D3, wxT("dalethebrew") },
  { 0xFEAA, wxT("dalfinalarabic") },
  { 0x064F, wxT("dammaarabic") },
  { 0x064F, wxT("dammalowarabic") },
  { 0x064C, wxT("dammatanaltonearabic") },
  { 0x064C, wxT("dammatanarabic") },
  { 0x0964, wxT("danda") },
  { 0x05A7, wxT("dargahebrew") },
  { 0x05A7, wxT("dargalefthebrew") },
  { 0x0485, wxT("dasiapneumatacyrilliccmb") },
  { 0xF6D3, wxT("dblGrave") },
  { 0x300A, wxT("dblanglebracketleft") },
  { 0xFE3D, wxT("dblanglebracketleftvertical") },
  { 0x300B, wxT("dblanglebracketright") },
  { 0xFE3E, wxT("dblanglebracketrightvertical") },
  { 0x032B, wxT("dblarchinvertedbelowcmb") },
  { 0x21D4, wxT("dblarrowleft") },
  { 0x21D2, wxT("dblarrowright") },
  { 0x0965, wxT("dbldanda") },
  { 0xF6D6, wxT("dblgrave") },
  { 0x030F, wxT("dblgravecmb") },
  { 0x222C, wxT("dblintegral") },
  { 0x2017, wxT("dbllowline") },
  { 0x0333, wxT("dbllowlinecmb") },
  { 0x033F, wxT("dbloverlinecmb") },
  { 0x02BA, wxT("dblprimemod") },
  { 0x2016, wxT("dblverticalbar") },
  { 0x030E, wxT("dblverticallineabovecmb") },
  { 0x3109, wxT("dbopomofo") },
  { 0x33C8, wxT("dbsquare") },
  { 0x010F, wxT("dcaron") },
  { 0x1E11, wxT("dcedilla") },
  { 0x24D3, wxT("dcircle") },
  { 0x1E13, wxT("dcircumflexbelow") },
  { 0x0111, wxT("dcroat") },
  { 0x09A1, wxT("ddabengali") },
  { 0x0921, wxT("ddadeva") },
  { 0x0AA1, wxT("ddagujarati") },
  { 0x0A21, wxT("ddagurmukhi") },
  { 0x0688, wxT("ddalarabic") },
  { 0xFB89, wxT("ddalfinalarabic") },
  { 0x095C, wxT("dddhadeva") },
  { 0x09A2, wxT("ddhabengali") },
  { 0x0922, wxT("ddhadeva") },
  { 0x0AA2, wxT("ddhagujarati") },
  { 0x0A22, wxT("ddhagurmukhi") },
  { 0x1E0B, wxT("ddotaccent") },
  { 0x1E0D, wxT("ddotbelow") },
  { 0x066B, wxT("decimalseparatorarabic") },
  { 0x066B, wxT("decimalseparatorpersian") },
  { 0x0434, wxT("decyrillic") },
  { 0x00B0, wxT("degree") },
  { 0x05AD, wxT("dehihebrew") },
  { 0x3067, wxT("dehiragana") },
  { 0x03EF, wxT("deicoptic") },
  { 0x30C7, wxT("dekatakana") },
  { 0x232B, wxT("deleteleft") },
  { 0x2326, wxT("deleteright") },
  { 0x03B4, wxT("delta") },
  { 0x018D, wxT("deltaturned") },
  { 0x09F8, wxT("denominatorminusonenumeratorbengali") },
  { 0x02A4, wxT("dezh") },
  { 0x09A7, wxT("dhabengali") },
  { 0x0927, wxT("dhadeva") },
  { 0x0AA7, wxT("dhagujarati") },
  { 0x0A27, wxT("dhagurmukhi") },
  { 0x0257, wxT("dhook") },
  { 0x0385, wxT("dialytikatonos") },
  { 0x0344, wxT("dialytikatonoscmb") },
  { 0x2666, wxT("diamond") },
  { 0x2662, wxT("diamondsuitwhite") },
  { 0x00A8, wxT("dieresis") },
  { 0xF6D7, wxT("dieresisacute") },
  { 0x0324, wxT("dieresisbelowcmb") },
  { 0x0308, wxT("dieresiscmb") },
  { 0xF6D8, wxT("dieresisgrave") },
  { 0x0385, wxT("dieresistonos") },
  { 0x3062, wxT("dihiragana") },
  { 0x30C2, wxT("dikatakana") },
  { 0x3003, wxT("dittomark") },
  { 0x00F7, wxT("divide") },
  { 0x2223, wxT("divides") },
  { 0x2215, wxT("divisionslash") },
  { 0x0452, wxT("djecyrillic") },
  { 0x2593, wxT("dkshade") },
  { 0x1E0F, wxT("dlinebelow") },
  { 0x3397, wxT("dlsquare") },
  { 0x0111, wxT("dmacron") },
  { 0xFF44, wxT("dmonospace") },
  { 0x2584, wxT("dnblock") },
  { 0x0E0E, wxT("dochadathai") },
  { 0x0E14, wxT("dodekthai") },
  { 0x3069, wxT("dohiragana") },
  { 0x30C9, wxT("dokatakana") },
  { 0x0024, wxT("dollar") },
  { 0xF6E3, wxT("dollarinferior") },
  { 0xFF04, wxT("dollarmonospace") },
  { 0xF724, wxT("dollaroldstyle") },
  { 0xFE69, wxT("dollarsmall") },
  { 0xF6E4, wxT("dollarsuperior") },
  { 0x20AB, wxT("dong") },
  { 0x3326, wxT("dorusquare") },
  { 0x02D9, wxT("dotaccent") },
  { 0x0307, wxT("dotaccentcmb") },
  { 0x0323, wxT("dotbelowcmb") },
  { 0x0323, wxT("dotbelowcomb") },
  { 0x30FB, wxT("dotkatakana") },
  { 0x0131, wxT("dotlessi") },
  { 0xF6BE, wxT("dotlessj") },
  { 0x0284, wxT("dotlessjstrokehook") },
  { 0x22C5, wxT("dotmath") },
  { 0x25CC, wxT("dottedcircle") },
  { 0xFB1F, wxT("doubleyodpatah") },
  { 0xFB1F, wxT("doubleyodpatahhebrew") },
  { 0x031E, wxT("downtackbelowcmb") },
  { 0x02D5, wxT("downtackmod") },
  { 0x249F, wxT("dparen") },
  { 0xF6EB, wxT("dsuperior") },
  { 0x0256, wxT("dtail") },
  { 0x018C, wxT("dtopbar") },
  { 0x3065, wxT("duhiragana") },
  { 0x30C5, wxT("dukatakana") },
  { 0x01F3, wxT("dz") },
  { 0x02A3, wxT("dzaltone") },
  { 0x01C6, wxT("dzcaron") },
  { 0x02A5, wxT("dzcurl") },
  { 0x04E1, wxT("dzeabkhasiancyrillic") },
  { 0x0455, wxT("dzecyrillic") },
  { 0x045F, wxT("dzhecyrillic") },
  { 0x0065, wxT("e") },
  { 0x00E9, wxT("eacute") },
  { 0x2641, wxT("earth") },
  { 0x098F, wxT("ebengali") },
  { 0x311C, wxT("ebopomofo") },
  { 0x0115, wxT("ebreve") },
  { 0x090D, wxT("ecandradeva") },
  { 0x0A8D, wxT("ecandragujarati") },
  { 0x0945, wxT("ecandravowelsigndeva") },
  { 0x0AC5, wxT("ecandravowelsigngujarati") },
  { 0x011B, wxT("ecaron") },
  { 0x1E1D, wxT("ecedillabreve") },
  { 0x0565, wxT("echarmenian") },
  { 0x0587, wxT("echyiwnarmenian") },
  { 0x24D4, wxT("ecircle") },
  { 0x00EA, wxT("ecircumflex") },
  { 0x1EBF, wxT("ecircumflexacute") },
  { 0x1E19, wxT("ecircumflexbelow") },
  { 0x1EC7, wxT("ecircumflexdotbelow") },
  { 0x1EC1, wxT("ecircumflexgrave") },
  { 0x1EC3, wxT("ecircumflexhookabove") },
  { 0x1EC5, wxT("ecircumflextilde") },
  { 0x0454, wxT("ecyrillic") },
  { 0x0205, wxT("edblgrave") },
  { 0x090F, wxT("edeva") },
  { 0x00EB, wxT("edieresis") },
  { 0x0117, wxT("edot") },
  { 0x0117, wxT("edotaccent") },
  { 0x1EB9, wxT("edotbelow") },
  { 0x0A0F, wxT("eegurmukhi") },
  { 0x0A47, wxT("eematragurmukhi") },
  { 0x0444, wxT("efcyrillic") },
  { 0x00E8, wxT("egrave") },
  { 0x0A8F, wxT("egujarati") },
  { 0x0567, wxT("eharmenian") },
  { 0x311D, wxT("ehbopomofo") },
  { 0x3048, wxT("ehiragana") },
  { 0x1EBB, wxT("ehookabove") },
  { 0x311F, wxT("eibopomofo") },
  { 0x0038, wxT("eight") },
  { 0x0668, wxT("eightarabic") },
  { 0x09EE, wxT("eightbengali") },
  { 0x2467, wxT("eightcircle") },
  { 0x2791, wxT("eightcircleinversesansserif") },
  { 0x096E, wxT("eightdeva") },
  { 0x2471, wxT("eighteencircle") },
  { 0x2485, wxT("eighteenparen") },
  { 0x2499, wxT("eighteenperiod") },
  { 0x0AEE, wxT("eightgujarati") },
  { 0x0A6E, wxT("eightgurmukhi") },
  { 0x0668, wxT("eighthackarabic") },
  { 0x3028, wxT("eighthangzhou") },
  { 0x266B, wxT("eighthnotebeamed") },
  { 0x3227, wxT("eightideographicparen") },
  { 0x2088, wxT("eightinferior") },
  { 0xFF18, wxT("eightmonospace") },
  { 0xF738, wxT("eightoldstyle") },
  { 0x247B, wxT("eightparen") },
  { 0x248F, wxT("eightperiod") },
  { 0x06F8, wxT("eightpersian") },
  { 0x2177, wxT("eightroman") },
  { 0x2078, wxT("eightsuperior") },
  { 0x0E58, wxT("eightthai") },
  { 0x0207, wxT("einvertedbreve") },
  { 0x0465, wxT("eiotifiedcyrillic") },
  { 0x30A8, wxT("ekatakana") },
  { 0xFF74, wxT("ekatakanahalfwidth") },
  { 0x0A74, wxT("ekonkargurmukhi") },
  { 0x3154, wxT("ekorean") },
  { 0x043B, wxT("elcyrillic") },
  { 0x2208, wxT("element") },
  { 0x246A, wxT("elevencircle") },
  { 0x247E, wxT("elevenparen") },
  { 0x2492, wxT("elevenperiod") },
  { 0x217A, wxT("elevenroman") },
  { 0x2026, wxT("ellipsis") },
  { 0x22EE, wxT("ellipsisvertical") },
  { 0x0113, wxT("emacron") },
  { 0x1E17, wxT("emacronacute") },
  { 0x1E15, wxT("emacrongrave") },
  { 0x043C, wxT("emcyrillic") },
  { 0x2014, wxT("emdash") },
  { 0xFE31, wxT("emdashvertical") },
  { 0xFF45, wxT("emonospace") },
  { 0x055B, wxT("emphasismarkarmenian") },
  { 0x2205, wxT("emptyset") },
  { 0x3123, wxT("enbopomofo") },
  { 0x043D, wxT("encyrillic") },
  { 0x2013, wxT("endash") },
  { 0xFE32, wxT("endashvertical") },
  { 0x04A3, wxT("endescendercyrillic") },
  { 0x014B, wxT("eng") },
  { 0x3125, wxT("engbopomofo") },
  { 0x04A5, wxT("enghecyrillic") },
  { 0x04C8, wxT("enhookcyrillic") },
  { 0x2002, wxT("enspace") },
  { 0x0119, wxT("eogonek") },
  { 0x3153, wxT("eokorean") },
  { 0x025B, wxT("eopen") },
  { 0x029A, wxT("eopenclosed") },
  { 0x025C, wxT("eopenreversed") },
  { 0x025E, wxT("eopenreversedclosed") },
  { 0x025D, wxT("eopenreversedhook") },
  { 0x24A0, wxT("eparen") },
  { 0x03B5, wxT("epsilon") },
  { 0x03AD, wxT("epsilontonos") },
  { 0x003D, wxT("equal") },
  { 0xFF1D, wxT("equalmonospace") },
  { 0xFE66, wxT("equalsmall") },
  { 0x207C, wxT("equalsuperior") },
  { 0x2261, wxT("equivalence") },
  { 0x3126, wxT("erbopomofo") },
  { 0x0440, wxT("ercyrillic") },
  { 0x0258, wxT("ereversed") },
  { 0x044D, wxT("ereversedcyrillic") },
  { 0x0441, wxT("escyrillic") },
  { 0x04AB, wxT("esdescendercyrillic") },
  { 0x0283, wxT("esh") },
  { 0x0286, wxT("eshcurl") },
  { 0x090E, wxT("eshortdeva") },
  { 0x0946, wxT("eshortvowelsigndeva") },
  { 0x01AA, wxT("eshreversedloop") },
  { 0x0285, wxT("eshsquatreversed") },
  { 0x3047, wxT("esmallhiragana") },
  { 0x30A7, wxT("esmallkatakana") },
  { 0xFF6A, wxT("esmallkatakanahalfwidth") },
  { 0x212E, wxT("estimated") },
  { 0xF6EC, wxT("esuperior") },
  { 0x03B7, wxT("eta") },
  { 0x0568, wxT("etarmenian") },
  { 0x03AE, wxT("etatonos") },
  { 0x00F0, wxT("eth") },
  { 0x1EBD, wxT("etilde") },
  { 0x1E1B, wxT("etildebelow") },
  { 0x0591, wxT("etnahtafoukhhebrew") },
  { 0x0591, wxT("etnahtafoukhlefthebrew") },
  { 0x0591, wxT("etnahtahebrew") },
  { 0x0591, wxT("etnahtalefthebrew") },
  { 0x01DD, wxT("eturned") },
  { 0x3161, wxT("eukorean") },
  { 0x20AC, wxT("euro") },
  { 0x09C7, wxT("evowelsignbengali") },
  { 0x0947, wxT("evowelsigndeva") },
  { 0x0AC7, wxT("evowelsigngujarati") },
  { 0x0021, wxT("exclam") },
  { 0x055C, wxT("exclamarmenian") },
  { 0x203C, wxT("exclamdbl") },
  { 0x00A1, wxT("exclamdown") },
  { 0xF7A1, wxT("exclamdownsmall") },
  { 0xFF01, wxT("exclammonospace") },
  { 0xF721, wxT("exclamsmall") },
  { 0x2203, wxT("existential") },
  { 0x0292, wxT("ezh") },
  { 0x01EF, wxT("ezhcaron") },
  { 0x0293, wxT("ezhcurl") },
  { 0x01B9, wxT("ezhreversed") },
  { 0x01BA, wxT("ezhtail") },
  { 0x0066, wxT("f") },
  { 0x095E, wxT("fadeva") },
  { 0x0A5E, wxT("fagurmukhi") },
  { 0x2109, wxT("fahrenheit") },
  { 0x064E, wxT("fathaarabic") },
  { 0x064E, wxT("fathalowarabic") },
  { 0x064B, wxT("fathatanarabic") },
  { 0x3108, wxT("fbopomofo") },
  { 0x24D5, wxT("fcircle") },
  { 0x1E1F, wxT("fdotaccent") },
  { 0x0641, wxT("feharabic") },
  { 0x0586, wxT("feharmenian") },
  { 0xFED2, wxT("fehfinalarabic") },
  { 0xFED3, wxT("fehinitialarabic") },
  { 0xFED4, wxT("fehmedialarabic") },
  { 0x03E5, wxT("feicoptic") },
  { 0x2640, wxT("female") },
  { 0xFB00, wxT("ff") },
  { 0xFB03, wxT("ffi") },
  { 0xFB04, wxT("ffl") },
  { 0xFB01, wxT("fi") },
  { 0x246E, wxT("fifteencircle") },
  { 0x2482, wxT("fifteenparen") },
  { 0x2496, wxT("fifteenperiod") },
  { 0x2012, wxT("figuredash") },
  { 0x25A0, wxT("filledbox") },
  { 0x25AC, wxT("filledrect") },
  { 0x05DA, wxT("finalkaf") },
  { 0xFB3A, wxT("finalkafdagesh") },
  { 0xFB3A, wxT("finalkafdageshhebrew") },
  { 0x05DA, wxT("finalkafhebrew") },
  { 0x05DD, wxT("finalmem") },
  { 0x05DD, wxT("finalmemhebrew") },
  { 0x05DF, wxT("finalnun") },
  { 0x05DF, wxT("finalnunhebrew") },
  { 0x05E3, wxT("finalpe") },
  { 0x05E3, wxT("finalpehebrew") },
  { 0x05E5, wxT("finaltsadi") },
  { 0x05E5, wxT("finaltsadihebrew") },
  { 0x02C9, wxT("firsttonechinese") },
  { 0x25C9, wxT("fisheye") },
  { 0x0473, wxT("fitacyrillic") },
  { 0x0035, wxT("five") },
  { 0x0665, wxT("fivearabic") },
  { 0x09EB, wxT("fivebengali") },
  { 0x2464, wxT("fivecircle") },
  { 0x278E, wxT("fivecircleinversesansserif") },
  { 0x096B, wxT("fivedeva") },
  { 0x215D, wxT("fiveeighths") },
  { 0x0AEB, wxT("fivegujarati") },
  { 0x0A6B, wxT("fivegurmukhi") },
  { 0x0665, wxT("fivehackarabic") },
  { 0x3025, wxT("fivehangzhou") },
  { 0x3224, wxT("fiveideographicparen") },
  { 0x2085, wxT("fiveinferior") },
  { 0xFF15, wxT("fivemonospace") },
  { 0xF735, wxT("fiveoldstyle") },
  { 0x2478, wxT("fiveparen") },
  { 0x248C, wxT("fiveperiod") },
  { 0x06F5, wxT("fivepersian") },
  { 0x2174, wxT("fiveroman") },
  { 0x2075, wxT("fivesuperior") },
  { 0x0E55, wxT("fivethai") },
  { 0xFB02, wxT("fl") },
  { 0x0192, wxT("florin") },
  { 0xFF46, wxT("fmonospace") },
  { 0x3399, wxT("fmsquare") },
  { 0x0E1F, wxT("fofanthai") },
  { 0x0E1D, wxT("fofathai") },
  { 0x0E4F, wxT("fongmanthai") },
  { 0x2200, wxT("forall") },
  { 0x0034, wxT("four") },
  { 0x0664, wxT("fourarabic") },
  { 0x09EA, wxT("fourbengali") },
  { 0x2463, wxT("fourcircle") },
  { 0x278D, wxT("fourcircleinversesansserif") },
  { 0x096A, wxT("fourdeva") },
  { 0x0AEA, wxT("fourgujarati") },
  { 0x0A6A, wxT("fourgurmukhi") },
  { 0x0664, wxT("fourhackarabic") },
  { 0x3024, wxT("fourhangzhou") },
  { 0x3223, wxT("fourideographicparen") },
  { 0x2084, wxT("fourinferior") },
  { 0xFF14, wxT("fourmonospace") },
  { 0x09F7, wxT("fournumeratorbengali") },
  { 0xF734, wxT("fouroldstyle") },
  { 0x2477, wxT("fourparen") },
  { 0x248B, wxT("fourperiod") },
  { 0x06F4, wxT("fourpersian") },
  { 0x2173, wxT("fourroman") },
  { 0x2074, wxT("foursuperior") },
  { 0x246D, wxT("fourteencircle") },
  { 0x2481, wxT("fourteenparen") },
  { 0x2495, wxT("fourteenperiod") },
  { 0x0E54, wxT("fourthai") },
  { 0x02CB, wxT("fourthtonechinese") },
  { 0x24A1, wxT("fparen") },
  { 0x2044, wxT("fraction") },
  { 0x20A3, wxT("franc") },
  { 0x0067, wxT("g") },
  { 0x0997, wxT("gabengali") },
  { 0x01F5, wxT("gacute") },
  { 0x0917, wxT("gadeva") },
  { 0x06AF, wxT("gafarabic") },
  { 0xFB93, wxT("gaffinalarabic") },
  { 0xFB94, wxT("gafinitialarabic") },
  { 0xFB95, wxT("gafmedialarabic") },
  { 0x0A97, wxT("gagujarati") },
  { 0x0A17, wxT("gagurmukhi") },
  { 0x304C, wxT("gahiragana") },
  { 0x30AC, wxT("gakatakana") },
  { 0x03B3, wxT("gamma") },
  { 0x0263, wxT("gammalatinsmall") },
  { 0x02E0, wxT("gammasuperior") },
  { 0x03EB, wxT("gangiacoptic") },
  { 0x310D, wxT("gbopomofo") },
  { 0x011F, wxT("gbreve") },
  { 0x01E7, wxT("gcaron") },
  { 0x0123, wxT("gcedilla") },
  { 0x24D6, wxT("gcircle") },
  { 0x011D, wxT("gcircumflex") },
  { 0x0123, wxT("gcommaaccent") },
  { 0x0121, wxT("gdot") },
  { 0x0121, wxT("gdotaccent") },
  { 0x0433, wxT("gecyrillic") },
  { 0x3052, wxT("gehiragana") },
  { 0x30B2, wxT("gekatakana") },
  { 0x2251, wxT("geometricallyequal") },
  { 0x059C, wxT("gereshaccenthebrew") },
  { 0x05F3, wxT("gereshhebrew") },
  { 0x059D, wxT("gereshmuqdamhebrew") },
  { 0x00DF, wxT("germandbls") },
  { 0x059E, wxT("gershayimaccenthebrew") },
  { 0x05F4, wxT("gershayimhebrew") },
  { 0x3013, wxT("getamark") },
  { 0x0998, wxT("ghabengali") },
  { 0x0572, wxT("ghadarmenian") },
  { 0x0918, wxT("ghadeva") },
  { 0x0A98, wxT("ghagujarati") },
  { 0x0A18, wxT("ghagurmukhi") },
  { 0x063A, wxT("ghainarabic") },
  { 0xFECE, wxT("ghainfinalarabic") },
  { 0xFECF, wxT("ghaininitialarabic") },
  { 0xFED0, wxT("ghainmedialarabic") },
  { 0x0495, wxT("ghemiddlehookcyrillic") },
  { 0x0493, wxT("ghestrokecyrillic") },
  { 0x0491, wxT("gheupturncyrillic") },
  { 0x095A, wxT("ghhadeva") },
  { 0x0A5A, wxT("ghhagurmukhi") },
  { 0x0260, wxT("ghook") },
  { 0x3393, wxT("ghzsquare") },
  { 0x304E, wxT("gihiragana") },
  { 0x30AE, wxT("gikatakana") },
  { 0x0563, wxT("gimarmenian") },
  { 0x05D2, wxT("gimel") },
  { 0xFB32, wxT("gimeldagesh") },
  { 0xFB32, wxT("gimeldageshhebrew") },
  { 0x05D2, wxT("gimelhebrew") },
  { 0x0453, wxT("gjecyrillic") },
  { 0x01BE, wxT("glottalinvertedstroke") },
  { 0x0294, wxT("glottalstop") },
  { 0x0296, wxT("glottalstopinverted") },
  { 0x02C0, wxT("glottalstopmod") },
  { 0x0295, wxT("glottalstopreversed") },
  { 0x02C1, wxT("glottalstopreversedmod") },
  { 0x02E4, wxT("glottalstopreversedsuperior") },
  { 0x02A1, wxT("glottalstopstroke") },
  { 0x02A2, wxT("glottalstopstrokereversed") },
  { 0x1E21, wxT("gmacron") },
  { 0xFF47, wxT("gmonospace") },
  { 0x3054, wxT("gohiragana") },
  { 0x30B4, wxT("gokatakana") },
  { 0x24A2, wxT("gparen") },
  { 0x33AC, wxT("gpasquare") },
  { 0x2207, wxT("gradient") },
  { 0x0060, wxT("grave") },
  { 0x0316, wxT("gravebelowcmb") },
  { 0x0300, wxT("gravecmb") },
  { 0x0300, wxT("gravecomb") },
  { 0x0953, wxT("gravedeva") },
  { 0x02CE, wxT("gravelowmod") },
  { 0xFF40, wxT("gravemonospace") },
  { 0x0340, wxT("gravetonecmb") },
  { 0x003E, wxT("greater") },
  { 0x2265, wxT("greaterequal") },
  { 0x22DB, wxT("greaterequalorless") },
  { 0xFF1E, wxT("greatermonospace") },
  { 0x2273, wxT("greaterorequivalent") },
  { 0x2277, wxT("greaterorless") },
  { 0x2267, wxT("greateroverequal") },
  { 0xFE65, wxT("greatersmall") },
  { 0x0261, wxT("gscript") },
  { 0x01E5, wxT("gstroke") },
  { 0x3050, wxT("guhiragana") },
  { 0x00AB, wxT("guillemotleft") },
  { 0x00BB, wxT("guillemotright") },
  { 0x2039, wxT("guilsinglleft") },
  { 0x203A, wxT("guilsinglright") },
  { 0x30B0, wxT("gukatakana") },
  { 0x3318, wxT("guramusquare") },
  { 0x33C9, wxT("gysquare") },
  { 0x0068, wxT("h") },
  { 0x04A9, wxT("haabkhasiancyrillic") },
  { 0x06C1, wxT("haaltonearabic") },
  { 0x09B9, wxT("habengali") },
  { 0x04B3, wxT("hadescendercyrillic") },
  { 0x0939, wxT("hadeva") },
  { 0x0AB9, wxT("hagujarati") },
  { 0x0A39, wxT("hagurmukhi") },
  { 0x062D, wxT("haharabic") },
  { 0xFEA2, wxT("hahfinalarabic") },
  { 0xFEA3, wxT("hahinitialarabic") },
  { 0x306F, wxT("hahiragana") },
  { 0xFEA4, wxT("hahmedialarabic") },
  { 0x332A, wxT("haitusquare") },
  { 0x30CF, wxT("hakatakana") },
  { 0xFF8A, wxT("hakatakanahalfwidth") },
  { 0x0A4D, wxT("halantgurmukhi") },
  { 0x0621, wxT("hamzaarabic") },
  { 0x0621, wxT("hamzalowarabic") },
  { 0x3164, wxT("hangulfiller") },
  { 0x044A, wxT("hardsigncyrillic") },
  { 0x21BC, wxT("harpoonleftbarbup") },
  { 0x21C0, wxT("harpoonrightbarbup") },
  { 0x33CA, wxT("hasquare") },
  { 0x05B2, wxT("hatafpatah") },
  { 0x05B2, wxT("hatafpatah16") },
  { 0x05B2, wxT("hatafpatah23") },
  { 0x05B2, wxT("hatafpatah2f") },
  { 0x05B2, wxT("hatafpatahhebrew") },
  { 0x05B2, wxT("hatafpatahnarrowhebrew") },
  { 0x05B2, wxT("hatafpatahquarterhebrew") },
  { 0x05B2, wxT("hatafpatahwidehebrew") },
  { 0x05B3, wxT("hatafqamats") },
  { 0x05B3, wxT("hatafqamats1b") },
  { 0x05B3, wxT("hatafqamats28") },
  { 0x05B3, wxT("hatafqamats34") },
  { 0x05B3, wxT("hatafqamatshebrew") },
  { 0x05B3, wxT("hatafqamatsnarrowhebrew") },
  { 0x05B3, wxT("hatafqamatsquarterhebrew") },
  { 0x05B3, wxT("hatafqamatswidehebrew") },
  { 0x05B1, wxT("hatafsegol") },
  { 0x05B1, wxT("hatafsegol17") },
  { 0x05B1, wxT("hatafsegol24") },
  { 0x05B1, wxT("hatafsegol30") },
  { 0x05B1, wxT("hatafsegolhebrew") },
  { 0x05B1, wxT("hatafsegolnarrowhebrew") },
  { 0x05B1, wxT("hatafsegolquarterhebrew") },
  { 0x05B1, wxT("hatafsegolwidehebrew") },
  { 0x0127, wxT("hbar") },
  { 0x310F, wxT("hbopomofo") },
  { 0x1E2B, wxT("hbrevebelow") },
  { 0x1E29, wxT("hcedilla") },
  { 0x24D7, wxT("hcircle") },
  { 0x0125, wxT("hcircumflex") },
  { 0x1E27, wxT("hdieresis") },
  { 0x1E23, wxT("hdotaccent") },
  { 0x1E25, wxT("hdotbelow") },
  { 0x05D4, wxT("he") },
  { 0x2665, wxT("heart") },
  { 0x2665, wxT("heartsuitblack") },
  { 0x2661, wxT("heartsuitwhite") },
  { 0xFB34, wxT("hedagesh") },
  { 0xFB34, wxT("hedageshhebrew") },
  { 0x06C1, wxT("hehaltonearabic") },
  { 0x0647, wxT("heharabic") },
  { 0x05D4, wxT("hehebrew") },
  { 0xFBA7, wxT("hehfinalaltonearabic") },
  { 0xFEEA, wxT("hehfinalalttwoarabic") },
  { 0xFEEA, wxT("hehfinalarabic") },
  { 0xFBA5, wxT("hehhamzaabovefinalarabic") },
  { 0xFBA4, wxT("hehhamzaaboveisolatedarabic") },
  { 0xFBA8, wxT("hehinitialaltonearabic") },
  { 0xFEEB, wxT("hehinitialarabic") },
  { 0x3078, wxT("hehiragana") },
  { 0xFBA9, wxT("hehmedialaltonearabic") },
  { 0xFEEC, wxT("hehmedialarabic") },
  { 0x337B, wxT("heiseierasquare") },
  { 0x30D8, wxT("hekatakana") },
  { 0xFF8D, wxT("hekatakanahalfwidth") },
  { 0x3336, wxT("hekutaarusquare") },
  { 0x0267, wxT("henghook") },
  { 0x3339, wxT("herutusquare") },
  { 0x05D7, wxT("het") },
  { 0x05D7, wxT("hethebrew") },
  { 0x0266, wxT("hhook") },
  { 0x02B1, wxT("hhooksuperior") },
  { 0x327B, wxT("hieuhacirclekorean") },
  { 0x321B, wxT("hieuhaparenkorean") },
  { 0x326D, wxT("hieuhcirclekorean") },
  { 0x314E, wxT("hieuhkorean") },
  { 0x320D, wxT("hieuhparenkorean") },
  { 0x3072, wxT("hihiragana") },
  { 0x30D2, wxT("hikatakana") },
  { 0xFF8B, wxT("hikatakanahalfwidth") },
  { 0x05B4, wxT("hiriq") },
  { 0x05B4, wxT("hiriq14") },
  { 0x05B4, wxT("hiriq21") },
  { 0x05B4, wxT("hiriq2d") },
  { 0x05B4, wxT("hiriqhebrew") },
  { 0x05B4, wxT("hiriqnarrowhebrew") },
  { 0x05B4, wxT("hiriqquarterhebrew") },
  { 0x05B4, wxT("hiriqwidehebrew") },
  { 0x1E96, wxT("hlinebelow") },
  { 0xFF48, wxT("hmonospace") },
  { 0x0570, wxT("hoarmenian") },
  { 0x0E2B, wxT("hohipthai") },
  { 0x307B, wxT("hohiragana") },
  { 0x30DB, wxT("hokatakana") },
  { 0xFF8E, wxT("hokatakanahalfwidth") },
  { 0x05B9, wxT("holam") },
  { 0x05B9, wxT("holam19") },
  { 0x05B9, wxT("holam26") },
  { 0x05B9, wxT("holam32") },
  { 0x05B9, wxT("holamhebrew") },
  { 0x05B9, wxT("holamnarrowhebrew") },
  { 0x05B9, wxT("holamquarterhebrew") },
  { 0x05B9, wxT("holamwidehebrew") },
  { 0x0E2E, wxT("honokhukthai") },
  { 0x0309, wxT("hookabovecomb") },
  { 0x0309, wxT("hookcmb") },
  { 0x0321, wxT("hookpalatalizedbelowcmb") },
  { 0x0322, wxT("hookretroflexbelowcmb") },
  { 0x3342, wxT("hoonsquare") },
  { 0x03E9, wxT("horicoptic") },
  { 0x2015, wxT("horizontalbar") },
  { 0x031B, wxT("horncmb") },
  { 0x2668, wxT("hotsprings") },
  { 0x2302, wxT("house") },
  { 0x24A3, wxT("hparen") },
  { 0x02B0, wxT("hsuperior") },
  { 0x0265, wxT("hturned") },
  { 0x3075, wxT("huhiragana") },
  { 0x3333, wxT("huiitosquare") },
  { 0x30D5, wxT("hukatakana") },
  { 0xFF8C, wxT("hukatakanahalfwidth") },
  { 0x02DD, wxT("hungarumlaut") },
  { 0x030B, wxT("hungarumlautcmb") },
  { 0x0195, wxT("hv") },
  { 0x002D, wxT("hyphen") },
  { 0xF6E5, wxT("hypheninferior") },
  { 0xFF0D, wxT("hyphenmonospace") },
  { 0xFE63, wxT("hyphensmall") },
  { 0xF6E6, wxT("hyphensuperior") },
  { 0x2010, wxT("hyphentwo") },
  { 0x0069, wxT("i") },
  { 0x00ED, wxT("iacute") },
  { 0x044F, wxT("iacyrillic") },
  { 0x0987, wxT("ibengali") },
  { 0x3127, wxT("ibopomofo") },
  { 0x012D, wxT("ibreve") },
  { 0x01D0, wxT("icaron") },
  { 0x24D8, wxT("icircle") },
  { 0x00EE, wxT("icircumflex") },
  { 0x0456, wxT("icyrillic") },
  { 0x0209, wxT("idblgrave") },
  { 0x328F, wxT("ideographearthcircle") },
  { 0x328B, wxT("ideographfirecircle") },
  { 0x323F, wxT("ideographicallianceparen") },
  { 0x323A, wxT("ideographiccallparen") },
  { 0x32A5, wxT("ideographiccentrecircle") },
  { 0x3006, wxT("ideographicclose") },
  { 0x3001, wxT("ideographiccomma") },
  { 0xFF64, wxT("ideographiccommaleft") },
  { 0x3237, wxT("ideographiccongratulationparen") },
  { 0x32A3, wxT("ideographiccorrectcircle") },
  { 0x322F, wxT("ideographicearthparen") },
  { 0x323D, wxT("ideographicenterpriseparen") },
  { 0x329D, wxT("ideographicexcellentcircle") },
  { 0x3240, wxT("ideographicfestivalparen") },
  { 0x3296, wxT("ideographicfinancialcircle") },
  { 0x3236, wxT("ideographicfinancialparen") },
  { 0x322B, wxT("ideographicfireparen") },
  { 0x3232, wxT("ideographichaveparen") },
  { 0x32A4, wxT("ideographichighcircle") },
  { 0x3005, wxT("ideographiciterationmark") },
  { 0x3298, wxT("ideographiclaborcircle") },
  { 0x3238, wxT("ideographiclaborparen") },
  { 0x32A7, wxT("ideographicleftcircle") },
  { 0x32A6, wxT("ideographiclowcircle") },
  { 0x32A9, wxT("ideographicmedicinecircle") },
  { 0x322E, wxT("ideographicmetalparen") },
  { 0x322A, wxT("ideographicmoonparen") },
  { 0x3234, wxT("ideographicnameparen") },
  { 0x3002, wxT("ideographicperiod") },
  { 0x329E, wxT("ideographicprintcircle") },
  { 0x3243, wxT("ideographicreachparen") },
  { 0x3239, wxT("ideographicrepresentparen") },
  { 0x323E, wxT("ideographicresourceparen") },
  { 0x32A8, wxT("ideographicrightcircle") },
  { 0x3299, wxT("ideographicsecretcircle") },
  { 0x3242, wxT("ideographicselfparen") },
  { 0x3233, wxT("ideographicsocietyparen") },
  { 0x3000, wxT("ideographicspace") },
  { 0x3235, wxT("ideographicspecialparen") },
  { 0x3231, wxT("ideographicstockparen") },
  { 0x323B, wxT("ideographicstudyparen") },
  { 0x3230, wxT("ideographicsunparen") },
  { 0x323C, wxT("ideographicsuperviseparen") },
  { 0x322C, wxT("ideographicwaterparen") },
  { 0x322D, wxT("ideographicwoodparen") },
  { 0x3007, wxT("ideographiczero") },
  { 0x328E, wxT("ideographmetalcircle") },
  { 0x328A, wxT("ideographmooncircle") },
  { 0x3294, wxT("ideographnamecircle") },
  { 0x3290, wxT("ideographsuncircle") },
  { 0x328C, wxT("ideographwatercircle") },
  { 0x328D, wxT("ideographwoodcircle") },
  { 0x0907, wxT("ideva") },
  { 0x00EF, wxT("idieresis") },
  { 0x1E2F, wxT("idieresisacute") },
  { 0x04E5, wxT("idieresiscyrillic") },
  { 0x1ECB, wxT("idotbelow") },
  { 0x04D7, wxT("iebrevecyrillic") },
  { 0x0435, wxT("iecyrillic") },
  { 0x3275, wxT("ieungacirclekorean") },
  { 0x3215, wxT("ieungaparenkorean") },
  { 0x3267, wxT("ieungcirclekorean") },
  { 0x3147, wxT("ieungkorean") },
  { 0x3207, wxT("ieungparenkorean") },
  { 0x00EC, wxT("igrave") },
  { 0x0A87, wxT("igujarati") },
  { 0x0A07, wxT("igurmukhi") },
  { 0x3044, wxT("ihiragana") },
  { 0x1EC9, wxT("ihookabove") },
  { 0x0988, wxT("iibengali") },
  { 0x0438, wxT("iicyrillic") },
  { 0x0908, wxT("iideva") },
  { 0x0A88, wxT("iigujarati") },
  { 0x0A08, wxT("iigurmukhi") },
  { 0x0A40, wxT("iimatragurmukhi") },
  { 0x020B, wxT("iinvertedbreve") },
  { 0x0439, wxT("iishortcyrillic") },
  { 0x09C0, wxT("iivowelsignbengali") },
  { 0x0940, wxT("iivowelsigndeva") },
  { 0x0AC0, wxT("iivowelsigngujarati") },
  { 0x0133, wxT("ij") },
  { 0x30A4, wxT("ikatakana") },
  { 0xFF72, wxT("ikatakanahalfwidth") },
  { 0x3163, wxT("ikorean") },
  { 0x02DC, wxT("ilde") },
  { 0x05AC, wxT("iluyhebrew") },
  { 0x012B, wxT("imacron") },
  { 0x04E3, wxT("imacroncyrillic") },
  { 0x2253, wxT("imageorapproximatelyequal") },
  { 0x0A3F, wxT("imatragurmukhi") },
  { 0xFF49, wxT("imonospace") },
  { 0x2206, wxT("increment") },
  { 0x221E, wxT("infinity") },
  { 0x056B, wxT("iniarmenian") },
  { 0x222B, wxT("integral") },
  { 0x2321, wxT("integralbottom") },
  { 0x2321, wxT("integralbt") },
  { 0xF8F5, wxT("integralex") },
  { 0x2320, wxT("integraltop") },
  { 0x2320, wxT("integraltp") },
  { 0x2229, wxT("intersection") },
  { 0x3305, wxT("intisquare") },
  { 0x25D8, wxT("invbullet") },
  { 0x25D9, wxT("invcircle") },
  { 0x263B, wxT("invsmileface") },
  { 0x0451, wxT("iocyrillic") },
  { 0x012F, wxT("iogonek") },
  { 0x03B9, wxT("iota") },
  { 0x03CA, wxT("iotadieresis") },
  { 0x0390, wxT("iotadieresistonos") },
  { 0x0269, wxT("iotalatin") },
  { 0x03AF, wxT("iotatonos") },
  { 0x24A4, wxT("iparen") },
  { 0x0A72, wxT("irigurmukhi") },
  { 0x3043, wxT("ismallhiragana") },
  { 0x30A3, wxT("ismallkatakana") },
  { 0xFF68, wxT("ismallkatakanahalfwidth") },
  { 0x09FA, wxT("issharbengali") },
  { 0x0268, wxT("istroke") },
  { 0xF6ED, wxT("isuperior") },
  { 0x309D, wxT("iterationhiragana") },
  { 0x30FD, wxT("iterationkatakana") },
  { 0x0129, wxT("itilde") },
  { 0x1E2D, wxT("itildebelow") },
  { 0x3129, wxT("iubopomofo") },
  { 0x044E, wxT("iucyrillic") },
  { 0x09BF, wxT("ivowelsignbengali") },
  { 0x093F, wxT("ivowelsigndeva") },
  { 0x0ABF, wxT("ivowelsigngujarati") },
  { 0x0475, wxT("izhitsacyrillic") },
  { 0x0477, wxT("izhitsadblgravecyrillic") },
  { 0x006A, wxT("j") },
  { 0x0571, wxT("jaarmenian") },
  { 0x099C, wxT("jabengali") },
  { 0x091C, wxT("jadeva") },
  { 0x0A9C, wxT("jagujarati") },
  { 0x0A1C, wxT("jagurmukhi") },
  { 0x3110, wxT("jbopomofo") },
  { 0x01F0, wxT("jcaron") },
  { 0x24D9, wxT("jcircle") },
  { 0x0135, wxT("jcircumflex") },
  { 0x029D, wxT("jcrossedtail") },
  { 0x025F, wxT("jdotlessstroke") },
  { 0x0458, wxT("jecyrillic") },
  { 0x062C, wxT("jeemarabic") },
  { 0xFE9E, wxT("jeemfinalarabic") },
  { 0xFE9F, wxT("jeeminitialarabic") },
  { 0xFEA0, wxT("jeemmedialarabic") },
  { 0x0698, wxT("jeharabic") },
  { 0xFB8B, wxT("jehfinalarabic") },
  { 0x099D, wxT("jhabengali") },
  { 0x091D, wxT("jhadeva") },
  { 0x0A9D, wxT("jhagujarati") },
  { 0x0A1D, wxT("jhagurmukhi") },
  { 0x057B, wxT("jheharmenian") },
  { 0x3004, wxT("jis") },
  { 0xFF4A, wxT("jmonospace") },
  { 0x24A5, wxT("jparen") },
  { 0x02B2, wxT("jsuperior") },
  { 0x006B, wxT("k") },
  { 0x04A1, wxT("kabashkircyrillic") },
  { 0x0995, wxT("kabengali") },
  { 0x1E31, wxT("kacute") },
  { 0x043A, wxT("kacyrillic") },
  { 0x049B, wxT("kadescendercyrillic") },
  { 0x0915, wxT("kadeva") },
  { 0x05DB, wxT("kaf") },
  { 0x0643, wxT("kafarabic") },
  { 0xFB3B, wxT("kafdagesh") },
  { 0xFB3B, wxT("kafdageshhebrew") },
  { 0xFEDA, wxT("kaffinalarabic") },
  { 0x05DB, wxT("kafhebrew") },
  { 0xFEDB, wxT("kafinitialarabic") },
  { 0xFEDC, wxT("kafmedialarabic") },
  { 0xFB4D, wxT("kafrafehebrew") },
  { 0x0A95, wxT("kagujarati") },
  { 0x0A15, wxT("kagurmukhi") },
  { 0x304B, wxT("kahiragana") },
  { 0x04C4, wxT("kahookcyrillic") },
  { 0x30AB, wxT("kakatakana") },
  { 0xFF76, wxT("kakatakanahalfwidth") },
  { 0x03BA, wxT("kappa") },
  { 0x03F0, wxT("kappasymbolgreek") },
  { 0x3171, wxT("kapyeounmieumkorean") },
  { 0x3184, wxT("kapyeounphieuphkorean") },
  { 0x3178, wxT("kapyeounpieupkorean") },
  { 0x3179, wxT("kapyeounssangpieupkorean") },
  { 0x330D, wxT("karoriisquare") },
  { 0x0640, wxT("kashidaautoarabic") },
  { 0x0640, wxT("kashidaautonosidebearingarabic") },
  { 0x30F5, wxT("kasmallkatakana") },
  { 0x3384, wxT("kasquare") },
  { 0x0650, wxT("kasraarabic") },
  { 0x064D, wxT("kasratanarabic") },
  { 0x049F, wxT("kastrokecyrillic") },
  { 0xFF70, wxT("katahiraprolongmarkhalfwidth") },
  { 0x049D, wxT("kaverticalstrokecyrillic") },
  { 0x310E, wxT("kbopomofo") },
  { 0x3389, wxT("kcalsquare") },
  { 0x01E9, wxT("kcaron") },
  { 0x0137, wxT("kcedilla") },
  { 0x24DA, wxT("kcircle") },
  { 0x0137, wxT("kcommaaccent") },
  { 0x1E33, wxT("kdotbelow") },
  { 0x0584, wxT("keharmenian") },
  { 0x3051, wxT("kehiragana") },
  { 0x30B1, wxT("kekatakana") },
  { 0xFF79, wxT("kekatakanahalfwidth") },
  { 0x056F, wxT("kenarmenian") },
  { 0x30F6, wxT("kesmallkatakana") },
  { 0x0138, wxT("kgreenlandic") },
  { 0x0996, wxT("khabengali") },
  { 0x0445, wxT("khacyrillic") },
  { 0x0916, wxT("khadeva") },
  { 0x0A96, wxT("khagujarati") },
  { 0x0A16, wxT("khagurmukhi") },
  { 0x062E, wxT("khaharabic") },
  { 0xFEA6, wxT("khahfinalarabic") },
  { 0xFEA7, wxT("khahinitialarabic") },
  { 0xFEA8, wxT("khahmedialarabic") },
  { 0x03E7, wxT("kheicoptic") },
  { 0x0959, wxT("khhadeva") },
  { 0x0A59, wxT("khhagurmukhi") },
  { 0x3278, wxT("khieukhacirclekorean") },
  { 0x3218, wxT("khieukhaparenkorean") },
  { 0x326A, wxT("khieukhcirclekorean") },
  { 0x314B, wxT("khieukhkorean") },
  { 0x320A, wxT("khieukhparenkorean") },
  { 0x0E02, wxT("khokhaithai") },
  { 0x0E05, wxT("khokhonthai") },
  { 0x0E03, wxT("khokhuatthai") },
  { 0x0E04, wxT("khokhwaithai") },
  { 0x0E5B, wxT("khomutthai") },
  { 0x0199, wxT("khook") },
  { 0x0E06, wxT("khorakhangthai") },
  { 0x3391, wxT("khzsquare") },
  { 0x304D, wxT("kihiragana") },
  { 0x30AD, wxT("kikatakana") },
  { 0xFF77, wxT("kikatakanahalfwidth") },
  { 0x3315, wxT("kiroguramusquare") },
  { 0x3316, wxT("kiromeetorusquare") },
  { 0x3314, wxT("kirosquare") },
  { 0x326E, wxT("kiyeokacirclekorean") },
  { 0x320E, wxT("kiyeokaparenkorean") },
  { 0x3260, wxT("kiyeokcirclekorean") },
  { 0x3131, wxT("kiyeokkorean") },
  { 0x3200, wxT("kiyeokparenkorean") },
  { 0x3133, wxT("kiyeoksioskorean") },
  { 0x045C, wxT("kjecyrillic") },
  { 0x1E35, wxT("klinebelow") },
  { 0x3398, wxT("klsquare") },
  { 0x33A6, wxT("kmcubedsquare") },
  { 0xFF4B, wxT("kmonospace") },
  { 0x33A2, wxT("kmsquaredsquare") },
  { 0x3053, wxT("kohiragana") },
  { 0x33C0, wxT("kohmsquare") },
  { 0x0E01, wxT("kokaithai") },
  { 0x30B3, wxT("kokatakana") },
  { 0xFF7A, wxT("kokatakanahalfwidth") },
  { 0x331E, wxT("kooposquare") },
  { 0x0481, wxT("koppacyrillic") },
  { 0x327F, wxT("koreanstandardsymbol") },
  { 0x0343, wxT("koroniscmb") },
  { 0x24A6, wxT("kparen") },
  { 0x33AA, wxT("kpasquare") },
  { 0x046F, wxT("ksicyrillic") },
  { 0x33CF, wxT("ktsquare") },
  { 0x029E, wxT("kturned") },
  { 0x304F, wxT("kuhiragana") },
  { 0x30AF, wxT("kukatakana") },
  { 0xFF78, wxT("kukatakanahalfwidth") },
  { 0x33B8, wxT("kvsquare") },
  { 0x33BE, wxT("kwsquare") },
  { 0x006C, wxT("l") },
  { 0x09B2, wxT("labengali") },
  { 0x013A, wxT("lacute") },
  { 0x0932, wxT("ladeva") },
  { 0x0AB2, wxT("lagujarati") },
  { 0x0A32, wxT("lagurmukhi") },
  { 0x0E45, wxT("lakkhangyaothai") },
  { 0xFEFC, wxT("lamaleffinalarabic") },
  { 0xFEF8, wxT("lamalefhamzaabovefinalarabic") },
  { 0xFEF7, wxT("lamalefhamzaaboveisolatedarabic") },
  { 0xFEFA, wxT("lamalefhamzabelowfinalarabic") },
  { 0xFEF9, wxT("lamalefhamzabelowisolatedarabic") },
  { 0xFEFB, wxT("lamalefisolatedarabic") },
  { 0xFEF6, wxT("lamalefmaddaabovefinalarabic") },
  { 0xFEF5, wxT("lamalefmaddaaboveisolatedarabic") },
  { 0x0644, wxT("lamarabic") },
  { 0x03BB, wxT("lambda") },
  { 0x019B, wxT("lambdastroke") },
  { 0x05DC, wxT("lamed") },
  { 0xFB3C, wxT("lameddagesh") },
  { 0xFB3C, wxT("lameddageshhebrew") },
  { 0x05DC, wxT("lamedhebrew") },
  { 0xFEDE, wxT("lamfinalarabic") },
  { 0xFCCA, wxT("lamhahinitialarabic") },
  { 0xFEDF, wxT("laminitialarabic") },
  { 0xFCC9, wxT("lamjeeminitialarabic") },
  { 0xFCCB, wxT("lamkhahinitialarabic") },
  { 0xFDF2, wxT("lamlamhehisolatedarabic") },
  { 0xFEE0, wxT("lammedialarabic") },
  { 0xFD88, wxT("lammeemhahinitialarabic") },
  { 0xFCCC, wxT("lammeeminitialarabic") },
  { 0x25EF, wxT("largecircle") },
  { 0x019A, wxT("lbar") },
  { 0x026C, wxT("lbelt") },
  { 0x310C, wxT("lbopomofo") },
  { 0x013E, wxT("lcaron") },
  { 0x013C, wxT("lcedilla") },
  { 0x24DB, wxT("lcircle") },
  { 0x1E3D, wxT("lcircumflexbelow") },
  { 0x013C, wxT("lcommaaccent") },
  { 0x0140, wxT("ldot") },
  { 0x0140, wxT("ldotaccent") },
  { 0x1E37, wxT("ldotbelow") },
  { 0x1E39, wxT("ldotbelowmacron") },
  { 0x031A, wxT("leftangleabovecmb") },
  { 0x0318, wxT("lefttackbelowcmb") },
  { 0x003C, wxT("less") },
  { 0x2264, wxT("lessequal") },
  { 0x22DA, wxT("lessequalorgreater") },
  { 0xFF1C, wxT("lessmonospace") },
  { 0x2272, wxT("lessorequivalent") },
  { 0x2276, wxT("lessorgreater") },
  { 0x2266, wxT("lessoverequal") },
  { 0xFE64, wxT("lesssmall") },
  { 0x026E, wxT("lezh") },
  { 0x258C, wxT("lfblock") },
  { 0x026D, wxT("lhookretroflex") },
  { 0x20A4, wxT("lira") },
  { 0x056C, wxT("liwnarmenian") },
  { 0x01C9, wxT("lj") },
  { 0x0459, wxT("ljecyrillic") },
  { 0xF6C0, wxT("ll") },
  { 0x0933, wxT("lladeva") },
  { 0x0AB3, wxT("llagujarati") },
  { 0x1E3B, wxT("llinebelow") },
  { 0x0934, wxT("llladeva") },
  { 0x09E1, wxT("llvocalicbengali") },
  { 0x0961, wxT("llvocalicdeva") },
  { 0x09E3, wxT("llvocalicvowelsignbengali") },
  { 0x0963, wxT("llvocalicvowelsigndeva") },
  { 0x026B, wxT("lmiddletilde") },
  { 0xFF4C, wxT("lmonospace") },
  { 0x33D0, wxT("lmsquare") },
  { 0x0E2C, wxT("lochulathai") },
  { 0x2227, wxT("logicaland") },
  { 0x00AC, wxT("logicalnot") },
  { 0x2310, wxT("logicalnotreversed") },
  { 0x2228, wxT("logicalor") },
  { 0x0E25, wxT("lolingthai") },
  { 0x017F, wxT("longs") },
  { 0xFE4E, wxT("lowlinecenterline") },
  { 0x0332, wxT("lowlinecmb") },
  { 0xFE4D, wxT("lowlinedashed") },
  { 0x25CA, wxT("lozenge") },
  { 0x24A7, wxT("lparen") },
  { 0x0142, wxT("lslash") },
  { 0x2113, wxT("lsquare") },
  { 0xF6EE, wxT("lsuperior") },
  { 0x2591, wxT("ltshade") },
  { 0x0E26, wxT("luthai") },
  { 0x098C, wxT("lvocalicbengali") },
  { 0x090C, wxT("lvocalicdeva") },
  { 0x09E2, wxT("lvocalicvowelsignbengali") },
  { 0x0962, wxT("lvocalicvowelsigndeva") },
  { 0x33D3, wxT("lxsquare") },
  { 0x006D, wxT("m") },
  { 0x09AE, wxT("mabengali") },
  { 0x00AF, wxT("macron") },
  { 0x0331, wxT("macronbelowcmb") },
  { 0x0304, wxT("macroncmb") },
  { 0x02CD, wxT("macronlowmod") },
  { 0xFFE3, wxT("macronmonospace") },
  { 0x1E3F, wxT("macute") },
  { 0x092E, wxT("madeva") },
  { 0x0AAE, wxT("magujarati") },
  { 0x0A2E, wxT("magurmukhi") },
  { 0x05A4, wxT("mahapakhhebrew") },
  { 0x05A4, wxT("mahapakhlefthebrew") },
  { 0x307E, wxT("mahiragana") },
  { 0xF895, wxT("maichattawalowleftthai") },
  { 0xF894, wxT("maichattawalowrightthai") },
  { 0x0E4B, wxT("maichattawathai") },
  { 0xF893, wxT("maichattawaupperleftthai") },
  { 0xF88C, wxT("maieklowleftthai") },
  { 0xF88B, wxT("maieklowrightthai") },
  { 0x0E48, wxT("maiekthai") },
  { 0xF88A, wxT("maiekupperleftthai") },
  { 0xF884, wxT("maihanakatleftthai") },
  { 0x0E31, wxT("maihanakatthai") },
  { 0xF889, wxT("maitaikhuleftthai") },
  { 0x0E47, wxT("maitaikhuthai") },
  { 0xF88F, wxT("maitholowleftthai") },
  { 0xF88E, wxT("maitholowrightthai") },
  { 0x0E49, wxT("maithothai") },
  { 0xF88D, wxT("maithoupperleftthai") },
  { 0xF892, wxT("maitrilowleftthai") },
  { 0xF891, wxT("maitrilowrightthai") },
  { 0x0E4A, wxT("maitrithai") },
  { 0xF890, wxT("maitriupperleftthai") },
  { 0x0E46, wxT("maiyamokthai") },
  { 0x30DE, wxT("makatakana") },
  { 0xFF8F, wxT("makatakanahalfwidth") },
  { 0x2642, wxT("male") },
  { 0x3347, wxT("mansyonsquare") },
  { 0x05BE, wxT("maqafhebrew") },
  { 0x2642, wxT("mars") },
  { 0x05AF, wxT("masoracirclehebrew") },
  { 0x3383, wxT("masquare") },
  { 0x3107, wxT("mbopomofo") },
  { 0x33D4, wxT("mbsquare") },
  { 0x24DC, wxT("mcircle") },
  { 0x33A5, wxT("mcubedsquare") },
  { 0x1E41, wxT("mdotaccent") },
  { 0x1E43, wxT("mdotbelow") },
  { 0x0645, wxT("meemarabic") },
  { 0xFEE2, wxT("meemfinalarabic") },
  { 0xFEE3, wxT("meeminitialarabic") },
  { 0xFEE4, wxT("meemmedialarabic") },
  { 0xFCD1, wxT("meemmeeminitialarabic") },
  { 0xFC48, wxT("meemmeemisolatedarabic") },
  { 0x334D, wxT("meetorusquare") },
  { 0x3081, wxT("mehiragana") },
  { 0x337E, wxT("meizierasquare") },
  { 0x30E1, wxT("mekatakana") },
  { 0xFF92, wxT("mekatakanahalfwidth") },
  { 0x05DE, wxT("mem") },
  { 0xFB3E, wxT("memdagesh") },
  { 0xFB3E, wxT("memdageshhebrew") },
  { 0x05DE, wxT("memhebrew") },
  { 0x0574, wxT("menarmenian") },
  { 0x05A5, wxT("merkhahebrew") },
  { 0x05A6, wxT("merkhakefulahebrew") },
  { 0x05A6, wxT("merkhakefulalefthebrew") },
  { 0x05A5, wxT("merkhalefthebrew") },
  { 0x0271, wxT("mhook") },
  { 0x3392, wxT("mhzsquare") },
  { 0xFF65, wxT("middledotkatakanahalfwidth") },
  { 0x00B7, wxT("middot") },
  { 0x3272, wxT("mieumacirclekorean") },
  { 0x3212, wxT("mieumaparenkorean") },
  { 0x3264, wxT("mieumcirclekorean") },
  { 0x3141, wxT("mieumkorean") },
  { 0x3170, wxT("mieumpansioskorean") },
  { 0x3204, wxT("mieumparenkorean") },
  { 0x316E, wxT("mieumpieupkorean") },
  { 0x316F, wxT("mieumsioskorean") },
  { 0x307F, wxT("mihiragana") },
  { 0x30DF, wxT("mikatakana") },
  { 0xFF90, wxT("mikatakanahalfwidth") },
  { 0x2212, wxT("minus") },
  { 0x0320, wxT("minusbelowcmb") },
  { 0x2296, wxT("minuscircle") },
  { 0x02D7, wxT("minusmod") },
  { 0x2213, wxT("minusplus") },
  { 0x2032, wxT("minute") },
  { 0x334A, wxT("miribaarusquare") },
  { 0x3349, wxT("mirisquare") },
  { 0x0270, wxT("mlonglegturned") },
  { 0x3396, wxT("mlsquare") },
  { 0x33A3, wxT("mmcubedsquare") },
  { 0xFF4D, wxT("mmonospace") },
  { 0x339F, wxT("mmsquaredsquare") },
  { 0x3082, wxT("mohiragana") },
  { 0x33C1, wxT("mohmsquare") },
  { 0x30E2, wxT("mokatakana") },
  { 0xFF93, wxT("mokatakanahalfwidth") },
  { 0x33D6, wxT("molsquare") },
  { 0x0E21, wxT("momathai") },
  { 0x33A7, wxT("moverssquare") },
  { 0x33A8, wxT("moverssquaredsquare") },
  { 0x24A8, wxT("mparen") },
  { 0x33AB, wxT("mpasquare") },
  { 0x33B3, wxT("mssquare") },
  { 0xF6EF, wxT("msuperior") },
  { 0x026F, wxT("mturned") },
  { 0x03BC, wxT("mu") },
  { 0x00B5, wxT("mu1") },
  { 0x3382, wxT("muasquare") },
  { 0x226B, wxT("muchgreater") },
  { 0x226A, wxT("muchless") },
  { 0x338C, wxT("mufsquare") },
  { 0x03BC, wxT("mugreek") },
  { 0x338D, wxT("mugsquare") },
  { 0x3080, wxT("muhiragana") },
  { 0x30E0, wxT("mukatakana") },
  { 0xFF91, wxT("mukatakanahalfwidth") },
  { 0x3395, wxT("mulsquare") },
  { 0x00D7, wxT("multiply") },
  { 0x339B, wxT("mumsquare") },
  { 0x05A3, wxT("munahhebrew") },
  { 0x05A3, wxT("munahlefthebrew") },
  { 0x266A, wxT("musicalnote") },
  { 0x266B, wxT("musicalnotedbl") },
  { 0x266D, wxT("musicflatsign") },
  { 0x266F, wxT("musicsharpsign") },
  { 0x33B2, wxT("mussquare") },
  { 0x33B6, wxT("muvsquare") },
  { 0x33BC, wxT("muwsquare") },
  { 0x33B9, wxT("mvmegasquare") },
  { 0x33B7, wxT("mvsquare") },
  { 0x33BF, wxT("mwmegasquare") },
  { 0x33BD, wxT("mwsquare") },
  { 0x006E, wxT("n") },
  { 0x09A8, wxT("nabengali") },
  { 0x2207, wxT("nabla") },
  { 0x0144, wxT("nacute") },
  { 0x0928, wxT("nadeva") },
  { 0x0AA8, wxT("nagujarati") },
  { 0x0A28, wxT("nagurmukhi") },
  { 0x306A, wxT("nahiragana") },
  { 0x30CA, wxT("nakatakana") },
  { 0xFF85, wxT("nakatakanahalfwidth") },
  { 0x0149, wxT("napostrophe") },
  { 0x3381, wxT("nasquare") },
  { 0x310B, wxT("nbopomofo") },
  { 0x00A0, wxT("nbspace") },
  { 0x0148, wxT("ncaron") },
  { 0x0146, wxT("ncedilla") },
  { 0x24DD, wxT("ncircle") },
  { 0x1E4B, wxT("ncircumflexbelow") },
  { 0x0146, wxT("ncommaaccent") },
  { 0x1E45, wxT("ndotaccent") },
  { 0x1E47, wxT("ndotbelow") },
  { 0x306D, wxT("nehiragana") },
  { 0x30CD, wxT("nekatakana") },
  { 0xFF88, wxT("nekatakanahalfwidth") },
  { 0x20AA, wxT("newsheqelsign") },
  { 0x338B, wxT("nfsquare") },
  { 0x0999, wxT("ngabengali") },
  { 0x0919, wxT("ngadeva") },
  { 0x0A99, wxT("ngagujarati") },
  { 0x0A19, wxT("ngagurmukhi") },
  { 0x0E07, wxT("ngonguthai") },
  { 0x3093, wxT("nhiragana") },
  { 0x0272, wxT("nhookleft") },
  { 0x0273, wxT("nhookretroflex") },
  { 0x326F, wxT("nieunacirclekorean") },
  { 0x320F, wxT("nieunaparenkorean") },
  { 0x3135, wxT("nieuncieuckorean") },
  { 0x3261, wxT("nieuncirclekorean") },
  { 0x3136, wxT("nieunhieuhkorean") },
  { 0x3134, wxT("nieunkorean") },
  { 0x3168, wxT("nieunpansioskorean") },
  { 0x3201, wxT("nieunparenkorean") },
  { 0x3167, wxT("nieunsioskorean") },
  { 0x3166, wxT("nieuntikeutkorean") },
  { 0x306B, wxT("nihiragana") },
  { 0x30CB, wxT("nikatakana") },
  { 0xFF86, wxT("nikatakanahalfwidth") },
  { 0xF899, wxT("nikhahitleftthai") },
  { 0x0E4D, wxT("nikhahitthai") },
  { 0x0039, wxT("nine") },
  { 0x0669, wxT("ninearabic") },
  { 0x09EF, wxT("ninebengali") },
  { 0x2468, wxT("ninecircle") },
  { 0x2792, wxT("ninecircleinversesansserif") },
  { 0x096F, wxT("ninedeva") },
  { 0x0AEF, wxT("ninegujarati") },
  { 0x0A6F, wxT("ninegurmukhi") },
  { 0x0669, wxT("ninehackarabic") },
  { 0x3029, wxT("ninehangzhou") },
  { 0x3228, wxT("nineideographicparen") },
  { 0x2089, wxT("nineinferior") },
  { 0xFF19, wxT("ninemonospace") },
  { 0xF739, wxT("nineoldstyle") },
  { 0x247C, wxT("nineparen") },
  { 0x2490, wxT("nineperiod") },
  { 0x06F9, wxT("ninepersian") },
  { 0x2178, wxT("nineroman") },
  { 0x2079, wxT("ninesuperior") },
  { 0x2472, wxT("nineteencircle") },
  { 0x2486, wxT("nineteenparen") },
  { 0x249A, wxT("nineteenperiod") },
  { 0x0E59, wxT("ninethai") },
  { 0x01CC, wxT("nj") },
  { 0x045A, wxT("njecyrillic") },
  { 0x30F3, wxT("nkatakana") },
  { 0xFF9D, wxT("nkatakanahalfwidth") },
  { 0x019E, wxT("nlegrightlong") },
  { 0x1E49, wxT("nlinebelow") },
  { 0xFF4E, wxT("nmonospace") },
  { 0x339A, wxT("nmsquare") },
  { 0x09A3, wxT("nnabengali") },
  { 0x0923, wxT("nnadeva") },
  { 0x0AA3, wxT("nnagujarati") },
  { 0x0A23, wxT("nnagurmukhi") },
  { 0x0929, wxT("nnnadeva") },
  { 0x306E, wxT("nohiragana") },
  { 0x30CE, wxT("nokatakana") },
  { 0xFF89, wxT("nokatakanahalfwidth") },
  { 0x00A0, wxT("nonbreakingspace") },
  { 0x0E13, wxT("nonenthai") },
  { 0x0E19, wxT("nonuthai") },
  { 0x0646, wxT("noonarabic") },
  { 0xFEE6, wxT("noonfinalarabic") },
  { 0x06BA, wxT("noonghunnaarabic") },
  { 0xFB9F, wxT("noonghunnafinalarabic") },
  { 0xFEE7, wxT("nooninitialarabic") },
  { 0xFCD2, wxT("noonjeeminitialarabic") },
  { 0xFC4B, wxT("noonjeemisolatedarabic") },
  { 0xFEE8, wxT("noonmedialarabic") },
  { 0xFCD5, wxT("noonmeeminitialarabic") },
  { 0xFC4E, wxT("noonmeemisolatedarabic") },
  { 0xFC8D, wxT("noonnoonfinalarabic") },
  { 0x220C, wxT("notcontains") },
  { 0x2209, wxT("notelement") },
  { 0x2209, wxT("notelementof") },
  { 0x2260, wxT("notequal") },
  { 0x226F, wxT("notgreater") },
  { 0x2271, wxT("notgreaternorequal") },
  { 0x2279, wxT("notgreaternorless") },
  { 0x2262, wxT("notidentical") },
  { 0x226E, wxT("notless") },
  { 0x2270, wxT("notlessnorequal") },
  { 0x2226, wxT("notparallel") },
  { 0x2280, wxT("notprecedes") },
  { 0x2284, wxT("notsubset") },
  { 0x2281, wxT("notsucceeds") },
  { 0x2285, wxT("notsuperset") },
  { 0x0576, wxT("nowarmenian") },
  { 0x24A9, wxT("nparen") },
  { 0x33B1, wxT("nssquare") },
  { 0x207F, wxT("nsuperior") },
  { 0x00F1, wxT("ntilde") },
  { 0x03BD, wxT("nu") },
  { 0x306C, wxT("nuhiragana") },
  { 0x30CC, wxT("nukatakana") },
  { 0xFF87, wxT("nukatakanahalfwidth") },
  { 0x09BC, wxT("nuktabengali") },
  { 0x093C, wxT("nuktadeva") },
  { 0x0ABC, wxT("nuktagujarati") },
  { 0x0A3C, wxT("nuktagurmukhi") },
  { 0x0023, wxT("numbersign") },
  { 0xFF03, wxT("numbersignmonospace") },
  { 0xFE5F, wxT("numbersignsmall") },
  { 0x0374, wxT("numeralsigngreek") },
  { 0x0375, wxT("numeralsignlowergreek") },
  { 0x2116, wxT("numero") },
  { 0x05E0, wxT("nun") },
  { 0xFB40, wxT("nundagesh") },
  { 0xFB40, wxT("nundageshhebrew") },
  { 0x05E0, wxT("nunhebrew") },
  { 0x33B5, wxT("nvsquare") },
  { 0x33BB, wxT("nwsquare") },
  { 0x099E, wxT("nyabengali") },
  { 0x091E, wxT("nyadeva") },
  { 0x0A9E, wxT("nyagujarati") },
  { 0x0A1E, wxT("nyagurmukhi") },
  { 0x006F, wxT("o") },
  { 0x00F3, wxT("oacute") },
  { 0x0E2D, wxT("oangthai") },
  { 0x0275, wxT("obarred") },
  { 0x04E9, wxT("obarredcyrillic") },
  { 0x04EB, wxT("obarreddieresiscyrillic") },
  { 0x0993, wxT("obengali") },
  { 0x311B, wxT("obopomofo") },
  { 0x014F, wxT("obreve") },
  { 0x0911, wxT("ocandradeva") },
  { 0x0A91, wxT("ocandragujarati") },
  { 0x0949, wxT("ocandravowelsigndeva") },
  { 0x0AC9, wxT("ocandravowelsigngujarati") },
  { 0x01D2, wxT("ocaron") },
  { 0x24DE, wxT("ocircle") },
  { 0x00F4, wxT("ocircumflex") },
  { 0x1ED1, wxT("ocircumflexacute") },
  { 0x1ED9, wxT("ocircumflexdotbelow") },
  { 0x1ED3, wxT("ocircumflexgrave") },
  { 0x1ED5, wxT("ocircumflexhookabove") },
  { 0x1ED7, wxT("ocircumflextilde") },
  { 0x043E, wxT("ocyrillic") },
  { 0x0151, wxT("odblacute") },
  { 0x020D, wxT("odblgrave") },
  { 0x0913, wxT("odeva") },
  { 0x00F6, wxT("odieresis") },
  { 0x04E7, wxT("odieresiscyrillic") },
  { 0x1ECD, wxT("odotbelow") },
  { 0x0153, wxT("oe") },
  { 0x315A, wxT("oekorean") },
  { 0x02DB, wxT("ogonek") },
  { 0x0328, wxT("ogonekcmb") },
  { 0x00F2, wxT("ograve") },
  { 0x0A93, wxT("ogujarati") },
  { 0x0585, wxT("oharmenian") },
  { 0x304A, wxT("ohiragana") },
  { 0x1ECF, wxT("ohookabove") },
  { 0x01A1, wxT("ohorn") },
  { 0x1EDB, wxT("ohornacute") },
  { 0x1EE3, wxT("ohorndotbelow") },
  { 0x1EDD, wxT("ohorngrave") },
  { 0x1EDF, wxT("ohornhookabove") },
  { 0x1EE1, wxT("ohorntilde") },
  { 0x0151, wxT("ohungarumlaut") },
  { 0x01A3, wxT("oi") },
  { 0x020F, wxT("oinvertedbreve") },
  { 0x30AA, wxT("okatakana") },
  { 0xFF75, wxT("okatakanahalfwidth") },
  { 0x3157, wxT("okorean") },
  { 0x05AB, wxT("olehebrew") },
  { 0x014D, wxT("omacron") },
  { 0x1E53, wxT("omacronacute") },
  { 0x1E51, wxT("omacrongrave") },
  { 0x0950, wxT("omdeva") },
  { 0x03C9, wxT("omega") },
  { 0x03D6, wxT("omega1") },
  { 0x0461, wxT("omegacyrillic") },
  { 0x0277, wxT("omegalatinclosed") },
  { 0x047B, wxT("omegaroundcyrillic") },
  { 0x047D, wxT("omegatitlocyrillic") },
  { 0x03CE, wxT("omegatonos") },
  { 0x0AD0, wxT("omgujarati") },
  { 0x03BF, wxT("omicron") },
  { 0x03CC, wxT("omicrontonos") },
  { 0xFF4F, wxT("omonospace") },
  { 0x0031, wxT("one") },
  { 0x0661, wxT("onearabic") },
  { 0x09E7, wxT("onebengali") },
  { 0x2460, wxT("onecircle") },
  { 0x278A, wxT("onecircleinversesansserif") },
  { 0x0967, wxT("onedeva") },
  { 0x2024, wxT("onedotenleader") },
  { 0x215B, wxT("oneeighth") },
  { 0xF6DC, wxT("onefitted") },
  { 0x0AE7, wxT("onegujarati") },
  { 0x0A67, wxT("onegurmukhi") },
  { 0x0661, wxT("onehackarabic") },
  { 0x00BD, wxT("onehalf") },
  { 0x3021, wxT("onehangzhou") },
  { 0x3220, wxT("oneideographicparen") },
  { 0x2081, wxT("oneinferior") },
  { 0xFF11, wxT("onemonospace") },
  { 0x09F4, wxT("onenumeratorbengali") },
  { 0xF731, wxT("oneoldstyle") },
  { 0x2474, wxT("oneparen") },
  { 0x2488, wxT("oneperiod") },
  { 0x06F1, wxT("onepersian") },
  { 0x00BC, wxT("onequarter") },
  { 0x2170, wxT("oneroman") },
  { 0x00B9, wxT("onesuperior") },
  { 0x0E51, wxT("onethai") },
  { 0x2153, wxT("onethird") },
  { 0x01EB, wxT("oogonek") },
  { 0x01ED, wxT("oogonekmacron") },
  { 0x0A13, wxT("oogurmukhi") },
  { 0x0A4B, wxT("oomatragurmukhi") },
  { 0x0254, wxT("oopen") },
  { 0x24AA, wxT("oparen") },
  { 0x25E6, wxT("openbullet") },
  { 0x2325, wxT("option") },
  { 0x00AA, wxT("ordfeminine") },
  { 0x00BA, wxT("ordmasculine") },
  { 0x221F, wxT("orthogonal") },
  { 0x0912, wxT("oshortdeva") },
  { 0x094A, wxT("oshortvowelsigndeva") },
  { 0x00F8, wxT("oslash") },
  { 0x01FF, wxT("oslashacute") },
  { 0x3049, wxT("osmallhiragana") },
  { 0x30A9, wxT("osmallkatakana") },
  { 0xFF6B, wxT("osmallkatakanahalfwidth") },
  { 0x01FF, wxT("ostrokeacute") },
  { 0xF6F0, wxT("osuperior") },
  { 0x047F, wxT("otcyrillic") },
  { 0x00F5, wxT("otilde") },
  { 0x1E4D, wxT("otildeacute") },
  { 0x1E4F, wxT("otildedieresis") },
  { 0x3121, wxT("oubopomofo") },
  { 0x203E, wxT("overline") },
  { 0xFE4A, wxT("overlinecenterline") },
  { 0x0305, wxT("overlinecmb") },
  { 0xFE49, wxT("overlinedashed") },
  { 0xFE4C, wxT("overlinedblwavy") },
  { 0xFE4B, wxT("overlinewavy") },
  { 0x00AF, wxT("overscore") },
  { 0x09CB, wxT("ovowelsignbengali") },
  { 0x094B, wxT("ovowelsigndeva") },
  { 0x0ACB, wxT("ovowelsigngujarati") },
  { 0x0070, wxT("p") },
  { 0x3380, wxT("paampssquare") },
  { 0x332B, wxT("paasentosquare") },
  { 0x09AA, wxT("pabengali") },
  { 0x1E55, wxT("pacute") },
  { 0x092A, wxT("padeva") },
  { 0x21DF, wxT("pagedown") },
  { 0x21DE, wxT("pageup") },
  { 0x0AAA, wxT("pagujarati") },
  { 0x0A2A, wxT("pagurmukhi") },
  { 0x3071, wxT("pahiragana") },
  { 0x0E2F, wxT("paiyannoithai") },
  { 0x30D1, wxT("pakatakana") },
  { 0x0484, wxT("palatalizationcyrilliccmb") },
  { 0x04C0, wxT("palochkacyrillic") },
  { 0x317F, wxT("pansioskorean") },
  { 0x00B6, wxT("paragraph") },
  { 0x2225, wxT("parallel") },
  { 0x0028, wxT("parenleft") },
  { 0xFD3E, wxT("parenleftaltonearabic") },
  { 0xF8ED, wxT("parenleftbt") },
  { 0xF8EC, wxT("parenleftex") },
  { 0x208D, wxT("parenleftinferior") },
  { 0xFF08, wxT("parenleftmonospace") },
  { 0xFE59, wxT("parenleftsmall") },
  { 0x207D, wxT("parenleftsuperior") },
  { 0xF8EB, wxT("parenlefttp") },
  { 0xFE35, wxT("parenleftvertical") },
  { 0x0029, wxT("parenright") },
  { 0xFD3F, wxT("parenrightaltonearabic") },
  { 0xF8F8, wxT("parenrightbt") },
  { 0xF8F7, wxT("parenrightex") },
  { 0x208E, wxT("parenrightinferior") },
  { 0xFF09, wxT("parenrightmonospace") },
  { 0xFE5A, wxT("parenrightsmall") },
  { 0x207E, wxT("parenrightsuperior") },
  { 0xF8F6, wxT("parenrighttp") },
  { 0xFE36, wxT("parenrightvertical") },
  { 0x2202, wxT("partialdiff") },
  { 0x05C0, wxT("paseqhebrew") },
  { 0x0599, wxT("pashtahebrew") },
  { 0x33A9, wxT("pasquare") },
  { 0x05B7, wxT("patah") },
  { 0x05B7, wxT("patah11") },
  { 0x05B7, wxT("patah1d") },
  { 0x05B7, wxT("patah2a") },
  { 0x05B7, wxT("patahhebrew") },
  { 0x05B7, wxT("patahnarrowhebrew") },
  { 0x05B7, wxT("patahquarterhebrew") },
  { 0x05B7, wxT("patahwidehebrew") },
  { 0x05A1, wxT("pazerhebrew") },
  { 0x3106, wxT("pbopomofo") },
  { 0x24DF, wxT("pcircle") },
  { 0x1E57, wxT("pdotaccent") },
  { 0x05E4, wxT("pe") },
  { 0x043F, wxT("pecyrillic") },
  { 0xFB44, wxT("pedagesh") },
  { 0xFB44, wxT("pedageshhebrew") },
  { 0x333B, wxT("peezisquare") },
  { 0xFB43, wxT("pefinaldageshhebrew") },
  { 0x067E, wxT("peharabic") },
  { 0x057A, wxT("peharmenian") },
  { 0x05E4, wxT("pehebrew") },
  { 0xFB57, wxT("pehfinalarabic") },
  { 0xFB58, wxT("pehinitialarabic") },
  { 0x307A, wxT("pehiragana") },
  { 0xFB59, wxT("pehmedialarabic") },
  { 0x30DA, wxT("pekatakana") },
  { 0x04A7, wxT("pemiddlehookcyrillic") },
  { 0xFB4E, wxT("perafehebrew") },
  { 0x0025, wxT("percent") },
  { 0x066A, wxT("percentarabic") },
  { 0xFF05, wxT("percentmonospace") },
  { 0xFE6A, wxT("percentsmall") },
  { 0x002E, wxT("period") },
  { 0x0589, wxT("periodarmenian") },
  { 0x00B7, wxT("periodcentered") },
  { 0xFF61, wxT("periodhalfwidth") },
  { 0xF6E7, wxT("periodinferior") },
  { 0xFF0E, wxT("periodmonospace") },
  { 0xFE52, wxT("periodsmall") },
  { 0xF6E8, wxT("periodsuperior") },
  { 0x0342, wxT("perispomenigreekcmb") },
  { 0x22A5, wxT("perpendicular") },
  { 0x2030, wxT("perthousand") },
  { 0x20A7, wxT("peseta") },
  { 0x338A, wxT("pfsquare") },
  { 0x09AB, wxT("phabengali") },
  { 0x092B, wxT("phadeva") },
  { 0x0AAB, wxT("phagujarati") },
  { 0x0A2B, wxT("phagurmukhi") },
  { 0x03C6, wxT("phi") },
  { 0x03D5, wxT("phi1") },
  { 0x327A, wxT("phieuphacirclekorean") },
  { 0x321A, wxT("phieuphaparenkorean") },
  { 0x326C, wxT("phieuphcirclekorean") },
  { 0x314D, wxT("phieuphkorean") },
  { 0x320C, wxT("phieuphparenkorean") },
  { 0x0278, wxT("philatin") },
  { 0x0E3A, wxT("phinthuthai") },
  { 0x03D5, wxT("phisymbolgreek") },
  { 0x01A5, wxT("phook") },
  { 0x0E1E, wxT("phophanthai") },
  { 0x0E1C, wxT("phophungthai") },
  { 0x0E20, wxT("phosamphaothai") },
  { 0x03C0, wxT("pi") },
  { 0x3273, wxT("pieupacirclekorean") },
  { 0x3213, wxT("pieupaparenkorean") },
  { 0x3176, wxT("pieupcieuckorean") },
  { 0x3265, wxT("pieupcirclekorean") },
  { 0x3172, wxT("pieupkiyeokkorean") },
  { 0x3142, wxT("pieupkorean") },
  { 0x3205, wxT("pieupparenkorean") },
  { 0x3174, wxT("pieupsioskiyeokkorean") },
  { 0x3144, wxT("pieupsioskorean") },
  { 0x3175, wxT("pieupsiostikeutkorean") },
  { 0x3177, wxT("pieupthieuthkorean") },
  { 0x3173, wxT("pieuptikeutkorean") },
  { 0x3074, wxT("pihiragana") },
  { 0x30D4, wxT("pikatakana") },
  { 0x03D6, wxT("pisymbolgreek") },
  { 0x0583, wxT("piwrarmenian") },
  { 0x002B, wxT("plus") },
  { 0x031F, wxT("plusbelowcmb") },
  { 0x2295, wxT("pluscircle") },
  { 0x00B1, wxT("plusminus") },
  { 0x02D6, wxT("plusmod") },
  { 0xFF0B, wxT("plusmonospace") },
  { 0xFE62, wxT("plussmall") },
  { 0x207A, wxT("plussuperior") },
  { 0xFF50, wxT("pmonospace") },
  { 0x33D8, wxT("pmsquare") },
  { 0x307D, wxT("pohiragana") },
  { 0x261F, wxT("pointingindexdownwhite") },
  { 0x261C, wxT("pointingindexleftwhite") },
  { 0x261E, wxT("pointingindexrightwhite") },
  { 0x261D, wxT("pointingindexupwhite") },
  { 0x30DD, wxT("pokatakana") },
  { 0x0E1B, wxT("poplathai") },
  { 0x3012, wxT("postalmark") },
  { 0x3020, wxT("postalmarkface") },
  { 0x24AB, wxT("pparen") },
  { 0x227A, wxT("precedes") },
  { 0x211E, wxT("prescription") },
  { 0x02B9, wxT("primemod") },
  { 0x2035, wxT("primereversed") },
  { 0x220F, wxT("product") },
  { 0x2305, wxT("projective") },
  { 0x30FC, wxT("prolongedkana") },
  { 0x2318, wxT("propellor") },
  { 0x2282, wxT("propersubset") },
  { 0x2283, wxT("propersuperset") },
  { 0x2237, wxT("proportion") },
  { 0x221D, wxT("proportional") },
  { 0x03C8, wxT("psi") },
  { 0x0471, wxT("psicyrillic") },
  { 0x0486, wxT("psilipneumatacyrilliccmb") },
  { 0x33B0, wxT("pssquare") },
  { 0x3077, wxT("puhiragana") },
  { 0x30D7, wxT("pukatakana") },
  { 0x33B4, wxT("pvsquare") },
  { 0x33BA, wxT("pwsquare") },
  { 0x0071, wxT("q") },
  { 0x0958, wxT("qadeva") },
  { 0x05A8, wxT("qadmahebrew") },
  { 0x0642, wxT("qafarabic") },
  { 0xFED6, wxT("qaffinalarabic") },
  { 0xFED7, wxT("qafinitialarabic") },
  { 0xFED8, wxT("qafmedialarabic") },
  { 0x05B8, wxT("qamats") },
  { 0x05B8, wxT("qamats10") },
  { 0x05B8, wxT("qamats1a") },
  { 0x05B8, wxT("qamats1c") },
  { 0x05B8, wxT("qamats27") },
  { 0x05B8, wxT("qamats29") },
  { 0x05B8, wxT("qamats33") },
  { 0x05B8, wxT("qamatsde") },
  { 0x05B8, wxT("qamatshebrew") },
  { 0x05B8, wxT("qamatsnarrowhebrew") },
  { 0x05B8, wxT("qamatsqatanhebrew") },
  { 0x05B8, wxT("qamatsqatannarrowhebrew") },
  { 0x05B8, wxT("qamatsqatanquarterhebrew") },
  { 0x05B8, wxT("qamatsqatanwidehebrew") },
  { 0x05B8, wxT("qamatsquarterhebrew") },
  { 0x05B8, wxT("qamatswidehebrew") },
  { 0x059F, wxT("qarneyparahebrew") },
  { 0x3111, wxT("qbopomofo") },
  { 0x24E0, wxT("qcircle") },
  { 0x02A0, wxT("qhook") },
  { 0xFF51, wxT("qmonospace") },
  { 0x05E7, wxT("qof") },
  { 0xFB47, wxT("qofdagesh") },
  { 0xFB47, wxT("qofdageshhebrew") },
  { 0x05E7, wxT("qofhebrew") },
  { 0x24AC, wxT("qparen") },
  { 0x2669, wxT("quarternote") },
  { 0x05BB, wxT("qubuts") },
  { 0x05BB, wxT("qubuts18") },
  { 0x05BB, wxT("qubuts25") },
  { 0x05BB, wxT("qubuts31") },
  { 0x05BB, wxT("qubutshebrew") },
  { 0x05BB, wxT("qubutsnarrowhebrew") },
  { 0x05BB, wxT("qubutsquarterhebrew") },
  { 0x05BB, wxT("qubutswidehebrew") },
  { 0x003F, wxT("question") },
  { 0x061F, wxT("questionarabic") },
  { 0x055E, wxT("questionarmenian") },
  { 0x00BF, wxT("questiondown") },
  { 0xF7BF, wxT("questiondownsmall") },
  { 0x037E, wxT("questiongreek") },
  { 0xFF1F, wxT("questionmonospace") },
  { 0xF73F, wxT("questionsmall") },
  { 0x0022, wxT("quotedbl") },
  { 0x201E, wxT("quotedblbase") },
  { 0x201C, wxT("quotedblleft") },
  { 0xFF02, wxT("quotedblmonospace") },
  { 0x301E, wxT("quotedblprime") },
  { 0x301D, wxT("quotedblprimereversed") },
  { 0x201D, wxT("quotedblright") },
  { 0x2018, wxT("quoteleft") },
  { 0x201B, wxT("quoteleftreversed") },
  { 0x201B, wxT("quotereversed") },
  { 0x2019, wxT("quoteright") },
  { 0x0149, wxT("quoterightn") },
  { 0x201A, wxT("quotesinglbase") },
  { 0x0027, wxT("quotesingle") },
  { 0xFF07, wxT("quotesinglemonospace") },
  { 0x0072, wxT("r") },
  { 0x057C, wxT("raarmenian") },
  { 0x09B0, wxT("rabengali") },
  { 0x0155, wxT("racute") },
  { 0x0930, wxT("radeva") },
  { 0x221A, wxT("radical") },
  { 0xF8E5, wxT("radicalex") },
  { 0x33AE, wxT("radoverssquare") },
  { 0x33AF, wxT("radoverssquaredsquare") },
  { 0x33AD, wxT("radsquare") },
  { 0x05BF, wxT("rafe") },
  { 0x05BF, wxT("rafehebrew") },
  { 0x0AB0, wxT("ragujarati") },
  { 0x0A30, wxT("ragurmukhi") },
  { 0x3089, wxT("rahiragana") },
  { 0x30E9, wxT("rakatakana") },
  { 0xFF97, wxT("rakatakanahalfwidth") },
  { 0x09F1, wxT("ralowerdiagonalbengali") },
  { 0x09F0, wxT("ramiddlediagonalbengali") },
  { 0x0264, wxT("ramshorn") },
  { 0x2236, wxT("ratio") },
  { 0x3116, wxT("rbopomofo") },
  { 0x0159, wxT("rcaron") },
  { 0x0157, wxT("rcedilla") },
  { 0x24E1, wxT("rcircle") },
  { 0x0157, wxT("rcommaaccent") },
  { 0x0211, wxT("rdblgrave") },
  { 0x1E59, wxT("rdotaccent") },
  { 0x1E5B, wxT("rdotbelow") },
  { 0x1E5D, wxT("rdotbelowmacron") },
  { 0x203B, wxT("referencemark") },
  { 0x2286, wxT("reflexsubset") },
  { 0x2287, wxT("reflexsuperset") },
  { 0x00AE, wxT("registered") },
  { 0xF8E8, wxT("registersans") },
  { 0xF6DA, wxT("registerserif") },
  { 0x0631, wxT("reharabic") },
  { 0x0580, wxT("reharmenian") },
  { 0xFEAE, wxT("rehfinalarabic") },
  { 0x308C, wxT("rehiragana") },
  { 0x30EC, wxT("rekatakana") },
  { 0xFF9A, wxT("rekatakanahalfwidth") },
  { 0x05E8, wxT("resh") },
  { 0xFB48, wxT("reshdageshhebrew") },
  { 0x05E8, wxT("reshhebrew") },
  { 0x223D, wxT("reversedtilde") },
  { 0x0597, wxT("reviahebrew") },
  { 0x0597, wxT("reviamugrashhebrew") },
  { 0x2310, wxT("revlogicalnot") },
  { 0x027E, wxT("rfishhook") },
  { 0x027F, wxT("rfishhookreversed") },
  { 0x09DD, wxT("rhabengali") },
  { 0x095D, wxT("rhadeva") },
  { 0x03C1, wxT("rho") },
  { 0x027D, wxT("rhook") },
  { 0x027B, wxT("rhookturned") },
  { 0x02B5, wxT("rhookturnedsuperior") },
  { 0x03F1, wxT("rhosymbolgreek") },
  { 0x02DE, wxT("rhotichookmod") },
  { 0x3271, wxT("rieulacirclekorean") },
  { 0x3211, wxT("rieulaparenkorean") },
  { 0x3263, wxT("rieulcirclekorean") },
  { 0x3140, wxT("rieulhieuhkorean") },
  { 0x313A, wxT("rieulkiyeokkorean") },
  { 0x3169, wxT("rieulkiyeoksioskorean") },
  { 0x3139, wxT("rieulkorean") },
  { 0x313B, wxT("rieulmieumkorean") },
  { 0x316C, wxT("rieulpansioskorean") },
  { 0x3203, wxT("rieulparenkorean") },
  { 0x313F, wxT("rieulphieuphkorean") },
  { 0x313C, wxT("rieulpieupkorean") },
  { 0x316B, wxT("rieulpieupsioskorean") },
  { 0x313D, wxT("rieulsioskorean") },
  { 0x313E, wxT("rieulthieuthkorean") },
  { 0x316A, wxT("rieultikeutkorean") },
  { 0x316D, wxT("rieulyeorinhieuhkorean") },
  { 0x221F, wxT("rightangle") },
  { 0x0319, wxT("righttackbelowcmb") },
  { 0x22BF, wxT("righttriangle") },
  { 0x308A, wxT("rihiragana") },
  { 0x30EA, wxT("rikatakana") },
  { 0xFF98, wxT("rikatakanahalfwidth") },
  { 0x02DA, wxT("ring") },
  { 0x0325, wxT("ringbelowcmb") },
  { 0x030A, wxT("ringcmb") },
  { 0x02BF, wxT("ringhalfleft") },
  { 0x0559, wxT("ringhalfleftarmenian") },
  { 0x031C, wxT("ringhalfleftbelowcmb") },
  { 0x02D3, wxT("ringhalfleftcentered") },
  { 0x02BE, wxT("ringhalfright") },
  { 0x0339, wxT("ringhalfrightbelowcmb") },
  { 0x02D2, wxT("ringhalfrightcentered") },
  { 0x0213, wxT("rinvertedbreve") },
  { 0x3351, wxT("rittorusquare") },
  { 0x1E5F, wxT("rlinebelow") },
  { 0x027C, wxT("rlongleg") },
  { 0x027A, wxT("rlonglegturned") },
  { 0xFF52, wxT("rmonospace") },
  { 0x308D, wxT("rohiragana") },
  { 0x30ED, wxT("rokatakana") },
  { 0xFF9B, wxT("rokatakanahalfwidth") },
  { 0x0E23, wxT("roruathai") },
  { 0x24AD, wxT("rparen") },
  { 0x09DC, wxT("rrabengali") },
  { 0x0931, wxT("rradeva") },
  { 0x0A5C, wxT("rragurmukhi") },
  { 0x0691, wxT("rreharabic") },
  { 0xFB8D, wxT("rrehfinalarabic") },
  { 0x09E0, wxT("rrvocalicbengali") },
  { 0x0960, wxT("rrvocalicdeva") },
  { 0x0AE0, wxT("rrvocalicgujarati") },
  { 0x09C4, wxT("rrvocalicvowelsignbengali") },
  { 0x0944, wxT("rrvocalicvowelsigndeva") },
  { 0x0AC4, wxT("rrvocalicvowelsigngujarati") },
  { 0xF6F1, wxT("rsuperior") },
  { 0x2590, wxT("rtblock") },
  { 0x0279, wxT("rturned") },
  { 0x02B4, wxT("rturnedsuperior") },
  { 0x308B, wxT("ruhiragana") },
  { 0x30EB, wxT("rukatakana") },
  { 0xFF99, wxT("rukatakanahalfwidth") },
  { 0x09F2, wxT("rupeemarkbengali") },
  { 0x09F3, wxT("rupeesignbengali") },
  { 0xF6DD, wxT("rupiah") },
  { 0x0E24, wxT("ruthai") },
  { 0x098B, wxT("rvocalicbengali") },
  { 0x090B, wxT("rvocalicdeva") },
  { 0x0A8B, wxT("rvocalicgujarati") },
  { 0x09C3, wxT("rvocalicvowelsignbengali") },
  { 0x0943, wxT("rvocalicvowelsigndeva") },
  { 0x0AC3, wxT("rvocalicvowelsigngujarati") },
  { 0x0073, wxT("s") },
  { 0x09B8, wxT("sabengali") },
  { 0x015B, wxT("sacute") },
  { 0x1E65, wxT("sacutedotaccent") },
  { 0x0635, wxT("sadarabic") },
  { 0x0938, wxT("sadeva") },
  { 0xFEBA, wxT("sadfinalarabic") },
  { 0xFEBB, wxT("sadinitialarabic") },
  { 0xFEBC, wxT("sadmedialarabic") },
  { 0x0AB8, wxT("sagujarati") },
  { 0x0A38, wxT("sagurmukhi") },
  { 0x3055, wxT("sahiragana") },
  { 0x30B5, wxT("sakatakana") },
  { 0xFF7B, wxT("sakatakanahalfwidth") },
  { 0xFDFA, wxT("sallallahoualayhewasallamarabic") },
  { 0x05E1, wxT("samekh") },
  { 0xFB41, wxT("samekhdagesh") },
  { 0xFB41, wxT("samekhdageshhebrew") },
  { 0x05E1, wxT("samekhhebrew") },
  { 0x0E32, wxT("saraaathai") },
  { 0x0E41, wxT("saraaethai") },
  { 0x0E44, wxT("saraaimaimalaithai") },
  { 0x0E43, wxT("saraaimaimuanthai") },
  { 0x0E33, wxT("saraamthai") },
  { 0x0E30, wxT("saraathai") },
  { 0x0E40, wxT("saraethai") },
  { 0xF886, wxT("saraiileftthai") },
  { 0x0E35, wxT("saraiithai") },
  { 0xF885, wxT("saraileftthai") },
  { 0x0E34, wxT("saraithai") },
  { 0x0E42, wxT("saraothai") },
  { 0xF888, wxT("saraueeleftthai") },
  { 0x0E37, wxT("saraueethai") },
  { 0xF887, wxT("saraueleftthai") },
  { 0x0E36, wxT("sarauethai") },
  { 0x0E38, wxT("sarauthai") },
  { 0x0E39, wxT("sarauuthai") },
  { 0x3119, wxT("sbopomofo") },
  { 0x0161, wxT("scaron") },
  { 0x1E67, wxT("scarondotaccent") },
  { 0x015F, wxT("scedilla") },
  { 0x0259, wxT("schwa") },
  { 0x04D9, wxT("schwacyrillic") },
  { 0x04DB, wxT("schwadieresiscyrillic") },
  { 0x025A, wxT("schwahook") },
  { 0x24E2, wxT("scircle") },
  { 0x015D, wxT("scircumflex") },
  { 0x0219, wxT("scommaaccent") },
  { 0x1E61, wxT("sdotaccent") },
  { 0x1E63, wxT("sdotbelow") },
  { 0x1E69, wxT("sdotbelowdotaccent") },
  { 0x033C, wxT("seagullbelowcmb") },
  { 0x2033, wxT("second") },
  { 0x02CA, wxT("secondtonechinese") },
  { 0x00A7, wxT("section") },
  { 0x0633, wxT("seenarabic") },
  { 0xFEB2, wxT("seenfinalarabic") },
  { 0xFEB3, wxT("seeninitialarabic") },
  { 0xFEB4, wxT("seenmedialarabic") },
  { 0x05B6, wxT("segol") },
  { 0x05B6, wxT("segol13") },
  { 0x05B6, wxT("segol1f") },
  { 0x05B6, wxT("segol2c") },
  { 0x05B6, wxT("segolhebrew") },
  { 0x05B6, wxT("segolnarrowhebrew") },
  { 0x05B6, wxT("segolquarterhebrew") },
  { 0x0592, wxT("segoltahebrew") },
  { 0x05B6, wxT("segolwidehebrew") },
  { 0x057D, wxT("seharmenian") },
  { 0x305B, wxT("sehiragana") },
  { 0x30BB, wxT("sekatakana") },
  { 0xFF7E, wxT("sekatakanahalfwidth") },
  { 0x003B, wxT("semicolon") },
  { 0x061B, wxT("semicolonarabic") },
  { 0xFF1B, wxT("semicolonmonospace") },
  { 0xFE54, wxT("semicolonsmall") },
  { 0x309C, wxT("semivoicedmarkkana") },
  { 0xFF9F, wxT("semivoicedmarkkanahalfwidth") },
  { 0x3322, wxT("sentisquare") },
  { 0x3323, wxT("sentosquare") },
  { 0x0037, wxT("seven") },
  { 0x0667, wxT("sevenarabic") },
  { 0x09ED, wxT("sevenbengali") },
  { 0x2466, wxT("sevencircle") },
  { 0x2790, wxT("sevencircleinversesansserif") },
  { 0x096D, wxT("sevendeva") },
  { 0x215E, wxT("seveneighths") },
  { 0x0AED, wxT("sevengujarati") },
  { 0x0A6D, wxT("sevengurmukhi") },
  { 0x0667, wxT("sevenhackarabic") },
  { 0x3027, wxT("sevenhangzhou") },
  { 0x3226, wxT("sevenideographicparen") },
  { 0x2087, wxT("seveninferior") },
  { 0xFF17, wxT("sevenmonospace") },
  { 0xF737, wxT("sevenoldstyle") },
  { 0x247A, wxT("sevenparen") },
  { 0x248E, wxT("sevenperiod") },
  { 0x06F7, wxT("sevenpersian") },
  { 0x2176, wxT("sevenroman") },
  { 0x2077, wxT("sevensuperior") },
  { 0x2470, wxT("seventeencircle") },
  { 0x2484, wxT("seventeenparen") },
  { 0x2498, wxT("seventeenperiod") },
  { 0x0E57, wxT("seventhai") },
  { 0x00AD, wxT("sfthyphen") },
  { 0x0577, wxT("shaarmenian") },
  { 0x09B6, wxT("shabengali") },
  { 0x0448, wxT("shacyrillic") },
  { 0x0651, wxT("shaddaarabic") },
  { 0xFC61, wxT("shaddadammaarabic") },
  { 0xFC5E, wxT("shaddadammatanarabic") },
  { 0xFC60, wxT("shaddafathaarabic") },
  { 0xFC62, wxT("shaddakasraarabic") },
  { 0xFC5F, wxT("shaddakasratanarabic") },
  { 0x2592, wxT("shade") },
  { 0x2593, wxT("shadedark") },
  { 0x2591, wxT("shadelight") },
  { 0x2592, wxT("shademedium") },
  { 0x0936, wxT("shadeva") },
  { 0x0AB6, wxT("shagujarati") },
  { 0x0A36, wxT("shagurmukhi") },
  { 0x0593, wxT("shalshelethebrew") },
  { 0x3115, wxT("shbopomofo") },
  { 0x0449, wxT("shchacyrillic") },
  { 0x0634, wxT("sheenarabic") },
  { 0xFEB6, wxT("sheenfinalarabic") },
  { 0xFEB7, wxT("sheeninitialarabic") },
  { 0xFEB8, wxT("sheenmedialarabic") },
  { 0x03E3, wxT("sheicoptic") },
  { 0x20AA, wxT("sheqel") },
  { 0x20AA, wxT("sheqelhebrew") },
  { 0x05B0, wxT("sheva") },
  { 0x05B0, wxT("sheva115") },
  { 0x05B0, wxT("sheva15") },
  { 0x05B0, wxT("sheva22") },
  { 0x05B0, wxT("sheva2e") },
  { 0x05B0, wxT("shevahebrew") },
  { 0x05B0, wxT("shevanarrowhebrew") },
  { 0x05B0, wxT("shevaquarterhebrew") },
  { 0x05B0, wxT("shevawidehebrew") },
  { 0x04BB, wxT("shhacyrillic") },
  { 0x03ED, wxT("shimacoptic") },
  { 0x05E9, wxT("shin") },
  { 0xFB49, wxT("shindagesh") },
  { 0xFB49, wxT("shindageshhebrew") },
  { 0xFB2C, wxT("shindageshshindot") },
  { 0xFB2C, wxT("shindageshshindothebrew") },
  { 0xFB2D, wxT("shindageshsindot") },
  { 0xFB2D, wxT("shindageshsindothebrew") },
  { 0x05C1, wxT("shindothebrew") },
  { 0x05E9, wxT("shinhebrew") },
  { 0xFB2A, wxT("shinshindot") },
  { 0xFB2A, wxT("shinshindothebrew") },
  { 0xFB2B, wxT("shinsindot") },
  { 0xFB2B, wxT("shinsindothebrew") },
  { 0x0282, wxT("shook") },
  { 0x03C3, wxT("sigma") },
  { 0x03C2, wxT("sigma1") },
  { 0x03C2, wxT("sigmafinal") },
  { 0x03F2, wxT("sigmalunatesymbolgreek") },
  { 0x3057, wxT("sihiragana") },
  { 0x30B7, wxT("sikatakana") },
  { 0xFF7C, wxT("sikatakanahalfwidth") },
  { 0x05BD, wxT("siluqhebrew") },
  { 0x05BD, wxT("siluqlefthebrew") },
  { 0x223C, wxT("similar") },
  { 0x05C2, wxT("sindothebrew") },
  { 0x3274, wxT("siosacirclekorean") },
  { 0x3214, wxT("siosaparenkorean") },
  { 0x317E, wxT("sioscieuckorean") },
  { 0x3266, wxT("sioscirclekorean") },
  { 0x317A, wxT("sioskiyeokkorean") },
  { 0x3145, wxT("sioskorean") },
  { 0x317B, wxT("siosnieunkorean") },
  { 0x3206, wxT("siosparenkorean") },
  { 0x317D, wxT("siospieupkorean") },
  { 0x317C, wxT("siostikeutkorean") },
  { 0x0036, wxT("six") },
  { 0x0666, wxT("sixarabic") },
  { 0x09EC, wxT("sixbengali") },
  { 0x2465, wxT("sixcircle") },
  { 0x278F, wxT("sixcircleinversesansserif") },
  { 0x096C, wxT("sixdeva") },
  { 0x0AEC, wxT("sixgujarati") },
  { 0x0A6C, wxT("sixgurmukhi") },
  { 0x0666, wxT("sixhackarabic") },
  { 0x3026, wxT("sixhangzhou") },
  { 0x3225, wxT("sixideographicparen") },
  { 0x2086, wxT("sixinferior") },
  { 0xFF16, wxT("sixmonospace") },
  { 0xF736, wxT("sixoldstyle") },
  { 0x2479, wxT("sixparen") },
  { 0x248D, wxT("sixperiod") },
  { 0x06F6, wxT("sixpersian") },
  { 0x2175, wxT("sixroman") },
  { 0x2076, wxT("sixsuperior") },
  { 0x246F, wxT("sixteencircle") },
  { 0x09F9, wxT("sixteencurrencydenominatorbengali") },
  { 0x2483, wxT("sixteenparen") },
  { 0x2497, wxT("sixteenperiod") },
  { 0x0E56, wxT("sixthai") },
  { 0x002F, wxT("slash") },
  { 0xFF0F, wxT("slashmonospace") },
  { 0x017F, wxT("slong") },
  { 0x1E9B, wxT("slongdotaccent") },
  { 0x263A, wxT("smileface") },
  { 0xFF53, wxT("smonospace") },
  { 0x05C3, wxT("sofpasuqhebrew") },
  { 0x00AD, wxT("softhyphen") },
  { 0x044C, wxT("softsigncyrillic") },
  { 0x305D, wxT("sohiragana") },
  { 0x30BD, wxT("sokatakana") },
  { 0xFF7F, wxT("sokatakanahalfwidth") },
  { 0x0338, wxT("soliduslongoverlaycmb") },
  { 0x0337, wxT("solidusshortoverlaycmb") },
  { 0x0E29, wxT("sorusithai") },
  { 0x0E28, wxT("sosalathai") },
  { 0x0E0B, wxT("sosothai") },
  { 0x0E2A, wxT("sosuathai") },
  { 0x0020, wxT("space") },
  { 0x0020, wxT("spacehackarabic") },
  { 0x2660, wxT("spade") },
  { 0x2660, wxT("spadesuitblack") },
  { 0x2664, wxT("spadesuitwhite") },
  { 0x24AE, wxT("sparen") },
  { 0x033B, wxT("squarebelowcmb") },
  { 0x33C4, wxT("squarecc") },
  { 0x339D, wxT("squarecm") },
  { 0x25A9, wxT("squarediagonalcrosshatchfill") },
  { 0x25A4, wxT("squarehorizontalfill") },
  { 0x338F, wxT("squarekg") },
  { 0x339E, wxT("squarekm") },
  { 0x33CE, wxT("squarekmcapital") },
  { 0x33D1, wxT("squareln") },
  { 0x33D2, wxT("squarelog") },
  { 0x338E, wxT("squaremg") },
  { 0x33D5, wxT("squaremil") },
  { 0x339C, wxT("squaremm") },
  { 0x33A1, wxT("squaremsquared") },
  { 0x25A6, wxT("squareorthogonalcrosshatchfill") },
  { 0x25A7, wxT("squareupperlefttolowerrightfill") },
  { 0x25A8, wxT("squareupperrighttolowerleftfill") },
  { 0x25A5, wxT("squareverticalfill") },
  { 0x25A3, wxT("squarewhitewithsmallblack") },
  { 0x33DB, wxT("srsquare") },
  { 0x09B7, wxT("ssabengali") },
  { 0x0937, wxT("ssadeva") },
  { 0x0AB7, wxT("ssagujarati") },
  { 0x3149, wxT("ssangcieuckorean") },
  { 0x3185, wxT("ssanghieuhkorean") },
  { 0x3180, wxT("ssangieungkorean") },
  { 0x3132, wxT("ssangkiyeokkorean") },
  { 0x3165, wxT("ssangnieunkorean") },
  { 0x3143, wxT("ssangpieupkorean") },
  { 0x3146, wxT("ssangsioskorean") },
  { 0x3138, wxT("ssangtikeutkorean") },
  { 0xF6F2, wxT("ssuperior") },
  { 0x00A3, wxT("sterling") },
  { 0xFFE1, wxT("sterlingmonospace") },
  { 0x0336, wxT("strokelongoverlaycmb") },
  { 0x0335, wxT("strokeshortoverlaycmb") },
  { 0x2282, wxT("subset") },
  { 0x228A, wxT("subsetnotequal") },
  { 0x2286, wxT("subsetorequal") },
  { 0x227B, wxT("succeeds") },
  { 0x220B, wxT("suchthat") },
  { 0x3059, wxT("suhiragana") },
  { 0x30B9, wxT("sukatakana") },
  { 0xFF7D, wxT("sukatakanahalfwidth") },
  { 0x0652, wxT("sukunarabic") },
  { 0x2211, wxT("summation") },
  { 0x263C, wxT("sun") },
  { 0x2283, wxT("superset") },
  { 0x228B, wxT("supersetnotequal") },
  { 0x2287, wxT("supersetorequal") },
  { 0x33DC, wxT("svsquare") },
  { 0x337C, wxT("syouwaerasquare") },
  { 0x0074, wxT("t") },
  { 0x09A4, wxT("tabengali") },
  { 0x22A4, wxT("tackdown") },
  { 0x22A3, wxT("tackleft") },
  { 0x0924, wxT("tadeva") },
  { 0x0AA4, wxT("tagujarati") },
  { 0x0A24, wxT("tagurmukhi") },
  { 0x0637, wxT("taharabic") },
  { 0xFEC2, wxT("tahfinalarabic") },
  { 0xFEC3, wxT("tahinitialarabic") },
  { 0x305F, wxT("tahiragana") },
  { 0xFEC4, wxT("tahmedialarabic") },
  { 0x337D, wxT("taisyouerasquare") },
  { 0x30BF, wxT("takatakana") },
  { 0xFF80, wxT("takatakanahalfwidth") },
  { 0x0640, wxT("tatweelarabic") },
  { 0x03C4, wxT("tau") },
  { 0x05EA, wxT("tav") },
  { 0xFB4A, wxT("tavdages") },
  { 0xFB4A, wxT("tavdagesh") },
  { 0xFB4A, wxT("tavdageshhebrew") },
  { 0x05EA, wxT("tavhebrew") },
  { 0x0167, wxT("tbar") },
  { 0x310A, wxT("tbopomofo") },
  { 0x0165, wxT("tcaron") },
  { 0x02A8, wxT("tccurl") },
  { 0x0163, wxT("tcedilla") },
  { 0x0686, wxT("tcheharabic") },
  { 0xFB7B, wxT("tchehfinalarabic") },
  { 0xFB7C, wxT("tchehinitialarabic") },
  { 0xFB7D, wxT("tchehmedialarabic") },
  { 0x24E3, wxT("tcircle") },
  { 0x1E71, wxT("tcircumflexbelow") },
  { 0x0163, wxT("tcommaaccent") },
  { 0x1E97, wxT("tdieresis") },
  { 0x1E6B, wxT("tdotaccent") },
  { 0x1E6D, wxT("tdotbelow") },
  { 0x0442, wxT("tecyrillic") },
  { 0x04AD, wxT("tedescendercyrillic") },
  { 0x062A, wxT("teharabic") },
  { 0xFE96, wxT("tehfinalarabic") },
  { 0xFCA2, wxT("tehhahinitialarabic") },
  { 0xFC0C, wxT("tehhahisolatedarabic") },
  { 0xFE97, wxT("tehinitialarabic") },
  { 0x3066, wxT("tehiragana") },
  { 0xFCA1, wxT("tehjeeminitialarabic") },
  { 0xFC0B, wxT("tehjeemisolatedarabic") },
  { 0x0629, wxT("tehmarbutaarabic") },
  { 0xFE94, wxT("tehmarbutafinalarabic") },
  { 0xFE98, wxT("tehmedialarabic") },
  { 0xFCA4, wxT("tehmeeminitialarabic") },
  { 0xFC0E, wxT("tehmeemisolatedarabic") },
  { 0xFC73, wxT("tehnoonfinalarabic") },
  { 0x30C6, wxT("tekatakana") },
  { 0xFF83, wxT("tekatakanahalfwidth") },
  { 0x2121, wxT("telephone") },
  { 0x260E, wxT("telephoneblack") },
  { 0x05A0, wxT("telishagedolahebrew") },
  { 0x05A9, wxT("telishaqetanahebrew") },
  { 0x2469, wxT("tencircle") },
  { 0x3229, wxT("tenideographicparen") },
  { 0x247D, wxT("tenparen") },
  { 0x2491, wxT("tenperiod") },
  { 0x2179, wxT("tenroman") },
  { 0x02A7, wxT("tesh") },
  { 0x05D8, wxT("tet") },
  { 0xFB38, wxT("tetdagesh") },
  { 0xFB38, wxT("tetdageshhebrew") },
  { 0x05D8, wxT("tethebrew") },
  { 0x04B5, wxT("tetsecyrillic") },
  { 0x059B, wxT("tevirhebrew") },
  { 0x059B, wxT("tevirlefthebrew") },
  { 0x09A5, wxT("thabengali") },
  { 0x0925, wxT("thadeva") },
  { 0x0AA5, wxT("thagujarati") },
  { 0x0A25, wxT("thagurmukhi") },
  { 0x0630, wxT("thalarabic") },
  { 0xFEAC, wxT("thalfinalarabic") },
  { 0xF898, wxT("thanthakhatlowleftthai") },
  { 0xF897, wxT("thanthakhatlowrightthai") },
  { 0x0E4C, wxT("thanthakhatthai") },
  { 0xF896, wxT("thanthakhatupperleftthai") },
  { 0x062B, wxT("theharabic") },
  { 0xFE9A, wxT("thehfinalarabic") },
  { 0xFE9B, wxT("thehinitialarabic") },
  { 0xFE9C, wxT("thehmedialarabic") },
  { 0x2203, wxT("thereexists") },
  { 0x2234, wxT("therefore") },
  { 0x03B8, wxT("theta") },
  { 0x03D1, wxT("theta1") },
  { 0x03D1, wxT("thetasymbolgreek") },
  { 0x3279, wxT("thieuthacirclekorean") },
  { 0x3219, wxT("thieuthaparenkorean") },
  { 0x326B, wxT("thieuthcirclekorean") },
  { 0x314C, wxT("thieuthkorean") },
  { 0x320B, wxT("thieuthparenkorean") },
  { 0x246C, wxT("thirteencircle") },
  { 0x2480, wxT("thirteenparen") },
  { 0x2494, wxT("thirteenperiod") },
  { 0x0E11, wxT("thonangmonthothai") },
  { 0x01AD, wxT("thook") },
  { 0x0E12, wxT("thophuthaothai") },
  { 0x00FE, wxT("thorn") },
  { 0x0E17, wxT("thothahanthai") },
  { 0x0E10, wxT("thothanthai") },
  { 0x0E18, wxT("thothongthai") },
  { 0x0E16, wxT("thothungthai") },
  { 0x0482, wxT("thousandcyrillic") },
  { 0x066C, wxT("thousandsseparatorarabic") },
  { 0x066C, wxT("thousandsseparatorpersian") },
  { 0x0033, wxT("three") },
  { 0x0663, wxT("threearabic") },
  { 0x09E9, wxT("threebengali") },
  { 0x2462, wxT("threecircle") },
  { 0x278C, wxT("threecircleinversesansserif") },
  { 0x0969, wxT("threedeva") },
  { 0x215C, wxT("threeeighths") },
  { 0x0AE9, wxT("threegujarati") },
  { 0x0A69, wxT("threegurmukhi") },
  { 0x0663, wxT("threehackarabic") },
  { 0x3023, wxT("threehangzhou") },
  { 0x3222, wxT("threeideographicparen") },
  { 0x2083, wxT("threeinferior") },
  { 0xFF13, wxT("threemonospace") },
  { 0x09F6, wxT("threenumeratorbengali") },
  { 0xF733, wxT("threeoldstyle") },
  { 0x2476, wxT("threeparen") },
  { 0x248A, wxT("threeperiod") },
  { 0x06F3, wxT("threepersian") },
  { 0x00BE, wxT("threequarters") },
  { 0xF6DE, wxT("threequartersemdash") },
  { 0x2172, wxT("threeroman") },
  { 0x00B3, wxT("threesuperior") },
  { 0x0E53, wxT("threethai") },
  { 0x3394, wxT("thzsquare") },
  { 0x3061, wxT("tihiragana") },
  { 0x30C1, wxT("tikatakana") },
  { 0xFF81, wxT("tikatakanahalfwidth") },
  { 0x3270, wxT("tikeutacirclekorean") },
  { 0x3210, wxT("tikeutaparenkorean") },
  { 0x3262, wxT("tikeutcirclekorean") },
  { 0x3137, wxT("tikeutkorean") },
  { 0x3202, wxT("tikeutparenkorean") },
  { 0x02DC, wxT("tilde") },
  { 0x0330, wxT("tildebelowcmb") },
  { 0x0303, wxT("tildecmb") },
  { 0x0303, wxT("tildecomb") },
  { 0x0360, wxT("tildedoublecmb") },
  { 0x223C, wxT("tildeoperator") },
  { 0x0334, wxT("tildeoverlaycmb") },
  { 0x033E, wxT("tildeverticalcmb") },
  { 0x2297, wxT("timescircle") },
  { 0x0596, wxT("tipehahebrew") },
  { 0x0596, wxT("tipehalefthebrew") },
  { 0x0A70, wxT("tippigurmukhi") },
  { 0x0483, wxT("titlocyrilliccmb") },
  { 0x057F, wxT("tiwnarmenian") },
  { 0x1E6F, wxT("tlinebelow") },
  { 0xFF54, wxT("tmonospace") },
  { 0x0569, wxT("toarmenian") },
  { 0x3068, wxT("tohiragana") },
  { 0x30C8, wxT("tokatakana") },
  { 0xFF84, wxT("tokatakanahalfwidth") },
  { 0x02E5, wxT("tonebarextrahighmod") },
  { 0x02E9, wxT("tonebarextralowmod") },
  { 0x02E6, wxT("tonebarhighmod") },
  { 0x02E8, wxT("tonebarlowmod") },
  { 0x02E7, wxT("tonebarmidmod") },
  { 0x01BD, wxT("tonefive") },
  { 0x0185, wxT("tonesix") },
  { 0x01A8, wxT("tonetwo") },
  { 0x0384, wxT("tonos") },
  { 0x3327, wxT("tonsquare") },
  { 0x0E0F, wxT("topatakthai") },
  { 0x3014, wxT("tortoiseshellbracketleft") },
  { 0xFE5D, wxT("tortoiseshellbracketleftsmall") },
  { 0xFE39, wxT("tortoiseshellbracketleftvertical") },
  { 0x3015, wxT("tortoiseshellbracketright") },
  { 0xFE5E, wxT("tortoiseshellbracketrightsmall") },
  { 0xFE3A, wxT("tortoiseshellbracketrightvertical") },
  { 0x0E15, wxT("totaothai") },
  { 0x01AB, wxT("tpalatalhook") },
  { 0x24AF, wxT("tparen") },
  { 0x2122, wxT("trademark") },
  { 0xF8EA, wxT("trademarksans") },
  { 0xF6DB, wxT("trademarkserif") },
  { 0x0288, wxT("tretroflexhook") },
  { 0x25BC, wxT("triagdn") },
  { 0x25C4, wxT("triaglf") },
  { 0x25BA, wxT("triagrt") },
  { 0x25B2, wxT("triagup") },
  { 0x02A6, wxT("ts") },
  { 0x05E6, wxT("tsadi") },
  { 0xFB46, wxT("tsadidagesh") },
  { 0xFB46, wxT("tsadidageshhebrew") },
  { 0x05E6, wxT("tsadihebrew") },
  { 0x0446, wxT("tsecyrillic") },
  { 0x05B5, wxT("tsere") },
  { 0x05B5, wxT("tsere12") },
  { 0x05B5, wxT("tsere1e") },
  { 0x05B5, wxT("tsere2b") },
  { 0x05B5, wxT("tserehebrew") },
  { 0x05B5, wxT("tserenarrowhebrew") },
  { 0x05B5, wxT("tserequarterhebrew") },
  { 0x05B5, wxT("tserewidehebrew") },
  { 0x045B, wxT("tshecyrillic") },
  { 0xF6F3, wxT("tsuperior") },
  { 0x099F, wxT("ttabengali") },
  { 0x091F, wxT("ttadeva") },
  { 0x0A9F, wxT("ttagujarati") },
  { 0x0A1F, wxT("ttagurmukhi") },
  { 0x0679, wxT("tteharabic") },
  { 0xFB67, wxT("ttehfinalarabic") },
  { 0xFB68, wxT("ttehinitialarabic") },
  { 0xFB69, wxT("ttehmedialarabic") },
  { 0x09A0, wxT("tthabengali") },
  { 0x0920, wxT("tthadeva") },
  { 0x0AA0, wxT("tthagujarati") },
  { 0x0A20, wxT("tthagurmukhi") },
  { 0x0287, wxT("tturned") },
  { 0x3064, wxT("tuhiragana") },
  { 0x30C4, wxT("tukatakana") },
  { 0xFF82, wxT("tukatakanahalfwidth") },
  { 0x3063, wxT("tusmallhiragana") },
  { 0x30C3, wxT("tusmallkatakana") },
  { 0xFF6F, wxT("tusmallkatakanahalfwidth") },
  { 0x246B, wxT("twelvecircle") },
  { 0x247F, wxT("twelveparen") },
  { 0x2493, wxT("twelveperiod") },
  { 0x217B, wxT("twelveroman") },
  { 0x2473, wxT("twentycircle") },
  { 0x5344, wxT("twentyhangzhou") },
  { 0x2487, wxT("twentyparen") },
  { 0x249B, wxT("twentyperiod") },
  { 0x0032, wxT("two") },
  { 0x0662, wxT("twoarabic") },
  { 0x09E8, wxT("twobengali") },
  { 0x2461, wxT("twocircle") },
  { 0x278B, wxT("twocircleinversesansserif") },
  { 0x0968, wxT("twodeva") },
  { 0x2025, wxT("twodotenleader") },
  { 0x2025, wxT("twodotleader") },
  { 0xFE30, wxT("twodotleadervertical") },
  { 0x0AE8, wxT("twogujarati") },
  { 0x0A68, wxT("twogurmukhi") },
  { 0x0662, wxT("twohackarabic") },
  { 0x3022, wxT("twohangzhou") },
  { 0x3221, wxT("twoideographicparen") },
  { 0x2082, wxT("twoinferior") },
  { 0xFF12, wxT("twomonospace") },
  { 0x09F5, wxT("twonumeratorbengali") },
  { 0xF732, wxT("twooldstyle") },
  { 0x2475, wxT("twoparen") },
  { 0x2489, wxT("twoperiod") },
  { 0x06F2, wxT("twopersian") },
  { 0x2171, wxT("tworoman") },
  { 0x01BB, wxT("twostroke") },
  { 0x00B2, wxT("twosuperior") },
  { 0x0E52, wxT("twothai") },
  { 0x2154, wxT("twothirds") },
  { 0x0075, wxT("u") },
  { 0x00FA, wxT("uacute") },
  { 0x0289, wxT("ubar") },
  { 0x0989, wxT("ubengali") },
  { 0x3128, wxT("ubopomofo") },
  { 0x016D, wxT("ubreve") },
  { 0x01D4, wxT("ucaron") },
  { 0x24E4, wxT("ucircle") },
  { 0x00FB, wxT("ucircumflex") },
  { 0x1E77, wxT("ucircumflexbelow") },
  { 0x0443, wxT("ucyrillic") },
  { 0x0951, wxT("udattadeva") },
  { 0x0171, wxT("udblacute") },
  { 0x0215, wxT("udblgrave") },
  { 0x0909, wxT("udeva") },
  { 0x00FC, wxT("udieresis") },
  { 0x01D8, wxT("udieresisacute") },
  { 0x1E73, wxT("udieresisbelow") },
  { 0x01DA, wxT("udieresiscaron") },
  { 0x04F1, wxT("udieresiscyrillic") },
  { 0x01DC, wxT("udieresisgrave") },
  { 0x01D6, wxT("udieresismacron") },
  { 0x1EE5, wxT("udotbelow") },
  { 0x00F9, wxT("ugrave") },
  { 0x0A89, wxT("ugujarati") },
  { 0x0A09, wxT("ugurmukhi") },
  { 0x3046, wxT("uhiragana") },
  { 0x1EE7, wxT("uhookabove") },
  { 0x01B0, wxT("uhorn") },
  { 0x1EE9, wxT("uhornacute") },
  { 0x1EF1, wxT("uhorndotbelow") },
  { 0x1EEB, wxT("uhorngrave") },
  { 0x1EED, wxT("uhornhookabove") },
  { 0x1EEF, wxT("uhorntilde") },
  { 0x0171, wxT("uhungarumlaut") },
  { 0x04F3, wxT("uhungarumlautcyrillic") },
  { 0x0217, wxT("uinvertedbreve") },
  { 0x30A6, wxT("ukatakana") },
  { 0xFF73, wxT("ukatakanahalfwidth") },
  { 0x0479, wxT("ukcyrillic") },
  { 0x315C, wxT("ukorean") },
  { 0x016B, wxT("umacron") },
  { 0x04EF, wxT("umacroncyrillic") },
  { 0x1E7B, wxT("umacrondieresis") },
  { 0x0A41, wxT("umatragurmukhi") },
  { 0xFF55, wxT("umonospace") },
  { 0x005F, wxT("underscore") },
  { 0x2017, wxT("underscoredbl") },
  { 0xFF3F, wxT("underscoremonospace") },
  { 0xFE33, wxT("underscorevertical") },
  { 0xFE4F, wxT("underscorewavy") },
  { 0x222A, wxT("union") },
  { 0x2200, wxT("universal") },
  { 0x0173, wxT("uogonek") },
  { 0x24B0, wxT("uparen") },
  { 0x2580, wxT("upblock") },
  { 0x05C4, wxT("upperdothebrew") },
  { 0x03C5, wxT("upsilon") },
  { 0x03CB, wxT("upsilondieresis") },
  { 0x03B0, wxT("upsilondieresistonos") },
  { 0x028A, wxT("upsilonlatin") },
  { 0x03CD, wxT("upsilontonos") },
  { 0x031D, wxT("uptackbelowcmb") },
  { 0x02D4, wxT("uptackmod") },
  { 0x0A73, wxT("uragurmukhi") },
  { 0x016F, wxT("uring") },
  { 0x045E, wxT("ushortcyrillic") },
  { 0x3045, wxT("usmallhiragana") },
  { 0x30A5, wxT("usmallkatakana") },
  { 0xFF69, wxT("usmallkatakanahalfwidth") },
  { 0x04AF, wxT("ustraightcyrillic") },
  { 0x04B1, wxT("ustraightstrokecyrillic") },
  { 0x0169, wxT("utilde") },
  { 0x1E79, wxT("utildeacute") },
  { 0x1E75, wxT("utildebelow") },
  { 0x098A, wxT("uubengali") },
  { 0x090A, wxT("uudeva") },
  { 0x0A8A, wxT("uugujarati") },
  { 0x0A0A, wxT("uugurmukhi") },
  { 0x0A42, wxT("uumatragurmukhi") },
  { 0x09C2, wxT("uuvowelsignbengali") },
  { 0x0942, wxT("uuvowelsigndeva") },
  { 0x0AC2, wxT("uuvowelsigngujarati") },
  { 0x09C1, wxT("uvowelsignbengali") },
  { 0x0941, wxT("uvowelsigndeva") },
  { 0x0AC1, wxT("uvowelsigngujarati") },
  { 0x0076, wxT("v") },
  { 0x0935, wxT("vadeva") },
  { 0x0AB5, wxT("vagujarati") },
  { 0x0A35, wxT("vagurmukhi") },
  { 0x30F7, wxT("vakatakana") },
  { 0x05D5, wxT("vav") },
  { 0xFB35, wxT("vavdagesh") },
  { 0xFB35, wxT("vavdagesh65") },
  { 0xFB35, wxT("vavdageshhebrew") },
  { 0x05D5, wxT("vavhebrew") },
  { 0xFB4B, wxT("vavholam") },
  { 0xFB4B, wxT("vavholamhebrew") },
  { 0x05F0, wxT("vavvavhebrew") },
  { 0x05F1, wxT("vavyodhebrew") },
  { 0x24E5, wxT("vcircle") },
  { 0x1E7F, wxT("vdotbelow") },
  { 0x0432, wxT("vecyrillic") },
  { 0x06A4, wxT("veharabic") },
  { 0xFB6B, wxT("vehfinalarabic") },
  { 0xFB6C, wxT("vehinitialarabic") },
  { 0xFB6D, wxT("vehmedialarabic") },
  { 0x30F9, wxT("vekatakana") },
  { 0x2640, wxT("venus") },
  { 0x007C, wxT("verticalbar") },
  { 0x030D, wxT("verticallineabovecmb") },
  { 0x0329, wxT("verticallinebelowcmb") },
  { 0x02CC, wxT("verticallinelowmod") },
  { 0x02C8, wxT("verticallinemod") },
  { 0x057E, wxT("vewarmenian") },
  { 0x028B, wxT("vhook") },
  { 0x30F8, wxT("vikatakana") },
  { 0x09CD, wxT("viramabengali") },
  { 0x094D, wxT("viramadeva") },
  { 0x0ACD, wxT("viramagujarati") },
  { 0x0983, wxT("visargabengali") },
  { 0x0903, wxT("visargadeva") },
  { 0x0A83, wxT("visargagujarati") },
  { 0xFF56, wxT("vmonospace") },
  { 0x0578, wxT("voarmenian") },
  { 0x309E, wxT("voicediterationhiragana") },
  { 0x30FE, wxT("voicediterationkatakana") },
  { 0x309B, wxT("voicedmarkkana") },
  { 0xFF9E, wxT("voicedmarkkanahalfwidth") },
  { 0x30FA, wxT("vokatakana") },
  { 0x24B1, wxT("vparen") },
  { 0x1E7D, wxT("vtilde") },
  { 0x028C, wxT("vturned") },
  { 0x3094, wxT("vuhiragana") },
  { 0x30F4, wxT("vukatakana") },
  { 0x0077, wxT("w") },
  { 0x1E83, wxT("wacute") },
  { 0x3159, wxT("waekorean") },
  { 0x308F, wxT("wahiragana") },
  { 0x30EF, wxT("wakatakana") },
  { 0xFF9C, wxT("wakatakanahalfwidth") },
  { 0x3158, wxT("wakorean") },
  { 0x308E, wxT("wasmallhiragana") },
  { 0x30EE, wxT("wasmallkatakana") },
  { 0x3357, wxT("wattosquare") },
  { 0x301C, wxT("wavedash") },
  { 0xFE34, wxT("wavyunderscorevertical") },
  { 0x0648, wxT("wawarabic") },
  { 0xFEEE, wxT("wawfinalarabic") },
  { 0x0624, wxT("wawhamzaabovearabic") },
  { 0xFE86, wxT("wawhamzaabovefinalarabic") },
  { 0x33DD, wxT("wbsquare") },
  { 0x24E6, wxT("wcircle") },
  { 0x0175, wxT("wcircumflex") },
  { 0x1E85, wxT("wdieresis") },
  { 0x1E87, wxT("wdotaccent") },
  { 0x1E89, wxT("wdotbelow") },
  { 0x3091, wxT("wehiragana") },
  { 0x2118, wxT("weierstrass") },
  { 0x30F1, wxT("wekatakana") },
  { 0x315E, wxT("wekorean") },
  { 0x315D, wxT("weokorean") },
  { 0x1E81, wxT("wgrave") },
  { 0x25E6, wxT("whitebullet") },
  { 0x25CB, wxT("whitecircle") },
  { 0x25D9, wxT("whitecircleinverse") },
  { 0x300E, wxT("whitecornerbracketleft") },
  { 0xFE43, wxT("whitecornerbracketleftvertical") },
  { 0x300F, wxT("whitecornerbracketright") },
  { 0xFE44, wxT("whitecornerbracketrightvertical") },
  { 0x25C7, wxT("whitediamond") },
  { 0x25C8, wxT("whitediamondcontainingblacksmalldiamond") },
  { 0x25BF, wxT("whitedownpointingsmalltriangle") },
  { 0x25BD, wxT("whitedownpointingtriangle") },
  { 0x25C3, wxT("whiteleftpointingsmalltriangle") },
  { 0x25C1, wxT("whiteleftpointingtriangle") },
  { 0x3016, wxT("whitelenticularbracketleft") },
  { 0x3017, wxT("whitelenticularbracketright") },
  { 0x25B9, wxT("whiterightpointingsmalltriangle") },
  { 0x25B7, wxT("whiterightpointingtriangle") },
  { 0x25AB, wxT("whitesmallsquare") },
  { 0x263A, wxT("whitesmilingface") },
  { 0x25A1, wxT("whitesquare") },
  { 0x2606, wxT("whitestar") },
  { 0x260F, wxT("whitetelephone") },
  { 0x3018, wxT("whitetortoiseshellbracketleft") },
  { 0x3019, wxT("whitetortoiseshellbracketright") },
  { 0x25B5, wxT("whiteuppointingsmalltriangle") },
  { 0x25B3, wxT("whiteuppointingtriangle") },
  { 0x3090, wxT("wihiragana") },
  { 0x30F0, wxT("wikatakana") },
  { 0x315F, wxT("wikorean") },
  { 0xFF57, wxT("wmonospace") },
  { 0x3092, wxT("wohiragana") },
  { 0x30F2, wxT("wokatakana") },
  { 0xFF66, wxT("wokatakanahalfwidth") },
  { 0x20A9, wxT("won") },
  { 0xFFE6, wxT("wonmonospace") },
  { 0x0E27, wxT("wowaenthai") },
  { 0x24B2, wxT("wparen") },
  { 0x1E98, wxT("wring") },
  { 0x02B7, wxT("wsuperior") },
  { 0x028D, wxT("wturned") },
  { 0x01BF, wxT("wynn") },
  { 0x0078, wxT("x") },
  { 0x033D, wxT("xabovecmb") },
  { 0x3112, wxT("xbopomofo") },
  { 0x24E7, wxT("xcircle") },
  { 0x1E8D, wxT("xdieresis") },
  { 0x1E8B, wxT("xdotaccent") },
  { 0x056D, wxT("xeharmenian") },
  { 0x03BE, wxT("xi") },
  { 0xFF58, wxT("xmonospace") },
  { 0x24B3, wxT("xparen") },
  { 0x02E3, wxT("xsuperior") },
  { 0x0079, wxT("y") },
  { 0x334E, wxT("yaadosquare") },
  { 0x09AF, wxT("yabengali") },
  { 0x00FD, wxT("yacute") },
  { 0x092F, wxT("yadeva") },
  { 0x3152, wxT("yaekorean") },
  { 0x0AAF, wxT("yagujarati") },
  { 0x0A2F, wxT("yagurmukhi") },
  { 0x3084, wxT("yahiragana") },
  { 0x30E4, wxT("yakatakana") },
  { 0xFF94, wxT("yakatakanahalfwidth") },
  { 0x3151, wxT("yakorean") },
  { 0x0E4E, wxT("yamakkanthai") },
  { 0x3083, wxT("yasmallhiragana") },
  { 0x30E3, wxT("yasmallkatakana") },
  { 0xFF6C, wxT("yasmallkatakanahalfwidth") },
  { 0x0463, wxT("yatcyrillic") },
  { 0x24E8, wxT("ycircle") },
  { 0x0177, wxT("ycircumflex") },
  { 0x00FF, wxT("ydieresis") },
  { 0x1E8F, wxT("ydotaccent") },
  { 0x1EF5, wxT("ydotbelow") },
  { 0x064A, wxT("yeharabic") },
  { 0x06D2, wxT("yehbarreearabic") },
  { 0xFBAF, wxT("yehbarreefinalarabic") },
  { 0xFEF2, wxT("yehfinalarabic") },
  { 0x0626, wxT("yehhamzaabovearabic") },
  { 0xFE8A, wxT("yehhamzaabovefinalarabic") },
  { 0xFE8B, wxT("yehhamzaaboveinitialarabic") },
  { 0xFE8C, wxT("yehhamzaabovemedialarabic") },
  { 0xFEF3, wxT("yehinitialarabic") },
  { 0xFEF4, wxT("yehmedialarabic") },
  { 0xFCDD, wxT("yehmeeminitialarabic") },
  { 0xFC58, wxT("yehmeemisolatedarabic") },
  { 0xFC94, wxT("yehnoonfinalarabic") },
  { 0x06D1, wxT("yehthreedotsbelowarabic") },
  { 0x3156, wxT("yekorean") },
  { 0x00A5, wxT("yen") },
  { 0xFFE5, wxT("yenmonospace") },
  { 0x3155, wxT("yeokorean") },
  { 0x3186, wxT("yeorinhieuhkorean") },
  { 0x05AA, wxT("yerahbenyomohebrew") },
  { 0x05AA, wxT("yerahbenyomolefthebrew") },
  { 0x044B, wxT("yericyrillic") },
  { 0x04F9, wxT("yerudieresiscyrillic") },
  { 0x3181, wxT("yesieungkorean") },
  { 0x3183, wxT("yesieungpansioskorean") },
  { 0x3182, wxT("yesieungsioskorean") },
  { 0x059A, wxT("yetivhebrew") },
  { 0x1EF3, wxT("ygrave") },
  { 0x01B4, wxT("yhook") },
  { 0x1EF7, wxT("yhookabove") },
  { 0x0575, wxT("yiarmenian") },
  { 0x0457, wxT("yicyrillic") },
  { 0x3162, wxT("yikorean") },
  { 0x262F, wxT("yinyang") },
  { 0x0582, wxT("yiwnarmenian") },
  { 0xFF59, wxT("ymonospace") },
  { 0x05D9, wxT("yod") },
  { 0xFB39, wxT("yoddagesh") },
  { 0xFB39, wxT("yoddageshhebrew") },
  { 0x05D9, wxT("yodhebrew") },
  { 0x05F2, wxT("yodyodhebrew") },
  { 0xFB1F, wxT("yodyodpatahhebrew") },
  { 0x3088, wxT("yohiragana") },
  { 0x3189, wxT("yoikorean") },
  { 0x30E8, wxT("yokatakana") },
  { 0xFF96, wxT("yokatakanahalfwidth") },
  { 0x315B, wxT("yokorean") },
  { 0x3087, wxT("yosmallhiragana") },
  { 0x30E7, wxT("yosmallkatakana") },
  { 0xFF6E, wxT("yosmallkatakanahalfwidth") },
  { 0x03F3, wxT("yotgreek") },
  { 0x3188, wxT("yoyaekorean") },
  { 0x3187, wxT("yoyakorean") },
  { 0x0E22, wxT("yoyakthai") },
  { 0x0E0D, wxT("yoyingthai") },
  { 0x24B4, wxT("yparen") },
  { 0x037A, wxT("ypogegrammeni") },
  { 0x0345, wxT("ypogegrammenigreekcmb") },
  { 0x01A6, wxT("yr") },
  { 0x1E99, wxT("yring") },
  { 0x02B8, wxT("ysuperior") },
  { 0x1EF9, wxT("ytilde") },
  { 0x028E, wxT("yturned") },
  { 0x3086, wxT("yuhiragana") },
  { 0x318C, wxT("yuikorean") },
  { 0x30E6, wxT("yukatakana") },
  { 0xFF95, wxT("yukatakanahalfwidth") },
  { 0x3160, wxT("yukorean") },
  { 0x046B, wxT("yusbigcyrillic") },
  { 0x046D, wxT("yusbigiotifiedcyrillic") },
  { 0x0467, wxT("yuslittlecyrillic") },
  { 0x0469, wxT("yuslittleiotifiedcyrillic") },
  { 0x3085, wxT("yusmallhiragana") },
  { 0x30E5, wxT("yusmallkatakana") },
  { 0xFF6D, wxT("yusmallkatakanahalfwidth") },
  { 0x318B, wxT("yuyekorean") },
  { 0x318A, wxT("yuyeokorean") },
  { 0x09DF, wxT("yyabengali") },
  { 0x095F, wxT("yyadeva") },
  { 0x007A, wxT("z") },
  { 0x0566, wxT("zaarmenian") },
  { 0x017A, wxT("zacute") },
  { 0x095B, wxT("zadeva") },
  { 0x0A5B, wxT("zagurmukhi") },
  { 0x0638, wxT("zaharabic") },
  { 0xFEC6, wxT("zahfinalarabic") },
  { 0xFEC7, wxT("zahinitialarabic") },
  { 0x3056, wxT("zahiragana") },
  { 0xFEC8, wxT("zahmedialarabic") },
  { 0x0632, wxT("zainarabic") },
  { 0xFEB0, wxT("zainfinalarabic") },
  { 0x30B6, wxT("zakatakana") },
  { 0x0595, wxT("zaqefgadolhebrew") },
  { 0x0594, wxT("zaqefqatanhebrew") },
  { 0x0598, wxT("zarqahebrew") },
  { 0x05D6, wxT("zayin") },
  { 0xFB36, wxT("zayindagesh") },
  { 0xFB36, wxT("zayindageshhebrew") },
  { 0x05D6, wxT("zayinhebrew") },
  { 0x3117, wxT("zbopomofo") },
  { 0x017E, wxT("zcaron") },
  { 0x24E9, wxT("zcircle") },
  { 0x1E91, wxT("zcircumflex") },
  { 0x0291, wxT("zcurl") },
  { 0x017C, wxT("zdot") },
  { 0x017C, wxT("zdotaccent") },
  { 0x1E93, wxT("zdotbelow") },
  { 0x0437, wxT("zecyrillic") },
  { 0x0499, wxT("zedescendercyrillic") },
  { 0x04DF, wxT("zedieresiscyrillic") },
  { 0x305C, wxT("zehiragana") },
  { 0x30BC, wxT("zekatakana") },
  { 0x0030, wxT("zero") },
  { 0x0660, wxT("zeroarabic") },
  { 0x09E6, wxT("zerobengali") },
  { 0x0966, wxT("zerodeva") },
  { 0x0AE6, wxT("zerogujarati") },
  { 0x0A66, wxT("zerogurmukhi") },
  { 0x0660, wxT("zerohackarabic") },
  { 0x2080, wxT("zeroinferior") },
  { 0xFF10, wxT("zeromonospace") },
  { 0xF730, wxT("zerooldstyle") },
  { 0x06F0, wxT("zeropersian") },
  { 0x2070, wxT("zerosuperior") },
  { 0x0E50, wxT("zerothai") },
  { 0xFEFF, wxT("zerowidthjoiner") },
  { 0x200C, wxT("zerowidthnonjoiner") },
  { 0x200B, wxT("zerowidthspace") },
  { 0x03B6, wxT("zeta") },
  { 0x3113, wxT("zhbopomofo") },
  { 0x056A, wxT("zhearmenian") },
  { 0x04C2, wxT("zhebrevecyrillic") },
  { 0x0436, wxT("zhecyrillic") },
  { 0x0497, wxT("zhedescendercyrillic") },
  { 0x04DD, wxT("zhedieresiscyrillic") },
  { 0x3058, wxT("zihiragana") },
  { 0x30B8, wxT("zikatakana") },
  { 0x05AE, wxT("zinorhebrew") },
  { 0x1E95, wxT("zlinebelow") },
  { 0xFF5A, wxT("zmonospace") },
  { 0x305E, wxT("zohiragana") },
  { 0x30BE, wxT("zokatakana") },
  { 0x24B5, wxT("zparen") },
  { 0x0290, wxT("zretroflexhook") },
  { 0x01B6, wxT("zstroke") },
  { 0x305A, wxT("zuhiragana") },
  { 0x30BA, wxT("zukatakana") },
  { 0x0000, wxT("") }
};

static const size_t gs_glyphName2UnicodeTableSize = 4200;

static const wxGlyphDesc gs_zapfDingBats2UnicodeTable[] =
{
  { 0x2701, wxT("a1") },
  { 0x2721, wxT("a10") },
  { 0x275E, wxT("a100") },
  { 0x2761, wxT("a101") },
  { 0x2762, wxT("a102") },
  { 0x2763, wxT("a103") },
  { 0x2764, wxT("a104") },
  { 0x2710, wxT("a105") },
  { 0x2765, wxT("a106") },
  { 0x2766, wxT("a107") },
  { 0x2767, wxT("a108") },
  { 0x2660, wxT("a109") },
  { 0x261B, wxT("a11") },
  { 0x2665, wxT("a110") },
  { 0x2666, wxT("a111") },
  { 0x2663, wxT("a112") },
  { 0x2709, wxT("a117") },
  { 0x2708, wxT("a118") },
  { 0x2707, wxT("a119") },
  { 0x261E, wxT("a12") },
  { 0x2460, wxT("a120") },
  { 0x2461, wxT("a121") },
  { 0x2462, wxT("a122") },
  { 0x2463, wxT("a123") },
  { 0x2464, wxT("a124") },
  { 0x2465, wxT("a125") },
  { 0x2466, wxT("a126") },
  { 0x2467, wxT("a127") },
  { 0x2468, wxT("a128") },
  { 0x2469, wxT("a129") },
  { 0x270C, wxT("a13") },
  { 0x2776, wxT("a130") },
  { 0x2777, wxT("a131") },
  { 0x2778, wxT("a132") },
  { 0x2779, wxT("a133") },
  { 0x277A, wxT("a134") },
  { 0x277B, wxT("a135") },
  { 0x277C, wxT("a136") },
  { 0x277D, wxT("a137") },
  { 0x277E, wxT("a138") },
  { 0x277F, wxT("a139") },
  { 0x270D, wxT("a14") },
  { 0x2780, wxT("a140") },
  { 0x2781, wxT("a141") },
  { 0x2782, wxT("a142") },
  { 0x2783, wxT("a143") },
  { 0x2784, wxT("a144") },
  { 0x2785, wxT("a145") },
  { 0x2786, wxT("a146") },
  { 0x2787, wxT("a147") },
  { 0x2788, wxT("a148") },
  { 0x2789, wxT("a149") },
  { 0x270E, wxT("a15") },
  { 0x278A, wxT("a150") },
  { 0x278B, wxT("a151") },
  { 0x278C, wxT("a152") },
  { 0x278D, wxT("a153") },
  { 0x278E, wxT("a154") },
  { 0x278F, wxT("a155") },
  { 0x2790, wxT("a156") },
  { 0x2791, wxT("a157") },
  { 0x2792, wxT("a158") },
  { 0x2793, wxT("a159") },
  { 0x270F, wxT("a16") },
  { 0x2794, wxT("a160") },
  { 0x2192, wxT("a161") },
  { 0x27A3, wxT("a162") },
  { 0x2194, wxT("a163") },
  { 0x2195, wxT("a164") },
  { 0x2799, wxT("a165") },
  { 0x279B, wxT("a166") },
  { 0x279C, wxT("a167") },
  { 0x279D, wxT("a168") },
  { 0x279E, wxT("a169") },
  { 0x2711, wxT("a17") },
  { 0x279F, wxT("a170") },
  { 0x27A0, wxT("a171") },
  { 0x27A1, wxT("a172") },
  { 0x27A2, wxT("a173") },
  { 0x27A4, wxT("a174") },
  { 0x27A5, wxT("a175") },
  { 0x27A6, wxT("a176") },
  { 0x27A7, wxT("a177") },
  { 0x27A8, wxT("a178") },
  { 0x27A9, wxT("a179") },
  { 0x2712, wxT("a18") },
  { 0x27AB, wxT("a180") },
  { 0x27AD, wxT("a181") },
  { 0x27AF, wxT("a182") },
  { 0x27B2, wxT("a183") },
  { 0x27B3, wxT("a184") },
  { 0x27B5, wxT("a185") },
  { 0x27B8, wxT("a186") },
  { 0x27BA, wxT("a187") },
  { 0x27BB, wxT("a188") },
  { 0x27BC, wxT("a189") },
  { 0x2713, wxT("a19") },
  { 0x27BD, wxT("a190") },
  { 0x27BE, wxT("a191") },
  { 0x279A, wxT("a192") },
  { 0x27AA, wxT("a193") },
  { 0x27B6, wxT("a194") },
  { 0x27B9, wxT("a195") },
  { 0x2798, wxT("a196") },
  { 0x27B4, wxT("a197") },
  { 0x27B7, wxT("a198") },
  { 0x27AC, wxT("a199") },
  { 0x2702, wxT("a2") },
  { 0x2714, wxT("a20") },
  { 0x27AE, wxT("a200") },
  { 0x27B1, wxT("a201") },
  { 0x2703, wxT("a202") },
  { 0x2750, wxT("a203") },
  { 0x2752, wxT("a204") },
  { 0x276E, wxT("a205") },
  { 0x2770, wxT("a206") },
  { 0x2715, wxT("a21") },
  { 0x2716, wxT("a22") },
  { 0x2717, wxT("a23") },
  { 0x2718, wxT("a24") },
  { 0x2719, wxT("a25") },
  { 0x271A, wxT("a26") },
  { 0x271B, wxT("a27") },
  { 0x271C, wxT("a28") },
  { 0x2722, wxT("a29") },
  { 0x2704, wxT("a3") },
  { 0x2723, wxT("a30") },
  { 0x2724, wxT("a31") },
  { 0x2725, wxT("a32") },
  { 0x2726, wxT("a33") },
  { 0x2727, wxT("a34") },
  { 0x2605, wxT("a35") },
  { 0x2729, wxT("a36") },
  { 0x272A, wxT("a37") },
  { 0x272B, wxT("a38") },
  { 0x272C, wxT("a39") },
  { 0x260E, wxT("a4") },
  { 0x272D, wxT("a40") },
  { 0x272E, wxT("a41") },
  { 0x272F, wxT("a42") },
  { 0x2730, wxT("a43") },
  { 0x2731, wxT("a44") },
  { 0x2732, wxT("a45") },
  { 0x2733, wxT("a46") },
  { 0x2734, wxT("a47") },
  { 0x2735, wxT("a48") },
  { 0x2736, wxT("a49") },
  { 0x2706, wxT("a5") },
  { 0x2737, wxT("a50") },
  { 0x2738, wxT("a51") },
  { 0x2739, wxT("a52") },
  { 0x273A, wxT("a53") },
  { 0x273B, wxT("a54") },
  { 0x273C, wxT("a55") },
  { 0x273D, wxT("a56") },
  { 0x273E, wxT("a57") },
  { 0x273F, wxT("a58") },
  { 0x2740, wxT("a59") },
  { 0x271D, wxT("a6") },
  { 0x2741, wxT("a60") },
  { 0x2742, wxT("a61") },
  { 0x2743, wxT("a62") },
  { 0x2744, wxT("a63") },
  { 0x2745, wxT("a64") },
  { 0x2746, wxT("a65") },
  { 0x2747, wxT("a66") },
  { 0x2748, wxT("a67") },
  { 0x2749, wxT("a68") },
  { 0x274A, wxT("a69") },
  { 0x271E, wxT("a7") },
  { 0x274B, wxT("a70") },
  { 0x25CF, wxT("a71") },
  { 0x274D, wxT("a72") },
  { 0x25A0, wxT("a73") },
  { 0x274F, wxT("a74") },
  { 0x2751, wxT("a75") },
  { 0x25B2, wxT("a76") },
  { 0x25BC, wxT("a77") },
  { 0x25C6, wxT("a78") },
  { 0x2756, wxT("a79") },
  { 0x271F, wxT("a8") },
  { 0x25D7, wxT("a81") },
  { 0x2758, wxT("a82") },
  { 0x2759, wxT("a83") },
  { 0x275A, wxT("a84") },
  { 0x276F, wxT("a85") },
  { 0x2771, wxT("a86") },
  { 0x2772, wxT("a87") },
  { 0x2773, wxT("a88") },
  { 0x2768, wxT("a89") },
  { 0x2720, wxT("a9") },
  { 0x2769, wxT("a90") },
  { 0x276C, wxT("a91") },
  { 0x276D, wxT("a92") },
  { 0x276A, wxT("a93") },
  { 0x276B, wxT("a94") },
  { 0x2774, wxT("a95") },
  { 0x2775, wxT("a96") },
  { 0x275B, wxT("a97") },
  { 0x275C, wxT("a98") },
  { 0x275D, wxT("a99") }
};

static const size_t gs_zapfDingBats2UnicodeTableSize = 201;

static const wxGlyphDesc gs_unicode2GlyphNameTable[] =
{
  { 0x0001, wxT("controlSTX") },
  { 0x0002, wxT("controlSOT") },
  { 0x0003, wxT("controlETX") },
  { 0x0004, wxT("controlEOT") },
  { 0x0005, wxT("controlENQ") },
  { 0x0006, wxT("controlACK") },
  { 0x0007, wxT("controlBEL") },
  { 0x0008, wxT("controlBS") },
  { 0x0009, wxT("controlHT") },
  { 0x000A, wxT("controlLF") },
  { 0x000B, wxT("controlVT") },
  { 0x000C, wxT("controlFF") },
  { 0x000D, wxT("controlCR") },
  { 0x000E, wxT("controlSO") },
  { 0x000F, wxT("controlSI") },
  { 0x0010, wxT("controlDLE") },
  { 0x0011, wxT("controlDC1") },
  { 0x0012, wxT("controlDC2") },
  { 0x0013, wxT("controlDC3") },
  { 0x0014, wxT("controlDC4") },
  { 0x0015, wxT("controlNAK") },
  { 0x0016, wxT("controlSYN") },
  { 0x0017, wxT("controlETB") },
  { 0x0018, wxT("controlCAN") },
  { 0x0019, wxT("controlEM") },
  { 0x001A, wxT("controlSUB") },
  { 0x001B, wxT("controlESC") },
  { 0x001C, wxT("controlFS") },
  { 0x001D, wxT("controlGS") },
  { 0x001E, wxT("controlRS") },
  { 0x001F, wxT("controlUS") },
  { 0x0020, wxT("space") },
  { 0x0021, wxT("exclam") },
  { 0x0022, wxT("quotedbl") },
  { 0x0023, wxT("numbersign") },
  { 0x0024, wxT("dollar") },
  { 0x0025, wxT("percent") },
  { 0x0026, wxT("ampersand") },
  { 0x0027, wxT("quotesingle") },
  { 0x0028, wxT("parenleft") },
  { 0x0029, wxT("parenright") },
  { 0x002A, wxT("asterisk") },
  { 0x002B, wxT("plus") },
  { 0x002C, wxT("comma") },
  { 0x002D, wxT("hyphen") },
  { 0x002E, wxT("period") },
  { 0x002F, wxT("slash") },
  { 0x0030, wxT("zero") },
  { 0x0031, wxT("one") },
  { 0x0032, wxT("two") },
  { 0x0033, wxT("three") },
  { 0x0034, wxT("four") },
  { 0x0035, wxT("five") },
  { 0x0036, wxT("six") },
  { 0x0037, wxT("seven") },
  { 0x0038, wxT("eight") },
  { 0x0039, wxT("nine") },
  { 0x003A, wxT("colon") },
  { 0x003B, wxT("semicolon") },
  { 0x003C, wxT("less") },
  { 0x003D, wxT("equal") },
  { 0x003E, wxT("greater") },
  { 0x003F, wxT("question") },
  { 0x0040, wxT("at") },
  { 0x0041, wxT("A") },
  { 0x0042, wxT("B") },
  { 0x0043, wxT("C") },
  { 0x0044, wxT("D") },
  { 0x0045, wxT("E") },
  { 0x0046, wxT("F") },
  { 0x0047, wxT("G") },
  { 0x0048, wxT("H") },
  { 0x0049, wxT("I") },
  { 0x004A, wxT("J") },
  { 0x004B, wxT("K") },
  { 0x004C, wxT("L") },
  { 0x004D, wxT("M") },
  { 0x004E, wxT("N") },
  { 0x004F, wxT("O") },
  { 0x0050, wxT("P") },
  { 0x0051, wxT("Q") },
  { 0x0052, wxT("R") },
  { 0x0053, wxT("S") },
  { 0x0054, wxT("T") },
  { 0x0055, wxT("U") },
  { 0x0056, wxT("V") },
  { 0x0057, wxT("W") },
  { 0x0058, wxT("X") },
  { 0x0059, wxT("Y") },
  { 0x005A, wxT("Z") },
  { 0x005B, wxT("bracketleft") },
  { 0x005C, wxT("backslash") },
  { 0x005D, wxT("bracketright") },
  { 0x005E, wxT("asciicircum") },
  { 0x005F, wxT("underscore") },
  { 0x0060, wxT("grave") },
  { 0x0061, wxT("a") },
  { 0x0062, wxT("b") },
  { 0x0063, wxT("c") },
  { 0x0064, wxT("d") },
  { 0x0065, wxT("e") },
  { 0x0066, wxT("f") },
  { 0x0067, wxT("g") },
  { 0x0068, wxT("h") },
  { 0x0069, wxT("i") },
  { 0x006A, wxT("j") },
  { 0x006B, wxT("k") },
  { 0x006C, wxT("l") },
  { 0x006D, wxT("m") },
  { 0x006E, wxT("n") },
  { 0x006F, wxT("o") },
  { 0x0070, wxT("p") },
  { 0x0071, wxT("q") },
  { 0x0072, wxT("r") },
  { 0x0073, wxT("s") },
  { 0x0074, wxT("t") },
  { 0x0075, wxT("u") },
  { 0x0076, wxT("v") },
  { 0x0077, wxT("w") },
  { 0x0078, wxT("x") },
  { 0x0079, wxT("y") },
  { 0x007A, wxT("z") },
  { 0x007B, wxT("braceleft") },
  { 0x007C, wxT("bar") },
  { 0x007D, wxT("braceright") },
  { 0x007E, wxT("asciitilde") },
  { 0x007F, wxT("controlDEL") },
  { 0x00A0, wxT("space") },
  { 0x00A1, wxT("exclamdown") },
  { 0x00A2, wxT("cent") },
  { 0x00A3, wxT("sterling") },
  { 0x00A4, wxT("currency") },
  { 0x00A5, wxT("yen") },
  { 0x00A6, wxT("brokenbar") },
  { 0x00A7, wxT("section") },
  { 0x00A8, wxT("dieresis") },
  { 0x00A9, wxT("copyright") },
  { 0x00AA, wxT("ordfeminine") },
  { 0x00AB, wxT("guillemotleft") },
  { 0x00AC, wxT("logicalnot") },
  { 0x00AD, wxT("hyphen") },
  { 0x00AE, wxT("registered") },
  { 0x00AF, wxT("macron") },
  { 0x00B0, wxT("degree") },
  { 0x00B1, wxT("plusminus") },
  { 0x00B2, wxT("twosuperior") },
  { 0x00B3, wxT("threesuperior") },
  { 0x00B4, wxT("acute") },
  { 0x00B5, wxT("mu") },
  { 0x00B6, wxT("paragraph") },
  { 0x00B7, wxT("periodcentered") },
  { 0x00B8, wxT("cedilla") },
  { 0x00B9, wxT("onesuperior") },
  { 0x00BA, wxT("ordmasculine") },
  { 0x00BB, wxT("guillemotright") },
  { 0x00BC, wxT("onequarter") },
  { 0x00BD, wxT("onehalf") },
  { 0x00BE, wxT("threequarters") },
  { 0x00BF, wxT("questiondown") },
  { 0x00C0, wxT("Agrave") },
  { 0x00C1, wxT("Aacute") },
  { 0x00C2, wxT("Acircumflex") },
  { 0x00C3, wxT("Atilde") },
  { 0x00C4, wxT("Adieresis") },
  { 0x00C5, wxT("Aring") },
  { 0x00C6, wxT("AE") },
  { 0x00C7, wxT("Ccedilla") },
  { 0x00C8, wxT("Egrave") },
  { 0x00C9, wxT("Eacute") },
  { 0x00CA, wxT("Ecircumflex") },
  { 0x00CB, wxT("Edieresis") },
  { 0x00CC, wxT("Igrave") },
  { 0x00CD, wxT("Iacute") },
  { 0x00CE, wxT("Icircumflex") },
  { 0x00CF, wxT("Idieresis") },
  { 0x00D0, wxT("Eth") },
  { 0x00D1, wxT("Ntilde") },
  { 0x00D2, wxT("Ograve") },
  { 0x00D3, wxT("Oacute") },
  { 0x00D4, wxT("Ocircumflex") },
  { 0x00D5, wxT("Otilde") },
  { 0x00D6, wxT("Odieresis") },
  { 0x00D7, wxT("multiply") },
  { 0x00D8, wxT("Oslash") },
  { 0x00D9, wxT("Ugrave") },
  { 0x00DA, wxT("Uacute") },
  { 0x00DB, wxT("Ucircumflex") },
  { 0x00DC, wxT("Udieresis") },
  { 0x00DD, wxT("Yacute") },
  { 0x00DE, wxT("Thorn") },
  { 0x00DF, wxT("germandbls") },
  { 0x00E0, wxT("agrave") },
  { 0x00E1, wxT("aacute") },
  { 0x00E2, wxT("acircumflex") },
  { 0x00E3, wxT("atilde") },
  { 0x00E4, wxT("adieresis") },
  { 0x00E5, wxT("aring") },
  { 0x00E6, wxT("ae") },
  { 0x00E7, wxT("ccedilla") },
  { 0x00E8, wxT("egrave") },
  { 0x00E9, wxT("eacute") },
  { 0x00EA, wxT("ecircumflex") },
  { 0x00EB, wxT("edieresis") },
  { 0x00EC, wxT("igrave") },
  { 0x00ED, wxT("iacute") },
  { 0x00EE, wxT("icircumflex") },
  { 0x00EF, wxT("idieresis") },
  { 0x00F0, wxT("eth") },
  { 0x00F1, wxT("ntilde") },
  { 0x00F2, wxT("ograve") },
  { 0x00F3, wxT("oacute") },
  { 0x00F4, wxT("ocircumflex") },
  { 0x00F5, wxT("otilde") },
  { 0x00F6, wxT("odieresis") },
  { 0x00F7, wxT("divide") },
  { 0x00F8, wxT("oslash") },
  { 0x00F9, wxT("ugrave") },
  { 0x00FA, wxT("uacute") },
  { 0x00FB, wxT("ucircumflex") },
  { 0x00FC, wxT("udieresis") },
  { 0x00FD, wxT("yacute") },
  { 0x00FE, wxT("thorn") },
  { 0x00FF, wxT("ydieresis") },
  { 0x0100, wxT("Amacron") },
  { 0x0101, wxT("amacron") },
  { 0x0102, wxT("Abreve") },
  { 0x0103, wxT("abreve") },
  { 0x0104, wxT("Aogonek") },
  { 0x0105, wxT("aogonek") },
  { 0x0106, wxT("Cacute") },
  { 0x0107, wxT("cacute") },
  { 0x0108, wxT("Ccircumflex") },
  { 0x0109, wxT("ccircumflex") },
  { 0x010A, wxT("Cdotaccent") },
  { 0x010B, wxT("cdotaccent") },
  { 0x010C, wxT("Ccaron") },
  { 0x010D, wxT("ccaron") },
  { 0x010E, wxT("Dcaron") },
  { 0x010F, wxT("dcaron") },
  { 0x0110, wxT("Dcroat") },
  { 0x0111, wxT("dcroat") },
  { 0x0112, wxT("Emacron") },
  { 0x0113, wxT("emacron") },
  { 0x0114, wxT("Ebreve") },
  { 0x0115, wxT("ebreve") },
  { 0x0116, wxT("Edotaccent") },
  { 0x0117, wxT("edotaccent") },
  { 0x0118, wxT("Eogonek") },
  { 0x0119, wxT("eogonek") },
  { 0x011A, wxT("Ecaron") },
  { 0x011B, wxT("ecaron") },
  { 0x011C, wxT("Gcircumflex") },
  { 0x011D, wxT("gcircumflex") },
  { 0x011E, wxT("Gbreve") },
  { 0x011F, wxT("gbreve") },
  { 0x0120, wxT("Gdotaccent") },
  { 0x0121, wxT("gdotaccent") },
  { 0x0122, wxT("Gcommaaccent") },
  { 0x0123, wxT("gcommaaccent") },
  { 0x0124, wxT("Hcircumflex") },
  { 0x0125, wxT("hcircumflex") },
  { 0x0126, wxT("Hbar") },
  { 0x0127, wxT("hbar") },
  { 0x0128, wxT("Itilde") },
  { 0x0129, wxT("itilde") },
  { 0x012A, wxT("Imacron") },
  { 0x012B, wxT("imacron") },
  { 0x012C, wxT("Ibreve") },
  { 0x012D, wxT("ibreve") },
  { 0x012E, wxT("Iogonek") },
  { 0x012F, wxT("iogonek") },
  { 0x0130, wxT("Idotaccent") },
  { 0x0131, wxT("dotlessi") },
  { 0x0132, wxT("IJ") },
  { 0x0133, wxT("ij") },
  { 0x0134, wxT("Jcircumflex") },
  { 0x0135, wxT("jcircumflex") },
  { 0x0136, wxT("Kcommaaccent") },
  { 0x0137, wxT("kcommaaccent") },
  { 0x0138, wxT("kgreenlandic") },
  { 0x0139, wxT("Lacute") },
  { 0x013A, wxT("lacute") },
  { 0x013B, wxT("Lcommaaccent") },
  { 0x013C, wxT("lcommaaccent") },
  { 0x013D, wxT("Lcaron") },
  { 0x013E, wxT("lcaron") },
  { 0x013F, wxT("Ldot") },
  { 0x0140, wxT("ldot") },
  { 0x0141, wxT("Lslash") },
  { 0x0142, wxT("lslash") },
  { 0x0143, wxT("Nacute") },
  { 0x0144, wxT("nacute") },
  { 0x0145, wxT("Ncommaaccent") },
  { 0x0146, wxT("ncommaaccent") },
  { 0x0147, wxT("Ncaron") },
  { 0x0148, wxT("ncaron") },
  { 0x0149, wxT("napostrophe") },
  { 0x014A, wxT("Eng") },
  { 0x014B, wxT("eng") },
  { 0x014C, wxT("Omacron") },
  { 0x014D, wxT("omacron") },
  { 0x014E, wxT("Obreve") },
  { 0x014F, wxT("obreve") },
  { 0x0150, wxT("Ohungarumlaut") },
  { 0x0151, wxT("ohungarumlaut") },
  { 0x0152, wxT("OE") },
  { 0x0153, wxT("oe") },
  { 0x0154, wxT("Racute") },
  { 0x0155, wxT("racute") },
  { 0x0156, wxT("Rcommaaccent") },
  { 0x0157, wxT("rcommaaccent") },
  { 0x0158, wxT("Rcaron") },
  { 0x0159, wxT("rcaron") },
  { 0x015A, wxT("Sacute") },
  { 0x015B, wxT("sacute") },
  { 0x015C, wxT("Scircumflex") },
  { 0x015D, wxT("scircumflex") },
  { 0x015E, wxT("Scedilla") },
  { 0x015F, wxT("scedilla") },
  { 0x0160, wxT("Scaron") },
  { 0x0161, wxT("scaron") },
  { 0x0162, wxT("Tcommaaccent") },
  { 0x0163, wxT("tcommaaccent") },
  { 0x0164, wxT("Tcaron") },
  { 0x0165, wxT("tcaron") },
  { 0x0166, wxT("Tbar") },
  { 0x0167, wxT("tbar") },
  { 0x0168, wxT("Utilde") },
  { 0x0169, wxT("utilde") },
  { 0x016A, wxT("Umacron") },
  { 0x016B, wxT("umacron") },
  { 0x016C, wxT("Ubreve") },
  { 0x016D, wxT("ubreve") },
  { 0x016E, wxT("Uring") },
  { 0x016F, wxT("uring") },
  { 0x0170, wxT("Uhungarumlaut") },
  { 0x0171, wxT("uhungarumlaut") },
  { 0x0172, wxT("Uogonek") },
  { 0x0173, wxT("uogonek") },
  { 0x0174, wxT("Wcircumflex") },
  { 0x0175, wxT("wcircumflex") },
  { 0x0176, wxT("Ycircumflex") },
  { 0x0177, wxT("ycircumflex") },
  { 0x0178, wxT("Ydieresis") },
  { 0x0179, wxT("Zacute") },
  { 0x017A, wxT("zacute") },
  { 0x017B, wxT("Zdotaccent") },
  { 0x017C, wxT("zdotaccent") },
  { 0x017D, wxT("Zcaron") },
  { 0x017E, wxT("zcaron") },
  { 0x017F, wxT("longs") },
  { 0x0180, wxT("bstroke") },
  { 0x0181, wxT("Bhook") },
  { 0x0182, wxT("Btopbar") },
  { 0x0183, wxT("btopbar") },
  { 0x0184, wxT("Tonesix") },
  { 0x0185, wxT("tonesix") },
  { 0x0186, wxT("Oopen") },
  { 0x0187, wxT("Chook") },
  { 0x0188, wxT("chook") },
  { 0x0189, wxT("Dafrican") },
  { 0x018A, wxT("Dhook") },
  { 0x018B, wxT("Dtopbar") },
  { 0x018C, wxT("dtopbar") },
  { 0x018D, wxT("deltaturned") },
  { 0x018E, wxT("Ereversed") },
  { 0x018F, wxT("Schwa") },
  { 0x0190, wxT("Eopen") },
  { 0x0191, wxT("Fhook") },
  { 0x0192, wxT("florin") },
  { 0x0193, wxT("Ghook") },
  { 0x0194, wxT("Gammaafrican") },
  { 0x0195, wxT("hv") },
  { 0x0196, wxT("Iotaafrican") },
  { 0x0197, wxT("Istroke") },
  { 0x0198, wxT("Khook") },
  { 0x0199, wxT("khook") },
  { 0x019A, wxT("lbar") },
  { 0x019B, wxT("lambdastroke") },
  { 0x019C, wxT("Mturned") },
  { 0x019D, wxT("Nhookleft") },
  { 0x019E, wxT("nlegrightlong") },
  { 0x019F, wxT("Ocenteredtilde") },
  { 0x01A0, wxT("Ohorn") },
  { 0x01A1, wxT("ohorn") },
  { 0x01A2, wxT("Oi") },
  { 0x01A3, wxT("oi") },
  { 0x01A4, wxT("Phook") },
  { 0x01A5, wxT("phook") },
  { 0x01A6, wxT("yr") },
  { 0x01A7, wxT("Tonetwo") },
  { 0x01A8, wxT("tonetwo") },
  { 0x01A9, wxT("Esh") },
  { 0x01AA, wxT("eshreversedloop") },
  { 0x01AB, wxT("tpalatalhook") },
  { 0x01AC, wxT("Thook") },
  { 0x01AD, wxT("thook") },
  { 0x01AE, wxT("Tretroflexhook") },
  { 0x01AF, wxT("Uhorn") },
  { 0x01B0, wxT("uhorn") },
  { 0x01B1, wxT("Upsilonafrican") },
  { 0x01B2, wxT("Vhook") },
  { 0x01B3, wxT("Yhook") },
  { 0x01B4, wxT("yhook") },
  { 0x01B5, wxT("Zstroke") },
  { 0x01B6, wxT("zstroke") },
  { 0x01B7, wxT("Ezh") },
  { 0x01B8, wxT("Ezhreversed") },
  { 0x01B9, wxT("ezhreversed") },
  { 0x01BA, wxT("ezhtail") },
  { 0x01BB, wxT("twostroke") },
  { 0x01BC, wxT("Tonefive") },
  { 0x01BD, wxT("tonefive") },
  { 0x01BE, wxT("glottalinvertedstroke") },
  { 0x01BF, wxT("wynn") },
  { 0x01C0, wxT("clickdental") },
  { 0x01C1, wxT("clicklateral") },
  { 0x01C2, wxT("clickalveolar") },
  { 0x01C3, wxT("clickretroflex") },
  { 0x01C4, wxT("DZcaron") },
  { 0x01C5, wxT("Dzcaron") },
  { 0x01C6, wxT("dzcaron") },
  { 0x01C7, wxT("LJ") },
  { 0x01C8, wxT("Lj") },
  { 0x01C9, wxT("lj") },
  { 0x01CA, wxT("NJ") },
  { 0x01CB, wxT("Nj") },
  { 0x01CC, wxT("nj") },
  { 0x01CD, wxT("Acaron") },
  { 0x01CE, wxT("acaron") },
  { 0x01CF, wxT("Icaron") },
  { 0x01D0, wxT("icaron") },
  { 0x01D1, wxT("Ocaron") },
  { 0x01D2, wxT("ocaron") },
  { 0x01D3, wxT("Ucaron") },
  { 0x01D4, wxT("ucaron") },
  { 0x01D5, wxT("Udieresismacron") },
  { 0x01D6, wxT("udieresismacron") },
  { 0x01D7, wxT("Udieresisacute") },
  { 0x01D8, wxT("udieresisacute") },
  { 0x01D9, wxT("Udieresiscaron") },
  { 0x01DA, wxT("udieresiscaron") },
  { 0x01DB, wxT("Udieresisgrave") },
  { 0x01DC, wxT("udieresisgrave") },
  { 0x01DD, wxT("eturned") },
  { 0x01DE, wxT("Adieresismacron") },
  { 0x01DF, wxT("adieresismacron") },
  { 0x01E0, wxT("Adotmacron") },
  { 0x01E1, wxT("adotmacron") },
  { 0x01E2, wxT("AEmacron") },
  { 0x01E3, wxT("aemacron") },
  { 0x01E4, wxT("Gstroke") },
  { 0x01E5, wxT("gstroke") },
  { 0x01E6, wxT("Gcaron") },
  { 0x01E7, wxT("gcaron") },
  { 0x01E8, wxT("Kcaron") },
  { 0x01E9, wxT("kcaron") },
  { 0x01EA, wxT("Oogonek") },
  { 0x01EB, wxT("oogonek") },
  { 0x01EC, wxT("Oogonekmacron") },
  { 0x01ED, wxT("oogonekmacron") },
  { 0x01EE, wxT("Ezhcaron") },
  { 0x01EF, wxT("ezhcaron") },
  { 0x01F0, wxT("jcaron") },
  { 0x01F1, wxT("DZ") },
  { 0x01F2, wxT("Dz") },
  { 0x01F3, wxT("dz") },
  { 0x01F4, wxT("Gacute") },
  { 0x01F5, wxT("gacute") },
  { 0x01FA, wxT("Aringacute") },
  { 0x01FB, wxT("aringacute") },
  { 0x01FC, wxT("AEacute") },
  { 0x01FD, wxT("aeacute") },
  { 0x01FE, wxT("Oslashacute") },
  { 0x01FF, wxT("oslashacute") },
  { 0x0200, wxT("Adblgrave") },
  { 0x0201, wxT("adblgrave") },
  { 0x0202, wxT("Ainvertedbreve") },
  { 0x0203, wxT("ainvertedbreve") },
  { 0x0204, wxT("Edblgrave") },
  { 0x0205, wxT("edblgrave") },
  { 0x0206, wxT("Einvertedbreve") },
  { 0x0207, wxT("einvertedbreve") },
  { 0x0208, wxT("Idblgrave") },
  { 0x0209, wxT("idblgrave") },
  { 0x020A, wxT("Iinvertedbreve") },
  { 0x020B, wxT("iinvertedbreve") },
  { 0x020C, wxT("Odblgrave") },
  { 0x020D, wxT("odblgrave") },
  { 0x020E, wxT("Oinvertedbreve") },
  { 0x020F, wxT("oinvertedbreve") },
  { 0x0210, wxT("Rdblgrave") },
  { 0x0211, wxT("rdblgrave") },
  { 0x0212, wxT("Rinvertedbreve") },
  { 0x0213, wxT("rinvertedbreve") },
  { 0x0214, wxT("Udblgrave") },
  { 0x0215, wxT("udblgrave") },
  { 0x0216, wxT("Uinvertedbreve") },
  { 0x0217, wxT("uinvertedbreve") },
  { 0x0218, wxT("Scommaaccent") },
  { 0x0219, wxT("scommaaccent") },
  { 0x021A, wxT("Tcommaaccent") },
  { 0x021B, wxT("tcommaaccent") },
  { 0x0250, wxT("aturned") },
  { 0x0251, wxT("ascript") },
  { 0x0252, wxT("ascriptturned") },
  { 0x0253, wxT("bhook") },
  { 0x0254, wxT("oopen") },
  { 0x0255, wxT("ccurl") },
  { 0x0256, wxT("dtail") },
  { 0x0257, wxT("dhook") },
  { 0x0258, wxT("ereversed") },
  { 0x0259, wxT("schwa") },
  { 0x025A, wxT("schwahook") },
  { 0x025B, wxT("eopen") },
  { 0x025C, wxT("eopenreversed") },
  { 0x025D, wxT("eopenreversedhook") },
  { 0x025E, wxT("eopenreversedclosed") },
  { 0x025F, wxT("jdotlessstroke") },
  { 0x0260, wxT("ghook") },
  { 0x0261, wxT("gscript") },
  { 0x0263, wxT("gammalatinsmall") },
  { 0x0264, wxT("ramshorn") },
  { 0x0265, wxT("hturned") },
  { 0x0266, wxT("hhook") },
  { 0x0267, wxT("henghook") },
  { 0x0268, wxT("istroke") },
  { 0x0269, wxT("iotalatin") },
  { 0x026B, wxT("lmiddletilde") },
  { 0x026C, wxT("lbelt") },
  { 0x026D, wxT("lhookretroflex") },
  { 0x026E, wxT("lezh") },
  { 0x026F, wxT("mturned") },
  { 0x0270, wxT("mlonglegturned") },
  { 0x0271, wxT("mhook") },
  { 0x0272, wxT("nhookleft") },
  { 0x0273, wxT("nhookretroflex") },
  { 0x0275, wxT("obarred") },
  { 0x0277, wxT("omegalatinclosed") },
  { 0x0278, wxT("philatin") },
  { 0x0279, wxT("rturned") },
  { 0x027A, wxT("rlonglegturned") },
  { 0x027B, wxT("rhookturned") },
  { 0x027C, wxT("rlongleg") },
  { 0x027D, wxT("rhook") },
  { 0x027E, wxT("rfishhook") },
  { 0x027F, wxT("rfishhookreversed") },
  { 0x0281, wxT("Rsmallinverted") },
  { 0x0282, wxT("shook") },
  { 0x0283, wxT("esh") },
  { 0x0284, wxT("dotlessjstrokehook") },
  { 0x0285, wxT("eshsquatreversed") },
  { 0x0286, wxT("eshcurl") },
  { 0x0287, wxT("tturned") },
  { 0x0288, wxT("tretroflexhook") },
  { 0x0289, wxT("ubar") },
  { 0x028A, wxT("upsilonlatin") },
  { 0x028B, wxT("vhook") },
  { 0x028C, wxT("vturned") },
  { 0x028D, wxT("wturned") },
  { 0x028E, wxT("yturned") },
  { 0x0290, wxT("zretroflexhook") },
  { 0x0291, wxT("zcurl") },
  { 0x0292, wxT("ezh") },
  { 0x0293, wxT("ezhcurl") },
  { 0x0294, wxT("glottalstop") },
  { 0x0295, wxT("glottalstopreversed") },
  { 0x0296, wxT("glottalstopinverted") },
  { 0x0297, wxT("cstretched") },
  { 0x0298, wxT("bilabialclick") },
  { 0x029A, wxT("eopenclosed") },
  { 0x029B, wxT("Gsmallhook") },
  { 0x029D, wxT("jcrossedtail") },
  { 0x029E, wxT("kturned") },
  { 0x02A0, wxT("qhook") },
  { 0x02A1, wxT("glottalstopstroke") },
  { 0x02A2, wxT("glottalstopstrokereversed") },
  { 0x02A3, wxT("dzaltone") },
  { 0x02A4, wxT("dezh") },
  { 0x02A5, wxT("dzcurl") },
  { 0x02A6, wxT("ts") },
  { 0x02A7, wxT("tesh") },
  { 0x02A8, wxT("tccurl") },
  { 0x02B0, wxT("hsuperior") },
  { 0x02B1, wxT("hhooksuperior") },
  { 0x02B2, wxT("jsuperior") },
  { 0x02B4, wxT("rturnedsuperior") },
  { 0x02B5, wxT("rhookturnedsuperior") },
  { 0x02B6, wxT("Rsmallinvertedsuperior") },
  { 0x02B7, wxT("wsuperior") },
  { 0x02B8, wxT("ysuperior") },
  { 0x02B9, wxT("primemod") },
  { 0x02BA, wxT("dblprimemod") },
  { 0x02BB, wxT("commaturnedmod") },
  { 0x02BC, wxT("afii57929") },
  { 0x02BD, wxT("afii64937") },
  { 0x02BE, wxT("ringhalfright") },
  { 0x02BF, wxT("ringhalfleft") },
  { 0x02C0, wxT("glottalstopmod") },
  { 0x02C1, wxT("glottalstopreversedmod") },
  { 0x02C2, wxT("arrowheadleftmod") },
  { 0x02C3, wxT("arrowheadrightmod") },
  { 0x02C4, wxT("arrowheadupmod") },
  { 0x02C5, wxT("arrowheaddownmod") },
  { 0x02C6, wxT("circumflex") },
  { 0x02C7, wxT("caron") },
  { 0x02C8, wxT("verticallinemod") },
  { 0x02C9, wxT("firsttonechinese") },
  { 0x02CA, wxT("secondtonechinese") },
  { 0x02CB, wxT("fourthtonechinese") },
  { 0x02CC, wxT("verticallinelowmod") },
  { 0x02CD, wxT("macronlowmod") },
  { 0x02CE, wxT("gravelowmod") },
  { 0x02CF, wxT("acutelowmod") },
  { 0x02D0, wxT("colontriangularmod") },
  { 0x02D1, wxT("colontriangularhalfmod") },
  { 0x02D2, wxT("ringhalfrightcentered") },
  { 0x02D3, wxT("ringhalfleftcentered") },
  { 0x02D4, wxT("uptackmod") },
  { 0x02D5, wxT("downtackmod") },
  { 0x02D6, wxT("plusmod") },
  { 0x02D7, wxT("minusmod") },
  { 0x02D8, wxT("breve") },
  { 0x02D9, wxT("dotaccent") },
  { 0x02DA, wxT("ring") },
  { 0x02DB, wxT("ogonek") },
  { 0x02DC, wxT("tilde") },
  { 0x02DD, wxT("hungarumlaut") },
  { 0x02DE, wxT("rhotichookmod") },
  { 0x02E0, wxT("gammasuperior") },
  { 0x02E3, wxT("xsuperior") },
  { 0x02E4, wxT("glottalstopreversedsuperior") },
  { 0x02E5, wxT("tonebarextrahighmod") },
  { 0x02E6, wxT("tonebarhighmod") },
  { 0x02E7, wxT("tonebarmidmod") },
  { 0x02E8, wxT("tonebarlowmod") },
  { 0x02E9, wxT("tonebarextralowmod") },
  { 0x0300, wxT("gravecomb") },
  { 0x0301, wxT("acutecomb") },
  { 0x0302, wxT("circumflexcmb") },
  { 0x0303, wxT("tildecomb") },
  { 0x0304, wxT("macroncmb") },
  { 0x0305, wxT("overlinecmb") },
  { 0x0306, wxT("brevecmb") },
  { 0x0307, wxT("dotaccentcmb") },
  { 0x0308, wxT("dieresiscmb") },
  { 0x0309, wxT("hookabovecomb") },
  { 0x030A, wxT("ringcmb") },
  { 0x030B, wxT("hungarumlautcmb") },
  { 0x030C, wxT("caroncmb") },
  { 0x030D, wxT("verticallineabovecmb") },
  { 0x030E, wxT("dblverticallineabovecmb") },
  { 0x030F, wxT("dblgravecmb") },
  { 0x0310, wxT("candrabinducmb") },
  { 0x0311, wxT("breveinvertedcmb") },
  { 0x0312, wxT("commaturnedabovecmb") },
  { 0x0313, wxT("commaabovecmb") },
  { 0x0314, wxT("commareversedabovecmb") },
  { 0x0315, wxT("commaaboverightcmb") },
  { 0x0316, wxT("gravebelowcmb") },
  { 0x0317, wxT("acutebelowcmb") },
  { 0x0318, wxT("lefttackbelowcmb") },
  { 0x0319, wxT("righttackbelowcmb") },
  { 0x031A, wxT("leftangleabovecmb") },
  { 0x031B, wxT("horncmb") },
  { 0x031C, wxT("ringhalfleftbelowcmb") },
  { 0x031D, wxT("uptackbelowcmb") },
  { 0x031E, wxT("downtackbelowcmb") },
  { 0x031F, wxT("plusbelowcmb") },
  { 0x0320, wxT("minusbelowcmb") },
  { 0x0321, wxT("hookpalatalizedbelowcmb") },
  { 0x0322, wxT("hookretroflexbelowcmb") },
  { 0x0323, wxT("dotbelowcomb") },
  { 0x0324, wxT("dieresisbelowcmb") },
  { 0x0325, wxT("ringbelowcmb") },
  { 0x0327, wxT("cedillacmb") },
  { 0x0328, wxT("ogonekcmb") },
  { 0x0329, wxT("verticallinebelowcmb") },
  { 0x032A, wxT("bridgebelowcmb") },
  { 0x032B, wxT("dblarchinvertedbelowcmb") },
  { 0x032C, wxT("caronbelowcmb") },
  { 0x032D, wxT("circumflexbelowcmb") },
  { 0x032E, wxT("brevebelowcmb") },
  { 0x032F, wxT("breveinvertedbelowcmb") },
  { 0x0330, wxT("tildebelowcmb") },
  { 0x0331, wxT("macronbelowcmb") },
  { 0x0332, wxT("lowlinecmb") },
  { 0x0333, wxT("dbllowlinecmb") },
  { 0x0334, wxT("tildeoverlaycmb") },
  { 0x0335, wxT("strokeshortoverlaycmb") },
  { 0x0336, wxT("strokelongoverlaycmb") },
  { 0x0337, wxT("solidusshortoverlaycmb") },
  { 0x0338, wxT("soliduslongoverlaycmb") },
  { 0x0339, wxT("ringhalfrightbelowcmb") },
  { 0x033A, wxT("bridgeinvertedbelowcmb") },
  { 0x033B, wxT("squarebelowcmb") },
  { 0x033C, wxT("seagullbelowcmb") },
  { 0x033D, wxT("xabovecmb") },
  { 0x033E, wxT("tildeverticalcmb") },
  { 0x033F, wxT("dbloverlinecmb") },
  { 0x0340, wxT("gravetonecmb") },
  { 0x0341, wxT("acutetonecmb") },
  { 0x0342, wxT("perispomenigreekcmb") },
  { 0x0343, wxT("koroniscmb") },
  { 0x0344, wxT("dialytikatonoscmb") },
  { 0x0345, wxT("ypogegrammenigreekcmb") },
  { 0x0360, wxT("tildedoublecmb") },
  { 0x0361, wxT("breveinverteddoublecmb") },
  { 0x0374, wxT("numeralsigngreek") },
  { 0x0375, wxT("numeralsignlowergreek") },
  { 0x037A, wxT("ypogegrammeni") },
  { 0x037E, wxT("questiongreek") },
  { 0x0384, wxT("tonos") },
  { 0x0385, wxT("dieresistonos") },
  { 0x0386, wxT("Alphatonos") },
  { 0x0387, wxT("anoteleia") },
  { 0x0388, wxT("Epsilontonos") },
  { 0x0389, wxT("Etatonos") },
  { 0x038A, wxT("Iotatonos") },
  { 0x038C, wxT("Omicrontonos") },
  { 0x038E, wxT("Upsilontonos") },
  { 0x038F, wxT("Omegatonos") },
  { 0x0390, wxT("iotadieresistonos") },
  { 0x0391, wxT("Alpha") },
  { 0x0392, wxT("Beta") },
  { 0x0393, wxT("Gamma") },
  { 0x0394, wxT("Delta") },
  { 0x0395, wxT("Epsilon") },
  { 0x0396, wxT("Zeta") },
  { 0x0397, wxT("Eta") },
  { 0x0398, wxT("Theta") },
  { 0x0399, wxT("Iota") },
  { 0x039A, wxT("Kappa") },
  { 0x039B, wxT("Lambda") },
  { 0x039C, wxT("Mu") },
  { 0x039D, wxT("Nu") },
  { 0x039E, wxT("Xi") },
  { 0x039F, wxT("Omicron") },
  { 0x03A0, wxT("Pi") },
  { 0x03A1, wxT("Rho") },
  { 0x03A3, wxT("Sigma") },
  { 0x03A4, wxT("Tau") },
  { 0x03A5, wxT("Upsilon") },
  { 0x03A6, wxT("Phi") },
  { 0x03A7, wxT("Chi") },
  { 0x03A8, wxT("Psi") },
  { 0x03A9, wxT("Omega") },
  { 0x03AA, wxT("Iotadieresis") },
  { 0x03AB, wxT("Upsilondieresis") },
  { 0x03AC, wxT("alphatonos") },
  { 0x03AD, wxT("epsilontonos") },
  { 0x03AE, wxT("etatonos") },
  { 0x03AF, wxT("iotatonos") },
  { 0x03B0, wxT("upsilondieresistonos") },
  { 0x03B1, wxT("alpha") },
  { 0x03B2, wxT("beta") },
  { 0x03B3, wxT("gamma") },
  { 0x03B4, wxT("delta") },
  { 0x03B5, wxT("epsilon") },
  { 0x03B6, wxT("zeta") },
  { 0x03B7, wxT("eta") },
  { 0x03B8, wxT("theta") },
  { 0x03B9, wxT("iota") },
  { 0x03BA, wxT("kappa") },
  { 0x03BB, wxT("lambda") },
  { 0x03BC, wxT("mu") },
  { 0x03BD, wxT("nu") },
  { 0x03BE, wxT("xi") },
  { 0x03BF, wxT("omicron") },
  { 0x03C0, wxT("pi") },
  { 0x03C1, wxT("rho") },
  { 0x03C2, wxT("sigma1") },
  { 0x03C3, wxT("sigma") },
  { 0x03C4, wxT("tau") },
  { 0x03C5, wxT("upsilon") },
  { 0x03C6, wxT("phi") },
  { 0x03C7, wxT("chi") },
  { 0x03C8, wxT("psi") },
  { 0x03C9, wxT("omega") },
  { 0x03CA, wxT("iotadieresis") },
  { 0x03CB, wxT("upsilondieresis") },
  { 0x03CC, wxT("omicrontonos") },
  { 0x03CD, wxT("upsilontonos") },
  { 0x03CE, wxT("omegatonos") },
  { 0x03D0, wxT("betasymbolgreek") },
  { 0x03D1, wxT("theta1") },
  { 0x03D2, wxT("Upsilon1") },
  { 0x03D3, wxT("Upsilonacutehooksymbolgreek") },
  { 0x03D4, wxT("Upsilondieresishooksymbolgreek") },
  { 0x03D5, wxT("phi1") },
  { 0x03D6, wxT("omega1") },
  { 0x03DA, wxT("Stigmagreek") },
  { 0x03DC, wxT("Digammagreek") },
  { 0x03DE, wxT("Koppagreek") },
  { 0x03E0, wxT("Sampigreek") },
  { 0x03E2, wxT("Sheicoptic") },
  { 0x03E3, wxT("sheicoptic") },
  { 0x03E4, wxT("Feicoptic") },
  { 0x03E5, wxT("feicoptic") },
  { 0x03E6, wxT("Kheicoptic") },
  { 0x03E7, wxT("kheicoptic") },
  { 0x03E8, wxT("Horicoptic") },
  { 0x03E9, wxT("horicoptic") },
  { 0x03EA, wxT("Gangiacoptic") },
  { 0x03EB, wxT("gangiacoptic") },
  { 0x03EC, wxT("Shimacoptic") },
  { 0x03ED, wxT("shimacoptic") },
  { 0x03EE, wxT("Deicoptic") },
  { 0x03EF, wxT("deicoptic") },
  { 0x03F0, wxT("kappasymbolgreek") },
  { 0x03F1, wxT("rhosymbolgreek") },
  { 0x03F2, wxT("sigmalunatesymbolgreek") },
  { 0x03F3, wxT("yotgreek") },
  { 0x0401, wxT("afii10023") },
  { 0x0402, wxT("afii10051") },
  { 0x0403, wxT("afii10052") },
  { 0x0404, wxT("afii10053") },
  { 0x0405, wxT("afii10054") },
  { 0x0406, wxT("afii10055") },
  { 0x0407, wxT("afii10056") },
  { 0x0408, wxT("afii10057") },
  { 0x0409, wxT("afii10058") },
  { 0x040A, wxT("afii10059") },
  { 0x040B, wxT("afii10060") },
  { 0x040C, wxT("afii10061") },
  { 0x040E, wxT("afii10062") },
  { 0x040F, wxT("afii10145") },
  { 0x0410, wxT("afii10017") },
  { 0x0411, wxT("afii10018") },
  { 0x0412, wxT("afii10019") },
  { 0x0413, wxT("afii10020") },
  { 0x0414, wxT("afii10021") },
  { 0x0415, wxT("afii10022") },
  { 0x0416, wxT("afii10024") },
  { 0x0417, wxT("afii10025") },
  { 0x0418, wxT("afii10026") },
  { 0x0419, wxT("afii10027") },
  { 0x041A, wxT("afii10028") },
  { 0x041B, wxT("afii10029") },
  { 0x041C, wxT("afii10030") },
  { 0x041D, wxT("afii10031") },
  { 0x041E, wxT("afii10032") },
  { 0x041F, wxT("afii10033") },
  { 0x0420, wxT("afii10034") },
  { 0x0421, wxT("afii10035") },
  { 0x0422, wxT("afii10036") },
  { 0x0423, wxT("afii10037") },
  { 0x0424, wxT("afii10038") },
  { 0x0425, wxT("afii10039") },
  { 0x0426, wxT("afii10040") },
  { 0x0427, wxT("afii10041") },
  { 0x0428, wxT("afii10042") },
  { 0x0429, wxT("afii10043") },
  { 0x042A, wxT("afii10044") },
  { 0x042B, wxT("afii10045") },
  { 0x042C, wxT("afii10046") },
  { 0x042D, wxT("afii10047") },
  { 0x042E, wxT("afii10048") },
  { 0x042F, wxT("afii10049") },
  { 0x0430, wxT("afii10065") },
  { 0x0431, wxT("afii10066") },
  { 0x0432, wxT("afii10067") },
  { 0x0433, wxT("afii10068") },
  { 0x0434, wxT("afii10069") },
  { 0x0435, wxT("afii10070") },
  { 0x0436, wxT("afii10072") },
  { 0x0437, wxT("afii10073") },
  { 0x0438, wxT("afii10074") },
  { 0x0439, wxT("afii10075") },
  { 0x043A, wxT("afii10076") },
  { 0x043B, wxT("afii10077") },
  { 0x043C, wxT("afii10078") },
  { 0x043D, wxT("afii10079") },
  { 0x043E, wxT("afii10080") },
  { 0x043F, wxT("afii10081") },
  { 0x0440, wxT("afii10082") },
  { 0x0441, wxT("afii10083") },
  { 0x0442, wxT("afii10084") },
  { 0x0443, wxT("afii10085") },
  { 0x0444, wxT("afii10086") },
  { 0x0445, wxT("afii10087") },
  { 0x0446, wxT("afii10088") },
  { 0x0447, wxT("afii10089") },
  { 0x0448, wxT("afii10090") },
  { 0x0449, wxT("afii10091") },
  { 0x044A, wxT("afii10092") },
  { 0x044B, wxT("afii10093") },
  { 0x044C, wxT("afii10094") },
  { 0x044D, wxT("afii10095") },
  { 0x044E, wxT("afii10096") },
  { 0x044F, wxT("afii10097") },
  { 0x0451, wxT("afii10071") },
  { 0x0452, wxT("afii10099") },
  { 0x0453, wxT("afii10100") },
  { 0x0454, wxT("afii10101") },
  { 0x0455, wxT("afii10102") },
  { 0x0456, wxT("afii10103") },
  { 0x0457, wxT("afii10104") },
  { 0x0458, wxT("afii10105") },
  { 0x0459, wxT("afii10106") },
  { 0x045A, wxT("afii10107") },
  { 0x045B, wxT("afii10108") },
  { 0x045C, wxT("afii10109") },
  { 0x045E, wxT("afii10110") },
  { 0x045F, wxT("afii10193") },
  { 0x0460, wxT("Omegacyrillic") },
  { 0x0461, wxT("omegacyrillic") },
  { 0x0462, wxT("afii10146") },
  { 0x0463, wxT("afii10194") },
  { 0x0464, wxT("Eiotifiedcyrillic") },
  { 0x0465, wxT("eiotifiedcyrillic") },
  { 0x0466, wxT("Yuslittlecyrillic") },
  { 0x0467, wxT("yuslittlecyrillic") },
  { 0x0468, wxT("Yuslittleiotifiedcyrillic") },
  { 0x0469, wxT("yuslittleiotifiedcyrillic") },
  { 0x046A, wxT("Yusbigcyrillic") },
  { 0x046B, wxT("yusbigcyrillic") },
  { 0x046C, wxT("Yusbigiotifiedcyrillic") },
  { 0x046D, wxT("yusbigiotifiedcyrillic") },
  { 0x046E, wxT("Ksicyrillic") },
  { 0x046F, wxT("ksicyrillic") },
  { 0x0470, wxT("Psicyrillic") },
  { 0x0471, wxT("psicyrillic") },
  { 0x0472, wxT("afii10147") },
  { 0x0473, wxT("afii10195") },
  { 0x0474, wxT("afii10148") },
  { 0x0475, wxT("afii10196") },
  { 0x0476, wxT("Izhitsadblgravecyrillic") },
  { 0x0477, wxT("izhitsadblgravecyrillic") },
  { 0x0478, wxT("Ukcyrillic") },
  { 0x0479, wxT("ukcyrillic") },
  { 0x047A, wxT("Omegaroundcyrillic") },
  { 0x047B, wxT("omegaroundcyrillic") },
  { 0x047C, wxT("Omegatitlocyrillic") },
  { 0x047D, wxT("omegatitlocyrillic") },
  { 0x047E, wxT("Otcyrillic") },
  { 0x047F, wxT("otcyrillic") },
  { 0x0480, wxT("Koppacyrillic") },
  { 0x0481, wxT("koppacyrillic") },
  { 0x0482, wxT("thousandcyrillic") },
  { 0x0483, wxT("titlocyrilliccmb") },
  { 0x0484, wxT("palatalizationcyrilliccmb") },
  { 0x0485, wxT("dasiapneumatacyrilliccmb") },
  { 0x0486, wxT("psilipneumatacyrilliccmb") },
  { 0x0490, wxT("afii10050") },
  { 0x0491, wxT("afii10098") },
  { 0x0492, wxT("Ghestrokecyrillic") },
  { 0x0493, wxT("ghestrokecyrillic") },
  { 0x0494, wxT("Ghemiddlehookcyrillic") },
  { 0x0495, wxT("ghemiddlehookcyrillic") },
  { 0x0496, wxT("Zhedescendercyrillic") },
  { 0x0497, wxT("zhedescendercyrillic") },
  { 0x0498, wxT("Zedescendercyrillic") },
  { 0x0499, wxT("zedescendercyrillic") },
  { 0x049A, wxT("Kadescendercyrillic") },
  { 0x049B, wxT("kadescendercyrillic") },
  { 0x049C, wxT("Kaverticalstrokecyrillic") },
  { 0x049D, wxT("kaverticalstrokecyrillic") },
  { 0x049E, wxT("Kastrokecyrillic") },
  { 0x049F, wxT("kastrokecyrillic") },
  { 0x04A0, wxT("Kabashkircyrillic") },
  { 0x04A1, wxT("kabashkircyrillic") },
  { 0x04A2, wxT("Endescendercyrillic") },
  { 0x04A3, wxT("endescendercyrillic") },
  { 0x04A4, wxT("Enghecyrillic") },
  { 0x04A5, wxT("enghecyrillic") },
  { 0x04A6, wxT("Pemiddlehookcyrillic") },
  { 0x04A7, wxT("pemiddlehookcyrillic") },
  { 0x04A8, wxT("Haabkhasiancyrillic") },
  { 0x04A9, wxT("haabkhasiancyrillic") },
  { 0x04AA, wxT("Esdescendercyrillic") },
  { 0x04AB, wxT("esdescendercyrillic") },
  { 0x04AC, wxT("Tedescendercyrillic") },
  { 0x04AD, wxT("tedescendercyrillic") },
  { 0x04AE, wxT("Ustraightcyrillic") },
  { 0x04AF, wxT("ustraightcyrillic") },
  { 0x04B0, wxT("Ustraightstrokecyrillic") },
  { 0x04B1, wxT("ustraightstrokecyrillic") },
  { 0x04B2, wxT("Hadescendercyrillic") },
  { 0x04B3, wxT("hadescendercyrillic") },
  { 0x04B4, wxT("Tetsecyrillic") },
  { 0x04B5, wxT("tetsecyrillic") },
  { 0x04B6, wxT("Chedescendercyrillic") },
  { 0x04B7, wxT("chedescendercyrillic") },
  { 0x04B8, wxT("Cheverticalstrokecyrillic") },
  { 0x04B9, wxT("cheverticalstrokecyrillic") },
  { 0x04BA, wxT("Shhacyrillic") },
  { 0x04BB, wxT("shhacyrillic") },
  { 0x04BC, wxT("Cheabkhasiancyrillic") },
  { 0x04BD, wxT("cheabkhasiancyrillic") },
  { 0x04BE, wxT("Chedescenderabkhasiancyrillic") },
  { 0x04BF, wxT("chedescenderabkhasiancyrillic") },
  { 0x04C0, wxT("palochkacyrillic") },
  { 0x04C1, wxT("Zhebrevecyrillic") },
  { 0x04C2, wxT("zhebrevecyrillic") },
  { 0x04C3, wxT("Kahookcyrillic") },
  { 0x04C4, wxT("kahookcyrillic") },
  { 0x04C7, wxT("Enhookcyrillic") },
  { 0x04C8, wxT("enhookcyrillic") },
  { 0x04CB, wxT("Chekhakassiancyrillic") },
  { 0x04CC, wxT("chekhakassiancyrillic") },
  { 0x04D0, wxT("Abrevecyrillic") },
  { 0x04D1, wxT("abrevecyrillic") },
  { 0x04D2, wxT("Adieresiscyrillic") },
  { 0x04D3, wxT("adieresiscyrillic") },
  { 0x04D4, wxT("Aiecyrillic") },
  { 0x04D5, wxT("aiecyrillic") },
  { 0x04D6, wxT("Iebrevecyrillic") },
  { 0x04D7, wxT("iebrevecyrillic") },
  { 0x04D8, wxT("Schwacyrillic") },
  { 0x04D9, wxT("afii10846") },
  { 0x04DA, wxT("Schwadieresiscyrillic") },
  { 0x04DB, wxT("schwadieresiscyrillic") },
  { 0x04DC, wxT("Zhedieresiscyrillic") },
  { 0x04DD, wxT("zhedieresiscyrillic") },
  { 0x04DE, wxT("Zedieresiscyrillic") },
  { 0x04DF, wxT("zedieresiscyrillic") },
  { 0x04E0, wxT("Dzeabkhasiancyrillic") },
  { 0x04E1, wxT("dzeabkhasiancyrillic") },
  { 0x04E2, wxT("Imacroncyrillic") },
  { 0x04E3, wxT("imacroncyrillic") },
  { 0x04E4, wxT("Idieresiscyrillic") },
  { 0x04E5, wxT("idieresiscyrillic") },
  { 0x04E6, wxT("Odieresiscyrillic") },
  { 0x04E7, wxT("odieresiscyrillic") },
  { 0x04E8, wxT("Obarredcyrillic") },
  { 0x04E9, wxT("obarredcyrillic") },
  { 0x04EA, wxT("Obarreddieresiscyrillic") },
  { 0x04EB, wxT("obarreddieresiscyrillic") },
  { 0x04EE, wxT("Umacroncyrillic") },
  { 0x04EF, wxT("umacroncyrillic") },
  { 0x04F0, wxT("Udieresiscyrillic") },
  { 0x04F1, wxT("udieresiscyrillic") },
  { 0x04F2, wxT("Uhungarumlautcyrillic") },
  { 0x04F3, wxT("uhungarumlautcyrillic") },
  { 0x04F4, wxT("Chedieresiscyrillic") },
  { 0x04F5, wxT("chedieresiscyrillic") },
  { 0x04F8, wxT("Yerudieresiscyrillic") },
  { 0x04F9, wxT("yerudieresiscyrillic") },
  { 0x0531, wxT("Aybarmenian") },
  { 0x0532, wxT("Benarmenian") },
  { 0x0533, wxT("Gimarmenian") },
  { 0x0534, wxT("Daarmenian") },
  { 0x0535, wxT("Echarmenian") },
  { 0x0536, wxT("Zaarmenian") },
  { 0x0537, wxT("Eharmenian") },
  { 0x0538, wxT("Etarmenian") },
  { 0x0539, wxT("Toarmenian") },
  { 0x053A, wxT("Zhearmenian") },
  { 0x053B, wxT("Iniarmenian") },
  { 0x053C, wxT("Liwnarmenian") },
  { 0x053D, wxT("Xeharmenian") },
  { 0x053E, wxT("Caarmenian") },
  { 0x053F, wxT("Kenarmenian") },
  { 0x0540, wxT("Hoarmenian") },
  { 0x0541, wxT("Jaarmenian") },
  { 0x0542, wxT("Ghadarmenian") },
  { 0x0543, wxT("Cheharmenian") },
  { 0x0544, wxT("Menarmenian") },
  { 0x0545, wxT("Yiarmenian") },
  { 0x0546, wxT("Nowarmenian") },
  { 0x0547, wxT("Shaarmenian") },
  { 0x0548, wxT("Voarmenian") },
  { 0x0549, wxT("Chaarmenian") },
  { 0x054A, wxT("Peharmenian") },
  { 0x054B, wxT("Jheharmenian") },
  { 0x054C, wxT("Raarmenian") },
  { 0x054D, wxT("Seharmenian") },
  { 0x054E, wxT("Vewarmenian") },
  { 0x054F, wxT("Tiwnarmenian") },
  { 0x0550, wxT("Reharmenian") },
  { 0x0551, wxT("Coarmenian") },
  { 0x0552, wxT("Yiwnarmenian") },
  { 0x0553, wxT("Piwrarmenian") },
  { 0x0554, wxT("Keharmenian") },
  { 0x0555, wxT("Oharmenian") },
  { 0x0556, wxT("Feharmenian") },
  { 0x0559, wxT("ringhalfleftarmenian") },
  { 0x055A, wxT("apostrophearmenian") },
  { 0x055B, wxT("emphasismarkarmenian") },
  { 0x055C, wxT("exclamarmenian") },
  { 0x055D, wxT("commaarmenian") },
  { 0x055E, wxT("questionarmenian") },
  { 0x055F, wxT("abbreviationmarkarmenian") },
  { 0x0561, wxT("aybarmenian") },
  { 0x0562, wxT("benarmenian") },
  { 0x0563, wxT("gimarmenian") },
  { 0x0564, wxT("daarmenian") },
  { 0x0565, wxT("echarmenian") },
  { 0x0566, wxT("zaarmenian") },
  { 0x0567, wxT("eharmenian") },
  { 0x0568, wxT("etarmenian") },
  { 0x0569, wxT("toarmenian") },
  { 0x056A, wxT("zhearmenian") },
  { 0x056B, wxT("iniarmenian") },
  { 0x056C, wxT("liwnarmenian") },
  { 0x056D, wxT("xeharmenian") },
  { 0x056E, wxT("caarmenian") },
  { 0x056F, wxT("kenarmenian") },
  { 0x0570, wxT("hoarmenian") },
  { 0x0571, wxT("jaarmenian") },
  { 0x0572, wxT("ghadarmenian") },
  { 0x0573, wxT("cheharmenian") },
  { 0x0574, wxT("menarmenian") },
  { 0x0575, wxT("yiarmenian") },
  { 0x0576, wxT("nowarmenian") },
  { 0x0577, wxT("shaarmenian") },
  { 0x0578, wxT("voarmenian") },
  { 0x0579, wxT("chaarmenian") },
  { 0x057A, wxT("peharmenian") },
  { 0x057B, wxT("jheharmenian") },
  { 0x057C, wxT("raarmenian") },
  { 0x057D, wxT("seharmenian") },
  { 0x057E, wxT("vewarmenian") },
  { 0x057F, wxT("tiwnarmenian") },
  { 0x0580, wxT("reharmenian") },
  { 0x0581, wxT("coarmenian") },
  { 0x0582, wxT("yiwnarmenian") },
  { 0x0583, wxT("piwrarmenian") },
  { 0x0584, wxT("keharmenian") },
  { 0x0585, wxT("oharmenian") },
  { 0x0586, wxT("feharmenian") },
  { 0x0587, wxT("echyiwnarmenian") },
  { 0x0589, wxT("periodarmenian") },
  { 0x0591, wxT("etnahtahebrew") },
  { 0x0592, wxT("segoltahebrew") },
  { 0x0593, wxT("shalshelethebrew") },
  { 0x0594, wxT("zaqefqatanhebrew") },
  { 0x0595, wxT("zaqefgadolhebrew") },
  { 0x0596, wxT("tipehahebrew") },
  { 0x0597, wxT("reviahebrew") },
  { 0x0598, wxT("zarqahebrew") },
  { 0x0599, wxT("pashtahebrew") },
  { 0x059A, wxT("yetivhebrew") },
  { 0x059B, wxT("tevirhebrew") },
  { 0x059C, wxT("gereshaccenthebrew") },
  { 0x059D, wxT("gereshmuqdamhebrew") },
  { 0x059E, wxT("gershayimaccenthebrew") },
  { 0x059F, wxT("qarneyparahebrew") },
  { 0x05A0, wxT("telishagedolahebrew") },
  { 0x05A1, wxT("pazerhebrew") },
  { 0x05A3, wxT("munahhebrew") },
  { 0x05A4, wxT("mahapakhhebrew") },
  { 0x05A5, wxT("merkhahebrew") },
  { 0x05A6, wxT("merkhakefulahebrew") },
  { 0x05A7, wxT("dargahebrew") },
  { 0x05A8, wxT("qadmahebrew") },
  { 0x05A9, wxT("telishaqetanahebrew") },
  { 0x05AA, wxT("yerahbenyomohebrew") },
  { 0x05AB, wxT("olehebrew") },
  { 0x05AC, wxT("iluyhebrew") },
  { 0x05AD, wxT("dehihebrew") },
  { 0x05AE, wxT("zinorhebrew") },
  { 0x05AF, wxT("masoracirclehebrew") },
  { 0x05B0, wxT("afii57799") },
  { 0x05B1, wxT("afii57801") },
  { 0x05B2, wxT("afii57800") },
  { 0x05B3, wxT("afii57802") },
  { 0x05B4, wxT("afii57793") },
  { 0x05B5, wxT("afii57794") },
  { 0x05B6, wxT("afii57795") },
  { 0x05B7, wxT("afii57798") },
  { 0x05B8, wxT("afii57797") },
  { 0x05B9, wxT("afii57806") },
  { 0x05BB, wxT("afii57796") },
  { 0x05BC, wxT("afii57807") },
  { 0x05BD, wxT("afii57839") },
  { 0x05BE, wxT("afii57645") },
  { 0x05BF, wxT("afii57841") },
  { 0x05C0, wxT("afii57842") },
  { 0x05C1, wxT("afii57804") },
  { 0x05C2, wxT("afii57803") },
  { 0x05C3, wxT("afii57658") },
  { 0x05C4, wxT("upperdothebrew") },
  { 0x05D0, wxT("afii57664") },
  { 0x05D1, wxT("afii57665") },
  { 0x05D2, wxT("afii57666") },
  { 0x05D3, wxT("afii57667") },
  { 0x05D4, wxT("afii57668") },
  { 0x05D5, wxT("afii57669") },
  { 0x05D6, wxT("afii57670") },
  { 0x05D7, wxT("afii57671") },
  { 0x05D8, wxT("afii57672") },
  { 0x05D9, wxT("afii57673") },
  { 0x05DA, wxT("afii57674") },
  { 0x05DB, wxT("afii57675") },
  { 0x05DC, wxT("afii57676") },
  { 0x05DD, wxT("afii57677") },
  { 0x05DE, wxT("afii57678") },
  { 0x05DF, wxT("afii57679") },
  { 0x05E0, wxT("afii57680") },
  { 0x05E1, wxT("afii57681") },
  { 0x05E2, wxT("afii57682") },
  { 0x05E3, wxT("afii57683") },
  { 0x05E4, wxT("afii57684") },
  { 0x05E5, wxT("afii57685") },
  { 0x05E6, wxT("afii57686") },
  { 0x05E7, wxT("afii57687") },
  { 0x05E8, wxT("afii57688") },
  { 0x05E9, wxT("afii57689") },
  { 0x05EA, wxT("afii57690") },
  { 0x05F0, wxT("afii57716") },
  { 0x05F1, wxT("afii57717") },
  { 0x05F2, wxT("afii57718") },
  { 0x05F3, wxT("gereshhebrew") },
  { 0x05F4, wxT("gershayimhebrew") },
  { 0x060C, wxT("afii57388") },
  { 0x061B, wxT("afii57403") },
  { 0x061F, wxT("afii57407") },
  { 0x0621, wxT("afii57409") },
  { 0x0622, wxT("afii57410") },
  { 0x0623, wxT("afii57411") },
  { 0x0624, wxT("afii57412") },
  { 0x0625, wxT("afii57413") },
  { 0x0626, wxT("afii57414") },
  { 0x0627, wxT("afii57415") },
  { 0x0628, wxT("afii57416") },
  { 0x0629, wxT("afii57417") },
  { 0x062A, wxT("afii57418") },
  { 0x062B, wxT("afii57419") },
  { 0x062C, wxT("afii57420") },
  { 0x062D, wxT("afii57421") },
  { 0x062E, wxT("afii57422") },
  { 0x062F, wxT("afii57423") },
  { 0x0630, wxT("afii57424") },
  { 0x0631, wxT("afii57425") },
  { 0x0632, wxT("afii57426") },
  { 0x0633, wxT("afii57427") },
  { 0x0634, wxT("afii57428") },
  { 0x0635, wxT("afii57429") },
  { 0x0636, wxT("afii57430") },
  { 0x0637, wxT("afii57431") },
  { 0x0638, wxT("afii57432") },
  { 0x0639, wxT("afii57433") },
  { 0x063A, wxT("afii57434") },
  { 0x0640, wxT("afii57440") },
  { 0x0641, wxT("afii57441") },
  { 0x0642, wxT("afii57442") },
  { 0x0643, wxT("afii57443") },
  { 0x0644, wxT("afii57444") },
  { 0x0645, wxT("afii57445") },
  { 0x0646, wxT("afii57446") },
  { 0x0647, wxT("afii57470") },
  { 0x0648, wxT("afii57448") },
  { 0x0649, wxT("afii57449") },
  { 0x064A, wxT("afii57450") },
  { 0x064B, wxT("afii57451") },
  { 0x064C, wxT("afii57452") },
  { 0x064D, wxT("afii57453") },
  { 0x064E, wxT("afii57454") },
  { 0x064F, wxT("afii57455") },
  { 0x0650, wxT("afii57456") },
  { 0x0651, wxT("afii57457") },
  { 0x0652, wxT("afii57458") },
  { 0x0660, wxT("afii57392") },
  { 0x0661, wxT("afii57393") },
  { 0x0662, wxT("afii57394") },
  { 0x0663, wxT("afii57395") },
  { 0x0664, wxT("afii57396") },
  { 0x0665, wxT("afii57397") },
  { 0x0666, wxT("afii57398") },
  { 0x0667, wxT("afii57399") },
  { 0x0668, wxT("afii57400") },
  { 0x0669, wxT("afii57401") },
  { 0x066A, wxT("afii57381") },
  { 0x066B, wxT("decimalseparatorarabic") },
  { 0x066C, wxT("thousandsseparatorarabic") },
  { 0x066D, wxT("afii63167") },
  { 0x0679, wxT("afii57511") },
  { 0x067E, wxT("afii57506") },
  { 0x0686, wxT("afii57507") },
  { 0x0688, wxT("afii57512") },
  { 0x0691, wxT("afii57513") },
  { 0x0698, wxT("afii57508") },
  { 0x06A4, wxT("afii57505") },
  { 0x06AF, wxT("afii57509") },
  { 0x06BA, wxT("afii57514") },
  { 0x06C1, wxT("hehaltonearabic") },
  { 0x06D1, wxT("yehthreedotsbelowarabic") },
  { 0x06D2, wxT("afii57519") },
  { 0x06D5, wxT("afii57534") },
  { 0x06F0, wxT("zeropersian") },
  { 0x06F1, wxT("onepersian") },
  { 0x06F2, wxT("twopersian") },
  { 0x06F3, wxT("threepersian") },
  { 0x06F4, wxT("fourpersian") },
  { 0x06F5, wxT("fivepersian") },
  { 0x06F6, wxT("sixpersian") },
  { 0x06F7, wxT("sevenpersian") },
  { 0x06F8, wxT("eightpersian") },
  { 0x06F9, wxT("ninepersian") },
  { 0x0901, wxT("candrabindudeva") },
  { 0x0902, wxT("anusvaradeva") },
  { 0x0903, wxT("visargadeva") },
  { 0x0905, wxT("adeva") },
  { 0x0906, wxT("aadeva") },
  { 0x0907, wxT("ideva") },
  { 0x0908, wxT("iideva") },
  { 0x0909, wxT("udeva") },
  { 0x090A, wxT("uudeva") },
  { 0x090B, wxT("rvocalicdeva") },
  { 0x090C, wxT("lvocalicdeva") },
  { 0x090D, wxT("ecandradeva") },
  { 0x090E, wxT("eshortdeva") },
  { 0x090F, wxT("edeva") },
  { 0x0910, wxT("aideva") },
  { 0x0911, wxT("ocandradeva") },
  { 0x0912, wxT("oshortdeva") },
  { 0x0913, wxT("odeva") },
  { 0x0914, wxT("audeva") },
  { 0x0915, wxT("kadeva") },
  { 0x0916, wxT("khadeva") },
  { 0x0917, wxT("gadeva") },
  { 0x0918, wxT("ghadeva") },
  { 0x0919, wxT("ngadeva") },
  { 0x091A, wxT("cadeva") },
  { 0x091B, wxT("chadeva") },
  { 0x091C, wxT("jadeva") },
  { 0x091D, wxT("jhadeva") },
  { 0x091E, wxT("nyadeva") },
  { 0x091F, wxT("ttadeva") },
  { 0x0920, wxT("tthadeva") },
  { 0x0921, wxT("ddadeva") },
  { 0x0922, wxT("ddhadeva") },
  { 0x0923, wxT("nnadeva") },
  { 0x0924, wxT("tadeva") },
  { 0x0925, wxT("thadeva") },
  { 0x0926, wxT("dadeva") },
  { 0x0927, wxT("dhadeva") },
  { 0x0928, wxT("nadeva") },
  { 0x0929, wxT("nnnadeva") },
  { 0x092A, wxT("padeva") },
  { 0x092B, wxT("phadeva") },
  { 0x092C, wxT("badeva") },
  { 0x092D, wxT("bhadeva") },
  { 0x092E, wxT("madeva") },
  { 0x092F, wxT("yadeva") },
  { 0x0930, wxT("radeva") },
  { 0x0931, wxT("rradeva") },
  { 0x0932, wxT("ladeva") },
  { 0x0933, wxT("lladeva") },
  { 0x0934, wxT("llladeva") },
  { 0x0935, wxT("vadeva") },
  { 0x0936, wxT("shadeva") },
  { 0x0937, wxT("ssadeva") },
  { 0x0938, wxT("sadeva") },
  { 0x0939, wxT("hadeva") },
  { 0x093C, wxT("nuktadeva") },
  { 0x093D, wxT("avagrahadeva") },
  { 0x093E, wxT("aavowelsigndeva") },
  { 0x093F, wxT("ivowelsigndeva") },
  { 0x0940, wxT("iivowelsigndeva") },
  { 0x0941, wxT("uvowelsigndeva") },
  { 0x0942, wxT("uuvowelsigndeva") },
  { 0x0943, wxT("rvocalicvowelsigndeva") },
  { 0x0944, wxT("rrvocalicvowelsigndeva") },
  { 0x0945, wxT("ecandravowelsigndeva") },
  { 0x0946, wxT("eshortvowelsigndeva") },
  { 0x0947, wxT("evowelsigndeva") },
  { 0x0948, wxT("aivowelsigndeva") },
  { 0x0949, wxT("ocandravowelsigndeva") },
  { 0x094A, wxT("oshortvowelsigndeva") },
  { 0x094B, wxT("ovowelsigndeva") },
  { 0x094C, wxT("auvowelsigndeva") },
  { 0x094D, wxT("viramadeva") },
  { 0x0950, wxT("omdeva") },
  { 0x0951, wxT("udattadeva") },
  { 0x0952, wxT("anudattadeva") },
  { 0x0953, wxT("gravedeva") },
  { 0x0954, wxT("acutedeva") },
  { 0x0958, wxT("qadeva") },
  { 0x0959, wxT("khhadeva") },
  { 0x095A, wxT("ghhadeva") },
  { 0x095B, wxT("zadeva") },
  { 0x095C, wxT("dddhadeva") },
  { 0x095D, wxT("rhadeva") },
  { 0x095E, wxT("fadeva") },
  { 0x095F, wxT("yyadeva") },
  { 0x0960, wxT("rrvocalicdeva") },
  { 0x0961, wxT("llvocalicdeva") },
  { 0x0962, wxT("lvocalicvowelsigndeva") },
  { 0x0963, wxT("llvocalicvowelsigndeva") },
  { 0x0964, wxT("danda") },
  { 0x0965, wxT("dbldanda") },
  { 0x0966, wxT("zerodeva") },
  { 0x0967, wxT("onedeva") },
  { 0x0968, wxT("twodeva") },
  { 0x0969, wxT("threedeva") },
  { 0x096A, wxT("fourdeva") },
  { 0x096B, wxT("fivedeva") },
  { 0x096C, wxT("sixdeva") },
  { 0x096D, wxT("sevendeva") },
  { 0x096E, wxT("eightdeva") },
  { 0x096F, wxT("ninedeva") },
  { 0x0970, wxT("abbreviationsigndeva") },
  { 0x0981, wxT("candrabindubengali") },
  { 0x0982, wxT("anusvarabengali") },
  { 0x0983, wxT("visargabengali") },
  { 0x0985, wxT("abengali") },
  { 0x0986, wxT("aabengali") },
  { 0x0987, wxT("ibengali") },
  { 0x0988, wxT("iibengali") },
  { 0x0989, wxT("ubengali") },
  { 0x098A, wxT("uubengali") },
  { 0x098B, wxT("rvocalicbengali") },
  { 0x098C, wxT("lvocalicbengali") },
  { 0x098F, wxT("ebengali") },
  { 0x0990, wxT("aibengali") },
  { 0x0993, wxT("obengali") },
  { 0x0994, wxT("aubengali") },
  { 0x0995, wxT("kabengali") },
  { 0x0996, wxT("khabengali") },
  { 0x0997, wxT("gabengali") },
  { 0x0998, wxT("ghabengali") },
  { 0x0999, wxT("ngabengali") },
  { 0x099A, wxT("cabengali") },
  { 0x099B, wxT("chabengali") },
  { 0x099C, wxT("jabengali") },
  { 0x099D, wxT("jhabengali") },
  { 0x099E, wxT("nyabengali") },
  { 0x099F, wxT("ttabengali") },
  { 0x09A0, wxT("tthabengali") },
  { 0x09A1, wxT("ddabengali") },
  { 0x09A2, wxT("ddhabengali") },
  { 0x09A3, wxT("nnabengali") },
  { 0x09A4, wxT("tabengali") },
  { 0x09A5, wxT("thabengali") },
  { 0x09A6, wxT("dabengali") },
  { 0x09A7, wxT("dhabengali") },
  { 0x09A8, wxT("nabengali") },
  { 0x09AA, wxT("pabengali") },
  { 0x09AB, wxT("phabengali") },
  { 0x09AC, wxT("babengali") },
  { 0x09AD, wxT("bhabengali") },
  { 0x09AE, wxT("mabengali") },
  { 0x09AF, wxT("yabengali") },
  { 0x09B0, wxT("rabengali") },
  { 0x09B2, wxT("labengali") },
  { 0x09B6, wxT("shabengali") },
  { 0x09B7, wxT("ssabengali") },
  { 0x09B8, wxT("sabengali") },
  { 0x09B9, wxT("habengali") },
  { 0x09BC, wxT("nuktabengali") },
  { 0x09BE, wxT("aavowelsignbengali") },
  { 0x09BF, wxT("ivowelsignbengali") },
  { 0x09C0, wxT("iivowelsignbengali") },
  { 0x09C1, wxT("uvowelsignbengali") },
  { 0x09C2, wxT("uuvowelsignbengali") },
  { 0x09C3, wxT("rvocalicvowelsignbengali") },
  { 0x09C4, wxT("rrvocalicvowelsignbengali") },
  { 0x09C7, wxT("evowelsignbengali") },
  { 0x09C8, wxT("aivowelsignbengali") },
  { 0x09CB, wxT("ovowelsignbengali") },
  { 0x09CC, wxT("auvowelsignbengali") },
  { 0x09CD, wxT("viramabengali") },
  { 0x09D7, wxT("aulengthmarkbengali") },
  { 0x09DC, wxT("rrabengali") },
  { 0x09DD, wxT("rhabengali") },
  { 0x09DF, wxT("yyabengali") },
  { 0x09E0, wxT("rrvocalicbengali") },
  { 0x09E1, wxT("llvocalicbengali") },
  { 0x09E2, wxT("lvocalicvowelsignbengali") },
  { 0x09E3, wxT("llvocalicvowelsignbengali") },
  { 0x09E6, wxT("zerobengali") },
  { 0x09E7, wxT("onebengali") },
  { 0x09E8, wxT("twobengali") },
  { 0x09E9, wxT("threebengali") },
  { 0x09EA, wxT("fourbengali") },
  { 0x09EB, wxT("fivebengali") },
  { 0x09EC, wxT("sixbengali") },
  { 0x09ED, wxT("sevenbengali") },
  { 0x09EE, wxT("eightbengali") },
  { 0x09EF, wxT("ninebengali") },
  { 0x09F0, wxT("ramiddlediagonalbengali") },
  { 0x09F1, wxT("ralowerdiagonalbengali") },
  { 0x09F2, wxT("rupeemarkbengali") },
  { 0x09F3, wxT("rupeesignbengali") },
  { 0x09F4, wxT("onenumeratorbengali") },
  { 0x09F5, wxT("twonumeratorbengali") },
  { 0x09F6, wxT("threenumeratorbengali") },
  { 0x09F7, wxT("fournumeratorbengali") },
  { 0x09F8, wxT("denominatorminusonenumeratorbengali") },
  { 0x09F9, wxT("sixteencurrencydenominatorbengali") },
  { 0x09FA, wxT("issharbengali") },
  { 0x0A02, wxT("bindigurmukhi") },
  { 0x0A05, wxT("agurmukhi") },
  { 0x0A06, wxT("aagurmukhi") },
  { 0x0A07, wxT("igurmukhi") },
  { 0x0A08, wxT("iigurmukhi") },
  { 0x0A09, wxT("ugurmukhi") },
  { 0x0A0A, wxT("uugurmukhi") },
  { 0x0A0F, wxT("eegurmukhi") },
  { 0x0A10, wxT("aigurmukhi") },
  { 0x0A13, wxT("oogurmukhi") },
  { 0x0A14, wxT("augurmukhi") },
  { 0x0A15, wxT("kagurmukhi") },
  { 0x0A16, wxT("khagurmukhi") },
  { 0x0A17, wxT("gagurmukhi") },
  { 0x0A18, wxT("ghagurmukhi") },
  { 0x0A19, wxT("ngagurmukhi") },
  { 0x0A1A, wxT("cagurmukhi") },
  { 0x0A1B, wxT("chagurmukhi") },
  { 0x0A1C, wxT("jagurmukhi") },
  { 0x0A1D, wxT("jhagurmukhi") },
  { 0x0A1E, wxT("nyagurmukhi") },
  { 0x0A1F, wxT("ttagurmukhi") },
  { 0x0A20, wxT("tthagurmukhi") },
  { 0x0A21, wxT("ddagurmukhi") },
  { 0x0A22, wxT("ddhagurmukhi") },
  { 0x0A23, wxT("nnagurmukhi") },
  { 0x0A24, wxT("tagurmukhi") },
  { 0x0A25, wxT("thagurmukhi") },
  { 0x0A26, wxT("dagurmukhi") },
  { 0x0A27, wxT("dhagurmukhi") },
  { 0x0A28, wxT("nagurmukhi") },
  { 0x0A2A, wxT("pagurmukhi") },
  { 0x0A2B, wxT("phagurmukhi") },
  { 0x0A2C, wxT("bagurmukhi") },
  { 0x0A2D, wxT("bhagurmukhi") },
  { 0x0A2E, wxT("magurmukhi") },
  { 0x0A2F, wxT("yagurmukhi") },
  { 0x0A30, wxT("ragurmukhi") },
  { 0x0A32, wxT("lagurmukhi") },
  { 0x0A35, wxT("vagurmukhi") },
  { 0x0A36, wxT("shagurmukhi") },
  { 0x0A38, wxT("sagurmukhi") },
  { 0x0A39, wxT("hagurmukhi") },
  { 0x0A3C, wxT("nuktagurmukhi") },
  { 0x0A3E, wxT("aamatragurmukhi") },
  { 0x0A3F, wxT("imatragurmukhi") },
  { 0x0A40, wxT("iimatragurmukhi") },
  { 0x0A41, wxT("umatragurmukhi") },
  { 0x0A42, wxT("uumatragurmukhi") },
  { 0x0A47, wxT("eematragurmukhi") },
  { 0x0A48, wxT("aimatragurmukhi") },
  { 0x0A4B, wxT("oomatragurmukhi") },
  { 0x0A4C, wxT("aumatragurmukhi") },
  { 0x0A4D, wxT("halantgurmukhi") },
  { 0x0A59, wxT("khhagurmukhi") },
  { 0x0A5A, wxT("ghhagurmukhi") },
  { 0x0A5B, wxT("zagurmukhi") },
  { 0x0A5C, wxT("rragurmukhi") },
  { 0x0A5E, wxT("fagurmukhi") },
  { 0x0A66, wxT("zerogurmukhi") },
  { 0x0A67, wxT("onegurmukhi") },
  { 0x0A68, wxT("twogurmukhi") },
  { 0x0A69, wxT("threegurmukhi") },
  { 0x0A6A, wxT("fourgurmukhi") },
  { 0x0A6B, wxT("fivegurmukhi") },
  { 0x0A6C, wxT("sixgurmukhi") },
  { 0x0A6D, wxT("sevengurmukhi") },
  { 0x0A6E, wxT("eightgurmukhi") },
  { 0x0A6F, wxT("ninegurmukhi") },
  { 0x0A70, wxT("tippigurmukhi") },
  { 0x0A71, wxT("addakgurmukhi") },
  { 0x0A72, wxT("irigurmukhi") },
  { 0x0A73, wxT("uragurmukhi") },
  { 0x0A74, wxT("ekonkargurmukhi") },
  { 0x0A81, wxT("candrabindugujarati") },
  { 0x0A82, wxT("anusvaragujarati") },
  { 0x0A83, wxT("visargagujarati") },
  { 0x0A85, wxT("agujarati") },
  { 0x0A86, wxT("aagujarati") },
  { 0x0A87, wxT("igujarati") },
  { 0x0A88, wxT("iigujarati") },
  { 0x0A89, wxT("ugujarati") },
  { 0x0A8A, wxT("uugujarati") },
  { 0x0A8B, wxT("rvocalicgujarati") },
  { 0x0A8D, wxT("ecandragujarati") },
  { 0x0A8F, wxT("egujarati") },
  { 0x0A90, wxT("aigujarati") },
  { 0x0A91, wxT("ocandragujarati") },
  { 0x0A93, wxT("ogujarati") },
  { 0x0A94, wxT("augujarati") },
  { 0x0A95, wxT("kagujarati") },
  { 0x0A96, wxT("khagujarati") },
  { 0x0A97, wxT("gagujarati") },
  { 0x0A98, wxT("ghagujarati") },
  { 0x0A99, wxT("ngagujarati") },
  { 0x0A9A, wxT("cagujarati") },
  { 0x0A9B, wxT("chagujarati") },
  { 0x0A9C, wxT("jagujarati") },
  { 0x0A9D, wxT("jhagujarati") },
  { 0x0A9E, wxT("nyagujarati") },
  { 0x0A9F, wxT("ttagujarati") },
  { 0x0AA0, wxT("tthagujarati") },
  { 0x0AA1, wxT("ddagujarati") },
  { 0x0AA2, wxT("ddhagujarati") },
  { 0x0AA3, wxT("nnagujarati") },
  { 0x0AA4, wxT("tagujarati") },
  { 0x0AA5, wxT("thagujarati") },
  { 0x0AA6, wxT("dagujarati") },
  { 0x0AA7, wxT("dhagujarati") },
  { 0x0AA8, wxT("nagujarati") },
  { 0x0AAA, wxT("pagujarati") },
  { 0x0AAB, wxT("phagujarati") },
  { 0x0AAC, wxT("bagujarati") },
  { 0x0AAD, wxT("bhagujarati") },
  { 0x0AAE, wxT("magujarati") },
  { 0x0AAF, wxT("yagujarati") },
  { 0x0AB0, wxT("ragujarati") },
  { 0x0AB2, wxT("lagujarati") },
  { 0x0AB3, wxT("llagujarati") },
  { 0x0AB5, wxT("vagujarati") },
  { 0x0AB6, wxT("shagujarati") },
  { 0x0AB7, wxT("ssagujarati") },
  { 0x0AB8, wxT("sagujarati") },
  { 0x0AB9, wxT("hagujarati") },
  { 0x0ABC, wxT("nuktagujarati") },
  { 0x0ABE, wxT("aavowelsigngujarati") },
  { 0x0ABF, wxT("ivowelsigngujarati") },
  { 0x0AC0, wxT("iivowelsigngujarati") },
  { 0x0AC1, wxT("uvowelsigngujarati") },
  { 0x0AC2, wxT("uuvowelsigngujarati") },
  { 0x0AC3, wxT("rvocalicvowelsigngujarati") },
  { 0x0AC4, wxT("rrvocalicvowelsigngujarati") },
  { 0x0AC5, wxT("ecandravowelsigngujarati") },
  { 0x0AC7, wxT("evowelsigngujarati") },
  { 0x0AC8, wxT("aivowelsigngujarati") },
  { 0x0AC9, wxT("ocandravowelsigngujarati") },
  { 0x0ACB, wxT("ovowelsigngujarati") },
  { 0x0ACC, wxT("auvowelsigngujarati") },
  { 0x0ACD, wxT("viramagujarati") },
  { 0x0AD0, wxT("omgujarati") },
  { 0x0AE0, wxT("rrvocalicgujarati") },
  { 0x0AE6, wxT("zerogujarati") },
  { 0x0AE7, wxT("onegujarati") },
  { 0x0AE8, wxT("twogujarati") },
  { 0x0AE9, wxT("threegujarati") },
  { 0x0AEA, wxT("fourgujarati") },
  { 0x0AEB, wxT("fivegujarati") },
  { 0x0AEC, wxT("sixgujarati") },
  { 0x0AED, wxT("sevengujarati") },
  { 0x0AEE, wxT("eightgujarati") },
  { 0x0AEF, wxT("ninegujarati") },
  { 0x0E01, wxT("kokaithai") },
  { 0x0E02, wxT("khokhaithai") },
  { 0x0E03, wxT("khokhuatthai") },
  { 0x0E04, wxT("khokhwaithai") },
  { 0x0E05, wxT("khokhonthai") },
  { 0x0E06, wxT("khorakhangthai") },
  { 0x0E07, wxT("ngonguthai") },
  { 0x0E08, wxT("chochanthai") },
  { 0x0E09, wxT("chochingthai") },
  { 0x0E0A, wxT("chochangthai") },
  { 0x0E0B, wxT("sosothai") },
  { 0x0E0C, wxT("chochoethai") },
  { 0x0E0D, wxT("yoyingthai") },
  { 0x0E0E, wxT("dochadathai") },
  { 0x0E0F, wxT("topatakthai") },
  { 0x0E10, wxT("thothanthai") },
  { 0x0E11, wxT("thonangmonthothai") },
  { 0x0E12, wxT("thophuthaothai") },
  { 0x0E13, wxT("nonenthai") },
  { 0x0E14, wxT("dodekthai") },
  { 0x0E15, wxT("totaothai") },
  { 0x0E16, wxT("thothungthai") },
  { 0x0E17, wxT("thothahanthai") },
  { 0x0E18, wxT("thothongthai") },
  { 0x0E19, wxT("nonuthai") },
  { 0x0E1A, wxT("bobaimaithai") },
  { 0x0E1B, wxT("poplathai") },
  { 0x0E1C, wxT("phophungthai") },
  { 0x0E1D, wxT("fofathai") },
  { 0x0E1E, wxT("phophanthai") },
  { 0x0E1F, wxT("fofanthai") },
  { 0x0E20, wxT("phosamphaothai") },
  { 0x0E21, wxT("momathai") },
  { 0x0E22, wxT("yoyakthai") },
  { 0x0E23, wxT("roruathai") },
  { 0x0E24, wxT("ruthai") },
  { 0x0E25, wxT("lolingthai") },
  { 0x0E26, wxT("luthai") },
  { 0x0E27, wxT("wowaenthai") },
  { 0x0E28, wxT("sosalathai") },
  { 0x0E29, wxT("sorusithai") },
  { 0x0E2A, wxT("sosuathai") },
  { 0x0E2B, wxT("hohipthai") },
  { 0x0E2C, wxT("lochulathai") },
  { 0x0E2D, wxT("oangthai") },
  { 0x0E2E, wxT("honokhukthai") },
  { 0x0E2F, wxT("paiyannoithai") },
  { 0x0E30, wxT("saraathai") },
  { 0x0E31, wxT("maihanakatthai") },
  { 0x0E32, wxT("saraaathai") },
  { 0x0E33, wxT("saraamthai") },
  { 0x0E34, wxT("saraithai") },
  { 0x0E35, wxT("saraiithai") },
  { 0x0E36, wxT("sarauethai") },
  { 0x0E37, wxT("saraueethai") },
  { 0x0E38, wxT("sarauthai") },
  { 0x0E39, wxT("sarauuthai") },
  { 0x0E3A, wxT("phinthuthai") },
  { 0x0E3F, wxT("bahtthai") },
  { 0x0E40, wxT("saraethai") },
  { 0x0E41, wxT("saraaethai") },
  { 0x0E42, wxT("saraothai") },
  { 0x0E43, wxT("saraaimaimuanthai") },
  { 0x0E44, wxT("saraaimaimalaithai") },
  { 0x0E45, wxT("lakkhangyaothai") },
  { 0x0E46, wxT("maiyamokthai") },
  { 0x0E47, wxT("maitaikhuthai") },
  { 0x0E48, wxT("maiekthai") },
  { 0x0E49, wxT("maithothai") },
  { 0x0E4A, wxT("maitrithai") },
  { 0x0E4B, wxT("maichattawathai") },
  { 0x0E4C, wxT("thanthakhatthai") },
  { 0x0E4D, wxT("nikhahitthai") },
  { 0x0E4E, wxT("yamakkanthai") },
  { 0x0E4F, wxT("fongmanthai") },
  { 0x0E50, wxT("zerothai") },
  { 0x0E51, wxT("onethai") },
  { 0x0E52, wxT("twothai") },
  { 0x0E53, wxT("threethai") },
  { 0x0E54, wxT("fourthai") },
  { 0x0E55, wxT("fivethai") },
  { 0x0E56, wxT("sixthai") },
  { 0x0E57, wxT("seventhai") },
  { 0x0E58, wxT("eightthai") },
  { 0x0E59, wxT("ninethai") },
  { 0x0E5A, wxT("angkhankhuthai") },
  { 0x0E5B, wxT("khomutthai") },
  { 0x1E00, wxT("Aringbelow") },
  { 0x1E01, wxT("aringbelow") },
  { 0x1E02, wxT("Bdotaccent") },
  { 0x1E03, wxT("bdotaccent") },
  { 0x1E04, wxT("Bdotbelow") },
  { 0x1E05, wxT("bdotbelow") },
  { 0x1E06, wxT("Blinebelow") },
  { 0x1E07, wxT("blinebelow") },
  { 0x1E08, wxT("Ccedillaacute") },
  { 0x1E09, wxT("ccedillaacute") },
  { 0x1E0A, wxT("Ddotaccent") },
  { 0x1E0B, wxT("ddotaccent") },
  { 0x1E0C, wxT("Ddotbelow") },
  { 0x1E0D, wxT("ddotbelow") },
  { 0x1E0E, wxT("Dlinebelow") },
  { 0x1E0F, wxT("dlinebelow") },
  { 0x1E10, wxT("Dcedilla") },
  { 0x1E11, wxT("dcedilla") },
  { 0x1E12, wxT("Dcircumflexbelow") },
  { 0x1E13, wxT("dcircumflexbelow") },
  { 0x1E14, wxT("Emacrongrave") },
  { 0x1E15, wxT("emacrongrave") },
  { 0x1E16, wxT("Emacronacute") },
  { 0x1E17, wxT("emacronacute") },
  { 0x1E18, wxT("Ecircumflexbelow") },
  { 0x1E19, wxT("ecircumflexbelow") },
  { 0x1E1A, wxT("Etildebelow") },
  { 0x1E1B, wxT("etildebelow") },
  { 0x1E1C, wxT("Ecedillabreve") },
  { 0x1E1D, wxT("ecedillabreve") },
  { 0x1E1E, wxT("Fdotaccent") },
  { 0x1E1F, wxT("fdotaccent") },
  { 0x1E20, wxT("Gmacron") },
  { 0x1E21, wxT("gmacron") },
  { 0x1E22, wxT("Hdotaccent") },
  { 0x1E23, wxT("hdotaccent") },
  { 0x1E24, wxT("Hdotbelow") },
  { 0x1E25, wxT("hdotbelow") },
  { 0x1E26, wxT("Hdieresis") },
  { 0x1E27, wxT("hdieresis") },
  { 0x1E28, wxT("Hcedilla") },
  { 0x1E29, wxT("hcedilla") },
  { 0x1E2A, wxT("Hbrevebelow") },
  { 0x1E2B, wxT("hbrevebelow") },
  { 0x1E2C, wxT("Itildebelow") },
  { 0x1E2D, wxT("itildebelow") },
  { 0x1E2E, wxT("Idieresisacute") },
  { 0x1E2F, wxT("idieresisacute") },
  { 0x1E30, wxT("Kacute") },
  { 0x1E31, wxT("kacute") },
  { 0x1E32, wxT("Kdotbelow") },
  { 0x1E33, wxT("kdotbelow") },
  { 0x1E34, wxT("Klinebelow") },
  { 0x1E35, wxT("klinebelow") },
  { 0x1E36, wxT("Ldotbelow") },
  { 0x1E37, wxT("ldotbelow") },
  { 0x1E38, wxT("Ldotbelowmacron") },
  { 0x1E39, wxT("ldotbelowmacron") },
  { 0x1E3A, wxT("Llinebelow") },
  { 0x1E3B, wxT("llinebelow") },
  { 0x1E3C, wxT("Lcircumflexbelow") },
  { 0x1E3D, wxT("lcircumflexbelow") },
  { 0x1E3E, wxT("Macute") },
  { 0x1E3F, wxT("macute") },
  { 0x1E40, wxT("Mdotaccent") },
  { 0x1E41, wxT("mdotaccent") },
  { 0x1E42, wxT("Mdotbelow") },
  { 0x1E43, wxT("mdotbelow") },
  { 0x1E44, wxT("Ndotaccent") },
  { 0x1E45, wxT("ndotaccent") },
  { 0x1E46, wxT("Ndotbelow") },
  { 0x1E47, wxT("ndotbelow") },
  { 0x1E48, wxT("Nlinebelow") },
  { 0x1E49, wxT("nlinebelow") },
  { 0x1E4A, wxT("Ncircumflexbelow") },
  { 0x1E4B, wxT("ncircumflexbelow") },
  { 0x1E4C, wxT("Otildeacute") },
  { 0x1E4D, wxT("otildeacute") },
  { 0x1E4E, wxT("Otildedieresis") },
  { 0x1E4F, wxT("otildedieresis") },
  { 0x1E50, wxT("Omacrongrave") },
  { 0x1E51, wxT("omacrongrave") },
  { 0x1E52, wxT("Omacronacute") },
  { 0x1E53, wxT("omacronacute") },
  { 0x1E54, wxT("Pacute") },
  { 0x1E55, wxT("pacute") },
  { 0x1E56, wxT("Pdotaccent") },
  { 0x1E57, wxT("pdotaccent") },
  { 0x1E58, wxT("Rdotaccent") },
  { 0x1E59, wxT("rdotaccent") },
  { 0x1E5A, wxT("Rdotbelow") },
  { 0x1E5B, wxT("rdotbelow") },
  { 0x1E5C, wxT("Rdotbelowmacron") },
  { 0x1E5D, wxT("rdotbelowmacron") },
  { 0x1E5E, wxT("Rlinebelow") },
  { 0x1E5F, wxT("rlinebelow") },
  { 0x1E60, wxT("Sdotaccent") },
  { 0x1E61, wxT("sdotaccent") },
  { 0x1E62, wxT("Sdotbelow") },
  { 0x1E63, wxT("sdotbelow") },
  { 0x1E64, wxT("Sacutedotaccent") },
  { 0x1E65, wxT("sacutedotaccent") },
  { 0x1E66, wxT("Scarondotaccent") },
  { 0x1E67, wxT("scarondotaccent") },
  { 0x1E68, wxT("Sdotbelowdotaccent") },
  { 0x1E69, wxT("sdotbelowdotaccent") },
  { 0x1E6A, wxT("Tdotaccent") },
  { 0x1E6B, wxT("tdotaccent") },
  { 0x1E6C, wxT("Tdotbelow") },
  { 0x1E6D, wxT("tdotbelow") },
  { 0x1E6E, wxT("Tlinebelow") },
  { 0x1E6F, wxT("tlinebelow") },
  { 0x1E70, wxT("Tcircumflexbelow") },
  { 0x1E71, wxT("tcircumflexbelow") },
  { 0x1E72, wxT("Udieresisbelow") },
  { 0x1E73, wxT("udieresisbelow") },
  { 0x1E74, wxT("Utildebelow") },
  { 0x1E75, wxT("utildebelow") },
  { 0x1E76, wxT("Ucircumflexbelow") },
  { 0x1E77, wxT("ucircumflexbelow") },
  { 0x1E78, wxT("Utildeacute") },
  { 0x1E79, wxT("utildeacute") },
  { 0x1E7A, wxT("Umacrondieresis") },
  { 0x1E7B, wxT("umacrondieresis") },
  { 0x1E7C, wxT("Vtilde") },
  { 0x1E7D, wxT("vtilde") },
  { 0x1E7E, wxT("Vdotbelow") },
  { 0x1E7F, wxT("vdotbelow") },
  { 0x1E80, wxT("Wgrave") },
  { 0x1E81, wxT("wgrave") },
  { 0x1E82, wxT("Wacute") },
  { 0x1E83, wxT("wacute") },
  { 0x1E84, wxT("Wdieresis") },
  { 0x1E85, wxT("wdieresis") },
  { 0x1E86, wxT("Wdotaccent") },
  { 0x1E87, wxT("wdotaccent") },
  { 0x1E88, wxT("Wdotbelow") },
  { 0x1E89, wxT("wdotbelow") },
  { 0x1E8A, wxT("Xdotaccent") },
  { 0x1E8B, wxT("xdotaccent") },
  { 0x1E8C, wxT("Xdieresis") },
  { 0x1E8D, wxT("xdieresis") },
  { 0x1E8E, wxT("Ydotaccent") },
  { 0x1E8F, wxT("ydotaccent") },
  { 0x1E90, wxT("Zcircumflex") },
  { 0x1E91, wxT("zcircumflex") },
  { 0x1E92, wxT("Zdotbelow") },
  { 0x1E93, wxT("zdotbelow") },
  { 0x1E94, wxT("Zlinebelow") },
  { 0x1E95, wxT("zlinebelow") },
  { 0x1E96, wxT("hlinebelow") },
  { 0x1E97, wxT("tdieresis") },
  { 0x1E98, wxT("wring") },
  { 0x1E99, wxT("yring") },
  { 0x1E9A, wxT("arighthalfring") },
  { 0x1E9B, wxT("slongdotaccent") },
  { 0x1EA0, wxT("Adotbelow") },
  { 0x1EA1, wxT("adotbelow") },
  { 0x1EA2, wxT("Ahookabove") },
  { 0x1EA3, wxT("ahookabove") },
  { 0x1EA4, wxT("Acircumflexacute") },
  { 0x1EA5, wxT("acircumflexacute") },
  { 0x1EA6, wxT("Acircumflexgrave") },
  { 0x1EA7, wxT("acircumflexgrave") },
  { 0x1EA8, wxT("Acircumflexhookabove") },
  { 0x1EA9, wxT("acircumflexhookabove") },
  { 0x1EAA, wxT("Acircumflextilde") },
  { 0x1EAB, wxT("acircumflextilde") },
  { 0x1EAC, wxT("Acircumflexdotbelow") },
  { 0x1EAD, wxT("acircumflexdotbelow") },
  { 0x1EAE, wxT("Abreveacute") },
  { 0x1EAF, wxT("abreveacute") },
  { 0x1EB0, wxT("Abrevegrave") },
  { 0x1EB1, wxT("abrevegrave") },
  { 0x1EB2, wxT("Abrevehookabove") },
  { 0x1EB3, wxT("abrevehookabove") },
  { 0x1EB4, wxT("Abrevetilde") },
  { 0x1EB5, wxT("abrevetilde") },
  { 0x1EB6, wxT("Abrevedotbelow") },
  { 0x1EB7, wxT("abrevedotbelow") },
  { 0x1EB8, wxT("Edotbelow") },
  { 0x1EB9, wxT("edotbelow") },
  { 0x1EBA, wxT("Ehookabove") },
  { 0x1EBB, wxT("ehookabove") },
  { 0x1EBC, wxT("Etilde") },
  { 0x1EBD, wxT("etilde") },
  { 0x1EBE, wxT("Ecircumflexacute") },
  { 0x1EBF, wxT("ecircumflexacute") },
  { 0x1EC0, wxT("Ecircumflexgrave") },
  { 0x1EC1, wxT("ecircumflexgrave") },
  { 0x1EC2, wxT("Ecircumflexhookabove") },
  { 0x1EC3, wxT("ecircumflexhookabove") },
  { 0x1EC4, wxT("Ecircumflextilde") },
  { 0x1EC5, wxT("ecircumflextilde") },
  { 0x1EC6, wxT("Ecircumflexdotbelow") },
  { 0x1EC7, wxT("ecircumflexdotbelow") },
  { 0x1EC8, wxT("Ihookabove") },
  { 0x1EC9, wxT("ihookabove") },
  { 0x1ECA, wxT("Idotbelow") },
  { 0x1ECB, wxT("idotbelow") },
  { 0x1ECC, wxT("Odotbelow") },
  { 0x1ECD, wxT("odotbelow") },
  { 0x1ECE, wxT("Ohookabove") },
  { 0x1ECF, wxT("ohookabove") },
  { 0x1ED0, wxT("Ocircumflexacute") },
  { 0x1ED1, wxT("ocircumflexacute") },
  { 0x1ED2, wxT("Ocircumflexgrave") },
  { 0x1ED3, wxT("ocircumflexgrave") },
  { 0x1ED4, wxT("Ocircumflexhookabove") },
  { 0x1ED5, wxT("ocircumflexhookabove") },
  { 0x1ED6, wxT("Ocircumflextilde") },
  { 0x1ED7, wxT("ocircumflextilde") },
  { 0x1ED8, wxT("Ocircumflexdotbelow") },
  { 0x1ED9, wxT("ocircumflexdotbelow") },
  { 0x1EDA, wxT("Ohornacute") },
  { 0x1EDB, wxT("ohornacute") },
  { 0x1EDC, wxT("Ohorngrave") },
  { 0x1EDD, wxT("ohorngrave") },
  { 0x1EDE, wxT("Ohornhookabove") },
  { 0x1EDF, wxT("ohornhookabove") },
  { 0x1EE0, wxT("Ohorntilde") },
  { 0x1EE1, wxT("ohorntilde") },
  { 0x1EE2, wxT("Ohorndotbelow") },
  { 0x1EE3, wxT("ohorndotbelow") },
  { 0x1EE4, wxT("Udotbelow") },
  { 0x1EE5, wxT("udotbelow") },
  { 0x1EE6, wxT("Uhookabove") },
  { 0x1EE7, wxT("uhookabove") },
  { 0x1EE8, wxT("Uhornacute") },
  { 0x1EE9, wxT("uhornacute") },
  { 0x1EEA, wxT("Uhorngrave") },
  { 0x1EEB, wxT("uhorngrave") },
  { 0x1EEC, wxT("Uhornhookabove") },
  { 0x1EED, wxT("uhornhookabove") },
  { 0x1EEE, wxT("Uhorntilde") },
  { 0x1EEF, wxT("uhorntilde") },
  { 0x1EF0, wxT("Uhorndotbelow") },
  { 0x1EF1, wxT("uhorndotbelow") },
  { 0x1EF2, wxT("Ygrave") },
  { 0x1EF3, wxT("ygrave") },
  { 0x1EF4, wxT("Ydotbelow") },
  { 0x1EF5, wxT("ydotbelow") },
  { 0x1EF6, wxT("Yhookabove") },
  { 0x1EF7, wxT("yhookabove") },
  { 0x1EF8, wxT("Ytilde") },
  { 0x1EF9, wxT("ytilde") },
  { 0x2002, wxT("enspace") },
  { 0x200B, wxT("zerowidthspace") },
  { 0x200C, wxT("afii61664") },
  { 0x200D, wxT("afii301") },
  { 0x200E, wxT("afii299") },
  { 0x200F, wxT("afii300") },
  { 0x2010, wxT("hyphentwo") },
  { 0x2012, wxT("figuredash") },
  { 0x2013, wxT("endash") },
  { 0x2014, wxT("emdash") },
  { 0x2015, wxT("afii00208") },
  { 0x2016, wxT("dblverticalbar") },
  { 0x2017, wxT("underscoredbl") },
  { 0x2018, wxT("quoteleft") },
  { 0x2019, wxT("quoteright") },
  { 0x201A, wxT("quotesinglbase") },
  { 0x201B, wxT("quotereversed") },
  { 0x201C, wxT("quotedblleft") },
  { 0x201D, wxT("quotedblright") },
  { 0x201E, wxT("quotedblbase") },
  { 0x2020, wxT("dagger") },
  { 0x2021, wxT("daggerdbl") },
  { 0x2022, wxT("bullet") },
  { 0x2024, wxT("onedotenleader") },
  { 0x2025, wxT("twodotenleader") },
  { 0x2026, wxT("ellipsis") },
  { 0x202C, wxT("afii61573") },
  { 0x202D, wxT("afii61574") },
  { 0x202E, wxT("afii61575") },
  { 0x2030, wxT("perthousand") },
  { 0x2032, wxT("minute") },
  { 0x2033, wxT("second") },
  { 0x2035, wxT("primereversed") },
  { 0x2039, wxT("guilsinglleft") },
  { 0x203A, wxT("guilsinglright") },
  { 0x203B, wxT("referencemark") },
  { 0x203C, wxT("exclamdbl") },
  { 0x203E, wxT("overline") },
  { 0x2042, wxT("asterism") },
  { 0x2044, wxT("fraction") },
  { 0x2070, wxT("zerosuperior") },
  { 0x2074, wxT("foursuperior") },
  { 0x2075, wxT("fivesuperior") },
  { 0x2076, wxT("sixsuperior") },
  { 0x2077, wxT("sevensuperior") },
  { 0x2078, wxT("eightsuperior") },
  { 0x2079, wxT("ninesuperior") },
  { 0x207A, wxT("plussuperior") },
  { 0x207C, wxT("equalsuperior") },
  { 0x207D, wxT("parenleftsuperior") },
  { 0x207E, wxT("parenrightsuperior") },
  { 0x207F, wxT("nsuperior") },
  { 0x2080, wxT("zeroinferior") },
  { 0x2081, wxT("oneinferior") },
  { 0x2082, wxT("twoinferior") },
  { 0x2083, wxT("threeinferior") },
  { 0x2084, wxT("fourinferior") },
  { 0x2085, wxT("fiveinferior") },
  { 0x2086, wxT("sixinferior") },
  { 0x2087, wxT("seveninferior") },
  { 0x2088, wxT("eightinferior") },
  { 0x2089, wxT("nineinferior") },
  { 0x208D, wxT("parenleftinferior") },
  { 0x208E, wxT("parenrightinferior") },
  { 0x20A1, wxT("colonmonetary") },
  { 0x20A2, wxT("cruzeiro") },
  { 0x20A3, wxT("franc") },
  { 0x20A4, wxT("lira") },
  { 0x20A7, wxT("peseta") },
  { 0x20A9, wxT("won") },
  { 0x20AA, wxT("afii57636") },
  { 0x20AB, wxT("dong") },
  { 0x20AC, wxT("Euro") },
  { 0x2103, wxT("centigrade") },
  { 0x2105, wxT("afii61248") },
  { 0x2109, wxT("fahrenheit") },
  { 0x2111, wxT("Ifraktur") },
  { 0x2113, wxT("afii61289") },
  { 0x2116, wxT("afii61352") },
  { 0x2118, wxT("weierstrass") },
  { 0x211C, wxT("Rfraktur") },
  { 0x211E, wxT("prescription") },
  { 0x2121, wxT("telephone") },
  { 0x2122, wxT("trademark") },
  { 0x2126, wxT("Omega") },
  { 0x212B, wxT("angstrom") },
  { 0x212E, wxT("estimated") },
  { 0x2135, wxT("aleph") },
  { 0x2153, wxT("onethird") },
  { 0x2154, wxT("twothirds") },
  { 0x215B, wxT("oneeighth") },
  { 0x215C, wxT("threeeighths") },
  { 0x215D, wxT("fiveeighths") },
  { 0x215E, wxT("seveneighths") },
  { 0x2160, wxT("Oneroman") },
  { 0x2161, wxT("Tworoman") },
  { 0x2162, wxT("Threeroman") },
  { 0x2163, wxT("Fourroman") },
  { 0x2164, wxT("Fiveroman") },
  { 0x2165, wxT("Sixroman") },
  { 0x2166, wxT("Sevenroman") },
  { 0x2167, wxT("Eightroman") },
  { 0x2168, wxT("Nineroman") },
  { 0x2169, wxT("Tenroman") },
  { 0x216A, wxT("Elevenroman") },
  { 0x216B, wxT("Twelveroman") },
  { 0x2170, wxT("oneroman") },
  { 0x2171, wxT("tworoman") },
  { 0x2172, wxT("threeroman") },
  { 0x2173, wxT("fourroman") },
  { 0x2174, wxT("fiveroman") },
  { 0x2175, wxT("sixroman") },
  { 0x2176, wxT("sevenroman") },
  { 0x2177, wxT("eightroman") },
  { 0x2178, wxT("nineroman") },
  { 0x2179, wxT("tenroman") },
  { 0x217A, wxT("elevenroman") },
  { 0x217B, wxT("twelveroman") },
  { 0x2190, wxT("arrowleft") },
  { 0x2191, wxT("arrowup") },
  { 0x2192, wxT("arrowright") },
  { 0x2193, wxT("arrowdown") },
  { 0x2194, wxT("arrowboth") },
  { 0x2195, wxT("arrowupdn") },
  { 0x2196, wxT("arrowupleft") },
  { 0x2197, wxT("arrowupright") },
  { 0x2198, wxT("arrowdownright") },
  { 0x2199, wxT("arrowdownleft") },
  { 0x21A8, wxT("arrowupdnbse") },
  { 0x21B5, wxT("carriagereturn") },
  { 0x21BC, wxT("harpoonleftbarbup") },
  { 0x21C0, wxT("harpoonrightbarbup") },
  { 0x21C4, wxT("arrowrightoverleft") },
  { 0x21C5, wxT("arrowupleftofdown") },
  { 0x21C6, wxT("arrowleftoverright") },
  { 0x21CD, wxT("arrowleftdblstroke") },
  { 0x21CF, wxT("arrowrightdblstroke") },
  { 0x21D0, wxT("arrowdblleft") },
  { 0x21D1, wxT("arrowdblup") },
  { 0x21D2, wxT("arrowdblright") },
  { 0x21D3, wxT("arrowdbldown") },
  { 0x21D4, wxT("arrowdblboth") },
  { 0x21DE, wxT("pageup") },
  { 0x21DF, wxT("pagedown") },
  { 0x21E0, wxT("arrowdashleft") },
  { 0x21E1, wxT("arrowdashup") },
  { 0x21E2, wxT("arrowdashright") },
  { 0x21E3, wxT("arrowdashdown") },
  { 0x21E4, wxT("arrowtableft") },
  { 0x21E5, wxT("arrowtabright") },
  { 0x21E6, wxT("arrowleftwhite") },
  { 0x21E7, wxT("arrowupwhite") },
  { 0x21E8, wxT("arrowrightwhite") },
  { 0x21E9, wxT("arrowdownwhite") },
  { 0x21EA, wxT("capslock") },
  { 0x2200, wxT("universal") },
  { 0x2202, wxT("partialdiff") },
  { 0x2203, wxT("existential") },
  { 0x2205, wxT("emptyset") },
  { 0x2206, wxT("Delta") },
  { 0x2207, wxT("gradient") },
  { 0x2208, wxT("element") },
  { 0x2209, wxT("notelement") },
  { 0x220B, wxT("suchthat") },
  { 0x220C, wxT("notcontains") },
  { 0x220F, wxT("product") },
  { 0x2211, wxT("summation") },
  { 0x2212, wxT("minus") },
  { 0x2213, wxT("minusplus") },
  { 0x2215, wxT("divisionslash") },
  { 0x2217, wxT("asteriskmath") },
  { 0x2219, wxT("bulletoperator") },
  { 0x221A, wxT("radical") },
  { 0x221D, wxT("proportional") },
  { 0x221E, wxT("infinity") },
  { 0x221F, wxT("orthogonal") },
  { 0x2220, wxT("angle") },
  { 0x2223, wxT("divides") },
  { 0x2225, wxT("parallel") },
  { 0x2226, wxT("notparallel") },
  { 0x2227, wxT("logicaland") },
  { 0x2228, wxT("logicalor") },
  { 0x2229, wxT("intersection") },
  { 0x222A, wxT("union") },
  { 0x222B, wxT("integral") },
  { 0x222C, wxT("dblintegral") },
  { 0x222E, wxT("contourintegral") },
  { 0x2234, wxT("therefore") },
  { 0x2235, wxT("because") },
  { 0x2236, wxT("ratio") },
  { 0x2237, wxT("proportion") },
  { 0x223C, wxT("similar") },
  { 0x223D, wxT("reversedtilde") },
  { 0x2243, wxT("asymptoticallyequal") },
  { 0x2245, wxT("congruent") },
  { 0x2248, wxT("approxequal") },
  { 0x224C, wxT("allequal") },
  { 0x2250, wxT("approaches") },
  { 0x2251, wxT("geometricallyequal") },
  { 0x2252, wxT("approxequalorimage") },
  { 0x2253, wxT("imageorapproximatelyequal") },
  { 0x2260, wxT("notequal") },
  { 0x2261, wxT("equivalence") },
  { 0x2262, wxT("notidentical") },
  { 0x2264, wxT("lessequal") },
  { 0x2265, wxT("greaterequal") },
  { 0x2266, wxT("lessoverequal") },
  { 0x2267, wxT("greateroverequal") },
  { 0x226A, wxT("muchless") },
  { 0x226B, wxT("muchgreater") },
  { 0x226E, wxT("notless") },
  { 0x226F, wxT("notgreater") },
  { 0x2270, wxT("notlessnorequal") },
  { 0x2271, wxT("notgreaternorequal") },
  { 0x2272, wxT("lessorequivalent") },
  { 0x2273, wxT("greaterorequivalent") },
  { 0x2276, wxT("lessorgreater") },
  { 0x2277, wxT("greaterorless") },
  { 0x2279, wxT("notgreaternorless") },
  { 0x227A, wxT("precedes") },
  { 0x227B, wxT("succeeds") },
  { 0x2280, wxT("notprecedes") },
  { 0x2281, wxT("notsucceeds") },
  { 0x2282, wxT("propersubset") },
  { 0x2283, wxT("propersuperset") },
  { 0x2284, wxT("notsubset") },
  { 0x2285, wxT("notsuperset") },
  { 0x2286, wxT("reflexsubset") },
  { 0x2287, wxT("reflexsuperset") },
  { 0x228A, wxT("subsetnotequal") },
  { 0x228B, wxT("supersetnotequal") },
  { 0x2295, wxT("circleplus") },
  { 0x2296, wxT("minuscircle") },
  { 0x2297, wxT("circlemultiply") },
  { 0x2299, wxT("circleot") },
  { 0x22A3, wxT("tackleft") },
  { 0x22A4, wxT("tackdown") },
  { 0x22A5, wxT("perpendicular") },
  { 0x22BF, wxT("righttriangle") },
  { 0x22C5, wxT("dotmath") },
  { 0x22CE, wxT("curlyor") },
  { 0x22CF, wxT("curlyand") },
  { 0x22DA, wxT("lessequalorgreater") },
  { 0x22DB, wxT("greaterequalorless") },
  { 0x22EE, wxT("ellipsisvertical") },
  { 0x2302, wxT("house") },
  { 0x2303, wxT("control") },
  { 0x2305, wxT("projective") },
  { 0x2310, wxT("revlogicalnot") },
  { 0x2312, wxT("arc") },
  { 0x2318, wxT("propellor") },
  { 0x2320, wxT("integraltp") },
  { 0x2321, wxT("integralbt") },
  { 0x2325, wxT("option") },
  { 0x2326, wxT("deleteright") },
  { 0x2327, wxT("clear") },
  { 0x2329, wxT("angleleft") },
  { 0x232A, wxT("angleright") },
  { 0x232B, wxT("deleteleft") },
  { 0x2423, wxT("blank") },
  { 0x2460, wxT("onecircle") },
  { 0x2461, wxT("twocircle") },
  { 0x2462, wxT("threecircle") },
  { 0x2463, wxT("fourcircle") },
  { 0x2464, wxT("fivecircle") },
  { 0x2465, wxT("sixcircle") },
  { 0x2466, wxT("sevencircle") },
  { 0x2467, wxT("eightcircle") },
  { 0x2468, wxT("ninecircle") },
  { 0x2469, wxT("tencircle") },
  { 0x246A, wxT("elevencircle") },
  { 0x246B, wxT("twelvecircle") },
  { 0x246C, wxT("thirteencircle") },
  { 0x246D, wxT("fourteencircle") },
  { 0x246E, wxT("fifteencircle") },
  { 0x246F, wxT("sixteencircle") },
  { 0x2470, wxT("seventeencircle") },
  { 0x2471, wxT("eighteencircle") },
  { 0x2472, wxT("nineteencircle") },
  { 0x2473, wxT("twentycircle") },
  { 0x2474, wxT("oneparen") },
  { 0x2475, wxT("twoparen") },
  { 0x2476, wxT("threeparen") },
  { 0x2477, wxT("fourparen") },
  { 0x2478, wxT("fiveparen") },
  { 0x2479, wxT("sixparen") },
  { 0x247A, wxT("sevenparen") },
  { 0x247B, wxT("eightparen") },
  { 0x247C, wxT("nineparen") },
  { 0x247D, wxT("tenparen") },
  { 0x247E, wxT("elevenparen") },
  { 0x247F, wxT("twelveparen") },
  { 0x2480, wxT("thirteenparen") },
  { 0x2481, wxT("fourteenparen") },
  { 0x2482, wxT("fifteenparen") },
  { 0x2483, wxT("sixteenparen") },
  { 0x2484, wxT("seventeenparen") },
  { 0x2485, wxT("eighteenparen") },
  { 0x2486, wxT("nineteenparen") },
  { 0x2487, wxT("twentyparen") },
  { 0x2488, wxT("oneperiod") },
  { 0x2489, wxT("twoperiod") },
  { 0x248A, wxT("threeperiod") },
  { 0x248B, wxT("fourperiod") },
  { 0x248C, wxT("fiveperiod") },
  { 0x248D, wxT("sixperiod") },
  { 0x248E, wxT("sevenperiod") },
  { 0x248F, wxT("eightperiod") },
  { 0x2490, wxT("nineperiod") },
  { 0x2491, wxT("tenperiod") },
  { 0x2492, wxT("elevenperiod") },
  { 0x2493, wxT("twelveperiod") },
  { 0x2494, wxT("thirteenperiod") },
  { 0x2495, wxT("fourteenperiod") },
  { 0x2496, wxT("fifteenperiod") },
  { 0x2497, wxT("sixteenperiod") },
  { 0x2498, wxT("seventeenperiod") },
  { 0x2499, wxT("eighteenperiod") },
  { 0x249A, wxT("nineteenperiod") },
  { 0x249B, wxT("twentyperiod") },
  { 0x249C, wxT("aparen") },
  { 0x249D, wxT("bparen") },
  { 0x249E, wxT("cparen") },
  { 0x249F, wxT("dparen") },
  { 0x24A0, wxT("eparen") },
  { 0x24A1, wxT("fparen") },
  { 0x24A2, wxT("gparen") },
  { 0x24A3, wxT("hparen") },
  { 0x24A4, wxT("iparen") },
  { 0x24A5, wxT("jparen") },
  { 0x24A6, wxT("kparen") },
  { 0x24A7, wxT("lparen") },
  { 0x24A8, wxT("mparen") },
  { 0x24A9, wxT("nparen") },
  { 0x24AA, wxT("oparen") },
  { 0x24AB, wxT("pparen") },
  { 0x24AC, wxT("qparen") },
  { 0x24AD, wxT("rparen") },
  { 0x24AE, wxT("sparen") },
  { 0x24AF, wxT("tparen") },
  { 0x24B0, wxT("uparen") },
  { 0x24B1, wxT("vparen") },
  { 0x24B2, wxT("wparen") },
  { 0x24B3, wxT("xparen") },
  { 0x24B4, wxT("yparen") },
  { 0x24B5, wxT("zparen") },
  { 0x24B6, wxT("Acircle") },
  { 0x24B7, wxT("Bcircle") },
  { 0x24B8, wxT("Ccircle") },
  { 0x24B9, wxT("Dcircle") },
  { 0x24BA, wxT("Ecircle") },
  { 0x24BB, wxT("Fcircle") },
  { 0x24BC, wxT("Gcircle") },
  { 0x24BD, wxT("Hcircle") },
  { 0x24BE, wxT("Icircle") },
  { 0x24BF, wxT("Jcircle") },
  { 0x24C0, wxT("Kcircle") },
  { 0x24C1, wxT("Lcircle") },
  { 0x24C2, wxT("Mcircle") },
  { 0x24C3, wxT("Ncircle") },
  { 0x24C4, wxT("Ocircle") },
  { 0x24C5, wxT("Pcircle") },
  { 0x24C6, wxT("Qcircle") },
  { 0x24C7, wxT("Rcircle") },
  { 0x24C8, wxT("Scircle") },
  { 0x24C9, wxT("Tcircle") },
  { 0x24CA, wxT("Ucircle") },
  { 0x24CB, wxT("Vcircle") },
  { 0x24CC, wxT("Wcircle") },
  { 0x24CD, wxT("Xcircle") },
  { 0x24CE, wxT("Ycircle") },
  { 0x24CF, wxT("Zcircle") },
  { 0x24D0, wxT("acircle") },
  { 0x24D1, wxT("bcircle") },
  { 0x24D2, wxT("ccircle") },
  { 0x24D3, wxT("dcircle") },
  { 0x24D4, wxT("ecircle") },
  { 0x24D5, wxT("fcircle") },
  { 0x24D6, wxT("gcircle") },
  { 0x24D7, wxT("hcircle") },
  { 0x24D8, wxT("icircle") },
  { 0x24D9, wxT("jcircle") },
  { 0x24DA, wxT("kcircle") },
  { 0x24DB, wxT("lcircle") },
  { 0x24DC, wxT("mcircle") },
  { 0x24DD, wxT("ncircle") },
  { 0x24DE, wxT("ocircle") },
  { 0x24DF, wxT("pcircle") },
  { 0x24E0, wxT("qcircle") },
  { 0x24E1, wxT("rcircle") },
  { 0x24E2, wxT("scircle") },
  { 0x24E3, wxT("tcircle") },
  { 0x24E4, wxT("ucircle") },
  { 0x24E5, wxT("vcircle") },
  { 0x24E6, wxT("wcircle") },
  { 0x24E7, wxT("xcircle") },
  { 0x24E8, wxT("ycircle") },
  { 0x24E9, wxT("zcircle") },
  { 0x2500, wxT("SF100000") },
  { 0x2502, wxT("SF110000") },
  { 0x250C, wxT("SF010000") },
  { 0x2510, wxT("SF030000") },
  { 0x2514, wxT("SF020000") },
  { 0x2518, wxT("SF040000") },
  { 0x251C, wxT("SF080000") },
  { 0x2524, wxT("SF090000") },
  { 0x252C, wxT("SF060000") },
  { 0x2534, wxT("SF070000") },
  { 0x253C, wxT("SF050000") },
  { 0x2550, wxT("SF430000") },
  { 0x2551, wxT("SF240000") },
  { 0x2552, wxT("SF510000") },
  { 0x2553, wxT("SF520000") },
  { 0x2554, wxT("SF390000") },
  { 0x2555, wxT("SF220000") },
  { 0x2556, wxT("SF210000") },
  { 0x2557, wxT("SF250000") },
  { 0x2558, wxT("SF500000") },
  { 0x2559, wxT("SF490000") },
  { 0x255A, wxT("SF380000") },
  { 0x255B, wxT("SF280000") },
  { 0x255C, wxT("SF270000") },
  { 0x255D, wxT("SF260000") },
  { 0x255E, wxT("SF360000") },
  { 0x255F, wxT("SF370000") },
  { 0x2560, wxT("SF420000") },
  { 0x2561, wxT("SF190000") },
  { 0x2562, wxT("SF200000") },
  { 0x2563, wxT("SF230000") },
  { 0x2564, wxT("SF470000") },
  { 0x2565, wxT("SF480000") },
  { 0x2566, wxT("SF410000") },
  { 0x2567, wxT("SF450000") },
  { 0x2568, wxT("SF460000") },
  { 0x2569, wxT("SF400000") },
  { 0x256A, wxT("SF540000") },
  { 0x256B, wxT("SF530000") },
  { 0x256C, wxT("SF440000") },
  { 0x2580, wxT("upblock") },
  { 0x2584, wxT("dnblock") },
  { 0x2588, wxT("block") },
  { 0x258C, wxT("lfblock") },
  { 0x2590, wxT("rtblock") },
  { 0x2591, wxT("ltshade") },
  { 0x2592, wxT("shade") },
  { 0x2593, wxT("dkshade") },
  { 0x25A0, wxT("filledbox") },
  { 0x25A1, wxT("H22073") },
  { 0x25A3, wxT("squarewhitewithsmallblack") },
  { 0x25A4, wxT("squarehorizontalfill") },
  { 0x25A5, wxT("squareverticalfill") },
  { 0x25A6, wxT("squareorthogonalcrosshatchfill") },
  { 0x25A7, wxT("squareupperlefttolowerrightfill") },
  { 0x25A8, wxT("squareupperrighttolowerleftfill") },
  { 0x25A9, wxT("squarediagonalcrosshatchfill") },
  { 0x25AA, wxT("H18543") },
  { 0x25AB, wxT("H18551") },
  { 0x25AC, wxT("filledrect") },
  { 0x25B2, wxT("triagup") },
  { 0x25B3, wxT("whiteuppointingtriangle") },
  { 0x25B4, wxT("blackuppointingsmalltriangle") },
  { 0x25B5, wxT("whiteuppointingsmalltriangle") },
  { 0x25B6, wxT("blackrightpointingtriangle") },
  { 0x25B7, wxT("whiterightpointingtriangle") },
  { 0x25B9, wxT("whiterightpointingsmalltriangle") },
  { 0x25BA, wxT("triagrt") },
  { 0x25BC, wxT("triagdn") },
  { 0x25BD, wxT("whitedownpointingtriangle") },
  { 0x25BF, wxT("whitedownpointingsmalltriangle") },
  { 0x25C0, wxT("blackleftpointingtriangle") },
  { 0x25C1, wxT("whiteleftpointingtriangle") },
  { 0x25C3, wxT("whiteleftpointingsmalltriangle") },
  { 0x25C4, wxT("triaglf") },
  { 0x25C6, wxT("blackdiamond") },
  { 0x25C7, wxT("whitediamond") },
  { 0x25C8, wxT("whitediamondcontainingblacksmalldiamond") },
  { 0x25C9, wxT("fisheye") },
  { 0x25CA, wxT("lozenge") },
  { 0x25CB, wxT("circle") },
  { 0x25CC, wxT("dottedcircle") },
  { 0x25CE, wxT("bullseye") },
  { 0x25CF, wxT("H18533") },
  { 0x25D0, wxT("circlewithlefthalfblack") },
  { 0x25D1, wxT("circlewithrighthalfblack") },
  { 0x25D8, wxT("invbullet") },
  { 0x25D9, wxT("invcircle") },
  { 0x25E2, wxT("blacklowerrighttriangle") },
  { 0x25E3, wxT("blacklowerlefttriangle") },
  { 0x25E4, wxT("blackupperlefttriangle") },
  { 0x25E5, wxT("blackupperrighttriangle") },
  { 0x25E6, wxT("openbullet") },
  { 0x25EF, wxT("largecircle") },
  { 0x2605, wxT("blackstar") },
  { 0x2606, wxT("whitestar") },
  { 0x260E, wxT("telephoneblack") },
  { 0x260F, wxT("whitetelephone") },
  { 0x261C, wxT("pointingindexleftwhite") },
  { 0x261D, wxT("pointingindexupwhite") },
  { 0x261E, wxT("pointingindexrightwhite") },
  { 0x261F, wxT("pointingindexdownwhite") },
  { 0x262F, wxT("yinyang") },
  { 0x263A, wxT("smileface") },
  { 0x263B, wxT("invsmileface") },
  { 0x263C, wxT("sun") },
  { 0x2640, wxT("female") },
  { 0x2641, wxT("earth") },
  { 0x2642, wxT("male") },
  { 0x2660, wxT("spade") },
  { 0x2661, wxT("heartsuitwhite") },
  { 0x2662, wxT("diamondsuitwhite") },
  { 0x2663, wxT("club") },
  { 0x2664, wxT("spadesuitwhite") },
  { 0x2665, wxT("heart") },
  { 0x2666, wxT("diamond") },
  { 0x2667, wxT("clubsuitwhite") },
  { 0x2668, wxT("hotsprings") },
  { 0x2669, wxT("quarternote") },
  { 0x266A, wxT("musicalnote") },
  { 0x266B, wxT("musicalnotedbl") },
  { 0x266C, wxT("beamedsixteenthnotes") },
  { 0x266D, wxT("musicflatsign") },
  { 0x266F, wxT("musicsharpsign") },
  { 0x2713, wxT("checkmark") },
  { 0x278A, wxT("onecircleinversesansserif") },
  { 0x278B, wxT("twocircleinversesansserif") },
  { 0x278C, wxT("threecircleinversesansserif") },
  { 0x278D, wxT("fourcircleinversesansserif") },
  { 0x278E, wxT("fivecircleinversesansserif") },
  { 0x278F, wxT("sixcircleinversesansserif") },
  { 0x2790, wxT("sevencircleinversesansserif") },
  { 0x2791, wxT("eightcircleinversesansserif") },
  { 0x2792, wxT("ninecircleinversesansserif") },
  { 0x279E, wxT("arrowrightheavy") },
  { 0x3000, wxT("ideographicspace") },
  { 0x3001, wxT("ideographiccomma") },
  { 0x3002, wxT("ideographicperiod") },
  { 0x3003, wxT("dittomark") },
  { 0x3004, wxT("jis") },
  { 0x3005, wxT("ideographiciterationmark") },
  { 0x3006, wxT("ideographicclose") },
  { 0x3007, wxT("ideographiczero") },
  { 0x3008, wxT("anglebracketleft") },
  { 0x3009, wxT("anglebracketright") },
  { 0x300A, wxT("dblanglebracketleft") },
  { 0x300B, wxT("dblanglebracketright") },
  { 0x300C, wxT("cornerbracketleft") },
  { 0x300D, wxT("cornerbracketright") },
  { 0x300E, wxT("whitecornerbracketleft") },
  { 0x300F, wxT("whitecornerbracketright") },
  { 0x3010, wxT("blacklenticularbracketleft") },
  { 0x3011, wxT("blacklenticularbracketright") },
  { 0x3012, wxT("postalmark") },
  { 0x3013, wxT("getamark") },
  { 0x3014, wxT("tortoiseshellbracketleft") },
  { 0x3015, wxT("tortoiseshellbracketright") },
  { 0x3016, wxT("whitelenticularbracketleft") },
  { 0x3017, wxT("whitelenticularbracketright") },
  { 0x3018, wxT("whitetortoiseshellbracketleft") },
  { 0x3019, wxT("whitetortoiseshellbracketright") },
  { 0x301C, wxT("wavedash") },
  { 0x301D, wxT("quotedblprimereversed") },
  { 0x301E, wxT("quotedblprime") },
  { 0x3020, wxT("postalmarkface") },
  { 0x3021, wxT("onehangzhou") },
  { 0x3022, wxT("twohangzhou") },
  { 0x3023, wxT("threehangzhou") },
  { 0x3024, wxT("fourhangzhou") },
  { 0x3025, wxT("fivehangzhou") },
  { 0x3026, wxT("sixhangzhou") },
  { 0x3027, wxT("sevenhangzhou") },
  { 0x3028, wxT("eighthangzhou") },
  { 0x3029, wxT("ninehangzhou") },
  { 0x3036, wxT("circlepostalmark") },
  { 0x3041, wxT("asmallhiragana") },
  { 0x3042, wxT("ahiragana") },
  { 0x3043, wxT("ismallhiragana") },
  { 0x3044, wxT("ihiragana") },
  { 0x3045, wxT("usmallhiragana") },
  { 0x3046, wxT("uhiragana") },
  { 0x3047, wxT("esmallhiragana") },
  { 0x3048, wxT("ehiragana") },
  { 0x3049, wxT("osmallhiragana") },
  { 0x304A, wxT("ohiragana") },
  { 0x304B, wxT("kahiragana") },
  { 0x304C, wxT("gahiragana") },
  { 0x304D, wxT("kihiragana") },
  { 0x304E, wxT("gihiragana") },
  { 0x304F, wxT("kuhiragana") },
  { 0x3050, wxT("guhiragana") },
  { 0x3051, wxT("kehiragana") },
  { 0x3052, wxT("gehiragana") },
  { 0x3053, wxT("kohiragana") },
  { 0x3054, wxT("gohiragana") },
  { 0x3055, wxT("sahiragana") },
  { 0x3056, wxT("zahiragana") },
  { 0x3057, wxT("sihiragana") },
  { 0x3058, wxT("zihiragana") },
  { 0x3059, wxT("suhiragana") },
  { 0x305A, wxT("zuhiragana") },
  { 0x305B, wxT("sehiragana") },
  { 0x305C, wxT("zehiragana") },
  { 0x305D, wxT("sohiragana") },
  { 0x305E, wxT("zohiragana") },
  { 0x305F, wxT("tahiragana") },
  { 0x3060, wxT("dahiragana") },
  { 0x3061, wxT("tihiragana") },
  { 0x3062, wxT("dihiragana") },
  { 0x3063, wxT("tusmallhiragana") },
  { 0x3064, wxT("tuhiragana") },
  { 0x3065, wxT("duhiragana") },
  { 0x3066, wxT("tehiragana") },
  { 0x3067, wxT("dehiragana") },
  { 0x3068, wxT("tohiragana") },
  { 0x3069, wxT("dohiragana") },
  { 0x306A, wxT("nahiragana") },
  { 0x306B, wxT("nihiragana") },
  { 0x306C, wxT("nuhiragana") },
  { 0x306D, wxT("nehiragana") },
  { 0x306E, wxT("nohiragana") },
  { 0x306F, wxT("hahiragana") },
  { 0x3070, wxT("bahiragana") },
  { 0x3071, wxT("pahiragana") },
  { 0x3072, wxT("hihiragana") },
  { 0x3073, wxT("bihiragana") },
  { 0x3074, wxT("pihiragana") },
  { 0x3075, wxT("huhiragana") },
  { 0x3076, wxT("buhiragana") },
  { 0x3077, wxT("puhiragana") },
  { 0x3078, wxT("hehiragana") },
  { 0x3079, wxT("behiragana") },
  { 0x307A, wxT("pehiragana") },
  { 0x307B, wxT("hohiragana") },
  { 0x307C, wxT("bohiragana") },
  { 0x307D, wxT("pohiragana") },
  { 0x307E, wxT("mahiragana") },
  { 0x307F, wxT("mihiragana") },
  { 0x3080, wxT("muhiragana") },
  { 0x3081, wxT("mehiragana") },
  { 0x3082, wxT("mohiragana") },
  { 0x3083, wxT("yasmallhiragana") },
  { 0x3084, wxT("yahiragana") },
  { 0x3085, wxT("yusmallhiragana") },
  { 0x3086, wxT("yuhiragana") },
  { 0x3087, wxT("yosmallhiragana") },
  { 0x3088, wxT("yohiragana") },
  { 0x3089, wxT("rahiragana") },
  { 0x308A, wxT("rihiragana") },
  { 0x308B, wxT("ruhiragana") },
  { 0x308C, wxT("rehiragana") },
  { 0x308D, wxT("rohiragana") },
  { 0x308E, wxT("wasmallhiragana") },
  { 0x308F, wxT("wahiragana") },
  { 0x3090, wxT("wihiragana") },
  { 0x3091, wxT("wehiragana") },
  { 0x3092, wxT("wohiragana") },
  { 0x3093, wxT("nhiragana") },
  { 0x3094, wxT("vuhiragana") },
  { 0x309B, wxT("voicedmarkkana") },
  { 0x309C, wxT("semivoicedmarkkana") },
  { 0x309D, wxT("iterationhiragana") },
  { 0x309E, wxT("voicediterationhiragana") },
  { 0x30A1, wxT("asmallkatakana") },
  { 0x30A2, wxT("akatakana") },
  { 0x30A3, wxT("ismallkatakana") },
  { 0x30A4, wxT("ikatakana") },
  { 0x30A5, wxT("usmallkatakana") },
  { 0x30A6, wxT("ukatakana") },
  { 0x30A7, wxT("esmallkatakana") },
  { 0x30A8, wxT("ekatakana") },
  { 0x30A9, wxT("osmallkatakana") },
  { 0x30AA, wxT("okatakana") },
  { 0x30AB, wxT("kakatakana") },
  { 0x30AC, wxT("gakatakana") },
  { 0x30AD, wxT("kikatakana") },
  { 0x30AE, wxT("gikatakana") },
  { 0x30AF, wxT("kukatakana") },
  { 0x30B0, wxT("gukatakana") },
  { 0x30B1, wxT("kekatakana") },
  { 0x30B2, wxT("gekatakana") },
  { 0x30B3, wxT("kokatakana") },
  { 0x30B4, wxT("gokatakana") },
  { 0x30B5, wxT("sakatakana") },
  { 0x30B6, wxT("zakatakana") },
  { 0x30B7, wxT("sikatakana") },
  { 0x30B8, wxT("zikatakana") },
  { 0x30B9, wxT("sukatakana") },
  { 0x30BA, wxT("zukatakana") },
  { 0x30BB, wxT("sekatakana") },
  { 0x30BC, wxT("zekatakana") },
  { 0x30BD, wxT("sokatakana") },
  { 0x30BE, wxT("zokatakana") },
  { 0x30BF, wxT("takatakana") },
  { 0x30C0, wxT("dakatakana") },
  { 0x30C1, wxT("tikatakana") },
  { 0x30C2, wxT("dikatakana") },
  { 0x30C3, wxT("tusmallkatakana") },
  { 0x30C4, wxT("tukatakana") },
  { 0x30C5, wxT("dukatakana") },
  { 0x30C6, wxT("tekatakana") },
  { 0x30C7, wxT("dekatakana") },
  { 0x30C8, wxT("tokatakana") },
  { 0x30C9, wxT("dokatakana") },
  { 0x30CA, wxT("nakatakana") },
  { 0x30CB, wxT("nikatakana") },
  { 0x30CC, wxT("nukatakana") },
  { 0x30CD, wxT("nekatakana") },
  { 0x30CE, wxT("nokatakana") },
  { 0x30CF, wxT("hakatakana") },
  { 0x30D0, wxT("bakatakana") },
  { 0x30D1, wxT("pakatakana") },
  { 0x30D2, wxT("hikatakana") },
  { 0x30D3, wxT("bikatakana") },
  { 0x30D4, wxT("pikatakana") },
  { 0x30D5, wxT("hukatakana") },
  { 0x30D6, wxT("bukatakana") },
  { 0x30D7, wxT("pukatakana") },
  { 0x30D8, wxT("hekatakana") },
  { 0x30D9, wxT("bekatakana") },
  { 0x30DA, wxT("pekatakana") },
  { 0x30DB, wxT("hokatakana") },
  { 0x30DC, wxT("bokatakana") },
  { 0x30DD, wxT("pokatakana") },
  { 0x30DE, wxT("makatakana") },
  { 0x30DF, wxT("mikatakana") },
  { 0x30E0, wxT("mukatakana") },
  { 0x30E1, wxT("mekatakana") },
  { 0x30E2, wxT("mokatakana") },
  { 0x30E3, wxT("yasmallkatakana") },
  { 0x30E4, wxT("yakatakana") },
  { 0x30E5, wxT("yusmallkatakana") },
  { 0x30E6, wxT("yukatakana") },
  { 0x30E7, wxT("yosmallkatakana") },
  { 0x30E8, wxT("yokatakana") },
  { 0x30E9, wxT("rakatakana") },
  { 0x30EA, wxT("rikatakana") },
  { 0x30EB, wxT("rukatakana") },
  { 0x30EC, wxT("rekatakana") },
  { 0x30ED, wxT("rokatakana") },
  { 0x30EE, wxT("wasmallkatakana") },
  { 0x30EF, wxT("wakatakana") },
  { 0x30F0, wxT("wikatakana") },
  { 0x30F1, wxT("wekatakana") },
  { 0x30F2, wxT("wokatakana") },
  { 0x30F3, wxT("nkatakana") },
  { 0x30F4, wxT("vukatakana") },
  { 0x30F5, wxT("kasmallkatakana") },
  { 0x30F6, wxT("kesmallkatakana") },
  { 0x30F7, wxT("vakatakana") },
  { 0x30F8, wxT("vikatakana") },
  { 0x30F9, wxT("vekatakana") },
  { 0x30FA, wxT("vokatakana") },
  { 0x30FB, wxT("dotkatakana") },
  { 0x30FC, wxT("prolongedkana") },
  { 0x30FD, wxT("iterationkatakana") },
  { 0x30FE, wxT("voicediterationkatakana") },
  { 0x3105, wxT("bbopomofo") },
  { 0x3106, wxT("pbopomofo") },
  { 0x3107, wxT("mbopomofo") },
  { 0x3108, wxT("fbopomofo") },
  { 0x3109, wxT("dbopomofo") },
  { 0x310A, wxT("tbopomofo") },
  { 0x310B, wxT("nbopomofo") },
  { 0x310C, wxT("lbopomofo") },
  { 0x310D, wxT("gbopomofo") },
  { 0x310E, wxT("kbopomofo") },
  { 0x310F, wxT("hbopomofo") },
  { 0x3110, wxT("jbopomofo") },
  { 0x3111, wxT("qbopomofo") },
  { 0x3112, wxT("xbopomofo") },
  { 0x3113, wxT("zhbopomofo") },
  { 0x3114, wxT("chbopomofo") },
  { 0x3115, wxT("shbopomofo") },
  { 0x3116, wxT("rbopomofo") },
  { 0x3117, wxT("zbopomofo") },
  { 0x3118, wxT("cbopomofo") },
  { 0x3119, wxT("sbopomofo") },
  { 0x311A, wxT("abopomofo") },
  { 0x311B, wxT("obopomofo") },
  { 0x311C, wxT("ebopomofo") },
  { 0x311D, wxT("ehbopomofo") },
  { 0x311E, wxT("aibopomofo") },
  { 0x311F, wxT("eibopomofo") },
  { 0x3120, wxT("aubopomofo") },
  { 0x3121, wxT("oubopomofo") },
  { 0x3122, wxT("anbopomofo") },
  { 0x3123, wxT("enbopomofo") },
  { 0x3124, wxT("angbopomofo") },
  { 0x3125, wxT("engbopomofo") },
  { 0x3126, wxT("erbopomofo") },
  { 0x3127, wxT("ibopomofo") },
  { 0x3128, wxT("ubopomofo") },
  { 0x3129, wxT("iubopomofo") },
  { 0x3131, wxT("kiyeokkorean") },
  { 0x3132, wxT("ssangkiyeokkorean") },
  { 0x3133, wxT("kiyeoksioskorean") },
  { 0x3134, wxT("nieunkorean") },
  { 0x3135, wxT("nieuncieuckorean") },
  { 0x3136, wxT("nieunhieuhkorean") },
  { 0x3137, wxT("tikeutkorean") },
  { 0x3138, wxT("ssangtikeutkorean") },
  { 0x3139, wxT("rieulkorean") },
  { 0x313A, wxT("rieulkiyeokkorean") },
  { 0x313B, wxT("rieulmieumkorean") },
  { 0x313C, wxT("rieulpieupkorean") },
  { 0x313D, wxT("rieulsioskorean") },
  { 0x313E, wxT("rieulthieuthkorean") },
  { 0x313F, wxT("rieulphieuphkorean") },
  { 0x3140, wxT("rieulhieuhkorean") },
  { 0x3141, wxT("mieumkorean") },
  { 0x3142, wxT("pieupkorean") },
  { 0x3143, wxT("ssangpieupkorean") },
  { 0x3144, wxT("pieupsioskorean") },
  { 0x3145, wxT("sioskorean") },
  { 0x3146, wxT("ssangsioskorean") },
  { 0x3147, wxT("ieungkorean") },
  { 0x3148, wxT("cieuckorean") },
  { 0x3149, wxT("ssangcieuckorean") },
  { 0x314A, wxT("chieuchkorean") },
  { 0x314B, wxT("khieukhkorean") },
  { 0x314C, wxT("thieuthkorean") },
  { 0x314D, wxT("phieuphkorean") },
  { 0x314E, wxT("hieuhkorean") },
  { 0x314F, wxT("akorean") },
  { 0x3150, wxT("aekorean") },
  { 0x3151, wxT("yakorean") },
  { 0x3152, wxT("yaekorean") },
  { 0x3153, wxT("eokorean") },
  { 0x3154, wxT("ekorean") },
  { 0x3155, wxT("yeokorean") },
  { 0x3156, wxT("yekorean") },
  { 0x3157, wxT("okorean") },
  { 0x3158, wxT("wakorean") },
  { 0x3159, wxT("waekorean") },
  { 0x315A, wxT("oekorean") },
  { 0x315B, wxT("yokorean") },
  { 0x315C, wxT("ukorean") },
  { 0x315D, wxT("weokorean") },
  { 0x315E, wxT("wekorean") },
  { 0x315F, wxT("wikorean") },
  { 0x3160, wxT("yukorean") },
  { 0x3161, wxT("eukorean") },
  { 0x3162, wxT("yikorean") },
  { 0x3163, wxT("ikorean") },
  { 0x3164, wxT("hangulfiller") },
  { 0x3165, wxT("ssangnieunkorean") },
  { 0x3166, wxT("nieuntikeutkorean") },
  { 0x3167, wxT("nieunsioskorean") },
  { 0x3168, wxT("nieunpansioskorean") },
  { 0x3169, wxT("rieulkiyeoksioskorean") },
  { 0x316A, wxT("rieultikeutkorean") },
  { 0x316B, wxT("rieulpieupsioskorean") },
  { 0x316C, wxT("rieulpansioskorean") },
  { 0x316D, wxT("rieulyeorinhieuhkorean") },
  { 0x316E, wxT("mieumpieupkorean") },
  { 0x316F, wxT("mieumsioskorean") },
  { 0x3170, wxT("mieumpansioskorean") },
  { 0x3171, wxT("kapyeounmieumkorean") },
  { 0x3172, wxT("pieupkiyeokkorean") },
  { 0x3173, wxT("pieuptikeutkorean") },
  { 0x3174, wxT("pieupsioskiyeokkorean") },
  { 0x3175, wxT("pieupsiostikeutkorean") },
  { 0x3176, wxT("pieupcieuckorean") },
  { 0x3177, wxT("pieupthieuthkorean") },
  { 0x3178, wxT("kapyeounpieupkorean") },
  { 0x3179, wxT("kapyeounssangpieupkorean") },
  { 0x317A, wxT("sioskiyeokkorean") },
  { 0x317B, wxT("siosnieunkorean") },
  { 0x317C, wxT("siostikeutkorean") },
  { 0x317D, wxT("siospieupkorean") },
  { 0x317E, wxT("sioscieuckorean") },
  { 0x317F, wxT("pansioskorean") },
  { 0x3180, wxT("ssangieungkorean") },
  { 0x3181, wxT("yesieungkorean") },
  { 0x3182, wxT("yesieungsioskorean") },
  { 0x3183, wxT("yesieungpansioskorean") },
  { 0x3184, wxT("kapyeounphieuphkorean") },
  { 0x3185, wxT("ssanghieuhkorean") },
  { 0x3186, wxT("yeorinhieuhkorean") },
  { 0x3187, wxT("yoyakorean") },
  { 0x3188, wxT("yoyaekorean") },
  { 0x3189, wxT("yoikorean") },
  { 0x318A, wxT("yuyeokorean") },
  { 0x318B, wxT("yuyekorean") },
  { 0x318C, wxT("yuikorean") },
  { 0x318D, wxT("araeakorean") },
  { 0x318E, wxT("araeaekorean") },
  { 0x3200, wxT("kiyeokparenkorean") },
  { 0x3201, wxT("nieunparenkorean") },
  { 0x3202, wxT("tikeutparenkorean") },
  { 0x3203, wxT("rieulparenkorean") },
  { 0x3204, wxT("mieumparenkorean") },
  { 0x3205, wxT("pieupparenkorean") },
  { 0x3206, wxT("siosparenkorean") },
  { 0x3207, wxT("ieungparenkorean") },
  { 0x3208, wxT("cieucparenkorean") },
  { 0x3209, wxT("chieuchparenkorean") },
  { 0x320A, wxT("khieukhparenkorean") },
  { 0x320B, wxT("thieuthparenkorean") },
  { 0x320C, wxT("phieuphparenkorean") },
  { 0x320D, wxT("hieuhparenkorean") },
  { 0x320E, wxT("kiyeokaparenkorean") },
  { 0x320F, wxT("nieunaparenkorean") },
  { 0x3210, wxT("tikeutaparenkorean") },
  { 0x3211, wxT("rieulaparenkorean") },
  { 0x3212, wxT("mieumaparenkorean") },
  { 0x3213, wxT("pieupaparenkorean") },
  { 0x3214, wxT("siosaparenkorean") },
  { 0x3215, wxT("ieungaparenkorean") },
  { 0x3216, wxT("cieucaparenkorean") },
  { 0x3217, wxT("chieuchaparenkorean") },
  { 0x3218, wxT("khieukhaparenkorean") },
  { 0x3219, wxT("thieuthaparenkorean") },
  { 0x321A, wxT("phieuphaparenkorean") },
  { 0x321B, wxT("hieuhaparenkorean") },
  { 0x321C, wxT("cieucuparenkorean") },
  { 0x3220, wxT("oneideographicparen") },
  { 0x3221, wxT("twoideographicparen") },
  { 0x3222, wxT("threeideographicparen") },
  { 0x3223, wxT("fourideographicparen") },
  { 0x3224, wxT("fiveideographicparen") },
  { 0x3225, wxT("sixideographicparen") },
  { 0x3226, wxT("sevenideographicparen") },
  { 0x3227, wxT("eightideographicparen") },
  { 0x3228, wxT("nineideographicparen") },
  { 0x3229, wxT("tenideographicparen") },
  { 0x322A, wxT("ideographicmoonparen") },
  { 0x322B, wxT("ideographicfireparen") },
  { 0x322C, wxT("ideographicwaterparen") },
  { 0x322D, wxT("ideographicwoodparen") },
  { 0x322E, wxT("ideographicmetalparen") },
  { 0x322F, wxT("ideographicearthparen") },
  { 0x3230, wxT("ideographicsunparen") },
  { 0x3231, wxT("ideographicstockparen") },
  { 0x3232, wxT("ideographichaveparen") },
  { 0x3233, wxT("ideographicsocietyparen") },
  { 0x3234, wxT("ideographicnameparen") },
  { 0x3235, wxT("ideographicspecialparen") },
  { 0x3236, wxT("ideographicfinancialparen") },
  { 0x3237, wxT("ideographiccongratulationparen") },
  { 0x3238, wxT("ideographiclaborparen") },
  { 0x3239, wxT("ideographicrepresentparen") },
  { 0x323A, wxT("ideographiccallparen") },
  { 0x323B, wxT("ideographicstudyparen") },
  { 0x323C, wxT("ideographicsuperviseparen") },
  { 0x323D, wxT("ideographicenterpriseparen") },
  { 0x323E, wxT("ideographicresourceparen") },
  { 0x323F, wxT("ideographicallianceparen") },
  { 0x3240, wxT("ideographicfestivalparen") },
  { 0x3242, wxT("ideographicselfparen") },
  { 0x3243, wxT("ideographicreachparen") },
  { 0x3260, wxT("kiyeokcirclekorean") },
  { 0x3261, wxT("nieuncirclekorean") },
  { 0x3262, wxT("tikeutcirclekorean") },
  { 0x3263, wxT("rieulcirclekorean") },
  { 0x3264, wxT("mieumcirclekorean") },
  { 0x3265, wxT("pieupcirclekorean") },
  { 0x3266, wxT("sioscirclekorean") },
  { 0x3267, wxT("ieungcirclekorean") },
  { 0x3268, wxT("cieuccirclekorean") },
  { 0x3269, wxT("chieuchcirclekorean") },
  { 0x326A, wxT("khieukhcirclekorean") },
  { 0x326B, wxT("thieuthcirclekorean") },
  { 0x326C, wxT("phieuphcirclekorean") },
  { 0x326D, wxT("hieuhcirclekorean") },
  { 0x326E, wxT("kiyeokacirclekorean") },
  { 0x326F, wxT("nieunacirclekorean") },
  { 0x3270, wxT("tikeutacirclekorean") },
  { 0x3271, wxT("rieulacirclekorean") },
  { 0x3272, wxT("mieumacirclekorean") },
  { 0x3273, wxT("pieupacirclekorean") },
  { 0x3274, wxT("siosacirclekorean") },
  { 0x3275, wxT("ieungacirclekorean") },
  { 0x3276, wxT("cieucacirclekorean") },
  { 0x3277, wxT("chieuchacirclekorean") },
  { 0x3278, wxT("khieukhacirclekorean") },
  { 0x3279, wxT("thieuthacirclekorean") },
  { 0x327A, wxT("phieuphacirclekorean") },
  { 0x327B, wxT("hieuhacirclekorean") },
  { 0x327F, wxT("koreanstandardsymbol") },
  { 0x328A, wxT("ideographmooncircle") },
  { 0x328B, wxT("ideographfirecircle") },
  { 0x328C, wxT("ideographwatercircle") },
  { 0x328D, wxT("ideographwoodcircle") },
  { 0x328E, wxT("ideographmetalcircle") },
  { 0x328F, wxT("ideographearthcircle") },
  { 0x3290, wxT("ideographsuncircle") },
  { 0x3294, wxT("ideographnamecircle") },
  { 0x3296, wxT("ideographicfinancialcircle") },
  { 0x3298, wxT("ideographiclaborcircle") },
  { 0x3299, wxT("ideographicsecretcircle") },
  { 0x329D, wxT("ideographicexcellentcircle") },
  { 0x329E, wxT("ideographicprintcircle") },
  { 0x32A3, wxT("ideographiccorrectcircle") },
  { 0x32A4, wxT("ideographichighcircle") },
  { 0x32A5, wxT("ideographiccentrecircle") },
  { 0x32A6, wxT("ideographiclowcircle") },
  { 0x32A7, wxT("ideographicleftcircle") },
  { 0x32A8, wxT("ideographicrightcircle") },
  { 0x32A9, wxT("ideographicmedicinecircle") },
  { 0x3300, wxT("apaatosquare") },
  { 0x3303, wxT("aarusquare") },
  { 0x3305, wxT("intisquare") },
  { 0x330D, wxT("karoriisquare") },
  { 0x3314, wxT("kirosquare") },
  { 0x3315, wxT("kiroguramusquare") },
  { 0x3316, wxT("kiromeetorusquare") },
  { 0x3318, wxT("guramusquare") },
  { 0x331E, wxT("kooposquare") },
  { 0x3322, wxT("sentisquare") },
  { 0x3323, wxT("sentosquare") },
  { 0x3326, wxT("dorusquare") },
  { 0x3327, wxT("tonsquare") },
  { 0x332A, wxT("haitusquare") },
  { 0x332B, wxT("paasentosquare") },
  { 0x3331, wxT("birusquare") },
  { 0x3333, wxT("huiitosquare") },
  { 0x3336, wxT("hekutaarusquare") },
  { 0x3339, wxT("herutusquare") },
  { 0x333B, wxT("peezisquare") },
  { 0x3342, wxT("hoonsquare") },
  { 0x3347, wxT("mansyonsquare") },
  { 0x3349, wxT("mirisquare") },
  { 0x334A, wxT("miribaarusquare") },
  { 0x334D, wxT("meetorusquare") },
  { 0x334E, wxT("yaadosquare") },
  { 0x3351, wxT("rittorusquare") },
  { 0x3357, wxT("wattosquare") },
  { 0x337B, wxT("heiseierasquare") },
  { 0x337C, wxT("syouwaerasquare") },
  { 0x337D, wxT("taisyouerasquare") },
  { 0x337E, wxT("meizierasquare") },
  { 0x337F, wxT("corporationsquare") },
  { 0x3380, wxT("paampssquare") },
  { 0x3381, wxT("nasquare") },
  { 0x3382, wxT("muasquare") },
  { 0x3383, wxT("masquare") },
  { 0x3384, wxT("kasquare") },
  { 0x3385, wxT("KBsquare") },
  { 0x3386, wxT("MBsquare") },
  { 0x3387, wxT("GBsquare") },
  { 0x3388, wxT("calsquare") },
  { 0x3389, wxT("kcalsquare") },
  { 0x338A, wxT("pfsquare") },
  { 0x338B, wxT("nfsquare") },
  { 0x338C, wxT("mufsquare") },
  { 0x338D, wxT("mugsquare") },
  { 0x338E, wxT("squaremg") },
  { 0x338F, wxT("squarekg") },
  { 0x3390, wxT("Hzsquare") },
  { 0x3391, wxT("khzsquare") },
  { 0x3392, wxT("mhzsquare") },
  { 0x3393, wxT("ghzsquare") },
  { 0x3394, wxT("thzsquare") },
  { 0x3395, wxT("mulsquare") },
  { 0x3396, wxT("mlsquare") },
  { 0x3397, wxT("dlsquare") },
  { 0x3398, wxT("klsquare") },
  { 0x3399, wxT("fmsquare") },
  { 0x339A, wxT("nmsquare") },
  { 0x339B, wxT("mumsquare") },
  { 0x339C, wxT("squaremm") },
  { 0x339D, wxT("squarecm") },
  { 0x339E, wxT("squarekm") },
  { 0x339F, wxT("mmsquaredsquare") },
  { 0x33A0, wxT("cmsquaredsquare") },
  { 0x33A1, wxT("squaremsquared") },
  { 0x33A2, wxT("kmsquaredsquare") },
  { 0x33A3, wxT("mmcubedsquare") },
  { 0x33A4, wxT("cmcubedsquare") },
  { 0x33A5, wxT("mcubedsquare") },
  { 0x33A6, wxT("kmcubedsquare") },
  { 0x33A7, wxT("moverssquare") },
  { 0x33A8, wxT("moverssquaredsquare") },
  { 0x33A9, wxT("pasquare") },
  { 0x33AA, wxT("kpasquare") },
  { 0x33AB, wxT("mpasquare") },
  { 0x33AC, wxT("gpasquare") },
  { 0x33AD, wxT("radsquare") },
  { 0x33AE, wxT("radoverssquare") },
  { 0x33AF, wxT("radoverssquaredsquare") },
  { 0x33B0, wxT("pssquare") },
  { 0x33B1, wxT("nssquare") },
  { 0x33B2, wxT("mussquare") },
  { 0x33B3, wxT("mssquare") },
  { 0x33B4, wxT("pvsquare") },
  { 0x33B5, wxT("nvsquare") },
  { 0x33B6, wxT("muvsquare") },
  { 0x33B7, wxT("mvsquare") },
  { 0x33B8, wxT("kvsquare") },
  { 0x33B9, wxT("mvmegasquare") },
  { 0x33BA, wxT("pwsquare") },
  { 0x33BB, wxT("nwsquare") },
  { 0x33BC, wxT("muwsquare") },
  { 0x33BD, wxT("mwsquare") },
  { 0x33BE, wxT("kwsquare") },
  { 0x33BF, wxT("mwmegasquare") },
  { 0x33C0, wxT("kohmsquare") },
  { 0x33C1, wxT("mohmsquare") },
  { 0x33C2, wxT("amsquare") },
  { 0x33C3, wxT("bqsquare") },
  { 0x33C4, wxT("squarecc") },
  { 0x33C5, wxT("cdsquare") },
  { 0x33C6, wxT("coverkgsquare") },
  { 0x33C7, wxT("cosquare") },
  { 0x33C8, wxT("dbsquare") },
  { 0x33C9, wxT("gysquare") },
  { 0x33CA, wxT("hasquare") },
  { 0x33CB, wxT("HPsquare") },
  { 0x33CD, wxT("KKsquare") },
  { 0x33CE, wxT("squarekmcapital") },
  { 0x33CF, wxT("ktsquare") },
  { 0x33D0, wxT("lmsquare") },
  { 0x33D1, wxT("squareln") },
  { 0x33D2, wxT("squarelog") },
  { 0x33D3, wxT("lxsquare") },
  { 0x33D4, wxT("mbsquare") },
  { 0x33D5, wxT("squaremil") },
  { 0x33D6, wxT("molsquare") },
  { 0x33D8, wxT("pmsquare") },
  { 0x33DB, wxT("srsquare") },
  { 0x33DC, wxT("svsquare") },
  { 0x33DD, wxT("wbsquare") },
  { 0x5344, wxT("twentyhangzhou") },
  { 0xF6BE, wxT("dotlessj") },
  { 0xF6BF, wxT("LL") },
  { 0xF6C0, wxT("ll") },
  { 0xF6C1, wxT("Scedilla") },
  { 0xF6C2, wxT("scedilla") },
  { 0xF6C3, wxT("commaaccent") },
  { 0xF6C4, wxT("afii10063") },
  { 0xF6C5, wxT("afii10064") },
  { 0xF6C6, wxT("afii10192") },
  { 0xF6C7, wxT("afii10831") },
  { 0xF6C8, wxT("afii10832") },
  { 0xF6C9, wxT("Acute") },
  { 0xF6CA, wxT("Caron") },
  { 0xF6CB, wxT("Dieresis") },
  { 0xF6CC, wxT("DieresisAcute") },
  { 0xF6CD, wxT("DieresisGrave") },
  { 0xF6CE, wxT("Grave") },
  { 0xF6CF, wxT("Hungarumlaut") },
  { 0xF6D0, wxT("Macron") },
  { 0xF6D1, wxT("cyrBreve") },
  { 0xF6D2, wxT("cyrFlex") },
  { 0xF6D3, wxT("dblGrave") },
  { 0xF6D4, wxT("cyrbreve") },
  { 0xF6D5, wxT("cyrflex") },
  { 0xF6D6, wxT("dblgrave") },
  { 0xF6D7, wxT("dieresisacute") },
  { 0xF6D8, wxT("dieresisgrave") },
  { 0xF6D9, wxT("copyrightserif") },
  { 0xF6DA, wxT("registerserif") },
  { 0xF6DB, wxT("trademarkserif") },
  { 0xF6DC, wxT("onefitted") },
  { 0xF6DD, wxT("rupiah") },
  { 0xF6DE, wxT("threequartersemdash") },
  { 0xF6DF, wxT("centinferior") },
  { 0xF6E0, wxT("centsuperior") },
  { 0xF6E1, wxT("commainferior") },
  { 0xF6E2, wxT("commasuperior") },
  { 0xF6E3, wxT("dollarinferior") },
  { 0xF6E4, wxT("dollarsuperior") },
  { 0xF6E5, wxT("hypheninferior") },
  { 0xF6E6, wxT("hyphensuperior") },
  { 0xF6E7, wxT("periodinferior") },
  { 0xF6E8, wxT("periodsuperior") },
  { 0xF6E9, wxT("asuperior") },
  { 0xF6EA, wxT("bsuperior") },
  { 0xF6EB, wxT("dsuperior") },
  { 0xF6EC, wxT("esuperior") },
  { 0xF6ED, wxT("isuperior") },
  { 0xF6EE, wxT("lsuperior") },
  { 0xF6EF, wxT("msuperior") },
  { 0xF6F0, wxT("osuperior") },
  { 0xF6F1, wxT("rsuperior") },
  { 0xF6F2, wxT("ssuperior") },
  { 0xF6F3, wxT("tsuperior") },
  { 0xF6F4, wxT("Brevesmall") },
  { 0xF6F5, wxT("Caronsmall") },
  { 0xF6F6, wxT("Circumflexsmall") },
  { 0xF6F7, wxT("Dotaccentsmall") },
  { 0xF6F8, wxT("Hungarumlautsmall") },
  { 0xF6F9, wxT("Lslashsmall") },
  { 0xF6FA, wxT("OEsmall") },
  { 0xF6FB, wxT("Ogoneksmall") },
  { 0xF6FC, wxT("Ringsmall") },
  { 0xF6FD, wxT("Scaronsmall") },
  { 0xF6FE, wxT("Tildesmall") },
  { 0xF6FF, wxT("Zcaronsmall") },
  { 0xF721, wxT("exclamsmall") },
  { 0xF724, wxT("dollaroldstyle") },
  { 0xF726, wxT("ampersandsmall") },
  { 0xF730, wxT("zerooldstyle") },
  { 0xF731, wxT("oneoldstyle") },
  { 0xF732, wxT("twooldstyle") },
  { 0xF733, wxT("threeoldstyle") },
  { 0xF734, wxT("fouroldstyle") },
  { 0xF735, wxT("fiveoldstyle") },
  { 0xF736, wxT("sixoldstyle") },
  { 0xF737, wxT("sevenoldstyle") },
  { 0xF738, wxT("eightoldstyle") },
  { 0xF739, wxT("nineoldstyle") },
  { 0xF73F, wxT("questionsmall") },
  { 0xF760, wxT("Gravesmall") },
  { 0xF761, wxT("Asmall") },
  { 0xF762, wxT("Bsmall") },
  { 0xF763, wxT("Csmall") },
  { 0xF764, wxT("Dsmall") },
  { 0xF765, wxT("Esmall") },
  { 0xF766, wxT("Fsmall") },
  { 0xF767, wxT("Gsmall") },
  { 0xF768, wxT("Hsmall") },
  { 0xF769, wxT("Ismall") },
  { 0xF76A, wxT("Jsmall") },
  { 0xF76B, wxT("Ksmall") },
  { 0xF76C, wxT("Lsmall") },
  { 0xF76D, wxT("Msmall") },
  { 0xF76E, wxT("Nsmall") },
  { 0xF76F, wxT("Osmall") },
  { 0xF770, wxT("Psmall") },
  { 0xF771, wxT("Qsmall") },
  { 0xF772, wxT("Rsmall") },
  { 0xF773, wxT("Ssmall") },
  { 0xF774, wxT("Tsmall") },
  { 0xF775, wxT("Usmall") },
  { 0xF776, wxT("Vsmall") },
  { 0xF777, wxT("Wsmall") },
  { 0xF778, wxT("Xsmall") },
  { 0xF779, wxT("Ysmall") },
  { 0xF77A, wxT("Zsmall") },
  { 0xF7A1, wxT("exclamdownsmall") },
  { 0xF7A2, wxT("centoldstyle") },
  { 0xF7A8, wxT("Dieresissmall") },
  { 0xF7AF, wxT("Macronsmall") },
  { 0xF7B4, wxT("Acutesmall") },
  { 0xF7B8, wxT("Cedillasmall") },
  { 0xF7BF, wxT("questiondownsmall") },
  { 0xF7E0, wxT("Agravesmall") },
  { 0xF7E1, wxT("Aacutesmall") },
  { 0xF7E2, wxT("Acircumflexsmall") },
  { 0xF7E3, wxT("Atildesmall") },
  { 0xF7E4, wxT("Adieresissmall") },
  { 0xF7E5, wxT("Aringsmall") },
  { 0xF7E6, wxT("AEsmall") },
  { 0xF7E7, wxT("Ccedillasmall") },
  { 0xF7E8, wxT("Egravesmall") },
  { 0xF7E9, wxT("Eacutesmall") },
  { 0xF7EA, wxT("Ecircumflexsmall") },
  { 0xF7EB, wxT("Edieresissmall") },
  { 0xF7EC, wxT("Igravesmall") },
  { 0xF7ED, wxT("Iacutesmall") },
  { 0xF7EE, wxT("Icircumflexsmall") },
  { 0xF7EF, wxT("Idieresissmall") },
  { 0xF7F0, wxT("Ethsmall") },
  { 0xF7F1, wxT("Ntildesmall") },
  { 0xF7F2, wxT("Ogravesmall") },
  { 0xF7F3, wxT("Oacutesmall") },
  { 0xF7F4, wxT("Ocircumflexsmall") },
  { 0xF7F5, wxT("Otildesmall") },
  { 0xF7F6, wxT("Odieresissmall") },
  { 0xF7F8, wxT("Oslashsmall") },
  { 0xF7F9, wxT("Ugravesmall") },
  { 0xF7FA, wxT("Uacutesmall") },
  { 0xF7FB, wxT("Ucircumflexsmall") },
  { 0xF7FC, wxT("Udieresissmall") },
  { 0xF7FD, wxT("Yacutesmall") },
  { 0xF7FE, wxT("Thornsmall") },
  { 0xF7FF, wxT("Ydieresissmall") },
  { 0xF884, wxT("maihanakatleftthai") },
  { 0xF885, wxT("saraileftthai") },
  { 0xF886, wxT("saraiileftthai") },
  { 0xF887, wxT("saraueleftthai") },
  { 0xF888, wxT("saraueeleftthai") },
  { 0xF889, wxT("maitaikhuleftthai") },
  { 0xF88A, wxT("maiekupperleftthai") },
  { 0xF88B, wxT("maieklowrightthai") },
  { 0xF88C, wxT("maieklowleftthai") },
  { 0xF88D, wxT("maithoupperleftthai") },
  { 0xF88E, wxT("maitholowrightthai") },
  { 0xF88F, wxT("maitholowleftthai") },
  { 0xF890, wxT("maitriupperleftthai") },
  { 0xF891, wxT("maitrilowrightthai") },
  { 0xF892, wxT("maitrilowleftthai") },
  { 0xF893, wxT("maichattawaupperleftthai") },
  { 0xF894, wxT("maichattawalowrightthai") },
  { 0xF895, wxT("maichattawalowleftthai") },
  { 0xF896, wxT("thanthakhatupperleftthai") },
  { 0xF897, wxT("thanthakhatlowrightthai") },
  { 0xF898, wxT("thanthakhatlowleftthai") },
  { 0xF899, wxT("nikhahitleftthai") },
  { 0xF8E5, wxT("radicalex") },
  { 0xF8E6, wxT("arrowvertex") },
  { 0xF8E7, wxT("arrowhorizex") },
  { 0xF8E8, wxT("registersans") },
  { 0xF8E9, wxT("copyrightsans") },
  { 0xF8EA, wxT("trademarksans") },
  { 0xF8EB, wxT("parenlefttp") },
  { 0xF8EC, wxT("parenleftex") },
  { 0xF8ED, wxT("parenleftbt") },
  { 0xF8EE, wxT("bracketlefttp") },
  { 0xF8EF, wxT("bracketleftex") },
  { 0xF8F0, wxT("bracketleftbt") },
  { 0xF8F1, wxT("bracelefttp") },
  { 0xF8F2, wxT("braceleftmid") },
  { 0xF8F3, wxT("braceleftbt") },
  { 0xF8F4, wxT("braceex") },
  { 0xF8F5, wxT("integralex") },
  { 0xF8F6, wxT("parenrighttp") },
  { 0xF8F7, wxT("parenrightex") },
  { 0xF8F8, wxT("parenrightbt") },
  { 0xF8F9, wxT("bracketrighttp") },
  { 0xF8FA, wxT("bracketrightex") },
  { 0xF8FB, wxT("bracketrightbt") },
  { 0xF8FC, wxT("bracerighttp") },
  { 0xF8FD, wxT("bracerightmid") },
  { 0xF8FE, wxT("bracerightbt") },
  { 0xF8FF, wxT("apple") },
  { 0xFB00, wxT("ff") },
  { 0xFB01, wxT("fi") },
  { 0xFB02, wxT("fl") },
  { 0xFB03, wxT("ffi") },
  { 0xFB04, wxT("ffl") },
  { 0xFB1F, wxT("yodyodpatahhebrew") },
  { 0xFB20, wxT("ayinaltonehebrew") },
  { 0xFB2A, wxT("shinshindothebrew") },
  { 0xFB2B, wxT("shinsindothebrew") },
  { 0xFB2C, wxT("shindageshshindothebrew") },
  { 0xFB2D, wxT("shindageshsindothebrew") },
  { 0xFB2E, wxT("alefpatahhebrew") },
  { 0xFB2F, wxT("alefqamatshebrew") },
  { 0xFB30, wxT("alefdageshhebrew") },
  { 0xFB31, wxT("betdageshhebrew") },
  { 0xFB32, wxT("gimeldageshhebrew") },
  { 0xFB33, wxT("daletdageshhebrew") },
  { 0xFB34, wxT("hedageshhebrew") },
  { 0xFB35, wxT("vavdageshhebrew") },
  { 0xFB36, wxT("zayindageshhebrew") },
  { 0xFB38, wxT("tetdageshhebrew") },
  { 0xFB39, wxT("yoddageshhebrew") },
  { 0xFB3A, wxT("finalkafdageshhebrew") },
  { 0xFB3B, wxT("kafdageshhebrew") },
  { 0xFB3C, wxT("lameddageshhebrew") },
  { 0xFB3E, wxT("memdageshhebrew") },
  { 0xFB40, wxT("nundageshhebrew") },
  { 0xFB41, wxT("samekhdageshhebrew") },
  { 0xFB43, wxT("pefinaldageshhebrew") },
  { 0xFB44, wxT("pedageshhebrew") },
  { 0xFB46, wxT("tsadidageshhebrew") },
  { 0xFB47, wxT("qofdageshhebrew") },
  { 0xFB48, wxT("reshdageshhebrew") },
  { 0xFB49, wxT("shindageshhebrew") },
  { 0xFB4A, wxT("tavdageshhebrew") },
  { 0xFB4B, wxT("vavholamhebrew") },
  { 0xFB4C, wxT("betrafehebrew") },
  { 0xFB4D, wxT("kafrafehebrew") },
  { 0xFB4E, wxT("perafehebrew") },
  { 0xFB4F, wxT("aleflamedhebrew") },
  { 0xFB57, wxT("pehfinalarabic") },
  { 0xFB58, wxT("pehinitialarabic") },
  { 0xFB59, wxT("pehmedialarabic") },
  { 0xFB67, wxT("ttehfinalarabic") },
  { 0xFB68, wxT("ttehinitialarabic") },
  { 0xFB69, wxT("ttehmedialarabic") },
  { 0xFB6B, wxT("vehfinalarabic") },
  { 0xFB6C, wxT("vehinitialarabic") },
  { 0xFB6D, wxT("vehmedialarabic") },
  { 0xFB7B, wxT("tchehfinalarabic") },
  { 0xFB7C, wxT("tchehinitialarabic") },
  { 0xFB7D, wxT("tchehmedialarabic") },
  { 0xFB89, wxT("ddalfinalarabic") },
  { 0xFB8B, wxT("jehfinalarabic") },
  { 0xFB8D, wxT("rrehfinalarabic") },
  { 0xFB93, wxT("gaffinalarabic") },
  { 0xFB94, wxT("gafinitialarabic") },
  { 0xFB95, wxT("gafmedialarabic") },
  { 0xFB9F, wxT("noonghunnafinalarabic") },
  { 0xFBA4, wxT("hehhamzaaboveisolatedarabic") },
  { 0xFBA5, wxT("hehhamzaabovefinalarabic") },
  { 0xFBA7, wxT("hehfinalaltonearabic") },
  { 0xFBA8, wxT("hehinitialaltonearabic") },
  { 0xFBA9, wxT("hehmedialaltonearabic") },
  { 0xFBAF, wxT("yehbarreefinalarabic") },
  { 0xFC08, wxT("behmeemisolatedarabic") },
  { 0xFC0B, wxT("tehjeemisolatedarabic") },
  { 0xFC0C, wxT("tehhahisolatedarabic") },
  { 0xFC0E, wxT("tehmeemisolatedarabic") },
  { 0xFC48, wxT("meemmeemisolatedarabic") },
  { 0xFC4B, wxT("noonjeemisolatedarabic") },
  { 0xFC4E, wxT("noonmeemisolatedarabic") },
  { 0xFC58, wxT("yehmeemisolatedarabic") },
  { 0xFC5E, wxT("shaddadammatanarabic") },
  { 0xFC5F, wxT("shaddakasratanarabic") },
  { 0xFC60, wxT("shaddafathaarabic") },
  { 0xFC61, wxT("shaddadammaarabic") },
  { 0xFC62, wxT("shaddakasraarabic") },
  { 0xFC6D, wxT("behnoonfinalarabic") },
  { 0xFC73, wxT("tehnoonfinalarabic") },
  { 0xFC8D, wxT("noonnoonfinalarabic") },
  { 0xFC94, wxT("yehnoonfinalarabic") },
  { 0xFC9F, wxT("behmeeminitialarabic") },
  { 0xFCA1, wxT("tehjeeminitialarabic") },
  { 0xFCA2, wxT("tehhahinitialarabic") },
  { 0xFCA4, wxT("tehmeeminitialarabic") },
  { 0xFCC9, wxT("lamjeeminitialarabic") },
  { 0xFCCA, wxT("lamhahinitialarabic") },
  { 0xFCCB, wxT("lamkhahinitialarabic") },
  { 0xFCCC, wxT("lammeeminitialarabic") },
  { 0xFCD1, wxT("meemmeeminitialarabic") },
  { 0xFCD2, wxT("noonjeeminitialarabic") },
  { 0xFCD5, wxT("noonmeeminitialarabic") },
  { 0xFCDD, wxT("yehmeeminitialarabic") },
  { 0xFD3E, wxT("parenleftaltonearabic") },
  { 0xFD3F, wxT("parenrightaltonearabic") },
  { 0xFD88, wxT("lammeemhahinitialarabic") },
  { 0xFDF2, wxT("lamlamhehisolatedarabic") },
  { 0xFDFA, wxT("sallallahoualayhewasallamarabic") },
  { 0xFE30, wxT("twodotleadervertical") },
  { 0xFE31, wxT("emdashvertical") },
  { 0xFE32, wxT("endashvertical") },
  { 0xFE33, wxT("underscorevertical") },
  { 0xFE34, wxT("wavyunderscorevertical") },
  { 0xFE35, wxT("parenleftvertical") },
  { 0xFE36, wxT("parenrightvertical") },
  { 0xFE37, wxT("braceleftvertical") },
  { 0xFE38, wxT("bracerightvertical") },
  { 0xFE39, wxT("tortoiseshellbracketleftvertical") },
  { 0xFE3A, wxT("tortoiseshellbracketrightvertical") },
  { 0xFE3B, wxT("blacklenticularbracketleftvertical") },
  { 0xFE3C, wxT("blacklenticularbracketrightvertical") },
  { 0xFE3D, wxT("dblanglebracketleftvertical") },
  { 0xFE3E, wxT("dblanglebracketrightvertical") },
  { 0xFE3F, wxT("anglebracketleftvertical") },
  { 0xFE40, wxT("anglebracketrightvertical") },
  { 0xFE41, wxT("cornerbracketleftvertical") },
  { 0xFE42, wxT("cornerbracketrightvertical") },
  { 0xFE43, wxT("whitecornerbracketleftvertical") },
  { 0xFE44, wxT("whitecornerbracketrightvertical") },
  { 0xFE49, wxT("overlinedashed") },
  { 0xFE4A, wxT("overlinecenterline") },
  { 0xFE4B, wxT("overlinewavy") },
  { 0xFE4C, wxT("overlinedblwavy") },
  { 0xFE4D, wxT("lowlinedashed") },
  { 0xFE4E, wxT("lowlinecenterline") },
  { 0xFE4F, wxT("underscorewavy") },
  { 0xFE50, wxT("commasmall") },
  { 0xFE52, wxT("periodsmall") },
  { 0xFE54, wxT("semicolonsmall") },
  { 0xFE55, wxT("colonsmall") },
  { 0xFE59, wxT("parenleftsmall") },
  { 0xFE5A, wxT("parenrightsmall") },
  { 0xFE5B, wxT("braceleftsmall") },
  { 0xFE5C, wxT("bracerightsmall") },
  { 0xFE5D, wxT("tortoiseshellbracketleftsmall") },
  { 0xFE5E, wxT("tortoiseshellbracketrightsmall") },
  { 0xFE5F, wxT("numbersignsmall") },
  { 0xFE61, wxT("asterisksmall") },
  { 0xFE62, wxT("plussmall") },
  { 0xFE63, wxT("hyphensmall") },
  { 0xFE64, wxT("lesssmall") },
  { 0xFE65, wxT("greatersmall") },
  { 0xFE66, wxT("equalsmall") },
  { 0xFE69, wxT("dollarsmall") },
  { 0xFE6A, wxT("percentsmall") },
  { 0xFE6B, wxT("atsmall") },
  { 0xFE82, wxT("alefmaddaabovefinalarabic") },
  { 0xFE84, wxT("alefhamzaabovefinalarabic") },
  { 0xFE86, wxT("wawhamzaabovefinalarabic") },
  { 0xFE88, wxT("alefhamzabelowfinalarabic") },
  { 0xFE8A, wxT("yehhamzaabovefinalarabic") },
  { 0xFE8B, wxT("yehhamzaaboveinitialarabic") },
  { 0xFE8C, wxT("yehhamzaabovemedialarabic") },
  { 0xFE8E, wxT("aleffinalarabic") },
  { 0xFE90, wxT("behfinalarabic") },
  { 0xFE91, wxT("behinitialarabic") },
  { 0xFE92, wxT("behmedialarabic") },
  { 0xFE94, wxT("tehmarbutafinalarabic") },
  { 0xFE96, wxT("tehfinalarabic") },
  { 0xFE97, wxT("tehinitialarabic") },
  { 0xFE98, wxT("tehmedialarabic") },
  { 0xFE9A, wxT("thehfinalarabic") },
  { 0xFE9B, wxT("thehinitialarabic") },
  { 0xFE9C, wxT("thehmedialarabic") },
  { 0xFE9E, wxT("jeemfinalarabic") },
  { 0xFE9F, wxT("jeeminitialarabic") },
  { 0xFEA0, wxT("jeemmedialarabic") },
  { 0xFEA2, wxT("hahfinalarabic") },
  { 0xFEA3, wxT("hahinitialarabic") },
  { 0xFEA4, wxT("hahmedialarabic") },
  { 0xFEA6, wxT("khahfinalarabic") },
  { 0xFEA7, wxT("khahinitialarabic") },
  { 0xFEA8, wxT("khahmedialarabic") },
  { 0xFEAA, wxT("dalfinalarabic") },
  { 0xFEAC, wxT("thalfinalarabic") },
  { 0xFEAE, wxT("rehfinalarabic") },
  { 0xFEB0, wxT("zainfinalarabic") },
  { 0xFEB2, wxT("seenfinalarabic") },
  { 0xFEB3, wxT("seeninitialarabic") },
  { 0xFEB4, wxT("seenmedialarabic") },
  { 0xFEB6, wxT("sheenfinalarabic") },
  { 0xFEB7, wxT("sheeninitialarabic") },
  { 0xFEB8, wxT("sheenmedialarabic") },
  { 0xFEBA, wxT("sadfinalarabic") },
  { 0xFEBB, wxT("sadinitialarabic") },
  { 0xFEBC, wxT("sadmedialarabic") },
  { 0xFEBE, wxT("dadfinalarabic") },
  { 0xFEBF, wxT("dadinitialarabic") },
  { 0xFEC0, wxT("dadmedialarabic") },
  { 0xFEC2, wxT("tahfinalarabic") },
  { 0xFEC3, wxT("tahinitialarabic") },
  { 0xFEC4, wxT("tahmedialarabic") },
  { 0xFEC6, wxT("zahfinalarabic") },
  { 0xFEC7, wxT("zahinitialarabic") },
  { 0xFEC8, wxT("zahmedialarabic") },
  { 0xFECA, wxT("ainfinalarabic") },
  { 0xFECB, wxT("aininitialarabic") },
  { 0xFECC, wxT("ainmedialarabic") },
  { 0xFECE, wxT("ghainfinalarabic") },
  { 0xFECF, wxT("ghaininitialarabic") },
  { 0xFED0, wxT("ghainmedialarabic") },
  { 0xFED2, wxT("fehfinalarabic") },
  { 0xFED3, wxT("fehinitialarabic") },
  { 0xFED4, wxT("fehmedialarabic") },
  { 0xFED6, wxT("qaffinalarabic") },
  { 0xFED7, wxT("qafinitialarabic") },
  { 0xFED8, wxT("qafmedialarabic") },
  { 0xFEDA, wxT("kaffinalarabic") },
  { 0xFEDB, wxT("kafinitialarabic") },
  { 0xFEDC, wxT("kafmedialarabic") },
  { 0xFEDE, wxT("lamfinalarabic") },
  { 0xFEDF, wxT("laminitialarabic") },
  { 0xFEE0, wxT("lammedialarabic") },
  { 0xFEE2, wxT("meemfinalarabic") },
  { 0xFEE3, wxT("meeminitialarabic") },
  { 0xFEE4, wxT("meemmedialarabic") },
  { 0xFEE6, wxT("noonfinalarabic") },
  { 0xFEE7, wxT("nooninitialarabic") },
  { 0xFEE8, wxT("noonmedialarabic") },
  { 0xFEEA, wxT("hehfinalarabic") },
  { 0xFEEB, wxT("hehinitialarabic") },
  { 0xFEEC, wxT("hehmedialarabic") },
  { 0xFEEE, wxT("wawfinalarabic") },
  { 0xFEF0, wxT("alefmaksurafinalarabic") },
  { 0xFEF2, wxT("yehfinalarabic") },
  { 0xFEF3, wxT("yehinitialarabic") },
  { 0xFEF4, wxT("yehmedialarabic") },
  { 0xFEF5, wxT("lamalefmaddaaboveisolatedarabic") },
  { 0xFEF6, wxT("lamalefmaddaabovefinalarabic") },
  { 0xFEF7, wxT("lamalefhamzaaboveisolatedarabic") },
  { 0xFEF8, wxT("lamalefhamzaabovefinalarabic") },
  { 0xFEF9, wxT("lamalefhamzabelowisolatedarabic") },
  { 0xFEFA, wxT("lamalefhamzabelowfinalarabic") },
  { 0xFEFB, wxT("lamalefisolatedarabic") },
  { 0xFEFC, wxT("lamaleffinalarabic") },
  { 0xFEFF, wxT("zerowidthjoiner") },
  { 0xFF01, wxT("exclammonospace") },
  { 0xFF02, wxT("quotedblmonospace") },
  { 0xFF03, wxT("numbersignmonospace") },
  { 0xFF04, wxT("dollarmonospace") },
  { 0xFF05, wxT("percentmonospace") },
  { 0xFF06, wxT("ampersandmonospace") },
  { 0xFF07, wxT("quotesinglemonospace") },
  { 0xFF08, wxT("parenleftmonospace") },
  { 0xFF09, wxT("parenrightmonospace") },
  { 0xFF0A, wxT("asteriskmonospace") },
  { 0xFF0B, wxT("plusmonospace") },
  { 0xFF0C, wxT("commamonospace") },
  { 0xFF0D, wxT("hyphenmonospace") },
  { 0xFF0E, wxT("periodmonospace") },
  { 0xFF0F, wxT("slashmonospace") },
  { 0xFF10, wxT("zeromonospace") },
  { 0xFF11, wxT("onemonospace") },
  { 0xFF12, wxT("twomonospace") },
  { 0xFF13, wxT("threemonospace") },
  { 0xFF14, wxT("fourmonospace") },
  { 0xFF15, wxT("fivemonospace") },
  { 0xFF16, wxT("sixmonospace") },
  { 0xFF17, wxT("sevenmonospace") },
  { 0xFF18, wxT("eightmonospace") },
  { 0xFF19, wxT("ninemonospace") },
  { 0xFF1A, wxT("colonmonospace") },
  { 0xFF1B, wxT("semicolonmonospace") },
  { 0xFF1C, wxT("lessmonospace") },
  { 0xFF1D, wxT("equalmonospace") },
  { 0xFF1E, wxT("greatermonospace") },
  { 0xFF1F, wxT("questionmonospace") },
  { 0xFF20, wxT("atmonospace") },
  { 0xFF21, wxT("Amonospace") },
  { 0xFF22, wxT("Bmonospace") },
  { 0xFF23, wxT("Cmonospace") },
  { 0xFF24, wxT("Dmonospace") },
  { 0xFF25, wxT("Emonospace") },
  { 0xFF26, wxT("Fmonospace") },
  { 0xFF27, wxT("Gmonospace") },
  { 0xFF28, wxT("Hmonospace") },
  { 0xFF29, wxT("Imonospace") },
  { 0xFF2A, wxT("Jmonospace") },
  { 0xFF2B, wxT("Kmonospace") },
  { 0xFF2C, wxT("Lmonospace") },
  { 0xFF2D, wxT("Mmonospace") },
  { 0xFF2E, wxT("Nmonospace") },
  { 0xFF2F, wxT("Omonospace") },
  { 0xFF30, wxT("Pmonospace") },
  { 0xFF31, wxT("Qmonospace") },
  { 0xFF32, wxT("Rmonospace") },
  { 0xFF33, wxT("Smonospace") },
  { 0xFF34, wxT("Tmonospace") },
  { 0xFF35, wxT("Umonospace") },
  { 0xFF36, wxT("Vmonospace") },
  { 0xFF37, wxT("Wmonospace") },
  { 0xFF38, wxT("Xmonospace") },
  { 0xFF39, wxT("Ymonospace") },
  { 0xFF3A, wxT("Zmonospace") },
  { 0xFF3B, wxT("bracketleftmonospace") },
  { 0xFF3C, wxT("backslashmonospace") },
  { 0xFF3D, wxT("bracketrightmonospace") },
  { 0xFF3E, wxT("asciicircummonospace") },
  { 0xFF3F, wxT("underscoremonospace") },
  { 0xFF40, wxT("gravemonospace") },
  { 0xFF41, wxT("amonospace") },
  { 0xFF42, wxT("bmonospace") },
  { 0xFF43, wxT("cmonospace") },
  { 0xFF44, wxT("dmonospace") },
  { 0xFF45, wxT("emonospace") },
  { 0xFF46, wxT("fmonospace") },
  { 0xFF47, wxT("gmonospace") },
  { 0xFF48, wxT("hmonospace") },
  { 0xFF49, wxT("imonospace") },
  { 0xFF4A, wxT("jmonospace") },
  { 0xFF4B, wxT("kmonospace") },
  { 0xFF4C, wxT("lmonospace") },
  { 0xFF4D, wxT("mmonospace") },
  { 0xFF4E, wxT("nmonospace") },
  { 0xFF4F, wxT("omonospace") },
  { 0xFF50, wxT("pmonospace") },
  { 0xFF51, wxT("qmonospace") },
  { 0xFF52, wxT("rmonospace") },
  { 0xFF53, wxT("smonospace") },
  { 0xFF54, wxT("tmonospace") },
  { 0xFF55, wxT("umonospace") },
  { 0xFF56, wxT("vmonospace") },
  { 0xFF57, wxT("wmonospace") },
  { 0xFF58, wxT("xmonospace") },
  { 0xFF59, wxT("ymonospace") },
  { 0xFF5A, wxT("zmonospace") },
  { 0xFF5B, wxT("braceleftmonospace") },
  { 0xFF5C, wxT("barmonospace") },
  { 0xFF5D, wxT("bracerightmonospace") },
  { 0xFF5E, wxT("asciitildemonospace") },
  { 0xFF61, wxT("periodhalfwidth") },
  { 0xFF62, wxT("cornerbracketlefthalfwidth") },
  { 0xFF63, wxT("cornerbracketrighthalfwidth") },
  { 0xFF64, wxT("ideographiccommaleft") },
  { 0xFF65, wxT("middledotkatakanahalfwidth") },
  { 0xFF66, wxT("wokatakanahalfwidth") },
  { 0xFF67, wxT("asmallkatakanahalfwidth") },
  { 0xFF68, wxT("ismallkatakanahalfwidth") },
  { 0xFF69, wxT("usmallkatakanahalfwidth") },
  { 0xFF6A, wxT("esmallkatakanahalfwidth") },
  { 0xFF6B, wxT("osmallkatakanahalfwidth") },
  { 0xFF6C, wxT("yasmallkatakanahalfwidth") },
  { 0xFF6D, wxT("yusmallkatakanahalfwidth") },
  { 0xFF6E, wxT("yosmallkatakanahalfwidth") },
  { 0xFF6F, wxT("tusmallkatakanahalfwidth") },
  { 0xFF70, wxT("katahiraprolongmarkhalfwidth") },
  { 0xFF71, wxT("akatakanahalfwidth") },
  { 0xFF72, wxT("ikatakanahalfwidth") },
  { 0xFF73, wxT("ukatakanahalfwidth") },
  { 0xFF74, wxT("ekatakanahalfwidth") },
  { 0xFF75, wxT("okatakanahalfwidth") },
  { 0xFF76, wxT("kakatakanahalfwidth") },
  { 0xFF77, wxT("kikatakanahalfwidth") },
  { 0xFF78, wxT("kukatakanahalfwidth") },
  { 0xFF79, wxT("kekatakanahalfwidth") },
  { 0xFF7A, wxT("kokatakanahalfwidth") },
  { 0xFF7B, wxT("sakatakanahalfwidth") },
  { 0xFF7C, wxT("sikatakanahalfwidth") },
  { 0xFF7D, wxT("sukatakanahalfwidth") },
  { 0xFF7E, wxT("sekatakanahalfwidth") },
  { 0xFF7F, wxT("sokatakanahalfwidth") },
  { 0xFF80, wxT("takatakanahalfwidth") },
  { 0xFF81, wxT("tikatakanahalfwidth") },
  { 0xFF82, wxT("tukatakanahalfwidth") },
  { 0xFF83, wxT("tekatakanahalfwidth") },
  { 0xFF84, wxT("tokatakanahalfwidth") },
  { 0xFF85, wxT("nakatakanahalfwidth") },
  { 0xFF86, wxT("nikatakanahalfwidth") },
  { 0xFF87, wxT("nukatakanahalfwidth") },
  { 0xFF88, wxT("nekatakanahalfwidth") },
  { 0xFF89, wxT("nokatakanahalfwidth") },
  { 0xFF8A, wxT("hakatakanahalfwidth") },
  { 0xFF8B, wxT("hikatakanahalfwidth") },
  { 0xFF8C, wxT("hukatakanahalfwidth") },
  { 0xFF8D, wxT("hekatakanahalfwidth") },
  { 0xFF8E, wxT("hokatakanahalfwidth") },
  { 0xFF8F, wxT("makatakanahalfwidth") },
  { 0xFF90, wxT("mikatakanahalfwidth") },
  { 0xFF91, wxT("mukatakanahalfwidth") },
  { 0xFF92, wxT("mekatakanahalfwidth") },
  { 0xFF93, wxT("mokatakanahalfwidth") },
  { 0xFF94, wxT("yakatakanahalfwidth") },
  { 0xFF95, wxT("yukatakanahalfwidth") },
  { 0xFF96, wxT("yokatakanahalfwidth") },
  { 0xFF97, wxT("rakatakanahalfwidth") },
  { 0xFF98, wxT("rikatakanahalfwidth") },
  { 0xFF99, wxT("rukatakanahalfwidth") },
  { 0xFF9A, wxT("rekatakanahalfwidth") },
  { 0xFF9B, wxT("rokatakanahalfwidth") },
  { 0xFF9C, wxT("wakatakanahalfwidth") },
  { 0xFF9D, wxT("nkatakanahalfwidth") },
  { 0xFF9E, wxT("voicedmarkkanahalfwidth") },
  { 0xFF9F, wxT("semivoicedmarkkanahalfwidth") },
  { 0xFFE0, wxT("centmonospace") },
  { 0xFFE1, wxT("sterlingmonospace") },
  { 0xFFE3, wxT("macronmonospace") },
  { 0xFFE5, wxT("yenmonospace") },
  { 0xFFE6, wxT("wonmonospace") },
  { 0x0000, wxT("") }
};

static const size_t gs_unicode2GlyphNameTableSize = 3684;
