
CAMLprim value
Python__Py_NoneStruct_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python__Py_NoneStruct;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python__Py_TrueStruct_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python__Py_TrueStruct;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_Py_Exit_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    int arg0 = Int_val(arg0_ocaml);
    Python_Py_Exit(arg0);
    CAMLreturn(Val_unit);
}

CAMLprim value
Python_Py_GetVersion_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    char *result = Python_Py_GetVersion();
    CAMLreturn(caml_copy_string(result));
}

CAMLprim value
Python_Py_GetPlatform_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    char *result = Python_Py_GetPlatform();
    CAMLreturn(caml_copy_string(result));
}

CAMLprim value
Python_Py_GetCopyright_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    char *result = Python_Py_GetCopyright();
    CAMLreturn(caml_copy_string(result));
}

CAMLprim value
Python_Py_GetCompiler_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    char *result = Python_Py_GetCompiler();
    CAMLreturn(caml_copy_string(result));
}

CAMLprim value
Python_Py_GetBuildInfo_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    char *result = Python_Py_GetBuildInfo();
    CAMLreturn(caml_copy_string(result));
}

CAMLprim value
Python_Py_FdIsInteractive_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    FILE *arg0 = fdopen(dup(Int_val(arg0_ocaml)), "r");
    char *arg1 = String_val(arg1_ocaml);
    int result = Python_Py_FdIsInteractive(arg0, arg1);
    fclose(arg0);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_Py_Initialize_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    Python_Py_Initialize();
    CAMLreturn(Val_unit);
}

CAMLprim value
Python_PyBool_Type_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyBool_Type;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyCallable_Check_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    int result = Python_PyCallable_Check(arg0);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyCapsule_IsValid_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    char *arg1 = String_val(arg1_ocaml);
    int result = Python_PyCapsule_IsValid(arg0, arg1);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyDict_Clear_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    Python_PyDict_Clear(arg0);
    CAMLreturn(Val_unit);
}

CAMLprim value
Python_PyDict_Copy_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python_PyDict_Copy(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyDict_DelItem_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    int result = Python_PyDict_DelItem(arg0, arg1);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyDict_DelItemString_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    char *arg1 = String_val(arg1_ocaml);
    int result = Python_PyDict_DelItemString(arg0, arg1);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyDict_GetItem_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyDict_GetItem(arg0, arg1);
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyDict_GetItemString_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    char *arg1 = String_val(arg1_ocaml);
    PyObject *result = Python_PyDict_GetItemString(arg0, arg1);
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyDict_Keys_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python_PyDict_Keys(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyDict_Items_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python_PyDict_Items(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyDict_New_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyDict_New();
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyDict_SetItem_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *arg2 = pyunwrap(arg2_ocaml);
    int result = Python_PyDict_SetItem(arg0, arg1, arg2);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyDict_SetItemString_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    char *arg1 = String_val(arg1_ocaml);
    PyObject *arg2 = pyunwrap(arg2_ocaml);
    int result = Python_PyDict_SetItemString(arg0, arg1, arg2);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyDict_Size_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    int result = Python_PyDict_Size(arg0);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyDict_Values_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python_PyDict_Values(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyErr_Clear_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    Python_PyErr_Clear();
    CAMLreturn(Val_unit);
}

CAMLprim value
Python_PyErr_ExceptionMatches_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    int result = Python_PyErr_ExceptionMatches(arg0);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyErr_GivenExceptionMatches_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    int result = Python_PyErr_GivenExceptionMatches(arg0, arg1);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyErr_Occurred_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyErr_Occurred();
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyErr_Print_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    Python_PyErr_Print();
    CAMLreturn(Val_unit);
}

CAMLprim value
Python_PyErr_Restore_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *arg2 = pyunwrap(arg2_ocaml);
    Python_PyErr_Restore(arg0, arg1, arg2);
    CAMLreturn(Val_unit);
}

CAMLprim value
Python_PyErr_PrintEx_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    int arg0 = Int_val(arg0_ocaml);
    Python_PyErr_PrintEx(arg0);
    CAMLreturn(Val_unit);
}

CAMLprim value
Python_PyErr_SetNone_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    Python_PyErr_SetNone(arg0);
    CAMLreturn(Val_unit);
}

CAMLprim value
Python_PyErr_SetString_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    char *arg1 = String_val(arg1_ocaml);
    Python_PyErr_SetString(arg0, arg1);
    CAMLreturn(Val_unit);
}

CAMLprim value
Python_PyErr_SetObject_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    Python_PyErr_SetObject(arg0, arg1);
    CAMLreturn(Val_unit);
}

CAMLprim value
Python_PyEval_CallObjectWithKeywords_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *arg2 = pyunwrap(arg2_ocaml);
    PyObject *result = Python_PyEval_CallObjectWithKeywords(arg0, arg1, arg2);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyEval_GetBuiltins_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyEval_GetBuiltins();
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyEval_GetGlobals_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyEval_GetGlobals();
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyEval_GetLocals_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyEval_GetLocals();
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_BaseException_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_BaseException;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_Exception_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_Exception;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_StopIteration_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_StopIteration;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_GeneratorExit_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_GeneratorExit;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_ArithmeticError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_ArithmeticError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_LookupError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_LookupError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_AssertionError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_AssertionError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_AttributeError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_AttributeError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_BufferError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_BufferError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_EOFError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_EOFError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_FloatingPointError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_FloatingPointError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_OSError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_OSError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_ImportError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_ImportError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_IndexError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_IndexError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_KeyError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_KeyError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_KeyboardInterrupt_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_KeyboardInterrupt;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_MemoryError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_MemoryError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_NameError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_NameError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_OverflowError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_OverflowError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_RuntimeError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_RuntimeError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_NotImplementedError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_NotImplementedError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_SyntaxError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_SyntaxError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_IndentationError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_IndentationError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_TabError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_TabError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_ReferenceError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_ReferenceError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_SystemError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_SystemError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_SystemExit_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_SystemExit;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_TypeError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_TypeError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_UnboundLocalError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_UnboundLocalError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_UnicodeError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_UnicodeError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_UnicodeEncodeError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_UnicodeEncodeError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_UnicodeDecodeError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_UnicodeDecodeError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_UnicodeTranslateError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_UnicodeTranslateError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_ValueError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_ValueError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_ZeroDivisionError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_ZeroDivisionError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_EnvironmentError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_EnvironmentError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_IOError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_IOError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_RecursionErrorInst_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_RecursionErrorInst;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_Warning_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_Warning;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_UserWarning_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_UserWarning;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_DeprecationWarning_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_DeprecationWarning;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_PendingDeprecationWarning_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_PendingDeprecationWarning;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_SyntaxWarning_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_SyntaxWarning;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_RuntimeWarning_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_RuntimeWarning;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_FutureWarning_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_FutureWarning;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_ImportWarning_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_ImportWarning;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_UnicodeWarning_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_UnicodeWarning;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyExc_BytesWarning_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyExc_BytesWarning;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyFloat_AsDouble_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    double result = Python_PyFloat_AsDouble(arg0);
    CAMLreturn(caml_copy_double(result));
}

CAMLprim value
Python_PyFloat_FromDouble_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    double arg0 = Double_val(arg0_ocaml);
    PyObject *result = Python_PyFloat_FromDouble(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyFloat_Type_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyFloat_Type;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyImport_AddModule_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    char *arg0 = String_val(arg0_ocaml);
    PyObject *result = Python_PyImport_AddModule(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyImport_Cleanup_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    Python_PyImport_Cleanup();
    CAMLreturn(Val_unit);
}

CAMLprim value
Python_PyImport_ExecCodeModule_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    char *arg0 = String_val(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyImport_ExecCodeModule(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyImport_ExecCodeModuleEx_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    char *arg0 = String_val(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    char *arg2 = String_val(arg2_ocaml);
    PyObject *result = Python_PyImport_ExecCodeModuleEx(arg0, arg1, arg2);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyImport_GetMagicNumber_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    long result = Python_PyImport_GetMagicNumber();
    CAMLreturn(copy_int64(result));
}

CAMLprim value
Python_PyImport_GetModuleDict_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyImport_GetModuleDict();
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyImport_ImportFrozenModule_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    char *arg0 = String_val(arg0_ocaml);
    int result = Python_PyImport_ImportFrozenModule(arg0);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyImport_Import_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python_PyImport_Import(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyImport_ImportModule_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    char *arg0 = String_val(arg0_ocaml);
    PyObject *result = Python_PyImport_ImportModule(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyImport_ImportModuleLevel_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml, value arg3_ocaml, value arg4_ocaml)
{
    CAMLparam5(arg0_ocaml, arg1_ocaml, arg2_ocaml, arg3_ocaml, arg4_ocaml);

    assert_initialized();
    char *arg0 = String_val(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *arg2 = pyunwrap(arg2_ocaml);
    PyObject *arg3 = pyunwrap(arg3_ocaml);
    int arg4 = Int_val(arg4_ocaml);
    PyObject *result = Python_PyImport_ImportModuleLevel(arg0, arg1, arg2, arg3, arg4);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyImport_ReloadModule_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python_PyImport_ReloadModule(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyIter_Next_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python_PyIter_Next(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyList_New_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    Py_ssize_t arg0 = Int_val(arg0_ocaml);
    PyObject *result = Python_PyList_New(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyList_GetItem_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    PyObject *result = Python_PyList_GetItem(arg0, arg1);
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyList_SetItem_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    int arg1 = Int_val(arg1_ocaml);
    PyObject *arg2 = pyunwrap(arg2_ocaml);
    Py_INCREF(arg2);
    int result = Python_PyList_SetItem(arg0, arg1, arg2);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyList_Size_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    int result = Python_PyList_Size(arg0);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyLong_AsLong_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    long result = Python_PyLong_AsLong(arg0);
    CAMLreturn(copy_int64(result));
}

CAMLprim value
Python_PyLong_FromLong_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    long arg0 = Int64_val(arg0_ocaml);
    PyObject *result = Python_PyLong_FromLong(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyMapping_Check_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    int result = Python_PyMapping_Check(arg0);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyMapping_GetItemString_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    char *arg1 = String_val(arg1_ocaml);
    PyObject *result = Python_PyMapping_GetItemString(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyMapping_HasKey_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    int result = Python_PyMapping_HasKey(arg0, arg1);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyMapping_HasKeyString_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    char *arg1 = String_val(arg1_ocaml);
    int result = Python_PyMapping_HasKeyString(arg0, arg1);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyMapping_Length_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    int result = Python_PyMapping_Length(arg0);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyMapping_SetItemString_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    char *arg1 = String_val(arg1_ocaml);
    PyObject *arg2 = pyunwrap(arg2_ocaml);
    int result = Python_PyMapping_SetItemString(arg0, arg1, arg2);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyMapping_Size_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    int result = Python_PyMapping_Size(arg0);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyMethod_Function_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python_PyMethod_Function(arg0);
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyMethod_New_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *arg2 = pyunwrap(arg2_ocaml);
    PyObject *result = Python_PyMethod_New(arg0, arg1, arg2);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyMethod_Self_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python_PyMethod_Self(arg0);
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyModule_AddObject_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    char *arg1 = String_val(arg1_ocaml);
    PyObject *arg2 = pyunwrap(arg2_ocaml);
    int result = Python_PyModule_AddObject(arg0, arg1, arg2);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyModule_GetDict_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python_PyModule_GetDict(arg0);
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyModule_GetFilename_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    char *result = Python_PyModule_GetFilename(arg0);
    CAMLreturn(pywrap_string_option(result));
}

CAMLprim value
Python_PyModule_GetName_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    char *result = Python_PyModule_GetName(arg0);
    CAMLreturn(pywrap_string_option(result));
}

CAMLprim value
Python_PyModule_New_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    char *arg0 = String_val(arg0_ocaml);
    PyObject *result = Python_PyModule_New(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyModule_Type_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyModule_Type;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyNumber_Absolute_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python_PyNumber_Absolute(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_Add_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyNumber_Add(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_And_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyNumber_And(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_Check_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    int result = Python_PyNumber_Check(arg0);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyNumber_Divmod_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyNumber_Divmod(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_Float_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python_PyNumber_Float(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_FloorDivide_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyNumber_FloorDivide(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_InPlaceAdd_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyNumber_InPlaceAdd(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_InPlaceAnd_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyNumber_InPlaceAnd(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_InPlaceFloorDivide_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyNumber_InPlaceFloorDivide(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_InPlaceLshift_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyNumber_InPlaceLshift(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_InPlaceMultiply_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyNumber_InPlaceMultiply(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_InPlaceOr_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyNumber_InPlaceOr(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_InPlacePower_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *arg2 = pyunwrap(arg2_ocaml);
    PyObject *result = Python_PyNumber_InPlacePower(arg0, arg1, arg2);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_InPlaceRemainder_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyNumber_InPlaceRemainder(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_InPlaceRshift_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyNumber_InPlaceRshift(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_InPlaceSubtract_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyNumber_InPlaceSubtract(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_InPlaceTrueDivide_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyNumber_InPlaceTrueDivide(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_InPlaceXor_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyNumber_InPlaceXor(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_Invert_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python_PyNumber_Invert(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_Long_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python_PyNumber_Long(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_Lshift_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyNumber_Lshift(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_Multiply_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyNumber_Multiply(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_Negative_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python_PyNumber_Negative(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_Or_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyNumber_Or(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_Positive_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python_PyNumber_Positive(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_Power_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *arg2 = pyunwrap(arg2_ocaml);
    PyObject *result = Python_PyNumber_Power(arg0, arg1, arg2);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_Remainder_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyNumber_Remainder(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_Rshift_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyNumber_Rshift(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_Subtract_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyNumber_Subtract(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_TrueDivide_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyNumber_TrueDivide(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyNumber_Xor_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyNumber_Xor(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyObject_DelItem_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    int result = Python_PyObject_DelItem(arg0, arg1);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyObject_DelItemString_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    char *arg1 = String_val(arg1_ocaml);
    int result = Python_PyObject_DelItemString(arg0, arg1);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyObject_GetAttr_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyObject_GetAttr(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyObject_GetAttrString_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    char *arg1 = String_val(arg1_ocaml);
    PyObject *result = Python_PyObject_GetAttrString(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyObject_GetItem_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PyObject_GetItem(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyObject_GetIter_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python_PyObject_GetIter(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyObject_HasAttr_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    int result = Python_PyObject_HasAttr(arg0, arg1);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyObject_HasAttrString_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    char *arg1 = String_val(arg1_ocaml);
    int result = Python_PyObject_HasAttrString(arg0, arg1);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyObject_Hash_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    long result = Python_PyObject_Hash(arg0);
    CAMLreturn(copy_int64(result));
}

CAMLprim value
Python_PyObject_IsTrue_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    int result = Python_PyObject_IsTrue(arg0);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyObject_Not_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    int result = Python_PyObject_Not(arg0);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyObject_Print_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    FILE *arg1 = fdopen(dup(Int_val(arg1_ocaml)), "r");
    int arg2 = Int_val(arg2_ocaml);
    int result = Python_PyObject_Print(arg0, arg1, arg2);
    fclose(arg1);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyObject_Repr_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python_PyObject_Repr(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyObject_RichCompare_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    int arg2 = Int_val(arg2_ocaml);
    PyObject *result = Python_PyObject_RichCompare(arg0, arg1, arg2);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyObject_RichCompareBool_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    int arg2 = Int_val(arg2_ocaml);
    int result = Python_PyObject_RichCompareBool(arg0, arg1, arg2);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyObject_SetAttr_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *arg2 = pyunwrap(arg2_ocaml);
    int result = Python_PyObject_SetAttr(arg0, arg1, arg2);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyObject_SetAttrString_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    char *arg1 = String_val(arg1_ocaml);
    PyObject *arg2 = pyunwrap(arg2_ocaml);
    int result = Python_PyObject_SetAttrString(arg0, arg1, arg2);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyObject_SetItem_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *arg2 = pyunwrap(arg2_ocaml);
    int result = Python_PyObject_SetItem(arg0, arg1, arg2);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyObject_Size_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    int result = Python_PyObject_Size(arg0);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyObject_Str_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python_PyObject_Str(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyObject_Type_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python_PyObject_Type(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyRun_AnyFileExFlags_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml, value arg3_ocaml)
{
    CAMLparam4(arg0_ocaml, arg1_ocaml, arg2_ocaml, arg3_ocaml);

    assert_initialized();
    FILE *arg0 = fdopen(dup(Int_val(arg0_ocaml)), "r");
    char *arg1 = String_val(arg1_ocaml);
    int arg2 = Int_val(arg2_ocaml);
    PyCompilerFlags *arg3 = pyunwrap_compilerflags(arg3_ocaml);
    int result = Python_PyRun_AnyFileExFlags(arg0, arg1, arg2, arg3);
    fclose(arg0);
    free(arg3);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyRun_FileExFlags_native(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml, value arg3_ocaml, value arg4_ocaml, value arg5_ocaml, value arg6_ocaml)
{
    CAMLparam5(arg0_ocaml, arg1_ocaml, arg2_ocaml, arg3_ocaml, arg4_ocaml);
    CAMLxparam2(arg5_ocaml, arg6_ocaml);

    assert_initialized();
    FILE *arg0 = fdopen(dup(Int_val(arg0_ocaml)), "r");
    char *arg1 = String_val(arg1_ocaml);
    int arg2 = 256 + Int_val(arg2_ocaml);
    PyObject *arg3 = pyunwrap(arg3_ocaml);
    PyObject *arg4 = pyunwrap(arg4_ocaml);
    int arg5 = Int_val(arg5_ocaml);
    PyCompilerFlags *arg6 = pyunwrap_compilerflags(arg6_ocaml);
    PyObject *result = Python_PyRun_FileExFlags(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    fclose(arg0);
    free(arg6);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyRun_FileExFlags_bytecode(value *argv, int argn)
{
    return Python_PyRun_FileExFlags_native(argv[0], argv[1], argv[2], argv[3], argv[4], argv[5], argv[6]);
}

CAMLprim value
Python_PyRun_InteractiveOneFlags_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    FILE *arg0 = fdopen(dup(Int_val(arg0_ocaml)), "r");
    char *arg1 = String_val(arg1_ocaml);
    PyCompilerFlags *arg2 = pyunwrap_compilerflags(arg2_ocaml);
    int result = Python_PyRun_InteractiveOneFlags(arg0, arg1, arg2);
    fclose(arg0);
    free(arg2);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyRun_InteractiveLoopFlags_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    FILE *arg0 = fdopen(dup(Int_val(arg0_ocaml)), "r");
    char *arg1 = String_val(arg1_ocaml);
    PyCompilerFlags *arg2 = pyunwrap_compilerflags(arg2_ocaml);
    int result = Python_PyRun_InteractiveLoopFlags(arg0, arg1, arg2);
    fclose(arg0);
    free(arg2);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyRun_SimpleFileExFlags_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml, value arg3_ocaml)
{
    CAMLparam4(arg0_ocaml, arg1_ocaml, arg2_ocaml, arg3_ocaml);

    assert_initialized();
    FILE *arg0 = fdopen(dup(Int_val(arg0_ocaml)), "r");
    char *arg1 = String_val(arg1_ocaml);
    int arg2 = Int_val(arg2_ocaml);
    PyCompilerFlags *arg3 = pyunwrap_compilerflags(arg3_ocaml);
    int result = Python_PyRun_SimpleFileExFlags(arg0, arg1, arg2, arg3);
    fclose(arg0);
    free(arg3);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyRun_StringFlags_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml, value arg3_ocaml, value arg4_ocaml)
{
    CAMLparam5(arg0_ocaml, arg1_ocaml, arg2_ocaml, arg3_ocaml, arg4_ocaml);

    assert_initialized();
    char *arg0 = String_val(arg0_ocaml);
    int arg1 = 256 + Int_val(arg1_ocaml);
    PyObject *arg2 = pyunwrap(arg2_ocaml);
    PyObject *arg3 = pyunwrap(arg3_ocaml);
    PyCompilerFlags *arg4 = pyunwrap_compilerflags(arg4_ocaml);
    PyObject *result = Python_PyRun_StringFlags(arg0, arg1, arg2, arg3, arg4);
    free(arg4);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyRun_SimpleStringFlags_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    char *arg0 = String_val(arg0_ocaml);
    PyCompilerFlags *arg1 = pyunwrap_compilerflags(arg1_ocaml);
    int result = Python_PyRun_SimpleStringFlags(arg0, arg1);
    free(arg1);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PySequence_Check_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    int result = Python_PySequence_Check(arg0);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PySequence_Concat_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PySequence_Concat(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PySequence_Contains_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    int result = Python_PySequence_Contains(arg0, arg1);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PySequence_Count_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    int result = Python_PySequence_Count(arg0, arg1);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PySequence_DelItem_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    int result = Python_PySequence_DelItem(arg0, arg1);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PySequence_DelSlice_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    Py_ssize_t arg2 = Int_val(arg2_ocaml);
    int result = Python_PySequence_DelSlice(arg0, arg1, arg2);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PySequence_Fast_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    char *arg1 = String_val(arg1_ocaml);
    PyObject *result = Python_PySequence_Fast(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PySequence_GetItem_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    PyObject *result = Python_PySequence_GetItem(arg0, arg1);
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PySequence_GetSlice_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    Py_ssize_t arg2 = Int_val(arg2_ocaml);
    PyObject *result = Python_PySequence_GetSlice(arg0, arg1, arg2);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PySequence_In_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    int result = Python_PySequence_In(arg0, arg1);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PySequence_Index_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    int result = Python_PySequence_Index(arg0, arg1);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PySequence_InPlaceConcat_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python_PySequence_InPlaceConcat(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PySequence_InPlaceRepeat_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    PyObject *result = Python_PySequence_InPlaceRepeat(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PySequence_Length_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    int result = Python_PySequence_Length(arg0);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PySequence_List_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python_PySequence_List(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PySequence_Repeat_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    PyObject *result = Python_PySequence_Repeat(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PySequence_SetItem_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    PyObject *arg2 = pyunwrap(arg2_ocaml);
    int result = Python_PySequence_SetItem(arg0, arg1, arg2);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PySequence_SetSlice_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml, value arg3_ocaml)
{
    CAMLparam4(arg0_ocaml, arg1_ocaml, arg2_ocaml, arg3_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    Py_ssize_t arg2 = Int_val(arg2_ocaml);
    PyObject *arg3 = pyunwrap(arg3_ocaml);
    int result = Python_PySequence_SetSlice(arg0, arg1, arg2, arg3);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PySequence_Size_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    Py_ssize_t result = Python_PySequence_Size(arg0);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PySequence_Tuple_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python_PySequence_Tuple(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PySlice_New_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *arg2 = pyunwrap(arg2_ocaml);
    PyObject *result = Python_PySlice_New(arg0, arg1, arg2);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyTuple_GetItem_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    PyObject *result = Python_PyTuple_GetItem(arg0, arg1);
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python_PyTuple_GetSlice_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    Py_ssize_t arg2 = Int_val(arg2_ocaml);
    PyObject *result = Python_PyTuple_GetSlice(arg0, arg1, arg2);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyTuple_New_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    Py_ssize_t arg0 = Int_val(arg0_ocaml);
    PyObject *result = Python_PyTuple_New(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python_PyTuple_SetItem_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    PyObject *arg2 = pyunwrap(arg2_ocaml);
    Py_INCREF(arg2);
    int result = Python_PyTuple_SetItem(arg0, arg1, arg2);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyTuple_Size_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    int result = Python_PyTuple_Size(arg0);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyType_IsSubtype_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_initialized();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    int result = Python_PyType_IsSubtype(arg0, arg1);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python_PyType_Type_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_initialized();

    PyObject *result = Python_PyType_Type;
    CAMLreturn(pywrap(result, false));
}

/* Python 2 */

CAMLprim value
Python2_Py_GetProgramName_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_python2();

    char *result = Python2_Py_GetProgramName();
    CAMLreturn(caml_copy_string(result));
}

CAMLprim value
Python2_Py_GetPythonHome_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_python2();

    char *result = Python2_Py_GetPythonHome();
    CAMLreturn(caml_copy_string(result));
}

CAMLprim value
Python2_Py_GetProgramFullPath_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_python2();

    char *result = Python2_Py_GetProgramFullPath();
    CAMLreturn(caml_copy_string(result));
}

CAMLprim value
Python2_Py_GetPrefix_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_python2();

    char *result = Python2_Py_GetPrefix();
    CAMLreturn(caml_copy_string(result));
}

CAMLprim value
Python2_Py_GetExecPrefix_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_python2();

    char *result = Python2_Py_GetExecPrefix();
    CAMLreturn(caml_copy_string(result));
}

CAMLprim value
Python2_Py_GetPath_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_python2();

    char *result = Python2_Py_GetPath();
    CAMLreturn(caml_copy_string(result));
}

CAMLprim value
Python2_Py_SetProgramName_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_python2();
    char *arg0 = String_val(arg0_ocaml);
    Python2_Py_SetProgramName(arg0);
    CAMLreturn(Val_unit);
}

CAMLprim value
Python2_Py_SetPythonHome_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_python2();
    char *arg0 = String_val(arg0_ocaml);
    Python2_Py_SetPythonHome(arg0);
    CAMLreturn(Val_unit);
}

CAMLprim value
Python2_Py_CompileStringFlags_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml, value arg3_ocaml)
{
    CAMLparam4(arg0_ocaml, arg1_ocaml, arg2_ocaml, arg3_ocaml);

    assert_python2();
    char *arg0 = String_val(arg0_ocaml);
    char *arg1 = String_val(arg1_ocaml);
    int arg2 = 256 + Int_val(arg2_ocaml);
    PyCompilerFlags *arg3 = pyunwrap_compilerflags(arg3_ocaml);
    PyObject *result = Python2_Py_CompileStringFlags(arg0, arg1, arg2, arg3);
    free(arg3);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python2_PyClass_New_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_python2();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *arg2 = pyunwrap(arg2_ocaml);
    PyObject *result = Python2_PyClass_New(arg0, arg1, arg2);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python2_PyExc_StandardError_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_python2();

    PyObject *result = Python2_PyExc_StandardError;
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python2_PyEval_GetRestricted_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_python2();

    int result = Python2_PyEval_GetRestricted();
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python2_PyInstance_New_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_python2();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *arg2 = pyunwrap(arg2_ocaml);
    PyObject *result = Python2_PyInstance_New(arg0, arg1, arg2);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python2_PyInstance_NewRaw_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_python2();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python2_PyInstance_NewRaw(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python2_PyInt_AsLong_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_python2();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    long result = Python2_PyInt_AsLong(arg0);
    CAMLreturn(copy_int64(result));
}

CAMLprim value
Python2_PyInt_FromLong_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_python2();
    long arg0 = Int64_val(arg0_ocaml);
    PyObject *result = Python2_PyInt_FromLong(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python2_PyInt_GetMax_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_python2();

    long result = Python2_PyInt_GetMax();
    CAMLreturn(copy_int64(result));
}

CAMLprim value
Python2_PyMethod_Class_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_python2();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python2_PyMethod_Class(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python2_PyNumber_Divide_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_python2();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python2_PyNumber_Divide(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python2_PyNumber_InPlaceDivide_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_python2();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python2_PyNumber_InPlaceDivide(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python2_PyNumber_Int_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_python2();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python2_PyNumber_Int(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python2_PyObject_Cmp_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_python2();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    int arg2 = pyunwrap_intref(arg2_ocaml);
    int result = Python2_PyObject_Cmp(arg0, arg1, &arg2);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python2_PyObject_Compare_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_python2();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    int result = Python2_PyObject_Compare(arg0, arg1);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python2_PyObject_Unicode_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_python2();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python2_PyObject_Unicode(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python2_PyString_AsString_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_python2();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    char *result = Python2_PyString_AsString(arg0);
    CAMLreturn(pywrap_string_option(result));
}

CAMLprim value
Python2_PyString_Format_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_python2();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python2_PyString_Format(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python2_PyString_FromString_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_python2();
    char *arg0 = String_val(arg0_ocaml);
    PyObject *result = Python2_PyString_FromString(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python2_PyString_FromStringAndSize_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_python2();
    char *arg0 = String_val(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    PyObject *result = Python2_PyString_FromStringAndSize(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python2_PyString_Size_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_python2();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    Py_ssize_t result = Python2_PyString_Size(arg0);
    CAMLreturn(Val_int(result));
}

/* UCS 2 */

CAMLprim value
UCS2_PyUnicodeUCS2_AsEncodedString_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_ucs2();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    char *arg1 = String_val(arg1_ocaml);
    char *arg2 = String_val(arg2_ocaml);
    PyObject *result = UCS2_PyUnicodeUCS2_AsEncodedString(arg0, arg1, arg2);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
UCS2_PyUnicodeUCS2_AsUTF8String_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_ucs2();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = UCS2_PyUnicodeUCS2_AsUTF8String(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
UCS2_PyUnicodeUCS2_AsUTF16String_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_ucs2();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = UCS2_PyUnicodeUCS2_AsUTF16String(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
UCS2_PyUnicodeUCS2_AsUTF32String_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_ucs2();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = UCS2_PyUnicodeUCS2_AsUTF32String(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
UCS2_PyUnicodeUCS2_DecodeUTF8_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_ucs2();
    char *arg0 = String_val(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    char *arg2 = Is_block(arg2_ocaml) ? String_val(Field(arg2_ocaml, 0)) : NULL;
    PyObject *result = UCS2_PyUnicodeUCS2_DecodeUTF8(arg0, arg1, arg2);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
UCS2_PyUnicodeUCS2_DecodeUTF16_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml, value arg3_ocaml)
{
    CAMLparam4(arg0_ocaml, arg1_ocaml, arg2_ocaml, arg3_ocaml);

    assert_ucs2();
    char *arg0 = String_val(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    char *arg2 = Is_block(arg2_ocaml) ? String_val(Field(arg2_ocaml, 0)) : NULL;
    int arg3 = pyunwrap_intref(arg3_ocaml);
    PyObject *result = UCS2_PyUnicodeUCS2_DecodeUTF16(arg0, arg1, arg2, &arg3);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
UCS2_PyUnicodeUCS2_DecodeUTF32_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml, value arg3_ocaml)
{
    CAMLparam4(arg0_ocaml, arg1_ocaml, arg2_ocaml, arg3_ocaml);

    assert_ucs2();
    char *arg0 = String_val(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    char *arg2 = Is_block(arg2_ocaml) ? String_val(Field(arg2_ocaml, 0)) : NULL;
    int arg3 = pyunwrap_intref(arg3_ocaml);
    PyObject *result = UCS2_PyUnicodeUCS2_DecodeUTF32(arg0, arg1, arg2, &arg3);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
UCS2_PyUnicodeUCS2_Format_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_ucs2();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = UCS2_PyUnicodeUCS2_Format(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
UCS2_PyUnicodeUCS2_FromString_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_ucs2();
    char *arg0 = String_val(arg0_ocaml);
    PyObject *result = UCS2_PyUnicodeUCS2_FromString(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
UCS2_PyUnicodeUCS2_GetSize_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_ucs2();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    int result = UCS2_PyUnicodeUCS2_GetSize(arg0);
    CAMLreturn(Val_int(result));
}

CAMLprim value
UCS2_PyUnicodeUCS2_FromUnicode_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_ucs2();
    int16_t *arg0 = pyunwrap_ucs2(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    PyObject *result = UCS2_PyUnicodeUCS2_FromUnicode(arg0, arg1);
    free(arg0);
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
UCS2_PyUnicodeUCS2_AsUnicode_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_ucs2();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    int16_t *result = UCS2_PyUnicodeUCS2_AsUnicode(arg0);
    CAMLreturn(pywrap_ucs2_option(result));
}

/* UCS 4 */

CAMLprim value
UCS4_PyUnicodeUCS4_AsEncodedString_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_ucs4();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    char *arg1 = String_val(arg1_ocaml);
    char *arg2 = String_val(arg2_ocaml);
    PyObject *result = UCS4_PyUnicodeUCS4_AsEncodedString(arg0, arg1, arg2);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
UCS4_PyUnicodeUCS4_AsUTF8String_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_ucs4();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = UCS4_PyUnicodeUCS4_AsUTF8String(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
UCS4_PyUnicodeUCS4_AsUTF16String_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_ucs4();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = UCS4_PyUnicodeUCS4_AsUTF16String(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
UCS4_PyUnicodeUCS4_AsUTF32String_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_ucs4();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = UCS4_PyUnicodeUCS4_AsUTF32String(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
UCS4_PyUnicodeUCS4_DecodeUTF8_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_ucs4();
    char *arg0 = String_val(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    char *arg2 = Is_block(arg2_ocaml) ? String_val(Field(arg2_ocaml, 0)) : NULL;
    PyObject *result = UCS4_PyUnicodeUCS4_DecodeUTF8(arg0, arg1, arg2);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
UCS4_PyUnicodeUCS4_DecodeUTF16_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml, value arg3_ocaml)
{
    CAMLparam4(arg0_ocaml, arg1_ocaml, arg2_ocaml, arg3_ocaml);

    assert_ucs4();
    char *arg0 = String_val(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    char *arg2 = Is_block(arg2_ocaml) ? String_val(Field(arg2_ocaml, 0)) : NULL;
    int arg3 = pyunwrap_intref(arg3_ocaml);
    PyObject *result = UCS4_PyUnicodeUCS4_DecodeUTF16(arg0, arg1, arg2, &arg3);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
UCS4_PyUnicodeUCS4_DecodeUTF32_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml, value arg3_ocaml)
{
    CAMLparam4(arg0_ocaml, arg1_ocaml, arg2_ocaml, arg3_ocaml);

    assert_ucs4();
    char *arg0 = String_val(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    char *arg2 = Is_block(arg2_ocaml) ? String_val(Field(arg2_ocaml, 0)) : NULL;
    int arg3 = pyunwrap_intref(arg3_ocaml);
    PyObject *result = UCS4_PyUnicodeUCS4_DecodeUTF32(arg0, arg1, arg2, &arg3);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
UCS4_PyUnicodeUCS4_Format_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_ucs4();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = UCS4_PyUnicodeUCS4_Format(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
UCS4_PyUnicodeUCS4_FromString_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_ucs4();
    char *arg0 = String_val(arg0_ocaml);
    PyObject *result = UCS4_PyUnicodeUCS4_FromString(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
UCS4_PyUnicodeUCS4_GetSize_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_ucs4();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    int result = UCS4_PyUnicodeUCS4_GetSize(arg0);
    CAMLreturn(Val_int(result));
}

CAMLprim value
UCS4_PyUnicodeUCS4_FromUnicode_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_ucs4();
    int32_t *arg0 = pyunwrap_ucs4(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    PyObject *result = UCS4_PyUnicodeUCS4_FromUnicode(arg0, arg1);
    free(arg0);
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
UCS4_PyUnicodeUCS4_AsUnicode_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_ucs4();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    int32_t *result = UCS4_PyUnicodeUCS4_AsUnicode(arg0);
    CAMLreturn(pywrap_ucs4_option_and_free(result));
}

/* Python 3 */

CAMLprim value
Python3_Py_GetProgramName_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_python3();

    wchar_t *result = Python3_Py_GetProgramName();
    CAMLreturn(pywrap_wide_string(result));
}

CAMLprim value
Python3_Py_GetPythonHome_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_python3();

    wchar_t *result = Python3_Py_GetPythonHome();
    CAMLreturn(pywrap_wide_string(result));
}

CAMLprim value
Python3_Py_GetProgramFullPath_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_python3();

    wchar_t *result = Python3_Py_GetProgramFullPath();
    CAMLreturn(pywrap_wide_string(result));
}

CAMLprim value
Python3_Py_GetPrefix_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_python3();

    wchar_t *result = Python3_Py_GetPrefix();
    CAMLreturn(pywrap_wide_string(result));
}

CAMLprim value
Python3_Py_GetExecPrefix_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_python3();

    wchar_t *result = Python3_Py_GetExecPrefix();
    CAMLreturn(pywrap_wide_string(result));
}

CAMLprim value
Python3_Py_GetPath_wrapper(value unit)
{
    CAMLparam1(unit);
    assert_python3();

    wchar_t *result = Python3_Py_GetPath();
    CAMLreturn(pywrap_wide_string(result));
}

CAMLprim value
Python3_Py_SetProgramName_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_python3();
    wchar_t *arg0 = pyunwrap_wide_string(arg0_ocaml);
    Python3_Py_SetProgramName(arg0);
    CAMLreturn(Val_unit);
}

CAMLprim value
Python3_Py_SetPythonHome_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_python3();
    wchar_t *arg0 = pyunwrap_wide_string(arg0_ocaml);
    Python3_Py_SetPythonHome(arg0);
    CAMLreturn(Val_unit);
}

CAMLprim value
Python3_Py_CompileStringExFlags_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml, value arg3_ocaml, value arg4_ocaml)
{
    CAMLparam5(arg0_ocaml, arg1_ocaml, arg2_ocaml, arg3_ocaml, arg4_ocaml);

    assert_python3();
    char *arg0 = String_val(arg0_ocaml);
    char *arg1 = String_val(arg1_ocaml);
    int arg2 = 256 + Int_val(arg2_ocaml);
    PyCompilerFlags *arg3 = pyunwrap_compilerflags(arg3_ocaml);
    int arg4 = Int_val(arg4_ocaml);
    PyObject *result = Python3_Py_CompileStringExFlags(arg0, arg1, arg2, arg3, arg4);
    free(arg3);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python3_PyBytes_AsString_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_python3();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    char *result = Python3_PyBytes_AsString(arg0);
    CAMLreturn(pywrap_string_option(result));
}

CAMLprim value
Python3_PyBytes_FromString_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_python3();
    char *arg0 = String_val(arg0_ocaml);
    PyObject *result = Python3_PyBytes_FromString(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python3_PyBytes_Size_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_python3();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    Py_ssize_t result = Python3_PyBytes_Size(arg0);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python3_PyImport_ExecCodeModuleObject_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml, value arg3_ocaml)
{
    CAMLparam4(arg0_ocaml, arg1_ocaml, arg2_ocaml, arg3_ocaml);

    assert_python3();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *arg2 = pyunwrap(arg2_ocaml);
    PyObject *arg3 = pyunwrap(arg3_ocaml);
    PyObject *result = Python3_PyImport_ExecCodeModuleObject(arg0, arg1, arg2, arg3);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python3_PyImport_ExecCodeModuleWithPathnames_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml, value arg3_ocaml)
{
    CAMLparam4(arg0_ocaml, arg1_ocaml, arg2_ocaml, arg3_ocaml);

    assert_python3();
    char *arg0 = String_val(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    char *arg2 = String_val(arg2_ocaml);
    char *arg3 = String_val(arg3_ocaml);
    PyObject *result = Python3_PyImport_ExecCodeModuleWithPathnames(arg0, arg1, arg2, arg3);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python3_PyImport_ImportModuleLevelObject_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml, value arg3_ocaml, value arg4_ocaml)
{
    CAMLparam5(arg0_ocaml, arg1_ocaml, arg2_ocaml, arg3_ocaml, arg4_ocaml);

    assert_python3();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *arg2 = pyunwrap(arg2_ocaml);
    PyObject *arg3 = pyunwrap(arg3_ocaml);
    int arg4 = Int_val(arg4_ocaml);
    PyObject *result = Python3_PyImport_ImportModuleLevelObject(arg0, arg1, arg2, arg3, arg4);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python3_PyInstanceMethod_New_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_python3();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python3_PyInstanceMethod_New(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python3_PyUnicode_AsEncodedString_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_python3();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    char *arg1 = String_val(arg1_ocaml);
    char *arg2 = String_val(arg2_ocaml);
    PyObject *result = Python3_PyUnicode_AsEncodedString(arg0, arg1, arg2);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python3_PyUnicode_AsUTF8String_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_python3();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python3_PyUnicode_AsUTF8String(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python3_PyUnicode_AsUTF16String_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_python3();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python3_PyUnicode_AsUTF16String(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python3_PyUnicode_AsUTF32String_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_python3();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *result = Python3_PyUnicode_AsUTF32String(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python3_PyUnicode_DecodeUTF8_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_python3();
    char *arg0 = String_val(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    char *arg2 = Is_block(arg2_ocaml) ? String_val(Field(arg2_ocaml, 0)) : NULL;
    PyObject *result = Python3_PyUnicode_DecodeUTF8(arg0, arg1, arg2);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python3_PyUnicode_DecodeUTF16_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml, value arg3_ocaml)
{
    CAMLparam4(arg0_ocaml, arg1_ocaml, arg2_ocaml, arg3_ocaml);

    assert_python3();
    char *arg0 = String_val(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    char *arg2 = Is_block(arg2_ocaml) ? String_val(Field(arg2_ocaml, 0)) : NULL;
    int arg3 = pyunwrap_intref(arg3_ocaml);
    PyObject *result = Python3_PyUnicode_DecodeUTF16(arg0, arg1, arg2, &arg3);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python3_PyUnicode_DecodeUTF32_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml, value arg3_ocaml)
{
    CAMLparam4(arg0_ocaml, arg1_ocaml, arg2_ocaml, arg3_ocaml);

    assert_python3();
    char *arg0 = String_val(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    char *arg2 = Is_block(arg2_ocaml) ? String_val(Field(arg2_ocaml, 0)) : NULL;
    int arg3 = pyunwrap_intref(arg3_ocaml);
    PyObject *result = Python3_PyUnicode_DecodeUTF32(arg0, arg1, arg2, &arg3);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python3_PyUnicode_Format_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_python3();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    PyObject *arg1 = pyunwrap(arg1_ocaml);
    PyObject *result = Python3_PyUnicode_Format(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python3_PyUnicode_FromString_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_python3();
    char *arg0 = String_val(arg0_ocaml);
    PyObject *result = Python3_PyUnicode_FromString(arg0);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python3_PyUnicode_FromStringAndSize_wrapper(value arg0_ocaml, value arg1_ocaml)
{
    CAMLparam2(arg0_ocaml, arg1_ocaml);

    assert_python3();
    char *arg0 = String_val(arg0_ocaml);
    Py_ssize_t arg1 = Int_val(arg1_ocaml);
    PyObject *result = Python3_PyUnicode_FromStringAndSize(arg0, arg1);
    CAMLreturn(pywrap(result, true));
}

CAMLprim value
Python3_PyUnicode_GetLength_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_python3();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    Py_ssize_t result = Python3_PyUnicode_GetLength(arg0);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python3_PyUnicode_GetSize_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_python3();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    int result = Python3_PyUnicode_GetSize(arg0);
    CAMLreturn(Val_int(result));
}

CAMLprim value
Python3_PyUnicode_FromKindAndData_wrapper(value arg0_ocaml, value arg1_ocaml, value arg2_ocaml)
{
    CAMLparam3(arg0_ocaml, arg1_ocaml, arg2_ocaml);

    assert_python3();
    int arg0 = Int_val(arg0_ocaml);
    int32_t *arg1 = pyunwrap_ucs4(arg1_ocaml);
    Py_ssize_t arg2 = Int_val(arg2_ocaml);
    PyObject *result = Python3_PyUnicode_FromKindAndData(arg0, arg1, arg2);
    free(arg1);
    CAMLreturn(pywrap(result, false));
}

CAMLprim value
Python3_PyUnicode_AsUCS4Copy_wrapper(value arg0_ocaml)
{
    CAMLparam1(arg0_ocaml);

    assert_python3();
    PyObject *arg0 = pyunwrap(arg0_ocaml);
    int32_t *result = Python3_PyUnicode_AsUCS4Copy(arg0);
    CAMLreturn(pywrap_ucs4_option_and_free(result));
}
