#!/bin/sh
# $Id: make-src-dist-std.sh,v 1.6 2002/04/02 09:40:12 wagner Exp $

if [ -n "$ROOT" -a -d "$ROOT" ] ; then
  sysinfo="$ROOT/scripts/sysinfo.sh"
else
  root=`pwd`
  while [ -n "$root" -a ! -f "$root/scripts/sysinfo.sh" ] ; do
    root=`dirname $root`
  done
  sysinfo="$root/scripts/sysinfo.sh"
  if [ ! -f "$sysinfo" ] ; then
    echo "scripts/sysinfo.sh not found" 1>&2
    exit 1
  fi
  export root
fi
. "$sysinfo"
. "$ROOT/scripts/pkginfo.sh"
. "$ROOT/scripts/pkgcmds.sh"

STAGE="${STAGE:-${TMPDIR}}"
[ -d "${STAGE}" ] || mkdir "${STAGE}" || mkdir -p "${STAGE}" || exit 1
ARCHIVE="${STAGE}/cm3-src-std-${CM3VERSION}.tgz"
header "building CM3 source distribution in ${ARCHIVE}"

#-----------------------------------------------------------------------------
# build the source distribution archive
#
CM3_ALL=yes
. "$ROOT/scripts/def-std-pkgs.sh"

PKGS=`pkgpath ${P}`
#echo ${P}
#echo ${PKGS}
cd "${ROOT}" || exit 1
/bin/ls -1d COPYRIGHT-CMASS COPYRIGHT-DEC scripts ${PKGS} > .tar-include
/bin/ls -1d compat.quake >> .tar-include
/bin/ls -1d m3-*/*/${TARGET} > .tar-exclude
/bin/ls -1d m3-*/*/${TARGET}p >> .tar-exclude
echo "building exclude list..."
find . \( -name '*~' -or -name '*.bak' -or -name '*.orig' -or \
          -name '*.rej'  -or -name 'cvs-nq-up' -or -name '*-diffs' -or \
          -name 'PkgDep' -or -name 'PkgKind' -or -name '.bok' -or \
          -name '*.o' -or -name '*.a' -or -name '*.dll' -or -name '*.obj' -or \
          -name '.errors' -or -name '*.io' -or -name '*.mo' -or \
          -name '*.so' -or -name '*.so.[0-9]*' -or -name '.M3WEB' -or \
          -name '.M3SHIP' -or -name '.M3IMPTAB' -or -name '.M3EXPORTS' -or \
          \( -name 'CVS' -a -type d \) \) -print | \
  sed -e 's;^./;;' >> .tar-exclude

TARGETS=`cd ${ROOT}/m3-sys/cm3/src/config; echo *`

for p in ${PKGS}; do
  for t in ${TARGETS}; do
    echo ${p}/${t} >> .tar-exclude
  done
done

echo "archiving..."
export GZIP="-9 -v"
${TAR} -czf ${ARCHIVE} --files-from .tar-include --exclude-from .tar-exclude \
 || exit 1
ls -l ${ARCHIVE}
echo "done"
exit 0

