MODULE JunoBundle;
(* Generated by m3bundle; see its manpage. *)

IMPORT Bundle, BundleRep, Text;
IMPORT Thread, Wr, TextWr;

TYPE T = Bundle.T OBJECT OVERRIDES
           get      := LookUp;
           getNames := GetNames;
         END;

TYPE Texts = REF ARRAY OF TEXT;

VAR
  bundle: T     := NIL;
  names : Texts := NIL;

PROCEDURE Get(): Bundle.T =
  BEGIN
    IF (bundle = NIL) THEN bundle := NEW (T) END;
    RETURN bundle;
  END Get;

PROCEDURE GetNames (<*UNUSED*> self: T): Texts = 
  BEGIN
    IF names = NIL THEN
      names := NEW (Texts, NUMBER (Names));
      names^ := Names;
    END;
    RETURN names;
  END GetNames;

PROCEDURE LookUp (<*UNUSED*> self: T;  element: TEXT): TEXT = 
  BEGIN
    FOR i := 0 TO LAST (Names)-1 DO
      IF Text.Equal (Names[i], element) THEN
        IF Elements[i] = NIL THEN Elements[i] := GetElt (i) END;
        RETURN Elements[i];
      END;
    END;
    RETURN NIL;
  END LookUp;

CONST Names = ARRAY [0..79] OF TEXT {
  "SavePS.fv",
  "Geometry.juno",
  "TypeLinesR.juno",
  "Proj3D.juno",
  "Toolbox.fv",
  "C.juno",
  "Square.juno",
  "showerror.ps",
  "Math.juno",
  "CompaqLogo.ppm",
  "Bundled.modlist",
  "R3.juno",
  "LoadFile.fv",
  "Dash.juno",
  "Type.juno",
  "PieChart.juno",
  "Macros.fv",
  "Bezier.juno",
  "Show.juno",
  "FoldAsAnim.fv",
  "Line.juno",
  "Unparse.juno",
  "PtLabel.juno",
  "AboutBox.fv",
  "Circle.juno",
  "TextList.juno",
  "FontData.pkl",
  "Outline.juno",
  "Juno2Logo.ppm",
  "Anim.juno",
  "Rect.juno",
  "SaveConfirm.fv",
  "Ellipse.juno",
  "TypeLinesL.juno",
  "Print.juno",
  "Juno.fv",
  "BuiltIn.juno",
  "Slider.juno",
  "prologue.ps",
  "List.juno",
  "Xform2.juno",
  "R2.juno",
  "LoadModule.fv",
  "Curve.juno",
  "Triangle.juno",
  "Pen.juno",
  "UpArrow.pbm",
  "Arrow.juno",
  "Shadow.juno",
  "Fold.fv",
  "JunoUI.juno",
  "Unit.juno",
  "PS.juno",
  "Editor2.fv",
  "CharSet.juno",
  "Text.juno",
  "DefaultConfig.sx",
  "Offset.juno",
  "Grow.pbm",
  "Angle.juno",
  "Random.juno",
  "SaveFile.fv",
  "DiGraph.juno",
  "TypeLinesC.juno",
  "Plot.juno",
  "Startup.fv",
  "BST.juno",
  "ShowLine.juno",
  "SaveChanges.fv",
  "LineSkip.juno",
  "VPrint.juno",
  "PtLoc.juno",
  "Configure.fv",
  "Color.juno",
  "Time.juno",
  "Path.juno",
  "MenuArrow.pbm",
  "Arc.juno",
  "Rel.juno",
  NIL
};

VAR Elements := ARRAY [0..79] OF TEXT {
  E0,
  NIL (* E1 .. E1_1 *),
  NIL (* E2 .. E2_1 *),
  E3,
  E4,
  E5,
  E6,
  E7,
  E8,
  NIL (* E9 .. E9_3 *),
  E10,
  NIL (* E11 .. E11_0 *),
  E12,
  NIL (* E13 .. E13_3 *),
  E14,
  NIL (* E15 .. E15_1 *),
  NIL (* E16 .. E16_0 *),
  NIL (* E17 .. E17_2 *),
  E18,
  E19,
  E20,
  NIL (* E21 .. E21_0 *),
  NIL (* E22 .. E22_1 *),
  E23,
  NIL (* E24 .. E24_0 *),
  E25,
  NIL (* E26 .. E26_37 *),
  NIL (* E27 .. E27_2 *),
  NIL (* E28 .. E28_34 *),
  NIL (* E29 .. E29_2 *),
  NIL (* E30 .. E30_3 *),
  E31,
  NIL (* E32 .. E32_0 *),
  NIL (* E33 .. E33_1 *),
  E34,
  NIL (* E35 .. E35_1 *),
  NIL (* E36 .. E36_0 *),
  NIL (* E37 .. E37_3 *),
  NIL (* E38 .. E38_1 *),
  NIL (* E39 .. E39_0 *),
  NIL (* E40 .. E40_0 *),
  NIL (* E41 .. E41_0 *),
  E42,
  NIL (* E43 .. E43_4 *),
  E44,
  NIL (* E45 .. E45_1 *),
  E46,
  NIL (* E47 .. E47_1 *),
  NIL (* E48 .. E48_0 *),
  E49,
  E50,
  E51,
  NIL (* E52 .. E52_6 *),
  E53,
  NIL (* E54 .. E54_0 *),
  E55,
  E56,
  E57,
  E58,
  E59,
  E60,
  E61,
  NIL (* E62 .. E62_1 *),
  NIL (* E63 .. E63_1 *),
  NIL (* E64 .. E64_3 *),
  E65,
  NIL (* E66 .. E66_0 *),
  E67,
  E68,
  E69,
  NIL (* E70 .. E70_2 *),
  E71,
  E72,
  NIL (* E73 .. E73_0 *),
  E74,
  NIL (* E75 .. E75_2 *),
  E76,
  NIL (* E77 .. E77_0 *),
  NIL (* E78 .. E78_0 *),
  NIL
};

PROCEDURE GetElt (n: INTEGER): TEXT =
  <*FATAL Thread.Alerted, Wr.Failure *>
  VAR wr := TextWr.New ();
  BEGIN
    CASE n OF
    | 1 =>
        Wr.PutText (wr, E1);
        Wr.PutText (wr, E1_0);
        Wr.PutText (wr, E1_1);
    | 2 =>
        Wr.PutText (wr, E2);
        Wr.PutText (wr, E2_0);
        Wr.PutText (wr, E2_1);
    | 9 =>
        Wr.PutText (wr, E9);
        Wr.PutText (wr, E9_0);
        Wr.PutText (wr, E9_1);
        Wr.PutText (wr, E9_2);
        Wr.PutText (wr, E9_3);
    | 11 =>
        Wr.PutText (wr, E11);
        Wr.PutText (wr, E11_0);
    | 13 =>
        Wr.PutText (wr, E13);
        Wr.PutText (wr, E13_0);
        Wr.PutText (wr, E13_1);
        Wr.PutText (wr, E13_2);
        Wr.PutText (wr, E13_3);
    | 15 =>
        Wr.PutText (wr, E15);
        Wr.PutText (wr, E15_0);
        Wr.PutText (wr, E15_1);
    | 16 =>
        Wr.PutText (wr, E16);
        Wr.PutText (wr, E16_0);
    | 17 =>
        Wr.PutText (wr, E17);
        Wr.PutText (wr, E17_0);
        Wr.PutText (wr, E17_1);
        Wr.PutText (wr, E17_2);
    | 21 =>
        Wr.PutText (wr, E21);
        Wr.PutText (wr, E21_0);
    | 22 =>
        Wr.PutText (wr, E22);
        Wr.PutText (wr, E22_0);
        Wr.PutText (wr, E22_1);
    | 24 =>
        Wr.PutText (wr, E24);
        Wr.PutText (wr, E24_0);
    | 26 =>
        Wr.PutText (wr, E26);
        Wr.PutText (wr, E26_0);
        Wr.PutText (wr, E26_1);
        Wr.PutText (wr, E26_2);
        Wr.PutText (wr, E26_3);
        Wr.PutText (wr, E26_4);
        Wr.PutText (wr, E26_5);
        Wr.PutText (wr, E26_6);
        Wr.PutText (wr, E26_7);
        Wr.PutText (wr, E26_8);
        Wr.PutText (wr, E26_9);
        Wr.PutText (wr, E26_10);
        Wr.PutText (wr, E26_11);
        Wr.PutText (wr, E26_12);
        Wr.PutText (wr, E26_13);
        Wr.PutText (wr, E26_14);
        Wr.PutText (wr, E26_15);
        Wr.PutText (wr, E26_16);
        Wr.PutText (wr, E26_17);
        Wr.PutText (wr, E26_18);
        Wr.PutText (wr, E26_19);
        Wr.PutText (wr, E26_20);
        Wr.PutText (wr, E26_21);
        Wr.PutText (wr, E26_22);
        Wr.PutText (wr, E26_23);
        Wr.PutText (wr, E26_24);
        Wr.PutText (wr, E26_25);
        Wr.PutText (wr, E26_26);
        Wr.PutText (wr, E26_27);
        Wr.PutText (wr, E26_28);
        Wr.PutText (wr, E26_29);
        Wr.PutText (wr, E26_30);
        Wr.PutText (wr, E26_31);
        Wr.PutText (wr, E26_32);
        Wr.PutText (wr, E26_33);
        Wr.PutText (wr, E26_34);
        Wr.PutText (wr, E26_35);
        Wr.PutText (wr, E26_36);
        Wr.PutText (wr, E26_37);
    | 27 =>
        Wr.PutText (wr, E27);
        Wr.PutText (wr, E27_0);
        Wr.PutText (wr, E27_1);
        Wr.PutText (wr, E27_2);
    | 28 =>
        Wr.PutText (wr, E28);
        Wr.PutText (wr, E28_0);
        Wr.PutText (wr, E28_1);
        Wr.PutText (wr, E28_2);
        Wr.PutText (wr, E28_3);
        Wr.PutText (wr, E28_4);
        Wr.PutText (wr, E28_5);
        Wr.PutText (wr, E28_6);
        Wr.PutText (wr, E28_7);
        Wr.PutText (wr, E28_8);
        Wr.PutText (wr, E28_9);
        Wr.PutText (wr, E28_10);
        Wr.PutText (wr, E28_11);
        Wr.PutText (wr, E28_12);
        Wr.PutText (wr, E28_13);
        Wr.PutText (wr, E28_14);
        Wr.PutText (wr, E28_15);
        Wr.PutText (wr, E28_16);
        Wr.PutText (wr, E28_17);
        Wr.PutText (wr, E28_18);
        Wr.PutText (wr, E28_19);
        Wr.PutText (wr, E28_20);
        Wr.PutText (wr, E28_21);
        Wr.PutText (wr, E28_22);
        Wr.PutText (wr, E28_23);
        Wr.PutText (wr, E28_24);
        Wr.PutText (wr, E28_25);
        Wr.PutText (wr, E28_26);
        Wr.PutText (wr, E28_27);
        Wr.PutText (wr, E28_28);
        Wr.PutText (wr, E28_29);
        Wr.PutText (wr, E28_30);
        Wr.PutText (wr, E28_31);
        Wr.PutText (wr, E28_32);
        Wr.PutText (wr, E28_33);
        Wr.PutText (wr, E28_34);
    | 29 =>
        Wr.PutText (wr, E29);
        Wr.PutText (wr, E29_0);
        Wr.PutText (wr, E29_1);
        Wr.PutText (wr, E29_2);
    | 30 =>
        Wr.PutText (wr, E30);
        Wr.PutText (wr, E30_0);
        Wr.PutText (wr, E30_1);
        Wr.PutText (wr, E30_2);
        Wr.PutText (wr, E30_3);
    | 32 =>
        Wr.PutText (wr, E32);
        Wr.PutText (wr, E32_0);
    | 33 =>
        Wr.PutText (wr, E33);
        Wr.PutText (wr, E33_0);
        Wr.PutText (wr, E33_1);
    | 35 =>
        Wr.PutText (wr, E35);
        Wr.PutText (wr, E35_0);
        Wr.PutText (wr, E35_1);
    | 36 =>
        Wr.PutText (wr, E36);
        Wr.PutText (wr, E36_0);
    | 37 =>
        Wr.PutText (wr, E37);
        Wr.PutText (wr, E37_0);
        Wr.PutText (wr, E37_1);
        Wr.PutText (wr, E37_2);
        Wr.PutText (wr, E37_3);
    | 38 =>
        Wr.PutText (wr, E38);
        Wr.PutText (wr, E38_0);
        Wr.PutText (wr, E38_1);
    | 39 =>
        Wr.PutText (wr, E39);
        Wr.PutText (wr, E39_0);
    | 40 =>
        Wr.PutText (wr, E40);
        Wr.PutText (wr, E40_0);
    | 41 =>
        Wr.PutText (wr, E41);
        Wr.PutText (wr, E41_0);
    | 43 =>
        Wr.PutText (wr, E43);
        Wr.PutText (wr, E43_0);
        Wr.PutText (wr, E43_1);
        Wr.PutText (wr, E43_2);
        Wr.PutText (wr, E43_3);
        Wr.PutText (wr, E43_4);
    | 45 =>
        Wr.PutText (wr, E45);
        Wr.PutText (wr, E45_0);
        Wr.PutText (wr, E45_1);
    | 47 =>
        Wr.PutText (wr, E47);
        Wr.PutText (wr, E47_0);
        Wr.PutText (wr, E47_1);
    | 48 =>
        Wr.PutText (wr, E48);
        Wr.PutText (wr, E48_0);
    | 52 =>
        Wr.PutText (wr, E52);
        Wr.PutText (wr, E52_0);
        Wr.PutText (wr, E52_1);
        Wr.PutText (wr, E52_2);
        Wr.PutText (wr, E52_3);
        Wr.PutText (wr, E52_4);
        Wr.PutText (wr, E52_5);
        Wr.PutText (wr, E52_6);
    | 54 =>
        Wr.PutText (wr, E54);
        Wr.PutText (wr, E54_0);
    | 62 =>
        Wr.PutText (wr, E62);
        Wr.PutText (wr, E62_0);
        Wr.PutText (wr, E62_1);
    | 63 =>
        Wr.PutText (wr, E63);
        Wr.PutText (wr, E63_0);
        Wr.PutText (wr, E63_1);
    | 64 =>
        Wr.PutText (wr, E64);
        Wr.PutText (wr, E64_0);
        Wr.PutText (wr, E64_1);
        Wr.PutText (wr, E64_2);
        Wr.PutText (wr, E64_3);
    | 66 =>
        Wr.PutText (wr, E66);
        Wr.PutText (wr, E66_0);
    | 70 =>
        Wr.PutText (wr, E70);
        Wr.PutText (wr, E70_0);
        Wr.PutText (wr, E70_1);
        Wr.PutText (wr, E70_2);
    | 73 =>
        Wr.PutText (wr, E73);
        Wr.PutText (wr, E73_0);
    | 75 =>
        Wr.PutText (wr, E75);
        Wr.PutText (wr, E75_0);
        Wr.PutText (wr, E75_1);
        Wr.PutText (wr, E75_2);
    | 77 =>
        Wr.PutText (wr, E77);
        Wr.PutText (wr, E77_0);
    | 78 =>
        Wr.PutText (wr, E78);
        Wr.PutText (wr, E78_0);
    ELSE (*skip*)
    END;
    RETURN TextWr.ToText (wr);
  END GetElt;

CONST E0 = 
   "; Copyright (C) 1992, Digital Equipment Corporation                    "
 & "     \n; All rights reserved.                                          "
 & "            \n; See the file COPYRIGHT for a full description.         "
 & "                   \n;                                                 "
 & "                          \n; Last modified on Thu May 26 17:01:53 PDT "
 & "1994 by heydon                   \n\n(Rim (Pen 5)\n  (Macro Gap () \'(G"
 & "lue 5))\n  (BrowserShape\n    (VBox (MyBrowserFont)\n      (DirMenu (Fo"
 & "r savePSBrowser))\n      (Gap)\n      (Border\n        (FileBrowser %sa"
 & "vePSBrowser\n          (BgColor \"White\")\n          (Suffixes \".ps\""
 & ")\n        )\n      )\n      (Gap)\n      (HBox\n        \"File:\"\n   "
 & "     (Glue 2)\n        (Frame Lowered\n          (Helper FirstFocus (Bg"
 & "Color \"White\") (For savePSBrowser))\n        )\n      )\n    )\n  )\n"
 & ")\n";

CONST E1 = 
   "MODULE Geometry;\n\n(* Geometric predicates and functions. *)\n\nIMPORT"
 & " Math, R2;\n\nPRED Equal(a, b) IS a = b END;\n\nUI PointTool(Equal);\n\n"
 & "(* The points \"a\" and \"b\" are the same. *)\n\nFUNC p = Mid(a, b) IS"
 & " \n  p = R2.Times(0.5, R2.Plus(a, b)) \nEND;\n\nUI PointTool(Mid);\n\n("
 & "* \"p\" is the midpoint of the segment \n   \"(a, b)\". *)\n\nPRED Coli"
 & "near(a, b, c) IS \n  (a, b) PARA (a, c) \nEND;\n\nUI PointTool(Colinear"
 & ");\n\n(* The points \"a\", \"b\", and \"c\" are \n   colinear. *)\n\nFU"
 & "NC p = HorVer(h, v) IS \n  (E hx, hy, vx, vy :: \n    h = (hx, hy) AND "
 & "\n    v = (vx, vy) AND \n    p = (vx, hy)) \nEND;\n\nUI PointTool(HorVe"
 & "r);\n\n(* \"p\" is the intersection point of the \n   horizontal line t"
 & "hrough \"h\" and the \n   vertical line through \"v\". *)\n\nFUNC d2 = "
 & "Dist2(p, q) IS \n  d2 = R2.Length2(R2.Minus(p, q)) \nEND;\n\n(* \"d2\" "
 & "is the square of the distance \n   between the points \"p\" and \"q\". "
 & "*)\n\nFUNC d = Dist(p, q) IS \n  d = R2.Length(R2.Minus(p, q)) \nEND;\n"
 & "\n(* \"d\" is the distance between the points \n   \"p\" and \"q\". *)\n"
 & "\nFUNC d2 = DistX2(p, q) IS \n  (E px, py, qx, qy, dx :: \n    p = (px,"
 & " py) AND \n    q = (qx, qy) AND \n    dx = px - qx AND \n    d2 = dx * "
 & "dx) \nEND;\n\n(* \"d\" is the square of the distance \n   between the p"
 & "rojections of the points \n   \"p\" and \"q\" onto the X axis. *)\n\nFU"
 & "NC d = DistX(p, q) IS \n  d = Math.Sqrt(DistX2(p, q)) \nEND;\n\n(* \"d\""
 & " is the distance between the \n   projections of the points \"p\" and \""
 & "q\" \n   onto the X axis. *)\n\nFUNC d2 = DistY2(p, q) IS \n  (E px, py"
 & ", qx, qy, dy :: \n    p = (px, py) AND \n    q = (qx, qy) AND \n    dy "
 & "= py - qy AND \n    d2 = dy * dy) \nEND;\n\n(* \"d2\" is the square of "
 & "the distance \n   between the projections of the points \n   \"p\" and "
 & "\"q\" onto the Y axis. *)\n\nFUNC d = DistY(p, q) IS \n  d = Math.Sqrt("
 & "DistY2(p, q)) \nEND;\n\n(* \"d\" is the distance between the \n   proje"
 & "ctions of the points \"p\" and \"q\" \n   onto the Y axis. *)\n\nFUNC l"
 & "en2 = SegLength2(s) IS \n  (E p, q :: \n    s = (p, q) AND len2 = Dist2"
 & "(p, q)) \nEND;\n\n(* \"len2\" is the square of the length of \n   the s"
 & "egment \"s\", where \"s\" is a ";

CONST E1_0 = 
   "pair \n   of points \"(p, q)\". *)\n\nFUNC len = SegLength(s) IS \n  (E"
 & " p, q :: \n    s = (p, q) AND len = Dist(p, q)) \nEND;\n\n(* \"len\" is"
 & " the length of the segment \n   \"s\", where \"s\" is a pair of points "
 & "\n   \"(p, q)\". *)\n\nPRED CongX(a, b, c, d) IS \n  (E ax, ay, bx, by,"
 & " cx, cy, dx, dy, s1x, \n     s2x :: \n    a = (ax, ay) AND \n    b = (b"
 & "x, by) AND \n    c = (cx, cy) AND \n    d = (dx, dy) AND \n    s1x = ax"
 & " - bx AND \n    s2x = cx - dx AND \n    s1x * s1x = s2x * s2x) \nEND;\n"
 & "\nUI PointTool(CongX);\n\n(* The projections of the segments \"ab\" \n "
 & "  and \"cd\" onto the X axis are \n   congruent. *)\n\nPRED CongY(a, b,"
 & " c, d) IS \n  (E ax, ay, bx, by, cx, cy, dx, dy, s1y, \n     s2y :: \n "
 & "   a = (ax, ay) AND \n    b = (bx, by) AND \n    c = (cx, cy) AND \n   "
 & " d = (dx, dy) AND \n    s1y = ay - by AND \n    s2y = cy - dy AND \n   "
 & " s1y * s1y = s2y * s2y) \nEND;\n\nUI PointTool(CongY);\n\n(* The projec"
 & "tions of the segments \"ab\" \n   and \"cd\" onto the Y axis are \n   c"
 & "ongruent. *)\n\nPRED CongXY(a, b, c, d) IS \n  (E ax, ay, bx, by, cx, c"
 & "y, dx, dy, s1x, \n     s2y :: \n    a = (ax, ay) AND \n    b = (bx, by)"
 & " AND \n    c = (cx, cy) AND \n    d = (dx, dy) AND \n    s1x = ax - bx "
 & "AND \n    s2y = cy - dy AND \n    s1x * s1x = s2y * s2y) \nEND;\n\nUI P"
 & "ointTool(CongXY);\n\n(* The projection of the segment \"ab\" \n   onto "
 & "the X axis is congruent to the \n   projection of the segment \"cd\" on"
 & "to \n   the Y axis. *)\n\nPRED VerSym(a, b, p) IS \n  (E x, ay, by, px,"
 & " py :: \n    a = (x, ay) AND \n    b = (x, by) AND \n    p = (px, py) A"
 & "ND \n    by - py = py - ay) \nEND;\n\nUI PointTool(VerSym);\n\n(* The p"
 & "oints \"a\" and \"b\" are vertically \n   symmetric about the horizonta"
 & "l line \n   through the point \"p\". *)\n\nPRED HorSym(a, b, p) IS \n  "
 & "(E ax, bx, y, px, py :: \n    a = (ax, y) AND \n    b = (bx, y) AND \n "
 & "   p = (px, py) AND \n    bx - px = px - ax) \nEND;\n\nUI PointTool(Hor"
 & "Sym);\n\n(* The points \"a\" and \"b\" are \n   horizontally symmetric "
 & "about the \n   vertical line through the point \"p\". *)\n\nPRED LineSy"
 & "m(a, b, p, q) IS \n  (a, p) CONG (p, b) AND \n  (a, q) CONG (q, b) \nEN"
 & "D;";

CONST E1_1 = 
   "\n\nUI PointTool(LineSym);\n\n(* The points \"a\" and \"b\" are symmetr"
 & "ic \n   about the line through the points \"p\" \n   and \"q\". *)\n\n";

CONST E2 = 
   "MODULE TypeLinesR;\n\n(* The procedures in this module \n   type a righ"
 & "t-justified block of \n   text lines relative to a \n   specified point"
 & ". Each procedure \n   takes a reference point and a \n   single text, w"
 & "hich is converted \n   to a list of texts by the \n   \"TextList.FromTe"
 & "xt\" procedure. \n   One line is displayed in the \n   block per elemen"
 & "t of this list. \n\n   The lines in each block are \n   separated verti"
 & "cally by the \n   height of the current font plus \n   the current line"
 & " skip value \n   (maintained by the \"LineSkip\" \n   module). \n\n   T"
 & "he text block is actually \n   translated in the appropriate \n   direc"
 & "tion away from the \n   reference point by the current \n   horizontal "
 & "and/or vertical \n   offset values (maintained by the \n   \"Offset\" m"
 & "odule). For example, \n   the \"South\" procedure translates \n   the t"
 & "ext block up by the current \n   vertical offset, and the \"NE\" \n   p"
 & "rocedure translates it down by \n   the current vertical offset and \n "
 & "  to the left by the current \n   horizontal offset. The \"Center\" \n "
 & "  procedure ignores the current \n   offset values. *)\n\nIMPORT LineSk"
 & "ip, Offset, PS, \n       R2, TextList, Type;\n\nPRIVATE PROC TypeBlockR"
 & "(p, l) IS \n  VAR asc, dec, d IN \n    asc, dec := PS.FontHeight(); \n "
 & "   d := asc + dec + LineSkip.Get(); \n    p := (CAR(p), CDR(p) - asc); "
 & "\n    DO \n      l # NIL -> \n        Type.R(p, CAR(l)); \n        p :="
 & " (CAR(p), CDR(p) - d); \n        l := CDR(l) \n    OD \n  END \nEND;\n\n"
 & "/* Type the right-justified block \n   of text lines \"l\" such that \""
 & "p\" \n   is the northwest corner of the \n   box\'s bounding-box. */\n\n"
 & "PROC North(p, txt) IS \n  VAR l, w, h, dh IN \n    l := TextList.FromTe"
 & "xt(txt); \n    w, h := TextList.Size(l); \n    dh := Offset.GetVer(); \n"
 & "    TypeBlockR(R2.Plus(p, \n                       (w / 2, -dh)), \n   "
 & "            l) \n  END \nEND;\n\nPROC South(p, txt) IS \n  VAR l, w, h,"
 & " dh IN \n    l := TextList.FromText(txt); \n    w, h := TextList.Size(l"
 & "); \n    dh := Offset.GetVer(); \n    TypeBlockR(R2.Plus(p, \n         "
 & "              (w / 2, \n        ";

CONST E2_0 = 
   "                h + dh)), l) \n  END \nEND;\n\nPROC East(p, txt) IS \n "
 & " VAR l, w, h, dw IN \n    l := TextList.FromText(txt); \n    w, h := Te"
 & "xtList.Size(l); \n    dw := Offset.GetHor(); \n    TypeBlockR(R2.Plus(p"
 & ", \n                       (-dw, h / 2)), \n               l) \n  END \n"
 & "END;\n\nPROC West(p, txt) IS \n  VAR l, w, h, dw IN \n    l := TextList"
 & ".FromText(txt); \n    w, h := TextList.Size(l); \n    dw := Offset.GetH"
 & "or(); \n    TypeBlockR(R2.Plus(p, \n                       (w + dw, \n "
 & "                       h / 2)), l) \n  END \nEND;\n\nPROC Center(p, txt"
 & ") IS \n  VAR l, w, h IN \n    l := TextList.FromText(txt); \n    w, h :"
 & "= TextList.Size(l); \n    TypeBlockR(R2.Plus(p, \n                     "
 & "  (w / 2, \n                        h / 2)), l) \n  END \nEND;\n\nPROC "
 & "NW(p, txt) IS \n  VAR l, w, h, dw, dh IN \n    l := TextList.FromText(t"
 & "xt); \n    w, h := TextList.Size(l); \n    dw, dh := Offset.GetHorVer()"
 & "; \n    TypeBlockR(R2.Plus(p, \n                       (w + dw, -dh)), "
 & "\n               l) \n  END \nEND;\n\nPROC NE(p, txt) IS \n  VAR l, dw,"
 & " dh IN \n    l := TextList.FromText(txt); \n    dw, dh := Offset.GetHor"
 & "Ver(); \n    TypeBlockR(R2.Plus(p, (-dw, -dh)), \n               l) \n "
 & " END \nEND;\n\nPROC SE(p, txt) IS \n  VAR l, w, h, dw, dh IN \n    l :="
 & " TextList.FromText(txt); \n    w, h := TextList.Size(l); \n    dw, dh :"
 & "= Offset.GetHorVer(); \n    TypeBlockR(R2.Plus(p, \n                   "
 & "    (-dw, h + dh)), \n               l) \n  END \nEND;\n\nPROC SW(p, tx"
 & "t) IS \n  VAR l, w, h, dw, dh IN \n    l := TextList.FromText(txt); \n "
 & "   w, h := TextList.Size(l); \n    dw, dh := Offset.GetHorVer(); \n    "
 & "TypeBlockR(R2.Plus(p, \n                       (w + dw, \n             "
 & "           h + dh)), l) \n  END \nEND;\n\nUI TextTool(North);\n\nUI Tex"
 & "tTool(South);\n\nUI TextTool(East);\n\nUI TextTool(West);\n\nUI TextToo"
 & "l(Center);\n\nUI TextTool(NW);\n\nUI TextTool(NE);\n\nUI TextTool(SE);\n"
 & "\nUI TextTool(SW);\n\n(* Display the \"\\\"-separated texts \n   in \"t"
 & "\" as a right-justified \n   block such that \"p\" is at the \n   locat"
 & "ion of the block\'s bounding \n   box named by ";

CONST E2_1 = 
   "the procedure. *)\n\n";

CONST E3 = 
   "MODULE Proj3D;\n\n(* A module that computes perspective projections in "
 & "\n   3-space. *)\n\nIMPORT R2, R3;\n\n(* This procedure provides a sing"
 & "le function, \"Project\", for \n   mapping points in 3-space to points "
 & "in 2-space according \n   to a simple perspective projection. \n\n   Th"
 & "e \"Project\" function is parameterized by the point in \n   3-space to"
 & " project, the location of the camera, and a \n   point in 2-space to wh"
 & "ich the 3-space origin should be \n   mapped. In this model, the camera"
 & "\'s viewing direction is \n   the one that causes it to point at the 3-"
 & "space origin, \n   and the view plane is taken to be a fixed distance f"
 & "rom \n   the camera orthogonal to the viewing direction. The \"up\" \n "
 & "  direction of the camera is the direction of the z-axis; \n   hence, t"
 & "his mapping is undefined when the camera is \n   located on the z-axis."
 & " *)\n\nPRIVATE CONST PlaneDist = 100, Scale = 10;\n\nPRIVATE FUNC \n  Q"
 & " = ProjectToPlane(P, camDir, camLoc, viewP0) IS \n  (E lineDir = R3.Min"
 & "us(P, camLoc), \n     denom = R3.Dot(camDir, lineDir), \n     Num = R3."
 & "Dot(camDir, R3.Minus(camLoc, viewP0)), \n     t = -(Num / denom) :: \n "
 & "   Q = R3.Plus(camLoc, R3.Times(t, lineDir))) \nEND;\n\nFUNC q = Projec"
 & "t(Q, org, camLoc) IS \n  (E camDist = R3.Length(camLoc), \n     camDir "
 & "= R3.Times(1 / camDist, camLoc), \n     viewP0 = R3.Times(camDist - Pla"
 & "neDist, camDir), \n     zPt = ProjectToPlane([0, 0, 1], camDir, camLoc,"
 & " viewP0), \n     upVec = R3.Normalize(R3.Minus(zPt, viewP0)), \n     xV"
 & "ec = R3.Normalize(R3.Cross(upVec, camDir)), qx, qy, \n     Q1 = Project"
 & "ToPlane(Q, camDir, camLoc, viewP0), \n     vec = R3.Minus(Q1, viewP0) :"
 & ": \n    q = R2.Plus(org, (qx, qy)) AND \n    qx = Scale * R3.Dot(xVec, "
 & "vec) AND \n    qy = Scale * R3.Dot(upVec, vec)) \nEND;\n\n(* \"q\" is t"
 & "he perspective projection of the point \"Q\" in \n   3-space. \"org\" i"
 & "s the point in 2-space to which the point \n   \"[0,0,0]\" is mapped. \""
 & "camLoc\" is the location of the \n   camera in 3-space. *)\n\n";

CONST E4 = 
   "; Copyright (C) 1992, Digital Equipment Corporation                    "
 & "     \n; All rights reserved.                                          "
 & "            \n; See the file COPYRIGHT for a full description.         "
 & "                   \n;                                                 "
 & "                          \n; Last modified on Sat May 28 18:13:26 1994"
 & " by heydon                       \n\n(Border (Pen 2)\n (VBox\n  (Insert"
 & " \"Macros.fv\")\n  (MyLabelFont)\n    (Menu \n      (Shape (Height + 0)"
 & " (ButtonLabel (HBox\n        (Text %toolboxName LeftAlign \"\")\n      "
 & "  Fill\n        (FixedWidth (Pixmap \"MenuArrow.pbm\"))\n        (Space"
 & "))))\n      (VBox\n        (MButton %help (TextL \"Help...\"))\n       "
 & " (LinkMButton (For toolboxButtons) (TextL \"Expand\"))\n        (LinkMB"
 & "utton (For noButtons) (TextL \"Collapse\"))\n        (MButton %close (T"
 & "extL \"Close\"))\n    ))\n  (MyRidge)\n  (TSplit Flex (Which toolboxBut"
 & "tons)\n    (Generic %toolboxButtons)\n    (Glue %noButtons 0 + 0 - 0)\n"
 & "  )\n))\n";

CONST E5 = 
   "MODULE C;\n\n(* Defines procedures for complex arithmetic. *)\n\n(* The"
 & " procedures in this module represent a \n   complex number as a pair of"
 & " reals. However, all \n   procedures can accept either reals or pairs o"
 & "f \n   reals as arguments. \n\n   See also: \"R2\". *)\n\nPROC r := Rea"
 & "l(c) IS \n  IF PAIR(c) -> r := CAR(c) | REAL(c) -> r := c FI \nEND;\n\n"
 & "(* Set \"r\" to the real part of the complex number \n   \"c\". This is"
 & " a checked run-time error if \"c\" is \n   not a real number or a pair."
 & " *)\n\nPROC i := Imag(c) IS \n  IF PAIR(c) -> i := CDR(c) FI \nEND;\n\n"
 & "(* Set \"i\" to the imaginary part of the complex \n   number \"c\". Th"
 & "is is a checked run-time error if \n   \"c\" is not a pair. *)\n\nPRIVA"
 & "TE PROC res := ToPair(c) IS \n  IF \n    PAIR(c) -> res := c | REAL(c) "
 & "-> res := (c, 0) \n  FI \nEND;\n\n/* Set \"res\" to the complex represe"
 & "ntation of \"c\", \n   which must be either a real number or a pair. */"
 & "\n\nPROC res := Plus(c1, c2) IS \n  c1 := ToPair(c1); \n  c2 := ToPair("
 & "c2); \n  res := (CAR(c1) + CAR(c2), CDR(c1) + CDR(c2)) \nEND;\n\n(* Set"
 & " \"res\" to the complex sum of \"c1\" and \"c2\". \n*)\n\nPROC res := T"
 & "imes(c1, c2) IS \n  c1 := ToPair(c1); \n  c2 := ToPair(c2); \n  IF \n  "
 & "  VAR a1, b1, a2, b2 IN \n      c1 = (a1, b1) AND c2 = (a2, b2) -> \n  "
 & "      res := \n          (a1 * a2 - b1 * b2, a1 * b2 + b1 * a2) \n    E"
 & "ND \n  FI \nEND;\n\n(* Set \"res\" to the complex product of \"c1\" and"
 & " \n   \"c2\". *)\n\n";

CONST E6 = 
   "MODULE Square;\n\n(* Procedures and predicates for arbitrarily \n   ori"
 & "ented squares. *)\n\nIMPORT Geometry, PS;\n\n(* \\section{Adjacent Corn"
 & "er Representation} *)\n\nPROC Draw(a, b) IS \n  PS.MoveTo(a); \n  PS.Li"
 & "neTo(b); \n  PS.LineTo((1, 1) REL (a, b)); \n  PS.LineTo((0, 1) REL (a,"
 & " b)); \n  PS.Close() \nEND;\n\nUI PointTool(Draw);\n\n(* Append a close"
 & "d square path with edge \"ab\" to \n   the current path. The square is "
 & "constructed \n   to the left of the ray from \"a\" to \"b\". *)\n\nFUNC"
 & " area = Area(a, b) IS \n  area = Geometry.Dist2(a, b) \nEND;\n\n(* \"ar"
 & "ea\" is the area of the square with edge \n   \"ab\". *)\n\n(* \\sectio"
 & "n{Center-Corner Representation} *)\n\nPROC DrawC(c, b) IS \n  PS.MoveTo"
 & "(b); \n  PS.LineTo((0, 1) REL (c, b)); \n  PS.LineTo((-1, 0) REL (c, b)"
 & "); \n  PS.LineTo((0, -1) REL (c, b)); \n  PS.Close() \nEND;\n\nUI Point"
 & "Tool(DrawC);\n\n(* Append a closed square path with center \"c\" \n   a"
 & "nd corner vertex \"b\" to the current path. *)\n\nFUNC area = AreaC(c, "
 & "b) IS \n  area = 2 * Geometry.Dist2(c, b) \nEND;\n\n(* \"area\" is the "
 & "area of the square with center \n   \"c\" and corner vertex \"b\". *)\n"
 & "\n";

CONST E7 = 
   "\n% -------------------------------------------------------------------"
 & "----------\n% Inserted file: juno-app/src/rsrc/showerror.ps\n% Last mod"
 & "ified on Tue Dec 20 15:27:20 PST 1994 by heydon\n\n% PostScript code re"
 & "ad in to display a run-time error message in PostScript\n% output. This"
 & " code assumes that PostScript code has already been executed\n% that de"
 & "fines the identifier \"str\" as the error message string, and\n% \"xCen"
 & "ter\" and \"yCenter\" as the x- and y-coordinates of the center of\n% t"
 & "he page.\n\n% define font height and border width\n/fontheight 14 def\n"
 & "/border 8 def\n\n% drawbox\n%\n% Draw a white-filled box with size \"wi"
 & "dth\" x \"fontheight\" (plus an extra\n% strip of width \"border\" all "
 & "the way around) centered about the current\n% point. This procedure ass"
 & "umes that \"width\" has been defined.\n/drawbox {\n  /bwidth width bord"
 & "er 2 mul add def\n  /bheight fontheight border 2 mul add def\n  bwidth "
 & "2 div neg bheight 2 div neg rmoveto\n  bwidth 0 rlineto\n  0 bheight rl"
 & "ineto\n  bwidth neg 0 rlineto\n  closepath\n  gsave 1 setgray fill gres"
 & "tore\n  0 setgray 2 setlinewidth stroke\n} def\n\n% boxshow: str => <em"
 & "pty>\n%\n% Show the string \"str\" inside a white-filled box centered a"
 & "bout the current\n% point.\n/boxshow {\n  dup stringwidth pop /width ex"
 & "ch def % get length of string\n  gsave drawbox grestore              % "
 & "draw box first\n  width 2 div neg                     % delta X\n  font"
 & "height 2 div neg                % delta Y\n  rmoveto                   "
 & "          % move left/down by 1/2 str width/height\n  1 0 0 setrgbcolor"
 & " show              % show string in red\n} def\n\n% select Helvetica-Bo"
 & "ld 14 pt\n/Helvetica-Bold findfont\nfontheight scalefont\nsetfont\n\n% "
 & "show the string\nxCenter\nyCenter 11 72 mul 4 div sub\nmoveto\nstr boxs"
 & "how\n\n% end showerror.ps\n% ------------------------------------------"
 & "-----------------------------------\n";

CONST E8 = 
   "MODULE Math;\n\n(* Common math functions *)\n\nCONST \n  Pi = ATAN(0, -"
 & "1), \n  ToDegrees = 180 / Pi, \n  ToRadians = Pi / 180, \n  Exp = EXP(1"
 & "), \n  Phi = (1 + Sqrt(5))/2;\n\n(* \"Exp\" is the value \"e\", or the "
 & "\n   base of natural logarithms. \n   \"Phi\" is the golden ratio. *)\n"
 & "\nFUNC z = Pow(x, y) IS \n  z = EXP(y * LN(x)) \nEND;\n\n(* \"z\" is \""
 & "x\" raised to the \"y\" \n   power. *)\n\nFUNC y = LogBase(x, base) IS "
 & "\n  y * LN(base) = LN(x) \nEND;\n\n(* \"y\" is the logarithm base \"bas"
 & "e\" \n   of \"x\". *)\n\nFUNC y = Log(x) IS \n  y = LogBase(x, 10) \nEN"
 & "D;\n\n(* \"y\" is the logarithm base 10 of \n   \"x\". *)\n\nFUNC y = S"
 & "qrt(x) IS \n  y ~ 1000 AND y * y = x \nEND;\n\n(* \"y\" is the positive"
 & " square root \n   of \"x\". This version may fail \n   for large values"
 & " of \"x\" (in \n   excess of 1e10). *)\n\nFUNC y = Sqrt2(x) IS \n  y = "
 & "Pow(x, 0.5) \nEND;\n\n(* \"y\" is the positive square root \n   of \"x\""
 & ". This version is quite \n   fast and does not use the \n   constraint "
 & "solver, but it fails \n   when \"x = 0\". *)\n\nFUNC y = Abs(x) IS \n  "
 & "y = Sqrt(x * x) \nEND;\n\n(* \"y\" is the absolute value of \n   \"x\"."
 & " *)\n\nFUNC y = Sin(x) IS y = SIN(x) END;\n\nFUNC y = Cos(x) IS y = COS"
 & "(x) END;\n\nFUNC y = Tan(x) IS \n  y = SIN(x) / COS(x) \nEND;\n\n(* \"y"
 & "\" is the sine, cosine, and \n   tangent, respectively, of \"x\" \n   r"
 & "adians. *)\n\nFUNC y = SinD(x) IS \n  y = SIN(ToRadians * x) \nEND;\n\n"
 & "FUNC y = CosD(x) IS \n  y = COS(ToRadians * x) \nEND;\n\nFUNC y = TanD("
 & "x) IS \n  (E deg :: \n    deg = ToRadians * x AND \n    y = SIN(deg) / "
 & "COS(deg)) \nEND;\n\n(* \"y\" is the sine, cosine, and \n   tangent, res"
 & "pectively, of \"x\" \n   degrees. *)\n\n";

CONST E9 = 
   "P6\n# CREATOR: XV Version 3.10a  Rev: 12/29/94\n128 24\n255\n\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\316\316\316\347\234\234\347\234\234\347\234\234\347c\234\347cc\347cc\347"
 & "cc\347cc\347c\234\347\234\234\347c\234\347cc\347c\234\265\265\265\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\265\265\265\347\316\234\347c\234"
 & "\347cc\347cc\316c1\316\030c\347cc\347c\234\347\234\234\336\336\336\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\336\336\336\347\234\234\347\234\234\347\234\234\347c\234\347\234\234"
 & "\347\234\234\316\316\316\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\347\234\234"
 & "\347\234\234\347c\234\347\234\234\347\234\234\347\234\234\265\265\265\336"
 & "\336\336\377\377\377\377\265\316\347\234\234\347\234\234\347\234\234\347"
 & "\234\234\347\234\234\347\234\234\265\265\265\347\234\234\265\265\265\347"
 & "\234\234\265\265\265\347\234\234\265\265\265\336\336\336\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\336\336\336\347\234\234\347c\234\347cc\347\234\234"
 & "\347c\234\347cc\347\234\234\336\336\336\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\347\234\234\347\234"
 & "\234\347cc\275\003\013\316c1\275\003\013\316\000\000\275\003\013\316\000"
 & "\000\275\003\013\316\030c\347c\234\347\316\234\367\367\336\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\265\265\265\316\030c\316\000\000\275\003\013\316\000"
 & "\000\275\003\013\316\000\000\275\003\013\275\003\013\275\003\013\275\003"
 & "\013\316\000\000\275\003\013\316\000\000\275\003\013\275\003\013\347\234"
 & "\234\377\377\377\316\316\316\316c1\316\030c\316\000\000\275\003\013\316"
 & "\000\000\275\003\013\275\003\013\316\000\000\275\003\013\316\000\000\275"
 & "\003\013\316\000\000\316\000\000\316\030c\347cc\367\367\336\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\347cc\316\000\000\275\003\013\316\000"
 & "\000\275\003\013\316\000\000\275\003\013\316\000\000\316c1\336\336\336\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\265\265\265\316"
 & "\030c\316\000\000\275\003\013\316\000\000\275\003\013\316\000\000\275\003"
 & "\013\316c1\367\367\336\377\377\377\347\234\234\275\003\013\316\000\000\275"
 & "\003\013\316\000\000\275\003\013\316\000\000\275\003\013\275\003\013\275"
 & "\003\013\275\003\013\275\003\013\275\003\013\275\003\013\316c1\347\234\234"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\336\336\336\347cc\275\003\013\316\000\000\275\003\013\275\003\013\316\000"
 & "\000\275\003\013\275\003\013\275\003\013\367\367\336\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\265\265\265\316\030c\316\000\000"
 & "\275\003\013\275\003\013\316\000\000\275\003\013\316\000\000\275\003\013"
 & "\316\000\000\275\003\013\316\000\000\316c1\316\000\000\275\003\013\275\003"
 & "\013\347\234\234\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\347\234\234\316c1\316\000\000\275\003\013\316"
 & "\000\000\275\003\013\275\003\013\316\000\000\275\003\013\316\000\000\275"
 & "\003\013\316\000\000\275\003\013\316\000\000\275\003\013\316\000\000\316"
 & "\030c\377\377\377\336\336\336\316c1\316\030c\316\000\000\275\003\013\275"
 & "\003\013\275\003\013\316\000\000\275\003\013\275\003\013\275\003\013\316"
 & "\000\000\275\003\013\275\003\013\275\003\013\316\000\000\275\003\013\316"
 & "\030c\377\377\377\377\377\377\377\377\377\265\265\265\275\003\013\275\003"
 & "\013\316\000\000\275\003\013\316\000\000\275\003\013\316\000\000\275\003"
 & "\013\316\030c\316c1\377\377\377\377\377\377\377\377\377\377\377\377\347"
 & "\234\234\316\030c\316\000\000\275\003\013\316\000\000\275\003\013\316\000"
 & "\000\275\003\013\316\000\000\347cc\377\377\377\377\377\377\275\003\013\275"
 & "\003\013\316\000\000\275\003\013\275\003\013\275\003\013\275\003\013\316"
 & "\000\000\275\003\013\316\000\000\316\000\000\275\003\013\316\000\000\275"
 & "\003\013\316\000\000\275\003\013\347\234\234\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\316c1\275\003\013\316\000\000\275\003\013"
 & "\316\000\000\275\003\013\316\000\000\275\003\013\316\000\000\316\030c\367"
 & "\367\336\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\275"
 & "\003\013\275\003\013\275\003\013\316\000\000\275\003\013\316\000\000\275"
 & "\003\013\316\000\000\275\003\013\275\003\013\316\000\000\275\003\013\316"
 & "\000\000\275\003\013\316\000\000\275\003\013\275\003\013\347\234\234\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\336\336\336\275"
 & "\003\013\275\003\013\316\000\000\275\003\013\275\003\013\275\003\013\316"
 & "\000\000\275\003\013\316\000\000\275\003\013\316\000\000\275\003\013\316"
 & "\000\000\275\003\013\316\000\000\275\003\013\265\265\265\377\377\377\347"
 & "cc\316\000\000\275\003\013\316\000\000\275\003\013\316\000\000\275\003\013"
 & "\316\000\000\275\003\013\316\000\000\275\003\013\316\000\000\275\003\013"
 & "\316\000\000\275\003\013\316\000\000\275\003\013\316\000\000\347\234\234"
 & "\377\377\377\377\377\377\347\234\234\316\000\000\275\003\013\275\003\013"
 & "\316\000\000\275\003\013\275\003\013\316\000\000\275\003\013\316\000\000"
 & "\316\030c\336\336\336\377\377\377\377\377\377\336\336\336\275\003\013\275"
 & "\003\013\316\000\000\275\003\013\275\003\013\275\003\013\316\000\000\275"
 & "\003\013\275\003\013\265\265\265\377\377\377\377\265\316\275\003\013\275"
 & "\003\013\275\003\013\316\000\000\275\003\013\316\000\000\275\003\013\275"
 & "\003\013\316c1\275\003\013\275\003\013\316\000\000\275\003\013\316\000\000"
 & "\275\003\013\316\000\000\316\030c\336\336\336\377\377\377\377\377\377\377"
 & "\377\377\347\234\234\275\003\013\275\003\013\275\003\013\316\000\000\275"
 & "\003\013\316\000\000\275\003\013\316\000\000\275\003\013\316c1\316\316\316"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\347cc\275\003\013\316\000"
 & "\000\316\000\000\275\003\013\275\003\013\275\003\013\275\003\013\275\003"
 & "\013\275\003\013\316c1\275\003\013\275\003\013\275\003\013\275\003\013\275"
 & "\003\013\316\030c\316\000\000\316c1\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\347cc\275\003\013\316\000\000\275\003\013\316\000"
 & "\000\275\003\013\316\000\000\275\003\013\275\003\013\275\003\013\275\003"
 & "\013\275\003\013\275\003\013\275\003\013\316c1\275\003\013\275\003\013\347"
 & "\234\234\265\265\265\316\000\000\275\003\013\316\000\000\275\003\013\316"
 & "\000\000\275\003\013\347cc\336\336\336\347\234\234\265\265\265\347\234\234"
 & "\347c\234\316\000\000\275\003\013\316\000\000\275\003\013\316\000\000\275"
 & "\003\013\347cc\377\377\377\377\377\377\316c1\316\030c\275\003\013\316\000"
 & "\000\275\003\013\275\003\013\316\000\000\275\003\013\275\003\013\316\000"
 & "\000\275\003\013\347\234\234\377\377\377\336\336\336\316c1\316\030c\316"
 & "\000\000\275\003\013\275\003\013\316\000\000\275\003\013\275\003\013\316"
 & "\000\000\275\003\013\367\367\336\377\377\377\347\234\234\275\003\013\316"
 & "\000\000\275\003\013\316\000\000\275\003\013\347cc\377\265\316\347\234\234"
 & "\377\265\316\377\265\316\377\265\316\275\003\013\275\003\013\275\003\013"
 & "\316\000\000\275\003\013\316\000\000\347\316\234\377\377\377\377\377\377"
 & "\316\316\316\316\030c\316\000\000\275\003\013\316\000\000\275\003\013\275"
 & "\003\013\275\003\013\316\000\000\275\003\013\316\000\000\275\003\013\336"
 & "\336\336\377\377\377\377\377\377\377\377\377\265\265\265\275\003\013\316"
 & "\000\000\275\003\013\275\003\013\275\003\013\316\000\000\347\234\234\377"
 & "\265\316\316\316\316\316\316\316\347c\234\347\234\234\275\003\013\275\003"
 & "\013\316\000\000\275\003\013\316\000\000\316\000\000\316\030c\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\265\265\265\275\003\013\316\000\000"
 & "\275\003\013\275\003\013\275\003";

CONST E9_0 = 
   "\013\316\000\000\347cc\265\265\265\347\316\234\265\265\265\377\265\316\265"
 & "\265\265\377\265\316\265\265\265\316\316\316\265\265\265\367\367\336\377"
 & "\377\377\347cc\275\003\013\275\003\013\275\003\013\316\000\000\275\003\013"
 & "\347cc\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\336\336"
 & "\336\347cc\316\000\000\275\003\013\275\003\013\275\003\013\316\000\000\347"
 & "\234\234\377\377\377\377\265\316\316\030c\316\000\000\316\000\000\275\003"
 & "\013\316\000\000\316\000\000\275\003\013\275\003\013\316\000\000\275\003"
 & "\013\316\000\000\377\265\316\377\377\377\347\234\234\316\000\000\316\000"
 & "\000\275\003\013\275\003\013\316\000\000\275\003\013\316\000\000\316\000"
 & "\000\275\003\013\347cc\377\377\377\377\377\377\316c1\316\000\000\275\003"
 & "\013\275\003\013\275\003\013\316\000\000\265\265\265\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\347c\234\316\000\000\316\000\000"
 & "\275\003\013\275\003\013\275\003\013\265\265\265\377\377\377\377\377\377"
 & "\347cc\316\000\000\275\003\013\316\000\000\275\003\013\347cc\347cc\316\000"
 & "\000\275\003\013\275\003\013\275\003\013\275\003\013\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\347cc\275\003\013\275\003\013\275\003\013\316"
 & "\000\000\316\000\000\347cc\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\347c\234\316\000\000\275\003\013\316\000\000\275"
 & "\003\013\316\030c\347cc\336\336\336\377\377\377\377\377\377\377\377\377"
 & "\347\234\234\316\000\000\275\003\013\316\000\000\275\003\013\316\000\000"
 & "\275\003\013\347\234\234\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\265\265\265\275\003\013\316\000\000\316\000\000\275\003\013\275\003\013"
 & "\275\003\013\265\265\265\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\336\336\336\316\030c\316\000\000\275\003\013\316\000\000\275"
 & "\003\013\275\003\013\347\234\234\377\377\377\347\234\234\316\000\000\275"
 & "\003\013\275\003\013\275\003\013\275\003\013\275\003\013\275\003\013\316"
 & "\000\000\275\003\013\316\000\000\275\003\013\347\234\234\265\265\265\275"
 & "\003\013\316\030c\275\003\013\275\003\013\275\003\013\275\003\013\275\003"
 & "\013\275\003\013\275\003\013\316\000\000\347\234\234\377\377\377\336\336"
 & "\336\316\030c\275\003\013\316\000\000\316\000\000\275\003\013\275\003\013"
 & "\367\367\336\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\347\234\234\275\003\013\275\003\013\316\000\000\275\003\013\275\003\013"
 & "\367\367\336\377\377\377\265\265\265\275\003\013\316\000\000\275\003\013"
 & "\275\003\013\316\000\000\347\234\234\347\234\234\275\003\013\316\000\000"
 & "\275\003\013\316\000\000\316\030c\377\265\316\377\377\377\377\377\377\336"
 & "\336\336\316\030c\316\000\000\275\003\013\316\000\000\275\003\013\275\003"
 & "\013\316\316\316\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\347cc\275\003\013\316\000\000\275\003\013\316\000\000\275"
 & "\003\013\347cc\377\377\377\377\377\377\377\377\377\377\377\377\347cc\275"
 & "\003\013\316\000\000\275\003\013\316\000\000\275\003\013\347\234\234\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\347\234\234\316"
 & "\000\000\275\003\013\275\003\013\316\000\000\316\000\000\316\030c\367\367"
 & "\336\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\265"
 & "\316\316\000\000\316\030c\316\000\000\275\003\013\316\000\000\316\000\000"
 & "\265\265\265\377\377\377\347cc\316\000\000\316\000\000\275\003\013\316\000"
 & "\000\316\000\000\347\234\234\347cc\316\030c\275\003\013\275\003\013\316"
 & "\000\000\347cc\275\003\013\275\003\013\316\000\000\275\003\013\347c\234"
 & "\316c1\275\003\013\316\000\000\316\000\000\275\003\013\275\003\013\377\265"
 & "\316\377\377\377\347\234\234\275\003\013\316\000\000\275\003\013\275\003"
 & "\013\316\000\000\347cc\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\336\336\336\347cc\316\000\000\275\003\013\275\003\013\316\000\000"
 & "\347cc\377\377\377\377\377\377\347cc\316\000\000\275\003\013\316\000\000"
 & "\275\003\013\275\003\013\377\377\377\347\234\234\275\003\013\275\003\013"
 & "\316\000\000\275\003\013\316c1\316\316\316\377\377\377\377\377\377\347\234"
 & "\234\316\000\000\275\003\013\316\000\000\275\003\013\275\003\013\275\003"
 & "\013\336\336\336\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\347cc\316\000\000\275\003\013\316\000\000\275\003\013\316"
 & "\000\000\347\234\234\377\377\377\377\377\377\377\377\377\336\336\336\275"
 & "\003\013\316\000\000\275\003\013\275\003\013\275\003\013\275\003\013\336"
 & "\336\336\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\347"
 & "cc\275\003\013\275\003\013\316\000\000\275\003\013\275\003\013\347cc\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\347"
 & "\234\234\275\003\013\316\000\000\275\003\013\275\003\013\275\003\013\275"
 & "\003\013\377\265\316\377\377\377\316\030c\316c1\275\003\013\275\003\013"
 & "\275\003\013\275\003\013\377\377\377\347cc\316\000\000\275\003\013\316\000"
 & "\000\275\003\013\275\003\013\275\003\013\275\003\013\316\000\000\347\234"
 & "\234\336\336\336\275\003\013\316\000\000\275\003\013\275\003\013\275\003"
 & "\013\347cc\377\377\377\377\377\377\316c1\316\000\000\275\003\013\275\003"
 & "\013\275\003\013\316\000\000\347c\234\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\347\316\234\275\003\013\316\000\000\275\003\013"
 & "\316\000\000\275\003\013\347cc\377\377\377\347\234\234\275\003\013\316\000"
 & "\000\275\003\013\316\000\000\275\003\013\347\234\234\377\377\377\347\234"
 & "\234\275\003\013\316\000\000\275\003\013\316\000\000\275\003\013\367\367"
 & "\336\377\377\377\377\377\377\347cc\275\003\013\275\003\013\316\000\000\275"
 & "\003\013\316\000\000\347cc\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\265\265\265\316c1\275\003\013\316\000\000\275\003"
 & "\013\275\003\013\275\003\013\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\347\234\234\275\003\013\275\003\013\275\003\013\316\000\000\316\000"
 & "\000\347cc\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\265"
 & "\265\265\275\003\013\316\000\000\275\003\013\316\000\000\275\003\013\316"
 & "\000\000\377\265\316\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\347c\234\316\000\000\275\003\013\316\000\000\275\003"
 & "\013\316\000\000\347cc\377\377\377\265\265\265\316c1\316\000\000\316\000"
 & "\000\275\003\013\316\000\000\347cc\377\377\377\347\234\234\275\003\013\316"
 & "\000\000\275\003\013\275\003\013\316\000\000\275\003\013\316\000\000\347"
 & "cc\377\377\377\347\234\234\275\003\013\275\003\013\275\003\013\316\000\000"
 & "\316\000\000\347\234\234\377\377\377\377\265\316\316\030c\275\003\013\316"
 & "\000\000\316\000\000\275\003\013\275\003\013\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\336\336\336\316\030c\316\000\000\275\003"
 & "\013\316\000\000\275\003\013\275\003\013\347\316\234\336\336\336\275\003"
 & "\013\316\000\000\275\003\013\275\003\013\275\003\013\347cc\367\367\336\377"
 & "\377\377\347c\234\316\000\000\275\003\013\316\000\000\275\003\013\316c1"
 & "\336\336\336\377\377\377\336\336\336\347cc\316\000\000\275\003\013\275\003"
 & "\013\316\000\000\275\003\013\316\316\316\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\347\234\234\275\003\013\316\000"
 & "\000\275\003\013\316\000\000\316c1\316\030c\367\367\336\377\377\377\377"
 & "\377\377\377\377\377\347cc\316\000\000\316\000\000\275\003\013\275\003\013"
 & "\275\003\013\347\234\234\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\347c\234\316\000\000\275\003\013\275\003\013\275\003\013\316"
 & "\000\000\275\003\013\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\336\336\336\347cc\316";

CONST E9_1 = 
   "\000\000\275\003\013\275\003\013\316\000\000\275\003\013\347\234\234\377"
 & "\377\377\347c\234\316\000\000\275\003\013\275\003\013\316\000\000\316\030"
 & "c\347\234\234\377\377\377\265\265\265\275\003\013\316\000\000\316\000\000"
 & "\275\003\013\316\000\000\316\030c\275\003\013\377\377\377\377\377\377\347"
 & "c\234\316\000\000\275\003\013\316\000\000\275\003\013\275\003\013\347\234"
 & "\234\377\377\377\347\234\234\316\000\000\316\030c\275\003\013\316\000\000"
 & "\275\003\013\316\030c\367\367\336\377\377\377\367\367\336\377\377\377\316"
 & "\316\316\347cc\275\003\013\275\003\013\316\000\000\275\003\013\316\000\000"
 & "\347cc\377\377\377\347cc\275\003\013\316\000\000\275\003\013\316\000\000"
 & "\316\000\000\265\265\265\377\377\377\377\377\377\347\234\234\275\003\013"
 & "\275\003\013\275\003\013\275\003\013\275\003\013\367\367\336\377\377\377"
 & "\347\234\234\316\000\000\275\003\013\316\000\000\275\003\013\275\003\013"
 & "\275\003\013\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\347c\234\275\003\013\316\000\000\275\003\013\275"
 & "\003\013\316\000\000\347cc\377\377\377\377\377\377\377\377\377\377\265\316"
 & "\316c1\275\003\013\316\000\000\275\003\013\316\000\000\316c1\265\265\265"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\347cc\275\003"
 & "\013\316\000\000\316\000\000\275\003\013\275\003\013\347cc\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\265\265\265\275"
 & "\003\013\275\003\013\275\003\013\316\000\000\316c1\275\003\013\377\265\316"
 & "\377\377\377\347cc\275\003\013\316\000\000\275\003\013\316\030c\316\000"
 & "\000\377\377\377\377\377\377\367\367\336\275\003\013\275\003\013\275\003"
 & "\013\316\000\000\275\003\013\275\003\013\347\316\234\377\377\377\377\377"
 & "\377\275\003\013\275\003\013\316\000\000\275\003\013\316\000\000\275\003"
 & "\013\377\377\377\377\377\377\347cc\275\003\013\275\003\013\316\000\000\275"
 & "\003\013\316\000\000\316c1\316\030c\316c1\316\030c\316c1\275\003\013\275"
 & "\003\013\316\000\000\316\000\000\275\003\013\316\000\000\275\003\013\265"
 & "\265\265\377\265\316\316\000\000\275\003\013\316\000\000\275\003\013\275"
 & "\003\013\347\234\234\377\377\377\377\377\377\377\377\377\347\234\234\316"
 & "\000\000\275\003\013\316\000\000\275\003\013\275\003\013\336\336\336\377"
 & "\377\377\347c\234\316\000\000\275\003\013\275\003\013\316\000\000\316\000"
 & "\000\347cc\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\347cc\316\000\000\275\003\013\316\000\000\275\003\013"
 & "\275\003\013\265\265\265\377\377\377\377\377\377\377\377\377\265\265\265"
 & "\316\030c\316\000\000\275\003\013\316\000\000\275\003\013\316\030c\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\347\234\234\275\003"
 & "\013\316\000\000\275\003\013\275\003\013\275\003\013\316\000\000\265\265"
 & "\265\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\347\234\234\316\000\000\275\003\013\316\000\000\316\030c\316\000\000"
 & "\347cc\377\377\377\336\336\336\275\003\013\316\000\000\275\003\013\275\003"
 & "\013\316\000\000\347cc\377\377\377\377\377\377\336\336\336\316c1\275\003"
 & "\013\316\000\000\275\003\013\275\003\013\347\234\234\377\377\377\377\377"
 & "\377\347\234\234\316\000\000\275\003\013\316\000\000\275\003\013\275\003"
 & "\013\347cc\377\377\377\336\336\336\316\030c\316c1\316\000\000\275\003\013"
 & "\275\003\013\316\000\000\275\003\013\316\000\000\316\030c\316\000\000\275"
 & "\003\013\275\003\013\316\000\000\275\003\013\275\003\013\316\030c\275\003"
 & "\013\347\234\234\377\377\377\275\003\013\275\003\013\316\000\000\275\003"
 & "\013\316\000\000\275\003\013\265\265\265\377\265\316\377\377\377\377\265"
 & "\316\347\234\234\275\003\013\316\000\000\275\003\013\316\000\000\275\003"
 & "\013\367\367\336\377\377\377\316c1\316\000\000\316\030c\316\000\000\275"
 & "\003\013\275\003\013\347\234\234\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\347\234\234\275\003\013\316\000\000\275"
 & "\003\013\275\003\013\275\003\013\275\003\013\367\367\336\377\377\377\377"
 & "\377\377\377\377\377\347cc\275\003\013\316\000\000\275\003\013\275\003\013"
 & "\275\003\013\347\234\234\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\347\234\234\275\003\013\275\003\013\275\003\013\316\000\000"
 & "\275\003\013\275\003\013\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\316\030c\316\000\000\275\003\013\275"
 & "\003\013\316\000\000\275\003\013\347c\234\377\377\377\347\234\234\316\000"
 & "\000\275\003\013\275\003\013\316\000\000\275\003\013\347c\234\377\377\377"
 & "\377\377\377\377\377\377\316\030c\316\000\000\275\003\013\316\000\000\347"
 & "\234\234\377\377\377\377\377\377\377\377\377\347\234\234\275\003\013\275"
 & "\003\013\275\003\013\316\000\000\316\000\000\265\265\265\377\377\377\265"
 & "\265\265\316c1\316\000\000\275\003\013\316\000\000\275\003\013\275\003\013"
 & "\275\003\013\275\003\013\316\000\000\275\003\013\316\000\000\275\003\013"
 & "\316\000\000\275\003\013\316\000\000\316\000\000\347c\234\377\377\377\347"
 & "\234\234\316\000\000\275\003\013\275\003\013\275\003\013\316\000\000\275"
 & "\003\013\275\003\013\347cc\316c1\316\030c\275\003\013\316\000\000\275\003"
 & "\013\316\000\000\275\003\013\316c1\265\265\265\377\265\316\316\030c\275"
 & "\003\013\316\000\000\275\003\013\316\000\000\275\003\013\377\265\316\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\336\336\336\347"
 & "cc\316\000\000\275\003\013\316\000\000\275\003\013\316\000\000\347cc\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\316c1\316\000\000\275\003\013"
 & "\316\000\000\316\000\000\275\003\013\347\234\234\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\316c1\316\000\000\316\000\000\275\003"
 & "\013\316\000\000\275\003\013\347cc\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\347\316\234\275\003\013\275\003\013\316"
 & "\000\000\275\003\013\275\003\013\275\003\013\347\234\234\377\377\377\347"
 & "cc\275\003\013\316\000\000\275\003\013\316\000\000\275\003\013\347\316\234"
 & "\377\377\377\377\377\377\377\377\377\347cc\275\003\013\316\000\000\347c"
 & "c\377\377\377\377\377\377\377\377\377\336\336\336\347cc\316\000\000\316"
 & "\000\000\275\003\013\275\003\013\275\003\013\377\377\377\377\377\377\347"
 & "c\234\316\000\000\275\003\013\275\003\013\275\003\013\316\000\000\275\003"
 & "\013\316\000\000\275\003\013\275\003\013\316\000\000\275\003\013\316\000"
 & "\000\275\003\013\275\003\013\347cc\347\234\234\377\377\377\336\336\336\275"
 & "\003\013\275\003\013\316\000\000\316\000\000\275\003\013\275\003\013\275"
 & "\003\013\316\000\000\275\003\013\316\000\000\275\003\013\316\000\000\275"
 & "\003\013\275\003\013\275\003\013\275\003\013\316\030c\367\367\336\377\265"
 & "\316\316\000\000\275\003\013\275\003\013\316\000\000\275\003\013\347cc\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\275\003\013\275\003\013\316\000\000\275\003\013\316\030c\316\000"
 & "\000\347\234\234\377\377\377\377\377\377\377\377\377\377\377\377\275\003"
 & "\013\275\003\013\316\000\000\275\003\013\275\003\013\316\000\000\347\234"
 & "\234\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\347cc\275"
 & "\003\013\316\030c\275\003\013\275\003\013\316\000\000\347\234\234\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\347c\234"
 & "\275\003\013\316\000\000\275\003\013\275\003\013\316\000\000\316\030c\377"
 & "\377\377\377\377\377\275\003\013\275\003\013\275\003\013\316\000\000\316"
 & "\030c\316c1\377\377\377\377\377\377\377\377\377\377\377\377\347\234\234"
 & "\275\003\013\316\030c\336\336\336\377\377\377\377\377\377\377\377\377\377"
 & "\265\316\275\003\013\275\003\013\275\003\013";

CONST E9_2 = 
   "\275\003\013\316\000\000\347cc\377\377\377\377\377\377\347cc\275\003\013"
 & "\316\000\000\316\000\000\275\003\013\316\000\000\347\234\234\265\265\265"
 & "\316\316\316\377\265\316\265\265\265\377\265\316\377\265\316\377\265\316"
 & "\347\234\234\377\377\377\377\377\377\377\377\377\347cc\316\000\000\275\003"
 & "\013\275\003\013\275\003\013\316\000\000\275\003\013\316\000\000\275\003"
 & "\013\316\000\000\275\003\013\316\000\000\275\003\013\316\000\000\275\003"
 & "\013\316\000\000\316\000\000\275\003\013\367\367\336\347\234\234\275\003"
 & "\013\316\000\000\275\003\013\275\003\013\275\003\013\316\030c\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\347\234\234"
 & "\275\003\013\316\000\000\275\003\013\275\003\013\316\000\000\275\003\013"
 & "\336\336\336\377\377\377\377\377\377\377\377\377\377\377\377\316\000\000"
 & "\316\000\000\275\003\013\275\003\013\316\000\000\275\003\013\316\030c\347"
 & "\234\234\367\367\336\336\336\336\377\377\377\336\336\336\377\377\377\347"
 & "\234\234\265\265\265\347c\234\265\265\265\377\377\377\347cc\275\003\013"
 & "\316\000\000\275\003\013\316\000\000\275\003\013\347c\234\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\275\003\013\275"
 & "\003\013\316\000\000\275\003\013\316\000\000\275\003\013\347\234\234\377"
 & "\377\377\265\265\265\275\003\013\275\003\013\316\000\000\275\003\013\275"
 & "\003\013\347c\234\377\377\377\377\377\377\377\377\377\377\377\377\265\265"
 & "\265\316c1\336\336\336\377\377\377\377\377\377\377\377\377\377\377\377\347"
 & "\234\234\275\003\013\275\003\013\316\000\000\316\000\000\275\003\013\347"
 & "\234\234\377\377\377\367\367\336\275\003\013\275\003\013\275\003\013\275"
 & "\003\013\316\000\000\347cc\336\336\336\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\347\234\234\275\003\013\275\003\013\316\000\000\275\003\013"
 & "\316\000\000\275\003\013\347\234\234\347\234\234\347\234\234\347\234\234"
 & "\347\234\234\347\234\234\347cc\316\000\000\275\003\013\316\000\000\275\003"
 & "\013\275\003\013\377\265\316\347\234\234\275\003\013\316\000\000\275\003"
 & "\013\316\000\000\316\000\000\347cc\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\316\316\316\275\003\013\316\000\000\275\003\013\275"
 & "\003\013\316\000\000\275\003\013\347c\234\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\275\003\013\275\003\013\316\000\000\275\003"
 & "\013\316\000\000\275\003\013\316\000\000\275\003\013\275\003\013\316c1\316"
 & "\030c\275\003\013\275\003\013\316c1\275\003\013\316\000\000\347\234\234"
 & "\377\377\377\347cc\316\000\000\275\003\013\316\000\000\275\003\013\316\000"
 & "\000\347cc\347\234\234\316\316\316\316\316\316\377\265\316\265\265\265\275"
 & "\003\013\275\003\013\316\000\000\275\003\013\316\000\000\275\003\013\275"
 & "\003\013\316\316\316\377\377\377\347cc\316\000\000\316\000\000\275\003\013"
 & "\316\000\000\316\000\000\336\336\336\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\336\336\336\347cc\275\003\013\316\000\000\275\003\013\275\003"
 & "\013\275\003\013\336\336\336\377\377\377\347\234\234\275\003\013\316\000"
 & "\000\275\003\013\316\000\000\275\003\013\347cc\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\336\336\336\316\030c\316\000\000\316\000\000\275\003"
 & "\013\275\003\013\275\003\013\377\265\316\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\347\234\234\275\003\013\275\003"
 & "\013\316\000\000\275\003\013\316c1\336\336\336\347\234\234\316\000\000\275"
 & "\003\013\275\003\013\275\003\013\316\030c\275\003\013\316c1\347\234\234"
 & "\347c\234\347\234\234\316\030c\316c1\275\003\013\275\003\013\347cc\275\003"
 & "\013\316\000\000\275\003\013\347cc\347\234\234\347\234\234\347\234\234\265"
 & "\265\265\347\234\234\316\000\000\275\003\013\275\003\013\316\000\000\275"
 & "\003\013\316\000\000\275\003\013\316\000\000\275\003\013\316\000\000\316"
 & "\000\000\275\003\013\316\000\000\275\003\013\316\000\000\275\003\013\377"
 & "\265\316\377\377\377\265\265\265\275\003\013\316\000\000\275\003\013\316"
 & "\000\000\275\003\013\316\000\000\275\003\013\275\003\013\275\003\013\275"
 & "\003\013\275\003\013\316\000\000\275\003\013\275\003\013\316\000\000\275"
 & "\003\013\316\000\000\347cc\377\377\377\377\265\316\275\003\013\275\003\013"
 & "\275\003\013\275\003\013\275\003\013\347cc\336\336\336\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\316c1\275\003\013\316\000\000\275"
 & "\003\013\316\000\000\347cc\377\377\377\377\377\377\316c1\316\030c\316\000"
 & "\000\275\003\013\275\003\013\316\000\000\347\234\234\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\347\234\234\275\003\013\275\003\013\275\003"
 & "\013\316\000\000\275\003\013\316c1\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\265\265\265\316\000\000\275"
 & "\003\013\275\003\013\316\000\000\275\003\013\377\377\377\377\377\377\275"
 & "\003\013\275\003\013\316\000\000\316\000\000\316\000\000\316\030c\316\000"
 & "\000\275\003\013\316\000\000\275\003\013\275\003\013\347c\234\347\234\234"
 & "\347cc\347cc\275\003\013\275\003\013\316\000\000\275\003\013\275\003\013"
 & "\275\003\013\316\000\000\275\003\013\316\000\000\347\234\234\275\003\013"
 & "\316\000\000\316\030c\275\003\013\275\003\013\316\000\000\275\003\013\316"
 & "\000\000\275\003\013\275\003\013\316\000\000\275\003\013\275\003\013\275"
 & "\003\013\347cc\377\377\377\377\377\377\377\265\316\347cc\275\003\013\316"
 & "\000\000\275\003\013\275\003\013\275\003\013\316\000\000\316\000\000\275"
 & "\003\013\316\000\000\275\003\013\316\000\000\275\003\013\316\000\000\275"
 & "\003\013\316\000\000\347cc\377\377\377\377\377\377\347\316\234\316c1\275"
 & "\003\013\316\000\000\275\003\013\316\000\000\347cc\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\347c\234\275\003\013\316\000\000\275"
 & "\003\013\275\003\013\275\003\013\347c\234\377\377\377\377\377\377\316\030"
 & "c\316\000\000\275\003\013\316\000\000\275\003\013\275\003\013\347\234\234"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\336\336\336\275\003\013\316\000\000"
 & "\316\000\000\275\003\013\275\003\013\275\003\013\377\265\316\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\347\234\234\275\003\013\316\000\000\275\003\013\275\003\013\275\003\013"
 & "\347\234\234\377\377\377\347cc\316\000\000\275\003\013\275\003\013\275\003"
 & "\013\316\000\000\275\003\013\316\000\000\275\003\013\347c\234\367\367\336"
 & "\265\265\265\347cc\275\003\013\316\000\000\275\003\013\316\000\000\275\003"
 & "\013\316\000\000\316\000\000\275\003\013\316\000\000\275\003\013\347cc\377"
 & "\377\377\347\234\234\316\000\000\275\003\013\316\000\000\316\000\000\275"
 & "\003\013\316\000\000\275\003\013\275\003\013\316\000\000\275\003\013\316"
 & "\000\000\275\003\013\316\000\000\347\234\234\377\377\377\377\377\377\377"
 & "\377\377\265\265\265\347cc\316\000\000\275\003\013\275\003\013\316\000\000"
 & "\275\003\013\275\003\013\316\000\000\275\003\013\275\003\013\275\003\013"
 & "\316\000\000\275\003\013\275\003\013\347cc\336\336\336\377\377\377\336\336"
 & "\336\347c\234\316\000\000\275\003\013\316\000\000\275\003\013\316\000\000"
 & "\347\234\234\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\316c1\316\000\000\275\003\013\275\003\013\316\000\000\275\003\013\347\316"
 & "\234\377\377\377\265\265\265\316\000\000\275\003\013\316\000\000\275\003"
 & "\013\316\000\000\347cc\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\316"
 & "c1\275\003\013\275\003\013\275\003\013\316\000\000\316\000\000\347c";

CONST E9_3 = 
   "\234\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\347\234\234\316\000\000\275\003\013\316\000"
 & "\000\275\003\013\316c1\316\316\316\377\377\377\377\377\377\347\234\234\275"
 & "\003\013\275\003\013\316\000\000\275\003\013\275\003\013\275\003\013\347"
 & "\316\234\377\377\377\347c\234\316\000\000\275\003\013\316\000\000\275\003"
 & "\013\316\030c\275\003\013\316\000\000\275\003\013\275\003\013\316\000\000"
 & "\275\003\013\316\000\000\347\234\234\377\377\377\377\377\377\377\265\316"
 & "\347cc\347cc\347cc\347cc\275\003\013\347cc\275\003\013\347cc\347cc\347c"
 & "\234\347cc\347cc\367\367\336\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\347\234\234\347cc\347cc\347cc\347cc\275\003\013\347cc\347"
 & "cc\316c1\347cc\347cc\347c\234\367\367\336\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\347\234\234\347\234\234\347\234\234\347\234\234\347\234"
 & "\234\347c\234\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\336\336\336\377\265\316\347\234\234\265\265\265\377\265\316"
 & "\336\336\336\377\377\377\377\377\377\377\265\316\347\234\234\377\265\316"
 & "\265\265\265\347\234\234\377\265\316\336\336\336\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\336\336\336\377\265\316\347\234\234\347\316\234\265\265\265"
 & "\347\234\234\336\336\336\336\336\336\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\265\316\265\265\265\377\265\316\377\265\316\367\367\336\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\367\367\336\347\234\234\347cc\347c"
 & "c\347\234\234\316\316\316\377\377\377\347cc\275\003\013\275\003\013\347"
 & "cc\347cc\347cc\347\234\234\347cc\347c\234\347cc\347cc\347c\234\347cc\347"
 & "c\234\377\265\316\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\265\316\336\336\336\377\377\377\336\336\336\377\377\377\377\377"
 & "\377\377\377\377\367\367\336\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\336\336\336\377\377\377\377\377\377\336\336\336\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\347\234"
 & "\234\316\000\000\347\234\234\336\336\336\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\316\030c\377\265\316\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
 & "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377";

CONST E10 = 
   "% Last modified on Fri Feb  4 11:42:24 PST 2000 by heydon\n\n% This is "
 & "the configuration file for the bundled modules. Each line is\n% the nam"
 & "e of a Juno module; the corresponding file is formed from the\n% module"
 & " name by appending the \".juno\" extension. The modules must be\n% list"
 & "ed in a total order consistent with the partial order incuded by\n% the"
 & " IMPORT relation.\n\n% If a module name is followed by the text \"(buil"
 & "tin)\", the scope formed\n% from that module is used to augment an exis"
 & "ting built-in scope.\n\n% See the file \"juno-src/bundled/README\" for "
 & "a description of each of\n% the bundled modules and their import depend"
 & "encies.\n\n% Level 0\nC.juno\nJunoUI.juno (builtin)\nLineSkip.juno\nLis"
 & "t.juno\nMath.juno\nOffset.juno\nPrint.juno (builtin)\nR3.juno\nRandom.j"
 & "uno (builtin)\nText.juno (builtin)\nTime.juno (builtin)\nUnit.juno (bui"
 & "ltin)\n\n% Level 1\nBST.juno\nColor.juno\nR2.juno\nUnparse.juno\n\n% Le"
 & "vel 2\nGeometry.juno\nProj3D.juno\nPS.juno (builtin)\nRel.juno\nXform2."
 & "juno\n\n% Level 3\nAngle.juno\nAnim.juno\nArrow.juno\nBezier.juno\nCirc"
 & "le.juno\nEllipse.juno\nLine.juno\nPen.juno\nPtLoc.juno\nShadow.juno\nSh"
 & "ow.juno\nSquare.juno\nTextList.juno\nType.juno\nVPrint.juno\n\n% Level "
 & "4\nArc.juno\nCurve.juno\nDash.juno\nPath.juno\nPlot.juno\nPtLabel.juno\n"
 & "Rect.juno\nShowLine.juno\nTriangle.juno\nTypeLinesC.juno\nTypeLinesL.ju"
 & "no\nTypeLinesR.juno\n\n% Level 5\nCharSet.juno\nDiGraph.juno\nOutline.j"
 & "uno\nPieChart.juno\nSlider.juno\n\n% Extras\nEOF\nDijkstra.juno\nFont.j"
 & "uno\nUserFont.juno\n";

CONST E11 = 
   "MODULE R3;\n\n(* Functions on 3D real vectors. *)\n\nCONST Origin = [0,"
 & " 0, 0];\n(* \"Origin\" is the origin in 3-space. *)\n\n(* \\section{Ari"
 & "thmetic Functions} *)\n\nFUNC r = Plus(p, q) IS \n  (E px, py, pz, qx, "
 & "qy, qz :: \n    p = [px, py, pz] AND \n    q = [qx, qy, qz] AND \n    r"
 & " = [px + qx, py + qy, pz + qz]) \nEND;\n\n(* \"r\" is the vector sum \""
 & "p\" + \"q\". *)\n\nFUNC r = Minus(p, q) IS \n  (E px, py, pz, qx, qy, q"
 & "z :: \n    p = [px, py, pz] AND \n    q = [qx, qy, qz] AND \n    r = [p"
 & "x - qx, py - qy, pz - qz]) \nEND;\n\n(* \"r\" is the vector difference "
 & "\"p\" - \n   \"q\". *)\n\nFUNC p = Times(t, q) IS \n  (E qx, qy, qz :: "
 & "\n    q = [qx, qy, qz] AND \n    p = [t * qx, t * qy, t * qz]) \nEND;\n"
 & "\n(* \"p\" is the product of the scalar \"t\" \n   and the vector \"q\""
 & ". *)\n\nFUNC len2 = Length2(v) IS \n  (E vx, vy, vz :: \n    v = [vx, v"
 & "y, vz] AND \n    len2 = \n      (vx * vx) + (vy * vy) + (vz * vz)) \nEN"
 & "D;\n\n(* \"len2\" is the square of the L2 norm \n   of the vector \"v\""
 & ". *)\n\nFUNC len = Length(v) IS \n  len = Math.Sqrt(Length2(v)) \nEND;\n"
 & "\n(* \"len\" is the L2 norm of the vector \n   \"v\", namely, its Eucli"
 & "dean length. *)\n\nFUNC u = Normalize(v) IS\n  Times(Length(v), u) = v\n"
 & "END;\n\n(* \"u\" is the vector \"v\" normalized\n   to have unit length"
 & ". *)\n\nFUNC t = Dot(p, q) IS \n  (E px, py, pz, qx, qy, qz :: \n    p "
 & "= [px, py, pz] AND \n    q = [qx, qy, qz] AND \n    t = \n      (px * q"
 & "x) + (py * qy) + (pz * qz)) \nEND;\n\n(* The scalar \"t\" is the dot-pr"
 & "oduct of \n   \"p\" and \"q\". *)\n\nFUNC r = Cross(p, q) IS \n  (E px,"
 & " py, pz, qx, qy, qz :: \n    p = [px, py, pz] AND \n    q = [qx, qy, qz"
 & "] AND \n    r = \n      [(py * qz) - (qy * pz), \n       (pz * qx) - (q"
 & "z * px), \n       (px * qy) - (qx * py)]) \nEND;\n\n(* \"r\" is the cro"
 & "ss-product of \"p\" and \n   \"q\". *)\n\n(* \\section{Projection Funct"
 & "ions} *)\n\nFUNC x = X(p) IS \n  (E y, z :: p = [x, y, z]) \nEND;\n\n(*"
 & " \"x\" is the x-coordinate of the 3D \n   point \"p\". *)\n\nFUNC y = Y"
 & "(p) IS \n  (E x, z :: p = [x, y, z]) \nEND;\n\n(* \"y\" is the y-coordi"
 & "nate of the 3D \n   point \"p\". *)\n\nFUNC z = Z(p) IS \n  (E x, y :: "
 & "p = [x, y, z]) \nEND;\n\n(*";

CONST E11_0 = 
   " \"z\" is the y-coordinate of the 3D \n   point \"p\". *)\n\nFUNC r = F"
 & "romR2(p) IS \n  (E px, py :: \n    p = (px, py) AND r = [px, py, 0]) \n"
 & "END;\n\n(* Convert the R2 point \"p\" to an R3 \n   point whose \"z\" c"
 & "oordinate is 0. *)\n\nFUNC r = ToR2(p) IS \n  (E px, py, pz :: \n    p "
 & "= [px, py, pz] AND r = (px, py)) \nEND;\n\n(* \"r\" is the R2 projectio"
 & "n of the R3 \n   point \"p\" onto the XY-plane. *)\n\n";

CONST E12 = 
   "; Copyright (C) 1992, Digital Equipment Corporation                    "
 & "     \n; All rights reserved.                                          "
 & "            \n; See the file COPYRIGHT for a full description.         "
 & "                   \n;                                                 "
 & "                          \n; Last modified on Thu May 26 16:59:56 PDT "
 & "1994 by heydon                   \n\n(Rim (Pen 5)\n  (Macro Gap () \'(G"
 & "lue 5))\n  (BrowserShape\n    (VBox (MyBrowserFont)\n      (DirMenu (Fo"
 & "r loadBrowser))\n      (Gap)\n      (Border\n        (FileBrowser %load"
 & "Browser\n          (BgColor \"White\")\n          (Suffixes \".juno\")\n"
 & "        )\n      )\n      (Gap)\n      (HBox\n        \"File:\"\n      "
 & "  (Glue 2)\n        (Frame Lowered\n          (Helper FirstFocus (BgCol"
 & "or \"White\") (For loadBrowser))\n        )\n      )\n    )\n  )\n)\n";

CONST E13 = 
   "MODULE Dash;\n\n(* A module for drawing dashed lines. *)\n\nIMPORT R2, "
 & "Geometry, PS, Arrow;\n\nCONST \n  Tiny = ([3], 1.5), \n  Small = ([5], "
 & "2.5), \n  Medium = ([10], 5), \n  Big = ([20], 10), \n  Huge = ([40], 2"
 & "0), \n  DefaultPattern = Medium;\n\n(* This modules maintains a dash pa"
 & "ttern, which is a \n   pair \"(dashlist, offset)\". These dash patterns"
 & " \n   are based on the PostScript model for dashed \n   lines. The \"da"
 & "shlist\" is a list of non-negative \n   values that specify alternating"
 & " distances of dash \n   and gap lengths. The values in the \"dashlist\""
 & " are \n   used cyclically: after reaching the end of the \n   list, the"
 & " procedures in this module start back at \n   the beginning, alternatin"
 & "g the dash parity. \n   Hence, a \"dashlist\" that contains a single \n"
 & "   element alternates drawing dashes and gaps of the \n   same size. \n"
 & "\n   The dash \"offset\" may be thought of as the \n   ``phase\'\' of t"
 & "he dash pattern relative to the \n   start of the segment or curve. It "
 & "specifies the \n   distance into the dash pattern at which the \n   pat"
 & "tern should be started. Before beginning to \n   draw a dashed segment "
 & "or curve, the procedures in \n   this module cycle through the elements"
 & " of the \n   dash pattern, adding up distances and alternating \n   das"
 & "hes and gaps as usual, but without generating \n   any output. When the"
 & "y have travelled the offset \n   distance into the dash pattern, they s"
 & "tart adding \n   segments to the path from the point in the dash \n   p"
 & "attern that has been reached. *)\n\nPRIVATE VAR \n  dashList := CAR(Def"
 & "aultPattern), \n  offset := CDR(DefaultPattern);\n\n/* \"dashList\" and"
 & " \"offset\" are the current dash list \n   and offset values. */\n\nPRI"
 & "VATE PROC res := IsNonNegList(list) IS \n  IF \n    list # NIL -> \n   "
 & "   DO \n        list # NIL -> \n          IF CAR(list) >= 0 -> list := "
 & "CDR(list) FI \n      OD \n  FI; \n  res := NIL \nEND;\n\n/* Fail if \"l"
 & "ist\" contains anything other than \n   non-negative reals. Return \"NI"
 & "L\" otherwise. */\n\nPROC SetPattern(dashpat) IS \n  IF \n    VAR list,"
 & " num IN \n      dashpat = ";

CONST E13_0 = 
   "(list, num) -> \n        IF \n          num >= 0 AND IsNonNegList(list)"
 & " = NIL -> \n            dashList := list; offset := num \n        FI \n"
 & "    END \n  FI \nEND;\n\nUI SetTool(SetPattern);\n\n(* Sets the dash pa"
 & "ttern to \"dashpat\", which must be \n   a pair \"(dashlist, offset)\"."
 & " The \"dashlist\" must \n   be a non-NIL list of non-negative reals. Th"
 & "e \n   \"offset\" must be a non-negative real. *)\n\nUI Param(SetPatter"
 & "n, DefaultPattern);\n\nUI Param(SetPattern, Tiny);\n\nUI Param(SetPatte"
 & "rn, Small);\n\nUI Param(SetPattern, Medium);\n\nUI Param(SetPattern, Bi"
 & "g);\n\nUI Param(SetPattern, Huge);\n\nPROC dashpat := GetPattern() IS \n"
 & "  dashpat := (dashList, offset) \nEND;\n\n(* Set \"dashpat\" to the cur"
 & "rent dash pattern. *)\n\nPRIVATE PROC (pattern, parity):Advance(amt) IS"
 & " \n  DO \n    amt >= CAR(pattern) -> \n      amt := amt - CAR(pattern);"
 & " \n      parity := -parity; \n      pattern := CDR(pattern); \n      IF"
 & " \n        pattern = NIL -> pattern := dashList | SKIP \n      FI \n  O"
 & "D; \n  IF \n    amt > 0 -> \n      pattern := (CAR(pattern) - amt, CDR("
 & "pattern)) \n  | SKIP \n  FI \nEND;\n\n/* Let \"dashes\" denote the logi"
 & "cally infinite stream \n   of dashes represented by the initial value o"
 & "f \n   \"pattern\" concatenated with \"dash\" repeated an \n   infinite"
 & " number of times. Then set \"pattern\" and \n   \"parity\" to reflect t"
 & "he position reached by \n   advancing through \"dashes\" by the distanc"
 & "e \"amt\". \n*/\n\nPRIVATE VAR currPat, parity;\n\n/* While constructin"
 & "g a dashed path, \"currPat\" and \n   \"parity\" denote the current das"
 & "h pattern and \n   drawing parity. The \"MoveTo\" procedure resets \n  "
 & " these values according to \"dash\" and \"indent\". */\n\nPRIVATE PROC "
 & "Move(p) IS \n  PS.MoveTo(p); \n  currPat := dashList; \n  parity := 1; "
 & "\n  (currPat, parity):Advance(offset) \nEND;\n\n/* Start a new dashed p"
 & "ath at \"p\" using the current \n   dash pattern. */\n\nPRIVATE PROC Li"
 & "ne(p, q) IS \n  VAR r, dv, len, u, dist IN \n    dv := R2.Minus(q, p); "
 & "\n    len := Geometry.Dist(p, q); \n    u := R2.Times(1 / len, dv); \n "
 & "   dist := CAR(currPat); \n    DO \n      (dist < len) -> \n";

CONST E13_1 = 
   "        r := R2.Plus(p, R2.Times(dist, u)); \n        IF \n          pa"
 & "rity < 0 -> PS.MoveTo(r) | PS.LineTo(r) \n        FI; \n        (currPa"
 & "t, parity):Advance(CAR(currPat)); \n        dist := dist + CAR(currPat)"
 & " \n    OD; \n    IF parity > 0 -> PS.LineTo(q) | PS.MoveTo(q) FI; \n   "
 & " VAR amt IN \n      amt := len - (dist - CAR(currPat)); \n      (currPa"
 & "t, parity):Advance(amt) \n    END \n  END \nEND;\n\n/* Extend the curre"
 & "nt path with a dashed line \n   segment from \"p\" to \"q\"; \"q\" beco"
 & "mes the current \n   point. The style of the dash is determined by the "
 & "\n   current dash pattern. It is a checked run-time \n   error for the "
 & "current point to be undefined. */\n\nPRIVATE PROC Curve(p, q, r, s) IS "
 & "\n  VAR t, amt IN \n    t := 0; \n    DO \n      t < 1 -> \n        amt"
 & " := CAR(currPat); \n        (t, amt):CurvedDash(p, q, r, s, parity); \n"
 & "        (currPat, parity):Advance(amt) \n    OD \n  END \nEND;\n\n/* Ex"
 & "tend the current path with a dashed Bezier \n   curve determined by \"p"
 & "\", \"q\", \"r\", and \"s\"; \"s\" \n   becomes the current point. The "
 & "style of the dash \n   is determined by the current dash pattern. It is"
 & " \n   a checked run-time error for the current point to \n   be undefin"
 & "ed. */\n\nPRIVATE PRED \n  Trellis(t, p, q, r, s, pq, qr, rs, pqr, qrs,"
 & " pqrs) IS \n  pq = (t, 0) REL (p, q) AND \n  qr = (t, 0) REL (q, r) AND"
 & " \n  rs = (t, 0) REL (r, s) AND \n  pqr = (t, 0) REL (pq, qr) AND \n  q"
 & "rs = (t, 0) REL (qr, rs) AND \n  pqrs = (t, 0) REL (pqr, qrs) \nEND;\n\n"
 & "PRIVATE PROC \n  (t, len):CurvedDash(p, q, r, s, parity) IS \n  IF \n  "
 & "  VAR \n      pq, qr, rs, pqr, qrs, pqrs, velocity, speed, \n      endt"
 & " \n    IN \n      Trellis(t, p, q, r, s, pq, qr, rs, pqr, qrs, \n      "
 & "        pqrs) AND \n      velocity = R2.Times(3, R2.Minus(qrs, pqr)) AN"
 & "D \n      speed = R2.Length(velocity) AND \n      endt = t + len / spee"
 & "d -> \n        IF \n          endt > 1 -> \n            len := len * (1"
 & " - t) / (endt - t); \n            endt := 1 | SKIP \n        FI; \n    "
 & "    VAR t2 IN \n          t2 := (endt - t) / (1 - t); \n          Curve"
 & "dDashBit(pqrs, qrs, rs, s";

CONST E13_2 = 
   ", t2, parity) \n        END; \n        t := endt \n    END \n  FI \nEND"
 & ";\n\n/* CurvedDash draws a piece of the Bezier \n   \"[p,q,r,s]\" start"
 & "ing from \"t\" of length \"len\", \n   and advances \"t\". However, if "
 & "a piece of length \n   \"len\" would extend past \"s\", the piece is dr"
 & "awn \n   to \"s\", and \"len\" is set to the length of the \n   segment"
 & " that was drawn. */\n\nPRIVATE PROC CurvedDashBit(p, q, r, s, t, parity"
 & ") IS \n  IF \n    VAR pq, qr, rs, pqr, qrs, pqrs IN \n      Trellis(t, "
 & "p, q, r, s, pq, qr, rs, pqr, qrs, \n              pqrs) -> \n        IF"
 & " \n          parity > 0 -> PS.CurveTo(pq, pqr, pqrs) \n        | PS.Mov"
 & "eTo(pqrs) \n        FI \n    END \n  FI \nEND;\n\n/* CurvedDashBit(p,q,"
 & "r,s,t) draws the piece of \n   Bezier(p,q,r,s) from 0 to t. */\n\nPROC "
 & "Stroke() IS \n  VAR path, currPt, startPt IN \n    path := PS.CurrentPa"
 & "th(); \n    PS.NewPath(); \n    currPt, startPt := NIL, NIL; \n    DO \n"
 & "      path # NIL -> \n        IF \n          VAR op, args IN \n        "
 & "    CAR(path) = (op, args) -> \n              IF \n                op ="
 & " \"MoveTo\" -> \n                  startPt := CAR(args); \n            "
 & "      Move(startPt); \n                  currPt := startPt \n          "
 & "    | op = \"LineTo\" -> \n                  Line(currPt, CAR(args)); \n"
 & "                  currPt := CAR(args) \n              | op = \"CurveTo\""
 & " -> \n                  VAR b, c, d IN \n                    args = [b,"
 & " c, d] -> \n                      Curve(currPt, b, c, d); \n           "
 & "           currPt := d \n                  END \n              | op = \""
 & "Close\" -> \n                  Line(currPt, startPt); \n               "
 & "   currPt, startPt := NIL, NIL \n              FI \n          END \n   "
 & "     FI; \n        path := CDR(path) \n    OD; \n    PS.Stroke() \n  EN"
 & "D \nEND;\n\nUI PointTool(Stroke);\n\n(* Stroke the current path in the "
 & "current line width \n   using this module\'s current dash pattern. *)\n"
 & "\nPROC Straight1(a, b) IS \n  VAR c IN \n    c := Arrow.StraightEnd(a, "
 & "b, Arrow.HeadSize()); \n    PS.MoveTo(a); \n    PS.LineTo(c); \n    Str"
 & "oke(); \n    Arrow.Head(a, b) \n  END \nE";

CONST E13_3 = 
   "ND;\n\nUI PointTool(Straight1);\n\n(* Draw a dashed directed line from "
 & "\"a\" to \"b\". The \n   arrow head size is determined using the \n   \""
 & "Arrow.HeadSize\" procedure. *)\n\nPROC Straight2(a, b) IS \n  VAR sz, c"
 & ", d IN \n    sz := Arrow.HeadSize(); \n    c := Arrow.StraightEnd(b, a,"
 & " sz); \n    d := Arrow.StraightEnd(a, b, sz); \n    Arrow.Head(b, a); \n"
 & "    PS.MoveTo(c); \n    PS.LineTo(d); \n    Stroke(); \n    Arrow.Head("
 & "a, b) \n  END \nEND;\n\nUI PointTool(Straight2);\n\n(* Draw a dashed di"
 & "rected line between \"a\" and \"b\". \n   The arrow head size is determ"
 & "ined using the \n   \"Arrow.HeadSize\" procedure. *)\n\nPROC Curved1(a,"
 & " b, c, d) IS \n  VAR e IN \n    e := Arrow.StraightEnd(c, d, Arrow.Head"
 & "Size()); \n    PS.MoveTo(a); \n    PS.CurveTo(b, c, e); \n    Stroke();"
 & " \n    Arrow.Head(c, d) \n  END \nEND;\n\nUI PointTool(Curved1);\n\n(* "
 & "Draw a dashed directed curve from \"a\" to \"d\" \n   using \"b\" and \""
 & "c\" as control points. The arrow \n   head size is determined using the"
 & " \n   \"Arrow.HeadSize\" procedure. *)\n\nPROC Curved2(a, b, c, d) IS \n"
 & "  VAR sz, e, f IN \n    sz := Arrow.HeadSize(); \n    e := Arrow.Straig"
 & "htEnd(b, a, sz); \n    f := Arrow.StraightEnd(c, d, sz); \n    Arrow.He"
 & "ad(b, a); \n    PS.MoveTo(e); \n    PS.CurveTo(b, c, f); \n    Stroke()"
 & "; \n    Arrow.Head(c, d) \n  END \nEND;\n\nUI PointTool(Curved2);\n\n(*"
 & " Draw a dashed directed curve between \"a\" and \"d\" \n   using \"b\" "
 & "and \"c\" as control points. The arrow \n   head size is determined usi"
 & "ng the \n   \"Arrow.HeadSize\" procedure. *)\n\nPRIVATE VAR history := "
 & "NIL;\n\nPROC Save() IS \n  history := ((dashList, offset), history) \nE"
 & "ND;\n\nPROC Restore() IS \n  VAR state IN \n    state := CAR(history); "
 & "\n    dashList := CAR(state); \n    offset := CDR(state); \n    history"
 & " := CDR(history) \n  END \nEND;\n\nUI PointTool(Save);\n\nUI PointTool("
 & "Restore);\n\n(* Save/restore the \"Dash\" state, namely the dash \n   p"
 & "attern and offset. *)\n\n";

CONST E14 = 
   "MODULE Type;\n\n(* The procedures in this module type a \n   single lin"
 & "e of text relative to a \n   specified point. *)\n\nIMPORT PS;\n\nPROC "
 & "L(p, txt) IS PS.Type(p, txt) END;\n\nUI TextTool(L);\n\n(* Equivalent t"
 & "o \"PS.Type(p, txt)\". *)\n\nPROC C(p, txt) IS \n  VAR w IN\n    w := P"
 & "S.StringWidth(txt);\n    PS.Type((CAR(p) - w / 2, CDR(p)), txt) \n  END"
 & " \nEND;\n\nUI TextTool(C);\n\n(* Like \"PS.Type\", but \"txt\" is cente"
 & "red \n   around \"p\". *)\n\nPROC R(p, txt) IS \n  VAR w IN\n    w := P"
 & "S.StringWidth(txt);\n    PS.Type((CAR(p) - w, CDR(p)), txt) \n  END \nE"
 & "ND;\n\nUI TextTool(R);\n\n(* Like \"PS.Type\", but \"txt\" is \n   righ"
 & "t-justifed off \"p\". *)\n\n";

CONST E15 = 
   "MODULE PieChart;\n\nIMPORT Color, LineSkip, List, Math;\n\nIMPORT PS, R"
 & "2, Unparse, Circle, Arc, Rect;\n\n(* A module for drawing pie charts an"
 & "d their legends. *)\n\n(* \\section{Pie Chart Colors} *)\n\nVAR Saturat"
 & "ion := 1, Brightness := 1;\n\n(* The \"Draw\" procedure below for drawi"
 & "ng pie charts chooses the \n   hue of each wedge so that subsequent hue"
 & "s are distinct. The \n   saturation and value (or brightness) of each w"
 & "edge are \n   controlled by the current values of the global variables "
 & "\n   \"Saturation\" and \"Brightness\". See the description of the \n  "
 & " procedure \"Color.FromHSV\" of the hue-saturation-value color \n   mod"
 & "el. *)\n\nPRIVATE PROC c := ColorN(i) IS \n  c := Color.FromHSV(Color.H"
 & "ueN(i), Saturation, Brightness) \nEND;\n\n(* \\section{Pie Charts} *)\n"
 & "\nPRIVATE CONST OuterLineWidth = 2, InnerLineWidth = 1;\n\n/* The outer"
 & " circumference of the pie is stroked in a line of \n   width \"OuterLin"
 & "eWidth\". The divisions between the pie slices \n   are stroked with li"
 & "nes of width \"InnerLineWidth\". */\n\nPRIVATE FUNC p = Loc(a, b, k) IS"
 & " \n  (E theta = -k * 2 * Math.Pi, q = (COS(theta), SIN(theta)) :: \n   "
 & " p = q REL (a, b)) \nEND;\n\n/* \"p\" is the point on the circumference"
 & " of the pie with center \n   \"a\" starting at \"b\" a fraction \"k\" o"
 & "f the way around the pie \n   (in the clockwise direction). */\n\nPRIVA"
 & "TE PROC DrawWedge(a, b, from, to, i) IS \n  SAVE PS IN \n    VAR p, q I"
 & "N \n      p, q := Loc(a, b, from), Loc(a, b, to); \n      SAVE PS IN \n"
 & "        PS.MoveTo(a); \n        PS.LineTo(p); \n        Arc.Draw(a, q);"
 & " \n        PS.Close(); \n        PS.SetColor(ColorN(i)); \n        PS.F"
 & "ill() \n      END; \n      PS.MoveTo(p); \n      PS.LineTo(a); \n      "
 & "PS.LineTo(q); \n      PS.SetEndStyle(PS.ButtEnds); \n      PS.SetJointS"
 & "tyle(PS.BevelJoints); \n      PS.Stroke() \n    END \n  END \nEND;\n\n/"
 & "* Draw a wedge from \"Loc(a,b,from)\" to \"Loc(a,b,to)\" filled \n   wi"
 & "th the color corresponding to index \"i\". */\n\nPRIVATE PROC sum := To"
 & "tal(data) IS \n  sum := 0; \n  DO \n    data # NIL -> sum := sum + CAR("
 & "CAR(data)); data := CDR(data) \n  OD \nE";

CONST E15_0 = 
   "ND;\n\n/* Return the sum of the \"CAR\"\'s of the elements of the list "
 & "\n   \"data\". */\n\nPROC Draw(a, b, data) IS \n  SAVE PS IN \n    PS.S"
 & "etWidth(InnerLineWidth); \n    VAR sum, item, curr = 0, i = 0 IN \n    "
 & "  sum := Total(data); \n      DO \n        data # NIL -> \n          it"
 & "em := CAR(data); \n          data := CDR(data); \n          VAR new IN "
 & "\n            new := curr + (CAR(item) / sum); \n            DrawWedge("
 & "a, b, curr, new, i); \n            curr := new \n          END; \n     "
 & "     i := i + 1 \n      OD \n    END; \n    Circle.Draw(a, b); \n    PS"
 & ".SetWidth(OuterLineWidth); \n    PS.Stroke() \n  END \nEND;\n\n(* Draw "
 & "a pie chart with center \"a\" and circumference starting \n   point \"b"
 & "\" on the given \"data\". \"Data\" must be a list of \n   \"(value, nam"
 & "e)\" pairs. The \"name\" parts of the data are \n   ignored by this pro"
 & "cedure, but they are used by the \"Legend\" \n   procedure below. *)\n\n"
 & "(* \\section{Pie Chart Legends} *)\n\nPRIVATE CONST \n  LegendLineWidth"
 & " = 1, SquareScale = 0.7, LegendGap = 5;\n\nPRIVATE PROC LegendSquare(p,"
 & " ht, i) IS \n  VAR center, ht2, delta IN \n    ht2 := ht / 2; \n    del"
 & "ta := (ht2, -ht2); \n    center := R2.Plus(p, delta); \n    Rect.DrawC("
 & "center, \n               R2.Plus(center, R2.Times(SquareScale, delta)))"
 & "; \n    SAVE PS IN PS.SetColor(ColorN(i)); PS.Fill() END; \n    PS.Stro"
 & "ke() \n  END \nEND;\n\nPRIVATE PROC p:LegendItem(asc, ht, label, i) IS "
 & "\n  LegendSquare(p, ht, i); \n  PS.Type(R2.Plus(p, (ht + LegendGap, -as"
 & "c)), label); \n  p := R2.Minus(p, (0, ht + LineSkip.Get())) \nEND;\n\nP"
 & "ROC Legend(a, data, labelCl) IS \n  SAVE PS IN \n    PS.SetWidth(Legend"
 & "LineWidth); \n    VAR asc, dec, ht, vert, sum, i = 0 IN \n      asc, de"
 & "c := PS.FontHeight(); \n      ht := asc + dec; \n      vert := \n      "
 & "  List.Length(data) * (ht + LineSkip.Get()) - \n        LineSkip.Get();"
 & " \n      sum := Total(data); \n      a := R2.Plus(a, (0, vert / 2)); \n"
 & "      DO \n        data # NIL -> \n          a:LegendItem(asc, ht, APPL"
 & "Y(labelCl, CAR(data), sum), i); \n          data := CDR(data); \n      "
 & "    i := i + 1 \n      OD \n    EN";

CONST E15_1 = 
   "D \n  END \nEND;\n\n(* Draw a legend for the given \"data\" located so "
 & "its west edge \n   is centered at \"a\". The \"data\" should be a list "
 & "of \"(value, \n   name)\" pairs. \n\n   The call \"APPLY(labelCl, item,"
 & " sum)\" must return the textual \n   label associated with the given \""
 & "item\" (which is a name-value \n   pair), given that \"sum\" is the sum"
 & " of the values of all the \n   items. There are predefined label closur"
 & "es defined below for \n   common cases. \n\n   The legend names are pri"
 & "nted in the current font, separated \n   by the nominal height of the f"
 & "ont plus the current \"LineSkip\" \n   value (as maintained by the \"Li"
 & "neSkip\" module). *)\n\nPROC res := OnlyLabel(item, sum) IS res := CDR("
 & "item) END;\n\n(* A label closure that returns only the name of the labe"
 & "l *)\n\nPROC res := AbsoluteLabel(item, sum) IS \n  res := CDR(item) & "
 & "\" (\" & Unparse.Value(CAR(item)) & \")\" \nEND;\n\n(* A label closure "
 & "that returns the name of the label and its \n   associated value. *)\n\n"
 & "PROC res := PercentLabel(item, sum) IS \n  res := \n    CDR(item) & \" "
 & "(\" & Unparse.Value(100 * CAR(item) / sum) & \n    \"%)\" \nEND;\n\n(* "
 & "A label closure that returns the name of the label and its \n   associa"
 & "ted percentage. *)\n\n";

CONST E16 = 
   "; Copyright (C) 1992, Digital Equipment Corporation                    "
 & "     \n; All rights reserved.                                          "
 & "            \n; See the file COPYRIGHT for a full description.         "
 & "                   \n;                                                 "
 & "                          \n; Last modified on Thu Mar 28 17:28:49 PST "
 & "1996 by heydon\n\n; Macros for particular shape constraints\n;\n(Macro "
 & "Width2 BOA (w)  `(Width ,w + Inf - ,w))\n(Macro Height2 BOA (h) `(Heigh"
 & "t ,h + Inf - ,h))\n(Macro FixedHeight BOA (ch) `(Shape (Height + 0 - 0)"
 & " ,ch))\n(Macro FixedWidth BOA (ch) `(Shape (Width + 0 - 0) ,ch))\n(Macr"
 & "o FixedSize BOA (ch) `(Shape (Height + 0 - 0) (Width + 0 - 0) ,ch))\n\n"
 & "; Shape macros for particular generics\n;\n(Macro Drawing BOA (ch) `(Sh"
 & "ape (Width2 350) (Height2 0) ,ch))\n(Macro Sources BOA (ch) `(Shape (Wi"
 & "dth2 350) ,ch))\n(Macro Module  BOA (ch) `(Shape (Height2 295) ,ch))\n("
 & "Macro CCmd    BOA (ch) `(Shape (Height2 295) ,ch))\n\n; Macros for the "
 & "various \"File\" menu pop-ups\n(Macro BrowserAt BOA () \'(At 71 20 NW A"
 & "bsolute))\n(Macro BrowserShape BOA (ch) `(Shape (Height2 300) (Width2 2"
 & "00) ,ch))\n\n; MyBar, MyRidge, Space == misc spaces of fixed width\n;\n"
 & "(Macro MyBar   () \'(Bar 1))\n(Macro MyRidge () \'(Bar 1))\n(Macro Spac"
 & "e   () \'(Glue 3))\n(Macro SmallSpace () \'(Glue 1))\n\n; HTile2(ch1,ch"
 & "2) == like (HTile ch1 ch2), only puts (MyBar) on either side of\n;   th"
 & "e bar separating the children\n;\n(Macro HTile2 BOA (ch1 ch2)\n  `(HTil"
 & "e (HBox ,ch1 (MyBar)) (HBox (MyBar) ,ch2)))\n(Macro VTile2 BOA (ch1 ch2"
 & ")\n  `(VTile (VBox ,ch1 (MyBar)) (VBox (MyBar) ,ch2)))\n\n; ButtonLabel"
 & "(lbl) == \"lbl\" with space on either side\n;\n(Macro ButtonLabel BOA ("
 & "lbl)\n  `(HBox (SmallSpace) ,lbl (SmallSpace)))\n\n; MenuLabel(lbl) == "
 & "\"lbl\" followed by \"MenuArrow\"\n;\n(Macro MenuLabel BOA (lbl)\n  `(B"
 & "uttonLabel\n    (HBox\n     ,lbl\n     (SmallSpace)\n     (FixedWidth ("
 & "Pixmap \"MenuArrow.pbm\"))\n     (Space))))\n\n; TextL == left-aligned "
 & "text\n;\n(Macro TextL BOA (txt)\n  `(Text LeftAlign ,txt))\n\n; MyLabel"
 & "Font == set part";

CONST E16_0 = 
   "icular LabelFont\n;\n(Macro MyLabelFont ()\n  \'(LabelFont\n     (Famil"
 & "y \"Helvetica\")\n     (WeightName \"bold\")\n     (Slant \"r\")\n     "
 & "(PointSize 100)))\n\n; MyBrowserFont == set font for file browser windo"
 & "ws\n;\n(Macro MyBrowserFont ()\n  \'(Font\n     (Family \"Helvetica\")\n"
 & "     (WeightName \"bold\")\n     (Slant \"r\")\n     (Width \"normal\")"
 & "\n     (PointSize 100)))\n\n(Macro MyBrowserLabelFont ()\n  \'(LabelFon"
 & "t\n     (Family \"Helvetica\")\n     (WeightName \"bold\")\n     (Slant"
 & " \"r\")\n     (PointSize 100)))\n\n; ZChassis look-alikes with named \""
 & "Cancel\" buttons\n;\n(Macro If BOA (bool x y)\n  (IF bool x y))\n(Macro"
 & " MyZChassis\n  ((At (0.5 0.5))\n   (CancelBox TRUE)\n   (CancelName \"\""
 & ")\n   (GrowBox TRUE)\n   Name\n   Title\n   Child)\n `(ZChild %,Name\n "
 & "   (At ,@At)\n    (MyBrowserLabelFont)\n    (Border\n      (VBox\n     "
 & "   (HBox\n          (If ,CancelBox\n            (CloseButton %,CancelNa"
 & "me\n              (Rim (Pen 2) (Pixmap \"UpArrow.pbm\")))\n            "
 & "(Glue 0)\n          )\n          (Bar)\n          (Shape (Width + Inf) "
 & "(ZMove ,Title))\n          (Bar)\n          (If ,GrowBox\n            ("
 & "ZGrow (Rim (Pen 2) (Pixmap \"Grow.pbm\")))\n            (Glue 0)\n     "
 & "     )\n        )\n        (Bar)\n        (Frame ,Child)\n      )\n    "
 & ")\n  )\n)\n";

CONST E17 = 
   "MODULE Bezier;\n\n(* Bezier curve predicates and procedures. *)\n\nIMPO"
 & "RT R2, Geometry;\n\n(* A Bezier curve is defined by a univariate cubic "
 & "polynomial \n   \"F(t)\": \n\n|  F(t) = p0 + t*p1 + t^2*p2 + t^3*p3,\n\n"
 & "   where \"t\" is a scalar, and the coefficients \"p_i\" are vectors \n"
 & "   (pairs of real numbers). Here, \"*\" denotes the multiplication \n  "
 & " of a vector by a scalar, and \"+\" denotes vector addition. \n\n   Alt"
 & "ernatively, a Bezier curve \"a\", \"b\", \"c\", \"d\" may be \n   speci"
 & "fied by its two endpoints \"a\" and \"d\" and its two \n   control poin"
 & "ts \"b\" and \"c\". Since \"t = 0\" corresponds to the \n   first endpo"
 & "int \"a\", and \"F(0) = p0\", we have that \"a = p0\". \n   The \"MapRe"
 & "p\" predicate below defines the mapping between the \n   two representa"
 & "tions. *)\n\n(* MAPPING BETWEEN REPRESENTATIONS *)\n\nPRED MapRep(a, b,"
 & " c, d, p1, p2, p3) IS \n  (E ba, bc, b2, ab2, bc3, ab2c, bc3d :: \n    "
 & "ba = R2.Minus(b, a) AND \n    bc = R2.Minus(b, c) AND \n    b2 = R2.Tim"
 & "es(2, b) AND \n    ab2 = R2.Minus(a, b2) AND \n    bc3 = R2.Times(3, bc"
 & ") AND \n    ab2c = R2.Plus(ab2, c) AND \n    bc3d = R2.Plus(bc3, d) AND"
 & " \n    p1 = R2.Times(3, ba) AND \n    p2 = R2.Times(3, ab2c) AND \n    "
 & "p3 = R2.Minus(bc3d, a)) \nEND;\n\n(* The curve defined by the points \""
 & "a\", \"b\", \"c\", and \"d\" \n   corresponds to the univariate cubic p"
 & "olynomial \"F\" with \n   coefficients \"a\", \"p1\", \"p2\", and \"p3\""
 & ". *)\n\n(* COEFFICIENT REPRESENTATION *)\n\nPRIVATE FUNC r = Sum3(a, b,"
 & " c) IS \n  r = R2.Plus(a, R2.Plus(b, c)) \nEND;\n\n/* \"r\" is the vect"
 & "or sum of \"a\", \"b\", and \"c\", which are 2D \n   points. */\n\nPRIV"
 & "ATE FUNC r = Sum4(a, b, c, d) IS \n  r = R2.Plus(a, R2.Plus(b, R2.Plus("
 & "c, d))) \nEND;\n\n/* \"r\" is the vector sum of \"a\", \"b\", \"c\", an"
 & "d \"d\", which are 2D \n   points. */\n\nFUNC p = AtTFromCoeffs(p0, p1,"
 & " p2, p3, t) IS \n  (E t2, t3, s1, s2, s3 :: \n    t2 = t * t AND \n    "
 & "t3 = t * t2 AND \n    s1 = R2.Times(t, p1) AND \n    s2 = R2.Times(t2, "
 & "p2) AND \n    s3 = R2.Times(t3, p3) AND \n    p = Sum4(p0, s1, s2, s3))"
 & " \nEND;\n\n(* If \"F\" is the Bezier curve defined by the four coeffici"
 & "ents \n   \"";

CONST E17_0 = 
   "p0\", \"p1\", \"p2\", and \"p3\", then \"p = F(t)\". *)\n\nFUNC p = Pri"
 & "meAtTFromCoeffs(p0, p1, p2, p3, t) IS \n  p = Sum3(p1, R2.Times(2 * t, "
 & "p2), R2.Times(3 * t * t, p3)) \nEND;\n\n(* If \"F\" is the Bezier curve"
 & " defined by the four coefficients \n   \"p0\", \"p1\", \"p2\", and \"p3"
 & "\", then \"p = F\'(t)\", where \"F\'\" \n   denotes the first derivativ"
 & "e of the polynomial \"F\" with \n   respect to \"t\". *)\n\n(* POINT RE"
 & "PRESENTATION *)\n\nFUNC p = AtT(a, b, c, d, t) IS \n  (E p1, p2, p3 :: "
 & "\n    MapRep(a, b, c, d, p1, p2, p3) AND \n    p = AtTFromCoeffs(a, p1,"
 & " p2, p3, t)) \nEND;\n\n(* If \"F\" is the Bezier curve defined by the f"
 & "our points \"a\", \n   \"b\", \"c\", and \"d\", then \"p = F(t)\". *)\n"
 & "\nFUNC p = PrimeAtT(a, b, c, d, t) IS \n  (E p1, p2, p3 :: \n    MapRep"
 & "(a, b, c, d, p1, p2, p3) AND \n    p = PrimeAtTFromCoeffs(a, p1, p2, p3"
 & ", t)) \nEND;\n\n(* If \"F\" is the Bezier curve defined by the four poi"
 & "nts \"a\", \n   \"b\", \"c\", and \"d\", then \"p = F\'(t)\", where \"F"
 & "\'\" denotes the \n   first derivative of the polynomial \"F\" with res"
 & "pect to \"t\". *)\n\nPRIVATE PROC p := EvalAtT(p0, p1, p2, p3, t) IS \n"
 & "  VAR t2, t3, s1, s2, s3 IN \n    t2 := t * t; \n    t3 := t * t2; \n  "
 & "  s1 := R2.Times(t, p1); \n    s2 := R2.Times(t2, p2); \n    s3 := R2.T"
 & "imes(t3, p3); \n    p := Sum4(p0, s1, s2, s3) \n  END \nEND;\n\nPROC cl"
 & " := Closure(a, b, c, d) IS \n  IF \n    VAR p1, p2, p3 IN \n      MapRe"
 & "p(a, b, c, d, p1, p2, p3) -> \n        cl := CLOSE(EvalAtT, a, p1, p2, "
 & "p3) \n    END \n  FI \nEND;\n\n(* Return a closure taking a single argu"
 & "ment \"t\" and returning \n   the point \"F(t)\", where \"F\" is the Be"
 & "zier curve defined by \n   the points \"a\", \"b\", \"c\", and \"d\". *"
 & ")\n\nPRIVATE FUNC t = EstimateT(p, a, b, c, d) IS \n  (E ab = (0.5, 0) "
 & "REL (a, b), bc = (0.5, 0) REL (b, c), \n     cd = (0.5, 0) REL (c, d), "
 & "abc = (0.5, 0) REL (ab, bc), \n     bcd = (0.5, 0) REL (bc, cd), \n    "
 & " abcd = (0.5, 0) REL (abc, bcd), x, y :: \n    p = (x, y) REL (abcd, bc"
 & "d) AND t = 0.5 + x / 6) \nEND;\n\nPRED On(p, a, b, c, d) IS \n  (E t ~ "
 & "EstimateT(p, a, b, c, d), ab ~ (t, 0) REL (a, b), \n     bc ~ (t, 0) RE"
 & "L (b, c), c";

CONST E17_1 = 
   "d ~ (t, 0) REL (c, d), \n     abc ~ (t, 0) REL (ab, bc), bcd ~ (t, 0) R"
 & "EL (bc, cd) :: \n    ab = (t, 0) REL (a, b) AND \n    bc = (t, 0) REL ("
 & "b, c) AND \n    cd = (t, 0) REL (c, d) AND \n    abc = (t, 0) REL (ab, "
 & "bc) AND \n    bcd = (t, 0) REL (bc, cd) AND \n    p = (t, 0) REL (abc, "
 & "bcd)) \nEND;\n\nUI PointTool(On);\n\n(* The point \"p\" lies on the Bez"
 & "ier curve \"a\", \"b\", \"c\", \"d\". *)\n\nPROC p1, p2, p3, p4, p5 := "
 & "Split(a, b, c, d) IS \n  IF \n    VAR \n      ab = Geometry.Mid(a, b), "
 & "bc = Geometry.Mid(b, c), \n      cd = Geometry.Mid(c, d), abc = Geometr"
 & "y.Mid(ab, bc), \n      bcd = Geometry.Mid(bc, cd), abcd = Geometry.Mid("
 & "abc, bcd) \n    IN \n      p1, p2, p3, p4, p5 := ab, abc, abcd, bcd, cd"
 & " \n    END \n  FI \nEND;\n\n(* Set the output parameters so that \n\n| "
 & "   PS.MoveTo(a);\n|    PS.CurveTo(p1, p2, p3);\n|    PS.CurveTo(p4, p5,"
 & " d)\n\n   produces a path equivalent to \n\n|    PS.MoveTo(a);\n|    PS"
 & ".CurveTo(b, c, d).\n\n   The point \"p3\" is the midpoint of the curve "
 & "\"a\", b\", \"c\", \n   \"d\". That is, \"p3 = AtT(a, b, c, d, 0.5)\". "
 & "*)\n\nPRIVATE CONST MinDist = 8, MaxRatio = 0.004;\n\nPRIVATE PROC Ck, "
 & "Pk := LengthAux(a, b, c, d, depth, max) IS \n  VAR split = 1 IN \n    I"
 & "F \n      depth < max -> SKIP \n    | Ck, Pk := \n        Geometry.Dist"
 & "(a, d), \n        Geometry.Dist(a, b) + Geometry.Dist(b, c) + \n       "
 & " Geometry.Dist(c, d); \n      IF \n        Pk < MinDist OR (Pk - Ck) / "
 & "Pk < MaxRatio -> split := NIL \n      | SKIP \n      FI \n    FI; \n   "
 & " IF \n      split # NIL -> \n        VAR p1, p2, p3, p4, p5, Ck2, Pk2 I"
 & "N \n          p1, p2, p3, p4, p5 := Split(a, b, c, d); \n          Ck, "
 & "Pk := LengthAux(a, p1, p2, p3, depth + 1, max); \n          Ck2, Pk2 :="
 & " LengthAux(p3, p4, p5, d, depth + 1, max); \n          Ck, Pk := Ck + C"
 & "k2, Pk + Pk2 \n        END | SKIP \n    FI \n  END \nEND;\n\n/* Sets \""
 & "Ck\" and \"Pk\" to a lower- and upper-bound, respectively, \n   on the "
 & "length of the Bezier curve defined by the points \"a\", \n   \"b\", \"c"
 & "\", and \"d\". Recursion proceeds so long as the relative \n   differen"
 & "ce between the upper and lower bound is grea";

CONST E17_2 = 
   "ter than \n   the constant \"Epsilon\". */\n\nPROC len := Length(a, b, "
 & "c, d) IS \n  VAR Ck, Pk IN \n    Ck, Pk := LengthAux(a, b, c, d, 0, 3);"
 & " len := (Ck + Pk) / 2 \n  END \nEND;\n\n(* Set \"len\" to an approximat"
 & "ion of the length (in points) of \n   the Bezier curve defined by the f"
 & "our points \"a\", \"b\", \"c\", \n   \"d\". *)\n\n";

CONST E18 = 
   "MODULE Show;\n\n(* Procedures to display a single \n   line of text rel"
 & "ative to the \n   current point. All procedures in \n   this module req"
 & "uire that the \n   current point is defined. *)\n\nIMPORT PS;\n\nPROC L"
 & "(txt) IS \n  VAR p, w IN \n    p := PS.CurrentPoint(); \n    w := PS.St"
 & "ringWidth(txt); \n    PS.Type(p, txt); \n    PS.MoveTo((CAR(p) + w, CDR"
 & "(p))) \n  END \nEND;\n\nUI TextTool(L);\n\n(* Types \"txt\" left-justif"
 & "ied off \n   the current point, then moves \n   the current point to th"
 & "e right \n   by the width of \"txt\". *)\n\nPROC C(txt) IS \n  VAR p, w"
 & " IN \n    p := PS.CurrentPoint(); \n    w := PS.StringWidth(txt); \n   "
 & " PS.Type((CAR(p) - w / 2, CDR(p)), \n            txt) \n  END \nEND;\n\n"
 & "UI TextTool(C);\n\n(* Types \"txt\" centered about the \n   current poi"
 & "nt. This procedure \n   does not change the current \n   point. *)\n\nP"
 & "ROC R(txt) IS \n  VAR p, w IN \n    p := PS.CurrentPoint(); \n    w := "
 & "PS.StringWidth(txt); \n    p := (CAR(p) - w, CDR(p)); \n    PS.Type(p, "
 & "txt); \n    PS.MoveTo(p) \n  END \nEND;\n\nUI TextTool(R);\n\n(* Types "
 & "\"txt\" right-justified off \n   the current point, then moves \n   the"
 & " current point to the left\n   by the width of \"txt\". *)\n\n";

CONST E19 = 
   "; Copyright (C) 1992, Digital Equipment Corporation                    "
 & "     \n; All rights reserved.                                          "
 & "            \n; See the file COPYRIGHT for a full description.         "
 & "                   \n;                                                 "
 & "                          \n; Last modified on Thu Jan 30 11:34:11 PST "
 & "1997 by heydon                   \n\n(Rim (Pen 5)\n  (Macro VGap () \'("
 & "Glue 5))\n  (Macro TypeinField BOA (label name tabTo (firstFocus FALSE)"
 & ")\n    `(HBox\n       (Shape (Width + 0) (Text ,label))\n       (Glue 2"
 & ")\n       (Frame Lowered (MyBrowserFont) (Shape (Width 120 + Inf)\n    "
 & "     (TypeIn %,name (TabTo ,tabTo) (BgColor \"White\")\n           (Fir"
 & "stFocus ,firstFocus))))))\n  (VBox\n    (TypeinField \"Name:\" animName"
 & " sliderPts TRUE)\n    (VGap)\n    (TypeinField \"Slider Points:\" slide"
 & "rPts animName)\n    (VGap)\n    (HBox Fill (Button %foldAsAnimOk \"  OK"
 & "  \") Fill))\n)\n";

CONST E20 = 
   "MODULE Line;\n\n(* Procedures and predicates for \n   lines and line se"
 & "gments. *)\n\nIMPORT Geometry, PS;\n\n(* A line segment \"[a, b]\" is \n"
 & "   defined by its two endpoints \"a\" \n   and \"b\". *)\n\nPROC Draw(a"
 & ", b) IS \n  PS.MoveTo(a); PS.LineTo(b) \nEND;\n\nUI PointTool(Draw);\n\n"
 & "(* Add the line segment \"[a, b]\" to \n   the current path. The curren"
 & "t \n   point becomes \"b\". *)\n\nPRED On(p, a, b) IS \n  Geometry.Coli"
 & "near(a, p, b) \nEND;\n\nUI PointTool(On);\n\n(* The point \"p\" is on t"
 & "he line \n   \"[a, b]\". *)\n\n";

CONST E21 = 
   "MODULE Unparse;\n\n(* Procedures for converting Juno values to texts *)"
 & "\n\nIMPORT Text;\n\nCONST DefaultNumPrec = 4;\n\nPRIVATE VAR prec := De"
 & "faultNumPrec - 1;\n\n(* This module maintains a current numeric precisi"
 & "on, \n   which is the precision it uses when unparsing \n   numbers. A "
 & "number\'s \"precision\" is defined to be its \n   number of significant"
 & " digits. *)\n\nPROC SetNumPrec(p) IS prec := p - 1 END;\n\nPROC p := Ge"
 & "tNumPrec() IS p := prec + 1 END;\n\nUI SetTool(SetNumPrec);\n\n(* Set/g"
 & "et the current numeric precision. *)\n\nUI Param(SetNumPrec, DefaultNum"
 & "Prec);\n\nUI Param(SetNumPrec, 0);\n\nUI Param(SetNumPrec, 1);\n\nUI Pa"
 & "ram(SetNumPrec, 2);\n\nUI Param(SetNumPrec, 3);\n\nUI Param(SetNumPrec,"
 & " 4);\n\nUI Param(SetNumPrec, 5);\n\nCONST DefaultBreakDepth = 0;\n\nPRI"
 & "VATE VAR breakDepth := DefaultBreakDepth;\n\n(* This module maintains a"
 & " list-breaking depth. *)\n\nPROC SetBreakDepth(d) IS breakDepth := d EN"
 & "D;\n\nPROC d := GetBreakDepth() IS d := breakDepth END;\n\nUI SetTool(S"
 & "etBreakDepth);\n\n(* Set/get the list break depth. *)\n\nUI Param(SetBr"
 & "eakDepth, DefaultBreakDepth);\n\nUI Param(SetBreakDepth, 0);\n\nUI Para"
 & "m(SetBreakDepth, 1);\n\nUI Param(SetBreakDepth, 2);\n\nUI Param(SetBrea"
 & "kDepth, 1000);\n\nPROC t := Point(p) IS \n  t := \n    \"(\" & Text.Fro"
 & "mNum(CAR(p), prec) & \", \" & \n    Text.FromNum(CDR(p), prec) & \")\" "
 & "\nEND;\n\n(* Return a textual representation of the point \"p\". It \n "
 & "  is a checked run-time error for \"p\" not to be a pair \n   of number"
 & "s. *)\n\nPROC t := Value(val) IS t := ValueToDepth(val, 0) END;\n\n(* S"
 & "et \"t\" to a textual representation of \"val\". By \n   default, \"t\""
 & " will not contain any added newline \n   characters. However, if \"val\""
 & " is a list and the \n   current list break depth is positive, then list"
 & " \n   elements nested to a depth up to the current list \n   break dept"
 & "h will be separated by newlines and enough \n   spaces so they will be "
 & "nicely formatted if rendered \n   in a fixed-width font using any of th"
 & "e procedures in \n   the \"TypeLinesL\" module. *)\n\nPRIVATE PROC t :="
 & " ValueToDepth(val, depth) IS \n  IF \n    val = ";

CONST E21_0 = 
   "NIL -> t := \"NIL\" | TEXT(val) -> t := val \n  | REAL(val) -> t := Tex"
 & "t.FromNum(val, prec) \n  | PAIR(val) -> \n      IF \n        IsList(CDR"
 & "(val)) # NIL -> \n          t := ListVal(val, depth) | t := Pair(val) \n"
 & "      FI \n  FI \nEND;\n\nPRIVATE PROC res := IsList(v) IS \n  IF \n   "
 & " v = NIL -> res := 0 \n  | PAIR(v) -> res := IsList(CDR(v)) | res := NI"
 & "L \n  FI \nEND;\n\n/* Return non-NIL iff \"v\" is a list. */\n\nPRIVATE"
 & " PROC t := Pair(pr) IS \n  t := \n    \"(\" & ValueToDepth(CAR(pr), bre"
 & "akDepth) & \", \" & \n    ValueToDepth(CDR(pr), breakDepth) & \")\" \nE"
 & "ND;\n\n/* Return the textual representation of \"pr\", which is \n   kn"
 & "own to be a pair. */\n\nPRIVATE PROC t := ListVal(l, depth) IS \n  t :="
 & " \n    \"[\" & ValueToDepth(CAR(l), depth + 1) & \n    ListBody(CDR(l),"
 & " depth) & \"]\" \nEND;\n\n/* Return a textual representation of \"l\", "
 & "which is \n   known to be a list. */\n\nPRIVATE PROC t := ListBody(l, d"
 & "epth) IS \n  IF \n    l = NIL -> t := \"\" \n  | depth < breakDepth -> "
 & "\n      t := \n        \",\\n \" & Spaces(depth) & \n        ValueToDep"
 & "th(CAR(l), depth + 1) & \n        ListBody(CDR(l), depth) \n  | t := \n"
 & "      \", \" & ValueToDepth(CAR(l), depth) & \n      ListBody(CDR(l), d"
 & "epth) \n  FI \nEND;\n\nPRIVATE CONST SpacesStr = \"          \";\n\nPRI"
 & "VATE VAR spacesStrLen := Text.Length(SpacesStr);\n\nPRIVATE PROC t := S"
 & "paces(n) IS \n  t := \"\"; \n  DO \n    n > spacesStrLen -> \n      t :"
 & "= t & SpacesStr; n := n - spacesStrLen \n  OD; \n  t := t & Text.Sub(Sp"
 & "acesStr, 0, n) \nEND;\n\n/* Set \"t\" to a string of \"n\" spaces. */\n"
 & "\nPRIVATE VAR history := NIL;\n\nPROC Save() IS \n  history := ((prec, "
 & "breakDepth), history) \nEND;\n\nPROC Restore() IS \n  VAR head IN \n   "
 & " head := CAR(history); \n    prec := CAR(head); \n    breakDepth := CDR"
 & "(head) \n  END; \n  history := CDR(history) \nEND;\n\nUI PointTool(Save"
 & ");\n\nUI PointTool(Restore);\n\n(* Save/restore the current state of th"
 & "is module. *)\n\n";

CONST E22 = 
   "MODULE PtLabel;\n\n(* Module for annotating points in a \n   drawing fo"
 & "r inclusion in figures. *)\n\nIMPORT R2, PS, Circle;\n\nCONST DefaultDo"
 & "tSize = 2;\n\nPRIVATE VAR dotSize := DefaultDotSize;\n\n(* This module "
 & "maintains a ``current \n   dot size\'\', which is the radius of \n   th"
 & "e dot drawn to label a point. The \n   dot size is measured in points. "
 & "*)\n\nPROC SetDotSize(sz) IS \n  dotSize := sz \nEND;\n\nUI SetTool(Set"
 & "DotSize);\n\n(* Set the current dot size to \"sz\". *)\n\nUI Param(SetD"
 & "otSize, DefaultDotSize);\n\nUI Param(SetDotSize, 0);\n\nUI Param(SetDot"
 & "Size, 0.5);\n\nUI Param(SetDotSize, 1);\n\nUI Param(SetDotSize, 1.5);\n"
 & "\nUI Param(SetDotSize, 2);\n\nUI Param(SetDotSize, 2.5);\n\nUI Param(Se"
 & "tDotSize, 3);\n\nUI Param(SetDotSize, 4);\n\nUI Param(SetDotSize, 5);\n"
 & "\nPROC sz := GetDotSize() IS \n  sz := dotSize \nEND;\n\n(* Set \"sz\" "
 & "to the current dot size. *)\n\nCONST DefaultOffset = 5;\n\n(* This modu"
 & "le maintains a label \n   offset, which is the size in points \n   of a"
 & "ny extra horizontal and \n   vertical space inserted between a \n   poi"
 & "nt and its label. *)\n\nPRIVATE VAR \n  horOffset := DefaultOffset, \n "
 & " verOffset := DefaultOffset;\n\n/* The current label offset. We \n   ma"
 & "intain both a horizontal and \n   vertical offset in case we want to \n"
 & "   generalize the interface to make a \n   distinction between them in "
 & "the \n   future. */\n\nPROC SetOffset(sz) IS \n  horOffset := sz; verOf"
 & "fset := sz \nEND;\n\nUI SetTool(SetOffset);\n\n(* Set the current label"
 & " offset to \n   \"sz\" points. *)\n\nUI Param(SetOffset, DefaultOffset)"
 & ";\n\nUI Param(SetOffset, 0);\n\nUI Param(SetOffset, 2);\n\nUI Param(Set"
 & "Offset, 4);\n\nUI Param(SetOffset, 6);\n\nUI Param(SetOffset, 8);\n\nUI"
 & " Param(SetOffset, 10);\n\nPROC sz := GetOffset() IS \n  sz := horOffset"
 & " \nEND;\n\n(* Set \"sz\" to the current label \n   offset in points. *)"
 & "\n\nPRIVATE PROC DrawDot(p) IS \n  IF \n    dotSize > 0 -> \n      Circ"
 & "le.Draw(p, \n                  R2.Plus(p, \n                          ("
 & "dotSize, 0))); \n      PS.Fill() | SKIP \n  FI \nEND;\n\n/* Draw a roun"
 & "d dot with diameter \n   \"dotSize\" at the point \"p\". This \n  ";

CONST E22_0 = 
   " procedure does not preserve the \n   PostScript state. */\n\nPROC None"
 & "(p) IS \n  SAVE PS IN DrawDot(p) END \nEND;\n\n(* Draw a dot at \"p\" i"
 & "n the current \n   dot size. *)\n\nUI PointTool(None);\n\nPROC SW(p, tx"
 & "t) IS \n  SAVE PS IN \n    DrawDot(p); \n    VAR asc, dec, w IN \n     "
 & " asc, dec := PS.FontHeight(); \n      w := PS.StringWidth(txt); \n     "
 & " PS.Type(R2.Minus(p, \n                       (w + horOffset, \n       "
 & "                 asc)), txt) \n    END \n  END \nEND;\n\nPROC NW(p, txt"
 & ") IS \n  SAVE PS IN \n    DrawDot(p); \n    VAR asc, dec, w IN \n      "
 & "asc, dec := PS.FontHeight(); \n      w := PS.StringWidth(txt); \n      "
 & "PS.Type(R2.Plus(p, \n                      (-w - horOffset, \n         "
 & "              dec + verOffset)), \n              txt) \n    END \n  END"
 & " \nEND;\n\nPROC SE(p, txt) IS \n  SAVE PS IN \n    DrawDot(p); \n    VA"
 & "R asc, dec IN \n      asc, dec := PS.FontHeight(); \n      PS.Type(R2.P"
 & "lus(p, \n                      (verOffset, -asc)), \n              txt)"
 & " \n    END \n  END \nEND;\n\nPROC NE(p, txt) IS \n  SAVE PS IN \n    Dr"
 & "awDot(p); \n    VAR asc, dec IN \n      asc, dec := PS.FontHeight(); \n"
 & "      PS.Type(R2.Plus(p, \n                      (horOffset, \n        "
 & "               verOffset + dec)), \n              txt) \n    END \n  EN"
 & "D \nEND;\n\nPROC East(p, txt) IS \n  SAVE PS IN \n    DrawDot(p); \n   "
 & " VAR asc, dec IN \n      asc, dec := PS.FontHeight(); \n      PS.Type(R"
 & "2.Plus(p, \n                      (2 * horOffset, \n                   "
 & "    (dec - asc) / 2)), \n              txt) \n    END \n  END \nEND;\n\n"
 & "PROC West(p, txt) IS \n  SAVE PS IN \n    DrawDot(p); \n    VAR asc, de"
 & "c, w IN \n      w := PS.StringWidth(txt); \n      asc, dec := PS.FontHe"
 & "ight(); \n      PS.Type(R2.Plus(p, \n                      (-w - \n    "
 & "                   2 * horOffset, \n                       (dec - asc) "
 & "/ 2)), \n              txt) \n    END \n  END \nEND;\n\nPROC North(p, t"
 & "xt) IS \n  SAVE PS IN \n    DrawDot(p); \n    VAR asc, dec, w IN \n    "
 & "  w := PS.StringWidth(txt); \n      asc, dec := PS.FontHeight(); \n    "
 & "  PS.Type(R2.Plus(p, \n                  ";

CONST E22_1 = 
   "    (-w / 2, \n                       dec + verOffset)), \n            "
 & "  txt) \n    END \n  END \nEND;\n\nPROC South(p, txt) IS \n  SAVE PS IN"
 & " \n    DrawDot(p); \n    VAR asc, dec, w IN \n      w := PS.StringWidth"
 & "(txt); \n      asc, dec := PS.FontHeight(); \n      PS.Type(R2.Plus(p, "
 & "\n                      (-w / 2, \n                       -asc - verOff"
 & "set)), \n              txt) \n    END \n  END \nEND;\n\nUI TextTool(SW)"
 & ";\n\nUI TextTool(NW);\n\nUI TextTool(SE);\n\nUI TextTool(NE);\n\nUI Tex"
 & "tTool(East);\n\nUI TextTool(West);\n\nUI TextTool(North);\n\nUI TextToo"
 & "l(South);\n\n(* Draw a dot at \"p\" with label \"txt\". \n   The dot is"
 & " drawn in the current dot \n   size. In each case, the name of the \n  "
 & " procedure indicates the location of \n   the label relative to the dot"
 & ". Both \n   the dot and the label are drawn in \n   the current color. "
 & "*)\n\nPRIVATE VAR history := NIL;\n\nPROC Save() IS \n  history := \n  "
 & "  ([dotSize, horOffset, verOffset], \n     history) \nEND;\n\nPROC Rest"
 & "ore() IS \n  VAR head IN \n    head := CAR(history); \n    dotSize := C"
 & "AR(head); \n    horOffset := CAR(CDR(head)); \n    verOffset := CAR(CDR"
 & "(CDR(head))) \n  END; \n  history := CDR(history) \nEND;\n\nUI PointToo"
 & "l(Save);\n\nUI PointTool(Restore);\n\n(* Save/restore the current dot s"
 & "ize and offsets. \n*)\n\n";

CONST E23 = 
   "(Rim\n  (BgColor \"White\")\n  (Pen 10)\n  (VBox\n    (Pixmap \"Juno2Lo"
 & "go.ppm\")\n    (Glue 5)\n    (Text %version \"\")\n    \"By Allan Heydo"
 & "n and Greg Nelson\"\n    (Glue 5)\n    (Bar 1)\n    (Glue 5)\n    \"htt"
 & "p://www.research.digital.com/SRC/juno-2/\"\n    \"Please send comments "
 & "to gnelson@pa.dec.com\"\n    (Glue 5)\n    (Pixmap \"CompaqLogo.ppm\")\n"
 & "    (Text \"Systems Research Center\")\n  )\n)\n";

CONST E24 = 
   "MODULE Circle;\n\n(* Procedures and predicates for \n   circles. *)\n\n"
 & "IMPORT Math, R2, PS;\n\n(* QUARTER CIRCLES *)\n\n(* A quarter circle is"
 & " defined by its \n   center of curvature \"a\", the \n   current point,"
 & " and a direction \n   (clockwise or counter-clockwise). *)\n\nPRIVATE C"
 & "ONST K = 0.5519149706;\n/* This constant is used to position the contro"
 & "l\n   points for drawing a quarter circle. It was\n   provided by Lyle "
 & "Ramshaw. It produces a Bezier\n   curve approximation to a true quarter"
 & " circle that\n   coincides with the circle at the endpoints and at\n   "
 & "two other points. The Bezier curve starts and ends\n   going outside th"
 & "e circle, but the midpoint of the\n   curve is inside the circle. The w"
 & "orst relative error\n   between the curve and the constant is slightly "
 & "less\n   than 2 parts in 10,000. */\n\nPROC DrawQuarter(a) IS \n  VAR b"
 & " IN \n    b := PS.CurrentPoint(); \n    IF \n      VAR \n        c = (1"
 & ", -K) REL (a, b), \n        d = (K, -1) REL (a, b), \n        e = (0, -"
 & "1) REL (a, b) \n      IN \n        PS.CurveTo(c, d, e) \n      END \n  "
 & "  FI \n  END \nEND;\n\nPROC DrawQuarterCC(a) IS \n  VAR b IN \n    b :="
 & " PS.CurrentPoint(); \n    IF \n      VAR \n        c = (1, K) REL (a, b"
 & "), \n        d = (K, 1) REL (a, b), \n        e = (0, 1) REL (a, b) \n "
 & "     IN \n        PS.CurveTo(c, d, e) \n      END \n    FI \n  END \nEN"
 & "D;\n\nUI PointTool(DrawQuarter);\nUI PointTool(DrawQuarterCC);\n\n(* Ad"
 & "d a clockwise or \n   counter-clockwise quarter-circle, \n   respective"
 & "ly, to the current path. \n   In each case, the quarter-circle \n   sta"
 & "rts at the current point and has \n   center \"a\". *)\n\n(* CIRCLES *)"
 & "\n\n(* A circle \"[a, b]\" is defined by its \n   center \"a\" and a po"
 & "int \"b\" on the \n   circle. *)\n\nPROC Draw(a, b) IS \n  IF \n    VAR"
 & " \n      c ~ (0, -1) REL (a, b), \n      d ~ (-1, 0) REL (a, b), \n    "
 & "  e ~ (0, 1) REL (a, b) \n    IN \n      PS.MoveTo(b); \n      DrawQuar"
 & "ter(a); \n      DrawQuarter(a); \n      DrawQuarter(a); \n      DrawQua"
 & "rter(a); \n      PS.Close() \n    END \n  FI \nEND;\n\nPROC DrawCC(a, b"
 & ") IS \n  IF \n    VAR \n      c ~ (0, 1) RE";

CONST E24_0 = 
   "L (a, b), \n      d ~ (-1, 0) REL (a, b), \n      e ~ (0, -1) REL (a, b"
 & ") \n    IN \n      PS.MoveTo(b); \n      DrawQuarterCC(a); \n      Draw"
 & "QuarterCC(a); \n      DrawQuarterCC(a); \n      DrawQuarterCC(a); \n   "
 & "   PS.Close() \n    END \n  FI \nEND;\n\nUI PointTool(Draw);\nUI PointT"
 & "ool(DrawCC);\n\n(* Add a clockwise or\n   counter-clockwise circle \"[a"
 & ", b]\", \n   respectively, to the current path. \n   The current point "
 & "becomes \"b\". *)\n\nPROC DrawR(c, rad) IS\n  Draw(c, R2.PlusX(c, rad))"
 & "\nEND;\n\nPROC DrawCCR(c, rad) IS\n  DrawCC(c, R2.PlusX(c, rad))\nEND;\n"
 & "\n(* Add a clockwise or counter-clockwise circle,\n   respectively, wit"
 & "h center point \"c\" and a\n   radius of \"r\" points to the current pa"
 & "th. *)\n\nPRED On(p, a, b) IS \n  (a, p) CONG (a, b) \nEND;\n\nUI Point"
 & "Tool(On);\n\n(* The point \"p\" is on the circle \"[a, \n   b]\". *)\n\n"
 & "PRIVATE FUNC r2 = Dist2(a, b) IS \n  (E ax, ay, bx, by, dx, dy :: \n   "
 & " a = (ax, ay) AND \n    b = (bx, by) AND \n    dx = ax - bx AND \n    d"
 & "y = ay - by AND \n    r2 = dx * dx + dy * dy) \nEND;\n\n/* \"r2\" is th"
 & "e square of the distance \n   between the points \"a\" and \"b\". */\n\n"
 & "FUNC res = Area(a, b) IS \n  res = Math.Pi * Dist2(a, b) \nEND;\n\n(* \""
 & "res\" is the area of the circle \n   \"[a, b]\". *)\n\n";

CONST E25 = 
   "MODULE TextList;\n\n(* Procedures for managing lists of \n   texts. *)\n"
 & "\nIMPORT PS, Text, LineSkip;\n\nPRIVATE CONST BigInt = 1e6;\n\nPRIVATE "
 & "VAR \n  LineBreakChar := Text.GetChar(\"\\n\", 0);\n\nPROC l := FromTex"
 & "t(t) IS \n  VAR i IN \n    i := Text.FindChar(t, LineBreakChar); \n    "
 & "IF \n      i = -1 -> l := [t] \n    | l := \n        (Text.Sub(t, 0, i)"
 & ", \n         FromText(Text.Sub(t, \n                           i + 1, \n"
 & "                           BigInt))) \n    FI \n  END \nEND;\n\n(* Sets"
 & " \"l\" to the list of \n   \'\\n\'-separated texts in \"t\". For \n   e"
 & "xample: \n\n|  FromText(\"abc\") => [\"abc\"]\n|  FromText(\"abc\\ndef\""
 & ") => [\"abc\", \"def\"]\n|  FromText(\"a\\n\\nd\\n\") => [\"a\", \"\", "
 & "\"d\", \"\"]\n\n   A checked run-time error occurs \n   if \"t\" is not"
 & " a text. *)\n\nPROC w, h := Size(l) IS \n  VAR len IN \n    len := 0; \n"
 & "    w := 0; \n    DO \n      l # NIL -> \n        w := \n          MAX("
 & "w, \n          PS.StringWidth(CAR(l))); \n        len := len + 1; \n   "
 & "     l := CDR(l) \n    OD; \n    VAR asc, dec IN \n      asc, dec := PS"
 & ".FontHeight(); \n      h := \n        len * (asc + dec) + \n        (le"
 & "n - 1) * LineSkip.Get() \n    END \n  END \nEND;\n\n(* Set \"w\" and \""
 & "h\" to the width and \n   height, respectively, of the \n   bounding bo"
 & "x of the text lines \n   \"l\" printed as by the \n   \"TypeLinesL\" pr"
 & "ocedures in the \n   current font with the current \n   line skip (as m"
 & "aintained by the \n   \"LineSkip\" module. *)\n\nPROC w, h := SizeNoSki"
 & "p(l) IS \n  SAVE LineSkip IN \n    LineSkip.Set(0); w, h := Size(l) \n "
 & " END \nEND;\n\n(* Line \"Size\" above, but uses a \n   line skip value "
 & "of 0. *)\n\n";

CONST E26 = 
   "&%2IL5N5\000\000\000\200$null\000\201\320\032B\345\214\002\n5\001\000U\226"
 & "\303{\303`d\016\010\000\000\0005\001\000\312Q\2211\217U\207\024\000\001"
 & "\000\0000005\001\000\236\207\330\351d3h\0105\001\000\375\r\300V\'\217\375"
 & "\0375\000\027\202\212\303\350n\024\005\007\000\000\000Courier5\007\001\000"
 & "\000\0003\007\000\000\000\001\000\000\000\000\000\000\0005\001\000\022\363"
 & "M\246+B\016\0265\001\0065\001\0065\001\0065\001\0065\007\003\000\000\000"
 & "-*-5\007\020\000\000\000courier-medium-r\003\000\000\000\020\000\000\000"
 & "\000\000\000\0005\007\f\000\000\000-normal-*-*-\023\000\000\000\f\000\000"
 & "\000\000\000\000\0005\007\002\000\000\00014\037\000\000\000\002\000\000"
 & "\000\000\000\000\0005\007\r\000\000\0000-*-*-*-*-*-*!\000\000\000\r\000"
 & "\000\000\000\000\000\000XdXA00005\001\0055\001\0065\007\021\000\000\000"
 & "Helvetica-Oblique5\007\001\000\000\0005\021\000\000\000\001\000\000\000"
 & "\000\000\000\0005\001\0105\001\0065\001\0065\001\0065\001\0061\f\000\000"
 & "\0005\007\022\000\000\000helvetica-medium-o\003\000\000\000\022\000\000"
 & "\000\000\000\000\0001\016\000\000\000\025\000\000\000\f\000\000\000\000"
 & "\000\000\0005\007\002\000\000\00024!\000\000\000\002\000\000\000\000\000"
 & "\000\0001\020\000\000\000#\000\000\000\r\000\000\000\000\000\000\000%y\300"
 & "A0005\001\0055\001\0065\007\023\000\000\000Courier-BoldOblique1\006\000"
 & "\000\000\023\000\000\000\001\000\000\000\000\000\000\0005\001\0105\001\006"
 & "5\001\0065\001\0065\001\0061\f\000\000\0005\007\016\000\000\000courier-"
 & "bold-o\003\000\000\000\016\000\000\000\000\000\000\0001\016\000\000\000"
 & "\021\000\000\000\f\000\000\000\000\000\000\0001\017\000\000\000\035\000"
 & "\000\000\002\000\000\000\000\000\000\0001\020\000\000\000\037\000\000\000"
 & "\r\000\000\000\000\000\000\000XdXA005\001\0055\001\0065\007\025\000\000"
 & "\000Helvetica-BoldOblique5\007\001\000\000\0002\025\000\000\000\001\000"
 & "\000\000\000\000\000\0005\001\0105\001\0065\001\0065\001\0065\001\0061\f"
 & "\000\000\0005\007\020\000\000\000helvetica-bold-o\003\000\000\000\020\000"
 & "\000\000\000\000\000\0001\016\000\000\000\023\000\000\000\f\000\000\000"
 & "\000\000\000\0005\007\002\000\000\00012\037\000\000\000\002\000\000\000"
 & "\000\000\000\0001\020\000\000\000!\000\000\000\r\000\000\000\000\000\000"
 & "\0008\3068A0005\001\0055\001\0065\007\016\000\000\000Helvetica-Bold5\007"
 & "\001\000\000\0004\016\000\000\000\001\000\000\000\000\000\000\0005\001\010"
 & "5\001\0065\001\0065\001\0065\001\0061\f\000\000\0005\007\020\000\000\000"
 & "helvetica-bold-r\003\000\000\000\020\000\000\000\000\000\000\0001\016\000"
 & "\000\000\023\000\000\000\f\000\000\000\000\000\000\0005\007\002\000\000"
 & "\00018\037\000\000\000\002\000\000\000\000\000\000\0001\020\000\000\000"
 & "!\000\000\000\r\000\000\000\000\000\000\000\227G\222A00005\001\0055\001"
 & "\0065\007\n\000\000\000Times-Bold5\007\001\000\000\0000\n\000\000\000\001"
 & "\000\000\000\000\000\000\0005\001\0105\001\0065\001\0065\001\0065\001\006"
 & "1\f\000\000\0005\007\f\000\000\000times-bold-r\003\000\000\000\f\000\000"
 & "\000\000\000\000\0001\016\000\000\000\017\000\000\000\f\000\000\000\000"
 & "\000\000\0005\007\001\000\000\0008\033\000\000\000\001\000\000\000\000\000"
 & "\000\0001\020\000\000\000\034\000\000\000\r\000\000\000\000\000\000\000"
 & "\243\366\344@0005\001\0055\001\0065\007\020\000\000\000Times-BoldItalic"
 & "5\007\001\000\000\0001\020\000\000\000\001\000\000\000\000\000\000\0005"
 & "\001\0105\001\0065\001\0065\001\0065\001\0061\f\000\000\0005\007\f\000\000"
 & "\000times-bold-i\003\000\000\000\f\000\000\000\000\000\000\0001\016\000"
 & "\000\000\017\000\000\000\f\000\000\000\000\000\000\0005\007\002\000\000"
 & "\00010\033\000\000\000\002\000\000\000\000\000\000\0001\020\000\000\000"
 & "\035\000\000\000\r\000\000\000\000\000\000\000\254A%A0000005\001\0055\001"
 & "\0065\007\017\000\000\000Courier-Oblique1I\000\000\000\017\000\000\000\001"
 & "\000\000\000\000\000\000\0005\001\0105\001\0065\001\0065\001\0065\001\006"
 & "1\f\000\000\0005\007\020\000\000\000courier-medium-o\003\000\000\000\020"
 & "\000\000\000\000\000\000\0001\016\000\000\000\023\000\000\000\f\000\000"
 & "\000\000\000\000\0001P\000\000\000\037\000\000\000\002\000\000\000\000\000"
 & "\000\0001\020\000\000\000!\000\000\000\r\000\000\000\000\000\000\000H\f"
 & "1A005\001\0055\001\0065\007\t\000\000\000Helvetica1I\000\000\000\t\000\000"
 & "\000\001\000\000\000\000\000\000\0005\001\0105\001\0065\001\0065\001\006"
 & "5\001\0061\f\000\000\0005\007\022\000\000\000helvetica-medium-r\003\000"
 & "\000\000\022\000\000\000\000\000\000\0001\016\000\000\000\025\000\000\000"
 & "\f\000\000\000\000\000\000\0001P\000\000\000!\000\000\000\002\000\000\000"
 & "\000\000\000\0001\020\000\000\000#\000\000\000\r\000\000\000\000\000\000"
 & "\000^`)A0005\001\0055\001\0065\007\f\000\000\000Courier-Bold1>\000\000\000"
 & "\f\000\000\000\001\000\000\000\000\000\000\0005\001\0105\001\0065\001\006"
 & "5\001\0065\001\0061\f\000\000\0005\007\016\000\000\000courier-bold-r\003"
 & "\000\000\000\016\000\000\000\000\000\000\0001\016\000\000\000\021\000\000"
 & "\000\f\000\000\000\000\000\000\0001E\000\000\000\035\000\000\000\001\000"
 & "\000\000\000\000\000\0001\020\000\000\000\036\000\000\000\r\000\000\000"
 & "\000\000\000\000`\020\354@0000000005\001\0055\001\0061=\000\000\0001\024"
 & "\000\000\000\n\000\000\000\001\000\000\000\000\000\000\0005\001\0105\001"
 & "\0065\001\0065\001\0065\001\0061\f\000\000\0001D\000\000\000\003\000\000"
 & "\000\f\000\000\000\000\000\000\0001\016\000\000\000\017\000\000\000\f\000"
 & "\000\000\000\000\000\0001\033\000\000\000\033\000\000\000\002\000\000\000"
 & "\000\000\000\0001\020\000\000\000\035\000\000\000\r\000\000\000\000\000"
 & "\000\000\274\023\274A005\001\0055\001\0061\023\000\000\0001>\000\000\000"
 & "\021\000\000\000\001\000\000\000\000\000\000\0005\001\0105\001\0065\001"
 & "\0065\001\0065\001\0061\f\000\000\0001\032\000\000\000\003\000\000\000\022"
 & "\000\000\000\000\000\000\0001\016\000\000\000\025\000\000\000\f\000\000"
 & "\000\000\000\000\0001E\000\000\000!\000\000\000\001\000\000\000\000\000"
 & "\000\0001\020\000\000\000\"\000\000\000\r\000\000\000\000\000\000\000\241"
 & "]\366@000000005\001\0055\001\00612\000\000\0001I\000\000\000\016\000\000"
 & "\000\001\000\000\000\000\000\000\0005\001\0105\001\0065\001\0065\001\006"
 & "5\001\0061\f\000\000\000";

CONST E26_0 = 
   "19\000\000\000\003\000\000\000\020\000\000\000\000\000\000\0001\016\000"
 & "\000\000\023\000\000\000\f\000\000\000\000\000\000\0001P\000\000\000\037"
 & "\000\000\000\002\000\000\000\000\000\000\0001\020\000\000\000!\000\000\000"
 & "\r\000\000\000\000\000\000\000^`)A00005\001\0055\001\0061e\000\000\0001"
 & "\024\000\000\000\f\000\000\000\001\000\000\000\000\000\000\0005\001\010"
 & "5\001\0065\001\0065\001\0065\001\0061\f\000\000\0001k\000\000\000\003\000"
 & "\000\000\016\000\000\000\000\000\000\0001\016\000\000\000\021\000\000\000"
 & "\f\000\000\000\000\000\000\0001\033\000\000\000\035\000\000\000\002\000"
 & "\000\000\000\000\000\0001\020\000\000\000\037\000\000\000\r\000\000\000"
 & "\000\000\000\000P\270\304A005\001\0055\001\0065\007\013\000\000\000Time"
 & "s-Roman1\006\000\000\000\013\000\000\000\001\000\000\000\000\000\000\000"
 & "5\001\0105\001\0065\001\0065\001\0065\001\0061\f\000\000\0005\007\016\000"
 & "\000\000times-medium-r\003\000\000\000\016\000\000\000\000\000\000\0001"
 & "\016\000\000\000\021\000\000\000\f\000\000\000\000\000\000\0001\017\000"
 & "\000\000\035\000\000\000\002\000\000\000\000\000\000\0001\020\000\000\000"
 & "\037\000\000\000\r\000\000\000\000\000\000\000\353\032YA05\001\0055\001"
 & "\0061H\000\000\00013\000\000\000\020\000\000\000\001\000\000\000\000\000"
 & "\000\0005\001\0105\001\0065\001\0065\001\0065\001\0061\f\000\000\0001O\000"
 & "\000\000\003\000\000\000\f\000\000\000\000\000\000\0001\016\000\000\000"
 & "\017\000\000\000\f\000\000\000\000\000\000\0001:\000\000\000\033\000\000"
 & "\000\002\000\000\000\000\000\000\0001\020\000\000\000\035\000\000\000\r"
 & "\000\000\000\000\000\000\000\322w\214A5\001\0055\001\0065\007\f\000\000"
 & "\000Times-Italic1(\000\000\000\f\000\000\000\001\000\000\000\000\000\000"
 & "\0005\001\0105\001\0065\001\0065\001\0065\001\0061\f\000\000\0005\007\016"
 & "\000\000\000times-medium-i\003\000\000\000\016\000\000\000\000\000\000\000"
 & "1\016\000\000\000\021\000\000\000\f\000\000\000\000\000\000\0001/\000\000"
 & "\000\035\000\000\000\002\000\000\000\000\000\000\0001\020\000\000\000\037"
 & "\000\000\000\r\000\000\000\000\000\000\000|<:A00005\001\0055\001\0061\005"
 & "\000\000\0001\024\000\000\000\007\000\000\000\001\000\000\000\000\000\000"
 & "\0005\001\0105\001\0065\001\0065\001\0065\001\0061\f\000\000\0001\r\000"
 & "\000\000\003\000\000\000\020\000\000\000\000\000\000\0001\016\000\000\000"
 & "\023\000\000\000\f\000\000\000\000\000\000\0001\033\000\000\000\037\000"
 & "\000\000\002\000\000\000\000\000\000\0001\020\000\000\000!\000\000\000\r"
 & "\000\000\000\000\000\000\000L\342\272A00000005\001\0055\001\0061\036\000"
 & "\000\0001I\000\000\000\023\000\000\000\001\000\000\000\000\000\000\0005"
 & "\001\0105\001\0065\001\0065\001\0065\001\0061\f\000\000\0001$\000\000\000"
 & "\003\000\000\000\016\000\000\000\000\000\000\0001\016\000\000\000\021\000"
 & "\000\000\f\000\000\000\000\000\000\0001P\000\000\000\035\000\000\000\002"
 & "\000\000\000\000\000\000\0001\020\000\000\000\037\000\000\000\r\000\000"
 & "\000\000\000\000\000H\f1A005\001\0055\001\0065\007\006\000\000\000Symbo"
 & "l1(\000\000\000\006\000\000\000\001\000\000\000\000\000\000\0005\001\010"
 & "5\001\0065\001\0065\001\0065\001\0061\f\000\000\0005\007\017\000\000\000"
 & "symbol-medium-r\003\000\000\000\017\000\000\000\000\000\000\0001\016\000"
 & "\000\000\022\000\000\000\f\000\000\000\000\000\000\0001/\000\000\000\036"
 & "\000\000\000\002\000\000\000\000\000\000\0001\020\000\000\000 \000\000\000"
 & "\r\000\000\000\000\000\000\000\247\2634A000000005\001\0055\001\0061=\000"
 & "\000\0001(\000\000\000\n\000\000\000\001\000\000\000\000\000\000\0005\001"
 & "\0105\001\0065\001\0065\001\0065\001\0061\f\000\000\0001D\000\000\000\003"
 & "\000\000\000\f\000\000\000\000\000\000\0001\016\000\000\000\017\000\000"
 & "\000\f\000\000\000\000\000\000\0001/\000\000\000\033\000\000\000\002\000"
 & "\000\000\000\000\000\0001\020\000\000\000\035\000\000\000\r\000\000\000"
 & "\000\000\000\000[\3463A05\001\0055\001\0061\212\000\000\00013\000\000\000"
 & "\013\000\000\000\001\000\000\000\000\000\000\0005\001\0105\001\0065\001"
 & "\0065\001\0065\001\0061\f\000\000\0001\220\000\000\000\003\000\000\000\016"
 & "\000\000\000\000\000\000\0001\016\000\000\000\021\000\000\000\f\000\000"
 & "\000\000\000\000\0001:\000\000\000\035\000\000\000\002\000\000\000\000\000"
 & "\000\0001\020\000\000\000\037\000\000\000\r\000\000\000\000\000\000\000"
 & "\020\364\215A0000005\001\0055\001\0061\'\000\000\00013\000\000\000\025\000"
 & "\000\000\001\000\000\000\000\000\000\0005\001\0105\001\0065\001\0065\001"
 & "\0065\001\0061\f\000\000\0001.\000\000\000\003\000\000\000\020\000\000\000"
 & "\000\000\000\0001\016\000\000\000\023\000\000\000\f\000\000\000\000\000"
 & "\000\0001:\000\000\000\037\000\000\000\002\000\000\000\000\000\000\0001"
 & "\020\000\000\000!\000\000\000\r\000\000\000\000\000\000\000\227G\222A00"
 & "5\001\0055\001\0061S\000\000\0001\006\000\000\000\017\000\000\000\001\000"
 & "\000\000\000\000\000\0005\001\0105\001\0065\001\0065\001\0065\001\0061\f"
 & "\000\000\0001Y\000\000\000\003\000\000\000\020\000\000\000\000\000\000\000"
 & "1\016\000\000\000\023\000\000\000\f\000\000\000\000\000\000\0001\017\000"
 & "\000\000\037\000\000\000\002\000\000\000\000\000\000\0001\020\000\000\000"
 & "!\000\000\000\r\000\000\000\000\000\000\000XdXA5\001\0055\001\00612\000"
 & "\000\0001(\000\000\000\016\000\000\000\001\000\000\000\000\000\000\0005"
 & "\001\0105\001\0065\001\0065\001\0065\001\0061\f\000\000\00019\000\000\000"
 & "\003\000\000\000\020\000\000\000\000\000\000\0001\016\000\000\000\023\000"
 & "\000\000\f\000\000\000\000\000\000\0001/\000\000\000\037\000\000\000\002"
 & "\000\000\000\000\000\000\0001\020\000\000\000!\000\000\000\r\000\000\000"
 & "\000\000\000\0008\3068A005\001\0055\001\0061\\\000\000\0001\006\000\000"
 & "\000\t\000\000\000\001\000\000\000\000\000\000\0005\001\0105\001\0065\001"
 & "\0065\001\0065\001\0061\f\000\000\0001b\000\000\000\003\000\000\000\022"
 & "\000\000\000\000\000\000\0001\016\000\000\000\025\000\000\000\f\000\000"
 & "\000\000\000\000\0001\017\000\000\000!\000\000\000\002\000\000\000\000\000"
 & "\000\0001\020\000\000\000#\000\000\000\r\000\000\000\000\000\000\000\355"
 & "\221WA005\001\0055\001\0061\036\000\000\00013\000\000\000\023\000\000\000"
 & "\001\000\000\000\000\000\000\0005\001\0105\001\0065\001\0065\001\0065\001"
 & "\0061\f\000\000\0001$\000\000\000\003\000\000\000\016\000\000\000\000\000"
 & "\000\0001\016\000\000\000\021\000\000\000\f\000\000\000\000\000\000\000"
 & "1:\000\000\000\035\000\000\000\002\000\000\000\000\000\000\0001\020\000"
 & "\000\000\037\000\000\000\r\000\000\000\000\000\000\000<\212\223A5\001\005"
 & "5\001\0061e\000\000\0001(\000\000\000\f\000\000\000\001\000\000\000\000"
 & "\000\000\0005\001\0105\001\0065\001\0065\001\0065\001\0061\f\000\000\000"
 & "1k\000\000\000\003\000\000\000\016\000\000\000\000\000\000\0001\016\000"
 & "\000\000\021\000\000\000\f\000\000\000\000\000\000\0001/\000\000\000\035"
 & "\000\000\000\002\000\000\000\000\000\000\0001\020\000\000\000\037\000\000"
 & "\000\r\000\000\000\000\000\000\000P\270DA005\001\0055\001\0061";

CONST E26_1 = 
   "\261\000\000\0001\024\000\000\000\006\000\000\000\001\000\000\000\000\000"
 & "\000\0005\001\0105\001\0065\001\0065\001\0065\001\0061\f\000\000\0001\267"
 & "\000\000\000\003\000\000\000\017\000\000\000\000\000\000\0001\016\000\000"
 & "\000\022\000\000\000\f\000\000\000\000\000\000\0001\033\000\000\000\036"
 & "\000\000\000\002\000\000\000\000\000\000\0001\020\000\000\000 \000\000\000"
 & "\r\000\000\000\000\000\000\000]\352\274A05\001\0055\001\0061\232\000\000"
 & "\0001I\000\000\000\f\000\000\000\001\000\000\000\000\000\000\0005\001\010"
 & "5\001\0065\001\0065\001\0065\001\0061\f\000\000\0001\240\000\000\000\003"
 & "\000\000\000\016\000\000\000\000\000\000\0001\016\000\000\000\021\000\000"
 & "\000\f\000\000\000\000\000\000\0001P\000\000\000\035\000\000\000\002\000"
 & "\000\000\000\000\000\0001\020\000\000\000\037\000\000\000\r\000\000\000"
 & "\000\000\000\000BN)A00005\001\0055\001\0061\005\000\000\0001>\000\000\000"
 & "\007\000\000\000\001\000\000\000\000\000\000\0005\001\0105\001\0065\001"
 & "\0065\001\0065\001\0061\f\000\000\0001\r\000\000\000\003\000\000\000\020"
 & "\000\000\000\000\000\000\0001\016\000\000\000\023\000\000\000\f\000\000"
 & "\000\000\000\000\0001E\000\000\000\037\000\000\000\001\000\000\000\000\000"
 & "\000\0001\020\000\000\000 \000\000\000\r\000\000\000\000\000\000\000`\020"
 & "\354@00005\001\0055\001\0061\023\000\000\0001(\000\000\000\021\000\000\000"
 & "\001\000\000\000\000\000\000\0005\001\0105\001\0065\001\0065\001\0065\001"
 & "\0061\f\000\000\0001\032\000\000\000\003\000\000\000\022\000\000\000\000"
 & "\000\000\0001\016\000\000\000\025\000\000\000\f\000\000\000\000\000\000"
 & "\0001/\000\000\000!\000\000\000\002\000\000\000\000\000\000\0001\020\000"
 & "\000\000#\000\000\000\r\000\000\000\000\000\000\0008\3068A0000005\001\005"
 & "5\001\0061\'\000\000\0001I\000\000\000\025\000\000\000\001\000\000\000\000"
 & "\000\000\0005\001\0105\001\0065\001\0065\001\0065\001\0061\f\000\000\000"
 & "1.\000\000\000\003\000\000\000\020\000\000\000\000\000\000\0001\016\000"
 & "\000\000\023\000\000\000\f\000\000\000\000\000\000\0001P\000\000\000\037"
 & "\000\000\000\002\000\000\000\000\000\000\0001\020\000\000\000!\000\000\000"
 & "\r\000\000\000\000\000\000\000^`)A0000000005\001\0055\001\0061\232\000\000"
 & "\00013\000\000\000\f\000\000\000\001\000\000\000\000\000\000\0005\001\010"
 & "5\001\0065\001\0065\001\0065\001\0061\f\000\000\0001\240\000\000\000\003"
 & "\000\000\000\016\000\000\000\000\000\000\0001\016\000\000\000\021\000\000"
 & "\000\f\000\000\000\000\000\000\0001:\000\000\000\035\000\000\000\002\000"
 & "\000\000\000\000\000\0001\020\000\000\000\037\000\000\000\r\000\000\000"
 & "\000\000\000\000\354\350\217A5\001\0055\001\0061\212\000\000\0001I\000\000"
 & "\000\013\000\000\000\001\000\000\000\000\000\000\0005\001\0105\001\0065"
 & "\001\0065\001\0065\001\0061\f\000\000\0001\220\000\000\000\003\000\000\000"
 & "\016\000\000\000\000\000\000\0001\016\000\000\000\021\000\000\000\f\000"
 & "\000\000\000\000\000\0001P\000\000\000\035\000\000\000\002\000\000\000\000"
 & "\000\000\0001\020\000\000\000\037\000\000\000\r\000\000\000\000\000\000"
 & "\000\004\001\'A05\001\0055\001\0061H\000\000\0001(\000\000\000\020\000\000"
 & "\000\001\000\000\000\000\000\000\0005\001\0105\001\0065\001\0065\001\006"
 & "5\001\0061\f\000\000\0001O\000\000\000\003\000\000\000\f\000\000\000\000"
 & "\000\000\0001\016\000\000\000\017\000\000\000\f\000\000\000\000\000\000"
 & "\0001/\000\000\000\033\000\000\000\002\000\000\000\000\000\000\0001\020"
 & "\000\000\000\035\000\000\000\r\000\000\000\000\000\000\000=\3105A000000"
 & "5\001\0055\001\0061S\000\000\0001>\000\000\000\017\000\000\000\001\000\000"
 & "\000\000\000\000\0005\001\0105\001\0065\001\0065\001\0065\001\0061\f\000"
 & "\000\0001Y\000\000\000\003\000\000\000\020\000\000\000\000\000\000\0001"
 & "\016\000\000\000\023\000\000\000\f\000\000\000\000\000\000\0001E\000\000"
 & "\000\037\000\000\000\001\000\000\000\000\000\000\0001\020\000\000\000 \000"
 & "\000\000\r\000\000\000\000\000\000\000`\020\354@005\001\0055\001\0061\\"
 & "\000\000\0001>\000\000\000\t\000\000\000\001\000\000\000\000\000\000\000"
 & "5\001\0105\001\0065\001\0065\001\0065\001\0061\f\000\000\0001b\000\000\000"
 & "\003\000\000\000\022\000\000\000\000\000\000\0001\016\000\000\000\025\000"
 & "\000\000\f\000\000\000\000\000\000\0001E\000\000\000!\000\000\000\001\000"
 & "\000\000\000\000\000\0001\020\000\000\000\"\000\000\000\r\000\000\000\000"
 & "\000\000\000\241]\366@000005\001\0055\001\0061\261\000\000\0001>\000\000"
 & "\000\006\000\000\000\001\000\000\000\000\000\000\0005\001\0105\001\0065"
 & "\001\0065\001\0065\001\0061\f\000\000\0001\267\000\000\000\003\000\000\000"
 & "\017\000\000\000\000\000\000\0001\016\000\000\000\022\000\000\000\f\000"
 & "\000\000\000\000\000\0001E\000\000\000\036\000\000\000\001\000\000\000\000"
 & "\000\000\0001\020\000\000\000\037\000\000\000\r\000\000\000\000\000\000"
 & "\000\354\373\345@00000005\001\0055\001\0061=\000\000\00013\000\000\000\n"
 & "\000\000\000\001\000\000\000\000\000\000\0005\001\0105\001\0065\001\006"
 & "5\001\0065\001\0061\f\000\000\0001D\000\000\000\003\000\000\000\f\000\000"
 & "\000\000\000\000\0001\016\000\000\000\017\000\000\000\f\000\000\000\000"
 & "\000\000\0001:\000\000\000\033\000\000\000\002\000\000\000\000\000\000\000"
 & "1\020\000\000\000\035\000\000\000\r\000\000\000\000\000\000\000u\003\213"
 & "A005\001\0055\001\0061\023\000\000\0001I\000\000\000\021\000\000\000\001"
 & "\000\000\000\000\000\000\0005\001\0105\001\0065\001\0065\001\0065\001\006"
 & "1\f\000\000\0001\032\000\000\000\003\000\000\000\022\000\000\000\000\000"
 & "\000\0001\016\000\000\000\025\000\000\000\f\000\000\000\000\000\000\000"
 & "1P\000\000\000!\000\000\000\002\000\000\000\000\000\000\0001\020\000\000"
 & "\000#\000\000\000\r\000\000\000\000\000\000\000^`)A00000005\001\0055\001"
 & "\0061S\000\000\0001\024\000\000\000\017\000\000\000\001\000\000\000\000"
 & "\000\000\0005\001\0105\001\0065\001\0065\001\0065\001\0061\f\000\000\000"
 & "1Y\000\000\000\003\000\000\000\020\000\000\000\000\000\000\0001\016\000"
 & "\000\000\023\000\000\000\f\000\000\000\000\000\000\0001\033\000\000\000"
 & "\037\000\000\000\002\000\000\000\000\000\000\0001\020\000\000\000!\000\000"
 & "\000\r\000\000\000\000\000\000\000L\342\272A05\001\0055\001\00612\000\000"
 & "\0001>\000\000\000\016\000\000\000\001\000\000\000\000\000\000\0005\001"
 & "\0105\001\0065\001\0065\001\0065\001\0061\f\000\000\00019\000\000\000\003"
 & "\000\000\000\020\000\000\000\000\000\000\0001\016\000\000\000\023\000\000"
 & "\000\f\000\000\000\000\000\000\0001E\000\000\000\037\000\000\000\001\000"
 & "\000\000\000\000\000\0001\020\000\000\000 \000\000\000\r\000\000\000\000"
 & "\000\000\000\241]\366@05\001\0055\001\0061\\\000\000\0001\024\000\000\000"
 & "\t\000\000\000\001\000\000\000\000\000\000\0005\001\0105\001\0065\001\006"
 & "5\001\0065\001\0061\f\000\000\0001b\000\000\000\003\000\000\000\022\000"
 & "\000\000\000\000\000\0001\016\000\000\000\025\000\000\000\f\000\000\000"
 & "\000\000\000\0001\033\000\000\000!\000\000\000\002\000\000\000\000\000\000"
 & "\0001\020\000\000\000#\000\000\000\r\000\000\000\000\000\000\000%y\300A"
 & "005\001\0055\001\0061e\000\000\00013\000\000\000\f\000\000\000\001\000\000"
 & "\000\000\000\000\0005";

CONST E26_2 = 
   "\001\0105\001\0065\001\0065\001\0065\001\0061\f\000\000\0001k\000\000\000"
 & "\003\000\000\000\016\000\000\000\000\000\000\0001\016\000\000\000\021\000"
 & "\000\000\f\000\000\000\000\000\000\0001:\000\000\000\035\000\000\000\002"
 & "\000\000\000\000\000\000\0001\020\000\000\000\037\000\000\000\r\000\000"
 & "\000\000\000\000\000<\212\223A0005\001\0055\001\0061\212\000\000\0001(\000"
 & "\000\000\013\000\000\000\001\000\000\000\000\000\000\0005\001\0105\001\006"
 & "5\001\0065\001\0065\001\0061\f\000\000\0001\220\000\000\000\003\000\000"
 & "\000\016\000\000\000\000\000\000\0001\016\000\000\000\021\000\000\000\f"
 & "\000\000\000\000\000\000\0001/\000\000\000\035\000\000\000\002\000\000\000"
 & "\000\000\000\0001\020\000\000\000\037\000\000\000\r\000\000\000\000\000"
 & "\000\000Q\2647A05\001\0055\001\0061H\000\000\0001\024\000\000\000\020\000"
 & "\000\000\001\000\000\000\000\000\000\0005\001\0105\001\0065\001\0065\001"
 & "\0065\001\0061\f\000\000\0001O\000\000\000\003\000\000\000\f\000\000\000"
 & "\000\000\000\0001\016\000\000\000\017\000\000\000\f\000\000\000\000\000"
 & "\000\0001\033\000\000\000\033\000\000\000\002\000\000\000\000\000\000\000"
 & "1\020\000\000\000\035\000\000\000\r\000\000\000\000\000\000\000\206\013"
 & "\276A5\001\0055\001\0061\232\000\000\0001\006\000\000\000\f\000\000\000"
 & "\001\000\000\000\000\000\000\0005\001\0105\001\0065\001\0065\001\0065\001"
 & "\0061\f\000\000\0001\240\000\000\000\003\000\000\000\016\000\000\000\000"
 & "\000\000\0001\016\000\000\000\021\000\000\000\f\000\000\000\000\000\000"
 & "\0001\017\000\000\000\035\000\000\000\002\000\000\000\000\000\000\0001\020"
 & "\000\000\000\037\000\000\000\r\000\000\000\000\000\000\000\360\030\\A00"
 & "005\001\0055\001\0061\005\000\000\0001(\000\000\000\007\000\000\000\001"
 & "\000\000\000\000\000\000\0005\001\0105\001\0065\001\0065\001\0065\001\006"
 & "1\f\000\000\0001\r\000\000\000\003\000\000\000\020\000\000\000\000\000\000"
 & "\0001\016\000\000\000\023\000\000\000\f\000\000\000\000\000\000\0001/\000"
 & "\000\000\037\000\000\000\002\000\000\000\000\000\000\0001\020\000\000\000"
 & "!\000\000\000\r\000\000\000\000\000\000\000P\270DA00005\001\0055\001\006"
 & "1\023\000\000\00013\000\000\000\021\000\000\000\001\000\000\000\000\000"
 & "\000\0005\001\0105\001\0065\001\0065\001\0065\001\0061\f\000\000\0001\032"
 & "\000\000\000\003\000\000\000\022\000\000\000\000\000\000\0001\016\000\000"
 & "\000\025\000\000\000\f\000\000\000\000\000\000\0001:\000\000\000!\000\000"
 & "\000\002\000\000\000\000\000\000\0001\020\000\000\000#\000\000\000\r\000"
 & "\000\000\000\000\000\000\227G\222A0005\001\0055\001\0061\036\000\000\000"
 & "1(\000\000\000\023\000\000\000\001\000\000\000\000\000\000\0005\001\010"
 & "5\001\0065\001\0065\001\0065\001\0061\f\000\000\0001$\000\000\000\003\000"
 & "\000\000\016\000\000\000\000\000\000\0001\016\000\000\000\021\000\000\000"
 & "\f\000\000\000\000\000\000\0001/\000\000\000\035\000\000\000\002\000\000"
 & "\000\000\000\000\0001\020\000\000\000\037\000\000\000\r\000\000\000\000"
 & "\000\000\000P\270DA005\001\0055\001\0061\261\000\000\0001\006\000\000\000"
 & "\006\000\000\000\001\000\000\000\000\000\000\0005\001\0105\001\0065\001"
 & "\0065\001\0065\001\0061\f\000\000\0001\267\000\000\000\003\000\000\000\017"
 & "\000\000\000\000\000\000\0001\016\000\000\000\022\000\000\000\f\000\000"
 & "\000\000\000\000\0001\017\000\000\000\036\000\000\000\002\000\000\000\000"
 & "\000\000\0001\020\000\000\000 \000\000\000\r\000\000\000\000\000\000\000"
 & "\177\216UA5\001\0055\001\0061\'\000\000\0001\006\000\000\000\025\000\000"
 & "\000\001\000\000\000\000\000\000\0005\001\0105\001\0065\001\0065\001\006"
 & "5\001\0061\f\000\000\0001.\000\000\000\003\000\000\000\020\000\000\000\000"
 & "\000\000\0001\016\000\000\000\023\000\000\000\f\000\000\000\000\000\000"
 & "\0001\017\000\000\000\037\000\000\000\002\000\000\000\000\000\000\0001\020"
 & "\000\000\000!\000\000\000\r\000\000\000\000\000\000\000\355\221WA0005\001"
 & "\0055\001\00612\000\000\0001\024\000\000\000\016\000\000\000\001\000\000"
 & "\000\000\000\000\0005\001\0105\001\0065\001\0065\001\0065\001\0061\f\000"
 & "\000\00019\000\000\000\003\000\000\000\020\000\000\000\000\000\000\0001"
 & "\016\000\000\000\023\000\000\000\f\000\000\000\000\000\000\0001\033\000"
 & "\000\000\037\000\000\000\002\000\000\000\000\000\000\0001\020\000\000\000"
 & "!\000\000\000\r\000\000\000\000\000\000\000%y\300A00005\001\0055\001\006"
 & "1=\000\000\0001I\000\000\000\n\000\000\000\001\000\000\000\000\000\000\000"
 & "5\001\0105\001\0065\001\0065\001\0065\001\0061\f\000\000\0001D\000\000\000"
 & "\003\000\000\000\f\000\000\000\000\000\000\0001\016\000\000\000\017\000"
 & "\000\000\f\000\000\000\000\000\000\0001P\000\000\000\033\000\000\000\002"
 & "\000\000\000\000\000\000\0001\020\000\000\000\035\000\000\000\r\000\000"
 & "\000\000\000\000\000\231\213#A0005\001\0055\001\0061H\000\000\0001>\000"
 & "\000\000\020\000\000\000\001\000\000\000\000\000\000\0005\001\0105\001\006"
 & "5\001\0065\001\0065\001\0061\f\000\000\0001O\000\000\000\003\000\000\000"
 & "\f\000\000\000\000\000\000\0001\016\000\000\000\017\000\000\000\f\000\000"
 & "\000\000\000\000\0001E\000\000\000\033\000\000\000\001\000\000\000\000\000"
 & "\000\0001\020\000\000\000\034\000\000\000\r\000\000\000\000\000\000\000"
 & "\360[\347@0000005\001\0055\001\0061S\000\000\0001(\000\000\000\017\000\000"
 & "\000\001\000\000\000\000\000\000\0005\001\0105\001\0065\001\0065\001\006"
 & "5\001\0061\f\000\000\0001Y\000\000\000\003\000\000\000\020\000\000\000\000"
 & "\000\000\0001\016\000\000\000\023\000\000\000\f\000\000\000\000\000\000"
 & "\0001/\000\000\000\037\000\000\000\002\000\000\000\000\000\000\0001\020"
 & "\000\000\000!\000\000\000\r\000\000\000\000\000\000\000P\270DA005\001\005"
 & "5\001\0061\\\000\000\0001(\000\000\000\t\000\000\000\001\000\000\000\000"
 & "\000\000\0005\001\0105\001\0065\001\0065\001\0065\001\0061\f\000\000\000"
 & "1b\000\000\000\003\000\000\000\022\000\000\000\000\000\000\0001\016\000"
 & "\000\000\025\000\000\000\f\000\000\000\000\000\000\0001/\000\000\000!\000"
 & "\000\000\002\000\000\000\000\000\000\0001\020\000\000\000#\000\000\000\r"
 & "\000\000\000\000\000\000\0008\3068A0005\001\0055\001\0061\036\000\000\000"
 & "1\024\000\000\000\023\000\000\000\001\000\000\000\000\000\000\0005\001\010"
 & "5\001\0065\001\0065\001\0065\001\0061\f\000\000\0001$\000\000\000\003\000"
 & "\000\000\016\000\000\000\000\000\000\0001\016\000\000\000\021\000\000\000"
 & "\f\000\000\000\000\000\000\0001\033\000\000\000\035\000\000\000\002\000"
 & "\000\000\000\000\000\0001\020\000\000\000\037\000\000\000\r\000\000\000"
 & "\000\000\000\000P\270\304A5\001\0055\001\0061e\000\000\0001I\000\000\000"
 & "\f\000\000\000\001\000\000\000\000\000\000\0005\001\0105\001\0065\001\006"
 & "5\001\0065\001\0061\f\000\000\0001k\000\000\000\003\000\000\000\016\000"
 & "\000\000\000\000\000\0001\016\000\000\000\021\000\000\000\f\000\000\000"
 & "\000\000\000\0001P\000\000\000\035\000\000\000\002\000\000\000\000\000\000"
 & "\0001\020\000\000\000\037\000\000\000\r\000\000\000\000\000\000\000H\f1"
 & "A00000005\001\0055\001\0061\005\000\000\0001I\000\000\000\007\000\000\000"
 & "\001\000\000\000\000\000\000\0005\001\0105\001\0065\001\0065\001\0065\001"
 & "\0061\f\000\000\0001\r\000\000\000\003\000\000\000\020\000\000\000\000\000"
 & "\000";

CONST E26_3 = 
   "\0001\016\000\000\000\023\000\000\000\f\000\000\000\000\000\000\0001P\000"
 & "\000\000\037\000\000\000\002\000\000\000\000\000\000\0001\020\000\000\000"
 & "!\000\000\000\r\000\000\000\000\000\000\000H\f1A00005\001\0055\001\0061"
 & "\023\000\000\0001\006\000\000\000\021\000\000\000\001\000\000\000\000\000"
 & "\000\0005\001\0105\001\0065\001\0065\001\0065\001\0061\f\000\000\0001\032"
 & "\000\000\000\003\000\000\000\022\000\000\000\000\000\000\0001\016\000\000"
 & "\000\025\000\000\000\f\000\000\000\000\000\000\0001\017\000\000\000!\000"
 & "\000\000\002\000\000\000\000\000\000\0001\020\000\000\000#\000\000\000\r"
 & "\000\000\000\000\000\000\000\355\221WA0000005\001\0055\001\0061\'\000\000"
 & "\0001>\000\000\000\025\000\000\000\001\000\000\000\000\000\000\0005\001"
 & "\0105\001\0065\001\0065\001\0065\001\0061\f\000\000\0001.\000\000\000\003"
 & "\000\000\000\020\000\000\000\000\000\000\0001\016\000\000\000\023\000\000"
 & "\000\f\000\000\000\000\000\000\0001E\000\000\000\037\000\000\000\001\000"
 & "\000\000\000\000\000\0001\020\000\000\000 \000\000\000\r\000\000\000\000"
 & "\000\000\000\241]\366@0000000005\001\0055\001\0061\232\000\000\0001\024"
 & "\000\000\000\f\000\000\000\001\000\000\000\000\000\000\0005\001\0105\001"
 & "\0065\001\0065\001\0065\001\0061\f\000\000\0001\240\000\000\000\003\000"
 & "\000\000\016\000\000\000\000\000\000\0001\016\000\000\000\021\000\000\000"
 & "\f\000\000\000\000\000\000\0001\033\000\000\000\035\000\000\000\002\000"
 & "\000\000\000\000\000\0001\020\000\000\000\037\000\000\000\r\000\000\000"
 & "\000\000\000\000\231\263\302A5\001\0055\001\0061\212\000\000\0001>\000\000"
 & "\000\013\000\000\000\001\000\000\000\000\000\000\0005\001\0105\001\0065"
 & "\001\0065\001\0065\001\0061\f\000\000\0001\220\000\000\000\003\000\000\000"
 & "\016\000\000\000\000\000\000\0001\016\000\000\000\021\000\000\000\f\000"
 & "\000\000\000\000\000\0001E\000\000\000\035\000\000\000\001\000\000\000\000"
 & "\000\000\0001\020\000\000\000\036\000\000\000\r\000\000\000\000\000\000"
 & "\0008\316\351@05\001\0055\001\0061H\000\000\0001\006\000\000\000\020\000"
 & "\000\000\001\000\000\000\000\000\000\0005\001\0105\001\0065\001\0065\001"
 & "\0065\001\0061\f\000\000\0001O\000\000\000\003\000\000\000\f\000\000\000"
 & "\000\000\000\0001\016\000\000\000\017\000\000\000\f\000\000\000\000\000"
 & "\000\0001\017\000\000\000\033\000\000\000\002\000\000\000\000\000\000\000"
 & "1\020\000\000\000\035\000\000\000\r\000\000\000\000\000\000\000_\325VA0"
 & "005\001\0055\001\0061\005\000\000\00013\000\000\000\007\000\000\000\001"
 & "\000\000\000\000\000\000\0005\001\0105\001\0065\001\0065\001\0065\001\006"
 & "1\f\000\000\0001\r\000\000\000\003\000\000\000\020\000\000\000\000\000\000"
 & "\0001\016\000\000\000\023\000\000\000\f\000\000\000\000\000\000\0001:\000"
 & "\000\000\037\000\000\000\002\000\000\000\000\000\000\0001\020\000\000\000"
 & "!\000\000\000\r\000\000\000\000\000\000\0008\264\211A00000005\001\0055\001"
 & "\0061\036\000\000\0001>\000\000\000\023\000\000\000\001\000\000\000\000"
 & "\000\000\0005\001\0105\001\0065\001\0065\001\0065\001\0061\f\000\000\000"
 & "1$\000\000\000\003\000\000\000\016\000\000\000\000\000\000\0001\016\000"
 & "\000\000\021\000\000\000\f\000\000\000\000\000\000\0001E\000\000\000\035"
 & "\000\000\000\001\000\000\000\000\000\000\0001\020\000\000\000\036\000\000"
 & "\000\r\000\000\000\000\000\000\000`\020\354@0005\001\0055\001\0061\261\000"
 & "\000\0001I\000\000\000\006\000\000\000\001\000\000\000\000\000\000\0005"
 & "\001\0105\001\0065\001\0065\001\0065\001\0061\f\000\000\0001\267\000\000"
 & "\000\003\000\000\000\017\000\000\000\000\000\000\0001\016\000\000\000\022"
 & "\000\000\000\f\000\000\000\000\000\000\0001P\000\000\000\036\000\000\000"
 & "\002\000\000\000\000\000\000\0001\020\000\000\000 \000\000\000\r\000\000"
 & "\000\000\000\000\000;F$A00000005\001\0055\001\0061=\000\000\0001\006\000"
 & "\000\000\n\000\000\000\001\000\000\000\000\000\000\0005\001\0105\001\006"
 & "5\001\0065\001\0065\001\0061\f\000\000\0001D\000\000\000\003\000\000\000"
 & "\f\000\000\000\000\000\000\0001\016\000\000\000\017\000\000\000\f\000\000"
 & "\000\000\000\000\0001\017\000\000\000\033\000\000\000\002\000\000\000\000"
 & "\000\000\0001\020\000\000\000\035\000\000\000\r\000\000\000\000\000\000"
 & "\000\340\233TA005\001\0055\001\0061\212\000\000\0001\024\000\000\000\013"
 & "\000\000\000\001\000\000\000\000\000\000\0005\001\0105\001\0065\001\006"
 & "5\001\0065\001\0061\f\000\000\0001\220\000\000\000\003\000\000\000\016\000"
 & "\000\000\000\000\000\0001\016\000\000\000\021\000\000\000\f\000\000\000"
 & "\000\000\000\0001\033\000\000\000\035\000\000\000\002\000\000\000\000\000"
 & "\000\0001\020\000\000\000\037\000\000\000\r\000\000\000\000\000\000\000"
 & "\367\r\300A000005\001\0055\001\0061\'\000\000\0001\024\000\000\000\025\000"
 & "\000\000\001\000\000\000\000\000\000\0005\001\0105\001\0065\001\0065\001"
 & "\0065\001\0061\f\000\000\0001.\000\000\000\003\000\000\000\020\000\000\000"
 & "\000\000\000\0001\016\000\000\000\023\000\000\000\f\000\000\000\000\000"
 & "\000\0001\033\000\000\000\037\000\000\000\002\000\000\000\000\000\000\000"
 & "1\020\000\000\000!\000\000\000\r\000\000\000\000\000\000\000%y\300A005\001"
 & "\0055\001\0061S\000\000\00013\000\000\000\017\000\000\000\001\000\000\000"
 & "\000\000\000\0005\001\0105\001\0065\001\0065\001\0065\001\0061\f\000\000"
 & "\0001Y\000\000\000\003\000\000\000\020\000\000\000\000\000\000\0001\016"
 & "\000\000\000\023\000\000\000\f\000\000\000\000\000\000\0001:\000\000\000"
 & "\037\000\000\000\002\000\000\000\000\000\000\0001\020\000\000\000!\000\000"
 & "\000\r\000\000\000\000\000\000\0008\264\211A5\001\0055\001\00612\000\000"
 & "\0001\006\000\000\000\016\000\000\000\001\000\000\000\000\000\000\0005\001"
 & "\0105\001\0065\001\0065\001\0065\001\0061\f\000\000\00019\000\000\000\003"
 & "\000\000\000\020\000\000\000\000\000\000\0001\016\000\000\000\023\000\000"
 & "\000\f\000\000\000\000\000\000\0001\017\000\000\000\037\000\000\000\002"
 & "\000\000\000\000\000\000\0001\020\000\000\000!\000\000\000\r\000\000\000"
 & "\000\000\000\000\355\221WA005\001\0055\001\0061\\\000\000\00013\000\000"
 & "\000\t\000\000\000\001\000\000\000\000\000\000\0005\001\0105\001\0065\001"
 & "\0065\001\0065\001\0061\f\000\000\0001b\000\000\000\003\000\000\000\022"
 & "\000\000\000\000\000\000\0001\016\000\000\000\025\000\000\000\f\000\000"
 & "\000\000\000\000\0001:\000\000\000!\000\000\000\002\000\000\000\000\000"
 & "\000\0001\020\000\000\000#\000\000\000\r\000\000\000\000\000\000\000\227"
 & "G\222A005\001\0055\001\0061e\000\000\0001\006\000\000\000\f\000\000\000"
 & "\001\000\000\000\000\000\000\0005\001\0105\001\0065\001\0065\001\0065\001"
 & "\0061\f\000\000\0001k\000\000\000\003\000\000\000\016\000\000\000\000\000"
 & "\000\0001\016\000\000\000\021\000\000\000\f\000\000\000\000\000\000\000"
 & "1\017\000\000\000\035\000\000\000\002\000\000\000\000\000\000\0001\020\000"
 & "\000\000\037\000\000\000\r\000\000\000\000\000\000\000XdXA0005\001\0055"
 & "\001\0061\261\000\000\00013\000\000\000\006\000\000\000\001\000\000\000"
 & "\000\000\000\0005\001\0105\001\0065\001\0065\001\0065\001\0061\f\000\000"
 & "\0001\267\000\000\000\003\000\000\000\017\000\000\000\000\000\000\0001\016"
 & "\000\000\000\022\000\000\000\f\000\000\000\000\000\000\0001:\000\000\000"
 & "\036";

CONST E26_4 = 
   "\000\000\000\002\000\000\000\000\000\000\0001\020\000\000\000 \000\000\000"
 & "\r\000\000\000\000\000\000\000\030\242\213A5\001\0055\001\0061\232\000\000"
 & "\0001>\000\000\000\f\000\000\000\001\000\000\000\000\000\000\0005\001\010"
 & "5\001\0065\001\0065\001\0065\001\0061\f\000\000\0001\240\000\000\000\003"
 & "\000\000\000\016\000\000\000\000\000\000\0001\016\000\000\000\021\000\000"
 & "\000\f\000\000\000\000\000\000\0001E\000\000\000\035\000\000\000\001\000"
 & "\000\000\000\000\000\0001\020\000\000\000\036\000\000\000\r\000\000\000"
 & "\000\000\000\000*\007\355@00\010\000\000\000\300\000\000\0003\000\000\000"
 & "N\000\000\0005\001\003\005\000\000\0005\001\004 \000\000\00000000005\001"
 & "\0051\036\000\000\0005\001\000\200[\244\355\034\366Y\032B`e\275?5^?V\016"
 & "M?\000\000\200\276\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\001\001\001\001\001\001\001\001\001\000\001\001\000\001"
 & "\001\001\000\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\000\000\000\000\232\231"
 & "\031?\232\231\031?\000\000\000\000\232\231\031?\232\231\031?\232\231\031"
 & "?\000\000\000\000\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?0000000000000000000000000000000005\001\000\311\005\356G\216\333a\035\033"
 & "/]>\244p\375>\230n\022?\217\302u\2745\001\n\207\026Y>\006\201\025?;\337"
 & "\017?\362\322\215>5\001\nX9\264=\n\327#?\360\247&?\354Q8\2755\001\n\016"
 & "-\262=%\006!?\372~*?%\006\001\2765\001\n`\345\320=w\276\037?-\262\035?\217"
 & "\302u\2745\001\n\266\363}=b\020\030?\f\002\013?\217\302u\2745\001\n\037"
 & "\205k>\203\300\n?;\337\017?\362\322\215>5\001\n\'1\210>P\215\027?-\262\035"
 & "?`\345\320\2755\001\n\262\235\357=\370S\343>-\262\035?`\345\320\2755\001"
 & "\n\307K7>\376\324\030?#\333\031?\211A`>5\001\n\325x\351=u\223\030?j\274"
 & "\364>w\276\037=5\001\n\203\300\312=\366(\334>\016-2>\370S\343\2755\001\n"
 & "\325x\351=u\223\030?\211A\240>;\337O>5\001\n\317\367S>\254\034\332>\240"
 & "\032/>\217\302u\2745\001\n5^\272=\211A ?\211A ?-\262\235\2755\001\n\226"
 & "C\013>P\215\027?-\262\035?\217\302u\2745\001\n\311v\276=\262\235\017?-\262"
 & "\035?\000\000\000\0005\001\n#\333y=\331\316\027?-\262\035?\000\000\000\000"
 & "5\001\n\274t\223=\016-\022?-\262\035?\217\302u\2745\001\n\236\357\247=\027"
 & "\331\016?-\262\035?\000\000\000\0005\001\n-\262\235=\333\371\036?#\333\031"
 & "?\217\302u\2745\001\n\226C\013>y\351&?-\262\035?\217\302u\2745\001\n+\207"
 & "\026>d;\037?#\333\031?\000\000\000\0005\001\n\037\205\353=\276\237\032?"
 & "-\262\035?\217";

CONST E26_5 = 
   "\302u\2745\001\n\343\245\233=P\215\027?-\262\035?\217\302u\2745\001\n\252"
 & "\361R>}?\365>\232\231\331>\217\302u\2745\001\n\203\300\312=\217\302\365"
 & ">\232\231\331>\370S\343\2755\001\n\331\316\367=\010\254\034?\211A\000?\217"
 & "\302u<5\001\n\246\233\304=\033/\035?\250\306\313>\374\251\361=5\001\n\360"
 & "\247\306=\264\310\026?\211A\000?\217\302u<5\001\nZd;>\307K\027?\341z\024"
 & "?B`e\2745\001\n\002+\207=\223\030$?-\262\035?\217\302u\2745\001\n\274t\023"
 & "\2747\211!?;\337\017?\000\000\000\0005\001\n\217\302\365<%\006!?;\337\017"
 & "?\000\000\000\0005\001\n\232\231\231=D\213,?\341z\024?\274t\223\2745\001"
 & "\n\217\302\365<\347\373)?;\337\017?\000\000\000\0005\001\n\315\314\314<"
 & "\226C+?;\337\017?\000\000\000\0005\001\nw\276\037=\027\331.?;\337\017?\000"
 & "\000\000\0005\001\n\232\231\231=D\213,?\341z\024?\274t\223\2745\001\n\n"
 & "\327\243<\252\3612?;\337\017?\000\000\000\0005\001\n-\262\235=\035Z$?;\337"
 & "\017?\000\000\000\0005\001\n\374\251q=\354Q8?;\337\017?\274t\223\2745\001"
 & "\n1\010\254<`\3450?;\337\017?\000\000\000\0005\001\nw\276\037=\\\217\"?"
 & ";\337\017?\000\000\000\0005\001\no\022\003\273u\2238?;\337\017?\000\000"
 & "\000\0005\001\no\022\003<\276\237:?;\337\017?\246\233D\2745\001\nP\215\227"
 & "=\270\036%?\341z\024?\274t\223\2745\001\n\246\233D=\035Z$?;\337\017?\000"
 & "\000\000\0005\001\n1\010\254=\345\320\"?\341z\024?\337O\r\2765\001\n\246"
 & "\233\304<\266\363\035?;\337\017?\000\000\000\0005\001\n\033/]=1\010,?\364"
 & "\375\024?X9\264\2745\001\n\305 \260=h\221-?;\337\017?\000\000\000\0005\001"
 & "\n\027\331\316==\n7?;\337\017?\274t\223\2745\001\n1\010\254=Zd;?;\337\017"
 & "?\000\000\000\0005\001\n1\010\254=\010\254<?;\337\017?\000\000\000\0005"
 & "\001\n\246\233D<Nb0?;\337\017?\000\000\000\0005\001\nd;\337=}?5?;\337\017"
 & "?\000\000\000\0005\001\n\266\363}=\345\320\"?;\337\017?\000\000\000\000"
 & "5\001\n\035Zd>\321\"\033?-\262\035?`\345\320\2755\001\n\035Zd>\266\363\375"
 & ">\211A ?-\262\235\2755\001\n\252\361\322=\376\324\370>-\262\035?`\345\320"
 & "\2755\001\n\240\032/>{\024\016?-\262\035?\000\000\200>5\001\n\033/\335\274"
 & "\006\201\025?\232\231\231\275\000\000\000\2765\001\nb\020\230>\020X\371"
 & ">;\337\017?\362\322\215>5\001\n\266\363}=P\215\027?\260r\350>\217\302u\274"
 & "5\001\n\364\375T<\345\320\"?\211A ?\217\302u\2745\001\nT\343\245=7\211!"
 & "?\f\002\353>\217\302u\2745\001\n#\333y=/\335$?\211A ?\217\302u\2745\001"
 & "\nT\343\245=\276\237\032?\260r\350>\217\302u\2745\001\n\347\373\251=\337"
 & "O-?\211A ?\000\000\000\0005\001\n\236\357\'=\272I,?\260r\350>\006\201\025"
 & "\2765\001\n\274t\223<\033/\035?\211A ?\000\000\000\0005\001\n-\262\235="
 & "\037\205\013?\260r(?\000\000\000\0005\001\nP\215\027=\341z\024?\260r(?\006"
 & "\201\025\2765\001\n\002+\007=\035Z$?\211A ?\000\000\000\0005\001\n-\262"
 & "\235=\037\205\013?\211A ?\000\000\000\0005\001\nX9\264\274T\343%?\260r\350"
 & ">\000\000\000\0005\001\n\274t\223<\033/\035?\260r\350>\000\000\000\0005"
 & "\001\nsh\221=d;\037?\260r\350>\217\302u\2745\001\n\266\363\375\274d;\037"
 & "?\260r\350>sh\021\2765\001\n#\333y=\240\032/?\260r\350>sh\021\2765\001\n"
 & "\022\203@=\213l\'?\260r\350>\000\000\000\0005\001\nL7\211=Zd\033?\f\002"
 & "\353>\226C\213\2745\001\n\374\251\361=`\345\020?;\337\017?\217\302u\274"
 & "5\001\n)\\\217=\307K\027?\234\304\340>\217\302u\2745\001\n)\\\217=\374\251"
 & "1?\234\304\340>\000\000\000\0005\001\n\207\026Y=\031\0046?\234\304\340>"
 & "\000\000\000\0005\001\n\246\233\304;\037\205+?\234\304\340>\000\000\000"
 & "\0005\001\n\n\327\243\274\374\2511?\234\304\340>sh\021\2765\001\nT\343\245"
 & "=\221\355\034?\234\304\340>\000\000\000\0005\001\n`\345P>\354Q\030?-\262"
 & "\035?`\345\320\2755\001\n\027\331N>%\006\001?\000\000@?\000\000\200\276"
 & "5\001\n\325x\351=7\211\001?-\262\035?`\345\320\2755\001\n\217\302\365=\264"
 & "\310\026?\242E\266>\010\254\034>000000000000000005\001\n-\262\235=\037\205"
 & "\013?\234\304\340>\000\000\000\0005\001\n\226C\213>\234\304\000?L7)?J\f"
 & "\002?5\001\n\211A\240>\343\245\033?L7)?J\f\002?5\001\n\207\026Y>\321\"\033"
 & "?\'1(?\307K\367>5\001\n\315\314L>\035Z$?\345\320\"?\177j\374>5\001\n\024"
 & "\256G>\345\320\"?\217\302\025?\256G\001?5\001\n?5^>\360\247&?7\211!?\262"
 & "\235\357>5\001\n\351&\261>H\341\372>\000\000 ?\354Q\370>5\001\n#\333y>P"
 & "\215\027?\000\000 ?\354Q\370>05\001\n\370S\243>\002+\007?h\221-?\242E\366"
 & ">5\001\nV\016->m\347\273>\000\000\000\000\252\361R\27605\001\n\305 0>5^"
 & ":?L7)?#\333\371>5\001\n\274t\023>33\263>\000\000\000\000\250\306K\2765\001"
 & "\nF\266s>\301\312!?\203\300*?\177j\374>05\001\n^\272I>X9\364>T\343\345>"
 & "\006\201\025\2765\001\n\331\316\367=\276\237\032?\033/\035?9\264H\2755\001"
 & "\n\321\"\333=ff&?\177j\034?B`\345\2745\001\n-\262\235=\246\233$?\035Z\004"
 & "?9\264H=5\001\n9\264\310=\006\2015?;\337\017?\000\000\000\0005\001\nd;_"
 & ">#\333\371>\315\314,?333\2765\001\nP\215\227=\311v\036?\341z\024?)\\\217"
 & "\2751\270\002\000\0005\001\n\207\026Y=\203\300*?\341z\024?\274t\223\274"
 & "5\001\n7\211A>\360\247\006?\341z\024?9\264H>5\001\n%\006\201=\370S#?\035"
 & "Z\344>)\\\217=5\001\nq=\n>\266\363\035?\274t\323>\252\361\322=5\001\n\230"
 & "n\022>\351&\021?\211A\240>;\337O>5\001\n\207\026Y=\203\300*?\341z\024?\274"
 & "t\223\2741\265\002\000\0005\001\n\351&1>\374\251\021?-\262\035?\376\324"
 & "x>5\001\n\343\245\233=\033/\035?\n\327\003?\246\233\304<5\001\n\246\233"
 & "D>\372~\n?-\262\035?\037\205k>5\001\n\313\241E>ff\006?-\262\035?\370Sc>"
 & "1\262\002\000\0005\001\n\315\314L=\307K\027?\234\304\340>sh\021\2765\001"
 & "\n#\333y=\252\3612?\341z\024?)\\\217\2755\001\n\333\371";

CONST E26_6 = 
   "~>1\010\354>F\266\263>\303\365(>1\272\002\000\0005\001\n\254\034Z>\201\225"
 & "\003?-\262\035?\037\205k>5\001\n7\211A>\203\300\n?\341z\024?9\264H>5\001"
 & "\n\274t\223=\313\241%?\035Z\344>)\\\217=5\001\nB`e<j\2744?L7)?\217\302u"
 & "\2755\001\n\177j\274<=\n7?L7)?\217\302u\2755\001\no\022\003<!\2602?L7)?"
 & "\217\302u\2755\001\n\027\331\316=\323M\002?T\343\345>\006\201\025\2765\001"
 & "\n\274t\023\2747\211!?9\264H?\000\000\000\0005\001\n\274t\023\274q=*?9\264"
 & "H?\000\000\000\0005\001\n\274t\023\2747\211!?\024\256G?\000\000\000\000"
 & "5\001\n\274t\023\274\370S#?\323MB?\000\000\000\0005\001\n\274t\023\2747"
 & "\211!?\356|??\000\000\000\0005\001\n\274t\023\2747\211!?V\016M?\000\000"
 & "\000\0005\001\nh\221\355\274\364\3754?;\337\017?\000\000\000\0005\001\n"
 & "P\215\227=D\213,?\341z\024?\252\361R\2765\001\n\315\314\314<\226C+?9\264"
 & "H?\000\000\000\0005\001\n\315\314\314<\226C+?9\264H?\000\000\000\0005\001"
 & "\n\315\314\314<\226C+?\024\256G?\000\000\000\0005\001\n\315\314\314<\226"
 & "C+?\356|??\000\000\000\0005\001\n-\262\235=\035Z$?9\264H?\000\000\000\000"
 & "5\001\n-\262\235=\035Z$?9\264H?\000\000\000\0005\001\n-\262\235=\035Z$?"
 & "\024\256G?\000\000\000\0005\001\n-\262\235=\035Z$?\356|??\000\000\000\000"
 & "5\001\n\217\302\365<\347\373)?;\337\017?\000\000\000\0005\001\no\022\003"
 & "<\276\237:?\323MB?\246\233D\2745\001\nP\215\227=\270\036%?9\264H?\274t\223"
 & "\2745\001\nP\215\227=\270\036%?9\264H?\274t\223\2745\001\nP\215\227=\270"
 & "\036%?\024\256G?\274t\223\2745\001\nP\215\227=\f\002+?\323MB?\274t\223\274"
 & "5\001\nP\215\227=\270\036%?\356|??\274t\223\2745\001\n=\n\327=\321\"\033"
 & "?j\274\364>w\276\037=5\001\n\246\233D=1\010,?\006\201\025?X9\264\2745\001"
 & "\n\027\331\316==\n7?9\264H?\274t\223\2745\001\n\027\331\316==\n7?9\264H"
 & "?\274t\223\2745\001\n\027\331\316==\n7?\024\256G?\274t\223\2745\001\n\027"
 & "\331\316==\n7?\356|??\274t\223\2745\001\nd;\337=}?5?9\264H?\000\000\000"
 & "\0005\001\n\246\233D=\311v\036?;\337\017?\000\000\000\0005\001\nX9\264<"
 & "\234\304 ?\211A ?\217\302u\2745\001\n\266\363}=P\215\027?L7)?\217\302u\274"
 & "5\001\n\266\363}=\343\245\033?L7)?\217\302u\2745\001\n\266\363}=P\215\027"
 & "?\'1(?\217\302u\2745\001\n\266\363}=\035Z$?\345\320\"?\217\302u\2745\001"
 & "\n\266\363}=P\215\027?\000\000 ?\217\302u\2745\001\n\266\363}=P\215\027"
 & "?h\221-?\217\302u\2745\001\n1\010\254<\360\247&?\260r\350>\217\302u\274"
 & "5\001\nT\343\245=7\211!?\f\002\353>\252\361R\2765\001\nT\343\245=\276\237"
 & "\032?L7)?\217\302u\2745\001\nT\343\245=\343\245\033?L7)?\217\302u\2745\001"
 & "\nT\343\245=\321\"\033?\'1(?\217\302u\2745\001\nT\343\245=\276\237\032?"
 & "\000\000 ?\217\302u\2745\001\n-\262\235=\037\205\013?L7)?\000\000\000\000"
 & "5\001\n-\262\235=\343\245\033?L7)?\000\000\000\0005\001\n-\262\235=`\345"
 & "\020?\'1(?\000\000\000\0005\001\n-\262\235=\337O\r?\000\000 ?\000\000\000"
 & "\0005\001\n\311v\276=L7)?\211A ?\033/\335\2745\001\n\274t\223<\035Z$?\345"
 & "\320\"?\000\000\000\0005\001\nsh\221=d;\037?L7)?\217\302u\2745\001\nsh\221"
 & "=d;\037?L7)?\217\302u\2745\001\nsh\221=d;\037?\'1(?\217\302u\2745\001\n"
 & "sh\221=\035Z$?\345\320\"?\217\302u\2745\001\nsh\221=d;\037?\000\000 ?\217"
 & "\302u\2745\001\n\325x\351=u\223\030?\000\000\000?o\022\203<5\001\n\256G"
 & "a=o\022#?V\016\355>\246\233\304\2745\001\n)\\\217=\307K\027?L7)?\217\302"
 & "u\2745\001\n)\\\217=\343\245\033?L7)?\217\302u\2745\001\n)\\\217=\307K\027"
 & "?\'1(?\217\302u\2745\001\n)\\\217=\307K\027?\000\000 ?\217\302u\2745\001"
 & "\n\n\327\243\274\374\2511?L7)?sh\021\2765\001\n\266\363\375\274d;\037?\211"
 & "A ?sh\021\2765\001\n\n\327\243\274\374\2511?\000\000 ?sh\021\27605\001\005"
 & "1\'\000\000\0005\001\t\016-2\276\215\227\216?\242Ev?\325xi\276\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\001\001"
 & "\001\001\001\001\001\001\000\001\001\000\001\001\001\000\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\004V\216>\372~\252>!\260\362>\004V\016?\004V\016?\201\225c"
 & "?\376\3248?\004V\216>\372~\252>\372~\252>\002+\307>\006\201\025?\004V\216"
 & ">\006\201\025?\004V\216>\004V\216>\004V\016?\004V\016?\004V\016?\004V\016"
 & "?\004V\016?\004V\016?\004V\016?\004V\016?\004V\016?\004V\016?\372~\252>"
 & "\372~\252>\006\201\025?\006\201\025?\006\201\025?\177j\034?\232\231y?\376"
 & "\3248?\376\3248?\376\3248?\376\3248?\203\300*?\177j\034?\002+G?\376\324"
 & "8?\004V\216>\004V\016?\376\3248?\177j\034?}?U?\376\3248?\002+G?\203\300"
 & "*?\002+G?\376\3248?\203\300*?\177j\034?\376\3248?\203\300*?";

CONST E26_7 = 
   "\374\251q?\203\300*?\203\300*?\177j\034?\372~\252>\004V\216>\372~\252>\006"
 & "\201\025?\004V\016?\004V\216>\004V\016?\177j\034?\004V\016?\177j\034?\004"
 & "V\016?\372~\252>\177j\034?\177j\034?\004V\216>\004V\216>\004V\016?\004V"
 & "\216>\201\225c?\177j\034?\177j\034?\177j\034?\177j\034?\002+\307>\004V\016"
 & "?\372~\252>\177j\034?\004V\016?\002+G?\004V\016?\004V\016?\000\000\000?"
 & "\002+\307>)\\\217>\002+\307>\006\201\025?\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\004V\216>\372~\252>\372~\252>\372~\252>\372~\252"
 & ">\372~\252>\372~\252>\372~\252>\372~\252>\000\000\000\000\372~\252>\372"
 & "~\252>\000\000\000\000\372~\252>\372~\252>\372~\252>\000\000\000\000\372"
 & "~\252>\004V\016?\004V\016?\004V\016?\004V\016?)\\\217>\004V\016?\372~\252"
 & ">\010\254<?\244p\275>\004V\016?\006\201\025?\372~\252>\010\254<?\372~\252"
 & ">\315\314\314>\006\201\025?\372~\252>\372~\252>\372~\252>\177j\034?\004"
 & "V\016?\004V\216>\372~\252>\372~\252>H\341\272>\004V\016?\006\201U?\006\201"
 & "U?\006\201U?\177j\034?\376\3248?\376\3248?\376\3248?\376\3248?\376\3248"
 & "?\376\3248?\000\000\200?\376\3248?\203\300*?\203\300*?\203\300*?\203\300"
 & "*?\004V\216>\004V\216>\004V\216>\004V\216>\376\3248?\376\3248?\002+G?\002"
 & "+G?\002+G?\002+G?\002+G?\006\201\025?\002+G?\376\3248?\376\3248?\376\324"
 & "8?\376\3248?\203\300*?\203\300*?\177j\034?\004V\016?\004V\016?\004V\016"
 & "?\004V\016?\004V\016?\004V\016?\201\225c?\004V\016?\004V\016?\004V\016?"
 & "\004V\016?\004V\016?\004V\216>\004V\216>\004V\216>\004V\216>\177j\034?\177"
 & "j\034?\177j\034?\177j\034?\177j\034?\177j\034?\177j\034?\006\201\025?\177"
 & "j\034?\177j\034?\177j\034?\177j\034?\177j\034?\004V\016?\177j\034?\004V"
 & "\016?0000000000000000000000000000000005\001\n\022\203\300=\226C\313>\331"
 & "\3167?\000\000\000\0005\001\n\313\241E>\213l\007?\331\3167?/\335\344>5\001"
 & "\n\217\302u=/\335$?!\2602?\000\000\000\0005\001\nL7\211=d;\037?ffF?\037"
 & "\205\353\2755\001\n\226C\013>\360\247f?\217\3025?\343\245\233\2745\001\n"
 & "\242E\266=Zd;?\331\3167?\343\245\233\2745\001\n\f\002+>\020X\271>\331\316"
 & "7?\n\327\343>5\001\n\343\245\233=\327\243\360>m\347;?\364\375T\2765\001"
 & "\n\315\314\314\274\221\355\274>m\347;?\364\375T\2765\001\n\006\201\025>"
 & "\242E\366>\331\3167?\335$\306>5\001\n\236\357\247=\366(\034?7\211\001?\000"
 & "\000\000\0005\001\nB`\345<H\341z>\006\201\025>1\010,\2765\001\n\236\357"
 & "\247=\366(\034??5\236>^\272I>5\001\no\022\203=H\341z>\006\201\025>\000\000"
 & "\000\0005\001\nP\215\027\275\262\235\357>\010\254<?\343\245\233\2745\001"
 & "\n\305 \260=\266\363\035?\217\3025?\343\245\233\2745\001\n\351&1>\213l\007"
 & "?\217\3025?\000\000\000\0005\001\n\364\375\324<\311v\036?\217\3025?\000"
 & "\000\000\0005\001\n\270\036\205=\343\245\033?\217\3025?\343\245\233\274"
 & "5\001\n\217\302u=\207\026\031?\217\3025?\000\000\000\0005\001\no\022\203"
 & "=\345\320\"?!\2602?\343\245\233\2745\001\n{\024\256=\311v\036?\217\3025"
 & "?\343\245\233\2745\001\n\000\000\000>V\016-?!\2602?\000\000\000\0005\001"
 & "\n\337O\215=-\262\035?\217\3025?\343\245\233\2745\001\nw\276\237=\244p\035"
 & "?\217\3025?\343\245\233\2745\001\n\177j\274=F\266\263>o\022\003?\000\000"
 & "\000\0005\001\nB`e=F\266\263>o\022\003?1\010,\2765\001\n\236\357\247=\024"
 & "\256\'?\201\225\003?o\022\003\2745\001\nh\221m=J\f\"?+\207\326>\016-\262"
 & "=5\001\n\274t\023=m\347\033?\201\225\003?o\022\003\2745\001\n\303\365(>"
 & "\250\306+?\254\034:?\000\000\000\0005\001\n\311v>>X9t?\010\254<?\343\245"
 & "\233\2745\001\n\n\327\243<F\2663?\331\3167?\000\000\000\0005\001\n\343\245"
 & "\233=\201\225C?\331\3167?\000\000\000\0005\001\n\321\"\333=\347\373I?\010"
 & "\254<?\343\245\233\2745\001\n\343\245\233=y\351F?\331\3167?\000\000\000"
 & "\0005\001\n\343\245\233=\301\312A?\331\3167?\000\000\000\0005\001\n\343"
 & "\245\233=\244p=?\331\3167?\000\000\000\0005\001\n\033/\335=\351&Q?\010\254"
 & "<?\343\245\233\2745\001\nsh\221=\362\322M?\331\3167?\000\000\000\0005\001"
 & "\no\022\203=m\347\273>\331\3167?\000\000\000\0005\001\n\217\302u=o\022#"
 & "?\331\3167?\274t\223\2745\001\n\016-\262=\343\245[?\331\3167?\000\000\000"
 & "\0005\001\n\343\245\233=\177j\034?\331\3167?\000\000\000\0005\001\n\337"
 & "O\215=\f\002k?\331\3167?\000\000\000\0005\001\n\337O\215=\215\227N?\331"
 & "\3167?\000\000\000\0005\001\n\321\"\333=!\260R?\010\254<?\343\245\233\274"
 & "5\001\n\343\245\233=\221\355<?\331\3167?\000\000\000\0005\001\n\321\"\333"
 & "=!\260R?\010\254<?\364\375T\2755\001\n\343\245\233=\002+G?\331\3167?\000"
 & "\000\000\0005\001\nT\343\245=\331\3167?\010\254<?\343\245\233\2745\001\n"
 & ")\\\017>\211A@?\331\3167?\000\000\000\0005\001\nh\221\355=\362\322M?\331"
 & "\3167?\343\245\233\2745\001\n\305 0>V\016M?\331\3167?\000\000\000\0005\001"
 & "\nV\016->\372~\212?\331\3167?\000\000\000\0005\001\nB`e<\372~J?\331\316"
 & "7?\000\000\000\0005\001\n1\010,>\004VN?\331\3167?\000\000\000\0005\001\n"
 & "\315\314\314<\010\254<?\331\3167?\000\000\000\0005\001\n1\010\254<D\213"
 & "\354>\376\3248?9\264H\2765\001\n\266\363\375=\033/\235>\010\254<?\343\245"
 & "\233\2745\001\n\274t\223\274u\223\330>\376\3248?9\264H\2765\001\n\335$\006"
 & ">\307K\027?!\2602?B`\245>5\001\n\033/\335\274q=\n?\232\231\231\275\000\000"
 & "\000\2765\001\n\303\365(>\376\324\270>\254\034:?\260r\350>5\001\n\256Ga"
 & "=}?\025?\250\306\013?B`e\2745\001\n#\333y=\270\036%?\331\3167?B`e\2745\001"
 & "\n\301\312\241=\020X\031?\250\306\013?B`e\2745\001\n\236\357\247=X94?\331"
 & "\3167?B`e";

CONST E26_8 = 
   "\2745\001\n)\\\217=\331\316\027?\250\306\013?B`e\2745\001\n\016-\262=\305"
 & " \360>\254\034:?\000\000\000\0005\001\n\343\245\033=\372~*?\250\306\013"
 & "??5^\2765\001\n\270\036\205=%\006!?\331\3167?\000\000\000\0005\001\n\337"
 & "O\215=#\333\271>\232\2319?\000\000\000\0005\001\n1\010,\275#\333\271>\232"
 & "\2319?\321\"[\2765\001\n\337O\215=\037\205+?\331\3167?\000\000\000\0005"
 & "\001\n\337O\215=\020X\271>\331\3167?\000\000\000\0005\001\no\022\203=9\264"
 & "h?\250\306\013?\000\000\000\0005\001\n\270\036\205=%\006!?\250\306\013?"
 & "\000\000\000\0005\001\n\236\357\247=\246\233$?\250\306\013?B`e\2745\001"
 & "\n\274t\223<\270\036%?\250\306\013?\317\367S\2765\001\n\n\327\243=q=*?\250"
 & "\306\013?\317\367S\2765\001\no\022\203=5^\372>\250\306\013?\000\000\000"
 & "\0005\001\n%\006\201=\006\201\025?\250\306\013?B`e\2745\001\n\315\314\314"
 & "=b\020\330>V\016-?\246\233\304\2735\001\n9\264\310=\260r(?\'1\010?B`e\274"
 & "5\001\n%\006\001>\236\357\'?\'1\010?\000\000\000\0005\001\nm\347\373=\301"
 & "\312a?\'1\010?\000\000\000\0005\001\n\217\302u<T\343%?\'1\010?\000\000\000"
 & "\0005\001\n1\010,=y\351&?\'1\010?\321\"[\2765\001\n\n\327\243<}?\025?\'"
 & "1\010?\000\000\000\0005\001\n\022\203\300=\246\233\004?\376\3248?9\264H"
 & "\2765\001\n\n\327\243=j\274\264>\010\254<?\343\245\233\2745\001\n\274t\223"
 & "\274Nb\320>\376\3248?9\264H\2765\001\n\037\205\353=F\266\023?\262\235\257"
 & ">y\351&>000000000000000005\001\n\337O\215=/\335\244>\'1\010?\000\000\000"
 & "\0005\001\n\226C\013>j\274\264>\000\000@?\276\237\032?5\001\n\374\251q>"
 & "\n\327\003?\000\000@?\276\237\032?5\001\n\374\251\361=\351&\361>\000\000"
 & "@?\276\237\032?5\001\n\213l\347=\301\312\001?\010\254<?\366(\034?5\001\n"
 & "#\333\371=\307K\367>h\221-?\276\237\032?5\001\nw\276\037>\221\355\374>\000"
 & "\000@?\276\237\032?5\001\n\327\243p>\270\036\305>\276\237:?\033/\035?5\001"
 & "\n\272I\f>\264\310\366>\276\237:?\033/\035?05\001\n\315\314L>=\n\327>\360"
 & "\247F?sh\021?5\001\nP\215\027\275\256Ga>\000\000\000\000\325xi\27605\001"
 & "\n\272I\f>\270\036%?\000\000@?\276\237\032?5\001\n\236\357\'=\002+\207>"
 & "\000\000\000\000\325xi\2765\001\nu\223\030>\022\203\000?\000\000@?\276\237"
 & "\032?05\001\n\315\314L=j\274\264>\'1\010?\311v>\2765\001\n\301\312\241="
 & "\020X\031?\234\304 ?\374\251\361\2755\001\n\315\314L=\\\217\"?\331\3167"
 & "?o\022\203\2745\001\n\033/\335<{\024.?\345\320\"?\343\245\233=5\001\n\217"
 & "\302u=+\2076?!\2602?\000\000\000\0005\001\n\n\327\243=j\274\264>\010\254"
 & "<?\343\245\233\2745\001\n#\333y=\207\026\031?\254\034:?\177j<\2761\201\003"
 & "\000\0005\001\nB`e=\217\302U?\010\254<?\343\245\233\2745\001\n\177j\274"
 & "={\024\356>\010\254<?\337O\215>5\001\nq=\n>\016-\022?\331\316\367>\343\245"
 & "\233=5\001\n=\n\327=J\f\"?+\207\326>\033/\335=5\001\n\006\201\225=J\f\302"
 & ">\327\243\260>\366(\\>5\001\n\256Ga=\006\201U?\010\254<?\343\245\233\274"
 & "1~\003\000\0005\001\n333>\240\032\357>\242E6?\254\034\332>5\001\n\n\327"
 & "#=\000\000 ?7\211\001?\000\000\000\0005\001\n\337O\215=T\343\345>\217\302"
 & "5?`\345\220>5\001\n5^\272=\301\312\341>\217\3025?\203\300\212>1{\003\000"
 & "\0005\001\nX9\264<\260r(?\'1\010?\317\367S\2765\001\n9\264\310=\305 0?3"
 & "33?\201\225C\2765\001\n\256G\341=\337O\215>\f\002\253>\305 0>1\203\003\000"
 & "\0005\001\nP\215\027>\360\247\306>\217\3025?`\345\220>5\001\n\177j\274="
 & "\354Q\370>\010\254<?\337O\215>5\001\n\364\375\324=q=\n?\331\316\367>\343"
 & "\245\233=5\001\n\002+\007>\004VN?\217\3025?\343\245\233\2745\001\n\002+"
 & "\007>\343\245[?\217\3025?\343\245\233\2745\001\n\203\300\312=\264\310V?"
 & "\217\3025?\343\245\233\2745\001\n\207\026Y=\240\032\017?\'1\010?\024\256"
 & "G\2765\001\n\n\327\243<F\2663?\262\235o?\000\000\000\0005\001\n\n\327\243"
 & "<\000\000@?\262\235o?\000\000\000\0005\001\n\n\327\243<j\2744?\262\235o"
 & "?\000\000\000\0005\001\n\n\327\243<-\262=?\272Il?\000\000\000\0005\001\n"
 & "\n\327\243<\307K7?q=j?\000\000\000\0005\001\n\n\327\243<F\2663?\242Ev?\000"
 & "\000\000\0005\001\n\n\327\243;\315\314\214?\331\3167?\000\000\000\0005\001"
 & "\n\321\"\333=\347\373I?\010\254<?\325xi\2765\001\n\343\245\233=\301\312"
 & "A?\262\235o?\000\000\000\0005\001\n\343\245\233=\301\312A?\262\235o?\000"
 & "\000\000\0005\001\n\343\245\233=\301\312A?\262\235o?\000\000\000\0005\001"
 & "\n\343\245\233=\301\312A?q=j?\000\000\000\0005\001\no\022\203=m\347\273"
 & ">\262\235o?\000\000\000\0005\001\no\022\203=\002+\007?\262\235o?\000\000"
 & "\000\0005\001\no\022\203=\331\316\367>\262\235o?\000\000\000\0005\001\n"
 & "o\022\203=\221\355\374>q=j?\000\000\000\0005\001\n\266\363}=y\351F?\331"
 & "\3167?\000\000\000\0005\001\n\337O\215=\215\227N?\272Il?\000\000\000\000"
 & "5\001\n\321\"\333=!\260R?\262\235o?\343\245\233\2745\001\n\321\"\333=!\260"
 & "R?\262\235o?\343\245\233\2745\001\n\321\"\333=!\260R?\262\235o?\343\245"
 & "\233\2745\001\n\321\"\333=!\260R?\272Il?\343\245\233\2745\001\n\321\"\333"
 & "=!\260R?q=j?\343\245\233\2745\001\n\325xi=\\\217\"?\256G\001?o\022\203:"
 & "5\001\n)\\\017=/\335d?R\270>?\033/\335\2745\001\nh\221\355=\362\322M?\262"
 & "\235o?\343\245\233\2745\001\nh\221\355=\362\322M?\262\235o?\343\245\233"
 & "\2745\001\nh\221\355=\362\322M?\262\235o?\343\245\233\2745\001\nh\221\355"
 & "=\362\322M?q=j?\343\245\233\2745\001\n1\010,>\004VN?\262\235o?\000\000\000"
 & "\0005\001\n\343\245\233=\307K7?\331\3167?\000\000\000\0005\001\n\337O\215"
 & "=\'1(?\321\";?B`e\2745\001\n\256Ga=}?\025?\000\000@?B`e\2745\001\n\256G"
 & "a=\022\203 ?\000\000@?B`e\2745\001\n\256Ga=}?\025?\000\000@?B`e\2745\001"
 & "\n\256Ga=\311v\036?\010\254<?B`e\2745\001";

CONST E26_9 = 
   "\n\256Ga=b\020\030?\276\237:?B`e\2745\001\n\256Ga=}?\025?\360\247F?B`e\274"
 & "5\001\nB`e=\272Il?\250\306\013?B`e\2745\001\n\301\312\241=\020X\031?\250"
 & "\306\013?\325xi\2765\001\n)\\\217=\331\316\027?\000\000@?B`e\2745\001\n"
 & ")\\\217=\022\203 ?\000\000@?B`e\2745\001\n)\\\217=\331\316\027?\000\000"
 & "@?B`e\2745\001\n)\\\217=b\020\030?\276\237:?B`e\2745\001\n\337O\215=y\351"
 & "\246>\000\000@?\000\000\000\0005\001\n\337O\215=#\333\371>\000\000@?\000"
 & "\000\000\0005\001\n\337O\215=\370S\343>\000\000@?\000\000\000\0005\001\n"
 & "\337O\215=\303\365\350>\276\237:?\000\000\000\0005\001\n\236\357\247=\037"
 & "\205+?\010\254<?B`e\2745\001\n\270\036\205=B`%?\010\254<?\000\000\000\000"
 & "5\001\n\236\357\247=\246\233$?\000\000@?B`e\2745\001\n\236\357\247=\213"
 & "l\'?\000\000@?B`e\2745\001\n\236\357\247=\246\233$?\000\000@?B`e\2745\001"
 & "\n\236\357\247=B`%?\010\254<?B`e\2745\001\n\236\357\247=\246\233$?\276\237"
 & ":?B`e\2745\001\n\236\357\247=\366(\034?\272I\f?1\010,\2755\001\nX9\264<"
 & "\274t3?)\\\017?h\221\355\2745\001\n9\264\310=\260r(?\000\000@?B`e\2745\001"
 & "\n9\264\310=\260r(?\000\000@?B`e\2745\001\n9\264\310=\260r(?\000\000@?B"
 & "`e\2745\001\n9\264\310=\260r(?\276\237:?B`e\2745\001\n1\010,=y\351&?\000"
 & "\000@?\321\"[\2765\001\n\274t\223<\270\036%?\331\3167?\364\375T\2765\001"
 & "\n1\010,=y\351&?\276\237:?\321\"[\2760005\001\0051\005\000\000\0005\001"
 & "\tB`\345\274\234\304 ?{\024N?\000\000\200\276\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\001\001\001\001\001\001\001"
 & "\001\001\000\001\001\000\001\001\001\000\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\000\000\000\000\232\231\031?\232\231\031?\000\000\000\000\232\231"
 & "\031?\232\231\031?\232\231\031?\000\000\000\000\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?0000000000000000000000000000000005\001\n"
 & "\374\251q>5^\272>\230n\022?\217\302u\2745\001\n\356|?>\274t\323>;\337\017"
 & "?\236\357\247>5\001\n\311v\276=\301\312\001?\201\225#?o\022\003\2755\001"
 & "\n=\n\327=\266\363\375>\325x)?%\006\001\2765\001\nT\343\245=\246\233\004"
 & "?d;\037?\217\302u\2745\001\n%\006\201=^\272\t?\f\002\013?\217\302u\2745"
 & "\001\n\254\034Z>\022\203\300>;\337";

CONST E26_10 = 
   "\017?\236\357\247>5\001\n^\272\211>\256G\341>d;\037?\033/\335\2755\001\n"
 & "\n\327#>\325x\251>d;\037?\033/\335\2755\001\nh\221\355=\331\316\367>Zd\033"
 & "?\201\225\203>5\001\n\n\327\243=\270\036\005?\327\243\360>X94=5\001\n\020"
 & "X9>\305 \260>#\333\371=B`\345\2755\001\n\n\327\243=\270\036\005?`\345\220"
 & ">h\221m>5\001\n\372~j>\266\363\275>d;\337=\217\302u\2745\001\n\000\000\000"
 & ">33\363>%\006!?\n\327\243\2755\001\n\207\026\331=\221\355\374>d;\037?\217"
 & "\302u\2745\001\n\246\233\304=\256G\001?d;\037?\000\000\000\0005\001\n)\\"
 & "\217=\351&\361>d;\037?\000\000\000\0005\001\n\232\231\231=\215\227\356>"
 & "d;\037?\217\302u\2745\001\nw\276\237=\000\000\000?d;\037?\000\000\000\000"
 & "5\001\n\177j\274=\311v\376>Zd\033?\217\302u\2745\001\n\370S\343=\311v\376"
 & ">d;\037?\217\302u\2745\001\n\236\357\247=\307K\367>Zd\033?\000\000\000\000"
 & "5\001\n`\345\320=\333\371\376>d;\037?\217\302u\2745\001\n\246\233\304=5"
 & "^\372>d;\037?\217\302u\2745\001\n\372~j>\266\363\275>\270\036\305>\217\302"
 & "u\2745\001\n\020X9>\266\363\275>\270\036\305>B`\345\2755\001\n\236\357\'"
 & "=/\335\004?\374\251\361>1\010,=5\001\n\n\327\243=\270\036\005?\022\203\300"
 & ">\337O\r>5\001\n\002+\207=\226C\013?\374\251\361>1\010,=5\001\n\223\030"
 & "\004>m\347\373>\230n\022?\217\302u\2745\001\n-\262\235=\260r\010?d;\037"
 & "?\217\302u\2745\001\n\246\233D;\376\324\030?;\337\017?\000\000\000\0005"
 & "\001\n\305 0=\240\032\017?;\337\017?\000\000\000\0005\001\n\236\357\'=q"
 & "=\n?\341z\024?\274t\223\2745\001\n\305 0=\252\361\022?;\337\017?\000\000"
 & "\000\0005\001\n\207\026Y=\315\314\f?;\337\017?\000\000\000\0005\001\n\207"
 & "\026Y=\037\205\013?;\337\017?\000\000\000\0005\001\n\266\363\375<33\023"
 & "?\341z\024?\274t\223\2745\001\no\022\003=sh\021?;\337\017?\000\000\000\000"
 & "5\001\n\246\233\304=%\006\001?;\337\017?\000\000\000\0005\001\n\226C\013"
 & "=`\345\020?;\337\017?\274t\223\2745\001\n\343\245\033=\364\375\024?;\337"
 & "\017?\000\000\000\0005\001\n\022\203@=\362\322\r?;\337\017?\000\000\000"
 & "\0005\001\no\022\203;u\223\030?;\337\017?\000\000\000\0005\001\nB`\345;"
 & "\331\316\027?;\337\017?\364\375T\2745\001\n\305 0=\215\227\016?\341z\024"
 & "?\274t\223\2745\001\n\301\312\241=\027\331\016?;\337\017?\000\000\000\000"
 & "5\001\n\305 0=\215\227\016?\341z\024?\337O\r\2765\001\n\343\245\033=+\207"
 & "\026?;\337\017?\000\000\000\0005\001\n\274t\223=\213l\007?\341z\024?\n\327"
 & "\243\2745\001\n\343\245\033=\305 \020?;\337\017?\000\000\000\0005\001\n"
 & "\226C\213<}?\025?;\337\017?\274t\223\2745\001\no\022\203\273\276\237\032"
 & "?;\337\017?\364\375T\2745\001\n\246\233D\2735^\032?;\337\017?\364\375T\274"
 & "5\001\n\177j\274<F\266\023?;\337\017?\000\000\000\0005\001\n\246\233\304"
 & "<\274t\023?;\337\017?\000\000\000\0005\001\n\305 \260=\201\225\003?;\337"
 & "\017?\000\000\000\0005\001\n^\272\211>\323M\342>d;\037?\033/\335\2755\001"
 & "\n\374\251\361=\264\310\366>%\006!?\n\327\243\2755\001\n\301\312!>\325x"
 & "\251>d;\037?\033/\335\2755\001\n\022\203\300=7\211\001?d;\037?}?\265>5\001"
 & "\n\000\000\000\000\232\231\031?\232\231\231\275\000\000\000\2765\001\nB"
 & "`e>\335$\306>;\337\017?\236\357\247>5\001\n\207\026Y=\240\032\017?\301\312"
 & "\341>\217\302u\2745\001\nB`e<33\023?%\006!?\217\302u\2745\001\n\002+\207"
 & "=\213l\007?\301\312\341>\217\302u\2745\001\n\354Q8=\307K\027?%\006!?\217"
 & "\302u\2745\001\n\002+\207=\272I\f?\301\312\341>\217\302u\2745\001\n\325"
 & "x\351=\236\357\007?%\006!?\000\000\000\0005\001\n\354Q8=`\345\020?\301\312"
 & "\341>\234\304 \2765\001\n\274t\223<\364\375\024?%\006!?\000\000\000\000"
 & "5\001\n\\\217\302=\256G\001?\'1(?\000\000\000\0005\001\n\236\357\247=\205"
 & "\353\321>\'1(?\234\304 \2765\001\n\305 0=\341z\024?%\006!?\000\000\000\000"
 & "5\001\n\\\217\302=\256G\001?%\006!?\000\000\000\0005\001\n\n\327\243\273"
 & "H\341\032?\301\312\341>\000\000\000\0005\001\n\364\375\324<33\023?\301\312"
 & "\341>\000\000\000\0005\001\n\266\363}=^\272\t?\301\312\341>\217\302u\274"
 & "5\001\n\274t\023<{\024\016?\301\312\341>\234\304 \2765\001\n\354Q8=\307"
 & "K\027?\301\312\341>\234\304 \2765\001\n\217\302u=\240\032\017?\301\312\341"
 & ">\000\000\000\0005\001\n\n\327\243=\370S\003?\301\312\341>\217\302u\274"
 & "5\001\n\016-\262=\024\256\007?\262\235\017?\217\302u\2745\001\n1\010\254"
 & "<;\337\017?\254\034\332>\217\302u\2745\001\n\n\327#<=\n\027?\254\034\332"
 & ">\n\327#\2745\001\no\022\203\273\276\237\032?\254\034\332>\n\327#\2745\001"
 & "\n\n\327\243<\341z\024?\254\034\332>\000\000\000\0005\001\nB`\345;P\215"
 & "\027?\254\034\332>\234\304 \2765\001\n\203\300\312=\022\203\000?\254\034"
 & "\332>\000\000\000\0005\001\n5^:>w\276\337>d;\037?\033/\335\2755\001\n\315"
 & "\314\214>y\351\246>\000\000@?\000\000\200\2765\001\ny\351&>\031\004\326"
 & ">d;\037?\033/\335\2755\001\n%\006\201=q=\n?\n\327\243>^\272I>0000000000"
 & "00000005\001\n\\\217\302=\256G\001?\254\034\332>\000\000\000\0005\001\n"
 & "\276\237\032>7\211\301>1\010,?\311v\376>5\001\n\331\316w>\305 \360>1\010"
 & ",?\311v\376>5\001\n\266\363\375=F\266\363>\213l\'?X9\364>5\001\n=\n\327"
 & "=\234\304\000?\321\"\033?5^\372>5\001\n\217\302\365=\217\302\365>\327\243"
 & "\020?ff\006?5\001\n\010\254\034>/\335\344>m\347\033?\211A\000?5\001\n\333"
 & "\371~>X9\264>\341z\024?X9\364>5\001\nP\215\027>\236\357\347>\354Q\030?m"
 & "\347\373>05\001\nd;_>\201\225\303>\022\203 ?V\016\355>5\001\nB`e>\020X\271"
 & ">\n\327#<\276\237\032\27605\001\n\'1\010>q=\n?1\010,?\311v\376>5\001\n\260"
 & "rh>\244p\275>\000\000\000\000\276\237\032\2765\001\n\266\363\375=F\266\363"
 & ">\226C+?m\347\373>05\001\n\374\251q>5^\272>\366(\334>\234\304 \2765\001"
 & "\n\246\233\304=\000\000\000?\033/\035?9\264H\2755\001\n1\010\254=B`\005"
 & "?\177j\034?1\010";

CONST E26_11 = 
   "\254\2745\001\n\006\201\225=y\351\006?7\211\001?h\221m=5\001\n\364\375\324"
 & "<\252\361\022?;\337\017?\000\000\000\0005\001\n\315\314\214>y\351\246>\315"
 & "\314,?333\2765\001\n\213l\347=#\333\371>\341z\024?w\276\237\2751J\004\000"
 & "\0005\001\n\000\000\000\000\232\231\031?\341z\024?\274t\223\2745\001\nw"
 & "\276\037>\323M\342>\341z\024?\333\371~>5\001\nP\215\027=\305 \020?\035Z"
 & "\344>)\\\217=5\001\n\016-\262=\370S\003?\221\355\274>\033/\335=5\001\n\252"
 & "\361\322=\311v\376>\205\353\221>D\213l>5\001\n\000\000\000\000\232\231\031"
 & "?\341z\024?\274t\223\2741G\004\000\0005\001\nm\347\373=X9\364>d;\037?^\272"
 & "\211>5\001\n\016-\262=\370S\003?\027\331\016?X94=5\001\n}?5>\207\026\331"
 & ">d;\037?\333\371~>5\001\nR\270\036>;\337\317>d;\037?\217\302u>1D\004\000"
 & "\0005\001\n1\010\254<;\337\017?\254\034\332>\234\304 \2765\001\n\315\314"
 & "L=\345\320\002?;\337\017?w\276\237\2755\001\n\370Sc>7\211\301>\213l\247"
 & ">7\211A>1L\004\000\0005\001\n\305 0>\321\"\333>d;\037?\333\371~>5\001\n"
 & "\234\304 >\345\320\342>\341z\024?\333\371~>5\001\nP\215\027=\305 \020?\035"
 & "Z\344>)\\\217=5\001\n\000\000\000\000\232\231\031?q=*?\325xi\2755\001\n"
 & "\000\000\000\000\177j\034?q=*?\325xi\2755\001\no\022\003<\331\316\027?\372"
 & "~*?B`e\2755\001\n\033/\335=\351&\361>\366(\334>\234\304 \2765\001\n\246"
 & "\233D;\376\324\030?\f\002K?\000\000\000\0005\001\n\246\233D;\376\324\030"
 & "?\f\002K?\000\000\000\0005\001\n\246\233D;\376\324\030?ffF?\000\000\000"
 & "\0005\001\n\246\233D;\376\324\030?Zd;?\000\000\000\0005\001\n\246\233D;"
 & "\376\324\030?\321\";?\000\000\000\0005\001\n\246\233D;\376\324\030?\234"
 & "\304@?\000\000\000\0005\001\n\246\233D;\315\314\f?;\337\017?\000\000\000"
 & "\0005\001\n\236\357\'=q=\n?\341z\024?\276\237\032\2765\001\n\207\026Y=\315"
 & "\314\f?\f\002K?\000\000\000\0005\001\n\207\026Y=\315\314\f?\f\002K?\000"
 & "\000\000\0005\001\n\207\026Y=\315\314\f?ffF?\000\000\000\0005\001\n\207"
 & "\026Y=\315\314\f?\321\";?\000\000\000\0005\001\n\246\233\304=%\006\001?"
 & "\f\002K?\000\000\000\0005\001\n\246\233\304=%\006\001?\f\002K?\000\000\000"
 & "\0005\001\n\246\233\304=%\006\001?ffF?\000\000\000\0005\001\n\246\233\304"
 & "=%\006\001?\321\";?\000\000\000\0005\001\n\217\302\365<\252\361\022?;\337"
 & "\017?\000\000\000\0005\001\nB`\345;\331\316\027?Zd;?\364\375T\2745\001\n"
 & "\305 0=\215\227\016?\f\002K?\274t\223\2745\001\n\305 0=\215\227\016?\f\002"
 & "K?\274t\223\2745\001\n\305 0=\215\227\016?ffF?\274t\223\2745\001\n\305 "
 & "0=\215\227\016?Zd;?\274t\223\2745\001\n\305 0=\215\227\016?\321\";?\274"
 & "t\223\2745\001\n\016-\262=\n\327\003?\327\243\360>\305 0=5\001\n\305 0="
 & "\215\227\016?%\006!?\n\327\243\2755\001\n\226C\213<}?\025?\f\002K?\274t"
 & "\223\2745\001\n\226C\213<}?\025?\f\002K?\274t\223\2745\001\n\226C\213<}"
 & "?\025?ffF?\274t\223\2745\001\n\226C\213<}?\025?\321\";?\274t\223\2745\001"
 & "\n\246\233\304<\274t\023?\f\002K?\000\000\000\0005\001\n\301\312\241=^\272"
 & "\t?;\337\017?\000\000\000\0005\001\n\246\233D=+\207\026?%\006!?\217\302"
 & "u\2745\001\n\207\026Y=\240\032\017?1\010,?\217\302u\2745\001\n\207\026Y"
 & "=\240\032\017?1\010,?\217\302u\2745\001\n\207\026Y=\240\032\017?\213l\'"
 & "?\217\302u\2745\001\n\207\026Y=\240\032\017?\321\"\033?\217\302u\2745\001"
 & "\n\207\026Y=\240\032\017?\354Q\030?\217\302u\2745\001\n\207\026Y=\240\032"
 & "\017?\022\203 ?\217\302u\2745\001\n\343\245\233<\205\353\021?\301\312\341"
 & ">\217\302u\2745\001\n\002+\207=\213l\007?\301\312\341>\276\237\032\2765"
 & "\001\n\002+\207=\272I\f?1\010,?\217\302u\2745\001\n\002+\207=\272I\f?1\010"
 & ",?\217\302u\2745\001\n\002+\207=\272I\f?\213l\'?\217\302u\2745\001\n\002"
 & "+\207=\272I\f?\354Q\030?\217\302u\2745\001\n\\\217\302=\256G\001?1\010,"
 & "?\000\000\000\0005\001\n\\\217\302=\256G\001?1\010,?\000\000\000\0005\001"
 & "\n\022\203\300=\256G\001?\213l\'?\000\000\000\0005\001\n\\\217\302=\256"
 & "G\001?\354Q\030?\000\000\000\0005\001\n\266\363}=^\272\t?%\006!?\217\302"
 & "u\2745\001\n\364\375\324<33\023?\321\"\033?\000\000\000\0005\001\n\266\363"
 & "}=^\272\t?1\010,?\217\302u\2745\001\n\266\363}=^\272\t?1\010,?\217\302u"
 & "\2745\001\n\266\363}=^\272\t?\213l\'?\217\302u\2745\001\n\266\363}=^\272"
 & "\t?\321\"\033?\217\302u\2745\001\n\266\363}=^\272\t?\354Q\030?\217\302u"
 & "\2745\001\n\016-\262=\370S\003?\240\032\357>\246\233D=5\001\n\266\363}="
 & "^\272\t?7\211\001?\n\327\243\2755\001\n1\010\254<;\337\017?1\010,?\217\302"
 & "u\2745\001\n1\010\254<;\337\017?1\010,?\217\302u\2745\001\n1\010\254<;\337"
 & "\017?\213l\'?\217\302u\2745\001\n1\010\254<;\337\017?\354Q\030?\217\302"
 & "u\2745\001\nB`\345;P\215\027?1\010,?\234\304 \2765\001\n\246\233\304\273"
 & "{\024\016?%\006!?\234\304 \2765\001\nB`\345;P\215\027?\354Q\030?\234\304"
 & " \2760005\001\0051S\000\000\0005\001\tB`\345\274\266\363=?{\024N?\000\000"
 & "\200\276\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\001\001\001\001\001\001\001\001\001\000\001\001\000\001\001\001"
 & "\000\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000";

CONST E26_12 = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\000\000\000\000\232\231\031?\232\231\031?\000\000\000\000\232"
 & "\231\031?\232\231\031?\232\231\031?\000\000\000\000\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?0000000000000000000000000000000005\001"
 & "\n\376\324x>h\221\355>\230n\022?\217\302u\2745\001\n\250\306\213>\'1\010"
 & "?;\337\017?\236\357\247>5\001\n\'1\010>u\223\030?\201\225#?o\022\003\275"
 & "5\001\n\033/\335=u\223\030?\325x)?%\006\001\2765\001\nL7\t>\020X\031?d;"
 & "\037?\217\302u\2745\001\n\016-\262=\341z\024?\f\002\013?\217\302u\2745\001"
 & "\n`\345\220>\244p\375>;\337\017?\236\357\247>5\001\n\211A\240>\230n\022"
 & "?d;\037?\033/\335\2755\001\n\272I\f>\203\300\312>d;\037?\033/\335\2755\001"
 & "\n\207\026Y>\341z\024?Zd\033?\201\225\203>5\001\n\223\030\004>\341z\024"
 & "?\327\243\360>X94=5\001\n\234\304 >\244p\275>#\333\371=B`\345\2755\001\n"
 & "\223\030\004>\341z\024?`\345\220>h\221m>5\001\nF\266s>\201\225\303>d;\337"
 & "=\217\302u\2745\001\nB`\345=\276\237\032?%\006!?\n\327\243\2755\001\n-\262"
 & "\035>33\023?d;\037?\217\302u\2745\001\n9\264\310=\n\327\003?d;\037?\000"
 & "\000\000\0005\001\n)\\\217=sh\021?d;\037?\000\000\000\0005\001\n\236\357"
 & "\247=^\272\t?d;\037?\217\302u\2745\001\n\033/\335=\372~\n?d;\037?\000\000"
 & "\000\0005\001\n\203\300\312=\264\310\026?Zd\033?\217\302u\2745\001\nR\270"
 & "\036>%\006!?d;\037?\217\302u\2745\001\n5^:>\010\254\034?Zd\033?\000\000"
 & "\000\0005\001\n\002+\007>+\207\026?d;\037?\217\302u\2745\001\n\311v\276"
 & "=\252\361\022?d;\037?\217\302u\2745\001\nF\266s>\301\312\341>\270\036\305"
 & ">\217\302u\2745\001\n\234\304 >\301\312\341>\270\036\305>B`\345\2755\001"
 & "\n\246\233\304=\366(\034?\374\251\361>1\010,=5\001\nd;\337=\232\231\031"
 & "?\022\203\300>\337O\r>5\001\n{\024\256=\020X\031?\374\251\361>1\010,=5\001"
 & "\n\370Sc>}?\025?\230n\022?\217\302u\2745\001\nJ\f\002>\364\375\024?d;\037"
 & "?\217\302u\2745\001\n\246\233D;Zd\033?;\337\017?\000\000\000\0005\001\n"
 & "\305 0=-\262\035?;\337\017?\000\000\000\0005\001\n\311v\276=\024\256\'?"
 & "\341z\024?\274t\223\2745\001\n\305 0=\270\036%?;\337\017?\000\000\000\000"
 & "5\001\n\207\026Y=\303\365(?;\337\017?\000\000\000\0005\001\n\207\026Y=\303"
 & "\365(?;\337\017?\000\000\000\0005\001\n\347\373\251=\270\036%?\341z\024"
 & "?\274t\223\2745\001\no\022\003=;\337/?;\337\017?\000\000\000\0005\001\n"
 & "\246\233\304=\356|\037?;\337\017?\000\000\000\0005\001\n\364\375T=)\\/?"
 & ";\337\017?\274t\223\2745\001\n\343\245\033=\250\306+?;\337\017?\000\000"
 & "\000\0005\001\n\022\203@=Zd\033?;\337\017?\000\000\000\0005\001\no\022\203"
 & ";=\n7?;\337\017?\000\000\000\0005\001\nB`\345;\242E6?;\337\017?\364\375"
 & "T\2745\001\n\022\203\300=\000\000 ?\341z\024?\274t\223\2745\001\n\301\312"
 & "\241=/\335$?;\337\017?\000\000\000\0005\001\n\\\217\302=\000\000 ?\341z"
 & "\024?\337O\r\2765\001\n\343\245\033=\207\026\031?;\337\017?\000\000\000"
 & "\0005\001\n\343\245\233=ff&?\341z";

CONST E26_13 = 
   "\024?\n\327\243\2745\001\n\033/\335=q=*?;\337\017?\000\000\000\0005\001"
 & "\n\000\000\000>F\2663?;\337\017?\274t\223\2745\001\n=\n\327=\207\0269?;"
 & "\337\017?\364\375T\2745\001\n\207\026\331=\376\3248?;\337\017?\364\375T"
 & "\2745\001\n\177j\274<\315\314,?;\337\017?\000\000\000\0005\001\n\'1\010"
 & ">\205\3531?;\337\017?\000\000\000\0005\001\n\305 \260=\366(\034?;\337\017"
 & "?\000\000\000\0005\001\nm\347{>\252\361\022?d;\037?\033/\335\2755\001\n"
 & "\333\371~>\262\235\357>%\006!?\n\327\243\2755\001\nq=\n>V\016\355>d;\037"
 & "?\033/\335\2755\001\n333>\242E\026?d;\037?}?\265>5\001\n\033/\335\274\006"
 & "\201\025?\232\231\231\275\000\000\000\2765\001\n\262\235\257>\347\373\351"
 & ">;\337\017?\236\357\247>5\001\n\343\245\233=\374\251\021?\301\312\341>\217"
 & "\302u\2745\001\nh\221\355<\000\000 ?%\006!?\217\302u\2745\001\n\207\026"
 & "\331=\343\245\033?\301\312\341>\217\302u\2745\001\n{\024\256=\n\327#?%\006"
 & "!?\217\302u\2745\001\n\207\026\331=\207\026\031?\301\312\341>\217\302u\274"
 & "5\001\n\325x\351=\325x)?%\006!?\000\000\000\0005\001\n#\333y=\'1(?\301\312"
 & "\341>\234\304 \2765\001\n\002+\007=P\215\027?%\006!?\000\000\000\0005\001"
 & "\n\\\217\302=\n\327\003?\'1(?\000\000\000\0005\001\n\364\375T=\315\314\f"
 & "?\'1(?\234\304 \2765\001\nh\221m=J\f\"?%\006!?\000\000\000\0005\001\n\\"
 & "\217\302=\n\327\003?%\006!?\000\000\000\0005\001\n\n\327\243\273\244p\035"
 & "?\301\312\341>\000\000\000\0005\001\n\364\375\324<\217\302\025?\301\312"
 & "\341>\000\000\000\0005\001\n`\345\320=+\207\026?\301\312\341>\217\302u\274"
 & "5\001\n\246\233\304\274H\341\032?\301\312\341>\234\304 \2765\001\n{\024"
 & "\256=\215\227.?\301\312\341>\234\304 \2765\001\n\217\302u=\345\320\"?\301"
 & "\312\341>\000\000\000\0005\001\nw\276\237=\006\201\025?\301\312\341>\217"
 & "\302u\2745\001\n\f\002+>\262\235\017?\262\235\017?\217\302u\2745\001\n\027"
 & "\331\316=\230n\022?\254\034\332>\217\302u\2745\001\n\354Q\270=\004V.?\254"
 & "\034\332>\n\327#\2745\001\n\343\245\233=\205\3531?\254\034\332>\n\327#\274"
 & "5\001\n\n\327\243<\024\256\'?\254\034\332>\000\000\000\0005\001\no\022\203"
 & "\273\027\331.?\254\034\332>\234\304 \2765\001\n\203\300\312=\331\316\027"
 & "?\254\034\332>\000\000\000\0005\001\n\215\227n>\374\251\021?d;\037?\033"
 & "/\335\2755\001\n\370Sc>\354Q\370>\000\000@?\000\000\200\2765\001\n)\\\017"
 & ">X9\364>d;\037?\033/\335\2755\001\nh\221\355=\232\231\031?\n\327\243>^\272"
 & "I>000000000000000005\001\n\\\217\302=\n\327\003?\254\034\332>\000\000\000"
 & "\0005\001\n+\207\226>\331\316\367>1\010,?\311v\376>5\001\n\016-\262>\010"
 & "\254\034?1\010,?\311v\376>5\001\n\372~j>j\274\024?\213l\'?X9\364>5\001\n"
 & "\207\026Y>%\006!?\321\"\033?5^\372>5\001\nh\221m>\232\231\031?\327\243\020"
 & "?ff\006?5\001\n\027\331\216>\274t\023?m\347\033?\211A\000?5\001\n\354Q\270"
 & ">\215\227\356>\341z\024?X9\364>5\001\n\335$\206>\205\353\021?\354Q\030?"
 & "m\347\373>05\001\n\347\373\251>\000\000\000?\022\203 ?V\016\355>5\001\n"
 & "^\272I>\305 \260>\n\327#<\276\237\032\27605\001\nj\274t>\027\331.?1\010"
 & ",?\311v\376>5\001\n\317\367S>\016-\262>\000\000\000\000\276\237\032\276"
 & "5\001\n\335$\206>\033/\035?\226C+?m\347\373>05\001\nfff>\n\327\343>\366"
 & "(\334>\234\304 \2765\001\n\276\237\032>+\207\026?\033/\035?9\264H\2755\001"
 & "\n\266\363\375=\333\371\036?\177j\034?1\010\254\2745\001\n\022\203\300="
 & "\234\304 ?7\211\001?h\221m=5\001\n\217\302\365=sh1?;\337\017?\000\000\000"
 & "\0005\001\nF\266s>\305 \360>\315\314,?333\2765\001\n\364\375\324==\n\027"
 & "?\341z\024?w\276\237\2751\023\005\000\0005\001\n\207\026Y=\203\300*?\341"
 & "z\024?\274t\223\2745\001\n\031\004V>o\022\003?\341z\024?\333\371~>5\001"
 & "\n\177j\274=y\351&?\035Z\344>)\\\217=5\001\nR\270\036>\307K\027?\221\355"
 & "\274>\033/\335=5\001\n\343\245\033>\027\331\016?\205\353\221>D\213l>5\001"
 & "\n\207\026Y=\203\300*?\341z\024?\274t\223\2741\020\005\000\0005\001\n\321"
 & "\"[>\274t\023?d;\037?^\272\211>5\001\n\246\233\304=b\020\030?\027\331\016"
 & "?X94=5\001\n\037\205k>\303\365\010?d;\037?\333\371~>5\001\n\254\034Z>\211"
 & "A\000?d;\037?\217\302u>1\r\005\000\0005\001\n\274t\223=\230n\022?\254\034"
 & "\332>\234\304 \2765\001\n\315\314\314=\256G!?;\337\017?w\276\237\2755\001"
 & "\n\315\314\214>?5\336>\213l\247>7\211A>1\025\005\000\0005\001\nD\213l>Z"
 & "d\373>d;\037?\333\371~>5\001\n=\nW>\303\365\010?\341z\024?\333\371~>5\001"
 & "\nh\221m=?5\036?\035Z\344>)\\\217=5\001\n\270\036\205=D\213,?q=*?\325xi"
 & "\2755\001\n\270\036\205=\226C+?q=*?\325xi\2755\001\n\006\201\225=9\264("
 & "?\372~*?B`e\2755\001\n=\n\327=\215\227\356>\366(\334>\234\304 \2765\001"
 & "\n\246\233D;Zd\033?\f\002K?\000\000\000\0005\001\n\246\233D;\260r(?\f\002"
 & "K?\000\000\000\0005\001\n\246\233D;Zd\033?ffF?\000\000\000\0005\001\n\246"
 & "\233D;\236\357\'?Zd;?\000\000\000\0005\001\n\246\233D;Zd\033?\321\";?\000"
 & "\000\000\0005\001\n\246\233D;Zd\033?\234\304@?\000\000\000\0005\001\n\246"
 & "\233D;\024\256\'?;\337\017?\000\000\000\0005\001\n\311v\276=\260r(?\341"
 & "z\024?\276\237\032\2765\001\n\207\026Y=\303\365(?\f\002K?\000\000\000\000"
 & "5\001\n\207\026Y=\f\002+?\f\002K?\000\000\000\0005\001\n\207\026Y=\303\365"
 & "(?ffF?\000\000\000\0005\001\n\207\026Y=\303\365(?\321\";?\000\000\000\000"
 & "5\001\n\246\233\304=\356|\037?\f\002K?\000\000\000\0005\001\n\246\233\304"
 & "=\370S#?\f\002K?\000\000\000\0005\001\n\246\233\304=\356|\037?ffF?\000\000"
 & "\000\0005\001\n\246\233\304=\356|\037?\321\";?\000\000\000\0005\001\n\305"
 & " 0=\270\036%?;\337\017?\000\000\000\0005\001\nB`\345;\242E6?Zd;?\364\375"
 & "T\2745\001\n\022\203\300=\000\000 ?\f\002K?\274";

CONST E26_14 = 
   "t\223\2745\001\n\022\203\300=\370S#?\f\002K?\274t\223\2745\001\n\022\203"
 & "\300=\000\000 ?ffF?\274t\223\2745\001\n\022\203\300=\236\357\'?Zd;?\274"
 & "t\223\2745\001\n\022\203\300=\000\000 ?\321\";?\274t\223\2745\001\n\252"
 & "\361\322=Zd\033?\327\243\360>\305 0=5\001\n\022\203\300=\000\000 ?%\006"
 & "!?\n\327\243\2755\001\n\000\000\000>F\2663?\f\002K?\274t\223\2745\001\n"
 & "\000\000\000>F\2663?\f\002K?\274t\223\2745\001\n\000\000\000>F\2663?ffF"
 & "?\274t\223\2745\001\n\000\000\000>F\2663?\321\";?\274t\223\2745\001\n\'"
 & "1\010>\205\3531?\f\002K?\000\000\000\0005\001\n\301\312\241=\321\"\033?"
 & ";\337\017?\000\000\000\0005\001\n\246\233D=\266\363\035?%\006!?\217\302"
 & "u\2745\001\n\343\245\233=\374\251\021?1\010,?\217\302u\2745\001\n\343\245"
 & "\233=\010\254\034?1\010,?\217\302u\2745\001\n\343\245\233=j\274\024?\213"
 & "l\'?\217\302u\2745\001\n\343\245\233=%\006!?\321\"\033?\217\302u\2745\001"
 & "\n\343\245\233=\205\353\021?\354Q\030?\217\302u\2745\001\n\343\245\233="
 & "\374\251\021?\022\203 ?\217\302u\2745\001\n\236\357\'=\211A ?\301\312\341"
 & ">\217\302u\2745\001\n\207\026\331=\033/\035?\301\312\341>\276\237\032\276"
 & "5\001\n\207\026\331=\207\026\031?1\010,?\217\302u\2745\001\n\207\026\331"
 & "=\010\254\034?1\010,?\217\302u\2745\001\n\207\026\331=\207\026\031?\213"
 & "l\'?\217\302u\2745\001\n\207\026\331=\207\026\031?\354Q\030?\217\302u\274"
 & "5\001\n\\\217\302=\n\327\003?1\010,?\000\000\000\0005\001\n\\\217\302=\010"
 & "\254\034?1\010,?\000\000\000\0005\001\n\\\217\302=V\016\r?\213l\'?\000\000"
 & "\000\0005\001\n\\\217\302=q=\n?\354Q\030?\000\000\000\0005\001\n`\345\320"
 & "=\201\225#?%\006!?\217\302u\2745\001\n\364\375\324<%\006!?\321\"\033?\000"
 & "\000\000\0005\001\n`\345\320=+\207\026?1\010,?\217\302u\2745\001\n`\345"
 & "\320=\010\254\034?1\010,?\217\302u\2745\001\n`\345\320=+\207\026?\213l\'"
 & "?\217\302u\2745\001\n`\345\320=%\006!?\321\"\033?\217\302u\2745\001\n`\345"
 & "\320=+\207\026?\354Q\030?\217\302u\2745\001\n\226C\013>!\260\022?\240\032"
 & "\357>\246\233D=5\001\n`\345\320=+\207\026?7\211\001?\n\327\243\2755\001"
 & "\n\027\331\316=\230n\022?1\010,?\217\302u\2745\001\n\027\331\316=\254\034"
 & "\032?1\010,?\217\302u\2745\001\n\027\331\316=\230n\022?\213l\'?\217\302"
 & "u\2745\001\n\027\331\316=\230n\022?\354Q\030?\217\302u\2745\001\no\022\203"
 & "\273\027\331.?1\010,?\234\304 \2765\001\n\246\233\304\274H\341\032?%\006"
 & "!?\234\304 \2765\001\no\022\203\273\027\331.?\354Q\030?\234\304 \2765\001"
 & "\00512\000\000\0005\001\t{\024.\276Nb\200?\242Ev?\325xi\276\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\001\001"
 & "\001\001\001\001\001\001\000\001\001\000\001\001\001\000\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\004V\216>\372~\252>!\260\362>\004V\016?\004V\016?\201\225c"
 & "?\376\3248?\004V\216>\372~\252>\372~\252>\002+\307>\006\201\025?\004V\216"
 & ">\006\201\025?\004V\216>\004V\216>\004V\016?\004V\016?\004V\016?\004V\016"
 & "?\004V\016?\004V\016?\004V\016?\004V\016?\004V\016?\004V\016?\372~\252>"
 & "\372~\252>\006\201\025?\006\201\025?\006\201\025?\177j\034?\232\231y?\376"
 & "\3248?\376\3248?\376\3248?\376\3248?\203\300*?\177j\034?\002+G?\376\324"
 & "8?\004V\216>\004V\016?\376\3248?\177j\034?}?U?\376\3248?\002+G?\203\300"
 & "*?\002+G?\376\3248?\203\300*?\177j\034?\376\3248?\203\300*?\374\251q?\203"
 & "\300*?\203\300*?\177j\034?\372~\252>\004V\216>\372~\252>\006\201\025?\004"
 & "V\016?\004V\216>\004V\016?\177j\034?\004V\016?\177j\034?\004V\016?\372~"
 & "\252>\177j\034?\177j\034?\004V\216>\004V\216>\004V\016?\004V\216>\201\225"
 & "c?\177j\034?\177j\034?\177j\034?\177j\034?\002+\307>\004V\016?\372~\252"
 & ">\177j\034?\004V\016?\002+G?\004V\016?\004V\016?\000\000\000?\002+\307>"
 & ")\\\217>\002+\307>\006\201\025?\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\004V\216>\372~\252>\372~\252>\372~\252>\372~\252>\372~"
 & "\252>\372~\252>\372~\252>\372~\252>\000\000\000\000\372~\252>\372~\252>"
 & "\000\000\000\000\372~\252>\372~\252>\372~\252>\000\000\000\000\372~\252"
 & ">\004V\016?\004V\016?\004V\016?\004V\016?)\\\217>\004V\016?\372~\252>\010"
 & "\254<?\244p\275>\004V\016?\006\201\025?\372~\252>\010\254<?\372~\252>\315"
 & "\314\314>\006\201\025?\372~\252>\372~\252>\372~\252>\177j\034?\004V\016"
 & "?\004V\216>\372~\252>\372~\252>H\341\272>\004V\016?\006\201U?\006\201U?"
 & "\006\201U?\177j\034?\376\3248?\376\3248?\376\3248?\376\3248?\376\3248?\376"
 & "\3248?\000\000\200?\376\3248?\203\300*?\203\300*?\203\300*?\203\300*?\004"
 & "V\216>\004V\216>\004V\216>\004V\216>\376\3248?\376\3248?\002+G?\002+G?\002"
 & "+G?\002+G?\002+G";

CONST E26_15 = 
   "?\006\201\025?\002+G?\376\3248?\376\3248?\376\3248?\376\3248?\203\300*?"
 & "\203\300*?\177j\034?\004V\016?\004V\016?\004V\016?\004V\016?\004V\016?\004"
 & "V\016?\201\225c?\004V\016?\004V\016?\004V\016?\004V\016?\004V\016?\004V"
 & "\216>\004V\216>\004V\216>\004V\216>\177j\034?\177j\034?\177j\034?\177j\034"
 & "?\177j\034?\177j\034?\177j\034?\006\201\025?\177j\034?\177j\034?\177j\034"
 & "?\177j\034?\177j\034?\004V\016?\177j\034?\004V\016?00000000000000000000"
 & "00000000000005\001\n\354Q\270=#\333y>\331\3167?\000\000\000\0005\001\n9"
 & "\264\310=\022\203\300>\331\3167?/\335\344>5\001\n\274t\223<^\272\t?!\260"
 & "2?\000\000\000\0005\001\n\217\302\365<T\343\005?ffF?\037\205\353\2755\001"
 & "\nB`\345<\177j\\?\217\3025?\343\245\233\2745\001\n\033/]=\274t3?\331\316"
 & "7?\343\245\233\2745\001\n\337O\215=\031\004V>\331\3167?\n\327\343>5\001"
 & "\n)\\\017=\234\304\240>m\347;?\364\375T\2765\001\n\343\245\233<u\223\230"
 & ">m\347;?\364\375T\2765\001\n\033/\335<\020X\271>\331\3167?\335$\306>5\001"
 & "\n\n\327#=\226C\013?7\211\001?\000\000\000\0005\001\no\022\203=\321\"[>"
 & "\006\201\025>1\010,\2765\001\n\n\327#=\226C\013??5\236>^\272I>5\001\no\022"
 & "\203=\321\"[>\006\201\025>\000\000\000\0005\001\n\002+\007\275d;\237>\010"
 & "\254<?\343\245\233\2745\001\no\022\003=\335$\006?\217\3025?\343\245\233"
 & "\2745\001\n\337O\215=7\211\301>\217\3025?\000\000\000\0005\001\n\364\375"
 & "\324<\345\320\002?\217\3025?\000\000\000\0005\001\n\033/\335<\223\030\004"
 & "?\217\3025?\343\245\233\2745\001\n\033/\335<\360\247\006?\217\3025?\000"
 & "\000\000\0005\001\n\033/\335<\223\030\004?!\2602?\343\245\233\2745\001\n"
 & "\266\363\375<\270\036\005?\217\3025?\343\245\233\2745\001\n\315\314\314"
 & "<\002+\007?!\2602?\000\000\000\0005\001\no\022\003=\335$\006?\217\3025?"
 & "\343\245\233\2745\001\n\217\302\365<\313\241\005?\217\3025?\343\245\233"
 & "\2745\001\n\177j\274=\331\316w>o\022\003?\000\000\000\0005\001\n\177j\274"
 & "=\331\316w>o\022\003?1\010,\2765\001\n\343\245\033=\250\306\013?\201\225"
 & "\003?o\022\003\2745\001\n\n\327#=\226C\013?+\207\326>\016-\262=5\001\n\343"
 & "\245\033=\250\306\013?\201\225\003?o\022\003\2745\001\n\217\302u=\004V\016"
 & "?\254\034:?\000\000\000\0005\001\n\374\251\361=\321\"[?\010\254<?\343\245"
 & "\233\2745\001\n\n\327\243<F\2663?\331\3167?\000\000\000\0005\001\n\343\245"
 & "\233=\226C+?\331\3167?\000\000\000\0005\001\nX94=\240\032/?\010\254<?\343"
 & "\245\233\2745\001\n\343\245\233=)\\/?\331\3167?\000\000\000\0005\001\n\343"
 & "\245\233=\333\371\036?\331\3167?\000\000\000\0005\001\n\343\245\233=\242"
 & "E\026?\331\3167?\000\000\000\0005\001\nX94=+\2076?\010\254<?\343\245\233"
 & "\2745\001\nsh\221=\360\247&?\331\3167?\000\000\000\0005\001\no\022\203="
 & "\321\"[>\331\3167?\000\000\000\0005\001\nX9\264<\331\316\367>\331\3167?"
 & "\274t\223\2745\001\n\016-\262=\376\3248?\331\3167?\000\000\000\0005\001"
 & "\n\343\245\233=}?\025?\331\3167?\000\000\000\0005\001\n\337O\215=\n\327"
 & "C?\331\3167?\000\000\000\0005\001\n\337O\215=\213l\'?\331\3167?\000\000"
 & "\000\0005\001\nX94=m\347;?\010\254<?\343\245\233\2745\001\n\343\245\233"
 & "=\022\203 ?\331\3167?\000\000\000\0005\001\nX94=\010\254<?\010\254<?\364"
 & "\375T\2755\001\n\343\245\233=\337O-?\331\3167?\000\000\000\0005\001\nw\276"
 & "\037=%\006!?\010\254<?\343\245\233\2745\001\nB`e<\207\026\031?\331\3167"
 & "?\000\000\000\0005\001\n\274t\223=\360\247&?\331\3167?\343\245\233\2745"
 & "\001\n\343\245\233<T\343%?\331\3167?\000\000\000\0005\001\no\022\203<\362"
 & "\322m?\331\3167?\000\000\000\0005\001\nB`e<\002+\'?\331\3167?\000\000\000"
 & "\0005\001\n\217\302u<\002+\'?\331\3167?\000\000\000\0005\001\n\315\314\314"
 & "<\031\004\026?\331\3167?\000\000\000\0005\001\n%\006\201=?5\236>\376\324"
 & "8?9\264H\2765\001\n\002+\007\275d;\237>\010\254<?\343\245\233\2745\001\n"
 & "\246\233\304<q=\212>\376\3248?9\264H\2765\001\n\266\363}=\313\241\005?!"
 & "\2602?B`\245>5\001\n\000\000\000\000\004V\016?\232\231\231\275\000\000\000"
 & "\2765\001\n\337O\215=\031\004V>\254\034:?\260r\350>5\001\nh\221\355<y\351"
 & "\006?\250\306\013?B`e\2745\001\n#\333y=\317\367\023?\331\3167?B`e\2745\001"
 & "\n\226C\013=\335$\006?\250\306\013?B`e\2745\001\n\226C\013=V\016\r?\331"
 & "\3167?B`e\2745\001\n\177j\274<\002+\007?\250\306\013?B`e\2745\001\n\n\327"
 & "#<\345\320\242>\254\034:?\000\000\000\0005\001\n\n\327#=h\221\r?\250\306"
 & "\013??5^\2765\001\n\270\036\205=\250\306\013?\331\3167?\000\000\000\000"
 & "5\001\n\337O\215=\031\004V>\232\2319?\000\000\000\0005\001\n\246\233D;\031"
 & "\004V>\232\2319?\321\"[\2765\001\n\337O\215=;\337\017?\331\3167?\000\000"
 & "\000\0005\001\n\337O\215=\031\004V>\331\3167?\000\000\000\0005\001\no\022"
 & "\203=\274tS?\250\306\013?\000\000\000\0005\001\n\270\036\205=\250\306\013"
 & "?\250\306\013?\000\000\000\0005\001\n\226C\013=\317\367\023?\250\306\013"
 & "?B`e\2745\001\n\266\363}=\317\367\023?\250\306\013?\317\367S\2765\001\n"
 & "\226C\013=\337O\r?\250\306\013?\317\367S\2765\001\no\022\203=\333\371\276"
 & ">\250\306\013?\000\000\000\0005\001\n\217\302\365</\335\004?\250\306\013"
 & "?B`e\2745\001\n\n\327#<?5\236>V\016-?\246\233\304\2735\001\n\002+\207=\037"
 & "\205\013?\'1\010?B`e\2745\001\n\364\375T<\f\002\013?\'1\010?\000\000\000"
 & "\0005\001\n\n\327#</\335D?\'1\010?\000\000\000\0005\001\n\217\302u<\372"
 & "~\n?\'1\010?\000\000\000\0005\001\n\n\327#<\347\373\t?\'1\010?\321\"[\276"
 & "5\001\n\n\327\243<\217\302\365>\'1\010?\000\000\000\0005\001\n\246\233D"
 & "=H\341\272>\376\3248?9\264H\2765\001\n1\010\254=9\264H>\010\254<?\343\245"
 & "\233\2745\001\n\246\233\304<\215\227\256>\376\3248?9\264H\2765\001\n#\333"
 & "y=T\343\005?\262\235\257>y\351&>0000000000000000";

CONST E26_16 = 
   "05\001\n\337O\215=\031\004V>\'1\010?\000\000\000\0005\001\n\177j\274\274"
 & "fff>\000\000@?\276\237\032?5\001\n\033/\335=\242E\266>\000\000@?\276\237"
 & "\032?5\001\n\n\327#\274\262\235\257>\000\000@?\276\237\032?5\001\n\226C"
 & "\213\27433\263>\010\254<?\366(\034?5\001\n\246\233\304\273h\221\255>h\221"
 & "-?\276\237\032?5\001\no\022\003\273\037\205\253>\000\000@?\276\237\032?"
 & "5\001\n\364\375\324=\037\205k>\276\237:?\033/\035?5\001\n\246\233\304;\213"
 & "l\247>\276\237:?\033/\035?05\001\n\374\251q=\315\314\214>\360\247F?sh\021"
 & "?5\001\n\246\233\304;H\341z>\000\000\000\000\325xi\27605\001\n\274t\023"
 & "<\376\324\370>\000\000@?\276\237\032?5\001\nsh\221=\343\245\233>\000\000"
 & "\000\000\325xi\2765\001\n\n\327#\274\262\235\257>\000\000@?\276\237\032"
 & "?05\001\n\354Q\270=#\333y>\'1\010?\311v>\2765\001\n\226C\013=\335$\006?"
 & "\234\304 ?\374\251\361\2755\001\nB`\345<\372~\n?\331\3167?o\022\203\274"
 & "5\001\n\246\233D\273\240\032\017?\345\320\"?\343\245\233=5\001\n\274t\023"
 & "\274\327\243\020?!\2602?\000\000\000\0005\001\n1\010\254=9\264H>\010\254"
 & "<?\343\245\233\2745\001\n\226C\013=\313\241\005?\254\034:?\177j<\2761\334"
 & "\005\000\0005\001\nX94\274w\276??\010\254<?\343\245\233\2745\001\nX9\264"
 & "<\374\251\261>\010\254<?\337O\215>5\001\nX9\264=\262\235\357>\331\316\367"
 & ">\343\245\233=5\001\n\n\327#=\226C\013?+\207\326>\033/\335=5\001\n\033/"
 & "\335<\010\254\234>\327\243\260>\366(\\>5\001\nX94\274\356|??\010\254<?\343"
 & "\245\233\2741\331\005\000\0005\001\n\325xi=\262\235\257>\242E6?\254\034"
 & "\332>5\001\n\n\327#=\226C\013?7\211\001?\000\000\000\0005\001\n\274t\023"
 & "<T\343\245>\217\3025?`\345\220>5\001\no\022\003<y\351\246>\217\3025?\203"
 & "\300\212>1\326\005\000\0005\001\n\002+\207=\037\205\013?\'1\010?\317\367"
 & "S\2765\001\no\022\003\274\347\373\t?333?\201\225C\2765\001\nh\221m=\256"
 & "Ga>\f\002\253>\305 0>1\336\005\000\0005\001\n\364\375\324<!\260r>\217\302"
 & "5?`\345\220>5\001\n\246\233\304;\354Q\270>\010\254<?\337O\215>5\001\nX9"
 & "\264=\262\235\357>\331\316\367>\343\245\233=5\001\n\364\375\324<\223\030"
 & "D?\217\3025?\343\245\233\2745\001\n\364\375\324<\226CK?\217\3025?\343\245"
 & "\233\2745\001\no\022\203<D\213L?\217\3025?\343\245\233\2745\001\n\256Ga"
 & "=V\016\r?\'1\010?\024\256G\2765\001\n\n\327\243<F\2663?\262\235o?\000\000"
 & "\000\0005\001\n\n\327\243<F\2663?\262\235o?\000\000\000\0005\001\n\n\327"
 & "\243<F\2663?\262\235o?\000\000\000\0005\001\n\n\327\243<F\2663?\272Il?\000"
 & "\000\000\0005\001\n\n\327\243<F\2663?q=j?\000\000\000\0005\001\n\n\327\243"
 & "<F\2663?\242Ev?\000\000\000\0005\001\n\n\327\243;X9t?\331\3167?\000\000"
 & "\000\0005\001\nX94=\240\032/?\010\254<?\325xi\2765\001\n\343\245\233=\333"
 & "\371\036?\262\235o?\000\000\000\0005\001\n\343\245\233=\333\371\036?\262"
 & "\235o?\000\000\000\0005\001\n\343\245\233=\333\371\036?\262\235o?\000\000"
 & "\000\0005\001\n\343\245\233=\333\371\036?q=j?\000\000\000\0005\001\n\315"
 & "\314L\275\321\"[>\262\235o?\000\000\000\0005\001\no\022\203=\260r\250>\262"
 & "\235o?\000\000\000\0005\001\nP\215\027\275\301\312\241>\262\235o?\000\000"
 & "\000\0005\001\n1\010\254\274\232\231\231>q=j?\000\000\000\0005\001\n\n\327"
 & "\243\273)\\/?\331\3167?\000\000\000\0005\001\n\337O\215=\213l\'?\272Il?"
 & "\000\000\000\0005\001\nX94=m\347;?\262\235o?\343\245\233\2745\001\nX94="
 & "m\347;?\262\235o?\343\245\233\2745\001\nX94=m\347;?\262\235o?\343\245\233"
 & "\2745\001\nX94=m\347;?\272Il?\343\245\233\2745\001\nX94=m\347;?q=j?\343"
 & "\245\233\2745\001\n\n\327#=\037\205\013?\256G\001?o\022\203:5\001\n\002"
 & "+\007=\311v>?R\270>?\033/\335\2745\001\n\274t\223=\360\247&?\262\235o?\343"
 & "\245\233\2745\001\n\274t\223=\360\247&?\262\235o?\343\245\233\2745\001\n"
 & "\274t\223=\360\247&?\262\235o?\343\245\233\2745\001\n\274t\223=\360\247"
 & "&?q=j?\343\245\233\2745\001\n\217\302u<\002+\'?\262\235o?\000\000\000\000"
 & "5\001\n\343\245\233=\022\203 ?\331\3167?\000\000\000\0005\001\n\337O\215"
 & "=X9\024?\321\";?B`e\2745\001\nh\221\355<y\351\006?\000\000@?B`e\2745\001"
 & "\nh\221\355<y\351\006?\000\000@?B`e\2745\001\nh\221\355<y\351\006?\000\000"
 & "@?B`e\2745\001\nh\221\355<y\351\006?\010\254<?B`e\2745\001\nh\221\355<y"
 & "\351\006?\276\237:?B`e\2745\001\nh\221\355<y\351\006?\360\247F?B`e\2745"
 & "\001\nh\221\355<\343\245[?\250\306\013?B`e\2745\001\n\226C\013=\335$\006"
 & "?\250\306\013?\325xi\2765\001\n\177j\274<\002+\007?\000\000@?B`e\2745\001"
 & "\n\177j\274<\002+\007?\000\000@?B`e\2745\001\n\177j\274<\002+\007?\000\000"
 & "@?B`e\2745\001\n\177j\274<\002+\007?\276\237:?B`e\2745\001\n\315\314L\275"
 & "\031\004V>\000\000@?\000\000\000\0005\001\n\337O\215=\260r\250>\000\000"
 & "@?\000\000\000\0005\001\nP\215\027\275\301\312\241>\000\000@?\000\000\000"
 & "\0005\001\n1\010\254\274\232\231\231>\276\237:?\000\000\000\0005\001\n\226"
 & "C\013=\317\367\023?\010\254<?B`e\2745\001\n\270\036\205=\250\306\013?\010"
 & "\254<?\000\000\000\0005\001\n\226C\013=\317\367\023?\000\000@?B`e\2745\001"
 & "\n\226C\013=\317\367\023?\000\000@?B`e\2745\001\n\226C\013=\317\367\023"
 & "?\000\000@?B`e\2745\001\n\226C\013=\317\367\023?\010\254<?B`e\2745\001\n"
 & "\226C\013=\317\367\023?\276\237:?B`e\2745\001\n\n\327#=\226C\013?\272I\f"
 & "?1\010,\2755\001\nX9\264<\264\310\026?)\\\017?h\221\355\2745\001\n\002+"
 & "\207=\037\205\013?\000\000@?B`e\2745\001\n\002+\207=\037\205\013?\000\000"
 & "@?B`e\2745\001\n\002+\207=\037\205\013?\000\000@?B`e\2745\001\n\002+\207"
 & "=\037\205\013?\276\237:?B`e\2745\001\n\n\327#<\347\373\t?\000\000@?\321"
 & "\"[\2765\001\n\266\363}=\317\367\023?\331\3167?\364\375T\276";

CONST E26_17 = 
   "5\001\n\n\327#<\347\373\t?\276\237:?\321\"[\2765\001\0051\232\000\000\000"
 & "5\001\tV\016-\276\256G\201?J\fb??5^\276\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\001\001\001\001\001\001\001\001"
 & "\001\000\001\001\000\001\001\001\000\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\200>\372~\252>=\n\327>\000\000\000?\000\000\000?}?U?\002+G?\372~\252>\372"
 & "~\252>\372~\252>\000\000\000?\315\314,?\000\000\200>\315\314,?\000\000\200"
 & ">\004V\216>\000\000\000?\000\000\000?\000\000\000?\000\000\000?\000\000"
 & "\000?\000\000\000?\000\000\000?\000\000\000?\000\000\000?\000\000\000?\372"
 & "~\252>\372~\252>\315\314,?\315\314,?\315\314,?\000\000\000?\037\205k?\177"
 & "j\034?\177j\034?\203\300*?\376\3248?\177j\034?\177j\034?\376\3248?\376\324"
 & "8?\372~\252>\370S\343>\203\300*?\004V\016?}?U?\203\300*?\376\3248?\177j"
 & "\034?\376\3248?\177j\034?\000\000\000?\004V\016?\376\3248?\177j\034?}?U"
 & "?\177j\034?\004V\016?\004V\016?\002+\307>\004V\216>\002+\307>b\020\330>"
 & "\000\000\000?\372~\252>\000\000\000?\000\000\000?\370S\343>\000\000\000"
 & "?\370S\343>\004V\216>\000\000\000?\000\000\000?\004V\216>\004V\216>\370"
 & "S\343>\004V\216>\376\3248?\000\000\000?\000\000\000?\000\000\000?\000\000"
 & "\000?\002+\307>\002+\307>\004V\216>\000\000\000?\370S\343>\203\300*?\370"
 & "S\343>\370S\343>\002+\307>\315\314\314>\315\314\214>\315\314\314>\372~\n"
 & "?\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004V\216>\372~"
 & "\252>\372~\252>\372~\252>\372~\252>\372~\252>\372~\252>\372~\252>\372~\252"
 & ">\000\000\000\000\372~\252>\372~\252>\000\000\000\000\372~\252>\372~\252"
 & ">\372~\252>\000\000\000\000\002+\307>\000\000\000?\000\000\000?\000\000"
 & "\000?\000\000\000?\315\314\214>\000\000\000?\372~\252>\\\217B?\337O\215"
 & ">\000\000\000?\315\314,?\372~\252>\\\217B?\372~\252>\315\314\314>\315\314"
 & ",?\232\231\231>\232\231\231>\372~\252>\000\000\000?T\343\005?\000\000\200"
 & ">\372~\252>\232\231\231>R\270\236>\000\000\000?\000\000@?\000\000@?\000"
 & "\000@?\000\000\000?\177j\034?\177j\034?\177j\034?\177j\034?\177j\034?\177"
 & "j\034?\201\225c?\203\300*?\177j\034?\177j\034?\177j\034?\177j\034?\372~"
 & "\252>\372~\252>\372~\252>\372~\252>\376\3248?\203\300*?\376\3248?\376\324"
 & "8?\376\3248?\376\3248?\376\3248?\315\314,?\376\3248?\376\3248?\376\3248"
 & "?\376\3248?\376\3248?\004V\016?\177j\034?\000\000\000?\000\000\000?\000"
 & "\000\000?\000\000\000?\000\000\000?\000\000\000?\000\000\000?\203\300*?"
 & "\370S\343>\370S\343>\370S\343>\370S\343>\370S\343>\004V\216>\004V\216>\004"
 & "V\216>\004V\216>\000\000\000?\000\000\000?\000\000\000?\000\000\000?\000"
 & "\000\000?\000\000\000?\000\000\000?\315\314,?\000\000\000?\000\000\000?"
 & "\000\000\000?\000\000\000?\000\000\000?\370S\343>\000\000\000?\370S\343"
 & ">0000000000000000000000000000000005\001\nw\276\037=\276\237\232>\203\300"
 & "*?X94\2745\001\n\274t\023>\033/\335>\372~*?P\215\327>5\001\no\022\003;q"
 & "=\n?V\016-?\000\000\000\0005\001\n\266\363\375<\311v\376>\321\";?\242E\266"
 & "\2755\001\n\301\312\241=q=J?V\016-?\364\375T\2745\001\n\343\245\233=\207"
 & "\0269?\372~*?\274t\223\2745\001\n\276\237\032>\341z\224>\372~*?d;\337>5"
 & "\001\n1\010,=\256G\241>\226C+?\020X9\2765\001\no\022\203<\317\367\223>\226"
 & "C+?\354Q8\2765\001\no\022\003>m\347\373>\372~*?\\\217\202>5\001\n\305 \260"
 & "==\n\027?7\211\001?\000\000\000\0005\001\no\022\203\273q=\n>\027\331\316"
 & "=\223\030\004\2765\001\n\305 \260==\n\027?\230n\222>\256Ga>5\001\n\033/"
 & "\335<\337O\r>\315\314\314=X94\2745\001\n\270\036\205\275\313\241\305>\372"
 & "~*?\274t\223\2745\001\no\022\003=\311v\376>V\016-?B`\345\2735\001\n9\264"
 & "H=sh\321>V\016-?\000\000\000\0005\001\n\246\233D<\213l\347>V\016-?\000\000"
 & "\000\0005\001\n\217\302u<{\024\356>V\016-?B`\345\2735\001\no\022\203:}?"
 & "\365>V\016-?\000\000\000\0005\001\n\217\302u<Zd\373>\372~*?B`\345\2735\001"
 & "\n\217\302\365<B`\005?\262\235/?B`\345\2735\001\n\232\231\231=\325x\t?\372"
 & "~*?o\022\003\2745\001\n\217\302\365<\177j\374>V\016-?B`\345\2735\001\n\177"
 & "j\274<m\347\373>V\016-?\226C\213\2745\001\n\315\314L=\313\241\205>\301\312"
 & "\341>X94\2745\001\n\033/\335<\313\241\205>\301\312\341>\223\030\004\276"
 & "5\001\n1\010\254=P\215\027?\201\225\003?o\022\003\2745\001\n\305 \260=="
 & "\n\027?\313\241\305>\217\302\365=5\001\n1\010\254=P\215\027?\201\225\003"
 & "?o\022\003\2745\001\n\002+\007>\374\251\361>\347\373)?\246\233D\2745\001"
 & "\n\374\251\361=\004VN?\372~*?\274t\223\2745\001\n`\345P\275Nb\020?\f\002"
 & "+?\000\000\000\0005\001\no\022\003\274+\207\026?\002+\'";

CONST E26_18 = 
   "?\000\000\000\0005\001\n\002+\207=Nb0?\372~*?\274t\223\2745\001\no\022\003"
 & "\274333?\002+\'?\000\000\000\0005\001\no\022\203\272\323M\"?\002+\'?\000"
 & "\000\000\0005\001\no\022\003<\270\036%?\002+\'?\000\000\000\0005\001\n\364"
 & "\375T=\376\3248?\372~*?\274t\223\2745\001\no\022\003\274\035ZD?\002+\'?"
 & "\000\000\000\0005\001\no\022\003\274\246\233\304>\002+\'?\000\000\000\000"
 & "5\001\n\246\233\304\273Zd\373>\002+\'?\274t\223\2745\001\nB`\345;\376\324"
 & "8?\002+\'?\000\000\000\0005\001\no\022\003\274\240\032\017?\002+\'?\000"
 & "\000\000\0005\001\n\274t\223\274\356|_?\002+\'?\000\000\000\0005\001\n\n"
 & "\327\243\274\254\034:?\002+\'?\217\302u\2745\001\n\217\302u=\252\3612?\372"
 & "~*?\274t\223\2745\001\n\000\000\000\000H\341\032?\002+\'?\000\000\000\000"
 & "5\001\n\374\251q=\252\3612?\372~*?5^:\2765\001\n\364\375T\274+\207\026?"
 & "\002+\'?\000\000\000\0005\001\n\226C\213<J\f\002?\203\300*?\274t\223\274"
 & "5\001\n\374\251q=J\f\"?\002+\'?\000\000\000\0005\001\n`\345\320=\n\327C"
 & "?\002+\'?\274t\223\2745\001\n\343\245\233=\305 0?\002+\'?\274t\223\2745"
 & "\001\nsh\221=\236\357g?\002+\'?\274t\223\2745\001\nh\221\355\274\024\256"
 & "\'?\002+\'?\000\000\000\0005\001\nw\276\237=J\f\"?\002+\'?\000\000\000\000"
 & "5\001\n\246\233\304\273\321\"\033?\002+\'?\000\000\000\0005\001\n1\010\254"
 & "<\'1\310>^\272)?\010\254\034\2765\001\n\236\357\'\275\370S\243>\372~*?\274"
 & "t\223\2745\001\n\246\233D<\201\225\303>^\272)?\010\254\034\2765\001\n\000"
 & "\000\000\000b\020\330>\372~*?\254\034\232>5\001\n\000\000\000\000\000\000"
 & "\000?\232\231\231\275\000\000\000\2765\001\n\240\032/>R\270\236>\372~*?"
 & "d;\337>5\001\n\226C\213<F\266\363>\301\312\341>X94\2745\001\n\177j\274<"
 & "\016-\362>\027\331.?X94\2745\001\n\217\302\365<\232\231\331>\301\312\341"
 & ">X94\2745\001\n\217\302u<y\351\006?\027\331.?\364\375T\2745\001\n\266\363"
 & "\375<\252\361\322>\301\312\341>X94\2745\001\n+\207\026\276\207\026\331>"
 & "h\221-?\317\367S\2765\001\no\022\003<\374\251\361>\301\312\341>\252\361"
 & "R\2765\001\n\343\245\233<j\274\364>\027\331.?\274t\023\2745\001\n9\264H"
 & "=\002+\207>\213l\'?X94\2745\001\n\266\363\375\275\337O\215>\213l\'?\317"
 & "\367S\2765\001\nB`e<1\010\354>\027\331.?X94\2745\001\n\236\357\'=\027\331"
 & "\216>\027\331.?X94\2745\001\n\246\233D<X94?\301\312\341>\274t\023\2745\001"
 & "\nB`e<!\260\362>\301\312\341>\274t\023\2745\001\n\033/\335<\262\235\357"
 & ">\301\312\341>X94\2745\001\n\232\231\231\275\305 \360>\301\312\341>\205"
 & "\353Q\2765\001\n\315\314\314<\307K\367>\301\312\341>\031\004V\2765\001\n"
 & "\354Q8=\252\361\322>\301\312\341>\000\000\000\0005\001\no\022\203<Zd\273"
 & ">\323M\342>\364\375T\2745\001\nP\215\027=P\215\227>\250\306\013?X94\274"
 & "5\001\n1\010,=33\363>\301\312\341>X94\2745\001\n1\010\254<\254\034\332>"
 & "\301\312\341>\274t\223\2745\001\no\022\203<T\343%?\301\312\341>\274t\223"
 & "\2745\001\n\033/\335\274/\335\344>\301\312\341>X94\2745\001\n\246\233\304"
 & "\274\254\034\332>\301\312\341>\252\361R\2765\001\no\022\003\273\\\217\302"
 & ">\321\"\333>T\343\245\2755\001\n`\345P=Nb\320>;\337/?}?5\2765\001\n=\n\327"
 & "=\240\032/>\372~*?\274t\223\2745\001\nB`\345\273!\260\262>;\337/?}?5\276"
 & "5\001\n\n\327#=\022\203\000?B`\245>Zd;>000000000000000005\001\n9\264H=\327"
 & "\243p>\301\312\341>X94\2745\001\n\331\316\367=d;\237>\347\373)?m\347\373"
 & ">5\001\n\354Q8>\004V\316>\347\373)?\221\355\374>5\001\n5^\272=\270\036\305"
 & ">L7)?m\347\373>5\001\n\315\314\314=\276\237\332>w\276\037?\035Z\004?5\001"
 & "\n\203\300\312=\230n\322>}?\025?\'1\010?5\001\n\262\235\357=\031\004\326"
 & ">ff&?m\347\373>5\001\n\317\367S>\366(\234>\321\"\033?J\f\002?5\001\n\321"
 & "\"\333=)\\\317>\321\"\033?J\f\002?05\001\nR\270\036>\217\302\265>`\3450"
 & "?m\347\373>5\001\n\217\302\365\2745^:>\000\000\000\000?5^\27605\001\n\311"
 & "v\276=\376\324\370>\347\373)?\221\355\374>5\001\n\n\327\243\274\315\314"
 & "L>\n\327#=V\016-\2765\001\n\331\316\367=\254\034\332>L7)?m\347\373>05\001"
 & "\n\374\251q=/\335\244>\016-\362>\205\353Q\2765\001\n-\262\235=\374\251\361"
 & ">)\\\017?\230n\022\2765\001\n\n\327#<\035Z\004?\037\205+?\246\233\304\273"
 & "5\001\nX9\264\274\313\241\005?\376\324\030?\207\026Y=5\001\n\033/\335<5"
 & "^\032?\002+\'?\000\000\000\0005\001\n=\n\327=\240\032/>\372~*?\274t\223"
 & "\2745\001\n\207\026Y=1\010\354>\372~*?T\343%\2761\245\006\000\0005\001\n"
 & "\236\357\'=b\0208?\372~*?\274t\223\2745\001\n1\010,=X9\264>V\016-?;\337"
 & "\317>5\001\n\207\026Y=\n\327\343>\004V\316>P\215\027=5\001\n\305 \260=="
 & "\n\027?\313\241\305>\033/\335=5\001\n9\264H=Nb\220>\\\217\202>\246\233D"
 & ">5\001\n\236\357\'=b\0208?\372~*?\274t\223\2741\242\006\000\0005\001\n\027"
 & "\331\316=\335$\306>V\016-?\024\256\307>5\001\n\305 \260==\n\027?7\211\001"
 & "?\000\000\000\0005\001\n\002+\007=T\343\245>V\016-?\203\300\212>5\001\n"
 & "\305 0=h\221\255>V\016-?L7\211>1\237\006\000\0005\001\n\217\302\365\274"
 & "\311v\376>\321\"\333>\031\004V\2765\001\n\256Ga=-\262\035?\002+\'?m\347"
 & "\373\2755\001\n)\\\217=\020X9>R\270\236>\250\306K>1\247\006\000\0005\001"
 & "\n\305 0=sh\221>V\016-?\203\300\212>5\001\nL7\211=\020X\271>V\016-?;\337"
 & "\317>5\001\n\256Ga=/\335\344>\004V\316>P\215\027=5\001\n\002+\007=\177j"
 & "<?V\016-?\n\327#\2745\001\n\226C\013=w\276??V\016-?\n\327#\2745\001\n\177"
 & "j\274<\177j<?V\016-?\n\327#\2745\001\nB`\345<\177j\274>\351&\361>\205\353"
 & "Q\2765\001\n`\345P\275Nb\020?\211A`?\000\000\000\0005\001\n`\345P\275Nb"
 & "\020?\211A`?\000\000";

CONST E26_19 = 
   "\000\0005\001\n`\345P\275Nb\020?\356|_?\000\000\000\0005\001\n`\345P\275"
 & "`\345\020?\031\004V?\000\000\000\0005\001\n`\345P\275Nb\020?shQ?\000\000"
 & "\000\0005\001\n`\345P\275Nb\020?J\fb?\000\000\000\0005\001\n\033/\335\274"
 & "L7i?\002+\'?\000\000\000\0005\001\n\002+\207=Nb0?\372~*??5^\2765\001\no"
 & "\022\203\272\323M\"?\211A`?\000\000\000\0005\001\no\022\203\272\323M\"?"
 & "\211A`?\000\000\000\0005\001\no\022\203\272\323M\"?\356|_?\000\000\000\000"
 & "5\001\no\022\203\272\323M\"?shQ?\000\000\000\0005\001\no\022\003\274\246"
 & "\233\304>\211A`?\000\000\000\0005\001\no\022\003\274\274t\323>\211A`?\000"
 & "\000\000\0005\001\no\022\003\274\232\231\331>\356|_?\000\000\000\0005\001"
 & "\no\022\003\274R\270\336>shQ?\000\000\000\0005\001\no\022\003\274333?\002"
 & "+\'?\000\000\000\0005\001\n\n\327\243\274\254\034:?\031\004V?\217\302u\274"
 & "5\001\n\217\302u=\252\3612?\211A`?\274t\223\2745\001\n\217\302u=\252\361"
 & "2?\211A`?\274t\223\2745\001\n\217\302u=\252\3612?\356|_?\274t\223\2745\001"
 & "\n\217\302u=\252\3612?\031\004V?\274t\223\2745\001\n\217\302u=\252\3612"
 & "?shQ?\274t\223\2745\001\n\311v\276=\364\375\024?\311v\376>o\022\003<5\001"
 & "\n\217\302u=\252\3612?\376\3248?=\n\327\2755\001\n`\345\320=\n\327C?\211"
 & "A`?\274t\223\2745\001\n`\345\320=\n\327C?\211A`?\274t\223\2745\001\n`\345"
 & "\320=\n\327C?\356|_?\274t\223\2745\001\n`\345\320=\n\327C?shQ?\274t\223"
 & "\2745\001\nw\276\237=J\f\"?\211A`?\000\000\000\0005\001\n\000\000\000\000"
 & "\374\251\021?\002+\'?\000\000\000\0005\001\n1\010,\276\177j\374>\362\322"
 & "-?\317\367S\2765\001\n\226C\213<F\266\363>\347\373)?X94\2745\001\n\226C"
 & "\213<\020X\371>\347\373)?X94\2745\001\n\226C\213<F\266\363>L7)?X94\2745"
 & "\001\n\226C\213<\345\320\002?w\276\037?X94\2745\001\n\226C\213<5^\372>\321"
 & "\"\033?X94\2745\001\n\226C\213<F\266\363>`\3450?X94\2745\001\n\177j\274"
 & "<\n\327#?\301\312\341>X94\2745\001\n\364\375\324<\232\231\331>\301\312\341"
 & ">?5^\2765\001\n\266\363\375<\252\361\322>\347\373)?X94\2745\001\n\266\363"
 & "\375<\f\002\353>\347\373)?X94\2745\001\n\266\363\375<\301\312\341>L7)?X"
 & "94\2745\001\n\266\363\375<y\351\346>\321\"\033?X94\2745\001\n9\264H=sh\221"
 & ">\347\373)?X94\2745\001\n9\264H=\242E\266>\347\373)?X94\2745\001\n\226C"
 & "\013=\236\357\247>L7)?X94\2745\001\n9\264H=j\274\264>\321\"\033?X94\274"
 & "5\001\n\033/\335<\264\310\366>\027\331.?X94\2745\001\nB`e<F\266\363>w\276"
 & "\037?\274t\023\2745\001\n\033/\335<\262\235\357>\347\373)?X94\2745\001\n"
 & "\033/\335<\020X\371>\347\373)?X94\2745\001\n\033/\335<\262\235\357>L7)?"
 & "X94\2745\001\n\033/\335<\266\363\375>w\276\037?X94\2745\001\n\033/\335<"
 & "5^\372>\321\"\033?X94\2745\001\n\305 \260==\n\027?\035Z\004?X94\2745\001"
 & "\nB`\345<\305 \360>\362\322\r?q=\n\2765\001\n1\010,=33\363>\347\373)?X9"
 & "4\2745\001\n1\010,=X9\364>\347\373)?X94\2745\001\n1\010,=33\363>L7)?X94"
 & "\2745\001\n1\010,=}?\365>\321\"\033?X94\2745\001\n\246\233\304\274\f\002"
 & "\353>\347\373)?\252\361R\2765\001\n\232\231\231\275\305 \360>\027\331.?"
 & "\205\353Q\2765\001\n\246\233\304\274\301\312\341>\321\"\033?\252\361R\276"
 & "05\001\0051e\000\000\0005\001\t\213l\347\275w\276??V\016M?\000\000\200\276"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\001\001\001\001\001\001\001\001\001\000\001\001\000\001\001\001\000\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000";

CONST E26_20 = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\000\000\000"
 & "\000\232\231\031?\232\231\031?\000\000\000\000\232\231\031?\232\231\031"
 & "?\232\231\031?\000\000\000\000\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231"
 & "\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232"
 & "\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031?\232\231\031"
 & "?\232\231\031?0000000000000000000000000000000005\001\n\027\331N>\250\306"
 & "\313>\230n\022?\217\302u\2745\001\nq=\n>{\024\356>;\337\017?\362\322\215"
 & ">5\001\nB`e=\226C\013?\360\247&?\354Q8\2755\001\n\236\357\247=/\335\004"
 & "?\372~*?%\006\001\2765\001\n\n\327\243;\354Q\030?-\262\035?\217\302u\274"
 & "5\001\n\274t\023=\250\306\013?\f\002\013?\217\302u\2745\001\n\240\032/>"
 & "u\223\330>;\337\017?\362\322\215>5\001\n\211A`>1\010\354>-\262\035?`\345"
 & "\320\2755\001\n\004V\016>o\022\303>-\262\035?`\345\320\2755\001\n5^\272"
 & "=\323M\002?#\333\031?\211A`>5\001\nsh\221=\213l\007?j\274\364>w\276\037"
 & "=5\001\nm\347\373=L7\311>\016-2>\370S\343\2755\001\nsh\221=\213l\007?\211"
 & "A\240>;\337O>5\001\n\246\233D>`\345\320>\240\032/>\217\302u\2745\001\n9"
 & "\264\310=\022\203\000?\211A ?-\262\235\2755\001\n\016-\262=\370S\003?-\262"
 & "\035?\217\302u\2745\001\nT\343\245=\347\373\t?-\262\035?\000\000\000\000"
 & "5\001\n#\333y=\356|\377>-\262\035?\000\000\000\0005\001\n%\006\201=\211"
 & "A\000?-\262\035?\217\302u\2745\001\n\207\026Y=\301\312\001?-\262\035?\000"
 & "\000\000\0005\001\n)\\\217=B`\005?#\333\031?\217\302u\2745\001\n\354Q\270"
 & "=B`\005?-\262\035?\217\302u\2745\001\n\256Ga=\221\355\374>#\333\031?\000"
 & "\000\000\0005\001\n\347\373\251=\035Z\004?-\262\035?\217\302u\2745\001\n"
 & "\301\312\241=\\\217\002?-\262\035?\217\302u\2745\001\n\201\225C>Nb\320>"
 & "\232\231\331>\217\302u\2745\001\nm\347\373=`\345\320>\232\231\331>\370S"
 & "\343\2755\001\n\002+\207=T\343\005?\211A\000?\217\302u<5\001\nsh\221=\213"
 & "l\007?\250\306\313>\374\251\361=5\001\n-\262\235=9\264\010?\211A\000?\217"
 & "\302u<5\001\n9\264\310=\211A\000?\341z\024?B`e\2745\001\no\022\203<\006"
 & "\201\025?-\262\035?\217\302u\2745\001\n\274t\023\274m\347\033?;\337\017"
 & "?\000\000\000\0005\001\n\217\302\365<!\260\022?;\337\017?\000\000\000\000"
 & "5\001\nX9\264<)\\\017?\341z\024?\274t\223\2745\001\n\217\302\365<b\020\030"
 & "?;\337\017?\000\000\000\0005\001\n\315\314\314<)\\\017?;\337\017?\000\000"
 & "\000\0005\001\nw\276\037=\205\353\021?;\337\017?\000\000\000\0005\001\n"
 & "X9\264<b\020\030?\341z\024?\274t\223\2745\001\n\n\327\243<\341z\024?;\337"
 & "\017?\000\000\000\0005\001\n-\262\235=T\343\005?;\337\017?\000\000\000\000"
 & "5\001\nP\215\027=#\333\031?;\337\017?\274t\223\2745\001\n1\010\254<\020"
 & "X\031?;\337\017?\000\000\000\0005\001\nw\276\037=\317\367\023?;\337\017"
 & "?\000\000\000\0005\001\no\022\003\273\254\034\032?;\337\017?\000\000\000"
 & "\0005\001\no\022\003<\366(\034?;\337\017?\246\233D\2745\001\nX9\264<\317"
 & "\367\023?\341z\024?\274t\223\2745\001\n\246\233D=\240\032\017?;\337\017"
 & "?\000\000\000\0005\001\no\022\003=\317\367\023?\341z\024?\337O\r\2765\001"
 & "\n\246\233\304<\020X\031?;\337\017?\000\000\000\0005\001\n\022\203@=h\221"
 & "\r?\364\375\024?X9\264\2745\001\n1\010\254<X9\024?;\337\017?\000\000\000"
 & "\0005\001\no\022\203;u\223\030?;\337\017?\274t\223\2745\001\n\364\375T\274"
 & "\221\355\034?;\337\017?\000\000\000\0005\001\n\274t\223\274?5\036?;\337"
 & "\017?\000\000\000\0005\001\n\246\233D<+\207\026?;\337\017?\000\000\000\000"
 & "5\001\n\246\233D<\264\310\026?;\337\017?\000\000\000\0005\001\n\266\363"
 & "}=\347\373\t?;\337\017?\000\000\000\0005\001\nH\341z>33\363>-\262\035?`"
 & "\345\320\2755\001\n\203\300\312=\234\304\000?\211A ?-\262\235\2755\001\n"
 & "\000\000\000>\217\302\265>-\262\035?`\345\320\2755\001\n\033/\335=m\347"
 & "\373>-\262\035?\000\000\200>5\001\n\000\000\000\000\232\231\031?\232\231"
 & "\231\275\000\000\000\2765\001\n\242E6>\321\"\333>;\337\017?\362\322\215"
 & ">5\001\n)\\\017=\205\353\021?\260r\350>\217\302u\2745\001\n\000\000\000"
 & "\000\006\201\025?\211A ?\217\302u\2745\001\n\n\327#=\037\205\013?\f\002"
 & "\353>\217\302u\2745\001\n\n\327\243<\307K\027?\211A ?\217\302u\2745\001"
 & "\n\n\327#=\305 \020?\260r\350>\217\302u\2745\001\n\347\373\251=1\010\f?"
 & "\211A ?\000\000\000\0005\001\n\217\302\365<\341z\024?\260r\350>\006\201"
 & "\025\2765\001\n\n\327\243;P\215\027?\211A ?\000\000\000\0005\001\n-\262"
 & "\235=T\343\005?\260r(?\000\000\000\0005\001\n%\006\201=\256G\341>\260r("
 & "?\006\201\025\2765\001\n\n\327\243<\217\302\025?\211A ?\000\000\000\000"
 & "5\001\n-\262\235=T\343\005?\211A ?\000\000\000\0005\001\nX9\264\274\211"
 & "A ?\260r\350>\000\000\000\0005\001\n\274t\223<P\215\027?\260r\350>\000";

CONST E26_21 = 
   "\000\000\0005\001\n\217\302\365<\205\353\021?\260r\350>\217\302u\2745\001"
 & "\no\022\203\272\205\353\021?\260r\350>sh\021\2765\001\n\n\327\243<\307K"
 & "\027?\260r\350>sh\021\2765\001\n\022\203@=\341z\024?\260r\350>\000\000\000"
 & "\0005\001\n\226C\213=\303\365\010?\f\002\353>\226C\213\2745\001\n\022\203"
 & "@=\'1\010?;\337\017?\217\302u\2745\001\no\022\203\272\374\251\021?\234\304"
 & "\340>\217\302u\2745\001\no\022\203\272#\333\031?\234\304\340>\000\000\000"
 & "\0005\001\n\274t\223\274?5\036?\234\304\340>\000\000\000\0005\001\n\246"
 & "\233\304;b\020\030?\234\304\340>\000\000\000\0005\001\no\022\203\273#\333"
 & "\031?\234\304\340>sh\021\2765\001\nT\343\245=\270\036\005?\234\304\340>"
 & "\000\000\000\0005\001\n\n\327#>h\221\355>-\262\035?`\345\320\2755\001\n"
 & "\\\217\202>\327\243\260>\000\000@?\000\000\200\2765\001\n\226C\013>\256"
 & "G\341>-\262\035?`\345\320\2755\001\nsh\221=\024\256\007?\242E\266>\010\254"
 & "\034>000000000000000005\001\n-\262\235=T\343\005?\234\304\340>\000\000\000"
 & "\0005\001\n\002+\007>q=\312>L7)?J\f\002?5\001\n\205\353Q>\262\235\357>L"
 & "7)?J\f\002?5\001\n\252\361\322=\311v\376>\'1(?\307K\367>5\001\n\242E\266"
 & "=o\022\003?\345\320\"?\177j\374>5\001\nX9\264=o\022\003?\217\302\025?\256"
 & "G\001?5\001\n\347\373\251=\035Z\004?7\211!?\262\235\357>5\001\n\037\205"
 & "k>\244p\275>\000\000 ?\354Q\370>5\001\no\022\003>\374\251\361>\000\000 "
 & "?\354Q\370>05\001\n\203\300J>\362\322\315>h\221-?\242E\366>5\001\n\205\353"
 & "Q>\335$\306>\000\000\000\000\252\361R\27605\001\n\226C\213=+\207\026?L7"
 & ")?#\333\371>5\001\nV\016->m\347\273>\000\000\000\000\250\306K\2765\001\n"
 & "\252\361\322=\311v\376>\203\300*?\177j\374>05\001\n\027\331N>\250\306\313"
 & ">T\343\345>\006\201\025\2765\001\n\002+\207=\246\233\004?\033/\035?9\264"
 & "H\2755\001\n\274t\223=\027\331\016?\177j\034?B`\345\2745\001\n\033/]=\250"
 & "\306\013?\035Z\004?9\264H=5\001\n\n\327#<=\n\027?;\337\017?\000\000\000"
 & "\0005\001\n\\\217\202>\327\243\260>\315\314,?333\2765\001\n\347\373\251"
 & "=\035Z\004?\341z\024?)\\\217\2751n\007\000\0005\001\n\000\000\000\000\232"
 & "\231\031?\341z\024?\274t\223\2745\001\n+\207\026>\236\357\347>\341z\024"
 & "?9\264H>5\001\no\022\003<h\221\r?\035Z\344>)\\\217=5\001\nsh\221=\213l\007"
 & "?\274t\323>\252\361\322=5\001\n\315\314\314=\000\000\000?\211A\240>;\337"
 & "O>5\001\n\000\000\000\000\232\231\031?\341z\024?\274t\223\2741k\007\000"
 & "\0005\001\n\305 \260=!\260\362>-\262\035?\376\324x>5\001\nsh\221=\213l\007"
 & "?\n\327\003?\246\233\304<5\001\n\230n\022>d;\337>-\262\035?\037\205k>5\001"
 & "\n\337O\r>-\262\335>-\262\035?\370Sc>1h\007\000\0005\001\no\022\203\272"
 & "\374\251\021?\234\304\340>sh\021\2765\001\n\246\233\304;\274t\023?\341z"
 & "\024?)\\\217\2755\001\n9\264H>\027\331\316>F\266\263>\303\365(>1p\007\000"
 & "\0005\001\n\010\254\034>/\335\344>-\262\035?\037\205k>5\001\n+\207\026>"
 & "\236\357\347>\341z\024?9\264H>5\001\n\022\203@=P\215\027?\035Z\344>)\\\217"
 & "=5\001\nB`e\275\236\357\'?L7)?\217\302u\2755\001\n\022\203@\275T\343%?L"
 & "7)?\217\302u\2755\001\n\022\203@\275T\343%?L7)?\217\302u\2755\001\n\203"
 & "\300\312=\022\203\000?T\343\345>\006\201\025\2765\001\n\274t\023\274m\347"
 & "\033?9\264H?\000\000\000\0005\001\n\274t\023\274m\347\033?9\264H?\000\000"
 & "\000\0005\001\n\274t\023\274m\347\033?\024\256G?\000\000\000\0005\001\n"
 & "\274t\023\274m\347\033?\323MB?\000\000\000\0005\001\n\274t\023\274m\347"
 & "\033?\356|??\000\000\000\0005\001\n\274t\023\274m\347\033?V\016M?\000\000"
 & "\000\0005\001\nh\221\355\274\254\034\032?;\337\017?\000\000\000\0005\001"
 & "\nX9\264<)\\\017?\341z\024?\252\361R\2765\001\n\315\314\314<)\\\017?9\264"
 & "H?\000\000\000\0005\001\n\315\314\314<)\\\017?9\264H?\000\000\000\0005\001"
 & "\n\315\314\314<)\\\017?\024\256G?\000\000\000\0005\001\n\315\314\314<)\\"
 & "\017?\356|??\000\000\000\0005\001\n-\262\235=T\343\005?9\264H?\000\000\000"
 & "\0005\001\n-\262\235=T\343\005?9\264H?\000\000\000\0005\001\n-\262\235="
 & "T\343\005?\024\256G?\000\000\000\0005\001\n-\262\235=T\343\005?\356|??\000"
 & "\000\000\0005\001\n\217\302\365<b\020\030?;\337\017?\000\000\000\0005\001"
 & "\no\022\003<\366(\034?\323MB?\246\233D\2745\001\nX9\264<\317\367\023?9\264"
 & "H?\274t\223\2745\001\nX9\264<\317\367\023?9\264H?\274t\223\2745\001\nX9"
 & "\264<\317\367\023?\024\256G?\274t\223\2745\001\nX9\264<\317\367\023?\323"
 & "MB?\274t\223\2745\001\nX9\264<\317\367\023?\356|??\274t\223\2745\001\nT"
 & "\343\245=\270\036\005?j\274\364>w\276\037=5\001\nX9\264<\317\367\023?\006"
 & "\201\025?X9\264\2745\001\no\022\203;u\223\030?9\264H?\274t\223\2745\001"
 & "\no\022\203;u\223\030?9\264H?\274t\223\2745\001\no\022\203;u\223\030?\024"
 & "\256G?\274t\223\2745\001\no\022\203;u\223\030?\356|??\274t\223\2745\001"
 & "\n\246\233D<\264\310\026?9\264H?\000\000\000\0005\001\n\246\233D=\215\227"
 & "\016?;\337\017?\000\000\000\0005\001\nX9\264<u\223\030?\211A ?\217\302u"
 & "\2745\001\n)\\\017=\205\353\021?L7)?\217\302u\2745\001\n)\\\017=\205\353"
 & "\021?L7)?\217\302u\2745\001\n)\\\017=\205\353\021?\'1(?\217\302u\2745\001"
 & "\n)\\\017=\205\353\021?\345\320\"?\217\302u\2745\001\n)\\\017=\205\353\021"
 & "?\000\000 ?\217\302u\2745\001\n)\\\017=\205\353\021?h\221-?\217\302u\274"
 & "5\001\no\022\203\273#\333\031?\260r\350>\217\302u\2745\001\n\n\327#=\037"
 & "\205\013?\f\002\353>\252\361R\2765\001\n\n\327#=\305 \020?L7)?\217\302u"
 & "\2745\001\n\n\327#=\305 \020?L7)?\217\302u\2745\001\n\n\327#=\305 \020?"
 & "\'1(?\217\302u\2745\001\n\n\327#=\305 \020?\000\000 ?\217\302u\2745\001"
 & "\n-\262\235=T\343\005?L7)?\000\000\000\0005\001\n-\262\235=T\343\005?L7"
 & ")?\000\000\000\000";

CONST E26_22 = 
   "5\001\n%\006\201=T\343\005?\'1(?\000\000\000\0005\001\n-\262\235=T\343\005"
 & "?\000\000 ?\000\000\000\0005\001\nh\221m=\f\002\013?\211A ?\033/\335\274"
 & "5\001\n\274t\223<P\215\027?\345\320\"?\000\000\000\0005\001\n\217\302\365"
 & "<\205\353\021?L7)?\217\302u\2745\001\n\217\302\365<\205\353\021?L7)?\217"
 & "\302u\2745\001\n\217\302\365<\205\353\021?\'1(?\217\302u\2745\001\n\217"
 & "\302\365<\205\353\021?\345\320\"?\217\302u\2745\001\n\217\302\365<\205\353"
 & "\021?\000\000 ?\217\302u\2745\001\nsh\221=\213l\007?\000\000\000?o\022\203"
 & "<5\001\n\217\302\365<\205\353\021?V\016\355>\246\233\304\2745\001\no\022"
 & "\203\272\374\251\021?L7)?\217\302u\2745\001\no\022\203\272\374\251\021?"
 & "L7)?\217\302u\2745\001\no\022\203\272\374\251\021?\'1(?\217\302u\2745\001"
 & "\no\022\203\272\374\251\021?\000\000 ?\217\302u\2745\001\no\022\203\273"
 & "#\333\031?L7)?sh\021\2765\001\nB`e\274\205\353\021?\211A ?sh\021\2765\001"
 & "\no\022\203\273#\333\031?\000\000 ?sh\021\2765\001\0051\023\000\000\000"
 & "5\001\t{\024.\276\027\331\216?\004Vn?fff\276\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\001\001\001\001\001\001\001"
 & "\001\001\000\001\001\000\001\001\001\000\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004"
 & "V\216>\004V\216>\217\302\265>\004V\016?\004V\016?\201\225c?\203\300*?\370"
 & "Sc>\372~\252>\372~\252>\002+\307>\006\201\025?\004V\216>\006\201\025?\004"
 & "V\216>\004V\216>\004V\016?\004V\016?\004V\016?\004V\016?\004V\016?\004V"
 & "\016?\004V\016?\004V\016?\004V\016?\004V\016?\004V\216>\004V\216>\006\201"
 & "\025?\006\201\025?\006\201\025?\004V\016?\205\353\201?\203\300*?\203\300"
 & "*?\376\3248?\376\3248?\203\300*?\177j\034?\002+G?\376\3248?\004V\216>\000"
 & "\000\000?\203\300*?\004V\016?}?U?\376\3248?\002+G?\203\300*?\002+G?\376"
 & "\3248?\203\300*?\177j\034?\376\3248?\203\300*?\374\251q?\203\300*?\203\300"
 & "*?\177j\034?\004V\216>\004V\216>\004V\216>\305 \360>\004V\016?\370Sc>\004"
 & "V\016?\004V\016?\000\000\000?\004V\016?\004V\016?\004V\216>\004V\016?\004"
 & "V\016?\370Sc>\370Sc>\000\000\000?\370Sc>}?U?\004V\016?\004V\016?\004V\016"
 & "?\004V\016?\372~\252>\000\000\000?\004V\216>\004V\016?\000\000\000?\376"
 & "\3248?\000\000\000?\000\000\000?\000\000\000?\f\002\253>\270\036\205>\f"
 & "\002\253>\006\201\025?\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\004V\216>\372~\252>\372~\252>\372~\252>\372~\252>\372~\252>\372~\252"
 & ">\372~\252>\372~\252>\000\000\000\000\372~\252>\372~\252>\000\000\000\000"
 & "\372~\252>\372~\252>\372~\252>\000\000\000\000\372~\252>\004V\016?\004V"
 & "\016?\004V\016?\004V\016?\270\036\205>\004V\016?\372~\252>\010\254<?\244"
 & "p\275>\004V\016?\006\201\025?\372~\252>\010\254<?\372~\252>\315\314\314"
 & ">\006\201\025?\372~\252>\372~\252>\372~\252>\004V\016?\325x\t?\004V\216"
 & ">\372~\252>\372~\252>H\341\272>\004V\016?\006\201U?\006\201U?\006\201U?"
 & "\177j\034?\203\300*?\203\300*?\203\300*?\203\300*?\203\300*?\203\300*?\000"
 & "\000\200?\376\3248?\203\300*?\203\300*?\203\300*?\203\300*?\004V\216>\004"
 & "V\216>\004V\216>\004V\216>\376\3248?\376\3248?\002+G?\002+G?\002+G?\002"
 & "+G?\002+G?\006\201\025?\002+G?\376\3248?\376\3248?\376\3248?\376\3248?\203"
 & "\300*?\203\300*?\177j\034?\004V\016?\004V\016?\004V\016?\004V\016?\004V"
 & "\016?\004V\016?\201\225c?\000\000\000?\004V\016?\004V\016?\004V\016?\004"
 & "V\016?\004V\216>\004V\216>\004V\216>\004V\216>\004V\016?\004V\016?\004V"
 & "\016?\004V\016?\004V\016?\004V\016?\004V\016?\006\201\025?\177j\034?\004"
 & "V\016?\004V\016?\004V\016?\004V\016?\000\000\000?\004V\016?\000\000\000"
 & "?0000000000000000000000000000000005\001\n\354Q\270={\024\256>\331\3167?"
 & "\000\000\000\0005\001\n1\010,>\211A\340>\331\3167?V\016\355>5\001\n\006"
 & "\201\225=7\211!?\305 0?\000\000\000\0005\001\n\337O\215=\266\363\035?ff"
 & "F?\037\205\353\2755\001\n+\207\026>\201\225c?\317\3673?\343\245\233\274"
 & "5\001\n-\262\235=\313\241%?\331\3167?\217\302u\2745\001\n\276\237\032>R"
 & "\270\236>\331\3167?V\016\355>5\001\n\033/\335=\260r\350>\343\245;?\317\367"
 & "S\2765\001\n\274t\023\274D\213\254>\343\245;?\317\367S\2765\001\n\303\365"
 & "(>33\363>\331\3167?\010\254\334>5\001\n{\024\256=\321\"\033?\256G\001?\000"
 & "\000\000\0005\001\nB`e=\321\"[>\207\026\331=+\207\026\2765\001\n{\024\256"
 & "=\321\"\033?\317\367\223>\033/]>5\001\n\016-\262=\321\"[>\207\026\331=\000"
 & "\000\000\0005\001\n1\010\254\274\213l\347>\010\254<?\343\245\233\2745\001"
 & "\n\311v\276=\343\245\033?\317\3673?\343\245\233\2745\001\n\317\367S>J\f"
 & "\002?\317\3673";

CONST E26_23 = 
   "?\000\000\000\0005\001\n\364\375\324<\266\363\035?\317\3673?\000\000\000"
 & "\0005\001\n\232\231\231=\366(\034?\317\3673?\343\245\233\2745\001\n#\333"
 & "y=\274t\023?\317\3673?\000\000\000\0005\001\n\226C\213=\333\371\036?\305"
 & " 0?\343\245\233\2745\001\n5^\272=\244p\035?\317\3673?\343\245\233\2745\001"
 & "\n\272I\f>\226C+?\305 0?\000\000\000\0005\001\nP\215\227=Zd\033?\317\367"
 & "3?\343\245\233\2745\001\n\236\357\247=m\347\033?\317\3673?\343\245\233\274"
 & "5\001\n\016-\262=\254\034\232>\223\030\004?\000\000\000\0005\001\nB`e=\254"
 & "\034\232>\223\030\004?+\207\026\2765\001\n\022\203\300=\223\030$?\244p\375"
 & ">X94<5\001\n%\006\201=\234\304 ?\024\256\307>\037\205\353=5\001\n\315\314"
 & "L=\376\324\030?\244p\375>X94<5\001\n/\335$>\366(\034?\254\034:?\000\000"
 & "\000\0005\001\n\366(\\>=\nw?\010\254<?\343\245\233\2745\001\nB`e<\213l\'"
 & "?\331\3167?\000\000\000\0005\001\nP\215\227=\242E6?\331\3167?\000\000\000"
 & "\0005\001\n\033/\335=\'1H?\010\254<?\343\245\233\2745\001\nT\343\245=\201"
 & "\225C?\331\3167?\000\000\000\0005\001\n\305 \260=o\022C?\331\3167?\000\000"
 & "\000\0005\001\n\305 \260=\177j<?\331\3167?\000\000\000\0005\001\n\370S\343"
 & "=D\213L?\010\254<?\343\245\233\2745\001\n-\262\235=D\213L?\331\3167?\000"
 & "\000\000\0005\001\n5^\272=\215\227\256>\331\3167?\000\000\000\0005\001\n"
 & "\022\203@=j\274\024?\331\3167?\343\245\233\2745\001\n\343\245\233=\027\331"
 & "N?\331\3167?\000\000\000\0005\001\n\343\245\233={\024\016?\331\3167?\000"
 & "\000\000\0005\001\n\006\201\225=\347\373i?\331\3167?\000\000\000\0005\001"
 & "\n\343\245\233=D\213L?\331\3167?\000\000\000\0005\001\n=\n\327=\274tS?\010"
 & "\254<?\343\245\233\2745\001\n\305 \260=\010\254<?\331\3167?\000\000\000"
 & "\0005\001\n=\n\327=\274tS?\010\254<?B`e\2755\001\nX9\264=T\343E?\331\316"
 & "7?\000\000\000\0005\001\n\354Q\270=+\2076?\010\254<?\343\245\233\2745\001"
 & "\nP\215\027>\000\000@?\331\3167?\000\000\000\0005\001\nm\347\373=1\010L"
 & "?\331\3167?\343\245\233\2745\001\n\351&1>\315\314L?\331\3167?\000\000\000"
 & "\0005\001\nV\016->5^\212?\331\3167?\000\000\000\0005\001\n\343\245\233<"
 & "q=J?\331\3167?\000\000\000\0005\001\n\f\002+>\004VN?\331\3167?\000\000\000"
 & "\0005\001\n\177j\274<-\262=?\331\3167?\000\000\000\0005\001\n1\010\254<"
 & "\004V\316>\376\3248?9\264H\2765\001\n)\\\017>\364\375\224>\010\254<?\343"
 & "\245\233\2745\001\nB`e\274\177j\274>\376\3248?9\264H\2765\001\n1\010,=\347"
 & "\373\t?\305 0?\002+\207>5\001\n\033/\335\274q=\n?\232\231\231\275\000\000"
 & "\000\2765\001\n\303\365(>B`\245>\232\2319?\327\243\360>5\001\n#\333y=\240"
 & "\032\017?^\272\t?\217\302u\2745\001\nh\221m=\006\201\025?\331\3167?\217"
 & "\302u\2745\001\nP\215\227=h\221\r?^\272\t?\217\302u\2745\001\n1\010\254"
 & "=y\351&?\331\3167?\217\302u\2745\001\n1\010\254=\317\367\023?^\272\t?\217"
 & "\302u\2745\001\n\305 \260=\364\375\324>5^:?\000\000\000\0005\001\n1\010"
 & ",=\366(\034?^\272\t?\256Ga\2765\001\n\270\036\205=!\260\022?\331\3167?\000"
 & "\000\000\0005\001\nL7\211=-\262\235>\331\3167?\000\000\000\0005\001\n\217"
 & "\302u\275-\262\235>\331\3167?=\nW\2765\001\nL7\211=\232\231\031?\331\316"
 & "7?\000\000\000\0005\001\nL7\211=-\262\235>\331\3167?\000\000\000\0005\001"
 & "\n\270\036\205=\254\034Z?^\272\t?\000\000\000\0005\001\n\270\036\205=!\260"
 & "\022?^\272\t?\000\000\000\0005\001\n\347\373\251=\217\302\025?^\272\t?B"
 & "`e\2745\001\nB`e<\006\201\025?^\272\t?\317\367S\2765\001\n1\010\254=H\341"
 & "\032?^\272\t?\317\367S\2765\001\n-\262\235=\035Z\344>^\272\t?\000\000\000"
 & "\0005\001\n%\006\201=\213l\007?^\272\t?\217\302u\2745\001\n`\345\320=\177"
 & "j\274>\226C+?B`\345\2735\001\n\022\203\300=\232\231\031?T\343\005?\217\302"
 & "u\2745\001\nF\266\363=5^\032?T\343\005?\000\000\000\0005\001\n\000\000\000"
 & ">\205\353Q?T\343\005?\000\000\000\0005\001\nX94<b\020\030?T\343\005?\000"
 & "\000\000\0005\001\n\217\302u<\232\231\031?T\343\005?\321\"[\2765\001\n\266"
 & "\363\375<\016-\022?T\343\005?\000\000\000\0005\001\n\177j\274=\n\327\343"
 & ">\376\3248?9\264H\2765\001\n\354Q\270=T\343\245>\010\254<?\343\245\233\274"
 & "5\001\n\000\000\000\000}?\265>\376\3248?9\264H\2765\001\n\370S\343=\341"
 & "z\024?y\351\246>\354Q8>000000000000000005\001\n\\\217\302=+\207\226>T\343"
 & "\005?\000\000\000\0005\001\n{\024.>D\213\254>m\347;?\331\316\027?5\001\n"
 & "\266\363}>33\363>m\347;?\331\316\027?5\001\n+\207\026>\211A\340>m\347;?"
 & "\331\316\027?5\001\n\000\000\000>H\341\372>\376\3248?\321\"\033?5\001\n"
 & "\230n\022>\262\235\357>\240\032/?\022\203 ?5\001\n\f\002+>F\266\363>\321"
 & "\";?\354Q\030?5\001\n\333\371~>\020X\271>j\2744?\276\237\032?5\001\n1\010"
 & ",>\345\320\342>j\2744?\276\237\032?05\001\n\321\"[>\362\322\315>7\211A?"
 & "\230n\022?5\001\no\022\003;h\221m>\000\000\000\000fff\27605\001\n\234\304"
 & " >\327\243\020?m\347;?\331\316\027?5\001\n\305 0=\333\371~>\000\000\000"
 & "\000fff\2765\001\n}?5>\262\235\357>m\347;?\331\316\027?05\001\n-\262\235"
 & "=y\351\246>T\343\005?\024\256G\2765\001\n\\\217\302=\006\201\025?\356|\037"
 & "?\037\205\353\2755\001\n9\264H=\323M\"?\331\3167?o\022\203\2745\001\n\217"
 & "\302u=B`%?5^\032?\203\300\312=5\001\nT\343\245=\252\3612?\305 0?\000\000"
 & "\000\0005\001\n\354Q\270=T\343\245>\010\254<?\343\245\233\2745\001\n\343"
 & "\245\233=\006\201\025?\010\254<?\201\225C\27617\010\000\0005\001\n\033/"
 & "]=\242EV?\010\254<?\343\245\233\2745\001\n\315\314\314=T\343\345>\010\254"
 & "<?\343\245\233>5\001\n\006\201\025>\362\322\r?\035Z\344>\033/\335=5\001"
 & "\n\207\026\331=\234\304 ?\024\256\307>\033/\335=5\001\n\311v\276=\264\310"
 & "\266>/\335\244>h\221m>5\001\n\033/]=\242EV?\010\254";

CONST E26_24 = 
   "<?\343\245\233\27414\010\000\0005\001\nV\016->\262\235\357>\317\3673?\230"
 & "n\322>5\001\nw\276\037=?5\036?7\211\001?\000\000\000\0005\001\no\022\203"
 & "=T\343\345>\317\3673?;\337\217>5\001\n\354Q\270=d;\337>\317\3673?q=\212"
 & ">11\010\000\0005\001\n\246\233\304<\232\231\031?T\343\005?\317\367S\276"
 & "5\001\n%\006\001>ff&?\331\3167?\351&1\2765\001\n\223\030\004>\201\225\203"
 & ">\256G\241>\\\217B>19\010\000\0005\001\n\347\373)>\266\363\275>\317\367"
 & "3?;\337\217>5\001\n\315\314\314=\262\235\357>\010\254<?\343\245\233>5\001"
 & "\n\217\302\365=\002+\007?\035Z\344>\033/\335=5\001\n\232\231\031>\337OM"
 & "?\317\3673?\343\245\233\2745\001\n\325x\351=\264\310V?\317\3673?\343\245"
 & "\233\2745\001\n\270\036\005>\177j\\?\317\3673?\343\245\233\2745\001\n{\024"
 & "\256=9\264\010?ff\006?\362\322M\2765\001\nB`e<\213l\'?\362\322m?\000\000"
 & "\000\0005\001\nB`e<\027\331.?\362\322m?\000\000\000\0005\001\nB`e<\213l"
 & "\'?\362\322m?\000\000\000\0005\001\nB`e<\252\3612?\203\300j?\000\000\000"
 & "\0005\001\nB`e<\213l\'?\360\247f?\000\000\000\0005\001\nB`e<\213l\'?\004"
 & "Vn?\000\000\000\0005\001\no\022\003<\177j\214?\331\3167?\000\000\000\000"
 & "5\001\n\033/\335=\'1H?\010\254<?fff\2765\001\n\305 \260=o\022C?\362\322"
 & "m?\000\000\000\0005\001\n\305 \260=o\022C?\362\322m?\000\000\000\0005\001"
 & "\n\305 \260=o\022C?\362\322m?\000\000\000\0005\001\n\305 \260=o\022C?\360"
 & "\247f?\000\000\000\0005\001\n5^\272=F\266\263>\362\322m?\000\000\000\000"
 & "5\001\n5^\272=5^\372>\362\322m?\000\000\000\0005\001\n5^\272=\213l\347>"
 & "\362\322m?\000\000\000\0005\001\n5^\272=\372~\352>\360\247f?\000\000\000"
 & "\0005\001\n\337O\215=\201\225C?\331\3167?\000\000\000\0005\001\n\343\245"
 & "\233=D\213L?\203\300j?\000\000\000\0005\001\n=\n\327=\274tS?\362\322m?\343"
 & "\245\233\2745\001\n=\n\327=\274tS?\362\322m?\343\245\233\2745\001\n=\n\327"
 & "=\274tS?\362\322m?\343\245\233\2745\001\n=\n\327=\274tS?\203\300j?\343\245"
 & "\233\2745\001\n=\n\327=\274tS?\360\247f?\343\245\233\2745\001\n\315\314"
 & "L=\035Z$?7\211\001?\000\000\000\0005\001\n\305 0=\n\327c?\010\254<?\343"
 & "\245\233\2745\001\nm\347\373=1\010L?\362\322m?\343\245\233\2745\001\nm\347"
 & "\373=1\010L?\362\322m?\343\245\233\2745\001\nm\347\373=1\010L?\362\322m"
 & "?\343\245\233\2745\001\nm\347\373=1\010L?\360\247f?\343\245\233\2745\001"
 & "\n\f\002+>\004VN?\362\322m?\000\000\000\0005\001\n\305 \260=\242E6?\331"
 & "\3167?\000\000\000\0005\001\nL7\211=\260r(?5^:?\217\302u\2745\001\n#\333"
 & "y=\240\032\017?m\347;?\217\302u\2745\001\n#\333y=\242E\026?m\347;?\217\302"
 & "u\2745\001\n#\333y=\240\032\017?m\347;?\217\302u\2745\001\n#\333y=P\215"
 & "\027?\376\3248?\217\302u\2745\001\n#\333y=\240\032\017?j\2744?\217\302u"
 & "\2745\001\n#\333y=\240\032\017?7\211A?\217\302u\2745\001\n#\333y=9\264h"
 & "?^\272\t?\217\302u\2745\001\nP\215\227=h\221\r?^\272\t?fff\2765\001\n1\010"
 & "\254=\317\367\023?m\347;?\217\302u\2745\001\n1\010\254=\242E\026?m\347;"
 & "?\217\302u\2745\001\n1\010\254=\317\367\023?m\347;?\217\302u\2745\001\n"
 & "1\010\254=\317\367\023?j\2744?\217\302u\2745\001\n\\\217\302=R\270\236>"
 & "m\347;?\000\000\000\0005\001\n\\\217\302=B`\345>m\347;?\000\000\000\000"
 & "5\001\n\\\217\302=\230n\322>m\347;?\000\000\000\0005\001\n\\\217\302=\364"
 & "\375\324>j\2744?\000\000\000\0005\001\nT\343\245=\266\363\035?\010\254<"
 & "?\217\302u\2745\001\n\270\036\205=P\215\027?\376\3248?\000\000\000\0005"
 & "\001\n\347\373\251=\217\302\025?m\347;?B`e\2745\001\n\347\373\251=\242E"
 & "\026?m\347;?B`e\2745\001\n\347\373\251=\217\302\025?m\347;?B`e\2745\001"
 & "\n\347\373\251=\254\034\032?\376\3248?B`e\2745\001\n\347\373\251=\217\302"
 & "\025?j\2744?B`e\2745\001\n{\024\256=\321\"\033?\335$\006?\343\245\233\274"
 & "5\001\nh\221\355<\313\241%?\037\205\013?X9\264\2745\001\n\022\203\300=\232"
 & "\231\031?m\347;?\217\302u\2745\001\n\022\203\300=\232\231\031?m\347;?\217"
 & "\302u\2745\001\n\022\203\300=\232\231\031?m\347;?\217\302u\2745\001\n\022"
 & "\203\300=\232\231\031?j\2744?\217\302u\2745\001\n\217\302u<\232\231\031"
 & "?m\347;?\321\"[\2765\001\nB`e<\006\201\025?\331\3167?\317\367S\2765\001"
 & "\n\217\302u<\232\231\031?j\2744?\321\"[\27605\001\0051\261\000\000\0005"
 & "\001\t\354Q8\276\037\205\213?\256G\201?\031\004\226\276\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\000\001\001\001"
 & "\001\001\000\001\001\001\001\001\001\001\001\001\001\001\001\001\001\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\200>\372~\252>+\2076?\000\000\000?D\213\f?}?U?\002+G?\234"
 & "\304\340>\372~\252>\372~\252>\000\000\000?D\213\f?\000\000\200>D\213\f?"
 & "\000\000\200>\004V\216>\000\000\000?\000\000\000?\000\000\000?\000\000\000"
 & "?\000\000\000?\000";

CONST E26_25 = 
   "\000\000?\000\000\000?\000\000\000?\000\000\000?\000\000\000?\004V\216>"
 & "\004V\216>D\213\f?D\213\f?D\213\f?\370S\343>D\213\f?\376\3248?\203\300*"
 & "?\376\3248?\010\254\034?\177j\034?\370SC?5^\032?\376\3248?\372~\252>7\211"
 & "!?\376\3248?\262\235/?\201\225c?\376\3248?\376\3248?\246\233D?-\262=?\004"
 & "V\016?P\215\027?\177j\034?\327\2430?\234\304\340>\246\233D?\270\036%?\037"
 & "\205K?\177j\034?\372~\252>\221\355\\?\372~\252>\260r(?\000\000\000?\000"
 & "\000\000?7\211!?D\213\f?D\213\f?\221\355\374>\234\304\340>B`\005?\230n\322"
 & ">5^\032?\260r\250>5^\032?D\213\f?D\213\f?\274t\023?B`\005?D\213\f?D\213"
 & "\f?B`\005?D\213\f?5^\032?\234\304\340>\274t\023?+\2076?\262\235/?\177j\374"
 & ">\262\235/?\221\355\374>\217\302\365>\315\314L>\217\302\365>D\213\f?\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000R\270\036?\221\355|>D\213\f?\f\002+"
 & ">+\2076?\000\000\000?\234\304@?\234\304@?\234\304@?\234\304@?B`\205?\010"
 & "\254|?5^\032?\010\254|?5^\032?\315\314\314>D\213\f?\230n\322>D\213\f?D\213"
 & "\f?+\2076?\221\355\374>\037\205\353>D\213\f?D\213\f?D\213\f?D\213\f?\000"
 & "\000\200?5^\032?\000\000\200?\260r(?!\260R?\262\235/?\037\205K?\010\254"
 & "|?\246\233D?\246\233D?!\260R?\246\233D?\246\233D?+\2076?+\2076?+\2076?+"
 & "\2076?+\2076?+\2076?+\2076?\246\233D?+\2076?q=J?q=J?\n\327c?!\260R?D\213"
 & "\f?\000\000\200>+\2076?5^\032?5^\032?B`\205?\010\254|?5^\032?\010\254|?"
 & "5^\032?\221\355\374>\260r\250>q=J?q=J?L7I?+\2076?\246\233\304>\246\233\304"
 & ">\246\233\304>\246\233\304>\000\000\000\000\246\233\304>\221\355\374>\221"
 & "\355\374>\221\355\374>\221\355\374>\000\000\000\000\260r\250>\272I\214>"
 & "\262\235/?\262\235/?\262\235/?\246\233\304>\246\233\304>\246\233\304>\246"
 & "\233\304>\246\233\304>\246\233\304>\221\355\374>\221\355\374>\221\355\374"
 & ">\000\000\000\0000000000000000000000000000000000005\001\no\022\003>\217"
 & "\302u>1\010,?\226C\213\2745\001\n\266\363\375<\004V.?\341z4?\000\000\000"
 & "\0005\001\n\n\327\243<\242E\366>\272I,?o\022\203\2745\001\n\315\314\314"
 & "<j\274\364>\364\3754?\000\000\000\0005\001\n%\006\201=B`E?\024\256\'?\274"
 & "t\023\2755\001\n\236\357\'=\000\000@?L7)?\274t\223\2745\001\n\246\233D="
 & "\317\367\323>\000\000\000?\226C\213\2745\001\n\207\026Y=\232\231\231>\272"
 & "I,?\201\225C\2765\001\n\217\302\365<\362\322\215>\272I,?\201\225C\2765\001"
 & "\n\270\036\205=\276\237\332>V\016\r?L7\t>5\001\n\n\327#<\347\373\t?\260"
 & "r\010?\000\000\000\0005\001\nB`e=\360\247F>\364\375\324=\343\245\033\276"
 & "5\001\nX94<\303\365\010?\274t\223>\215\227n>5\001\n\337O\215=\020X9>\\\217"
 & "\302=\226C\213\2745\001\n\000\000\000\000J\f\202>B`%?\274t\223\2745\001"
 & "\n\177j\274<\351&\361>)\\/?\226C\213\2745\001\n\262\235\357=\024\256\307"
 & ">\272I,?\000\000\000\0005\001\n\315\314\314<33\363>\262\235/?\000\000\000"
 & "\0005\001\nw\276\037=R\270\336>)\\/?\226C\213\2745\001\no\022\203<\305 "
 & "\360>)\\/?\000\000\000\0005\001\nh\221\355<\345\320\342>)\\/?\226C\213\274"
 & "5\001\n\274t\023=\240\032\357>)\\/?\226C\213\2745\001\n\246\233\304<B`\345"
 & ">\272I,?o\022\203\2745\001\n\033/]=\256G\341>)\\/?\274t\223\2745\001\n\266"
 & "\363\375<\037\205\353>)\\/?\274t\223\2745\001\nT\343\245=\313\241E>\037"
 & "\205\353>\226C\213\2745\001\n\347\373\251=\323Mb>\037\205\353>\343\245\033"
 & "\2765\001\n\364\375\324<T\343\005?\313\241\005?\000\000\000\0005\001\nX"
 & "94<\325x\t?\024\256\307>Nb\020>5\001\n\364\375\324<T\343\005?\313\241\005"
 & "?\000\000\000\0005\001\n)\\\217=\252\361\322>\262\235/?\226C\213\2745\001"
 & "\nX94<\325x\t?33\363>\000\000\000\0005\001\no\022\203;\240\032/?\272I,?"
 & "\000\000\000\0005\001\nh\221\355<P\215\027?\272I,?\000\000\000\0005\001"
 & "\n\274t\023\274X94?\272I,?\000\000\000\0005\001\n\246\233\304;\343\245\033"
 & "?\305 0?\000\000\000\0005\001\no\022\003=\266\363\035?\272I,?\000\000\000"
 & "\0005\001\n\364\375\324<-\262=?\272I,?\000\000\000\0005\001\n\246\233\304"
 & "<m\347\033?\272I,?\000\000\000\0005\001\nw\276\037=\276\237:?\272I,?\000"
 & "\000\000\0005\001\no\022\003=\301\312\241>\272I,?\000\000\000\0005\001\n"
 & "\274t\223<\356|\037?Nb0?\274t\223\2745\001\n)\\\017=\376\3248?\272I,?\000"
 & "\000\000\0005\001\n\246\233\304;{\024.?\305 0?\000\000\000\0005\001\nB`"
 & "\345<o\022c?\272I,?\000\000\000\0005\001\nh\221\355<\354Q8?\272I,?o\022"
 & "\003\2745\001\n\236\357\'==\n7?)\\/?\226C\213\2745\001\n\315\314\314<R\270"
 & ">?\272I,?\000\000\000\0005\001\n\236\357\'==\n7?)\\/?\226C\213\2745\001"
 & "\nB`\345<\305 \020?\272I,?\000\000\000\0005\001\n\n\327\243;\264\310\026"
 & "?\272I,?\000\000\000\0005\001\n\002+\007=Zd\033?\272I,?\000\000\000\000"
 & "5\001\no\022\003\274\374\2511?\272I,?\000\000\000\0005\001\n\n\327#=d;\337"
 & ">\000\000\000?\215\227n\2765\001\n\226C\013=\177j<?\305 0?\000\000\000\000"
 & "5\001\n\n\327#=\020X\031?\272I,?\000\000\000\0005\001\n\217\302u<\236\357"
 & "G?\240\032/?\000\000\000\0005\001\nX94=\345\320\"?\272I,?\000\000\000\000"
 & "5\001\n\305 \260=\207\026\231>D\213,?R\270\036\2765\001\ny\351&>\274t3?"
 & "j\274\364>\000\000\000\0005\001\n\002+\007=m\347{>D\213,?R";

CONST E26_26 = 
   "\270\036\2765\001\n\217\302u<y\351&?D\213,?\000\000\000\0005\001\no\022"
 & "\003\273\022\203\000?\252\361R\276%\006\201\2765\001\n\217\302\365>\037"
 & "\205\213?\203\300j?7\211a?5\001\n\236\357\'=d;\037?\000\000\000?\274t\223"
 & "\2745\001\n#\333y=\n\327\003?-\262=?\035Zd\2765\001\n\246\233D<\313\241"
 & "\005?\356|\377>D\213l\2765\001\n\n\327#=\242E\366>\244p=?\343\245\233\274"
 & "5\001\nX9\264<\276\237\332>\022\203\000?\343\245\233\2745\001\n\033/\335"
 & "<H\341\372>\250\306+?B`e\2765\001\n\n\327\243;\331\316\367>\356|\377>ff"
 & "f\2765\001\n\000\000\000\000y\351\006?\201\225\003?\027\331N\2765\001\n"
 & "\000\000\000\000\254\034\232>\234\304\000?\226C\213\2745\001\n\274t\023"
 & "=\242E\026?\356|\377>B`e\2765\001\n\002+\007=\027\331\016?\211A\000?\000"
 & "\000\000\0005\001\n\246\233\304<\272I\f?\033/=?\226C\213\2745\001\n\002"
 & "+\007=\351&\021?\000\000\000?\035Zd\2765\001\n\274t\023\27433\363>\301\312"
 & "\001?o\022\203\2745\001\n)\\\017=\211A\000?\356|\377>\343\245\233\2745\001"
 & "\n\n\327#<\024\256\007?\020X\371>\343\245\233\2745\001\n\305 0=\354Q\370"
 & ">\327\2430?\226C\213\2745\001\n\315\314L=H\341\372>\356|\377>\037\205k\276"
 & "5\001\n\217\302\365<+\207\026?\000\000\000?1\010\254\2745\001\n\n\327#<"
 & "\031\004\326>\000\000\000?\343\245\233\2745\001\nB`\345;\303\365\010?\301"
 & "\312\001?\274t\223\2745\001\n\246\233D<\250\306+?}?\025?\274t\223\2745\001"
 & "\n1\010,=\240\032/?\000\000\000?\226C\213\2745\001\n\033/\335<\305 \360"
 & ">\223\030D?B`e\2765\001\n\246\233D<\274t3?\000\000\000?\325xi\2765\001\n"
 & "\217\302u=\240\032\357>7\211A?fff\2765\001\nh\221m=\226C\313>\272I,?Zd;"
 & "\2765\001\n\270\036\205=q=\n>\272I,?}?5\2765\001\n\301\312\241=\031\004"
 & "\326>\272I,?Zd;\2765\001\n\226C\213<\213l\007?\033/\235>;\337O>00000000"
 & "000000000000000000000000005\001\no\022\003\273\366(\034?)\\/?\000\000\000"
 & "\0005\001\n\033/\335<\325xi>\366(<?\f\002\353>5\001\nh\221\355<\360\247"
 & "\006?\201\225#?\000\000\000\0005\001\n\354Q8\276{\024\256>\337O-?\246\233"
 & "D\2745\001\n\364\375\324<\305 0?\027\331\316>\266\363\375=5\001\no\022\003"
 & ";\221\355\374>\262\235/?\313\241E\2765\001\n\305 \260=\303\365(?\260r\010"
 & "?\364\375\324\2745\001\nsh\021>\232\231\031?\315\314\f?\274t\023\2755\001"
 & "\n\262\235\357=7\211!?\'1\010?\002+\007\2755\001\n\213l\347=%\006!?\272"
 & "I\f?\274t\023\2755\001\n\246\233\304<o\022\203?\345\320\002?\217\302u\274"
 & "5\001\no\022\003=\351&q?\345\320\002?\217\302u\2745\001\n\354Q8=\016-\022"
 & "?\303\365h?\000\000\000\0005\001\n9\264H=\006\201u?\345\320\002?\217\302"
 & "u\2745\001\n\354Q8=\016-\022?\370Sc?X9\264\2745\001\n\315\314L=33\263>)"
 & "\\/?\270\036\305>5\001\n\n\327#<\347\373\t?\270\036%?\000\000\000\0005\001"
 & "\n\n\327\243<\274t\323>\010\254<?\f\002\353>5\001\nh\221\355<\360\247\006"
 & "?\201\225#?\000\000\000\0005\001\n\226C\213<\260r\010?\335$\006?o\022\003"
 & "<5\001\n\033/\335<\201\225#?\027\331\316>m\347\373=5\001\n\364\375\324<"
 & "D\213\354>\333\371>?\n\327\243\2745\001\n\315\314L=\205\353\321>\016-\362"
 & ">\213l\347=5\001\n\n\327#<L7\t?\325x\351>sh\221=5\001\n\217\302u<q=\n?D"
 & "\213\f?\315\314\314\2745\001\nB`e<^\272\t?\345\320\342>\236\357\247=5\001"
 & "\nB`e<y\351\006?^\272\311>q=\n>5\001\n\370S\343=\201\225c?\\\217\302=\226"
 & "C\213\2745\001\n)\\\217>1\010\254>\256G\201?\217\302\365\2755\001\n\217"
 & "\302u\275ff\206?\337O\215>\256Ga>5\001\n\217\302u<\254\034\032?%\006!?o"
 & "\022\203\2745\001\n333>L7)?\260r(?\274t\223\2745\001\n\n\327#<\317\367\023"
 & "?\244p=?\207\026Y\2755\001\n\364\375\324<\323MB?m\347;?\217\302u\2745\001"
 & "\n\345\320\">R\270^?!\260\022?b\020X\2765\001\n\305 0=\343\245;?\272I,?"
 & "\226C\213\2745\001\n\305 0=\343\245;?\315\314,?\217\302u\2745\001\nw\276"
 & "\037=\236\357G?b\0208?\246\233\304\2745\001\n\n\327#=Zd;?\323M\002?\000"
 & "\000\000\0005\001\n\n\327#=Zd;?m\347\373>\226C\213\2745\001\n\n\327\243"
 & "<\272I,?\327\243\360>\000\000\000\0005\001\n\n\327\243<\272I,?\327\243\360"
 & ">\000\000\000\2765\001\n\274t\023=\327\2430?q=\n?)\\\217\2755\001\nP\215"
 & "\027=\327\2430?\327\243\360>\000\000\000\0005\001\nP\215\027=\327\2430?"
 & "\327\243\360>\000\000\000\2765\001\n\354Q8=\256G\001?\262\235\357>\000\000"
 & "\000\0005\001\n\354Q8=\256G\001?{\024\016?h\221m\2755\001\n\364\375\324"
 & "<\221\355<?\272I,?\000\000\000\0005\001\n\274t\023=\004V.?\331\3167?\343"
 & "\245\233\2745\001\n\315\314L=\244p=?\272I,?\226C\213\2745\001\n`\345P=-"
 & "\262=?\315\314,?\217\302u\2745\001\n\274t\223<H\341Z?\272I,?\031\004\226"
 & ">5\001\n\315\314\314<h\221M?\211A@?\027\331\316\2755\001\n\n\327#<\n\327"
 & "\003?\203\300j?\343\245\033\2755\001\n\337O\215=V\016->R\270\236>=\nW>5"
 & "\001\n\217\302u<{\024.?\274t\223>\000\000\000\0005\001\n\177j\274<}?\025"
 & "?\260r\350>\000\000\000\0005\001\n\217\302\365<\317\367\023?X9\364>\000"
 & "\000\000\0005\001\n\033/\335<\252\361\202?\\\217\002?\n\327\243\2745\001"
 & "\n\217\302\365<Nbp?\370S\003?\217\302u\2745\001\nw\276\037=\351&\021?L7"
 & "i?o\022\003;5\001\n\354Q8=X9t?J\f\002?\n\327\243\2745\001\nX94=\230n\022"
 & "?\n\327c?\343\245\233\2745\001\n\274t\223<\215\227\356>R\270>?\000\000\000"
 & "\0005\001\n\315\314\314<\010\254\234>\333\371>?\203\300J\2765\001\n\315"
 & "\314L=\244p=?\037\205+?\n\327\243\2745\001\n9\264H=\033/=?\315\314,?\217"
 & "\302u\2745\001\n\n\327\243;\232\2319?\272I,?\031\004\226>5\001\nB`e<\205"
 & "\3531?\022\203@?\033/\335\2755\001\n\n\327#=d;\337>V\016m?\031\004\226\276"
 & "5\001\n\n\327#";

CONST E26_27 = 
   "=\177j\274=\315\314l?{\024\256\2755\001\n\n\327#=d;\337>V\016m?\031\004"
 & "\226\2765\001\n\000\000\000\000\215\227\256>V\016m?\n\327\243\27505\001"
 & "\n\000\000\000\000{\024\256>V\016m?\n\327\243\2755\001\n\362\322M>\234\304"
 & "\340>V\016m?\232\231\231\2755\001\nB`e<\\\217\202>)\\o?{\024\256\2755\001"
 & "\n\362\322M>\234\304\340>V\016m?)\\\217\2755\001\n\362\322M>\\\217\202>"
 & ")\\o?\n\327\243\27505\001\n1\010\254<\276\237\232>\333\371>?\203\300J\276"
 & "5\001\no\022\003;\364\375\224>\372~j?\321\"\333\2755\001\n\347\373\251>"
 & "=\n7?\250\306k?\347\373\251\2755\001\n\347\373\251>\341z\324>\232\231y?"
 & "X9\264\2755\001\nw\276\037=\341z\324>\250\306k?T\343\245\2755\001\n\033"
 & "/]=ff\346>V\016m?\031\004\226\2765\001\n\250\306\313>ff\346>\315\314l?{"
 & "\024\256\2755\001\n\033/]=ff\346>V\016m?\031\004\226\2765\001\nX9\264<\354"
 & "Q\270>V\016m?\n\327\243\2755\001\n\366(\234>\354Q\270>\315\314l?\301\312"
 & "\241\2755\001\n\n\327\243<\354Q\270>V\016m?\n\327\243\2755\001\n\226C\213"
 & "<\\\217\202>V\016m?\232\231\231\2755\001\n\362\322M>\323M\342>)\\o?{\024"
 & "\256\2755\001\n\226C\213<\\\217\202>V\016m?)\\\217\27505\001\0051H\000\000"
 & "\0005\001\t\315\314L\276\333\371~?\250\306k?d;_\276\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\001\001\001\001\001"
 & "\001\001\001\001\000\001\001\000\001\001\001\000\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\200>\002+\307>{\024\016?\000\000\000?\000\000\000?}?U?\002"
 & "+G?\372~\252>\372~\252>\372~\252>\000\000\000?\205\353\021?\000\000\200"
 & ">\321\"\033?\000\000\200>\004V\216>\000\000\000?\000\000\000?\000\000\000"
 & "?\000\000\000?\000\000\000?\000\000\000?\000\000\000?\000\000\000?\000\000"
 & "\000?\000\000\000?\372~\252>\372~\252>\205\353\021?\205\353\021?\205\353"
 & "\021?\000\000\000?\364\375T?\203\300*?\203\300*?\203\300*?\376\3248?\203"
 & "\300*?\203\300*?\376\3248?\002+G?\002+\307>\000\000\000?\203\300*?\177j"
 & "\034?\201\225c?\376\3248?\376\3248?\177j\034?\376\3248?\203\300*?\004V\016"
 & "?\177j\034?\376\3248?\203\300*?\201\225c?\203\300*?\177j\034?\177j\034?"
 & "\372~\252>\004V\216>\372~\252>\205\353\021?\000\000\000?\372~\252>\000\000"
 & "\000?\000\000\000?\370S\343>\000\000\000?\370S\343>\372~\252>\000\000\000"
 & "?\004V\016?\004V\216>\004V\216>\000\000\000?\004V\216>\002+G?\004V\016?"
 & "\000\000\000?\000\000\000?\000\000\000?\002+\307>\002+\307>\004V\216>\004"
 & "V\016?\370S\343>\203\300*?\000\000\000?\370S\343>\002+\307>\016-\262>\256"
 & "Ga>\016-\262>\205\353\021?\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\004V\216>\372~\252>\372~\252>\372~\252>\372~\252>\372~\252>\372"
 & "~\252>\372~\252>\372~\252>\000\000\000\000\372~\252>\372~\252>\000\000\000"
 & "\000\372~\252>\372~\252>\372~\252>\000\000\000\000\002+\307>\000\000\000"
 & "?\000\000\000?\000\000\000?\000\000\000?\256Ga>\000\000\000?\372~\252>d"
 & ";??\'1\210>\000\000\000?\321\"\033?\372~\252>d;??\372~\252>\315\314\314"
 & ">\205\353\021?\232\231\231>\232\231\231>\372~\252>\274t\023?\000\000\000"
 & "?\000\000\200>\372~\252>\232\231\231>\232\231\231>\000\000\000?\000\000"
 & "@?\000\000@?\000\000@?\000\000\000?\203\300*?\203\300*?\203\300*?\203\300"
 & "*?\203\300*?\203\300*?\374\251q?\203\300*?\203\300*?\203\300*?\203\300*"
 & "?\203\300*?\002+\307>\002+\307>\002+\307>\002+\307>\376\3248?\376\3248?"
 & "\376\3248?\376\3248?\376\3248?\376\3248?\376\3248?\205\353\021?\376\324"
 & "8?\376\3248?\376\3248?\376\3248?\376\3248?\177j\034?\177j\034?\000\000\000"
 & "?\000\000\000?\000\000\000?\000\000\000?\000\000\000?\000\000\000?\000\000"
 & "\000?\376\3248?\370S\343>\370S\343>\370S\343>\370S\343>\370S\343>\004V\216"
 & ">\004V\216>\004V\216>\004V\216>\000\000\000?\004V\016?\000\000\000?\000"
 & "\000\000?\000\000\000?\000\000\000?\000\000\000?\205\353\021?\000\000\000"
 & "?\004V\016?\004V\016?\004V\016?\004V\016?\370S\343>\000\000\000?\370S\343"
 & ">0000000000000000000000000000000005\001\nL7\211=\244p\275>\240\032/?\364"
 & "\375T\2745\001\n\226C\013>L7\t?)\\/?\250\306\313>5\001\n\002+\007\275\260"
 & "r\010?333?\000\000\000\0005\001\n\n\327\243\274\311v\376>\343\245;?\315"
 & "\314\314\2755\001\nw\276\037=\f\002K?\351&1?\n\327#\2745\001\n\n\327\243"
 & ";\252\3612?\215\227.?\343\245\233\2745\001\n9\264\310=\276\237\232>)\\/"
 & "?\221\355\274>5\001\nB`\345<\305 \260>)\\/?\307K7\2765\001\nX94\275\203"
 & "\300\212>)\\/?\307K7\2765\001\n\270\036\205=\325x\351>)\\/?\333\371~>5\001"
 & "\n\002+\007=\325x\t?7\211\001?\000\000\000\0005\001\n\217\302u\275\274t"
 & "\023>L7\t>5^:\2765\001\n`\345P={\024\016?b\020\230>\031\004";

CONST E26_28 = 
   "V>5\001\n\274t\023\274\004V\016>q=\n>\364\375T\2745\001\no\022\203\275\240"
 & "\032\257>)\\/?\274t\223\2745\001\n\226C\213<X9\364>\027\331.?B`e\2745\001"
 & "\n\n\327\243;+\207\326>\027\331.?\000\000\000\0005\001\n\033/\335\274\035"
 & "Z\344>\027\331.?\000\000\000\0005\001\n\217\302u\274ff\346>\027\331.?\364"
 & "\375T\2745\001\n\217\302u\274\234\304\000?\027\331.?\000\000\000\0005\001"
 & "\nX94\274\020X\371>\226C+?\364\375T\2745\001\n\177j\274<\323M\002?\362\322"
 & "-?\217\302u\2745\001\n\364\375T=ff\006?\226C+?\000\000\000\0005\001\n\246"
 & "\233D;F\266\363>\027\331.?\364\375T\2745\001\n\246\233D\27433\363>\027\331"
 & ".?\n\327#\2745\001\n\177j\274<\002+\207>\f\002\353>\364\375T\2745\001\n"
 & "\315\314\314\274\002+\207>\f\002\353>Zd;\2765\001\n\266\363\375<\347\373"
 & "\t?\201\225\003?o\022\003\2745\001\n\002+\007=\325x\t?\272I\314>\321\"\333"
 & "=5\001\n\266\363\375<\347\373\t?\201\225\003?o\022\003\2745\001\n\301\312"
 & "\241=\327\243\360>\240\032/?\364\375T\2745\001\n%\006\201=\270\036E?)\\"
 & "/?\274t\223\2745\001\nL7\211\275\331\316\027?\027\331.?\000\000\000\000"
 & "5\001\n\246\233\304\274w\276\037?\226C+?\000\000\000\0005\001\no\022\003"
 & "=\337O-?)\\/?\274t\223\2745\001\n\177j<\275)\\/?\226C+?\000\000\000\000"
 & "5\001\n\033/\335\274\002+\'?\226C+?\000\000\000\0005\001\n\364\375T\274"
 & "\303\365(?\226C+?\000\000\000\0005\001\n1\010\254<j\2744?)\\/?\274t\223"
 & "\2745\001\n\246\233\304\274D\213L?\226C+?\000\000\000\0005\001\no\022\003"
 & "\275;\337\317>\226C+?\000\000\000\0005\001\n\177j<\275\335$\006?\226C+?"
 & "\203\300\312\2755\001\n1\010\254\274F\2663?\226C+?\000\000\000\0005\001"
 & "\nX9\264\274=\n\027?\226C+?\000\000\000\0005\001\nh\221\355\274\203\300"
 & "j?\226C+?\246\233D\2745\001\n\033/\335\274\356|??\226C+?\217\302u\2745\001"
 & "\n\033/\335<`\3450?)\\/?\274t\223\2745\001\n\033/\335\274\221\355\034?\226"
 & "C+?\000\000\000\0005\001\n\033/\335<`\3450?)\\/?\364\375T\2765\001\nh\221"
 & "\355\274\356|\037?\226C+?\000\000\000\0005\001\no\022\003;\360\247\006?"
 & ")\\/?\274t\223\2745\001\n\315\314L=ff&?\226C+?\000\000\000\0005\001\nL7"
 & "\211=\311v>?\226C+?\274t\223\2745\001\n\270\036\205==\n7?\226C+?\274t\223"
 & "\2745\001\n\270\036\205=\327\243p?\226C+?\274t\223\2745\001\n\246\233\304"
 & "\274\374\2511?\226C+?\000\000\000\0005\001\n\006\201\225=9\264(?\226C+?"
 & "\000\000\000\0005\001\nX94\274=\n\027?\226C+?\000\000\000\0005\001\nP\215"
 & "\027\275\020X\271>D\213,?\345\320\"\2765\001\no\022\203\272\027\331\216"
 & ">)\\/?\274t\223\2745\001\nB`e\275\262\235\257>D\213,?\234\304 \2765\001"
 & "\nL7\211=\234\304\000?\226C+?\343\245\233>5\001\n\000\000\000\000\000\000"
 & "\000?\232\231\231\275\000\000\000\2765\001\no\022\003>\347\373\251>)\\/"
 & "?\221\355\274>5\001\n1\010\254\274\303\365\350>D\213\354>B`e\2745\001\n"
 & "B`e\274\370S\343>\252\3612?\364\375T\2745\001\n\n\327\243\2739\264\310>"
 & "D\213\354>\364\375T\2745\001\n1\010\254\274\035Z\004?\252\3612?\364\375"
 & "T\2745\001\n\n\327\243;\250\306\313>D\213\354>\364\375T\2745\001\nV\016"
 & "-\276\035Z\344>!\2602?\205\353Q\2765\001\n\364\375T\275j\274\364>D\213\354"
 & ">;\337O\2765\001\n\364\375T\274\333\371\376>\252\3612?\274t\023\2745\001"
 & "\no\022\003;\360\247\206>\240\032/?\274t\023\2745\001\n7\211A\276\027\331"
 & "\216>\240\032/?\317\367S\2765\001\n\177j\274\274\307K\367>\252\3612?o\022"
 & "\003\2745\001\no\022\003;\341z\224>\252\3612?\274t\023\2745\001\nB`e\274"
 & "\376\3248?D\213\354>\274t\023\2745\001\n\246\233\304\273\177j\374>D\213"
 & "\354>\274t\023\2745\001\n\246\233D\273\301\312\341>D\213\354>\364\375T\274"
 & "5\001\n\217\302\365\275\035Z\344>D\213\354>\205\353Q\2765\001\no\022\203"
 & ":\351&\361>D\213\354>\205\353Q\2765\001\n1\010\254\274\002+\307>D\213\354"
 & ">\000\000\000\0005\001\n\343\245\233\274\372~\252>D\213\354>\364\375T\274"
 & "5\001\nX94\274;\337\217>b\020\030?\274t\023\2745\001\n\217\302u<m\347\373"
 & ">D\213\354>\274t\023\2745\001\no\022\203<\337O\315>D\213\354>\364\375T\274"
 & "5\001\no\022\203<\033/\035?D\213\354>\364\375T\2745\001\n\177j<\275\305"
 & " \360>D\213\354>\364\375T\2745\001\n\022\203\300\2759\264\310>D\213\354"
 & ">\205\353Q\2765\001\n\305 0\275\177j\274>T\343\345>w\276\237\2755\001\n"
 & "\n\327\243;d;\337>\262\235/?\356|?\2765\001\n\002+\207=-\262\035>)\\/?\274"
 & "t\223\2745\001\n\223\030\004\276\276\237\232>\262\235/?\356|?\2765\001\n"
 & "\033/]=\223\030\004?\372~\252>\351&1>000000000000000005\001\no\022\003;"
 & "F\266s>D\213\354>\274t\023\2745\001\n{\024\256=b\020\230>\230n2?\223\030"
 & "\004?5\001\n\004V\016>J\f\302>\230n2?\223\030\004?5\001\n\n\327#=m\347\273"
 & ">\327\2430?\223\030\004?5\001\n\246\233D=Nb\320>\024\256\'?L7\t?5\001\n"
 & "`\345P=L7\311>\356|\037?h\221\r?5\001\nsh\221=\335$\306>h\221-?\223\030"
 & "\004?5\001\ny\351&>\031\004\226>\024\256\'?ff\006?5\001\n\256Ga=\226C\313"
 & ">\024\256\'?ff\006?05\001\nJ\f\002>{\024\256>\276\237:?\223\030\004?5\001"
 & "\n\n\327\243\275w\276\037>\n\327\243;d;_\27605\001\n\337O\215=\333\371\376"
 & ">\230n2?\223\030\004?5\001\n\n\327#\2757\211A>X94=\351&1\2765\001\n\301"
 & "\312\241=\230n\322>\327\2430?\223\030\004?05\001\n\343\245\233</\335\244"
 & ">m\347\373>\205\353Q\2765\001\n1\010,=\234\304\340>\274t\023?\230n\022\276"
 & "5\001\no\022\003\275\\\217\002?\027\331.?\246\233D\2745\001\n\364\375\324"
 & "\274\360\247\006?\031\004\026?\226C\013=5\001\n\002+\007=\234\304 ?\226"
 & "C+?\000\000\000\0005\001\n\002+\207=-\262\035>)\\/?\274t\223\2745\001\n"
 & "\274t\023=\f\002\353>)\\/?\230n\022\2761\274\t\000\0005\001\n\217\302\365"
 & "<\331\3167?)\\/?\274t\223\2745\001\no\022\203<\303\365\250>)\\/?\272";

CONST E26_29 = 
   "I\314>5\001\n\246\233D<\262\235\357>\341z\324>o\022\003=5\001\n`\345P={"
 & "\024\016?\272I\314>\033/\335=5\001\no\022\003;\203\300\212>Nb\220>\347\373"
 & ")>5\001\n\217\302\365<\331\3167?)\\/?\274t\223\2741\271\t\000\0005\001\n"
 & "\347\373\251=\221\355\274>\027\331.?\226C\313>5\001\n\002+\007=\325x\t?"
 & "7\211\001?\000\000\000\0005\001\no\022\003;\211A\240>\027\331.?\272I\214"
 & ">5\001\n\226C\213<\035Z\244>\027\331.?\024\256\207>1\266\t\000\0005\001"
 & "\n\217\302u\275\223\030\004?T\343\345>\317\367S\2765\001\n\325xi\275;\337"
 & "\017?\226C+?\313\241E\2765\001\n`\345P=\250\306K>)\\\317>\201\225\203>1"
 & "\276\t\000\0005\001\n\217\302\365<\254\034\232>\027\331.?\272I\214>5\001"
 & "\nB`e=\374\251\261>)\\/?\315\314\314>5\001\n\246\233D<\262\235\357>\341"
 & "z\324>o\022\003=5\001\nB`\345;u\2238?\027\331.?B`e\2745\001\n\274t\023\274"
 & "\207\0269?\027\331.?B`e\2745\001\nB`\345;#\3339?\027\331.?B`e\2745\001\n"
 & "\217\302\365<P\215\327>m\347\373>\205\353Q\2765\001\nL7\211\275\331\316"
 & "\027?\213lg?\000\000\000\0005\001\nL7\211\275\331\316\027?\213lg?\000\000"
 & "\000\0005\001\nL7\211\275\331\316\027?\313\241e?\000\000\000\0005\001\n"
 & "L7\211\275\331\316\027?\010\254\\?\000\000\000\0005\001\nL7\211\275\331"
 & "\316\027?\010\254\\?\000\000\000\0005\001\nL7\211\275\331\316\027?\250\306"
 & "k?\000\000\000\0005\001\no\022\203\275\f\002k?\226C+?\000\000\000\0005\001"
 & "\no\022\003=\337O-?)\\/?d;_\2765\001\n\033/\335\274\002+\'?\213lg?\000\000"
 & "\000\0005\001\n\033/\335\274\002+\'?\213lg?\000\000\000\0005\001\n\033/"
 & "\335\274\002+\'?\313\241e?\000\000\000\0005\001\n\033/\335\274\002+\'?\010"
 & "\254\\?\000\000\000\0005\001\no\022\003\275;\337\317>\213lg?\000\000\000"
 & "\0005\001\no\022\003\275\252\361\322>\213lg?\000\000\000\0005\001\no\022"
 & "\003\275=\n\327>\313\241e?\000\000\000\0005\001\no\022\003\275\n\327\343"
 & ">\010\254\\?\000\000\000\0005\001\n\266\363\375\274333?\226C+?\000\000\000"
 & "\0005\001\n\033/\335\274\356|??\010\254\\?\217\302u\2745\001\n\033/\335"
 & "<`\3450?\213lg?\274t\223\2745\001\n\033/\335<`\3450?\213lg?\274t\223\274"
 & "5\001\n\033/\335<`\3450?\313\241e?\274t\223\2745\001\n\033/\335<`\3450?"
 & "\010\254\\?\274t\223\2745\001\n\033/\335<`\3450?\010\254\\?\274t\223\274"
 & "5\001\n\246\233D=\313\241\005?H\341\372>o\022\203<5\001\n\033/\335<`\345"
 & "0?\201\225C?\000\000\000\2765\001\nL7\211=\311v>?\213lg?\274t\223\2745\001"
 & "\nL7\211=\311v>?\213lg?\274t\223\2745\001\nL7\211=\311v>?\313\241e?\274"
 & "t\223\2745\001\nL7\211=\311v>?\010\254\\?\274t\223\2745\001\n\006\201\225"
 & "=9\264(?\213lg?\000\000\000\0005\001\n\033/\335\274!\260\022?\226C+?\000"
 & "\000\000\0005\001\n\315\314L\276\016-\362>\341z4?\315\314L\2765\001\n1\010"
 & "\254\274\303\365\350>\230n2?B`e\2745\001\n1\010\254\274V\016\355>\230n2"
 & "?B`e\2745\001\n1\010\254\274\303\365\350>\327\2430?B`e\2745\001\n1\010\254"
 & "\274Zd\373>\024\256\'?B`e\2745\001\n1\010\254\274\351&\361>\024\256\'?B"
 & "`e\2745\001\n1\010\254\274\303\365\350>\276\237:?B`e\2745\001\n\n\327\243"
 & "\273\272I,?D\213\354>\364\375T\2745\001\n\246\233\304\2749\264\310>D\213"
 & "\354>d;_\2765\001\n\n\327\243;\250\306\313>\230n2?\364\375T\2745\001\n\n"
 & "\327\243;R\270\336>\230n2?\364\375T\2745\001\n\n\327\243;u\223\330>\327"
 & "\2430?\364\375T\2745\001\n\n\327\243;\345\320\342>\024\256\'?\364\375T\274"
 & "5\001\no\022\003;\270\036\205>\230n2?\274t\023\2745\001\no\022\003;X9\264"
 & ">\230n2?\274t\023\2745\001\no\022\003\273ff\246>\327\2430?\274t\023\274"
 & "5\001\no\022\003;\354Q\270>\024\256\'?\274t\023\2745\001\n\246\233D\273"
 & "\260r\350>\252\3612?\364\375T\2745\001\n\246\233\304\273%\006\001?\024\256"
 & "\'?\274t\023\2745\001\n\246\233D\273\301\312\341>\230n2?\364\375T\2745\001"
 & "\n\246\233D\273V\016\355>\230n2?\364\375T\2745\001\n\246\233D\273y\351\346"
 & ">\327\2430?\364\375T\2745\001\n\246\233D\273Zd\373>\024\256\'?\364\375T"
 & "\2745\001\n\246\233D\273\215\227\356>\024\256\'?\364\375T\2745\001\n\002"
 & "+\007=\325x\t?\303\365\010?h\221\355\2745\001\n\246\233D\273\301\312\341"
 & ">)\\\017?F\266\363\2755\001\n\217\302u<m\347\373>\230n2?\274t\023\2745\001"
 & "\n\217\302u<m\347\373>\230n2?\274t\023\2745\001\n\217\302u<m\347\373>\327"
 & "\2430?\274t\023\2745\001\n\217\302u<\221\355\374>\024\256\'?\274t\023\274"
 & "5\001\n\022\203\300\275R\270\336>\230n2?\205\353Q\2765\001\n\217\302\365"
 & "\275\035Z\344>\252\3612?\205\353Q\2765\001\n\022\203\300\275\211A\340>\024"
 & "\256\'?\205\353Q\2760005\001\0051=\000\000\0005\001\t1\010,\276\000\000"
 & "\200?)\\o?d;_\276\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\001\001\001\001\001\001\001\001\001\000\001\001\000\001"
 & "\001\001\000\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\200>\372~\252>{\024";

CONST E26_30 = 
   "\016?\000\000\000?\000\000\000?\000\000\200?}?U?\372~\252>\372~\252>\372"
 & "~\252>\000\000\000?\205\353\021?\000\000\200>\205\353\021?\000\000\200>"
 & "\004V\216>\000\000\000?\000\000\000?\000\000\000?\000\000\000?\000\000\000"
 & "?\000\000\000?\000\000\000?\000\000\000?\000\000\000?\000\000\000?\372~"
 & "\252>\372~\252>\205\353\021?\205\353\021?\205\353\021?\000\000\000?{\024"
 & "n?\376\3248?\203\300*?\376\3248?\376\3248?\203\300*?\177j\034?\002+G?\002"
 & "+G?\002+\307>\000\000\000?\002+G?\203\300*?\374\251q?\376\3248?\002+G?\177"
 & "j\034?\002+G?\376\3248?\004V\016?\203\300*?\376\3248?\376\3248?\000\000"
 & "\200?\376\3248?\376\3248?\203\300*?\372~\252>\004V\216>\372~\252>j\274\024"
 & "?\000\000\000?\372~\252>\000\000\000?\004V\016?\370S\343>\004V\016?\370"
 & "S\343>\372~\252>\000\000\000?\004V\016?\004V\216>\372~\252>\004V\016?\004"
 & "V\216>}?U?\004V\016?\000\000\000?\004V\016?\004V\016?\370S\343>\002+\307"
 & ">\372~\252>\004V\016?\000\000\000?\376\3248?\000\000\000?\000\000\000?\370"
 & "S\343>^\272\311>\256Ga>^\272\311>\270\036\005?\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\004V\216>\372~\252>\372~\252>\372~\252>\372"
 & "~\252>\372~\252>\372~\252>\372~\252>\372~\252>\000\000\000\000\372~\252"
 & ">\372~\252>\000\000\000\000\372~\252>\372~\252>\372~\252>\000\000\000\000"
 & "\372~\252>\000\000\000?\000\000\000?\000\000\000?\000\000\000?\256Ga>\000"
 & "\000\000?\372~\252>d;??\232\231\231>\000\000\000?\205\353\021?\372~\252"
 & ">d;??\372~\252>\315\314\314>\205\353\021?\232\231\231>\232\231\231>\372"
 & "~\252>\004V\016?q=\n?\000\000\200>\372~\252>\232\231\231>\303\365\250>\000"
 & "\000\000?\000\000@?\000\000@?\000\000@?\000\000\000?\376\3248?\376\3248"
 & "?\376\3248?\376\3248?\376\3248?\376\3248?\000\000\200?\376\3248?\203\300"
 & "*?\203\300*?\203\300*?\203\300*?\002+\307>\002+\307>\002+\307>\002+\307"
 & ">\376\3248?\376\3248?\002+G?\002+G?\002+G?\002+G?\002+G?\205\353\021?\002"
 & "+G?\376\3248?\376\3248?\376\3248?\376\3248?\376\3248?\177j\034?\004V\016"
 & "?\000\000\000?\000\000\000?\000\000\000?\000\000\000?\000\000\000?\000\000"
 & "\000?\376\3248?\370S\343>\370S\343>\370S\343>\370S\343>\370S\343>\004V\216"
 & ">\004V\216>\004V\216>\004V\216>\000\000\000?\004V\016?\000\000\000?\000"
 & "\000\000?\000\000\000?\000\000\000?\000\000\000?\205\353\021?\000\000\000"
 & "?\004V\016?\004V\016?\004V\016?\004V\016?\000\000\000?\004V\016?\000\000"
 & "\000?0000000000000000000000000000000005\001\nT\343\245=\022\203\200>`\345"
 & "0?\364\375T\2745\001\n\347\373\251=\374\251\361>`\3450?\027\331\316>5\001"
 & "\no\022\203;\266\363\375>333?\000\000\000\0005\001\nh\221\355<\374\251\361"
 & ">\000\000@?\203\300\312\2755\001\n\266\363\375=\022\203`?\351&1?B`e\274"
 & "5\001\n\266\363}=\325xI?`\3450?o\022\203\2745\001\n\301\312\241=\360\247"
 & "\206>`\3450?\242E\266>5\001\n\177j<=\010\254\234>\374\2511?1\010,\2765\001"
 & "\n\033/\335<\252\361\222>\374\2511?1\010,\2765\001\nB`e=/\335\344>`\345"
 & "0?\\\217\202>5\001\n\002+\007=\325x\t?7\211\001?\000\000\000\0005\001\n"
 & "w\276\037=\035Zd>R\270\036>\354Q8\2765\001\n\002+\007=\325x\t?b\020\230"
 & ">\031\004V>5\001\n\236\357\'==\nW>w\276\037>\364\375T\2745\001\n\246\233"
 & "\304\274\276\237\232>`\3450?\343\245\233\2745\001\n\246\233\304<F\266\363"
 & ">\305 0?\364\375T\2745\001\n\270\036\205=\323M\342>\305 0?\000\000\000\000"
 & "5\001\n\226C\213<j\274\364>\305 0?\000\000\000\0005\001\no\022\203<\262"
 & "\235\357>\305 0?B`e\2745\001\n\343\245\233<33\363>\305 0?\000\000\000\000"
 & "5\001\nX9\264<\327\243\360>V\016-?o\022\003\2745\001\nB`\345<33\363>\305"
 & " 0?\364\375T\2745\001\n\226C\213<X9\364>V\016-?\000\000\000\0005\001\nB"
 & "`\345<\374\251\361>\305 0?\364\375T\2745\001\n\364\375\324<\016-\362>\305"
 & " 0?\364\375T\2745\001\n\236\357\247=\022\203\200>\374\251\361>\364\375T"
 & "\2745\001\n\236\357\247=\'1\210>\374\251\361>\354Q8\2765\001\n\266\363\375"
 & "<\347\373\t?\201\225\003?o\022\003\2745\001\n\002+\007=\325x\t?\272I\314"
 & ">\321\"\333=5\001\n\266\363\375<\347\373\t?\201\225\003?o\022\003\2745\001"
 & "\n\325xi=\n\327\343>Nb0?\364\375T\2745\001\n\033/\335=\230nR?`\3450?\343"
 & "\245\233\2745\001\n\274t\023<Nb0?\327\2430?\000\000\000\0005\001\no\022"
 & "\203<\311v\036?V\016-?\000\000\000\0005\001\n9\264H=;\337/?`\3450?\343\245"
 & "\233\2745\001\nB`e<\327\2430?V\016-?\000\000\000\0005\001\no\022\203<\223"
 & "\030$?V\016-?\000\000\000\0005\001\no\022\203<}?\025?V\016-?\000\000\000"
 & "\0005\001\nP\215\027=\256GA?`\3450?\343\245\233\2745\001\n1\010\254<\323"
 & "MB?V\016-?\000\000\000\0005\001\n\n\327\243<\244p\275>V\016-?\000\000\000"
 & "\0005\001\n\246\233D;}?\365>V\016-?\246\233\304\2755\001\n\217\302\365<"
 & "/\335D?V\016-?\000\000\000\0005\001\n\343\245\233<\370S#?V\016-?\000\000"
 & "\000\0005\001\nB`e<\250\306k?V\016-?\000\000\000\0005\001\no\022\203<\274"
 & "t3?V\016-?\274t\223\2745\001\n)\\\017=?5>?`\3450?\343\245\233\2745\001\n"
 & "o\022\203<\232\231\031?V\016-?\000\000\000\0005\001\n)\\\017=?5>?`\3450"
 & "?X94\2765\001\n\364\375\324<=\n7?V\016-?\000\000\000\0005\001\n)\\\017="
 & "\370S\003?\351&1?\343\245\233\2745\001\n\266\363\375<\345\320\"?V\016-?"
 & "\000\000\000\0005\001\no\022\203<\274t3?V\016-?\343\245\233\2745\001\no"
 & "\022\203<\274t3?V\016-?\274t\223\2745\001\n\343\245\233<\321\"{?V\016-?"
 & "\217\302u\2745\001\no\022\203<\252\3612?V\016-?\000\000\000\0005\001\n\217"
 & "\302u<\252\3612?V\016-?\000\000";

CONST E26_31 = 
   "\000\0005\001\nB`\345<\323M\"?V\016-?\000\000\000\0005\001\nL7\211=\254"
 & "\034\232>h\221-?u\223\030\2765\001\n\315\314\314\274\321\"\233>`\3450?\343"
 & "\245\233\2745\001\no\022\003=\'1\210>h\221-?u\223\030\2765\001\n\006\201"
 & "\225=\323M\002?V\016-?d;\237>5\001\n\000\000\000\000\000\000\000?\232\231"
 & "\231\275\000\000\000\2765\001\n)\\\217=J\f\202>`\3450?\242E\266>5\001\n"
 & "\315\314\314<#\333\371>\016-\362>B`e\2745\001\n\226C\213<B`\005?V\016-?"
 & "B`e\2745\001\n\315\314\314<\366(\334>\016-\362>B`e\2745\001\n\315\314\314"
 & "<9\264\010?V\016-?B`e\2745\001\n\315\314\314<\254\034\332>\016-\362>B`e"
 & "\2745\001\nB`e<\002+\307>`\3450?\000\000\000\0005\001\nB`\345<\307K\367"
 & ">\016-\362>\252\361R\2765\001\no\022\203<9\264\010?V\016-?\000\000\000\000"
 & "5\001\no\022\203<\\\217\202>`\3450?\000\000\000\0005\001\n\325xi\275\360"
 & "\247\206>`\3450?;\337O\2765\001\nX9\264<\f\002\013?V\016-?\000\000\000\000"
 & "5\001\no\022\203<\\\217\202>V\016-?\000\000\000\0005\001\no\022\203<NbP"
 & "?\016-\362>\000\000\000\0005\001\n1\010\254<\347\373\t?\016-\362>\000\000"
 & "\000\0005\001\n\315\314\314<F\266\363>\016-\362>B`e\2745\001\n\343\245\233"
 & "<\335$\006?\016-\362>\205\353Q\2765\001\n\226C\013=L7\t?\016-\362>\205\353"
 & "Q\2765\001\nh\221\355<?5\336>\016-\362>\000\000\000\0005\001\n\315\314\314"
 & "<\376\324\270>\016-\362>B`e\2745\001\n\n\327\243<\347\373\251>\256G!?\246"
 & "\233D\2745\001\no\022\203<\325x\t?1\010\354>B`e\2745\001\n1\010\254<\354"
 & "Q\370>1\010\354>B`e\2745\001\n\177j\274<\364\3754?1\010\354>B`e\2745\001"
 & "\n\246\233D<\331\316\367>1\010\354>\000\000\000\0005\001\no\022\203<\217"
 & "\302\365>1\010\354>\205\353Q\2765\001\n1\010\254<=\n\327>1\010\354>\000"
 & "\000\000\0005\001\nX9\264<{\024\256>!\2602?333\2765\001\n\002+\207=-\262"
 & "\035>`\3450?\343\245\233\2745\001\n\033/]=\311v\276>!\2602?333\2765\001"
 & "\nh\221\355<Zd\373>\372~\252>\351&1>000000000000000005\001\no\022\203<\\"
 & "\217\202>1\010\354>\000\000\000\0005\001\no\022\003<m\347{>+\2076?\002+"
 & "\007?5\001\n\305 \260=T\343\245>+\2076?\002+\007?5\001\no\022\003\273\037"
 & "\205\253>X94?\002+\007?5\001\no\022\203\274!\260\262>D\213,?1\010\f?5\001"
 & "\no\022\203:\325x\251>o\022#?\327\243\020?5\001\n\217\302u<\345\320\242"
 & ">`\3450?\002+\007?5\001\n\252\361\322=\037\205k>\203\300*?\325x\t?5\001"
 & "\no\022\003\273\037\205\253>\203\300*?\325x\t?05\001\n\217\302u=\250\306"
 & "\213>\244p=?y\351\006?5\001\n\226C\213=+\207\226>\000\000\000\000d;_\276"
 & "05\001\n\364\375T\274\232\231\331>+\2076?\002+\007?5\001\n\354Q\270=\370"
 & "S\243>X94=\351&1\2765\001\no\022\003\273\037\205\253>X94?\002+\007?05\001"
 & "\n\236\357\247=%\006\201>\211A\000?;\337O\2765\001\n\207\026Y=\372~\352"
 & ">+\207\026?)\\\017\2765\001\n1\010\254<X9\364>\240\032/?B`e\2745\001\n\364"
 & "\375\324\274\360\247\006?\221\355\034?#\333y=5\001\no\022\203\2751\010\f"
 & "?V\016-?\000\000\000\0005\001\n\002+\207=-\262\035>`\3450?\343\245\233\274"
 & "5\001\n\325xi=\345\320\342>`\3450?\002+\007\2761\205\n\000\0005\001\n\364"
 & "\375\324<u\2238?`\3450?\343\245\233\2745\001\no\022\203\272\254\034\232"
 & ">\305 0?\226C\313>5\001\n\177j\274<\016-\362>\341z\324>\274t\023=5\001\n"
 & "\002+\007=\325x\t?\272I\314>\033/\335=5\001\nX94=\252\361\222>\252\361\222"
 & ">\240\032/>5\001\n\364\375\324<u\2238?`\3450?\343\245\233\2741\202\n\000"
 & "\0005\001\n\325xi=\262\235\257>\305 0?\362\322\315>5\001\n\002+\007=\325"
 & "x\t?7\211\001?\000\000\000\0005\001\n\000\000\000\000\232\231\231>\305 "
 & "0?\315\314\214>5\001\n\246\233D;b\020\230>\305 0?L7\211>1\177\n\000\000"
 & "5\001\n\002+\007=L7\t?1\010\354>\252\361R\2765\001\n\000\000\000\000/\335"
 & "\004?V\016-?\311v>\2765\001\n\236\357\'==\nW>\006\201\325>\266\363}>1\207"
 & "\n\000\0005\001\nB`\345<\250\306\213>\305 0?\315\314\214>5\001\n\274t\223"
 & "<w\276\237>\305 0?\226C\313>5\001\n\033/\335<X9\364>\341z\324>\274t\023"
 & "=5\001\nB`\345<?5>?\305 0?\246\233D\2745\001\nB`\345\273ffF?\305 0?\246"
 & "\233D\2745\001\n\177j\274<\343\245;?\305 0?\246\233D\2745\001\n\256Ga=\345"
 & "\320\342>\211A\000?\362\322M\2765\001\n\274t\023<Nb0?\272Il?\000\000\000"
 & "\0005\001\n\274t\023<Nb0?\272Il?\000\000\000\0005\001\n\274t\023<Nb0?\347"
 & "\373i?\000\000\000\0005\001\n\274t\023<Nb0?\323Mb?\000\000\000\0005\001"
 & "\n\274t\023<Nb0?\022\203`?\000\000\000\0005\001\n\274t\023<Nb0?)\\o?\000"
 & "\000\000\0005\001\no\022\203;\274ts?V\016-?\000\000\000\0005\001\n9\264"
 & "H=;\337/?`\3450?d;_\2765\001\no\022\203<\223\030$?\272Il?\000\000\000\000"
 & "5\001\no\022\203<\223\030$?\272Il?\000\000\000\0005\001\no\022\203<\223"
 & "\030$?\347\373i?\000\000\000\0005\001\no\022\203<\223\030$?\022\203`?\000"
 & "\000\000\0005\001\n\n\327\243<\244p\275>\272Il?\000\000\000\0005\001\n\n"
 & "\327\243<\244p\275>\272Il?\000\000\000\0005\001\n\n\327\243<\244p\275>\347"
 & "\373i?\000\000\000\0005\001\n\n\327\243<\244p\275>\022\203`?\000\000\000"
 & "\0005\001\n\246\233\304;\327\2430?V\016-?\000\000\000\0005\001\no\022\203"
 & "<\274t3?\323Mb?\274t\223\2745\001\n)\\\017=?5>?\272Il?\343\245\233\2745"
 & "\001\n)\\\017=?5>?\272Il?\343\245\233\2745\001\n)\\\017=?5>?\347\373i?\343"
 & "\245\233\2745\001\n)\\\017=?5>?\323Mb?\343\245\233\2745\001\n)\\\017=?5"
 & ">?\022\203`?\343\245\233\2745\001\n\246\233D=\313\241\005?H\341\372>o\022"
 & "\203<5\001\n)\\\017=?5>?\010\254<?P\215\227\2755";

CONST E26_32 = 
   "\001\no\022\203<\274t3?\272Il?\343\245\233\2745\001\no\022\203<\274t3?\272"
 & "Il?\343\245\233\2745\001\no\022\203<\274t3?\347\373i?\343\245\233\2745\001"
 & "\no\022\203<\274t3?\022\203`?\343\245\233\2745\001\n\217\302u<\252\3612"
 & "?h\221m?\000\000\000\0005\001\no\022\203<\232\231\031?V\016-?\000\000\000"
 & "\0005\001\n\343\245\233<\035Z\004?`\3450?\246\233D\2745\001\n\315\314\314"
 & "<#\333\371>+\2076?B`e\2745\001\n\315\314\314<#\333\371>+\2076?B`e\2745\001"
 & "\n\315\314\314<#\333\371>X94?B`e\2745\001\n\315\314\314<#\333\371>D\213"
 & ",?B`e\2745\001\n\315\314\314<#\333\371>\203\300*?B`e\2745\001\n\315\314"
 & "\314<#\333\371>\244p=?B`e\2745\001\n\002+\007=sh1?\016-\362>B`e\2745\001"
 & "\n\315\314\314<\366(\334>\016-\362>d;_\2765\001\n\315\314\314<\254\034\332"
 & ">+\2076?B`e\2745\001\n\315\314\314<\254\034\332>+\2076?B`e\2745\001\n\315"
 & "\314\314<\254\034\332>X94?B`e\2745\001\n\315\314\314<\254\034\332>\203\300"
 & "*?B`e\2745\001\n\364\375\324\274\\\217\202>+\2076?\000\000\000\0005\001"
 & "\no\022\203<\341z\224>+\2076?\000\000\000\0005\001\n\274t\023\275\254\034"
 & "\232>X94?\000\000\000\0005\001\n\274t\023\275\254\034\232>\203\300*?\000"
 & "\000\000\0005\001\n\315\314\314<F\266\363>`\3450?B`e\2745\001\n1\010\254"
 & "<\347\373\t?D\213,?\000\000\000\0005\001\n\315\314\314<F\266\363>+\2076"
 & "?B`e\2745\001\n\315\314\314<F\266\363>+\2076?B`e\2745\001\n\315\314\314"
 & "<F\266\363>X94?B`e\2745\001\n\315\314\314<F\266\363>D\213,?B`e\2745\001"
 & "\n\315\314\314<F\266\363>\203\300*?B`e\2745\001\n\002+\007=\325x\t?\325"
 & "x\t?\266\363\375\2745\001\n\315\314\314<F\266\363>D\213\f?\177j\274\275"
 & "5\001\no\022\203<\325x\t?+\2076?B`e\2745\001\no\022\203<\325x\t?+\2076?"
 & "B`e\2745\001\no\022\203<\325x\t?X94?B`e\2745\001\no\022\203<\325x\t?\203"
 & "\300*?B`e\2745\001\no\022\203<\217\302\365>+\2076?\205\353Q\2765\001\n\343"
 & "\245\233<\335$\006?V\016-?\205\353Q\2765\001\no\022\203<\217\302\365>\203"
 & "\300*?\205\353Q\2760005\001\0051\\\000\000\0005\001\t\347\373)\276\000\000"
 & "\200?\004Vn?fff\276\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\001\001\001\001\001\001\001\001\001\000\001\001\000"
 & "\001\001\001\000\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\004V\216>\004V\216>\217\302"
 & "\265>\004V\016?\004V\016?\201\225c?\203\300*?\370Sc>\372~\252>\372~\252"
 & ">\002+\307>\006\201\025?\004V\216>\006\201\025?\004V\216>\004V\216>\004"
 & "V\016?\004V\016?\004V\016?\004V\016?\004V\016?\004V\016?\004V\016?\004V"
 & "\016?\004V\016?\004V\016?\004V\216>\004V\216>\006\201\025?\006\201\025?"
 & "\006\201\025?\004V\016?\205\353\201?\203\300*?\203\300*?\376\3248?\376\324"
 & "8?\203\300*?\177j\034?\002+G?\376\3248?\004V\216>\000\000\000?\203\300*"
 & "?\004V\016?}?U?\376\3248?\002+G?\203\300*?\002+G?\376\3248?\203\300*?\177"
 & "j\034?\376\3248?\203\300*?\374\251q?\203\300*?\203\300*?\177j\034?\004V"
 & "\216>\004V\216>\004V\216>\305 \360>\004V\016?\370Sc>\004V\016?\004V\016"
 & "?\000\000\000?\004V\016?\004V\016?\004V\216>\004V\016?\004V\016?\370Sc>"
 & "\370Sc>\000\000\000?\370Sc>}?U?\004V\016?\004V\016?\004V\016?\004V\016?"
 & "\372~\252>\000\000\000?\004V\216>\004V\016?\000\000\000?\376\3248?\000\000"
 & "\000?\000\000\000?\000\000\000?\f\002\253>\270\036\205>\f\002\253>\006\201"
 & "\025?\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004V\216>\372"
 & "~\252>\372~\252>\372~\252>\372~\252>\372~\252>\372~\252>\372~\252>\372~"
 & "\252>\000\000\000\000\372~\252>\372~\252>\000\000\000\000\372~\252>\372"
 & "~\252>\372~\252>\000\000\000\000\372~\252>\004V\016?\004V\016?\004V\016"
 & "?\004V\016?\270\036\205>\004V\016?\372~\252>\010\254<?\244p\275>\004V\016"
 & "?\006\201\025?\372~\252>\010\254<?\372~\252>\315\314\314>\006\201\025?\372"
 & "~\252>\372~\252>\372~\252>\004V\016?\325x\t?\004V\216>\372~\252>\372~\252"
 & ">H\341\272>\004V\016?\006\201U?\006\201U?\006\201U?\177j\034?\203\300*?"
 & "\203\300*?\203\300*?\203\300*?\203\300*?\203\300*?\000\000\200?\376\324"
 & "8?\203\300*?\203\300*?\203\300*?\203\300*?\004V\216>\004V\216>\004V\216"
 & ">\004V\216>\376\3248?\376\3248?\002+G?\002+G?\002+G?\002+G?\002+G?\006\201"
 & "\025?\002+G?\376\3248?\376\3248?\376\3248?\376\3248?\203\300*?\203\300*"
 & "?\177j\034?\004V\016?\004V\016?\004V\016?\004V\016?\004V\016?\004V\016?"
 & "\201\225c?\000\000\000?\004V\016?\004V\016?\004V\016?\004V\016?\004V\216"
 & ">\004V\216>\004V\216>\004V\216>\004V\016?\004V\016?\004V\016?\004V";

CONST E26_33 = 
   "\016?\004V\016?\004V\016?\004V\016?\006\201\025?\177j\034?\004V\016?\004"
 & "V\016?\004V\016?\004V\016?\000\000\000?\004V\016?\000\000\000?000000000"
 & "0000000000000000000000005\001\n\354Q\270=\356|?>\331\3167?\000\000\000\000"
 & "5\001\n)\\\217=\205\353\221>\331\3167?V\016\355>5\001\nB`\345<\213l\007"
 & "?\305 0?\000\000\000\0005\001\no\022\003=\270\036\005?ffF?\037\205\353\275"
 & "5\001\nw\276\037=\232\231Y?\317\3673?\343\245\233\2745\001\nX94=\270\036"
 & "%?\331\3167?\217\302u\2745\001\n\207\026Y=\234\304 >\331\3167?V\016\355"
 & ">5\001\n\226C\213=\207\026\231>\343\245;?\317\367S\2765\001\n\226C\013="
 & "\024\256\207>\343\245;?\317\367S\2765\001\nw\276\037=!\260\262>\331\316"
 & "7?\010\254\334>5\001\nw\276\037=\037\205\013?\256G\001?\000\000\000\000"
 & "5\001\n\016-\262=\201\225C>\207\026\331=+\207\026\2765\001\nw\276\037=\037"
 & "\205\013?\317\367\223>\033/]>5\001\n\016-\262=\201\225C>\207\026\331=\000"
 & "\000\000\0005\001\n\226C\213\274=\n\227>\010\254<?\343\245\233\2745\001"
 & "\nP\215\027=/\335\004?\317\3673?\343\245\233\2745\001\n\027\331\316=\331"
 & "\316\267>\317\3673?\000\000\000\0005\001\n\364\375\324<\301\312\001?\317"
 & "\3673?\000\000\000\0005\001\n\226C\013=\313\241\005?\317\3673?\343\245\233"
 & "\2745\001\n\315\314\314<T\343\005?\317\3673?\000\000\000\0005\001\no\022"
 & "\003=\201\225\003?\305 0?\343\245\233\2745\001\n\343\245\033=\246\233\004"
 & "?\317\3673?\343\245\233\2745\001\nP\215\027=T\343\005?\305 0?\000\000\000"
 & "\0005\001\n\343\245\033=\035Z\004?\317\3673?\343\245\233\2745\001\n1\010"
 & ",=\201\225\003?\317\3673?\343\245\233\2745\001\n\016-\262=\201\225C>\223"
 & "\030\004?\000\000\000\0005\001\n\016-\262=\201\225C>\223\030\004?+\207\026"
 & "\2765\001\n\246\233D=L7\t?\244p\375>X94<5\001\nw\276\037=\037\205\013?\024"
 & "\256\307>\037\205\353=5\001\n\246\233D=L7\t?\244p\375>X94<5\001\nB`e=m\347"
 & "\373>\254\034:?\000\000\000\0005\001\n+\207\026>?5^?\010\254<?\343\245\233"
 & "\2745\001\nB`e<\213l\'?\331\3167?\000\000\000\0005\001\nP\215\227=\022\203"
 & " ?\331\3167?\000\000\000\0005\001\nX94=\004V.?\010\254<?\343\245\233\274"
 & "5\001\nT\343\245=D\213,?\331\3167?\000\000\000\0005\001\n\305 \260=-\262"
 & "\035?\331\3167?\000\000\000\0005\001\n\305 \260=}?\025?\331\3167?\000\000"
 & "\000\0005\001\n\246\233D=X94?\010\254<?\343\245\233\2745\001\n-\262\235"
 & "=B`%?\331\3167?\000\000\000\0005\001\n5^\272=\022\203@>\331\3167?\000\000"
 & "\000\0005\001\n\226C\213<\321\"\333>\331\3167?\343\245\233\2745\001\n\343"
 & "\245\233=^\272)?\331\3167?\000\000\000\0005\001\n\343\245\233=\325x\t?\331"
 & "\3167?\000\000\000\0005\001\n\006\201\225=\345\320B?\331\3167?\000\000\000"
 & "\0005\001\n\343\245\233=B`%?\331\3167?\000\000\000\0005\001\nw\276\037="
 & "\033/=?\010\254<?\343\245\233\2745\001\n\305 \260=d;\037?\331\3167?\000"
 & "\000\000\0005\001\nw\276\037=\033/=?\010\254<?B`e\2755\001\nX9\264=\240"
 & "\032/?\331\3167?\000\000\000\0005\001\n9\264H=R\270\036?\010\254<?\343\245"
 & "\233\2745\001\nB`e<\376\324\030?\331\3167?\000\000\000\0005\001\n\301\312"
 & "\241=/\335$?\331\3167?\343\245\233\2745\001\n\n\327\243<\313\241%?\331\316"
 & "7?\000\000\000\0005\001\no\022\203<h\221m?\331\3167?\000\000\000\0005\001"
 & "\n\343\245\233<T\343%?\331\3167?\000\000\000\0005\001\nB`e<\002+\'?\331"
 & "\3167?\000\000\000\0005\001\n\177j\274<+\207\026?\331\3167?\000\000\000"
 & "\0005\001\n%\006\201=\000\000\200>\376\3248?9\264H\2765\001\n\226C\213\274"
 & "=\n\227>\010\254<?\343\245\233\2745\001\nB`\345<\366(\\>\376\3248?9\264"
 & "H\2765\001\nB`e\274\307K\367>\305 0?\002+\207>5\001\n\000\000\000\000\004"
 & "V\016?\232\231\231\275\000\000\000\2765\001\n\270\036\205=V\016->\232\231"
 & "9?\327\243\360>5\001\n\274t\023=\024\256\007?^\272\t?\217\302u\2745\001"
 & "\nh\221m=\035Z\004?\331\3167?\217\302u\2745\001\n\217\302\365<X9\364>^\272"
 & "\t?\217\302u\2745\001\n)\\\017=\356|\377>\331\3167?\217\302u\2745\001\n"
 & "\n\327#=\223\030\004?^\272\t?\217\302u\2745\001\nB`e<\335$\206>5^:?\000"
 & "\000\000\0005\001\n\n\327#=\356|\377>^\272\t?\256Ga\2765\001\n\270\036\205"
 & "=Zd\373>\331\3167?\000\000\000\0005\001\nL7\211=R\270\036>\331\3167?\000"
 & "\000\000\0005\001\no\022\203\274R\270\036>\331\3167?=\nW\2765\001\nL7\211"
 & "=\211A\000?\331\3167?\000\000\000\0005\001\nL7\211=R\270\036>\331\3167?"
 & "\000\000\000\0005\001\n\270\036\205=/\335D?^\272\t?\000\000\000\0005\001"
 & "\n\270\036\205=Zd\373>^\272\t?\000\000\000\0005\001\n)\\\017=B`\005?^\272"
 & "\t?B`e\2745\001\nh\221m=\035Z\004?^\272\t?\317\367S\2765\001\n)\\\017=\221"
 & "\355\374>^\272\t?\317\367S\2765\001\n-\262\235=\347\373\251>^\272\t?\000"
 & "\000\000\0005\001\no\022\003=h\221\355>^\272\t?\217\302u\2745\001\nB`e<"
 & "\201\225\203>\226C+?B`\345\2735\001\n\226C\213=5^\372>T\343\005?\217\302"
 & "u\2745\001\no\022\003<m\347\373>T\343\005?\000\000\000\0005\001\nB`e<\006"
 & "\2015?T\343\005?\000\000\000\0005\001\nX94<H\341\372>T\343\005?\000\000"
 & "\000\0005\001\nX94<5^\372>T\343\005?\321\"[\2765\001\n\266\363\375<\305"
 & " \360>T\343\005?\000\000\000\0005\001\n1\010,=\006\201\225>\376\3248?9\264"
 & "H\2765\001\n\022\203\300=\f\002+>\010\254<?\343\245\233\2745\001\n1\010"
 & ",=\006\201\225>\376\3248?9\264H\2765\001\n#\333y=T\343\005?y\351\246>\354"
 & "Q8>000000000000000005\001\n\\\217\302=Zd;>T\343\005?\000\000\000\0005\001"
 & "\nB`e<b\020X>m\347;?\331\316\027?5\001\n#\333\371=\370S\243>m\347;?\331"
 & "\316\027?5\001\n1\010\254<w\276\237>m\347;?\331\316\027?5\001\no\022\203"
 & "\273D\213\254>\376\3248?\321\"\033?5\001\n\n\327#<B`\245>\240\032/?\022"
 & "\203 ?";

CONST E26_34 = 
   "5\001\n\364\375T<\035Z\244>\321\";?\354Q\030?5\001\n\331\316\367=\207\026"
 & "Y>j\2744?\276\237\032?5\001\n\n\327#=\031\004\226>j\2744?\276\237\032?0"
 & "5\001\n\232\231\231=\246\233\204>7\211A?\230n\022?5\001\n\354Q8=\246\233"
 & "\204>\000\000\000\000fff\27605\001\n\266\363\375<sh\321>m\347;?\331\316"
 & "\027?5\001\n\006\201\225=\252\361\222>\000\000\000\000fff\2765\001\n1\010"
 & "\254<w\276\237>m\347;?\331\316\027?05\001\n\374\251\361=\366(\\>T\343\005"
 & "?\024\256G\2765\001\n`\345P=\370S\003?\356|\037?\037\205\353\2755\001\n"
 & "\002+\007=\347\373\t?\331\3167?o\022\203\2745\001\nB`\345<\002+\007?5^\032"
 & "?\203\300\312=5\001\n\246\233D;h\221\r?\305 0?\000\000\000\0005\001\n\022"
 & "\203\300=\f\002+>\010\254<?\343\245\233\2745\001\n\305 0=o\022\003?\010"
 & "\254<?\201\225C\2761N\013\000\0005\001\nB`e\274\022\203@?\010\254<?\343"
 & "\245\233\2745\001\n\246\233\304<\351&\261>\010\254<?\343\245\233>5\001\n"
 & "\360\247\306=\f\002\353>\035Z\344>\033/\335=5\001\nw\276\037=\037\205\013"
 & "?\024\256\307>\033/\335=5\001\nX94=\317\367\223>/\335\244>h\221m>5\001\n"
 & "B`e\274\022\203@?\010\254<?\343\245\233\2741K\013\000\0005\001\n\033/]="
 & "\351&\261>\317\3673?\230n\322>5\001\nw\276\037=\037\205\013?7\211\001?\000"
 & "\000\000\0005\001\no\022\203;B`\245>\317\3673?;\337\217>5\001\n\n\327\243"
 & ";ff\246>\317\3673?q=\212>1H\013\000\0005\001\n\226C\213=5^\372>T\343\005"
 & "?\317\367S\2765\001\n\274t\223<\311v\376>\331\3167?\351&1\2765\001\n-\262"
 & "\235=\027\331N>\256G\241>\\\217B>1P\013\000\0005\001\n\305 0=\370Sc>\317"
 & "\3673?;\337\217>5\001\n\315\314\314<\215\227\256>\010\254<?\343\245\233"
 & ">5\001\n\360\247\306=\f\002\353>\035Z\344>\033/\335=5\001\n\006\201\225"
 & "=7\211A?\317\3673?\343\245\233\2745\001\n\305 0=T\343E?\317\3673?\343\245"
 & "\233\2745\001\n\354Q8=)\\O?\317\3673?\343\245\233\2745\001\n5^\272=y\351"
 & "\006?ff\006?\362\322M\2765\001\nB`e<\213l\'?\362\322m?\000\000\000\0005"
 & "\001\nB`e<\213l\'?\362\322m?\000\000\000\0005\001\nB`e<\213l\'?\362\322"
 & "m?\000\000\000\0005\001\nB`e<\213l\'?\203\300j?\000\000\000\0005\001\nB"
 & "`e<\213l\'?\360\247f?\000\000\000\0005\001\nB`e<\213l\'?\004Vn?\000\000"
 & "\000\0005\001\no\022\003<\274ts?\331\3167?\000\000\000\0005\001\nX94=\004"
 & "V.?\010\254<?fff\2765\001\n\305 \260=-\262\035?\362\322m?\000\000\000\000"
 & "5\001\n\305 \260=-\262\035?\362\322m?\000\000\000\0005\001\n\305 \260=-"
 & "\262\035?\362\322m?\000\000\000\0005\001\n\305 \260=-\262\035?\360\247f"
 & "?\000\000\000\0005\001\n\364\375T\274\022\203@>\362\322m?\000\000\000\000"
 & "5\001\n5^\272=\006\201\225>\362\322m?\000\000\000\0005\001\n\246\233\304"
 & "\273\205\353\221>\362\322m?\000\000\000\0005\001\n\364\375T<\'1\210>\360"
 & "\247f?\000\000\000\0005\001\n\000\000\000\000D\213,?\331\3167?\000\000\000"
 & "\0005\001\n\343\245\233=B`%?\203\300j?\000\000\000\0005\001\nw\276\037="
 & "\033/=?\362\322m?\343\245\233\2745\001\nw\276\037=\033/=?\362\322m?\343"
 & "\245\233\2745\001\nw\276\037=\033/=?\362\322m?\343\245\233\2745\001\nw\276"
 & "\037=\033/=?\203\300j?\343\245\233\2745\001\nw\276\037=\033/=?\360\247f"
 & "?\343\245\233\2745\001\nw\276\037=\037\205\013?7\211\001?\000\000\000\000"
 & "5\001\nw\276\037=\244p=?\010\254<?\343\245\233\2745\001\n\301\312\241=/"
 & "\335$?\362\322m?\343\245\233\2745\001\n\301\312\241=/\335$?\362\322m?\343"
 & "\245\233\2745\001\n\301\312\241=/\335$?\362\322m?\343\245\233\2745\001\n"
 & "\301\312\241=/\335$?\360\247f?\343\245\233\2745\001\nB`e<\002+\'?\362\322"
 & "m?\000\000\000\0005\001\n\305 \260=d;\037?\331\3167?\000\000\000\0005\001"
 & "\nL7\211=\016-\022?5^:?\217\302u\2745\001\n\274t\023=\024\256\007?m\347"
 & ";?\217\302u\2745\001\n\274t\023=\024\256\007?m\347;?\217\302u\2745\001\n"
 & "\274t\023=\024\256\007?m\347;?\217\302u\2745\001\n\274t\023=\024\256\007"
 & "?\376\3248?\217\302u\2745\001\n\274t\023=\024\256\007?j\2744?\217\302u\274"
 & "5\001\n\274t\023=\024\256\007?7\211A?\217\302u\2745\001\n\274t\023=\376"
 & "\324X?^\272\t?\217\302u\2745\001\n\217\302\365<X9\364>^\272\t?fff\2765\001"
 & "\n\n\327#=\223\030\004?m\347;?\217\302u\2745\001\n\n\327#=\223\030\004?"
 & "m\347;?\217\302u\2745\001\n\n\327#=\223\030\004?m\347;?\217\302u\2745\001"
 & "\n\n\327#=\223\030\004?j\2744?\217\302u\2745\001\n\364\375T\274\177j<>m"
 & "\347;?\000\000\000\0005\001\n\\\217\302=\006\201\225>m\347;?\000\000\000"
 & "\0005\001\n\246\233\304\273\205\353\221>m\347;?\000\000\000\0005\001\n\364"
 & "\375T<\'1\210>j\2744?\000\000\000\0005\001\n)\\\017=\313\241\005?\010\254"
 & "<?\217\302u\2745\001\n\270\036\205=Zd\373>\376\3248?\000\000\000\0005\001"
 & "\n)\\\017=B`\005?m\347;?B`e\2745\001\n)\\\017=B`\005?m\347;?B`e\2745\001"
 & "\n)\\\017=B`\005?m\347;?B`e\2745\001\n)\\\017=B`\005?\376\3248?B`e\2745"
 & "\001\n)\\\017=B`\005?j\2744?B`e\2745\001\nw\276\037=\037\205\013?\335$\006"
 & "?\343\245\233\2745\001\nB`\345<\325x\t?\037\205\013?X9\264\2745\001\n\226"
 & "C\213=5^\372>m\347;?\217\302u\2745\001\n\226C\213=5^\372>m\347;?\217\302"
 & "u\2745\001\n\226C\213=5^\372>m\347;?\217\302u\2745\001\n\226C\213=5^\372"
 & ">j\2744?\217\302u\2745\001\nX94<5^\372>m\347;?\321\"[\2765\001\nh\221m="
 & "\035Z\004?\331\3167?\317\367S\2765\001\nX94<5^\372>j\2744?\321\"[\27600"
 & "0005\001\0051\212\000\000\0005\001\t1\010,\276\000\000\200?T\343e?d;_\276"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001";

CONST E26_35 = 
   "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\001\001\001\001\001\001\001\001\001\000"
 & "\001\001\000\001\001\001\000\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001\001"
 & "\001\001\001\001\001\001\001\001\001\001\001\001\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\200>\372"
 & "~\252>`\345\320>\000\000\000?\000\000\000?}?U?\002+G?\372~\252>\372~\252"
 & ">\372~\252>\000\000\000?Nb\020?\000\000\200>Nb\020?\000\000\200>\004V\216"
 & ">\000\000\000?\000\000\000?\000\000\000?\000\000\000?\000\000\000?\000\000"
 & "\000?\000\000\000?\000\000\000?\000\000\000?\000\000\000?\004V\216>\004"
 & "V\216>Nb\020?Nb\020?Nb\020?\370S\343>\250\306k?\376\3248?\203\300*?\203"
 & "\300*?\376\3248?\177j\034?\004V\016?\376\3248?\376\3248?\372~\252>\002+"
 & "\307>\376\3248?\177j\034?\201\225c?\376\3248?\376\3248?\004V\016?\376\324"
 & "8?\203\300*?\004V\016?\177j\034?\376\3248?\376\3248?\374\251q?\376\3248"
 & "?\376\3248?\177j\034?\372~\252>\004V\216>\372~\252>\305 \360>\000\000\000"
 & "?\372~\252>\370S\343>\000\000\000?\370S\343>\000\000\000?\370S\343>\372"
 & "~\252>\000\000\000?\000\000\000?\004V\216>\004V\216>\000\000\000?\004V\216"
 & ">\002+G?\000\000\000?\000\000\000?\000\000\000?\000\000\000?\372~\252>\002"
 & "+\307>\004V\216>\000\000\000?\000\000\000?\376\3248?\000\000\000?\000\000"
 & "\000?\370S\343>\217\302\365>\315\314L>\217\302\365>\372~\n?\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\004V\216>\372~\252>\372~\252"
 & ">\372~\252>\372~\252>\372~\252>\372~\252>\372~\252>\372~\252>\000\000\000"
 & "\000\372~\252>\372~\252>\000\000\000\000\372~\252>\372~\252>\372~\252>\000"
 & "\000\000\000\372~\252>\000\000\000?\000\000\000?\000\000\000?\000\000\000"
 & "?\315\314L>\000\000\000?\372~\252>\\\217B?\337O\215>\000\000\000?Nb\020"
 & "?\372~\252>\\\217B?\372~\252>\315\314\314>Nb\020?\232\231\231>\232\231\231"
 & ">\372~\252>\000\000\000?\236\357\347>\000\000\200>\372~\252>\232\231\231"
 & ">R\270\236>\000\000\000?\000\000@?\000\000@?\000\000@?\370S\343>\376\324"
 & "8?\376\3248?\376\3248?\376\3248?\376\3248?\376\3248?\201\225c?\203\300*"
 & "?\177j\034?\177j\034?\177j\034?\177j\034?\372~\252>\372~\252>\372~\252>"
 & "\372~\252>\376\3248?\376\3248?\376\3248?\376\3248?\376\3248?\376\3248?\376"
 & "\3248?Nb\020?\376\3248?\376\3248?\376\3248?\376\3248?\376\3248?\376\324"
 & "8?\004V\016?\000\000\000?\370S\343>\370S\343>\370S\343>\370S\343>\370S\343"
 & ">\370S\343>\203\300*?\370S\343>\370S\343>\370S\343>\370S\343>\370S\343>"
 & "\004V\216>\004V\216>\004V\216>\004V\216>\000\000\000?\000\000\000?\000\000"
 & "\000?\000\000\000?\000\000\000?\000\000\000?\000\000\000?Nb\020?\000\000"
 & "\000?\000\000\000?\000\000\000?\000\000\000?\000\000\000?\000\000\000?\000"
 & "\000\000?\000\000\000?0000000000000000000000000000000005\001\n\270\036\005"
 & ">F\266s>V\016-?\274t\023\2745\001\n-\262\235=\325x\251>V\016-?\010\254\334"
 & ">5\001\n\n\327\243;\266\363\375>\325x)?\000\000\000\0005\001\nX94=\347\373"
 & "\351>\254\034:?\016-\262\2755\001\n#\333y=\313\241E?V\016-?\364\375T\274"
 & "5\001\n1\010,=\000\000@?V\016-?\364\375T\2745\001\n\301\312\241=d;_>V\016"
 & "-?-\262\335>5\001\n\246\233D=\343\245\233>V\016-?}?5\2765\001\nh\221\355"
 & "<\205\353\221>V\016-?}?5\2765\001\n\337O\215=\033/\335>V\016-?\024\256\207"
 & ">5\001\n\217\302\365<9\264\010?7\211\001?\000\000\000\0005\001\nB`e=\024"
 & "\256G>`\345\320=Nb\020\2765\001\n\217\302\365<9\264\010?\230n\222>\256G"
 & "a>5\001\n)\\\217=\020X9>\315\314\314=X94\2745\001\n\274t\023\274\252\361"
 & "\222>V\016-?B`e\2745\001\n\246\233\304<F\266\363>V\016-?B`e\2745\001\n\370"
 & "S\343=^\272\311>V\016-?\000\000\000\0005\001\n\217\302\365<33\363>V\016"
 & "-?\000\000\000\0005\001\n\305 0=\010\254\334>V\016-?B`e\2745\001\n\246\233"
 & "D<\374\251\361>V\016-?\000\000\000\0005\001\no\022\003=\211A\340>\305 0"
 & "?B`e\2745\001\n\226C\013=\262\235\357>\240\032/?B`e\2745\001\n\n\327\243"
 & "<T\343\345>\325x)?o\022\003\2745\001\nB`e=\n\327\343>V\016-?B`e\2745\001"
 & "\n\217\302\365<\f\002\353>V\016-?X9\264\2745\001\nT\343\245=\246\233D>\f"
 & "\002\353>X94\2745\001\n\n\327\243=\211A`>\f\002\353>Nb\020\2765\001\nB`"
 & "\345<L7\t?\201\225\003?o\022\003\2745\001\n\217\302\365<9\264\010?\313\241"
 & "\305>\217\302\365=5\001\nB`\345<L7\t?\201\225\003?o\022\003\2745\001\n\226"
 & "C\213=\317\367\323>V\016-?o\022\003\2745\001\nh\221\355=\240\032O?V\016"
 & "-?B`e\2745\001\n\217\302u<j\2744?D\213,?\000\000\000\0005\001\n\226C\213"
 & "<\331\316\027?\325x)?\000\000\000\0005\001\nB`\345<J\f\"?V\016-?B`e\274"
 & "5\001\no\022\203<)\\/?\325x)?\000\000\000\0005\001\n\246\233D<\376\324\030"
 & "?\325x)?\000\000\000\0005\001\n\246\233D<\250\306\013?\325x)?\000\000\000"
 & "\0005\001\no\022\003=\006\2015?V\016-?B`e\2745\001\n\343\245\233<F\2663";

CONST E26_36 = 
   "?\325x)?\000\000\000\0005\001\n\274t\223<\256G\241>\325x)?\000\000\000\000"
 & "5\001\n\n\327#<\244p\275>\325x)?B`e\2745\001\n\226C\013=\207\0269?\325x"
 & ")?\000\000\000\0005\001\n\246\233D<\207\026\031?\325x)?\000\000\000\000"
 & "5\001\n\246\233D<\221\355\\?\325x)?\000\000\000\0005\001\n\246\233D<\364"
 & "\3754?\325x)?X94\2745\001\n\226C\013=\305 0?V\016-?B`e\2745\001\no\022\203"
 & "<\203\300\n?\325x)?\000\000\000\0005\001\n\226C\013=\274t3?V\016-?\242E"
 & "6\2765\001\n\226C\213<9\264(?\325x)?\000\000\000\0005\001\n1\010,=Zd\373"
 & ">V\016-?B`e\2745\001\n\226C\213<\331\316\027?\325x)?\000\000\000\0005\001"
 & "\nB`e<\341z4?\325x)?B`e\2745\001\no\022\203<\230n2?\325x)?X94\2745\001\n"
 & "\n\327\243;\215\227n?\325x)?X94\2745\001\n\n\327#<X94?\325x)?\000\000\000"
 & "\0005\001\nX9\264<\317\3673?\325x)?\000\000\000\0005\001\n\274t\023<\376"
 & "\324\030?\325x)?\000\000\000\0005\001\nX9\264=\207\026\231>\325x)?w\276"
 & "\037\2765\001\n\274t\023\274\252\361\222>V\016-?B`e\2745\001\n\226C\013"
 & "=H\341z>\325x)?w\276\037\2765\001\n\246\233\304<\035Z\344>\325x)?b\020\230"
 & ">5\001\n\000\000\000\000\000\000\000?\232\231\231\275\000\000\000\2765\001"
 & "\n\037\205\353=J\f\202>V\016-?-\262\335>5\001\nP\215\027=\323M\342>\037"
 & "\205\353>\n\327#\2745\001\n\246\233D;\262\235\357>\027\331.?\n\327#\274"
 & "5\001\n\315\314\314<\252\361\322>\037\205\353>\n\327#\2745\001\n\033/\335"
 & "<Zd\373>\027\331.?\n\327#\2745\001\n\315\314\314<\207\026\331>\037\205\353"
 & ">\n\327#\2745\001\n\n\327\243<\223\030\304>\027\331.?\000\000\000\0005\001"
 & "\nB`\345<\327\243\360>\037\205\353>d;_\2765\001\n\274t\023<\020X\371>\027"
 & "\331.?\000\000\000\0005\001\no\022\203<7\211\201>\027\331.?\000\000\000"
 & "\0005\001\n)\\\217\275\360\247F>\027\331.?d;_\2765\001\nB`\345;\256G\001"
 & "?\027\331.?\000\000\000\0005\001\n\343\245\233<\201\225\203>\027\331.?\000"
 & "\000\000\0005\001\no\022\203<ffF?\037\205\353>\000\000\000\0005\001\no\022"
 & "\203<\354Q\370>\037\205\353>\000\000\000\0005\001\nh\221\355<\327\243\360"
 & ">\037\205\353>\n\327#\2745\001\n\n\327\243;\327\243\360>\037\205\353>?5"
 & "^\2765\001\n\246\233\304<#\333\371>\037\205\353>?5^\2765\001\n\n\327\243"
 & ";\037\205\253>\037\205\353>\000\000\000\0005\001\n`\345P=\016-\262>\037"
 & "\205\353>\n\327#\2745\001\n\364\375T<\027\331\216>X9\024?\n\327#\2745\001"
 & "\n\274t\023<}?\365>ff\346>\n\327#\2745\001\n\343\245\233<X9\364>ff\346>"
 & "B`e\2745\001\n1\010\254<\374\2511?ff\346>B`e\2745\001\n\226C\213<}?\365"
 & ">ff\346>\000\000\000\0005\001\nB`e<33\363>ff\346>d;_\2765\001\n\033/\335"
 & "<\031\004\326>ff\346>\000\000\000\0005\001\n\315\314\314=33\263>{\024.?"
 & "\020X9\2765\001\nL7\211=\'1\010>V\016-?B`e\2745\001\n\270\036\005>\\\217"
 & "\302>{\024.?\020X9\2765\001\n\n\327#=\022\203\000?B`\245>Zd;>0000000000"
 & "00000005\001\no\022\203<7\211\201>\037\205\353>\000\000\000\0005\001\n\343"
 & "\245\233<\331\316w>h\221-?\301\312\001?5\001\n\311v\276=\323M\242>h\221"
 & "-?\301\312\001?5\001\nX94</\335\244>D\213,?\301\312\001?5\001\no\022\203"
 & ":\325x\251>\370S#?\'1\010?5\001\nX94</\335\244>#\333\031?1\010\f?5\001\n"
 & "\364\375\324<\033/\235>\347\373)?\301\312\001?5\001\n\374\251\361=\033/"
 & "]>\356|\037?T\343\005?5\001\n\274t\223<\256G\241>\356|\037?T\343\005?05"
 & "\001\nL7\211=\'1\210>\031\0046?o\022\003?5\001\n\364\375T=\313\241\205>"
 & "\000\000\000\000\366(\\\27605\001\n\246\233D\273%\006\301>h\221-?\301\312"
 & "\001?5\001\no\022\203=\333\371~>\000\000\000\000\303\365(\2765\001\nX94"
 & "</\335\244>D\213,?\301\312\001?05\001\n\360\247\306=\205\353Q>\240\032\357"
 & ">d;_\2765\001\n\207\026Y=B`\345>X9\024?\337O\r\2765\001\n\246\233D<H\341"
 & "\372>V\016-?o\022\003\2745\001\nX9\264\274\313\241\005?\254\034\032?h\221"
 & "m=5\001\n\207\026Y\275o\022\003?\325x)?\000\000\000\0005\001\nL7\211=\'"
 & "1\010>V\016-?B`e\2745\001\n)\\\217=\254\034\332>V\016-?P\215\027\2761\027"
 & "\f\000\0005\001\n\343\245\033=\376\3248?V\016-?B`e\2745\001\no\022\203;"
 & "q=\212>V\016-?^\272\311>5\001\n1\010,=\325x\351>\364\375\324>\002+\007="
 & "5\001\n\217\302\365<9\264\010?\313\241\305>\033/\335=5\001\nw\276\037=\205"
 & "\353\221>\201\225\203>\360\247F>5\001\n\343\245\033=\376\3248?V\016-?B`"
 & "e\2741\024\f\000\0005\001\n\325xi=\262\235\257>V\016-?\024\256\307>5\001"
 & "\n\217\302\365<9\264\010?7\211\001?\000\000\000\0005\001\no\022\203:P\215"
 & "\227>V\016-?q=\212>5\001\n\217\302u<\364\375\224>V\016-?\335$\206>1\021"
 & "\f\000\0005\001\n\274t\023=o\022\003?ff\346>d;_\2765\001\nX9\264\274ff\346"
 & ">\325x)?-\262\035\2765\001\n)\\\217=\020X9>R\270\236>\250\306K>1\031\f\000"
 & "\0005\001\n\325xi=\266\363}>V\016-?q=\212>5\001\n\246\233\304;\343\245\233"
 & ">V\016-?^\272\311>5\001\nX94=\372~\352>\364\375\324>\002+\007=5\001\nP\215"
 & "\027=\331\3167?V\016-?B`e\2745\001\n\266\363\375<\333\371>?V\016-?B`e\274"
 & "5\001\n\217\302u<\331\3167?V\016-?B`e\2745\001\n\217\302\365<\022\203\300"
 & ">\215\227\356>d;_\2765\001\n\217\302u<j\2744?\n\327c?\000\000\000\0005\001"
 & "\n\217\302u<j\2744?\n\327c?\000\000\000\0005\001\n\217\302u<j\2744?\345"
 & "\320b?\000\000\000\0005\001\n\217\302u<j\2744?\232\231Y?\000\000\000\000"
 & "5\001\n\217\302u<j\2744?\217\302U?\000\000\000\0005\001\n\217\302u<j\274"
 & "4?T\343e?\000\000\000\0005\001\n\000\000\000\000\221\355\\?\325x)?\000\000"
 & "\000\0005\001\nB`\345<J\f\"?V\016";

CONST E26_37 = 
   "-?\366(\\\2765\001\n\246\233D<\376\324\030?\n\327c?\000\000\000\0005\001"
 & "\n\246\233D<\376\324\030?\n\327c?\000\000\000\0005\001\n\246\233D<\376\324"
 & "\030?\345\320b?\000\000\000\0005\001\n\246\233D<\376\324\030?\217\302U?"
 & "\000\000\000\0005\001\n\274t\223<\256G\241>\n\327c?\000\000\000\0005\001"
 & "\n\274t\223<\323M\242>\n\327c?\000\000\000\0005\001\nX94</\335\244>\345"
 & "\320b?\000\000\000\0005\001\n\274t\223<\256G\241>\217\302U?\000\000\000"
 & "\0005\001\no\022\203<)\\/?\325x)?\000\000\000\0005\001\n\246\233D<\364\375"
 & "4?\232\231Y?X94\2745\001\n\226C\013=\305 0?\n\327c?B`e\2745\001\n\226C\013"
 & "=\305 0?\n\327c?B`e\2745\001\n\226C\013=\305 0?\345\320b?B`e\2745\001\n"
 & "\226C\013=\305 0?\232\231Y?B`e\2745\001\n\226C\013=\305 0?\217\302U?B`e"
 & "\2745\001\n\343\245\033=y\351\006?\311v\376>o\022\003<5\001\n\226C\013="
 & "\305 0?m\347;?\n\327\243\2755\001\nB`e<\341z4?\n\327c?B`e\2745\001\nB`e"
 & "<\341z4?\n\327c?B`e\2745\001\nB`e<\341z4?\345\320b?B`e\2745\001\nB`e<\341"
 & "z4?\217\302U?B`e\2745\001\nX9\264<\317\3673?\n\327c?\000\000\000\0005\001"
 & "\no\022\203<\203\300\n?\325x)?\000\000\000\0005\001\n\246\233D<\262\235"
 & "\357>\027\331.?\274t\023\2745\001\nP\215\027=\323M\342>h\221-?\n\327#\274"
 & "5\001\nP\215\027=\323M\342>h\221-?\n\327#\2745\001\nP\215\027=\323M\342"
 & ">D\213,?\n\327#\2745\001\nP\215\027=\323M\342>\370S#?\n\327#\2745\001\n"
 & "P\215\027=\323M\342>\356|\037?\n\327#\2745\001\nP\215\027=\323M\342>\031"
 & "\0046?\n\327#\2745\001\n\343\245\033=\301\312!?\037\205\353>\n\327#\274"
 & "5\001\n\315\314\314<\252\361\322>\037\205\353>\366(\\\2765\001\n\315\314"
 & "\314<\207\026\331>h\221-?\n\327#\2745\001\n\315\314\314<\207\026\331>h\221"
 & "-?\n\327#\2745\001\n\315\314\314<\207\026\331>D\213,?\n\327#\2745\001\n"
 & "\315\314\314<\207\026\331>\356|\037?\n\327#\2745\001\no\022\003\2747\211"
 & "\201>h\221-?\000\000\000\0005\001\no\022\203<\341z\224>h\221-?\000\000\000"
 & "\0005\001\no\022\203\274=\n\227>D\213,?\000\000\000\0005\001\n\274t\023"
 & "\274\274t\223>\356|\037?\000\000\000\0005\001\nh\221\355<\351&\361>\262"
 & "\235/?\n\327#\2745\001\no\022\203<\354Q\370>\370S#?\000\000\000\0005\001"
 & "\nh\221\355<\327\243\360>h\221-?\n\327#\2745\001\nh\221\355<\327\243\360"
 & ">h\221-?\n\327#\2745\001\nh\221\355<\327\243\360>D\213,?\n\327#\2745\001"
 & "\nh\221\355<\327\243\360>\370S#?\n\327#\2745\001\nh\221\355<\327\243\360"
 & ">\356|\037?\n\327#\2745\001\n\217\302\365<9\264\010?\223\030\004?\n\327"
 & "#\2745\001\nh\221\355<\327\243\360>V\016\r?B`\345\2755\001\n\274t\023<}"
 & "?\365>h\221-?\n\327#\2745\001\n\274t\023<}?\365>h\221-?\n\327#\2745\001"
 & "\n\274t\023<}?\365>D\213,?\n\327#\2745\001\n\274t\023<}?\365>\356|\037?"
 & "\n\327#\2745\001\nB`e<33\363>h\221-?d;_\2765\001\n\n\327\243;\327\243\360"
 & ">\027\331.??5^\2765\001\nB`e<33\363>\356|\037?d;_\27600000\005\000\000\000"
 & "\030\000\000\000\006\000\000\000\r\000\000\0004\n";

CONST E27 = 
   "MODULE Outline;\n\nIMPORT Offset, Text, PS, R2, Circle, Show, TextList,"
 & " Type;\n\nIMPORT TypeLinesC, TypeLinesL, TypeLinesR;\n\nPRIVATE VAR nor"
 & "th, south, east, west;\n\n(* This module maintains a \"current bounding"
 & " box\", which other \n   procedures in the module use to locate the par"
 & "ts of the \n   outline. The bounding box is set by the \"Start\" proced"
 & "ure \n   below. *)\n\n/* These four numerc variables determine the curr"
 & "ent bounding box \n   for the outline. */\n\nCONST TopMDefault = 30, Le"
 & "ftMDefault = 20;\n\nPRIVATE VAR TopM := TopMDefault, LeftM := LeftMDefa"
 & "ult;\n\n(* This module maintains a top and left margin, which specify h"
 & "ow \n   much below and to the right of the northwest corner of the \n  "
 & " bounding box the current point should be positioned at the \n   start "
 & "of each outline. *)\n\nPROC SetTopM(val) IS TopM := val END;\n\nPROC Se"
 & "tLeftM(val) IS LeftM := val END;\n\nUI SetTool(SetTopM);\n\nUI SetTool("
 & "SetLeftM);\n\n(* Set the current top/left margin to \"val\". *)\n\nUI P"
 & "aram(SetTopM, TopMDefault);\n\nUI Param(SetTopM, 0);\n\nUI Param(SetTop"
 & "M, 15);\n\nUI Param(SetTopM, 30);\n\nUI Param(SetTopM, 45);\n\nUI Param"
 & "(SetLeftM, LeftMDefault);\n\nUI Param(SetLeftM, 0);\n\nUI Param(SetLeft"
 & "M, 10);\n\nUI Param(SetLeftM, 20);\n\nUI Param(SetLeftM, 30);\n\nPRIVAT"
 & "E CONST LeftMargin = 15;\n\nPROC Start(corner1, corner2) IS \n  IF \n  "
 & "  VAR x1, y1, x2, y2 IN \n      corner1 = (x1, y1) AND corner2 = (x2, y"
 & "2) -> \n        north := MAX(y1, y2); \n        south := MIN(y1, y2); \n"
 & "        east := MAX(x1, x2); \n        west := MIN(x1, x2); \n        P"
 & "S.MoveTo((west + LeftM, north - TopM)) \n    END \n  FI \nEND;\n\nUI Po"
 & "intTool(Start);\n\n(* Set the current bounding box so \"corner1\" and \""
 & "corner2\" are its \n   opposite corners and set the current point accor"
 & "ding to the \n   current top and left margin values. This procedure mus"
 & "t be \n   called before any calls to the other procedures in this modul"
 & "e. \n*)\n\nPROC Center(txt) IS \n  VAR w, h, pt IN \n    w, h := TextLi"
 & "st.Size(TextList.FromText(txt)); \n    pt := PS.CurrentPoint(); \n    T"
 & "ypeLinesC.North(((west + east) ";

CONST E27_0 = 
   "/ 2, CDR(pt)), txt); \n    PS.MoveTo(R2.Plus(pt, (0, -h))) \n  END \nEN"
 & "D;\n\nUI TextTool(Center);\n\n(* Center \"txt\" horzontally in the curr"
 & "ent bounding box so its \n   north edge is horizontal with the current "
 & "point, and advance \n   the current point down by the height of the tex"
 & "t. The text is \n   rendered in the current font face and size. If \"tx"
 & "t\" contains \n   \"\\n\" characters, the lines are typeset as a block."
 & " *)\n\nPROC SkipTo(p) IS \n  VAR curr IN \n    curr := PS.CurrentPoint("
 & "); PS.MoveTo((CAR(curr), CDR(p))) \n  END \nEND;\n\nUI PointTool(SkipTo"
 & ");\n\n(* Set the current point to the point horizontal with \"p\" and \n"
 & "   vertical with the current point. *)\n\nVAR InterpointSkip := (1.1, 0"
 & ");\n\nVAR IntersubpointSkip := (0.3, 0);\n\n(* If the InterpointSkip is"
 & " \"(k, d)\", then the gap before each new \n   outermost item will be k"
 & "*fs+d, where fs is the font point size. \n   The IntersubpointSkip is i"
 & "nterpreted similarly, but applies \n   after subpoints (of any level). "
 & "*)\n\nPRIVATE CONST TabChar = Text.GetChar(\"\\t\", 0);\n\n/* TabChar ="
 & " \'\\t\'. It is the character that users type to indent \n   subitems o"
 & "f the outline. */\n\nPRIVATE CONST TabRatio = 1;\n\n/* TabRatio is the "
 & "ratio between the pointsize of the font and the \n   amount by which su"
 & "bpoints are indented. */\n\nPRIVATE PROC (i, dx, dy):ProcessIndent(txt)"
 & " IS \n  VAR lineskip = InterpointSkip IN \n    DO \n      i < Text.Leng"
 & "th(txt) AND Text.GetChar(txt, i) = TabChar -> \n        dx := dx + PS.G"
 & "etFontPtSize() * TabRatio; \n        i := i + 1; \n        lineskip := "
 & "IntersubpointSkip \n    OD; \n    dy := dy - (PS.GetFontPtSize() * CAR("
 & "lineskip) + CDR(lineskip)) \n  END \nEND;\n\nPRIVATE CONST BulletChar ="
 & " Text.GetChar(\"*\", 0);\n\n/* \"BulletChar\" is the character typed to"
 & " get a bullet on a point. \n   If the next character is \'o\', the resu"
 & "lt will be a black \n   circle. If the next character is \'-\', the res"
 & "ult will be an em \n   dash. Otherwise the next character will be the b"
 & "ullet. */\n\nPRIVATE PROC i:ProcessBullet(txt, dx, dy) IS \n  IF \n    "
 & "i + 1 < Text.Length(txt) AND ";

CONST E27_1 = 
   "Text.GetChar(txt, i) = BulletChar -> \n      DrawBullet(Text.GetChar(tx"
 & "t, i + 1), dx, dy); i := i + 2 \n  | SKIP \n  FI \nEND;\n\nPRIVATE CONS"
 & "T DotChar = 183, DashChar = Text.GetChar(\"_\", 0);\n\nPRIVATE PROC Dra"
 & "wBullet(ch, dx, dy) IS \n  VAR bullet, yfudge, p, w IN \n    IF \n     "
 & " ch = Text.GetChar(\"o\", 0) -> bullet := DotChar; yfudge := 0 \n    | "
 & "ch = Text.GetChar(\"-\", 0) -> \n        bullet := DashChar; yfudge := "
 & "0.45 * PS.GetFontPtSize() \n    | bullet := ch; yfudge := 0 \n    FI; \n"
 & "    p := PS.CurrentPoint(); \n    w := PS.StringWidth(\" \"); \n    p :"
 & "= R2.Plus(p, (dx - w, dy + yfudge)); \n    DrawDot(p, bullet) \n  END \n"
 & "END;\n\nPRIVATE PROC DrawDot(p, ch) IS \n  IF \n    ch = DotChar -> \n "
 & "     VAR asc, dec, w IN \n        asc, dec := PS.FontHeight(); \n      "
 & "  w := PS.StringWidth(\"i\"); \n        FilledCirc(R2.Minus(p, (w / 2, "
 & "0.65 * asc)), asc / 8) \n      END | TypeLinesR.NE(p, Text.FromChar(ch)"
 & ") \n  FI \nEND;\n\nPRIVATE PROC FilledCirc(p, rad) IS \n  SAVE PS IN Ci"
 & "rcle.Draw(p, R2.Plus(p, (rad, 0))); PS.Fill() END \nEND;\n\nPRIVATE PRO"
 & "C (i, dx, dy):ProcessBody(txt) IS \n  VAR suffix IN \n    suffix := Tex"
 & "t.Sub(txt, i, 9999); \n    TypeLinesL.NW(R2.Plus(PS.CurrentPoint(), (dx"
 & ", dy)), suffix); \n    VAR width, height IN \n      width, height := Te"
 & "xtList.Size(TextList.FromText(suffix)); \n      dy := dy - height \n   "
 & " END \n  END \nEND;\n\nPROC Item(txt) IS \n  SAVE Offset IN \n    Offse"
 & "t.SetHorVer(0, 0); \n    VAR i = 0, dx = 0, dy = 0 IN \n      (i, dx, d"
 & "y):ProcessIndent(txt); \n      (i):ProcessBullet(txt, dx, dy); \n      "
 & "(i, dx, dy):ProcessBody(txt); \n      PS.MoveTo(R2.Plus(PS.CurrentPoint"
 & "(), (0, dy)))\n    END \n  END \nEND;\n\nUI TextTool(Item);\n\n(* Displ"
 & "ay \"txt\" as an item or sub-item. If \"txt\" begins with a \n   tab (\""
 & "\\t\") character, then the remaining characters are \n   displayed as a"
 & " sub-item. Otherwise, all of \"txt\" is displayed \n   as an item. \n\n"
 & "   If \"txt\" is displayed as an item, the current point is first \n   "
 & "moved down according to the current value of \"InterpointSkip\". \n   T"
 & "he item is then processed as de";

CONST E27_2 = 
   "scribed below. \n\n   If \"txt\" is displayed as a sub-item, then the c"
 & "urrent point is \n   first moved down according to the current value of"
 & " \n   \"IntersubpointSkip\". The sub-item is then processed as \n   des"
 & "cribed below, but indented by a fixed amount. \n\n   If the leading cha"
 & "racter of an item or sub-item is an asterisk \n   (\"*\"), then the ite"
 & "m or sub-item will be bulleted. The next \n   character determines the "
 & "kind of bullet: if it is a small oh \n   (\"o\"), the bullet is a fille"
 & "d round dot; if it is a dash (\"-\"), \n   the bullet is a dash; if it "
 & "is any other character, that \n   character serves as the bullet. The b"
 & "ullet is outdented to the \n   left, so that the left edges of bulleted"
 & " and unbulleted items \n   will be aligned. \n\n   Within an item, newl"
 & "ine (\"\\n\") characters cause line breaks. \n   Each new line is left-"
 & "justified with the text of the first line \n   of the item. *)\n\nPRIVA"
 & "TE PROC (i, dx, dy):ProcessBodyCL(txt, cl) IS \n  VAR suffix IN \n    s"
 & "uffix := Text.Sub(txt, i, 9999); \n    SAVE PS IN\n      VAR asc, dec I"
 & "N\n        asc, dec := PS.FontHeight();\n        PS.MoveTo(R2.Plus(PS.C"
 & "urrentPoint(), (dx, dy-asc)))\n      END; \n      Show.L(suffix); \n   "
 & "   APPLY(cl) \n    END; \n    VAR width, height IN \n      width, heigh"
 & "t := TextList.Size(TextList.FromText(suffix)); \n      dy := dy - heigh"
 & "t \n    END \n  END \nEND;\n\nPROC ItemCL(txt, cl) IS \n  SAVE Offset I"
 & "N \n    Offset.SetHorVer(0, 0); \n    VAR i = 0, dx = 0, dy = 0 IN \n  "
 & "    (i, dx, dy):ProcessIndent(txt); \n      (i):ProcessBullet(txt, dx, "
 & "dy); \n      (i, dx, dy):ProcessBodyCL(txt, cl); \n      PS.MoveTo(R2.P"
 & "lus(PS.CurrentPoint(), (0, dy)))\n    END \n  END \nEND;\n\n(* Like \"I"
 & "tem\" above, but newlines are not recognized in \"txt\", \n   and after"
 & " \"txt\" is rendered, \"cl\" is applied with the current \n   point set"
 & " just after the rendered \"txt\". *)\n\n";

CONST E28 = 
   "P6\n# CREATOR: XV Version 3.10  Rev: 12/16/94\n275 86\n255\n\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000";

CONST E28_0 = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377";

CONST E28_1 = 
   "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377";

CONST E28_2 = 
   "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000";

CONST E28_3 = 
   "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377";

CONST E28_4 = 
   "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377";

CONST E28_5 = 
   "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U";

CONST E28_6 = 
   "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377";

CONST E28_7 = 
   "U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\377\377U\377\377\000\377\377U\377\377U"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\000\000\377\000\000\377\000\000\377\000\000\377\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377";

CONST E28_8 = 
   "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\000\000\377"
 & "\000\000\377\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377"
 & "U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\000\000\377\000\000\377\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\377\377\000\377\377\000\377\377U\377\377U\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\000\000\377\000\000\377\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\000\000\377\000\000\377\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\377\377\000\377\377U\377\377U\377\377U"
 & "\377\377\000\377\377U\377\377U\377\377U\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\377\377U\377\377\000\377\377U\377\377U"
 & "\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377";

CONST E28_9 = 
   "\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\000\000\377\377\000\377\377U\377\377\000\377\377U"
 & "\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\000\000\377\000\000\377\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\000\000\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\000\000\377\000\000"
 & "\377\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377\000\377\377U\377\377\000\377\377U"
 & "\377\377\000\377\000\000\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\000\000\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\000\000\377\000\000"
 & "\377\000\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\000\000\377"
 & "\000\000\377\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\000\000\377\000\000\377\000\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\377\377U\377\377\000\377\377\000\377\377U\377\377U"
 & "\377\377\000\377\377\000\377\377U\000\000\377\000\000\377\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377\000\377\377\000\377\377U\377\000\000\377\000\000"
 & "\377\000\000\377\377U\377\377U\377\377\000\377\377\000\377\377\000\377\377"
 & "U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\000\000\377\000\000\377\000\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377\000\377\377\000\377\377U\377\377U"
 & "\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377"
 & "U\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\377\377U\377\377U\377\377\000\377\377U"
 & "\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\000\000\377\000\000"
 & "\377\000\000\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\000\000\377\000\000\377\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377U\377\377\000\377\000\000\377\000\000\377"
 & "\000\000\377\377\000\377\377U\377\377U\377\377U\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\000\000\377\000\000\377\377\377U\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\000\000\377\000\000\377\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377U\377\377U\377\377U\377\377\000\377\000\000\377\000\000"
 & "\377\000\000\377\377";

CONST E28_10 = 
   "\000\377\377U\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377U\377\377\000\377\000\000\377\000\000\377\000\000"
 & "\377\377\000\377\377U\377\377U\377\377U\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\000\000\377\000\000\377\377\377\000\377\377U"
 & "\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\377\000\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\000\000\377\000\000\377\377\377U\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\000\000\377\000\000\377\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\377\000\377\377U\377\377\000\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377\000\377\377U\377\377\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\377\000\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\377\377U\377\377U\377\377\000\377\377\000\377\377"
 & "U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\000\000\377\000\000\377\377\377\000\377\377U\377\377U"
 & "\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\377\000\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\000\000\377\000\000\377\377\377U\377\377U\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\377\377\000\377\377\000\377\377U\377\377U\377\377\000\000\000\377\000"
 & "\000\377\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377U\377\377U\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\377\000\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377"
 & "U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377"
 & "\377\000\377\377U\377\377U\377";

CONST E28_11 = 
   "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\000\000\377\000\000"
 & "\377\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377U\377\377\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\000\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\000\000\377\000\000\377\377\377\000"
 & "\377\377U\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\000\000\377\000\000\377\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\377\000\377\377U\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377U"
 & "\377\377\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\000\000\377\000\000\377\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\000\000\377\000\000\377\377\377U\377"
 & "\377\000\377\377U\377\377\000\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\377\377\000\377\377U\377\377\000"
 & "\377\377U\000\000\377\000\000\377\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\377U\377\377\000\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377\000\377\377U\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\000\000\377\000\000\377\000\000\377"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\000\000\377\000\000\377\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377U\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\377\000\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U";

CONST E28_12 = 
   "\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\000\000"
 & "\377\000\000\377\377\377\000\377\377\000\377\377U\377\377U\377\377\000\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\377\377\000\377\377\000\377\377U\000\000\377\000\000\377\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377U\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\377\000\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\000\000\377\000\000\377\000\000\377\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\000\000\377\000\000\377\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\000\000\377\000\000\377\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\377\377U\377\377\000\000\000\377\000\000\377\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\000\000\377\000\000\377\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\000\000\377\000\000\377\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\000\000\377\000\000\377\377\377U\377\377\000\377\377U"
 & "\377\377\000\377\377U\377\377\000\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\000\000"
 & "\377\000\000\377\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\000\000\377\000\000\377\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377";

CONST E28_13 = 
   "U\377\377\000\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377"
 & "U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\377\377U\377\377\000\377\377\000\377\377U\377\377U"
 & "\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377"
 & "U\000\000\377\000\000\377\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\000\000\377\000\000\377\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\377\377\000\000\000\377\000\000"
 & "\377\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\000\000\377\000\000\377\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "U\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\000\000\377\000\000\377\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377U\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377U\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U"
 & "\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\000\000"
 & "\377\000\000\377\000\000\377\000";

CONST E28_14 = 
   "\000\377\000\000\377\000\000\377\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\000\000\377\000\000\377\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\377U\377\377\000\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\000\000\377\000\000\377\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377\000\377\377U\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U"
 & "\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\000\000\377\000\000\377\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\377\000\377\377\000\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\000\000\377\000\000\377\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\000\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\377\000\377\377\000\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\000\000\377\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377U\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\377U\377\377U\377\377U\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\000\000\377\000\000\377\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377U\377\377U\377\377U\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\377U\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\000\000\377\000\000\377\000\000"
 & "\377\000\000\377";

CONST E28_15 = 
   "\000\000\377\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377U\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\377U\377\377U\377\377U\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\377\377U\377\377U\377\377\000\377\377U"
 & "\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\000\000\377\000\000\377\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\377\000\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\000\000\377\000\000\377\377\377U\377\377\000\377\377U"
 & "\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377\000\377\377U\377\377\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\000\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\377\377U\377\377\000\377\377U\377\377\000\377\377U"
 & "\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\377\000\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\000\000"
 & "\377\000\000\377\000\000\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\000\000\377"
 & "\000\000\377\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\000\000\377\000\000\377\000\000\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\000\000"
 & "\377\000\000\377\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377U\377\377U\377\377\000\377\000\000\377\000"
 & "\000\377\000\000\377\377\000\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377\000\377\377"
 & "U\377\377U\377\377\000\377\000\000\377\000\000\377\000\000\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\000\000\377"
 & "\000\000\377\000\000\377\000\000";

CONST E28_16 = 
   "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\000\000\377\000\000\377\000\000\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\000\000\377\000\000"
 & "\377\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\000\000\377\000\000\377\000\000\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\000\000\377\000\000\377\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\000\000\377\000\000\377\000\000\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\000\000\377\000\000\377\000\000\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\377\377U\377\377U\377\377\000\377\377U"
 & "\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\000\000\377\377\000\377\377U"
 & "\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\000\000\377\000\000\377\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\000\000\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\000\000\377\000\000\377\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\000\000"
 & "\377\000\000\377\000\000\377\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377\000\377\377U\377\377\000\377\000\000\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\000\000\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\377\377U\377\377\000\377\377\000\377\377"
 & "U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\000\000\377\000\000\377\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377";

CONST E28_17 = 
   "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377\000\377\377"
 & "U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\377\377U\377\377U\377\377\000\377\377U"
 & "\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\000\000\377\000\000\377\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\377\377U\377\377\000\377\377U\377\377\000\377\377U"
 & "\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\377\377U\377\377\000\377\377U\377\377\000\377\377U"
 & "\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\000\000\000";

CONST E28_18 = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377";

CONST E28_19 = 
   "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377";

CONST E28_20 = 
   "\377U\377\377U\377\377\000\377\377U\377\377U\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\000"
 & "\000\377\000\000\377\000\000\377\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\000\000\377\000\000\377\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\000\000\000\000\000\000\000\000\000\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\000\000\000\000"
 & "\000\000\000\000\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377"
 & "U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\000"
 & "\000\000\000\000\000\000\000\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\000\000\377\000\000\377"
 & "\000\000\377\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377"
 & "U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\000\000\377\000\000\377\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U";

CONST E28_21 = 
   "\377\377U\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\000\000\377\000\000\377\000\000\377\377\377U"
 & "\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\000\000"
 & "\377\000\000\377\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U"
 & "\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\377\377U\377\377\000\377\377U\377\377\000\377\377U"
 & "\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\000\000\377\000\000\377\000\000\377\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\000\000\377\000\000\377\000\000\377\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377";

CONST E28_22 = 
   "U\377\377U\377\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\000\000\377\000\000\377\000\000\377\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\377\377U\377\377U\377\377\000\377\377U"
 & "\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\000"
 & "\000\377\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U"
 & "\377\377\000\377\377U\377\377\000\377\377U\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\377\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\377\377U\377\377\000\377\377\000\377";

CONST E28_23 = 
   "\377U\377\377U\377\377\000\377\377\000\377\377U\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\377\377\000\377\377\000\377\377U\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377"
 & "U\377\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\377\377U\377\377\000\377\377\000\377\377U\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377\000\377\377"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U"
 & "\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000";

CONST E28_24 = 
   "\000\000\000\000\000\000\000\000\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\377\377U\377\377\000\377\377U\377\377\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\377\377U\377\377\000\377\377\000\377\377U\377\377U"
 & "\377\377\000\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377"
 & "U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377"
 & "\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\377\377\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\377\377\000\377\377U\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377"
 & "U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377";

CONST E28_25 = 
   "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\377\377U\377\377\000\377\377\000\377\377U\377\377U"
 & "\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377"
 & "U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\377\377U\377\377\000\377\377\000\377\377"
 & "U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000"
 & "\000\377\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377";

CONST E28_26 = 
   "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\000\000\377\000\000\377"
 & "\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\000\000\000\000\000\000\000\000\000\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377"
 & "U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377"
 & "U\377\377U\377\377\000\377\377\000\377\377U\000\000\377\000\000\377\000"
 & "\000\377\000\000\377\000\000\377\000\000\377\000\000\377\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\000\000\000"
 & "\000\000\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377"
 & "U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\000\000\000\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\000\000\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\000\000\000\000\000\000\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\000\000\000\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\000\000"
 & "\000\000\000\000\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U";

CONST E28_27 = 
   "\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377"
 & "U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\000\000"
 & "\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000\377\000\000"
 & "\377\000\000\377\000\000\377\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377"
 & "U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377";

CONST E28_28 = 
   "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\377\377\000\377\377U\377\377U\377\377U"
 & "\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377";

CONST E28_29 = 
   "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000";

CONST E28_30 = 
   "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377";

CONST E28_31 = 
   "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377";

CONST E28_32 = 
   "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377"
 & "U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377"
 & "\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377"
 & "U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377"
 & "\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377\377"
 & "U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000\377"
 & "\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377\000"
 & "\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377\377"
 & "\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\377\377U\377"
 & "\377\000\377\377U\377\377U\377\377U\377\377\000\377\377U\377\377U\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377"
 & "U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377"
 & "\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377"
 & "\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377"
 & "\377\000\377\377U\377\377\000\377\377U\377\377\000\377\377U\377\377\000"
 & "\377\377U\377\377\000\377\377U\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000";

CONST E28_33 = 
   "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377"
 & "\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377"
 & "\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377"
 & "\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000"
 & "\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000"
 & "\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377"
 & "U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377"
 & "\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377\377\000\377"
 & "\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U\377\377U\377"
 & "\377\000\377\377\000\377\377U\377\377U\377\377\000\377\377\000\377\377U"
 & "\377\377U\377\377\000\377\377\000\377\377U\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000";

CONST E28_34 = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000";

CONST E29 = 
   "MODULE Anim;\n\n(* A module for drawing animations. *)\n\nIMPORT Time, "
 & "PS;\n\n(* PERMANENT OBJECTS *)\n\nPRIVATE VAR permList := NIL;\n\n(* Th"
 & "is module maintains a list of permanent \n   objects, each represented "
 & "by a \n   zero-argument closure. The list is \n   initially empty. *)\n"
 & "\nPROC ClearPerm() IS permList := NIL END;\n\n(* Make the list of perma"
 & "nent objects empty. \n*)\n\nPROC AddPerm(cl) IS \n  permList := (cl, pe"
 & "rmList) \nEND;\n\n(* Add the zero-argument closure \"cl\" to the \n   l"
 & "ist of permanent objects. *)\n\nPRIVATE PROC DrawPerm2(l) IS \n  IF \n "
 & "   l # NIL -> \n      DrawPerm2(CDR(l)); APPLY(CAR(l)) | SKIP \n  FI \n"
 & "END;\n\nPROC DrawPerm() IS DrawPerm2(permList) END;\n\n(* Draw the perm"
 & "anent objects by invoking \n   their closures in the order they were \n"
 & "   added. *)\n\n(* ANIMATION OBJECTS *)\n\n(* An {\\it animation} is a "
 & "pair \"(cl, dur)\", \n   where \"cl\" is a closure for drawing each \n "
 & "  frame of an animation, and \"dur\" is the \n   animation\'s duration."
 & " The \"Play\" procedure \n   below applies \"cl\" with a single time \n"
 & "   argument in the interval \"[0,dur]\". *)\n\nPRIVATE PROC SeqFrame(a1"
 & ", a2, t) IS \n  IF \n    t <= CDR(a1) -> APPLY(CAR(a1), t) \n  | APPLY("
 & "CAR(a2), t - CDR(a1)) \n  FI \nEND;\n\nPROC an := Seq(a1, a2) IS \n  an"
 & " := \n    (CLOSE(SeqFrame, a1, a2), \n     CDR(a1) + CDR(a2)) \nEND;\n\n"
 & "(* \"an\" is the animation that runs \"a1\" \n   followed by \"a2\"; it"
 & "s duration is the sum \n   of the durations of \"a1\" and \"a2\". *)\n\n"
 & "PRIVATE PROC CoFrame(a1, a2, t) IS \n  IF \n    t <= CDR(a1) -> APPLY(C"
 & "AR(a1), t) | SKIP \n  FI; \n  IF \n    t <= CDR(a2) -> APPLY(CAR(a2), t"
 & ") | SKIP \n  FI \nEND;\n\nPROC an := Co(a1, a2) IS \n  an := \n    (CLO"
 & "SE(CoFrame, a1, a2), \n     MAX(CDR(a1), CDR(a2))) \nEND;\n\n(* \"an\" "
 & "is the animation that runs \"a1\" and \n   \"a2\" in parallel; its dura"
 & "tion is the \n   maximum of the durations of \"a1\" and \"a2\". \n   Ea"
 & "ch animation is run for its natural \n   duration, so if one animation\'"
 & "s duration \n   is shorter than the other, it will finish \n   sooner. "
 & "No frames are displayed for the \n   shorter animation once it ";

CONST E29_0 = 
   "completes. *)\n\nPRIVATE PROC ScaleFrame(an, dur, t) IS \n  APPLY(CAR(a"
 & "n), CDR(an) * (t / dur)) \nEND;\n\nPROC an := Scale(a, dur) IS \n  an :"
 & "= (CLOSE(ScaleFrame, a, dur), dur) \nEND;\n\n(* \"an\" is the animation"
 & " \"a\" scaled in time \n   to take a total of \"dur\" seconds, \n   reg"
 & "ardless of \"a\"\'s duration. *)\n\nPRIVATE PROC ExtendFrame(an, t) IS "
 & "\n  APPLY(CAR(an), MIN(t, CDR(an))) \nEND;\n\nPROC an := Extend(a, dur)"
 & " IS \n  an := (CLOSE(ExtendFrame, a), dur) \nEND;\n\n(* \"an\" is the a"
 & "nimation \"a\" with a total \n   duration of \"dur\". If \"dur\" is les"
 & "s than \n   \"Dur(a)\", then \"a\"\'s animation is \n   truncated. If \""
 & "dur\" is greater than \n   \"Dur(a)\" then \"a\" is extended by playing"
 & " \n   its last frame an extra \"dur - Dur(a)\" \n   seconds. *)\n\nPRIV"
 & "ATE PROC RepeatFrame(an, dur, t) IS \n  VAR t0 IN \n    t0 := t MOD CDR"
 & "(an); \n    IF \n      t0 = 0 AND t # 0 -> t0 := CDR(an) | SKIP \n    F"
 & "I; \n    APPLY(CAR(an), t0) \n  END \nEND;\n\nPROC an := Repeat(a, n) I"
 & "S \n  IF \n    VAR dur = n * CDR(a) IN \n      an := (CLOSE(RepeatFrame"
 & ", a, dur), dur) \n    END \n  FI \nEND;\n\n(* \"an\" is the animation \""
 & "a\" repeated \"n\" \n   times; its duration is \"n * Dur(a)\". *)\n\nPR"
 & "IVATE PROC ReverseFrame(an, t) IS \n  APPLY(CAR(an), CDR(an) - t) \nEND"
 & ";\n\nPROC an := Reverse(a) IS \n  an := (CLOSE(ReverseFrame, a), CDR(a)"
 & ") \nEND;\n\n(* \"an\" is the animation \"a\" in reverse; its \n   durat"
 & "ion is the same as \"a\"\'s duration. *)\n\nPRIVATE PROC WarpTimeFrame("
 & "an, warp, t) IS \n  APPLY(CAR(an), APPLY(warp, t)) \nEND;\n\nPROC an :="
 & " WarpTime(a, warp) IS \n  an := \n    (CLOSE(WarpTimeFrame, a, warp), C"
 & "DR(a)) \nEND;\n\n(* \"an\" is the animation whose duration is \n   \"Du"
 & "r(a)\" and whose frame at time \"t\" is \n   produced by running \"APPL"
 & "Y(CAR(a), \n   APPLY(warp, t))\". *)\n\nPRIVATE PROC NormalizeFrame(an,"
 & " t) IS \n  APPLY(CAR(an), t / CDR(an)) \nEND;\n\nPROC an := Normalize(a"
 & ") IS \n  an := (CLOSE(NormalizeFrame, a), CDR(a)) \nEND;\n\n(* \"an\" i"
 & "s the animation with duration \n   \"Dur(a)\" whose frame for time \"t\""
 & " is \n   produced by running \"APPLY(CAR(a), \n   t/Dur(a))\". Hence, \""
 & "a\"\'s closure wi";

CONST E29_1 = 
   "ll be \n   invoked with values of \"t\" in the interval \n   [0, 1]. *)"
 & "\n\nPRIVATE PROC SkipFrame(t) IS SKIP END;\n\nPROC an := Skip(dur) IS \n"
 & "  an := (SkipFrame, dur) \nEND;\n\n(* \"an\" is the animation that does"
 & " nothing \n   for \"dur\" seconds. *)\n\n(* DRAWING ANIMATIONS *)\n\nCO"
 & "NST DefaultTFactor = 1;\n\n(* This module maintains a current time \n  "
 & " factor, which is the ratio between \n   animation time and real time u"
 & "sed by the \n   procedure \"Play\" below. Time factors less \n   than 1"
 & ".0 cause the animation to run faster \n   than real time. *)\n\nPRIVATE"
 & " VAR tFactor := DefaultTFactor;\n\nPROC SetTFactor(k) IS tFactor := k E"
 & "ND;\n\nUI SetTool(SetTFactor);\n\n(* Set the current time factor to \"k"
 & "\". *)\n\nUI Param(SetTFactor, DefaultTFactor);\n\nUI Param(SetTFactor,"
 & " 0.25);\n\nUI Param(SetTFactor, 0.5);\n\nUI Param(SetTFactor, 1);\n\nUI"
 & " Param(SetTFactor, 2);\n\nUI Param(SetTFactor, 5);\n\nPROC Play(an) IS "
 & "\n  IF \n    VAR t = 0, cl, dur, start, k IN \n      start := Time.Now("
 & "); \n      cl := CAR(an); \n      dur := CDR(an); \n      k := 1 / MAX("
 & "tFactor, 0.0001); \n      DrawPerm(); \n      DO \n        t < dur -> \n"
 & "          APPLY(cl, t); \n          t := k * (Time.Now() - start); \n  "
 & "        PS.ShowPage(); \n          PS.RestorePage(); \n          DrawPe"
 & "rm() \n      OD; \n      APPLY(cl, dur) \n    END \n  FI \nEND;\n\n(* D"
 & "raw the animation \"an\", i.e., invoke the \n   animation\'s closure wi"
 & "th values of \"t\" \n   starting at 0 and ending at the \n   animation\'"
 & "s duration. Before each frame, \n   \"DrawPerm\" is called to draw the "
 & "permanent \n   objects. Between frames, \"PS.ShowPage\" and \n   \"PS.R"
 & "estorePage\" are called to start a new \n   frame. The animation\'s dur"
 & "ation is scaled \n   against real time according to the current \n   ti"
 & "me factor. *)\n\n(* MISC *)\n\nPRIVATE VAR history := NIL;\n\nPROC Save"
 & "() IS \n  history := ((permList, tFactor), history) \nEND;\n\nPROC Rest"
 & "ore() IS \n  VAR new IN \n    new := CAR(history); \n    permList := CA"
 & "R(new); \n    tFactor := CDR(new) \n  END; \n  history := CDR(history) "
 & "\nEND;\n\nUI PointTool(Save);\n\nUI PointTool(Restore);\n";

CONST E29_2 = 
   "\n(* Save/Restore the animation state, namely, \n   the list of permane"
 & "nt objects. *)\n\n";

CONST E30 = 
   "MODULE Rect;\n\n(* Procedures and predicates for rectangles. *)\n\nIMPO"
 & "RT R2, Geometry, PS, Ellipse;\n\n(* \\section{Opposite Corner Represent"
 & "ation} *)\n\n(* The follow procedures represent a rectangle \n   orient"
 & "ed squarely with the page by two of its \n   opposite corners, \"a\" an"
 & "d \"b\". *)\n\nPROC Draw(a, b) IS \n  IF \n    VAR ax, ay, bx, by IN \n"
 & "      a = (ax, ay) AND b = (bx, by) -> \n        PS.MoveTo(a); \n      "
 & "  PS.LineTo((ax, by)); \n        PS.LineTo(b); \n        PS.LineTo((bx,"
 & " ay)); \n        PS.Close() \n    END \n  FI \nEND;\n\nUI PointTool(Dra"
 & "w);\n\n(* Append a closed rectangular path with opposite \n   corners \""
 & "a\" and \"b\" oriented squarely with the \n   page to the current path."
 & " *)\n\nPRED On(p, a, b) IS \n  (E px, py, ax, ay, bx, by :: \n    p = ("
 & "px, py) AND \n    a = (ax, ay) AND \n    b = (bx, by) AND \n    0 = \n "
 & "     (px - ax) * (px - bx) * (py - ay) * \n      (py - by)) \nEND;\n\nU"
 & "I PointTool(On);\n\n(* The point \"p\" is on the rectangle with \n   op"
 & "posite corners \"a\" and \"b\". \n\n   This constraint is actually true"
 & " if \"p\" is on \n   any of the lines obtained by extending the \n   si"
 & "des of the rectangle infinitely. However, if \n   the hint for \"p\" is"
 & " inside the circle \n   circumscribing the rectangle and is not too \n "
 & "  close to the center of the rectangle, the \n   solver will converge o"
 & "n a solution for \"p\" \n   that is actually on the rectangle. You can "
 & "use \n   the \"OnHint\" function to compute a hint for \n   \"p\" that "
 & "will converge on the actual rectangle \n   in most cases. *)\n\nPRIVATE"
 & " FUNC ecc = Ecc(wh) IS \n  (E w, h :: wh = (w, h) AND ecc = h / w) \nEN"
 & "D;\n\nPRIVATE FUNC p = OnCHint0(c, b, d) IS \n  (E wh = R2.Minus(b, c),"
 & " maj :: \n    maj = R2.Plus(c, (CAR(wh), 0)) AND \n    p ~ (0.5, 0) REL"
 & " (d, c) AND \n    Geometry.Colinear(d, p, c) AND \n    Ellipse.OnEcc(p,"
 & " c, maj, Ecc(wh))) \nEND;\n\n/* See the comment for \"OnCHint\" below. "
 & "This \n   procedure is here because it must preceed \n   \"OnHint\". */"
 & "\n\nFUNC p = OnHint(a, b, d) IS \n  (E c = Geometry.Mid(a, b) :: \n    "
 & "p = OnCHint0(c, b, d)) \nEND;\n\n(* \"p\" is a goo";

CONST E30_0 = 
   "d hint for a point on the \n   intersection of the rectangle with corne"
 & "rs \"a\" \n   and \"b\" and the line through \"d\" and the \n   center "
 & "of that rectangle. *)\n\nFUNC res = Area(a, b) IS\n  res = Geometry.Dis"
 & "tX(a,b) * Geometry.DistY(a,b)\nEND;\n\n(* \"res\" is the area of the re"
 & "ctangle with \n   opposite corners \"a\" and \"b\". *)\n\n(* \\section{"
 & "Center-Corner Representation} *)\n\nPRIVATE FUNC a = OtherCorner(c, b) "
 & "IS\n  a = (-1, 0) REL (c, b)\nEND;\n\n/* \"a\" is the opposite corner o"
 & "f the rectangle\n   from the point \"b\", where \"c\" is the center\n  "
 & " of the rectangle. */\n\n(* The following procedures are like the ones "
 & "\n   above, only they represent a rectangle by its \n   center \"c\" an"
 & "d one of its corners \"b\". *)\n\nPROC DrawC(c, b) IS \n  Draw(OtherCor"
 & "ner(c, b), b)\nEND;\n\nUI PointTool(DrawC);\n\n(* Like \"Draw\" above, "
 & "but the rectangle is \n   specified by its center \"c\" and one of its "
 & "\n   corners \"b\". *)\n\nPRED OnC(p, c, b) IS \n  On(p, OtherCorner(c,"
 & " b), b)\nEND;\n\nUI PointTool(OnC);\n\n(* Like \"On\" above, but the re"
 & "ctangle is \n   specified by its center \"c\" and one of its \n   corne"
 & "rs \"b\". The current point becomes \"b\". *)\n\nFUNC p = OnCHint(c, b,"
 & " d) IS \n  p = OnCHint0(c, b, d) \nEND;\n\n(* \"p\" is a good hint for "
 & "a point on the \n   intersection of the line \"cd\" and the \n   rectan"
 & "gle with center \"c\" and corner \"b\". *)\n\nFUNC res = AreaC(c, b) IS"
 & "\n  res = Area(OtherCorner(c, b), b)\nEND;\n\n(* \"res\" is the area of"
 & " the rectangle with\n   center \"c\" and corner \"b\". *)\n\n(* \\secti"
 & "on{Pair representation} *)\n\n(* The following routines encode a rectan"
 & "gle \"r\" \n   as a pair of points denoting two of its \n   opposite co"
 & "rners. \n\n   If \"r = ((x1, y1), (x2, y2)\" and we have: \n\n|    west"
 & " = MIN(x1, x2)\n|    east = MAX(x1, x2)\n|    south = MIN(y1, y2)\n|   "
 & " north = MAX(y1, y2)\n\n   then a point \"p = (px, py)\" is in the \n  "
 & " rectangle \"r\" if: \n\n|    west <= px < east\n|    south <= py < nor"
 & "th\n\n   We impose the restriction that if a rectangle \n   contains no"
 & " points, then it must be equal to \n   \"Rect.Empty\". *)\n\nCONST Empt"
 & "y = ((0, 0), (0,";

CONST E30_1 = 
   " 0));\n\n(* The empty rectangle. *)\n\nPROC res := FromCorners(a, b) IS"
 & "\n  res := (a, b)\nEND;\n\n(* \"res\" is the rectangle with opposite co"
 & "rners\n   \"a\" and \"b\". *)\n\nPROC res := FromCenterCorner(c,b) IS\n"
 & "  res := ((-1,0) REL (c,b), b)\nEND;\n\n(* \"res\" is the rectangle wit"
 & "h center \"c\" and\n   corner \"b\". *)\n\nPROC DrawR(r) IS \n  IF \n  "
 & "  VAR r1, r2 IN r = (r1, r2) -> Draw(r1, r2) END \n  FI \nEND;\n\n(* Li"
 & "ke \"Draw\" above, but the rectangle \"r\" is \n   specified by a pair "
 & "of points at opposite \n   corners of the rectangle. *)\n\nPRED OnR(p, "
 & "r) IS \n  (E r1, r2 :: r = (r1, r2) AND On(p, r1, r2)) \nEND;\n\n(* Lik"
 & "e \"On\" above, but the rectangle \"r\" is \n   specified by a pair of "
 & "points at opposite \n   corners of the rectangle. *)\n\nFUNC p = OnRHin"
 & "t(r, d) IS \n  p = OnHint(CAR(r), CDR(r), d) \nEND;\n\n(* Like \"OnHint"
 & "\" above, but the rectangle \"r\" is \n   specified by a pair of points"
 & " at opposite \n   corners of the rectangle. *)\n\nPROC p := North(r) IS"
 & " \n  IF \n    VAR x1, y1, x2, y2 IN \n      r = ((x1, y1), (x2, y2)) ->"
 & " \n        p := ((x1 + x2) / 2, MAX(y1, y2)) \n    END \n  FI \nEND;\n\n"
 & "PROC p := South(r) IS \n  IF \n    VAR x1, y1, x2, y2 IN \n      r = (("
 & "x1, y1), (x2, y2)) -> \n        p := ((x1 + x2) / 2, MIN(y1, y2)) \n   "
 & " END \n  FI \nEND;\n\nPROC p := East(r) IS \n  IF \n    VAR x1, y1, x2,"
 & " y2 IN \n      r = ((x1, y1), (x2, y2)) -> \n        p := (MAX(x1, x2),"
 & " (y1 + y2) / 2) \n    END \n  FI \nEND;\n\nPROC p := West(r) IS \n  IF "
 & "\n    VAR x1, y1, x2, y2 IN \n      r = ((x1, y1), (x2, y2)) -> \n     "
 & "   p := (MIN(x1, x2), (y1 + y2) / 2) \n    END \n  FI \nEND;\n\nFUNC p "
 & "= Center(r) IS \n  (E r1, r2 :: \n    r = (r1, r2) AND p = Geometry.Mid"
 & "(r1, r2)) \nEND;\n\nPROC p := NW(r) IS \n  IF \n    VAR x1, y1, x2, y2 "
 & "IN \n      r = ((x1, y1), (x2, y2)) -> \n        p := (MIN(x1, x2), MAX"
 & "(y1, y2)) \n    END \n  FI \nEND;\n\nPROC p := NE(r) IS \n  IF \n    VA"
 & "R x1, y1, x2, y2 IN \n      r = ((x1, y1), (x2, y2)) -> \n        p := "
 & "(MAX(x1, x2), MAX(y1, y2)) \n    END \n  FI \nEND;\n\nPROC p := SE(r) I"
 & "S \n  IF \n    VAR x1, y1, x2, y2 IN \n      r = ((x1, y1), (x2, y2)) ";

CONST E30_2 = 
   "-> \n        p := (MAX(x1, x2), MIN(y1, y2)) \n    END \n  FI \nEND;\n\n"
 & "PROC p := SW(r) IS \n  IF \n    VAR x1, y1, x2, y2 IN \n      r = ((x1,"
 & " y1), (x2, y2)) -> \n        p := (MIN(x1, x2), MIN(y1, y2)) \n    END "
 & "\n  FI \nEND;\n\n(* These procedures set \"p\" to the named \n   charac"
 & "teristic point on the boundry or at the \n   center of the rectangle \""
 & "r\". *)\n\nPROC w := Width(r) IS \n  IF \n    VAR x1, y1, x2, y2 IN \n "
 & "     r = ((x1, y1), (x2, y2)) -> \n        w := ABS(x2 - x1) \n    END "
 & "\n  FI \nEND;\n\n(* \"w\" is the width of \"r\". *)\n\nPROC h := Height"
 & "(r) IS \n  IF \n    VAR x1, y1, x2, y2 IN \n      r = ((x1, y1), (x2, y"
 & "2)) -> \n        h := ABS(y2 - y1) \n    END \n  FI \nEND;\n\n(* \"h\" "
 & "is the height of \"r\". *)\n\nPROC res := Size(r) IS \n  IF \n    VAR x"
 & "1, y1, x2, y2 IN \n      r = ((x1, y1), (x2, y2)) -> \n        res := ("
 & "ABS(x2 - x1), ABS(y2 - y1)) \n    END \n  FI \nEND;\n\n(* \"res\" is a "
 & "pair \"(w, h)\", where \"w\" and \"h\" \n   are the width and height of"
 & " \"r\", respectively. \n*)\n\nPROC res := Plus(r, p) IS \n  IF \n    r "
 & "= Empty -> res := Empty \n  | VAR r1, r2 IN \n      r = (r1, r2) -> \n "
 & "       res := (R2.Plus(r1, p), R2.Plus(r2, p)) \n    END \n  FI \nEND;\n"
 & "\n(* \"res\" is the rectangle obtained by translating \n   \"r\" by the"
 & " vector \"p\". *)\n\nPROC w, e, s, n := Edges(r) IS \n  IF \n    VAR r1"
 & "x, r1y, r2x, r2y IN \n      r = ((r1x, r1y), (r2x, r2y)) -> \n        w"
 & " := MIN(r1x, r2x); \n        e := MAX(r1x, r2x); \n        s := MIN(r1y"
 & ", r2y); \n        n := MAX(r1y, r2y) \n    END \n  FI \nEND;\n\n(* Set "
 & "\"w\" and \"e\" to the x-coordinates of the\n   west and east edges of "
 & "\"r\", and \"s\" and \"n\"\n   to the y-coordinates of the south and no"
 & "rth\n   edges of \"r\". *)\n\nPROC res := Inset(r, d) IS \n  VAR w, e, "
 & "s, n IN \n    w, e, s, n := Edges(r); \n    w, s := w + d, s + d; \n   "
 & " e, n := e - d, n - d; \n    IF \n      e < w OR n < s -> res := Empty "
 & "\n    | res := ((w, s), (e, n)) \n    FI \n  END \nEND;\n\n(* \"res\" i"
 & "s the rectangle \"r\" inset by \"d\" \n   points. If \"r\" does not hav"
 & "e width and height \n   at least \"2*d\", \"res\" is set to \"Empty\". "
 & "*)\n\nPROC res := Join";

CONST E30_3 = 
   "(r, s) IS \n  IF \n    r = Empty -> res := s | s = Empty -> res := r \n"
 & "  | VAR rW, rE, rS, rN, sW, sE, sS, sN IN \n      rW, rE, rS, rN := Edg"
 & "es(r); \n      sW, sE, sS, sN := Edges(s); \n      res := \n        ((M"
 & "IN(rW, sW), MIN(rS, sS)), \n         (MAX(rE, sE), MAX(rN, sN))) \n    "
 & "END \n  FI \nEND;\n\n(* \"res\" is the smallest rectangle containing \n"
 & "   both \"r\" and \"s\". *)\n\nPROC res := Meet(r, s) IS \n  IF \n    r"
 & " = Empty OR s = Empty -> res := Empty \n  | VAR \n      rW, rE, rS, rN,"
 & " sW, sE, sS, sN, resW, resE, \n      resS, resN \n    IN \n      rW, rE"
 & ", rS, rN := Edges(r); \n      sW, sE, sS, sN := Edges(s); \n      resW "
 & ":= MAX(rW, sW); \n      resE := MIN(rE, sE); \n      resS := MAX(rS, sS"
 & "); \n      resN := MIN(rN, sN); \n      IF \n        resW >= resE OR re"
 & "sS >= resN -> \n          res := Empty \n      | res := ((resW, resS), "
 & "(resE, resN)) \n      FI \n    END \n  FI \nEND;\n\n(* \"res\" is the l"
 & "argest rectangle contained in \n   both \"r\" and \"s\". *)\n\nFUNC res"
 & " = AreaR(r) IS\n  (E c1, c2 :: r = (c1, c2) AND\n    res = Area(c1, c2)"
 & ")\nEND;\n\n(* \"res\" is the area of the rectangle \"r\". *)\n";

CONST E31 = 
   "; Copyright (C) 1992, Digital Equipment Corporation                    "
 & "     \n; All rights reserved.                                          "
 & "            \n; See the file COPYRIGHT for a full description.         "
 & "                   \n;                                                 "
 & "                          \n; Last modified on Thu Dec  1 10:28:20 PST "
 & "1994 by heydon                   \n\n(Rim (Pen 5)\n  (VBox\n    (HBox\n"
 & "      Fill\n      (FixedWidth (Text (Margin 0) \"The file \\\"\"))\n   "
 & "   (FixedWidth (Text (Margin 0) %overwriteFileName \"\"))\n      (Fixed"
 & "Width (Text (Margin 0) \"\\\" already exists.\"))\n      Fill\n    )\n "
 & "   \"Overwrite it?\"\n    (Glue 5)\n    (HBox\n      Fill\n      (Close"
 & "Button %saveAsOverwrite \"Overwrite\")\n      Fill\n      (CloseButton "
 & "%overwriteCancel \"Cancel\")\n      Fill\n    )\n  )\n)\n";

CONST E32 = 
   "MODULE Ellipse;\n\n(* Procedures and predicates for \n   ellipses with "
 & "arbitrary \n   orientations. *)\n\nIMPORT Geometry, PS, Rel;\n\n(* ECCE"
 & "NTRICITY REPRESENTATION *)\n\n(* The following routines define an \n   "
 & "ellipse \"[a, b, e]\" by its center \n   \"a\", the tip of its major ax"
 & "is \n   \"b\", and its eccentricity \"e\" \n   (the real-valued ratio o"
 & "f the \n   length of its minor axis to the \n   length its major axis)."
 & " This \n   representation is somewhat more \n   efficient than the one "
 & "used later \n   in this module, but cannot be \n   clicked in. *)\n\nPR"
 & "IVATE PROC DrawQuarterEcc(a, r) IS \n  VAR b IN \n    b := PS.CurrentPo"
 & "int(); \n    IF \n      VAR \n        c = (0, r) REL (a, b), \n        "
 & "d \n      = (1, r * 0.5523) REL (a, b), \n        e = (0.5523, r) REL ("
 & "a, b) \n      IN \n        PS.CurveTo(d, e, c) \n      END \n    FI \n "
 & " END \nEND;\n\n/* Add a quarter ellipse with \n   eccentricity \"r\" st"
 & "arting at the \n   current point about the center \n   \"a\" to the cur"
 & "rent path. Positive \n   values of \"r\" create the curve in \n   a cou"
 & "nter-clockwise direction \n   from the current point around \n   \"a\","
 & " while negative values of \"r\" \n   create the curve in a clockwise \n"
 & "   direction around \"a\". */\n\nPRIVATE PROC DrawSemiEcc(a, e) IS \n  "
 & "DrawQuarterEcc(a, e); \n  DrawQuarterEcc(a, 1 / e) \nEND;\n\n/* Add hal"
 & "f an ellipse of \n   eccentricity \"r\" about \"a\" \n   starting from "
 & "the current point. \n   Positive values of \"r\" create the \n   curve "
 & "in a counter-clockwise \n   direction from the current point \n   aroun"
 & "d \"a\", while negative values \n   of \"r\" create the curve in a \n  "
 & " clockwise direction around \"a\". */\n\nPROC DrawEcc(a, b, e) IS \n  P"
 & "S.MoveTo(b); \n  DrawSemiEcc(a, -e); \n  DrawSemiEcc(a, -e); \n  PS.Clo"
 & "se() \nEND;\n\nPROC DrawEccCC(a, b, e) IS \n  PS.MoveTo(b); \n  DrawSem"
 & "iEcc(a, e); \n  DrawSemiEcc(a, e); \n  PS.Close() \nEND;\n\n(* Add a cl"
 & "ockwise and counter- \n   clockwise ellipse \"[a, b, e]\", \n   respect"
 & "ively, to the current \n   path. The current point becomes \n   \"b\". "
 & "*)\n\nPRED OnEcc(p, a, b, e) IS \n  (E q = Rel.Inv(p, a, b), \n";

CONST E32_0 = 
   "     x = CAR(q), y = CDR(q) :: \n    x * x + (y * y) / (e * e) = 1) \nE"
 & "ND;\n\n(* The point \"p\" is on the ellipse \n   \"[a, b, e]\". *)\n\n("
 & "* THREE-POINT REPRESENTATION *)\n\n(* The following routines define an "
 & "\n   ellipse \"[a, b, c]\" by its center \n   \"a\", a point \"b\" at t"
 & "he tip of \n   one of its axes, and a point \"c\" \n   whose distance f"
 & "rom \"a\" is the \n   length of the axis perpendicular \n   to \"ab\". "
 & "*)\n\nPROC Draw(a, b, c) IS \n  VAR ab, ac IN \n    ab := Geometry.Dist"
 & "(a, b); \n    ac := Geometry.Dist(a, c); \n    DrawEcc(a, b, ac / ab) \n"
 & "  END \nEND;\n\nPROC DrawCC(a, b, c) IS \n  VAR ab, ac IN \n    ab := G"
 & "eometry.Dist(a, b); \n    ac := Geometry.Dist(a, c); \n    DrawEccCC(a,"
 & " b, ac / ab) \n  END \nEND;\n\nUI PointTool(Draw);\n\nUI PointTool(Draw"
 & "CC);\n\n(* Add a clockwise and counter- \n   clockwise ellipse \"[a, b,"
 & " c]\", \n   respectively, to the current \n   path. The current point b"
 & "ecomes \n   \"b\". *)\n\nPROC DrawSemi(a, c) IS \n  VAR b, ab, ac, e IN"
 & " \n    b := PS.CurrentPoint(); \n    ab := Geometry.Dist(a, b); \n    a"
 & "c := Geometry.Dist(a, c); \n    e := ac / ab; \n    DrawSemiEcc(a, -e) "
 & "\n  END \nEND;\n\nPROC DrawSemiCC(a, c) IS \n  VAR b, ab, ac, e IN \n  "
 & "  b := PS.CurrentPoint(); \n    ab := Geometry.Dist(a, b); \n    ac := "
 & "Geometry.Dist(a, c); \n    e := ac / ab; \n    DrawSemiEcc(a, e) \n  EN"
 & "D \nEND;\n\nUI PointTool(DrawSemi);\n\nUI PointTool(DrawSemiCC);\n\n(* "
 & "Add a clockwise or \n   counter-clockwise semi-ellipse to \n   the curr"
 & "ent path starting at the \n   current point. The semi-ellipse \n   has "
 & "center \"a\", the length of its \n   major axis is the distance from \n"
 & "   \"a\" to the current point, and the \n   length of its minor axis is"
 & " the \n   distance from \"a\" to \"c\". *)\n\nPRED On(p, a, b, c) IS \n"
 & "  (E ab, ac :: \n    ab = Geometry.Dist(a, b) AND \n    ac = Geometry.D"
 & "ist(a, c) AND \n    OnEcc(p, a, b, ac / ab)) \nEND;\n\nUI PointTool(On)"
 & ";\n\n(* The point \"p\" is on the ellipse \n   \"[a, b, c]\". *)\n\n";

CONST E33 = 
   "MODULE TypeLinesL;\n\n(* The procedures in this module \n   type a bloc"
 & "k of left-justified \n   text lines relative to a \n   specified point."
 & " Each procedure \n   takes a reference point and a \n   single text, wh"
 & "ich is converted \n   to a list of texts by the \n   \"TextList.FromTex"
 & "t\" procedure. \n   One line is displayed in the \n   block per element"
 & " of this list. \n\n   The lines in each block are \n   separated vertic"
 & "ally by the \n   height of the current font plus \n   the current line "
 & "skip value \n   (maintained by the \"LineSkip\" \n   module). \n\n   Th"
 & "e text block is actually \n   translated in the appropriate \n   direct"
 & "ion away from the \n   reference point by the current \n   horizontal a"
 & "nd/or vertical \n   offset values (maintained by the \n   \"Offset\" mo"
 & "dule). For example, \n   the \"South\" procedure translates \n   the te"
 & "xt block up by the current \n   vertical offset, and the \"NE\" \n   pr"
 & "ocedure translates it down by \n   the current vertical offset and \n  "
 & " to the left by the current \n   horizontal offset. The \"Center\" \n  "
 & " procedure ignores the current \n   offset values. *)\n\nIMPORT LineSki"
 & "p, Offset, PS, \n       R2, TextList;\n\nPRIVATE PROC TypeBlockL(p, l) "
 & "IS \n  VAR asc, dec, d IN \n    asc, dec := PS.FontHeight(); \n    d :="
 & " asc + dec + LineSkip.Get(); \n    p := (CAR(p), CDR(p) - asc); \n    D"
 & "O \n      l # NIL -> \n        PS.Type(p, CAR(l)); \n        p := (CAR("
 & "p), CDR(p) - d); \n        l := CDR(l) \n    OD \n  END \nEND;\n\n/* Ty"
 & "pe the left-justified block of \n   text lines \"l\" such that \"p\" is"
 & " \n   the northwest corner of the \n   box\'s bounding-box. */\n\nPROC "
 & "North(p, txt) IS \n  VAR l, w, h, dh IN \n    l := TextList.FromText(tx"
 & "t); \n    w, h := TextList.Size(l); \n    dh := Offset.GetVer(); \n    "
 & "TypeBlockL(R2.Plus(p, \n                       (-w / 2, -dh)), \n      "
 & "         l) \n  END \nEND;\n\nPROC South(p, txt) IS \n  VAR l, w, h, dh"
 & " IN \n    l := TextList.FromText(txt); \n    w, h := TextList.Size(l); "
 & "\n    dh := Offset.GetVer(); \n    TypeBlockL(R2.Plus(p, \n            "
 & "           (-w / 2, \n             ";

CONST E33_0 = 
   "           h + dh)), l) \n  END \nEND;\n\nPROC East(p, txt) IS \n  VAR "
 & "l, w, h, dw IN \n    l := TextList.FromText(txt); \n    w, h := TextLis"
 & "t.Size(l); \n    dw := Offset.GetHor(); \n    TypeBlockL(R2.Plus(p, \n "
 & "                      (-w - dw, \n                        h / 2)), l) \n"
 & "  END \nEND;\n\nPROC West(p, txt) IS \n  VAR l, w, h, dw IN \n    l := "
 & "TextList.FromText(txt); \n    w, h := TextList.Size(l); \n    dw := Off"
 & "set.GetHor(); \n    TypeBlockL(R2.Plus(p, \n                       (dw,"
 & " h / 2)), \n               l) \n  END \nEND;\n\nPROC Center(p, txt) IS "
 & "\n  VAR l, w, h IN \n    l := TextList.FromText(txt); \n    w, h := Tex"
 & "tList.Size(l); \n    TypeBlockL(R2.Plus(p, \n                       (-w"
 & " / 2, \n                        h / 2)), l) \n  END \nEND;\n\nPROC NW(p"
 & ", txt) IS \n  VAR l, dw, dh IN \n    l := TextList.FromText(txt); \n   "
 & " dw, dh := Offset.GetHorVer(); \n    TypeBlockL(R2.Plus(p, (dw, -dh)), "
 & "\n               l) \n  END \nEND;\n\nPROC NE(p, txt) IS \n  VAR l, w, "
 & "h, dw, dh IN \n    l := TextList.FromText(txt); \n    w, h := TextList."
 & "Size(l); \n    dw, dh := Offset.GetHorVer(); \n    TypeBlockL(R2.Plus(p"
 & ", \n                       (-w - dw, \n                        -dh)), l"
 & ") \n  END \nEND;\n\nPROC SE(p, txt) IS \n  VAR l, w, h, dw, dh IN \n   "
 & " l := TextList.FromText(txt); \n    w, h := TextList.Size(l); \n    dw,"
 & " dh := Offset.GetHorVer(); \n    TypeBlockL(R2.Plus(p, \n              "
 & "         (-w - dw, \n                        h + dh)), l) \n  END \nEND"
 & ";\n\nPROC SW(p, txt) IS \n  VAR l, w, h, dw, dh IN \n    l := TextList."
 & "FromText(txt); \n    w, h := TextList.Size(l); \n    dw, dh := Offset.G"
 & "etHorVer(); \n    TypeBlockL(R2.Plus(p, \n                       (dw, h"
 & " + dh)), \n               l) \n  END \nEND;\n\nUI TextTool(North);\n\nU"
 & "I TextTool(South);\n\nUI TextTool(East);\n\nUI TextTool(West);\n\nUI Te"
 & "xtTool(Center);\n\nUI TextTool(NW);\n\nUI TextTool(NE);\n\nUI TextTool("
 & "SE);\n\nUI TextTool(SW);\n\n(* Display the \"\\\"-separated texts \n   "
 & "in \"t\" as a left-justified block \n   such that \"p\" is at the locat"
 & "ion \n   of the block\'s bounding box \n   named";

CONST E33_1 = 
   " by the procedure. *)\n\n";

CONST E34 = 
   "MODULE Print;\n\n(* Module for printing values to the standard output. "
 & "*)\n\nPROC Val(v) IS SKIP END; /* external procedure */\n\n(* Pretty-pr"
 & "int the value \"v\" to the standard output using a\n   line width of 75"
 & " characters. Numerical values in \"v\" are\n   printed to full precisio"
 & "n. *)\n";

CONST E35 = 
   "; Copyright (C) 1992, Digital Equipment Corporation                    "
 & "     \n; All rights reserved.                                          "
 & "            \n; See the file COPYRIGHT for a full description.         "
 & "                   \n;                                                 "
 & "                          \n; Last modified on Thu Aug 28 17:35:33 PDT "
 & "1997 by leifer                   \n;      modified on Wed Apr  9 22:50:"
 & "42 PDT 1997 by heydon                   \n\n(ZSplit %mainChild\n  (Inse"
 & "rt \"Macros.fv\")\n  (MyLabelFont)\n  (BgColor HSV 0 0 0.8)\n  (ZBackgr"
 & "ound\n    (Filter %background Passive (Cursor \"XC_watch\")\n      (HTi"
 & "le2\n        ;; Drawing half of UI\n        (VBox\n          ;; Menu ba"
 & "r\n          (HBox\n            (Menu (MenuLabel \"Juno-2\") (VBox\n   "
 & "           (PopMButton (For aboutWindow) (TextL \"About...\"))\n\t     "
 & " (PopMButton %config (For configWindow) (TextL \"Configure...\"))\n    "
 & "          (MButton %quit (TextL \"Quit\"))\n            ))\n           "
 & " (Menu (MenuLabel \"File\") (VBox\n              (MButton %load (TextL "
 & "\"New / Open...\"))\n              (MButton %save (TextL \"Save\"))\n  "
 & "            (PopMButton %saveAs (For saveAsWindow) (TextL \"Save As...\""
 & "))\n;              (MButton %savejava (TextL \"Save to Java\"))\n\t    "
 & "  (MButton %reload (TextL \"Reload\"))\n\t      (MButton %clearall (Tex"
 & "tL \"Clear All\"))\n              (Ridge 2)\n              (PopMButton "
 & "%module (For moduleWindow) (TextL \"Open Module...\"))\n              ("
 & "Ridge 2)\n              (MButton %print (TextL \"Print\"))\n           "
 & "   (MButton %preview (TextL \"Preview\"))\n            (MButton %savePS"
 & " (TextL \"Save PostScript\"))\n              (PopMButton %savePSas (For"
 & " savePSWindow)\n                (TextL \"Save PostScript As...\")\n    "
 & "          )\n            ))\n            (Menu (MenuLabel \"Labels\") ("
 & "Radio %labels =letters (VBox\n              (MButton (Choice %letters C"
 & "heckMark MenuStyle (TextL \"Letters\")))\n              (MButton (Choic"
 & "e %crosses CheckMark MenuStyle (TextL \"Crosses\")))\n              (MB"
 & "utton (Choice %nothing Check";

CONST E35_0 = 
   "Mark MenuStyle (TextL \"None\")))\n            )))\n          (Menu (Me"
 & "nuLabel \"Redisplay\") (Radio %autoUpdate =autoRun (VBox\n             "
 & " (MButton (Choice %autoRun CheckMark MenuStyle\n              (TextL \""
 & "Auto Run\")))\n              (MButton (Choice %autoSolve CheckMark Menu"
 & "Style\n              (TextL \"Auto Solve\")))\n            )))\n       "
 & "   ; (Menu (MenuLabel \"Test\") (VBox\n          ;   (PopMButton (For s"
 & "aveAsConfirmWindow) (TextL \"Confirm...\"))\n          ; ))\n          "
 & "  Fill\n          ) ;; HBox\n          (MyRidge)\n          ;; Toolbox "
 & "and Drawing\n          (HBox\n            (Shape (Height2 0)\n         "
 & "     (Generic %toolbox)\n            )\n            (MyRidge)\n        "
 & "    (Drawing\n              (Generic %drawing)\n            )\n        "
 & "  )\n        ) ;; VBox\n        \n        ;; Code half of UI\n        ("
 & "Sources\n          (VBox\n            ;; Menu bar\n            (HBox\n "
 & "           (Button %run (ButtonLabel \"Run\"))\n              (Filter D"
 & "ormant (Button %solve (ButtonLabel \"Solve\")))\n              (Menu (M"
 & "enuLabel \"Edit\") (VBox\n                (MButton %fold (TextL \"Fold."
 & "..\"))\n                (MButton %foldAsAnim (TextL \"Fold As Animation"
 & "...\"))\n                (Ridge 2)\n                (MButton %pushCurrC"
 & "md (TextL \"Push Current Command\"))\n                (MButton %popCurr"
 & "Cmd (TextL \"Pop Current Command\"))\n              ))\n              F"
 & "ill\n              (Border (Shape (Width + 0)\n                (Text %c"
 & "urrFile\n                  RightAlign\n                  (BgColor \"Lig"
 & "htGray\")\n                  \"Untitled.juno\"\n                )\n    "
 & "          ))\n            ) ;; HBox\n            (MyRidge)\n           "
 & " ;; Module and current command editors\n            (VTile2\n          "
 & "    (Module (Generic %editor))\n  \t      (CCmd (Generic %source))\n  \t"
 & "    ) ;; VTile2\n  \t  ) ;; VBox\n  \t) ;; Sources -- end of code half "
 & "of UI\n      ) ;; HTile2\n    ) ;; Filter\n  ) ;; ZBackground\n\n  ;; P"
 & "op-up windows\n  (ZChild %stopWindow\n    (Button %stop (ButtonLabel \""
 & "Stop\"))\n  )\n  (MyZChassis %aboutWindow";

CONST E35_1 = 
   "\n    (GrowBox FALSE)\n    (Title \"About Juno-2\")\n    (CancelName ab"
 & "outCancel)\n    (Child (Insert \"AboutBox.fv\"))\n  )\n  (MyZChassis %c"
 & "onfigWindow\n    (Title \"Configure\")\n    (CancelName configCancel)\n"
 & "    (Child (Insert \"Configure.fv\"))\n  )\n  (MyZChassis %loadWindow\n"
 & "    (Title \"Open File\")\n    (CancelName loadCancel)\n    (Child (Ins"
 & "ert \"LoadFile.fv\"))\n  )\n  (MyZChassis %saveAsWindow\n    (Title \"S"
 & "ave File\")\n    (CancelName saveAsCancel)\n    (Child (Insert \"SaveFi"
 & "le.fv\"))\n  )\n  (MyZChassis %saveAsConfirmWindow\n    (Title \"Save C"
 & "onfirmation\")\n    (CancelBox FALSE)\n    (GrowBox FALSE)\n    (Child "
 & "(Insert \"SaveConfirm.fv\"))\n  )\n  (MyZChassis %moduleWindow\n    (Ti"
 & "tle \"Open Module\")\n    (CancelName moduleCancel)\n    (Child (Insert"
 & " \"LoadModule.fv\"))\n  )\n  (MyZChassis %savePSWindow\n    (Title \"Sa"
 & "ve PostScript File\")\n    (CancelName savePSCancel)\n    (Child (Inser"
 & "t \"SavePS.fv\"))\n  )\n  (MyZChassis %foldWindow\n    (Title \"Fold\")"
 & "\n    (At (0.5 0.25))\n    (CancelName foldCancel)\n    (Child (Insert "
 & "\"Fold.fv\"))\n  )\n  (MyZChassis %foldAsAnimWindow\n    (Title \"Fold "
 & "As Animation\")\n    (At (0.5 0.25))\n    (CancelName foldAsAnimCancel)"
 & "\n    (Child (Insert \"FoldAsAnim.fv\"))\n  )\n  (MyZChassis %saveChang"
 & "esWindow\n    (GrowBox FALSE)\n    (Title \"Save Changes?\")\n    (At ("
 & "0.5 0.25))\n    (CancelName cancelChanges)\n    (Child (Insert \"SaveCh"
 & "anges.fv\"))\n  )\n) ;; ZSplit\n";

CONST E36 = 
   "(* Copyright (C) 1992, Digital Equipment Corporation                 *)"
 & "\n(* All rights reserved.                                              "
 & "*)\n(* See the file COPYRIGHT for a full description.                  "
 & "  *)\n(*                                                               "
 & "    *)\n(* Last modified on Mon Oct 31 09:05:57 PST 1994 by heydon     "
 & "      *)\n\n(* Definitions for CLOSE and APPLY so they will have slot\n"
 & "   numbers in the top-level scope. *)\n\nPROC res := CLOSE() IS SKIP EN"
 & "D;\n\nPROC APPLY() IS SKIP END;\n\n(* Definitions for the built-in pred"
 & "icates and functions. \n   To avoid name conflicts, these names all beg"
 & "in with \"_\". *)\n\nPRED _HOR(a, b) IS \n  (E x1, x2, y :: \n    REAL("
 & "x1) AND \n    REAL(x2) AND \n    REAL(y) AND \n    a = (x1, y) AND \n  "
 & "  b = (x2, y)) \nEND;\n\nPRED _VER(a, b) IS \n  (E x, y1, y2 :: \n    R"
 & "EAL(y1) AND \n    REAL(y2) AND \n    REAL(x) AND \n    a = (x, y1) AND "
 & "\n    b = (x, y2)) \nEND;\n\nFUNC y = _UMINUS(x) IS 0 = x + y END;\n\nF"
 & "UNC z = _MINUS(x, y) IS x = y + z END;\n\nFUNC z = _DIVIDE(x, y) IS x ="
 & " y * z END;\n\nFUNC y = _CAR(x) IS (E z :: x = (y, z)) END;\n\nFUNC y ="
 & " _CDR(x) IS (E z :: x = (z, y)) END;\n\nPRIVATE FUNC len = _SegLenSq(s)"
 & " IS\n  (E a, b, ax, ay, bx, by, dx, dy ::\n    s = (a, b) AND\n    a = "
 & "(ax, ay) AND\n    b = (bx, by) AND\n    dx = bx - ax AND\n    dy = by -"
 & " ay AND\n    len = dx * dx + dy * dy)\nEND;\n\nPRED _CONG(a, b) IS\n  _"
 & "SegLenSq(a) = _SegLenSq(b)\nEND;\n\nPRIVATE FUNC v = _Delta(ab) IS\n  ("
 & "E a, b, ax, ay, bx, by, vx, vy ::\n    ab = (a, b) AND\n    a = (ax, ay"
 & ") AND\n    b = (bx, by) AND\n    v = (vx, vy) AND\n    bx = vx + ax AND"
 & "\n    by = vy + ay)\nEND;\n\nPRIVATE PRED _ParaVects(v1, v2) IS\n  (E v"
 & "1x, v1y, v2x, v2y ::\n    v1 = (v1x, v1y) AND\n    v2 = (v2x, v2y) AND\n"
 & "    v1x * v2y = v1y * v2x)\nEND;\n\nPRED _PARA(a, b) IS \n  (E ad, bd :"
 & ":\n    ad = _Delta(a) AND\n    bd = _Delta(b) AND\n    _ParaVects(ad, b"
 & "d))\nEND;\n\nFUNC q = _REL(p, ab) IS \n  (E px, py, qx, qy,\n     a, b,"
 & " ax, ay, bx, by, dx, dy,\n     xx, yy, xy, yx, dx2, dy2 :: \n    ab = ("
 & "a, b) AND \n    a = (ax, ay) ";

CONST E36_0 = 
   "AND \n    b = (bx, by) AND \n    p = (px, py) AND \n    q = (qx, qy) AN"
 & "D \n    bx = dx + ax AND \n    by = dy + ay AND \n    xx = px * dx AND "
 & "\n    yy = py * dy AND \n    xy = px * dy AND \n    yx = py * dx AND \n"
 & "    xx = dx2 + yy AND \n    dy2 = xy + yx AND \n    qx = ax + dx2 AND \n"
 & "    qy = ay + dy2) \nEND;\n\n";

CONST E37 = 
   "MODULE Slider;\n\nIMPORT Math, Text, Color, R2, Geometry, PS, Angle, Be"
 & "zier, \n       Circle, Type, Rect, TypeLinesC;\n\n(* A module for drawi"
 & "ng sliders and associating them with \n   constraints. *)\n\n(* A slide"
 & "r is represented by three points, \"a\", \"b\", and \"c\". \n   The poi"
 & "nts \"a\" and \"c\" determine the endpoints of the slider, \n   and the"
 & " point \"b\" determines the location of its ``thumb\'\'. \n   In partic"
 & "ular, \"a\" determines the axis of the slider and one \n   of its endpo"
 & "ints, \"c\" determines the sizes of the tick marks \n   at the end of t"
 & "he slider and one of its endpoints. The \n   projection of \"b\" onto t"
 & "he slider\'s axis is the location of \n   the slider\'s thumb. \n\n   T"
 & "he location of the thumb determine\'s the slider\'s value. The \n   val"
 & "ue is defined as the fraction of the distance the thumb is \n   from \""
 & "a\" to \"c\". Hence, when the thumb is within the bounds \n   of the sl"
 & "ider, the slider\'s value is in the interval [0, 1]. \n*)\n\n(* \\secti"
 & "on{Slider Values} *)\n\nFUNC res = Value(a, b, c) IS \n  res * (CAR(c) "
 & "- CAR(a)) = CAR(b) - CAR(a) \nEND;\n\n(* \"res\" is the value of the sl"
 & "ider determined by the points \n   \"a\", \"b\", and \"c\". *)\n\nFUNC "
 & "b = ThumbPoint(a, c, t) IS b = (t, 0) REL (a, c) END;\n\n(* \"b\" satis"
 & "fies \"t = Value(a,b,c)\". *)\n\n(* \\section{Drawing Sliders} *)\n\nCO"
 & "NST Invisible = 0, Visible = 1, DefaultVisibility = Visible;\n\n(* This"
 & " module maintains a ``current visibility\'\', which \n   determines whe"
 & "ther the \"Draw\" procedure draws anything or \n   not. *)\n\nPRIVATE V"
 & "AR visibility := DefaultVisibility;\n\nPROC SetVisibility(vis) IS visib"
 & "ility := vis END;\n\nUI SetTool(SetVisibility);\n\n(* Set the current v"
 & "isibility to \"vis\", which should be either \n   \"Invisible\" or \"Vi"
 & "sible\". *)\n\nUI Param(SetVisibility, DefaultVisibility);\n\nUI Param("
 & "SetVisibility, Invisible);\n\nUI Param(SetVisibility, Visible);\n\nCONS"
 & "T HideValue = 0, ShowValue = 1, DefaultValueVis = ShowValue;\n\n(* This"
 & " module maintains a current ``value visibility\'\', which \n   controls"
 & " whether the \"Draw\" procedure shows the slider\'s \n   value";

CONST E37_0 = 
   ". *)\n\nPRIVATE VAR valueVis := DefaultValueVis;\n\nPROC SetValueVis(vi"
 & "s) IS valueVis := vis END;\n\nUI SetTool(SetValueVis);\n\n(* Set the cu"
 & "rrent value visibility to \"vis\", which should be \n   either \"HideVa"
 & "lue\" or \"ShowValue\". *)\n\nUI Param(SetValueVis, DefaultValueVis);\n"
 & "\nUI Param(SetValueVis, HideValue);\n\nUI Param(SetValueVis, ShowValue)"
 & ";\n\nPRIVATE CONST Gap = 5, ThumbW = 5;\n\nPRIVATE PROC DrawTrackHor(a,"
 & " b) IS \n  VAR c, d, e, f IN \n    c := Geometry.HorVer(a, b); \n    d "
 & ":= Geometry.HorVer(b, a); \n    e := (-1, -0) REL (a, d); \n    f := (-"
 & "1, -0) REL (c, b); \n    SAVE PS IN \n      PS.SetEndStyle(PS.SquareEnd"
 & "s); \n      PS.MoveTo(a); \n      PS.LineTo(c); \n      PS.MoveTo(d); \n"
 & "      PS.LineTo(e); \n      PS.MoveTo(b); \n      PS.LineTo(f); \n     "
 & " PS.Stroke() \n    END \n  END \nEND;\n\nPRIVATE PROC DrawThumbHor0(a, "
 & "b) IS \n  VAR c IN \n    c := R2.PlusX(b, ThumbW / 2); \n    Rect.DrawC"
 & "(a, c); \n    SAVE PS IN PS.SetColor(Color.Grey75); PS.Fill() END; \n  "
 & "  PS.Stroke() \n  END \nEND;\n\nPRIVATE PROC DrawThumbHor(a, b, c) IS \n"
 & "  VAR d, e IN \n    d := Geometry.HorVer(a, b); \n    e := Geometry.Hor"
 & "Ver(c, b); \n    DrawThumbHor0(d, e) \n  END \nEND;\n\nPRIVATE CONST De"
 & "cimal = Text.GetChar(\".\", 0);\n\nPRIVATE PROC DrawValue(a, b, c) IS \n"
 & "  VAR d, e, val, dotPos, str IN \n    d := Geometry.HorVer(c, a); \n   "
 & " e := Geometry.Mid(d, c); \n    val := Text.FromNum(Value(a, b, c), 1);"
 & " \n    dotPos := Text.FindChar(val, Decimal); \n    IF \n      dotPos ="
 & " -1 -> val := val & \".00\" \n    | DO Text.Length(val) - dotPos <= 2 -"
 & "> val := val & \"0\" OD \n    FI; \n    str := \"Value = \" & val; \n  "
 & "  IF \n      CDR(c) > CDR(a) -> \n        Type.C(R2.PlusY(d, Gap), \"0\""
 & "); \n        Type.C(R2.PlusY(c, Gap), \"1\"); \n        Type.C(R2.PlusY"
 & "(e, Gap), str) \n    | TypeLinesC.North(d, \"0\"); \n      TypeLinesC.N"
 & "orth(c, \"1\"); \n      TypeLinesC.North(e, str) \n    FI \n  END \nEND"
 & ";\n\nPROC Draw(a, b, c) IS \n  IF \n    visibility = Visible -> \n     "
 & " SAVE PS IN \n        PS.SetWidth(1.5); \n        DrawTrackHor(a, c); \n"
 & "        DrawThumbHor(a, b, c); \n        IF v";

CONST E37_1 = 
   "alueVis = ShowValue -> DrawValue(a, b, c) | SKIP FI \n      END | SKIP "
 & "\n  FI \nEND;\n\nUI PointTool(Draw);\n\n(* If the current visibility is"
 & " \"Visible\", draw a horizontal \n   slider with endpoints \"a\" and \""
 & "c\", and thumb position \"b\". \n   The horizontal axis of the slider p"
 & "asses through \"a\", and its \n   vertical extent is determined by the "
 & "vertical position of \n   \"c\". The point \"b\" controls the horizonta"
 & "l position of the \n   slider\'s thumb. \n\n   If the current value vis"
 & "ibility is \"ShowValue\", the slider is \n   annotated with its current"
 & " value, rendered in the current \n   font. The value is printed above o"
 & "r below the slider\'s thumb \n   as \"c\" is above or below the slider\'"
 & "s axis. *)\n\n(* \\section{Constraining Sliders} \n\n   The following p"
 & "redicates all constrain a point \"p\" to lie \n   along a geometric sha"
 & "pe such as a line or circle according to \n   the value of a slider \"a"
 & "\", \"b\", \"c\". In all of these \n   predicates, the slider points \""
 & "a\", \"b\", \"c\" are the first \n   three arguments, and the constrain"
 & "ed point \"p\" is the last \n   argument (with the exception of the \"O"
 & "nLine\" constraint). *)\n\nPRED OnLine(a, b, c, l0, p, l1) IS \n  (E t "
 & "= Value(a, b, c) :: p = (t, 0) REL (l0, l1)) \nEND;\n\nUI PointTool(OnL"
 & "ine);\n\n(* Constrains the point \"p\" to be the point on the segment w"
 & "ith \n   endpoints \"l0\" and \"l1\" whose relative position along that"
 & " \n   segment is the value of the slider \"a\", \"b\", \"c\". *)\n\nPRE"
 & "D OnCurve(a, b, c, b0, b1, b2, b3, p) IS \n  (E t = Value(a, b, c) :: p"
 & " = Bezier.AtT(b0, b1, b2, b3, t)) \nEND;\n\nUI PointTool(OnCurve);\n\n("
 & "* Constrains the point \"p\" to be the point on the Bezier curve \n   d"
 & "etermined by \"b0\", \"b1\", \"b2\", and \"b3\" whose relative \n   pos"
 & "ition along that curve is the value of the slider \"a\", \n   \"b\", \""
 & "c\". *)\n\nPRIVATE PRED OnCircle0(a, b, c, c0, c1, p, k) IS \n  (E t = "
 & "k * Value(a, b, c) :: p = (COS(t), SIN(t)) REL (c0, c1)) \nEND;\n\nPRED"
 & " OnCircle(a, b, c, c0, c1, p) IS \n  OnCircle0(a, b, c, c0, c1, p, -2 *"
 & " Math.Pi) \nEND;\n\nPRED OnCircleCC(a, b, c, c0, c1, p) IS \n  OnC";

CONST E37_2 = 
   "ircle0(a, b, c, c0, c1, p, 2 * Math.Pi) \nEND;\n\nUI PointTool(OnCircle"
 & ");\n\nUI PointTool(OnCircleCC);\n\n(* The point \"p\" is on the circle "
 & "with center \"c0\" and radius \n   point \"c1\". Its position around th"
 & "e circle measured in the \n   clockwise and counter-clockwise direction"
 & ", respectfully, from \n   \"c1\" is proportional to the value of the sl"
 & "ider \"a\", \"b\", \n   \"c\". *)\n\nPRED OnSemi(a, b, c, c0, c1, p) IS"
 & " \n  OnCircle0(a, b, c, c0, c1, p, -Math.Pi) \nEND;\n\nPRED OnSemiCC(a,"
 & " b, c, c0, c1, p) IS \n  OnCircle0(a, b, c, c0, c1, p, Math.Pi) \nEND;\n"
 & "\nUI PointTool(OnSemi);\n\nUI PointTool(OnSemiCC);\n\n(* The point \"p\""
 & " is on the semi-circle with center \"c0\" and \n   radius point \"c1\"."
 & " Its position around the semi-circle \n   measured in the clockwise and"
 & " counter-clockwise direction, \n   respectfully, from \"c1\" is proport"
 & "ional to the value of the \n   slider \"a\", \"b\", \"c\". *)\n\nPRED O"
 & "nQuarter(a, b, c, c0, c1, p) IS \n  OnCircle0(a, b, c, c0, c1, p, -Math"
 & ".Pi / 2) \nEND;\n\nPRED OnQuarterCC(a, b, c, c0, c1, p) IS \n  OnCircle"
 & "0(a, b, c, c0, c1, p, Math.Pi / 2) \nEND;\n\nUI PointTool(OnQuarter);\n"
 & "\nUI PointTool(OnQuarterCC);\n\n(* The point \"p\" is on the quarter-ci"
 & "rcle with center \"c0\" and \n   radius point \"c1\". Its position arou"
 & "nd the quarter-circle \n   measured in the clockwise and counter-clockw"
 & "ise direction, \n   respectfully, from \"c1\" is proportional to the va"
 & "lue of the \n   slider \"a\", \"b\", \"c\". *)\n\nPRED OnArc(a, b, c, a"
 & "1, a2, a3, p) IS \n  OnCircle0(a, b, c, a2, a1, p, Angle.CC(a1, a2, a3)"
 & ") \nEND;\n\nUI PointTool(OnArc);\n\n(* The point \"p\" is on the direct"
 & "ed circular arc with center \n   \"a2\", starting at \"a1\" and ending "
 & "at the line through \"a1\" \n   and \"a3\". The position of \"p\" along"
 & " the arc is proportional \n   to the value of the slider \"a\", \"b\", "
 & "\"c\". *)\n\nPRED AtAngle1(a, b, c, p, q, max) IS \n  (E t = Value(a, b"
 & ", c), delta = R2.Minus(q, p), dx, dy :: \n    delta = (dx, dy) AND t * "
 & "max = ATAN(dy, dx)) \nEND;\n\n(* The ray \"pq\" forms an angle in the i"
 & "nterval \"[0, max]\" to the \n   horizontal. The angle in that interv";

CONST E37_3 = 
   "al is proportional to the \n   value of the slider \"a\", \"b\", \"c\"."
 & " *)\n\nPRED AtAngle2(a, b, c, p, q, min, max) IS \n  (E t = Value(a, b,"
 & " c), t2 = t * (max - min) + min, \n     delta = R2.Minus(q, p), dx, dy "
 & ":: \n    delta = (dx, dy) AND t2 = ATAN(dy, dx)) \nEND;\n\n(* The ray \""
 & "pq\" forms an angle in the interval \"[min, max]\" to \n   the horizont"
 & "al. The angle in that interval is proportional to \n   the value of the"
 & " slider \"a\", \"b\", \"c\". *)\n\n(* \\section{Saving/Restoring State}"
 & " *)\n\nPRIVATE VAR history := NIL;\n\nPROC Save() IS history := ((visib"
 & "ility, valueVis), history) END;\n\nPROC Restore() IS \n  VAR head IN \n"
 & "    head := CAR(history); \n    visibility := CAR(head); \n    valueVis"
 & " := CDR(head) \n  END; \n  history := CDR(history) \nEND;\n\nUI PointTo"
 & "ol(Save);\n\nUI PointTool(Restore);\n\n(* Save/restore the current modu"
 & "le state. *)\n\n";

CONST E38 = 
   "% Inserted file: juno-app/src/rsrc/prologue.ps\n% Last modified on Mon "
 & "Oct  9 14:16:28 PDT 1995 by heydon\n\n% The following procedures are us"
 & "ed to lazily redefine fonts to have\n% an ISOLatin1 encoding. This file"
 & " should be inserted in the Prologue\n% section of the PostScript file t"
 & "hat adheres to the DSC.\n\n% Of these procedures, the only one that sho"
 & "uld be used in the body of\n% a document is \"FindFontISO\", which look"
 & "s up the ISOLatin1-encoded\n% version of a font, and lazily creates the"
 & " ISOLatin1-encoded version\n% if it was not defined in the \"FontDirect"
 & "ory\".\n\n% ISOLatin1\n%\n% This defines the ISOLatin1 encoding vector,"
 & " which is defined under\n% the name \"ISOLatin1Encoding\" in Level-2 Po"
 & "stScript, but is defined\n% here for Level-1 compatibility. See Appendi"
 & "ces E.5 and E.7 of the\n% \"PostScript Language Reference Manual\", Sec"
 & "ond Edition.\n%\n/ISOLatin1 [\n/.notdef /.notdef /.notdef /.notdef /.no"
 & "tdef /.notdef /.notdef /.notdef\n/.notdef /.notdef /.notdef /.notdef /."
 & "notdef /.notdef /.notdef /.notdef\n/.notdef /.notdef /.notdef /.notdef "
 & "/.notdef /.notdef /.notdef /.notdef\n/.notdef /.notdef /.notdef /.notde"
 & "f /.notdef /.notdef /.notdef /.notdef\n/space /exclam /quotedbl /number"
 & "sign /dollar /percent /ampersand /quoteright\n/parenleft /parenright /a"
 & "sterisk /plus /comma /minus /period /slash\n/zero /one /two /three /fou"
 & "r /five /six /seven\n/eight /nine /colon /semicolon /less /equal /great"
 & "er /question\n/at /A /B /C /D /E /F /G\n/H /I /J /K /L /M /N /O\n/P /Q "
 & "/R /S /T /U /V /W\n/X /Y /Z /bracketleft /backslash /bracketright /asci"
 & "icircum /underscore\n/quoteleft /a /b /c /d /e /f /g\n/h /i /j /k /l /m"
 & " /n /o\n/p /q /r /s /t /u /v /w\n/x /y /z /braceleft /bar /braceright /"
 & "asciitilde /.notdef\n/.notdef /.notdef /.notdef /.notdef /.notdef /.not"
 & "def /.notdef /.notdef\n/.notdef /.notdef /.notdef /.notdef /.notdef /.n"
 & "otdef /.notdef /.notdef\n/dotlessi /grave /acute /circumflex /tilde /ma"
 & "cron /breve /dotaccent\n/dieresis /.notdef /ring /cedilla /.notdef /hun"
 & "garumlaut /ogonek /caron\n/space /exclamdown /cent /sterling";

CONST E38_0 = 
   " /currency /yen /brokenbar /section\n/dieresis /copyright /ordfeminine "
 & "/guillemotleft /logicalnot /hyphen\n  /registered /macron\n/degree /plu"
 & "sminus /twosuperior /threesuperior /acute /mu /paragraph\n  /periodcent"
 & "ered\n/cedilla /onesuperior /ordmasculine /guillemotright /onequarter /"
 & "onehalf\n  /threequarters /questiondown\n/Agrave /Aacute /Acircumflex /"
 & "Atilde /Adieresis /Aring /AE /Ccedilla\n/Egrave /Eacute /Ecircumflex /E"
 & "dieresis /Igrave /Iacute /Icircumflex /Idieresis\n/Eth /Ntilde /Ograve "
 & "/Oacute /Ocircumflex /Otilde /Odieresis /multiply\n/Oslash /Ugrave /Uac"
 & "ute /Ucircumflex /Udieresis /Yacute /Thorn /germandbls\n/agrave /aacute"
 & " /acircumflex /atilde /adieresis /aring /ae /ccedilla\n/egrave /eacute "
 & "/ecircumflex /edieresis /igrave /iacute /icircumflex /idieresis\n/eth /"
 & "ntilde /ograve /oacute /ocircumflex /otilde /odieresis /divide\n/oslash"
 & " /ugrave /uacute /ucircumflex /udieresis /yacute /thorn /ydieresis \n] "
 & "def\n\n% name AppendISO name\n%\n% The result name is the same as the a"
 & "rgument name, but with the\n% string \"-ISO\" appended.\n%\n/AppendISO "
 & "{\n  1 dict begin\n    dup /bigstr exch length 4 add string def\n    du"
 & "p bigstr cvs pop\n    bigstr exch length (-ISO) putinterval\n    bigstr"
 & " cvn\n  end\n} def\n\n% fontname MakeISOLatin1Font -\n%\n% Looks up the"
 & " font \"fontname\", creates a new font identical to it but\n% with the "
 & "ISOLatin1 encoding, and binds the font to the name \"fontname\"\n% conc"
 & "atenated with the string \"-ISO\".\n%\n/MakeISOLatin1Font {\ndup findfo"
 & "nt\ndup length dict begin\n  {1 index /FID ne {def} {pop pop} ifelse} f"
 & "orall\n  /Encoding ISOLatin1 def\n  currentdict\nend\nexch AppendISO ex"
 & "ch\ndefinefont pop\n} def\n\n% fontname FindFontISO font\n%\n% Looks up"
 & " the font with the name \"fontname\" concatenated with the\n% string \""
 & "-ISO\". If that font is not found, it is created from the\n% font named"
 & " \"fontname\" using the \"MakeISOLatin1Font\" operator above.\n% If \"f"
 & "ontname\" is \"Symbol\", then this is equivalent to \"findfont\",\n% si"
 & "nce the Symbol font on X uses the standard encoding.\n%\n/FindFontISO {"
 & "\n  dup /Symbol ne\n ";

CONST E38_1 = 
   " { dup FontDirectory exch AppendISO known not\n    { dup MakeISOLatin1F"
 & "ont } if\n    AppendISO\n  } if\n  findfont\n} def\n\n% end prologue.ps"
 & "\n";

CONST E39 = 
   "MODULE List;\n\n(* Procedures for manipulating lists *)\n\n(* A value \""
 & "l\" is a list if \"l\" is either NIL or a \n   pair whose CDR is a list"
 & ". A value \"l\" is a proper \n   list if \"l\" is a list other than NIL"
 & ". *)\n\nPROC res := Member(x, l) IS \n  DO l # NIL AND x # CAR(l) -> l "
 & ":= CDR(l) OD; \n  IF l = NIL -> res := NIL | res := x FI \nEND;\n\n(* R"
 & "eturns \"x\" if \"x\" appears as a top-level element \n   of the list \""
 & "l\", and \"NIL\" otherwise. *)\n\nPROC res := Length(l) IS \n  res := 0"
 & "; \n  DO l # NIL -> res := res + 1; l := CDR(l) OD \nEND;\n\n(* Return "
 & "the number of elements of \"l\". If \"l\" is \n   NIL, return 0. A chec"
 & "ked run-time error occurs if \n   \"l\" is not a list. *)\n\nPROC res :"
 & "= Nth(l, n) IS \n  IF \n    n >= 0 -> \n      DO n > 0 -> n := n - 1; l"
 & " := CDR(l) OD; \n      res := CAR(l) \n  FI \nEND;\n\n(* Return the \"n"
 & "\"th element of \"l\", where the first \n   element is numbered zero. A"
 & " checked run-time error \n   occurs if \"l\" is not a proper list or if"
 & " \"n\" is not \n   in the range [0, Length(l)). *)\n\nPROC res := Last("
 & "l) IS \n  DO CDR(l) # NIL -> l := CDR(l) OD; res := CAR(l) \nEND;\n\n(*"
 & " Return the last element of \"l\". A checked run-time \n   error occurs"
 & " if \"l\" is not a proper list. *)\n\nPROC res := Prefix(l, num) IS \n "
 & " IF \n    num <= 0 OR l = NIL -> res := NIL \n  | res := (CAR(l), Prefi"
 & "x(CDR(l), num - 1)) \n  FI \nEND;\n\n(* Return a list of the first \"nu"
 & "m\" elements of \"l\". \n   If \"num <= 0\", return \"NIL\". If \"num >"
 & "= Length(l)\", \n   return (a copy of) \"l\". *)\n\nPROC res := Suffix("
 & "l, num) IS \n  res := SuffixFrom(l, Length(l) - num) \nEND;\n\n(* Retur"
 & "n a list of the last \"num\" elements of \"l\". If \n   \"num <= 0\", r"
 & "eturn \"NIL\". If \"num >= Length(l)\", \n   return \"l\". *)\n\nPROC r"
 & "es := SuffixFrom(l, i) IS \n  DO i > 0 AND l # NIL -> i := i - 1; l := "
 & "CDR(l) OD; \n  res := l \nEND;\n\n(* Return the longest suffix of \"l\""
 & " that does not \n   include its first \"i\" elements. If \"i <= 0\", re"
 & "turn \n   \"l\". If \"i >= Length(l)\", return \"NIL\". *)\n\nPROC res "
 & ":= Reverse(l) IS \n  res := NIL; \n  DO \n    VAR u, v IN \n      l = ("
 & "u, v) -> res :=";

CONST E39_0 = 
   " (u, res); l := v \n    END \n  OD \nEND;\n\n(* Return the list contain"
 & "ing the elements of \"l\" in \n   reverse order. If \"l\" is not a pair"
 & ", return NIL. *)\n\nPROC res := Sum(l) IS \n  res := 0; \n  DO l # NIL "
 & "-> res := res + CAR(l); l := CDR(l) OD \nEND;\n\n(* Return the sum of t"
 & "he elements of \"l\". If \"l\" is \n   NIL, return 0. A checked run-tim"
 & "e error occurs if \n   \"l\" is not a list of numbers. *)\n\n";

CONST E40 = 
   "MODULE Xform2;\n\n(* Procedures for transforming 2-D points. *)\n\nIMPO"
 & "RT R2;\n\n(* \\subsection{Point Transformations} *)\n\n(* The following"
 & " procedures transform 2-D points \n   into 2-D points. *)\n\nPROC res :"
 & "= Translate(q, p) IS \n  res := R2.Plus(p, q) \nEND;\n\n(* \"res\" is t"
 & "he point \"p\" translated by the vector \n   \"q\". *)\n\nPROC res := S"
 & "cale(scale, p) IS \n  IF \n    VAR sx, sy, px, py IN \n      scale = (s"
 & "x, sy) AND p = (px, py) -> \n        res := (sx * px, sy * py) \n    EN"
 & "D \n  FI \nEND;\n\n(* \"res\" is the point \"p\" scaled about the origi"
 & "n \n   by the scale factor \"scale\", which must be a \n   pair of real"
 & " numbers representing the x- and \n   y-scale factors. *)\n\nPROC res :"
 & "= Rotate(theta, p) IS \n  IF \n    VAR px, py, cos = COS(theta), sin = "
 & "SIN(theta) IN \n      p = (px, py) -> \n        res := \n          (cos"
 & " * px - sin * py, \n           sin * px + cos * py) \n    END \n  FI \n"
 & "END;\n\n(* \"res\" is the point \"p\" rotated by \"theta\" \n   radians"
 & " about the origin. *)\n\n(* \\subsection{Transformation Closures} *)\n\n"
 & "(* The following procedures produce closures that \n   transform 2-D po"
 & "ints into 2-D points. There is \n   also a procedure for composing clos"
 & "ures \n   functionally. \n\n   In the comments for the following proced"
 & "ures, \n   we write \"cl(p)\" as a shorthand for \"APPLY(cl, \n   p)\","
 & " where \"cl\" denotes a closure with one IN \n   parameter and one OUT "
 & "parameter. *)\n\nPROC cl := TranslateCl(q) IS \n  cl := CLOSE(Translate"
 & ", q) \nEND;\n\n(* \"cl\" is a closure such that \"cl(p)\" evaluates \n "
 & "  to \"Translate(q, p)\". *)\n\nPROC cl := ScaleCl(scale) IS \n  cl := "
 & "CLOSE(Scale, scale) \nEND;\n\n(* \"cl\" is a closure such that \"cl(p)\""
 & " evaluates \n   to \"Scale(scale, p)\". *)\n\nPROC cl := RotateCl(theta"
 & ") IS \n  cl := CLOSE(Rotate, theta) \nEND;\n\n(* \"cl\" is a closure su"
 & "ch that \"cl(p)\" evaluates \n   to \"Rotate(theta, p)\". *)\n\nPRIVATE"
 & " PROC res := ComposeClsProc(cl2, cl1, p) IS \n  res := APPLY(cl2, APPLY"
 & "(cl1, p)) \nEND;\n\nPROC cl := ComposeCls(cl2, cl1) IS \n  cl := CLOSE("
 & "ComposeClsProc, cl2, cl1) \nEND;\n\n(* Set \"cl\" to a closure such tha"
 & "t";

CONST E40_0 = 
   " \"cl(p)\" is \n   equivalent to \"cl2(cl1(p))\". *)\n\n";

CONST E41 = 
   "MODULE R2;\n\nIMPORT Math;\n\n(* Arithmetic functions on 2D real \n   v"
 & "ectors.\n\n   See also: \"C\", \"Math\". *)\n\nCONST Origin = (0,0);\n\n"
 & "(* \"Origin\" is the origin in 2-space. *)\n\nPRED AtOrigin(p) IS\n  p "
 & "= Origin\nEND;\n\nUI PointTool(AtOrigin);\n\n(* The point \"p\" is at t"
 & "he origin. The Juno-2 application\n   arranges that the origin of the J"
 & "uno coordinate system\n   is always in the center of the drawing view, "
 & "and always\n   at the center of a printed page. *)\n\nFUNC r = Plus(p, "
 & "q) IS \n  (E px, py, qx, qy :: \n    p = (px, py) AND \n    q = (qx, qy"
 & ") AND \n    r = (px + qx, py + qy)) \nEND;\n\n(* \"r\" is the vector su"
 & "m \"p\" + \"q\". \n*)\n\nFUNC r = PlusX(p, x) IS\n  (E px, py ::\n    p"
 & " = (px, py) AND\n    r = (px + x, py))\nEND;\n\n(* Equivalent to \"r = "
 & "Plus(p, (x, 0))\". *)\n\nFUNC r = PlusY(p, y) IS\n  (E px, py ::\n    p"
 & " = (px, py) AND\n    r = (px, py + y))\nEND;\n\n(* Equivalent to \"r = "
 & "Plus(p, (0, y))\". *)\n\nFUNC r = Minus(p, q) IS \n  (E px, py, qx, qy "
 & ":: \n    p = (px, py) AND \n    q = (qx, qy) AND \n    r = (px - qx, py"
 & " - qy)) \nEND;\n\n(* \"r\" is the vector difference \"p\" \n   - \"q\"."
 & " *)\n\nFUNC r = MinusX(p, x) IS\n  (E px, py ::\n    p = (px, py) AND\n"
 & "    r = (px - x, py))\nEND;\n\n(* Equivalent to \"r = Minus(p, (x, 0))\""
 & ". *)\n\nFUNC r = MinusY(p, y) IS\n  (E px, py ::\n    p = (px, py) AND\n"
 & "    r = (px, py - y))\nEND;\n\n(* Equivalent to \"r = Minus(p, (0, y))\""
 & ". *)\n\nFUNC p = Times(t, q) IS \n  (E px, py, qx, qy :: \n    p = (px,"
 & " py) AND \n    q = (qx, qy) AND \n    px = t * qx AND \n    py = t * qy"
 & ") \nEND;\n\n(* \"p\" is the product of the scalar \n   \"t\" and the ve"
 & "ctor \"q\". *)\n\nFUNC len2 = Length2(v) IS \n  (E vx, vy :: \n    v = "
 & "(vx, vy) AND \n    len2 = (vx * vx) + (vy * vy))\nEND;\n\n(* \"len2\" i"
 & "s the square of the Euclidean\n   length of the vector \"v\". *)\n\nFUN"
 & "C len = Length(v) IS \n  len = Math.Sqrt(Length2(v))\nEND;\n\n(* \"len\""
 & " is the Euclidean length of the\n   vector \"v\". *)\n\nFUNC u = Normal"
 & "ize(v) IS\n  Times(Length(v), u) = v\nEND;\n\n(* \"u\" is the vector \""
 & "v\" normalized\n   to have unit length. *)\n\nFUNC t = Dot(p, q) IS \n "
 & " (E px, py, qx, qy :: ";

CONST E41_0 = 
   "\n    p = (px, py) AND \n    q = (qx, qy) AND \n    t = px * qx + py * "
 & "qy) \nEND;\n\n(* The scalar \"t\" is the \n   dot-product of \"p\" and "
 & "\"q\". *)\n\nFUNC t = Det(p, q) IS \n  (E px, py, qx, qy :: \n    p = ("
 & "px, py) AND \n    q = (qx, qy) AND \n    t = px * qy - py * qx) \nEND;\n"
 & "\n(* The scalar \"t\" is the \n   determinant of the 2x2 matrix \n   \""
 & "(p q)\", where \"p\" and \"q\" are \n   column vectors. *)\n\n";

CONST E42 = 
   "; Copyright (C) 1992, Digital Equipment Corporation                    "
 & "     \n; All rights reserved.                                          "
 & "            \n; See the file COPYRIGHT for a full description.         "
 & "                   \n;                                                 "
 & "                          \n; Last modified on Mon Oct  3 11:00:21 PDT "
 & "1994 by heydon                   \n\n(Rim (Pen 5)\n  (Macro Gap () \'(G"
 & "lue 5))\n  (Shape\n    (Height2 300)\n    (Width2 80)\n    (VBox\n     "
 & " (Border\n        (Browser %moduleBrowser\n          (MyBrowserFont)\n "
 & "         (BgColor \"White\")\n        )\n      )\n    )\n  )\n)\n";

CONST E43 = 
   "MODULE Curve;\n\n(* Define curves by sequences of points. *)\n\nIMPORT "
 & "List, R2, Bezier, Geometry, PS;\n\n/* The implementation of the \"Fit\""
 & " procedure was \n   taken from the book \"Graphic Gems\", edited by \n "
 & "  Andrew S. Glassner and published by AP \n   Professional, New York, 1"
 & "990. The algorithm is \n   described in the section \"An Algorithm for "
 & "\n   Automatically Fitting Digitized Curves\" by Philip \n   J. Schneid"
 & "er, pp. 612-626. */\n\nCONST DefaultErrorBound = 20;\n\n(* This module "
 & "maintains a current error bound, \n   which is used by the \"Fit\" (and"
 & " hence the \n   \"EndPoints\") procedures below. *)\n\nPRIVATE VAR erro"
 & "rBound := DefaultErrorBound;\n\nPRIVATE CONST MinErrorBound = 1;\n\n/* "
 & "A lower bound on the minimum allowed error bound. \n*/\n\nPROC SetError"
 & "Bound(errBnd) IS \n  IF \n    errBnd < MinErrorBound -> errBnd := MinEr"
 & "rorBound \n  | SKIP \n  FI; \n  errorBound := errBnd \nEND;\n\nUI SetTo"
 & "ol(SetErrorBound);\n\n(* Set the current error bound to \"errBnd\". *)\n"
 & "\nUI Param(SetErrorBound, DefaultErrorBound);\n\nUI Param(SetErrorBound"
 & ", 5);\n\nUI Param(SetErrorBound, 10);\n\nUI Param(SetErrorBound, 20);\n"
 & "\nUI Param(SetErrorBound, 50);\n\nUI Param(SetErrorBound, 100);\n\nUI P"
 & "aram(SetErrorBound, 200);\n\nUI Param(SetErrorBound, 500);\n\nPRIVATE C"
 & "ONST MaxIterations = 1, False = 0, True = 1;\n\n/* MISCELLANEOUS FUNCTI"
 & "ONS */\n\nPRIVATE FUNC ie = IterationError(error) IS \n  ie = 5 * error"
 & " \nEND;\n\nPRIVATE PROC v:Inc(x) IS v := v + x END;\n\nPRIVATE FUNC res"
 & " = Sum3(a, b, c) IS \n  res = R2.Plus(a, R2.Plus(b, c)) \nEND;\n\nPRIVA"
 & "TE FUNC res = Sum4(a, b, c, d) IS \n  res = R2.Plus(a, R2.Plus(b, R2.Pl"
 & "us(c, d))) \nEND;\n\nPRIVATE PROC res := B0(t) IS \n  VAR x IN x := 1 -"
 & " t; res := x * x * x END \nEND;\n\nPRIVATE PROC res := B1(t) IS \n  VAR"
 & " x IN x := 1 - t; res := 3 * t * x * x END \nEND;\n\nPRIVATE PROC res :"
 & "= B2(t) IS \n  res := 3 * t * t * (1 - t) \nEND;\n\nPRIVATE PROC res :="
 & " B3(t) IS res := t * t * t END;\n\n/* ROUTINES FOR OPTIMIZING TIMESTAMP"
 & "S */\n\nPRIVATE PROC res := ImproveTimeStamp(pt, bez, ts) IS \n  IF \n "
 & "   VAR a, b, c, d, p1, p2, p3 IN \n      bez";

CONST E43_0 = 
   " = [a, b, c, d] AND \n      Bezier.MapRep(a, b, c, d, p1, p2, p3) -> \n"
 & "        IF \n          VAR tsPrime ~ ts IN \n            0 = \n        "
 & "      R2.Dot(R2.Minus(pt, \n                              Bezier.AtTFro"
 & "mCoeffs(a, \n                                                   p1, \n "
 & "                                                  p2, \n               "
 & "                                    p3, \n                             "
 & "                      tsPrime)), \n                     Bezier.PrimeAtT"
 & "FromCoeffs(a, \n                                               p1, \n  "
 & "                                             p2, \n                    "
 & "                           p3, \n                                      "
 & "         tsPrime)) -> \n              res := tsPrime \n          END \n"
 & "        FI \n    END \n  FI \nEND;\n\nPRIVATE PROC res := Reparameteriz"
 & "e(pts, ts, bez) IS \n  res := NIL; \n  DO \n    pts # NIL -> \n      re"
 & "s := \n        (ImproveTimeStamp(CAR(pts), bez, CAR(ts)), \n         re"
 & "s); \n      pts, ts := CDR(pts), CDR(ts) \n  OD; \n  res := List.Revers"
 & "e(res) \nEND;\n\n/* ROUTINES FOR DOING RECURSIVE SPLIT */\n\nPRIVATE PR"
 & "OC \n  res := ComputeCenterTangent(pts, middle) IS \n  pts := List.Suff"
 & "ixFrom(pts, middle - 1); \n  res := \n    R2.Normalize(R2.Minus(CAR(pts"
 & "), List.Nth(pts, 2))) \nEND;\n\n/* Requires \"3 <= List.Length(pts)\" a"
 & "nd \"1 <= middle \n   < List.Length(pts) -1\" */\n\nPRIVATE PROC l, r :"
 & "= Split(pts, middle) IS \n  l := List.Prefix(pts, middle + 1); \n  r :="
 & " List.SuffixFrom(pts, middle) \nEND;\n\n/* BASIC ROUTINES */\n\nPRIVATE"
 & " PROC AppendBezier(bez) IS \n  IF \n    VAR p0, p1, p2, p3 IN \n      b"
 & "ez = [p0, p1, p2, p3] -> \n        PS.CurveTo(p1, p2, p3) \n    END \n "
 & " FI \nEND;\n\n/* Requires \"2 <= List.Size(pts)\" */\n\nPRIVATE PROC \n"
 & "  bez := BezHeuristic(pts, tHat1, tHat2) IS \n  VAR dist IN \n    dist "
 & ":= \n      Geometry.Dist(CAR(pts), List.Last(pts)) / 3; \n    bez := Be"
 & "zCurve(pts, tHat1, tHat2, dist, dist) \n  END \nEND;\n\n/* Requires \"2"
 & " <= List.Size(pts)\" */\n\nPRIVATE PROC ts := ChordLengthTimeStamps(pts"
 & ") IS \n  VAR dists = [0], ";

CONST E43_1 = 
   "prev IN \n    prev, pts := CAR(pts), CDR(pts); \n    DO \n      pts # N"
 & "IL -> \n        dists := \n          (CAR(dists) + Geometry.Dist(prev, "
 & "CAR(pts)), \n           dists); \n        prev, pts := CAR(pts), CDR(pt"
 & "s) \n    OD; \n    VAR sum IN \n      sum := CAR(dists); \n      ts := "
 & "NIL; \n      DO \n        dists # NIL -> \n          ts := (CAR(dists) "
 & "/ sum, ts); \n          dists := CDR(dists) \n      OD \n    END \n  EN"
 & "D \nEND;\n\n/* Set \"ts\" to a list of the approximate timestamps \n   "
 & "for the list points \"pts\". The timestamps are \n   monotonically incr"
 & "easing in the interval [0, 1]. \n*/\n\nPRIVATE PROC \n  a1, a2 := Compu"
 & "teMagnitudesA(ts, tHat1, tHat2) IS \n  a1, a2, ts := NIL, NIL, List.Rev"
 & "erse(ts); \n  DO \n    ts # NIL -> \n      a1 := (R2.Times(B1(CAR(ts)),"
 & " tHat1), a1); \n      a2 := (R2.Times(B2(CAR(ts)), tHat2), a2); \n     "
 & " ts := CDR(ts) \n  OD \nEND;\n\nPRIVATE PROC \n  c00, c01, c10, c11, x0"
 & ", x1 := \n    ComputeMagnitudesCX(pts, ts, tHat1, tHat2) IS \n  VAR a1,"
 & " a2, ptFirst, ptLast IN \n    a1, a2 := ComputeMagnitudesA(ts, tHat1, t"
 & "Hat2); \n    ptFirst, ptLast := CAR(pts), List.Last(pts); \n    c00, c0"
 & "1, c10, c11, x0, x1 := 0, 0, 0, 0, 0, 0; \n    DO \n      pts # NIL -> "
 & "\n        c00:Inc(R2.Dot(CAR(a1), CAR(a1))); \n        VAR k IN \n     "
 & "     k := R2.Dot(CAR(a1), CAR(a2)); \n          c01:Inc(k); \n         "
 & " c10:Inc(k) \n        END; \n        c11:Inc(R2.Dot(CAR(a2), CAR(a2)));"
 & " \n        VAR v IN \n          v := \n            R2.Minus(CAR(pts), \n"
 & "                     Sum4(R2.Times(B0(CAR(ts)), \n                     "
 & "              ptFirst), \n                          R2.Times(B1(CAR(ts)"
 & "), \n                                   ptFirst), \n                   "
 & "       R2.Times(B2(CAR(ts)), \n                                   ptLas"
 & "t), \n                          R2.Times(B3(CAR(ts)), \n               "
 & "                    ptLast))); \n          x0:Inc(R2.Dot(CAR(a1), v)); "
 & "\n          x1:Inc(R2.Dot(CAR(a2), v)) \n        END; \n        pts, ts"
 & " := CDR(pts), CDR(ts); \n        a1, a2 := CDR(a1), CDR(a2) \n    OD \n"
 & "  END \nEND;\n\nP";

CONST E43_2 = 
   "RIVATE PROC \n  detc0c1, detc0x, detxc1 := \n    ComputeDeterminants(pt"
 & "s, ts, tHat1, tHat2) IS \n  VAR c00, c01, c10, c11, x0, x1 IN \n    c00"
 & ", c01, c10, c11, x0, x1 := \n      ComputeMagnitudesCX(pts, ts, tHat1, "
 & "tHat2); \n    detc0c1 := c00 * c11 - c10 * c01; \n    detc0x := c00 * x"
 & "1 - c01 * x0; \n    detxc1 := x0 * c11 - x1 * c01; \n    IF \n      det"
 & "c0c1 = 0 -> detc0c1 := c00 * c11 * 1e-11 \n    | SKIP \n    FI \n  END "
 & "\nEND;\n\nPRIVATE PROC \n  l, r := ComputeMagnitudes(pts, ts, tHat1, tH"
 & "at2) IS \n  VAR detc0c1, detc0x, detxc1 IN \n    detc0c1, detc0x, detxc"
 & "1 := \n      ComputeDeterminants(pts, ts, tHat1, tHat2); \n    l := det"
 & "xc1 / detc0c1; \n    r := detc0x / detc0c1 \n  END \nEND;\n\nPRIVATE PR"
 & "OC \n  bez := BezCurve(pts, tHat1, tHat2, d1, d2) IS \n  VAR p0, p3 IN "
 & "\n    p0, p3 := CAR(pts), List.Last(pts); \n    bez := \n      [p0, R2."
 & "Plus(p0, R2.Times(d1, tHat1)), \n       R2.Plus(p3, R2.Times(d2, tHat2)"
 & "), p3] \n  END \nEND;\n\nPRIVATE PROC \n  bez := GenerateBezier(pts, ts"
 & ", tHat1, tHat2) IS \n  VAR alphaL, alphaR IN \n    alphaL, alphaR := \n"
 & "      ComputeMagnitudes(pts, ts, tHat1, tHat2); \n    IF \n      alphaL"
 & " < 0 OR alphaR < 0 -> \n        bez := BezHeuristic(pts, tHat1, tHat2) "
 & "\n    | bez := \n        BezCurve(pts, tHat1, tHat2, alphaL, alphaR) \n"
 & "    FI \n  END \nEND;\n\nPRIVATE PROC cl := BezClosure(bez) IS \n  IF \n"
 & "    VAR p0, p1, p2, p3 IN \n      bez = [p0, p1, p2, p3] -> \n        c"
 & "l := Bezier.Closure(p0, p1, p2, p3) \n    END \n  FI \nEND;\n\nPRIVATE "
 & "PROC \n  maxError, splitPoint := \n    ComputeMaxError(pts, bez, ts) IS"
 & " \n  VAR cl, dist, i, point IN \n    cl := BezClosure(bez); \n    pts, "
 & "ts, i := CDR(pts), CDR(ts), 1; \n    maxError := 0; \n    DO \n      CD"
 & "R(pts) # NIL -> \n        point := APPLY(cl, CAR(ts)); \n        dist :"
 & "= Geometry.Dist2(CAR(pts), point); \n        IF \n          maxError <="
 & " dist -> \n            maxError, splitPoint := dist, i | SKIP \n       "
 & " FI; \n        pts, ts, i := CDR(pts), CDR(ts), i + 1 \n    OD \n  END "
 & "\nEND;\n\n/* Requires \"3 <= List.Length(pts)\" and \n   \"List.Length("
 & "pts) = List.Length(ts)\"";

CONST E43_3 = 
   " */\n\nPRIVATE PROC \n  DrawCubicMany(pts, tHat1, tHat2, error) IS \n  "
 & "VAR ts, bez, maxError, splitPoint, i, done = False IN \n    ts := Chord"
 & "LengthTimeStamps(pts); \n    bez := GenerateBezier(pts, ts, tHat1, tHat"
 & "2); \n    maxError, splitPoint := \n      ComputeMaxError(pts, bez, ts)"
 & "; \n    IF \n      maxError < error -> \n        AppendBezier(bez); don"
 & "e := True \n    | maxError < IterationError(error) -> \n        i := 0;"
 & " \n        DO \n          done = False AND i < MaxIterations -> \n     "
 & "       ts := Reparameterize(pts, ts, bez); \n            bez := \n     "
 & "         GenerateBezier(pts, ts, tHat1, tHat2); \n            maxError,"
 & " splitPoint := \n              ComputeMaxError(pts, bez, ts); \n       "
 & "     IF \n              maxError < error -> \n                AppendBez"
 & "ier(bez); done := True \n            | i := i + 1 \n            FI \n  "
 & "      OD | SKIP \n    FI; \n    IF \n      done = False -> \n        VA"
 & "R \n          tHatCenter \n        = ComputeCenterTangent(pts, splitPoi"
 & "nt), \n          leftPts, rightPts \n        IN \n          leftPts, ri"
 & "ghtPts := Split(pts, splitPoint); \n          DrawCubic(leftPts, tHat1,"
 & " tHatCenter, error); \n          tHatCenter := R2.Times(-1, tHatCenter)"
 & "; \n          DrawCubic(rightPts, tHatCenter, tHat2, \n                "
 & "    error) \n        END | SKIP \n    FI \n  END \nEND;\n\nPRIVATE PROC"
 & " res := ComputeLeftTangent(pts) IS \n  res := \n    R2.Normalize(R2.Min"
 & "us(List.Nth(pts, 1), \n                          List.Nth(pts, 0))) \nE"
 & "ND;\n\n/* Requires \"2 <= List.Size(pts)\" */\n\nPRIVATE PROC res := Co"
 & "mputeRightTangent(pts) IS \n  res := ComputeLeftTangent(List.Reverse(pt"
 & "s)) \nEND;\n\n/* Requires \"2 <= List.Size(pts)\" */\n\nPRIVATE PROC Dr"
 & "awCubic(pts, tHat1, tHat2, error) IS \n  IF \n    List.Length(pts) = 2 "
 & "-> \n      AppendBezier(BezHeuristic(pts, tHat1, tHat2)) \n  | DrawCubi"
 & "cMany(pts, tHat1, tHat2, error) \n  FI \nEND;\n\nPROC FitPointList(pts)"
 & " IS \n  VAR len IN \n    len := List.Length(pts); \n    PS.MoveTo(CAR(p"
 & "ts)); \n    IF \n      len = 1 -> SKIP \n    | len = 2 -> PS.LineTo(CAR"
 & "(CDR(pts))) \n    |";

CONST E43_4 = 
   " len > 2 -> \n        DrawCubic(pts, ComputeLeftTangent(pts), \n       "
 & "           ComputeRightTangent(pts), \n                  errorBound) \n"
 & "    FI \n  END \nEND;\n\n(* Augment the current path with a sequence of"
 & " \n   connected Bezier curves that approximate the \n   points in the n"
 & "onempty list \"pts\". The sum of the \n   squared distances of the give"
 & "n points to the \n   constructed curve is at most the current error \n "
 & "  bound. *)\n\nPRIVATE VAR ptList := NIL;\n\n/* The list of points augm"
 & "ented, used, and reset by \n   the \"AddPoint\" and \"FitPoints\" proce"
 & "dures. */\n\n(* This module maintains a list of points, initially \n   "
 & "empty. Use the \"AddPoint\" procedure to append a \n   point to the lis"
 & "t, and the \"FitPoints\" procedure \n   to draw a curve through the poi"
 & "nts. *)\n\nPROC AddPoint(p) IS ptList := (p, ptList) END;\n\nUI PointTo"
 & "ol(AddPoint);\n\n(* Add the point \"p\" to the current list of points. "
 & "\n*)\n\nPROC FitPoints() IS \n  FitPointList(List.Reverse(ptList)); ptL"
 & "ist := NIL \nEND;\n\nUI PointTool(FitPoints);\n\n(* Equivalent to \"Fit"
 & "PointList(l)\", where \"l\" is the \n   current list of points. On exit"
 & ", the current list \n   of points is reset to the empty list. *)\n\nPRI"
 & "VATE VAR history := NIL;\n\nPROC Save() IS \n  history := ((errorBound,"
 & " ptList), history) \nEND;\n\nPROC Restore() IS \n  IF \n    VAR hd, tl "
 & "IN \n      history = (hd, tl) -> \n        errorBound := CAR(hd); \n   "
 & "     ptList := CDR(hd); \n        history := tl \n    END \n  FI \nEND;"
 & "\n\nUI PointTool(Save);\n\nUI PointTool(Restore);\n\n(* Save/restore th"
 & "e current error bound and point \n   list. *)\n\n";

CONST E44 = 
   "MODULE Triangle;\n\n(* Procedures and predicates for \n   triangles. *)"
 & "\n\nIMPORT Math, R2, Geometry, PS, Angle;\n\nPROC Draw(a, b, c) IS \n  "
 & "IF \n    PS.MoveTo(a); \n    PS.LineTo(b); \n    PS.LineTo(c); \n    PS"
 & ".Close() \n  FI \nEND;\n\nUI PointTool(Draw);\n\n(* Add the closed tria"
 & "ngle on the \n   vertices \"a\", \"b\", and \"c\" to \n   the current p"
 & "ath. *)\n\nFUNC p = OutCenter(a, b, c) IS \n  (b, p) CONG (p, a) AND \n"
 & "  (a, p) CONG (p, c) \nEND;\n\nUI PointTool(OutCenter);\n\n(* \"p\" is "
 & "the center of the circle \n   circumscribing the triangle \n   \"abc\"."
 & " *)\n\nFUNC p = InCenter(a, b, c) IS \n  Angle.OnBisector(p, a, b, c) A"
 & "ND \n  Angle.OnBisector(p, b, a, c) \nEND;\n\nUI PointTool(InCenter);\n"
 & "\n(* \"p\" is the center of the circle \n   inscribed in the triangle \""
 & "abc\". \n*)\n\nFUNC res = Area(a, b, c) IS \n  (E ab = R2.Minus(b, a),\n"
 & "     ac = R2.Minus(c, a), \n     det = R2.Det(ab, ac) :: \n    res = Ma"
 & "th.Abs(det) / 2) \nEND;\n\n(* \"res\" is the area of the \n   triangle "
 & "\"abc\". *)\n\n";

CONST E45 = 
   "MODULE Pen;\n\nIMPORT R2, PS;\n\n(* A module for simulating strokes of "
 & "a \n   calligraphic pen. *)\n\nPRIVATE FUNC d = MidVector(p, q) IS \n  "
 & "(E px, py, qx, qy, dx, dy :: \n    p = (px, py) AND \n    q = (qx, qy) "
 & "AND \n    d = (dx, dy) AND \n    dx = (qx - px) / 2 AND \n    dy = (qy "
 & "- py) / 2) \nEND;\n\n/* \"d\" is the vector from \"p\" to the \n   midp"
 & "oint of the segment (p,q). */\n\nPRIVATE PROC Line(a, b, p, q) IS \n  I"
 & "F \n    VAR del, aL, aR, bL, bR, cL, cR, dL, dR IN \n      del = MidVec"
 & "tor(p, q) AND \n      aL = R2.Minus(a, del) AND \n      aR = R2.Plus(a,"
 & " del) AND \n      bL = R2.Minus(b, del) AND \n      bR = R2.Plus(b, del"
 & ") -> \n        PS.MoveTo(aL); \n        PS.LineTo(bL); \n        PS.Lin"
 & "eTo(bR); \n        PS.LineTo(aR); \n        PS.Close(); \n        PS.Fi"
 & "ll() \n    END \n  FI \nEND;\n\n/* Stroke the segment \"ab\" with a \n "
 & "  calligrapher\'s pen determined by the \n   segment \"pq\". */\n\nPRIV"
 & "ATE FUNC p = B3Point(t, a, b, c, d) IS \n  (E ab, bc, cd, abc, bcd :: \n"
 & "    ab = (t, 0) REL (a, b) AND \n    bc = (t, 0) REL (b, c) AND \n    c"
 & "d = (t, 0) REL (c, d) AND \n    abc = (t, 0) REL (ab, bc) AND \n    bcd"
 & " = (t, 0) REL (bc, cd) AND \n    p = (t, 0) REL (abc, bcd)) \nEND;\n\n/"
 & "* \"p\" is a point on the curve (a,b,c,d) \n   such that p = (x(t), y(t"
 & ")), where x() and \n   y() are the parametric coordinate \n   functions"
 & " of the curve. */\n\nPRIVATE PRED \n  OnSplineTan(t, a, b, c, d, p, pL,"
 & " pR) IS \n  (E ab, bc, cd :: \n    ab = (t, 0) REL (a, b) AND \n    bc "
 & "= (t, 0) REL (b, c) AND \n    cd = (t, 0) REL (c, d) AND \n    pL = (t,"
 & " 0) REL (ab, bc) AND \n    pR = (t, 0) REL (bc, cd) AND \n    p = (t, 0"
 & ") REL (pL, pR)) \nEND;\n\n/* \"p\" is the point on the spline (a,b,c,d)"
 & " \n   whose tangent is parallel to the segment \n   (pL,pR), where \"pL"
 & "\" and \"pR\" are the \n   points surrounding \"p\" in the segment \n  "
 & " construction of a point on a spline. */\n\nPRIVATE PROC \n  Notch(aL, "
 & "bL, cL, dL, aR, bR, cR, dR, p, q) IS \n  IF \n    VAR t ~ 0.5, p1, p1L,"
 & " p1R, p2 IN \n      OnSplineTan(t, aL, bL, cL, dL, p1, \n              "
 & "    p1L, p1R) AND \n      (p1L, p1R) P";

CONST E45_0 = 
   "ARA (p, q) AND \n      p2 = R2.Plus(p1, R2.Minus(q, p)) -> \n        IF"
 & " \n          0 <= t AND t <= 1 -> \n            IF \n              VAR "
 & "\n                tL ~ (1 + t) / 2, \n                tR ~ t / 2, \n   "
 & "             p0 ~ (0.5, 0) REL (p1, p2) \n              IN \n          "
 & "      p0 = \n                  B3Point(tL, aL, bL, cL, dL) AND \n      "
 & "          p0 = \n                  B3Point(tR, aR, bR, cR, dR) -> \n   "
 & "               IF \n                    0 <= tL AND \n                 "
 & "   tL <= 1 AND \n                    0 <= tR AND \n                    "
 & "tR <= 1 -> \n                      PS.MoveTo(p0); \n                   "
 & "   PS.LineTo(p1); \n                      PS.LineTo(p2); \n            "
 & "          PS.Close(); \n                      PS.Fill() | SKIP \n      "
 & "            FI | SKIP \n              END \n            FI | SKIP \n   "
 & "     FI | SKIP \n    END \n  FI \nEND;\n\nPRIVATE PROC Curve(a, b, c, d"
 & ", p, q) IS \n  IF \n    VAR del, aL, aR, bL, bR, cL, cR, dL, dR IN \n  "
 & "    del = MidVector(p, q) AND \n      aL = R2.Minus(a, del) AND \n     "
 & " aR = R2.Plus(a, del) AND \n      bL = R2.Minus(b, del) AND \n      bR "
 & "= R2.Plus(b, del) AND \n      cL = R2.Minus(c, del) AND \n      cR = R2"
 & ".Plus(c, del) AND \n      dL = R2.Minus(d, del) AND \n      dR = R2.Plu"
 & "s(d, del) -> \n        Notch(aL, bL, cL, dL, aR, bR, cR, \n            "
 & "  dR, p, q); \n        PS.MoveTo(aR); \n        PS.CurveTo(bR, cR, dR);"
 & " \n        PS.LineTo(dL); \n        PS.CurveTo(cL, bL, aL); \n        P"
 & "S.Close(); \n        PS.Fill() \n    END \n  FI \nEND;\n\n/* Stroke the"
 & " Bezier cubic \"a\", \"b\", \"c\", \n   \"d\" with a calligrapher\'s pe"
 & "n determined \n   by the segment \"pq\". */\n\nPROC Stroke(p, q) IS \n "
 & " VAR path, currPt, startPt IN \n    path := PS.CurrentPath(); \n    PS."
 & "NewPath(); \n    currPt, startPt := NIL, NIL; \n    DO \n      path # N"
 & "IL -> \n        IF \n          VAR op, args IN \n            CAR(path) "
 & "= (op, args) -> \n              IF \n                op = \"MoveTo\" ->"
 & " \n                  startPt := CAR(args); \n                  currPt :"
 & "= startPt \n              | ";

CONST E45_1 = 
   "op = \"LineTo\" -> \n                  Line(currPt, CAR(args), p, \n   "
 & "                    q); \n                  currPt := CAR(args) \n     "
 & "         | op = \"CurveTo\" -> \n                  VAR b, c, d IN \n   "
 & "                 args = [b, c, d] -> \n                      Curve(curr"
 & "Pt, b, c, d, \n                            p, q); \n                   "
 & "   currPt := d \n                  END \n              | op = \"Close\""
 & " -> \n                  Line(currPt, startPt, p, q); \n                "
 & "  currPt, startPt := NIL, NIL \n              FI \n          END \n    "
 & "    FI; \n        path := CDR(path) \n    OD \n  END \nEND;\n\nUI Point"
 & "Tool(Stroke);\n\n(* Stroke the current path with a \n   calligrapher\'s"
 & " pen determined by the \n   segment \"pq\". *)\n\n";

CONST E46 = 
   "P4\n11 8\n\004\000\016\000\037\000?\200\177\300\377\340\000\000\000\000"
;

CONST E47 = 
   "MODULE Arrow;\n\n(* Procedures for drawing directed edges. *)\n\nIMPORT"
 & " Geometry, PS;\n\nPRIVATE CONST \n  WidthBase = 8, \n  WidthFactor = 3,"
 & " \n  StubSz = 0.15;\n\n/* If the current line width is \"w\", then \n  "
 & " when the arrowhead size = -1, the size \n   used is: \n\n|  size := Wi"
 & "dthBase + (w * WidthFactor)\n    */\n\nCONST DefaultSize = -1;\n\n(* Th"
 & "is module maintains a current arrowhead \n   size, which is the distanc"
 & "e from its tip \n   to its cusp. If the arrowhead size is \n   negative"
 & ", then the size is determined as a \n   function of the current line wi"
 & "dth. *)\n\nPRIVATE VAR size := DefaultSize;\n\nPROC SetSize(sz) IS size"
 & " := sz END;\n\nUI SetTool(SetSize);\n\n(* Set the current arrowhead siz"
 & "e to \"sz\". *)\n\nUI Param(SetSize, DefaultSize);\n\nUI Param(SetSize,"
 & " 12);\n\nUI Param(SetSize, 16);\n\nUI Param(SetSize, 20);\n\nUI Param(S"
 & "etSize, 24);\n\nUI Param(SetSize, 28);\n\nUI Param(SetSize, 48);\n\nPRO"
 & "C sz := GetSize() IS sz := size END;\n\n(* Return the current arrow hea"
 & "d size. A \n   negative result means the arrow head size \n   is determ"
 & "ined from the current line width. \n*)\n\nPROC sz := HeadSize() IS \n  "
 & "IF \n    size < 0 -> \n      VAR w IN \n        w := PS.GetWidth(); \n "
 & "       IF w = 0 -> w := 1 | SKIP FI; \n        sz := WidthBase + (Width"
 & "Factor * w) \n      END | sz := size \n  FI \nEND;\n\n(* Set \"sz\" to "
 & "the size to use to draw \n   arrowheads. This is usually the same as \n"
 & "   the value of the \"GetSize\" procedure, \n   unless that is negative"
 & ", in which case it \n   is a function of the current line width. *)\n\n"
 & "PRIVATE PROC DrawHead(a, b) IS \n  IF \n    VAR \n      c = (-0.16, 0.3"
 & "6) REL (a, b), \n      d = (-0.16, -0.36) REL (a, b) \n    IN \n      S"
 & "AVE PS IN \n        PS.SetJointStyle(PS.MiterJoints); \n        PS.Move"
 & "To(a); \n        PS.LineTo(c); \n        PS.LineTo(b); \n        PS.Lin"
 & "eTo(d); \n        PS.Close(); \n        PS.Fill() \n      END \n    END"
 & " \n  FI \nEND;\n\n/* Draw the head of an arrow with its cusp at \n   \""
 & "a\" and its tip at \"b\". The arrowhead is \n   filled with paint of th"
 & "e current color. */\n\nPRIVATE PROC DrawHeadWith";

CONST E47_0 = 
   "Tail(a, b) IS \n  IF \n    VAR c = (StubSz, 0) REL (a, b) IN \n      SA"
 & "VE PS IN \n        PS.SetEndStyle(PS.ButtEnds); \n        PS.MoveTo(a);"
 & " \n        PS.LineTo(c); \n        PS.Stroke() \n      END; \n      Dra"
 & "wHead(c, b) \n    END \n  FI \nEND;\n\n/* Draw an arrow head with a sma"
 & "ll tail. The \n   tail starts at \"a\", and the tip of the \n   head is"
 & " at \"b\". */\n\nFUNC p = StraightEnd(a, b, dist) IS \n  (E p0 ~ Geomet"
 & "ry.Mid(a, b) :: \n    Geometry.Colinear(a, p0, b) AND \n    dist = Geom"
 & "etry.Dist(p0, b) AND \n    p = p0) \nEND;\n\n(* \"p\" is the point on t"
 & "he line \"ab\" closest \n   to \"a\" and a distance \"dist\" from \"b\""
 & ". *)\n\nPROC Head(a, b) IS \n  IF \n    VAR p = StraightEnd(a, b, HeadS"
 & "ize()) IN \n      IF \n        VAR c = (StubSz, 0) REL (p, b) IN \n    "
 & "      DrawHead(c, b) \n        END \n      FI \n    END \n  FI \nEND;\n"
 & "\nUI PointTool(Head);\n\n(* Draw an arrow head with no tail as if the \n"
 & "   tail started at \"a\" and ended at \"b\". *)\n\nPROC Straight(a, b) "
 & "IS \n  IF \n    VAR p = StraightEnd(a, b, HeadSize()) IN \n      PS.Mov"
 & "eTo(a); \n      PS.LineTo(p); \n      PS.Stroke(); \n      DrawHeadWith"
 & "Tail(p, b) \n    END \n  FI \nEND;\n\nPROC DblStraight(a, b) IS \n  IF "
 & "\n    VAR \n      sz = HeadSize(), \n      p = StraightEnd(b, a, sz), \n"
 & "      q = StraightEnd(a, b, sz) \n    IN \n      DrawHeadWithTail(p, a)"
 & "; \n      PS.MoveTo(p); \n      PS.LineTo(q); \n      PS.Stroke(); \n  "
 & "    DrawHeadWithTail(q, b) \n    END \n  FI \nEND;\n\nUI PointTool(Stra"
 & "ight);\n\nUI PointTool(DblStraight);\n\n(* Draw a directed or doubly-di"
 & "rected edge, \n   respectively, from \"a\" to \"b\". Requires \n   that"
 & " \"a # b\". *)\n\nPROC Curved(a, b, c, d) IS \n  IF \n    VAR p = Strai"
 & "ghtEnd(c, d, HeadSize()) IN \n      PS.MoveTo(a); \n      PS.CurveTo(b,"
 & " c, p); \n      PS.Stroke(); \n      DrawHeadWithTail(p, d) \n    END \n"
 & "  FI \nEND;\n\nPROC DblCurved(a, b, c, d) IS \n  IF \n    VAR \n      s"
 & "z = HeadSize(), \n      p = StraightEnd(b, a, sz), \n      q = Straight"
 & "End(c, d, sz) \n    IN \n      DrawHeadWithTail(p, a); \n      PS.MoveT"
 & "o(p); \n      PS.CurveTo(b, c, q); \n      PS.Stroke(); \n      ";

CONST E47_1 = 
   "DrawHeadWithTail(q, d) \n    END \n  FI \nEND;\n\nUI PointTool(Curved);"
 & "\n\nUI PointTool(DblCurved);\n\n(* Draw a directed or doubly-directed c"
 & "urved \n   edge, respectively, from \"a\" to \"d\" with \n   Bezier con"
 & "trol points \"b\" and \"c\". \n   Requires that \"c # d\". *)\n\nPRIVAT"
 & "E VAR history := NIL;\n\nPROC Save() IS history := (size, history) END;"
 & "\n\nPROC Restore() IS \n  size := CAR(history); \n  history := CDR(hist"
 & "ory) \nEND;\n\nUI PointTool(Save);\n\nUI PointTool(Restore);\n\n(* Save"
 & "/restore the current arrow size. *)\n\n";

CONST E48 = 
   "MODULE Shadow;\n\n(* Procedures for drawing 3D shadow effects. *)\n\nIM"
 & "PORT Color, R2, Geometry, PS;\n\nCONST DefaultWidth = 4;\n\n(* This mod"
 & "ule maintains a current shadow width. *)\n\nPRIVATE VAR width := Defaul"
 & "tWidth;\n\nPROC SetWidth(w) IS width := w END;\n\nUI SetTool(SetWidth);"
 & "\n\n(* Set the current shadow width to \"w\". *)\n\nUI Param(SetWidth, "
 & "DefaultWidth);\n\nUI Param(SetWidth, 1);\n\nUI Param(SetWidth, 2);\n\nU"
 & "I Param(SetWidth, 3);\n\nUI Param(SetWidth, 4);\n\nUI Param(SetWidth, 5"
 & ");\n\nUI Param(SetWidth, 7);\n\nUI Param(SetWidth, 10);\n\nCONST \n  De"
 & "faultColors = (Color.Grey75, Color.Grey25), \n  ReverseColors = (Color."
 & "Grey25, Color.Grey75);\n\n(* This module maintains a current pair of co"
 & "lors, \n   which are the two colors used to draw the shadows. \n   By d"
 & "efault, the shadows are drawn so a light source \n   appears to be shin"
 & "ing on a raised object from the \n   upper-left. *)\n\nPRIVATE VAR colo"
 & "rs := DefaultColors;\n\nPROC SetColors(c) IS colors := c END;\n\nUI Set"
 & "Tool(SetColors);\n\n(* Set the current pair of colors to \"c\", which s"
 & "hould \n   be a pair of colors produced using the \"Color\" \n   module"
 & ". *)\n\nUI Param(SetColors, DefaultColors);\n\nUI Param(SetColors, Reve"
 & "rseColors);\n\nPRIVATE PROC Rect0(a, b) IS \n  IF \n    VAR \n      c ="
 & " Geometry.HorVer(b, a), \n      d = Geometry.HorVer(a, b), \n      e = "
 & "R2.Minus(a, (width, width)), \n      f = R2.Plus(b, (width, width)), \n"
 & "      g = Geometry.HorVer(f, e), \n      h = Geometry.HorVer(e, f) \n  "
 & "  IN \n      SAVE PS IN \n        PS.MoveTo(a); \n        PS.LineTo(c);"
 & " \n        PS.LineTo(b); \n        PS.LineTo(f); \n        PS.LineTo(g)"
 & "; \n        PS.LineTo(e); \n        PS.Close(); \n        PS.SetColor(C"
 & "AR(colors)); \n        PS.Fill(); \n        PS.MoveTo(a); \n        PS."
 & "LineTo(d); \n        PS.LineTo(b); \n        PS.LineTo(f); \n        PS"
 & ".LineTo(h); \n        PS.LineTo(e); \n        PS.Close(); \n        PS."
 & "SetColor(CDR(colors)); \n        PS.Fill() \n      END \n    END \n  FI"
 & " \nEND;\n\nPROC Rect(a, b) IS \n  IF \n    VAR ax, ay, bx, by IN \n    "
 & "  a = (ax, ay) AND b = (bx, by) -> \n      ";

CONST E48_0 = 
   "  Rect0((MIN(ax, bx), MIN(ay, by)), \n              (MAX(ax, bx), MAX(a"
 & "y, by))) \n    END \n  FI \nEND;\n\nUI PointTool(Rect);\n\n(* Draw shad"
 & "ows around the rectangle with corners \"a\" \n   and \"b\" that is squa"
 & "rely oriented with the page. The \n   shadows are drawn in the current "
 & "shadow width and \n   colors. The west and north shadows are filled wit"
 & "h \n   the first color, and the east and south shadows are \n   filled "
 & "with the second color. *)\n\nPROC RectC(c, b) IS \n  IF VAR a = (-1, 0)"
 & " REL (c, b) IN Rect(a, b) END FI \nEND;\n\nUI PointTool(RectC);\n\n(* L"
 & "ike \"Rect\" above, but the rectangle is specified by \n   its center \""
 & "c\" and one of its corners \"b\". *)\n\nPRIVATE VAR history := NIL;\n\n"
 & "PROC Save() IS \n  history := ((width, colors), history) \nEND;\n\nPROC"
 & " Restore() IS \n  VAR head IN \n    head := CAR(history); \n    width :"
 & "= CAR(head); \n    colors := CDR(head) \n  END; \n  history := CDR(hist"
 & "ory) \nEND;\n\nUI PointTool(Save);\n\nUI PointTool(Restore);\n\n(* Save"
 & "/restore the current shadow state. *)\n";

CONST E49 = 
   "; Copyright (C) 1992, Digital Equipment Corporation                    "
 & "     \n; All rights reserved.                                          "
 & "            \n; See the file COPYRIGHT for a full description.         "
 & "                   \n;                                                 "
 & "                          \n; Last modified on Thu Mar 28 17:07:59 PST "
 & "1996 by heydon                   \n;      modified on Sun Jun 11 17:30:"
 & "56 PDT 1995 by gnelson                  \n\n(Rim (Pen 5)\n  (Macro Gap "
 & "() \'(Glue 5 + Inf))\n  (Macro VGap () \'(Glue 5))\n  (Macro LeftText B"
 & "OA (t)\n    `(HBox (Shape (Width 45 + 0) (Text RightAlign ,t)) (Glue 2)"
 & "))\n (VBox\n  (HBox\n    (LeftText \"Name:\")\n    (Frame Lowered (MyBr"
 & "owserFont)\n      (Shape (Width 100 + Inf)\n        (TypeIn %declName F"
 & "irstFocus (BgColor \"White\")))\n    )\n  )\n  (VGap)\n  (Radio %typeRa"
 & "dio\n    (HBox\n      (LeftText \"Type:\")\n      (HBox\n        Fill\n"
 & "        (Choice %procType \"PROC\") (Gap)\n        (Filter (Choice %pre"
 & "dType \"PRED\")) (Gap)\n        (Choice %templType \"Template\")\n     "
 & "   Fill\n      )\n    )\n  )\n  (VGap)\n  (Radio %toolRadio\n    (HBox\n"
 & "      (LeftText \"Tool:\")\n      (HBox\n        Fill\n        (Choice "
 & "%pointTool \"Point\") (Gap)\n        (Choice %noTool    \"None\")\n    "
 & "    Fill\n      )\n    )\n  )\n  (VGap)\n  (HBox\n    Fill\n    (Button"
 & " %foldOk \"  OK  \")\n    Fill\n  )\n))\n";

CONST E50 = 
   "MODULE JunoUI;\n\n(* This module provides information to the Juno progr"
 & "am about the \n   state of the Juno application user interface. *) \n  "
 & " \nPROC nm := DragName() IS SKIP END; /* external procedure */\n\n(* \""
 & "DragName()\" returns the name of the point currently being dragged by\n"
 & "the user, or \"NIL\" if the user isn\'t dragging. *)\n\nPROC pt := Drag"
 & "Loc() IS SKIP END; /* external procedure */\n\n(* \"DragLoc()\" returns"
 & " the location of the point currently being dragged by\nthe user, or \"N"
 & "IL\" if the user isn\'t dragging. *)\n\nPROC pr := GetClick() IS SKIP E"
 & "ND;\n\n(* UNIMPLEMENTED!\n\n   Blocks and waits for the user to click t"
 & "he mouse in the drawing window,\n   then returns a value of the form \""
 & "((x,y),(tp,bt))\" where \"(x,y)\" are\n   the Juno coordinates of the p"
 & "osition of the click, \"tp\" is one\n   of \"FirstDown\", \"OtherDown\""
 & ", \"OtherUp\", and \"LastUp\" and identifies\n   the type of the click,"
 & " and \"bt\" is 0, 1, 2 identifying the left,\n   middle, and right mous"
 & "e button respectively. *)\n\n";

CONST E51 = 
   "MODULE Unit;\n\n(* Defines constants and \n   procedures for various un"
 & "its \n   of length. The lengths are\n   defined in terms of the units\n"
 & "   of Juno\'s coordinate system,\n   which are PostScript points\n   (e"
 & "qual to 1/72 of an inch). *)\n\nCONST \n  In = 72.0, \n  Ft = In * 12.0"
 & ", \n  Cm = In / 2.54, \n  Mm = Cm / 10.0;\n\n(* \"In\", \"Ft\", \"Cm\","
 & " and \"Mm\" \n   are the size (in points) of \n   one inch, one foot, o"
 & "ne \n   centimeter, and one \n   millimeter, respectively. *)\n\n(* Jun"
 & "o\'s coordinate system \n   uses screen-independent \n   units, but the"
 & "re are cases \n   in which screen-dependent \n   units could be useful."
 & " This \n   is most often the case when \n   PostScript output is not \n"
 & "   being generated, and it is \n   important that the \n   quantization"
 & " error induced \n   by the discrete pixels on \n   the screen not effec"
 & "t the \n   regularity of the drawing. \n   For example, it would be \n "
 & "  more convenient to use \n   screen-dependent units to \n   draw a ser"
 & "ies of \n   evenly-spaced horizontal \n   lines. The following \n   pro"
 & "cedure can be used to \n   obtain the screen-dependent \n   size of a s"
 & "ingle pixel. *)\n\nPROC x, y := Pixel() IS \n  SKIP \nEND;\n\n(* \"x\" "
 & "and \"y\" are the \n   horizontal and vertical size \n   (in points) of"
 & " a pixel on \n   the screen on which Juno is \n   running. Use this pro"
 & "cedure \n   in your Juno programs with \n   care, since it will cause \n"
 & "   your program to be \n   screen-dependent. *)\n\n";

CONST E52 = 
   "MODULE PS;\n\n/* A template for the PS interface to be \n   read in But"
 & "ton or Public view only. */\n\n(* The built-in Juno PostScript module. "
 & "*)\n\nIMPORT Color;\n\n(* \\section{Coordinate System} *)\n\n(* Juno us"
 & "es the same coordinate system\n   as the default PostScript coordinate\n"
 & "   system. The origin of this coordinate\n   system is the lower-left c"
 & "orner of the\n   page with \"x\" and \"y\" coordinates\n   increasing t"
 & "o the left and up,\n   respectively. The units of the coordinate\n   sy"
 & "stem are PostScript {\\it points}, equal\n   to 1/72 of an inch. The \""
 & "Unit\" module\n   defines constants and procedures for\n   converting f"
 & "rom points to other units. *)\n\n(* \\section{Drawing Model} *)\n\n(* J"
 & "uno uses the PostScript drawing model.\n   In this model, ink is painte"
 & "d on the page\n   by defining a {\\it path} of straight and\n   curved "
 & "segments, and then {\\it stroking}\n   or {\\it filling} the path with "
 & "ink. There\n   are separate procedures for painting text\n   in a parti"
 & "cular font. There are also\n   procedures for reading the values of\n  "
 & " the PostScript state, such as the current\n   point, and for measuring"
 & " text strings. *)\n\n(* \\section{Paths} *)\n\n(* A {\\it segment} is a"
 & " directed arc. A\n   segment is defined mathematically by two\n   param"
 & "etric univariate cubic polynomials \"x(t)\"\n   and \"y(t)\", where \"t"
 & "\" ranges over the closed\n   interval \"[0, 1]\". The segment starts a"
 & "t\n   \"(x(0), y(0))\" and ends at \"(x(1), y(1))\". If \n   \"x\" and "
 & "\"y\" are linear functions of \n   \"t\", then the segment is {\\it lin"
 & "ear}: it \n   corresponds to a straight line \n   segment. If \"x\" and"
 & " \"y\" are constant \n   functions of \"t\", then the segment is \n   {"
 & "\\it degenerate}: it consists of a single \n   point. \n\n   A {\\it su"
 & "b-path} is a connected sequence \n   of straight and curved line segmen"
 & "ts. \n   Within a sub-path, each segment \n   begins where the previous"
 & " segment \n   ends. \n\n   Each sub-path is either {\\it open} or \n   "
 & "{\\it closed}. In a closed sub-path, the \n   last segment ends where t"
 & "he first \n   segment begins. (This may also";

CONST E52_0 = 
   " happen \n   for an open sub-path, but this \n   coincidence does not m"
 & "ake the \n   sub-path closed.) \n\n   A {\\it path} is a (possibly empt"
 & "y) \n   sequence of sub-paths. This module \n   maintains a {\\it curre"
 & "nt path}. The \n   endpoint of the last segment of the \n   last open s"
 & "ub-path of the current \n   path is called the {\\it current point}; \n"
 & "   if the current path is empty, or if \n   the last sub-path of the cu"
 & "rrent path \n   is closed, the current point is \n   undefined. *)\n\n("
 & "* Variables named \"p\", \"q\", \"r\", and \n   \"s\" are points. *)\n\n"
 & "PROC NewPath() IS SKIP END;\n\n(* Make the current path empty. *)\n\nPR"
 & "OC MoveTo(p) IS SKIP END;\n\nUI PointTool(MoveTo);\n\n(* Let \"pp\" be "
 & "a new degenerate open \n   sub-path starting and ending at \"p\". \n   "
 & "In the usual case, this procedure \n   appends \"pp\" to the current pa"
 & "th. \n   However, in the special case that the \n   current sub-path is"
 & " non-empty, open, \n   and degenerate (i.e., \"MoveTo\" was \n   the mo"
 & "st-recently called path \n   construction procedure), this \n   procedu"
 & "re instead replaces the \n   current sub-path with \"pp\". In either \n"
 & "   case, \"p\" becomes the current point. *)\n\nPROC LineTo(p) IS SKIP "
 & "END;\n\nUI PointTool(LineTo);\n\n(* Extend the current path with a \n  "
 & " straight line segment from the \n   current point to \"p\"; \"p\" beco"
 & "mes the \n   current point. It is a checked \n   run-time error for the"
 & " current point \n   to be undefined. *)\n\nPROC CurveTo(q, r, s) IS SKI"
 & "P END;\n\nUI PointTool(CurveTo);\n\n(* Extend the current path with a B"
 & "ezier \n   curve determined by the current \n   point, \"q\", \"r\", an"
 & "d \"s\"; \"s\" becomes \n   the current point. It is a checked \n   run"
 & "-time error for the current point \n   to be undefined. *)\n\n(* \"Curv"
 & "eTo\" adds a curve that starts at \n   the current point in the directi"
 & "on of \n   \"q\", and ends at \"s\" coming from the \n   direction of \""
 & "r\". More precisely, let \n   \"p\" be the current point, and let \n   "
 & "\"x(t)\" and \"y(t)\" be the cubic \n   polynomials such that: \n\n|   "
 & " (x(0), y(0)) = p\n|    (x(1), y(1)) = s\n|    (x\'(0), y\'(0)";

CONST E52_1 = 
   ") = 3 * (q - p)\n|    (x\'(1), y\'(1)) = 3 * (s - r)\n\n   (where the p"
 & "rimes denote \n   differentiation with respect to \"t\"). \n   Then \"C"
 & "urveTo\" adds the segment \n   \"(x(t), y(t))\" to the current path, fo"
 & "r \n   \"t\" in the closed interval \"[0, 1]\". This \n   is called the"
 & " {\\it Bezier arc} determined \n   by \"p\", \"q\", \"r\", and \"s\". *"
 & ")\n\nPROC Close() IS SKIP END;\n\nUI PointTool(Close);\n\n(* Closes the"
 & " last sub-path of the \n   current path by adding a straight \n   line "
 & "segment from the current point \n   to the starting point of the curren"
 & "t \n   sub-path. It is a checked run-time \n   error for the current po"
 & "int to be\n   undefined. *)\n\n(* \\section{Painting} *)\n\nPROC Stroke"
 & "() IS SKIP END;\n\nUI PointTool(Stroke);\n\n(* Stroke the current path "
 & "using the \n   current color, current width, current \n   end style, an"
 & "d current joint style. *)\n\nPROC Fill() IS SKIP END;\n\nUI PointTool(F"
 & "ill);\n\n(* Fill the region enclosed by the\n   current path in the cur"
 & "rent \n   color according to the current \n   winding style. If the pat"
 & "h consists\n   of several disconnected sub-paths,\n   the subpaths are "
 & "filled individually.\n   Any open subpaths are implicitly\n   closed be"
 & "fore being filled. *)\n\nPROC Type(p, txt) IS SKIP END;\n\nUI TextTool("
 & "Type);\n\n(* Paint the string \"txt\" at the point \n   \"p\" in the cu"
 & "rrent font and the \n   current color. The current path is \n   unchang"
 & "ed.\n\n   The \"Type\" procedure uses the\n   ISO-Latin-1 character enc"
 & "oding for\n   the Courier, Helvetica, and Times\n   font families, and "
 & "the Symbol character\n   encoding for the Symbol font family.\n   See A"
 & "ppendix E of the ``PostScript\n   Language Reference Manual, Second\n  "
 & " Edition\'\'. Section E.7 shows the\n   ISO-Latin-1 encoding, and Secti"
 & "on\n   E.12 shows the Symbol encoding.\n\n   Warning: In the ISO-Latin-"
 & "1 encoding,\n   the easy-to-type \"-\" character with\n   code value \\"
 & "055 is a minus sign, while\n   the hyphen is hidden at code value\n   \\"
 & "255. *)\n\n(* \\section{Stroking} *)\n\nCONST DefaultWidth = 1;\n\n(* T"
 & "his module maintains a \"current \n   width\", which i";

CONST E52_2 = 
   "s a number. *)\n\nPROC SetWidth(w) IS SKIP END;\n\nUI SetTool(SetWidth)"
 & ";\n\n(* Set the current width to \"w\". It is a \n   checked run-time e"
 & "rror for \"w < 0\". *)\n\nUI Param(SetWidth, DefaultWidth);\n\nUI Param"
 & "(SetWidth, 0);\n\nUI Param(SetWidth, 1);\n\nUI Param(SetWidth, 2);\n\nU"
 & "I Param(SetWidth, 3);\n\nUI Param(SetWidth, 4);\n\nUI Param(SetWidth, 5"
 & ");\n\nUI Param(SetWidth, 10);\n\nUI Param(SetWidth, 20);\n\nCONST \n  B"
 & "uttEnds = 0, \n  RoundEnds = 1, \n  SquareEnds = 2, \n  DefaultEnds = B"
 & "uttEnds;\n\n(* This module maintains a \"current end \n   style\", whic"
 & "h is one of \"ButtEnds\", \n   \"RoundEnds\", or \"SquareEnds\". *)\n\n"
 & "PROC SetEndStyle(es) IS SKIP END;\n\nUI SetTool(SetEndStyle);\n\n(* Set"
 & " the current end style to \"es\". It \n   is a checked run-time error f"
 & "or \"es\" \n   not to be one of the values \n   \"ButtEnds\", \"RoundEn"
 & "ds\", or \n   \"SquareEnds\". *)\n\nUI Param(SetEndStyle, DefaultEnds);"
 & "\n\nUI Param(SetEndStyle, ButtEnds);\n\nUI Param(SetEndStyle, RoundEnds"
 & ");\n\nUI Param(SetEndStyle, SquareEnds);\n\nCONST \n  MiterJoints = 0, "
 & "\n  RoundJoints = 1, \n  BevelJoints = 2, \n  DefaultJoints = MiterJoin"
 & "ts;\n\n(* This module maintains a \"current \n   joint style\", which i"
 & "s one of \n   \"MiterJoints\", \"RoundJoints\", and \n   \"BevelJoints\""
 & ". *)\n\nPROC SetJointStyle(js) IS SKIP END;\n\nUI SetTool(SetJointStyle"
 & ");\n\n(* Set the current joint style to \"js\". \n   It is a checked ru"
 & "n-time error for \n   \"js\" not to be one of the values \n   \"MiterJo"
 & "ints\", \"RoundJoints\", or \n   \"BevelJoints\". *)\n\nUI Param(SetJoi"
 & "ntStyle, DefaultJoints);\n\nUI Param(SetJointStyle, MiterJoints);\n\nUI"
 & " Param(SetJointStyle, RoundJoints);\n\nUI Param(SetJointStyle, BevelJoi"
 & "nts);\n\nPROC w := GetWidth() IS SKIP END;\n\nPROC es := GetEndStyle() "
 & "IS SKIP END;\n\nPROC js := GetJointStyle() IS SKIP END;\n\n(* Return th"
 & "e current line width, end \n   style, and joint style as set by the \n "
 & "  most recent calls to the \n   corresponding \"Set\" procedures. *)\n\n"
 & "(* \\section{Filling} *)\n\nCONST DefaultColor = Color.Black;\n\n(* Thi"
 & "s module maintains a \"current \n   color\", which is specified as a re"
 & "d, \n   green,";

CONST E52_3 = 
   " blue triple \"[r, g, b]\". A \n   color is legal if \"0 <= r, g, b <= "
 & "\n   1\". See the \"Color\" module. *)\n\nPROC SetColor(c) IS SKIP END;"
 & "\n\nUI SetTool(SetColor);\n\n(* Set the current color to \"c\". It is a"
 & " \n   checked run-time error for \"c\" not to \n   be a legal color. *)"
 & "\n\nUI Param(SetColor, DefaultColor);\n\nUI Param(SetColor, Color.Black"
 & ");\n\nUI Param(SetColor, Color.White);\n\nUI Param(SetColor, Color.Red)"
 & ";\n\nUI Param(SetColor, Color.Green);\n\nUI Param(SetColor, Color.Blue)"
 & ";\n\nUI Param(SetColor, Color.Cyan);\n\nUI Param(SetColor, Color.Magent"
 & "a);\n\nUI Param(SetColor, Color.Yellow);\n\nUI Param(SetColor, Color.Gr"
 & "ey25);\n\nUI Param(SetColor, Color.Grey50);\n\nUI Param(SetColor, Color"
 & ".Grey75);\n\nCONST \n  NonZeroWinding = 0, \n  OddWinding = 1,\n  Defau"
 & "ltWinding = NonZeroWinding;\n\n(* This module maintains a \"current \n "
 & "  winding style\", which is one of \n   \"OddWinding\" or \"NonZeroWind"
 & "ing\". *)\n\nPROC SetWinding(ws) IS SKIP END;\n\nUI SetTool(SetWinding)"
 & ";\n\n(* Set the current winding style to \n   \"ws\". It is a checked r"
 & "un-time error \n   for \"ws\" not to be one of the \n   constants \"Odd"
 & "Winding\" or \n   \"NonZeroWinding\". *)\n\nUI Param(SetWinding, Defaul"
 & "tWinding);\n\nUI Param(SetWinding, OddWinding);\n\nUI Param(SetWinding,"
 & " NonZeroWinding);\n\nPROC c := GetColor() IS SKIP END;\n\nPROC ws := Ge"
 & "tWinding() IS SKIP END;\n\n(* Return the current color and winding \n  "
 & " style as set by the most recent calls \n   to the corresponding \"Set\""
 & " \n   procedures. *)\n\n(* \\section{Text} *)\n\nCONST \n  FontFaces = "
 & "[\"Times-Roman\", \n               \"Times-Bold\", \n               \"T"
 & "imes-Italic\", \n               \"Times-BoldItalic\", \n               "
 & "\"Helvetica\", \n               \"Helvetica-Bold\", \n               \""
 & "Helvetica-Oblique\", \n               \"Helvetica-BoldOblique\", \n    "
 & "           \"Courier\", \n               \"Courier-Bold\", \n          "
 & "     \"Courier-Oblique\", \n               \"Courier-BoldOblique\", \n "
 & "              \"Symbol\"], \n  DefaultFace = \"Times-Roman\";\n\n(* Thi"
 & "s module maintains a current font \n   face, which is one of the font f"
 & "aces \n   name";

CONST E52_4 = 
   "d in the list \"FontFaces\". *)\n\nPROC SetFontFace(nm) IS SKIP END;\n\n"
 & "UI SetTool(SetFontFace);\n\n(* Set the current font face to \"nm\"; \n "
 & "  the current font size is unchanged. \n   It is a checked run-time err"
 & "or for \n   \"nm\" not to be a member of the list \n   \"FontFaces\". *"
 & ")\n\nUI Param(SetFontFace, DefaultFace);\n\nUI Param(SetFontFace, \"Tim"
 & "es-Roman\");\n\nUI Param(SetFontFace, \"Times-Bold\");\n\nUI Param(SetF"
 & "ontFace, \"Times-Italic\");\n\nUI Param(SetFontFace, \"Times-BoldItalic"
 & "\");\n\nUI Param(SetFontFace, \"Helvetica\");\n\nUI Param(SetFontFace, "
 & "\"Helvetica-Bold\");\n\nUI Param(SetFontFace, \"Helvetica-Oblique\");\n"
 & "\nUI Param(SetFontFace, \n         \"Helvetica-BoldOblique\");\n\nUI Pa"
 & "ram(SetFontFace, \"Courier\");\n\nUI Param(SetFontFace, \"Courier-Bold\""
 & ");\n\nUI Param(SetFontFace, \"Courier-Oblique\");\n\nUI Param(SetFontFa"
 & "ce, \n         \"Courier-BoldOblique\");\n\nUI Param(SetFontFace, \"Sym"
 & "bol\");\n\nCONST \n  Tiny = 0, \n  Small = 1, \n  Medium = 2, \n  Big ="
 & " 3, \n  Large = 4, \n  Huge = 5, \n  DefaultSize = Large, \n  FontSizes"
 & " = [Tiny, Small, Medium, Big, \n               Large, Huge];\n\n(* This"
 & " module maintains a current font \n   size, which is one of the symboli"
 & "c \n   font sizes in the list \"FontSizes\". *)\n\nPROC SetFontSize(sz)"
 & " IS SKIP END;\n\nUI SetTool(SetFontSize);\n\n(* Set the current font si"
 & "ze to \"sz\"; \n   the current font face is unchanged. \n   It is a che"
 & "cked run-time error for \n   \"sz\" not to be a member of the list \n  "
 & " \"FontSizes\". *)\n\nUI Param(SetFontSize, DefaultSize);\n\nUI Param(S"
 & "etFontSize, Tiny);\n\nUI Param(SetFontSize, Small);\n\nUI Param(SetFont"
 & "Size, Medium);\n\nUI Param(SetFontSize, Big);\n\nUI Param(SetFontSize, "
 & "Large);\n\nUI Param(SetFontSize, Huge);\n\nPROC SetFont(nm, sz) IS SKIP"
 & " END;\n\n(* Equivalent to \"SetFontFace(nm); \n   SetFontSize(sz)\". *)"
 & "\n\nPROC nm := GetFontFace() IS SKIP END;\n\nPROC sz := GetFontSize() I"
 & "S SKIP END;\n\nPROC nm, sz := GetFont() IS SKIP END;\n\n(* Return the c"
 & "urrent font face and size \n   as set by the most recent calls to \n   "
 & "the corresponding \"Set\" procedures. *)\n\nPROC ptSz := GetFontPtSize("
 & ") IS SKIP ";

CONST E52_5 = 
   "END;\n\n(* Return the height in points of the \n   current font. This i"
 & "s the nominal \n   distance between tightly-spaced lines \n   of the fo"
 & "nt, and so is probably \n   larger than the height of the font\'s \n   "
 & "capital letters. *)\n\nPROC asc, dec := FontHeight() IS \n  SKIP \nEND;"
 & "\n\n(* Return the ascent and the decent of \n   the current font. The a"
 & "scent is the \n   height of the character in the font \n   that extends"
 & " furthest above the \n   baseline, and the decent is the depth \n   of "
 & "the character in the font that \n   extends furthest below the baseline"
 & ". \n   Hence, the height of the font\'s \n   bounding box is \"asc + de"
 & "c\". *)\n\nPROC w := StringWidth(txt) IS SKIP END;\n\n(* Return the wid"
 & "th of the string \"txt\" \n   typed in the current font. *)\n\nPROC rec"
 & "t := StringBBox(txt) IS SKIP END;\n\n(* Return the bounding box of the "
 & "string \n   \"txt\" typed at the origin in the \n   current font. The r"
 & "esult \"rect\" is a \n   pair of points \"(sw, ne)\", where \"sw\" \n  "
 & " and \"ne\" are the southwest and \n   northeast corners of the boundin"
 & "g \n   box, respectively. *)\n\n(* \\section{Current Path State} *)\n\n"
 & "PROC p := CurrentPoint() IS SKIP END;\n\n(* Returns the current point, "
 & "or \"NIL\" \n   if the current point is undefined. \n   The current poi"
 & "nt is defined if and \n   only if the current path is non-empty \n   an"
 & "d its last sub-path is open. *)\n\nPROC path := CurrentPath() IS SKIP E"
 & "ND;\n\n(* Returns a description of the current \n   path, or \"NIL\" if"
 & " the current path is \n   empty. A path description is a list \n   of s"
 & "ublists, where each sublist \n   describes a segment of the path and \n"
 & "   takes one of the following forms: \n\n|    [\"MoveTo\", p]\n|    [\""
 & "LineTo\", p]\n|    [\"CurveTo\", p, q, r]\n|    [\"Close\"]\n\n   In th"
 & "ese descriptions, the variables \n   \"p\", \"q\", and \"r\" range over"
 & " points \n   (i.e., pairs of numbers). *)\n\n(* \\section{Bounding Box}"
 & " *)\n\n(* This module maintains a \"bounding \n   box\", which is a rec"
 & "tangle. The \n   default bounding box is the bounding \n   box of an 8-"
 & "1/2\" x 11\" page. Juno\n   displays the current boun";

CONST E52_6 = 
   "ding box as\n   a grey rectangle on the screen, and\n   writes the boun"
 & "ding box information\n   into a \"BoundingBox\" comment when\n   genera"
 & "ting PostScript. *)\n\nPROC SetBBox(p, q) IS SKIP END;\n\nUI PointTool("
 & "SetBBox);\n\n(* Set the current bounding box to the \n   rectangle whos"
 & "e opposite corners are \n   \"p\" and \"q\". *)\n\nPROC p, q := GetBBox"
 & "() IS SKIP END;\n\n(* Set \"p\" and \"q\" to points at opposite\n   cor"
 & "ners of the current bounding box. *)\n\n(* \\section{PostScript State} "
 & "*)\n\nPROC ShowPage() IS SKIP END;\n\nUI PointTool(ShowPage);\n\n(* Upd"
 & "ate the display to contain the \n   current page. Since the Juno system"
 & " \n   executes an implicit ShowPage() at \n   the end of the current co"
 & "mmand, you \n   only need to use ShowPage() to \n   achieve animation e"
 & "ffects. *)\n\nPROC Reset() IS SKIP END;\n\nUI PointTool(Reset);\n\n(* R"
 & "eset the PostScript state to its \n   default value. Subsequent paintin"
 & "g \n   operations appear on a blank page. *)\n\nPROC SavePage() IS SKIP"
 & " END;\n\nPROC RestorePage() IS SKIP END;\n\n(* Save/restore the current"
 & " page to an offscreen\n   buffer. This can be used in animations to\n  "
 & " quickly restore a background common to all\n   frames. WARNING: When o"
 & "utputing PostScript,\n   these procedures are no-ops. *)\n\nPROC Save()"
 & " IS SKIP END;\n\nPROC Restore() IS SKIP END;\n\nUI PointTool(Save);\n\n"
 & "UI PointTool(Restore);\n\n(* Save/Restore the entire state of this \n  "
 & " module. The state is saved to and \n   restored from an internal stack"
 & ". The \n   state includes the current path, \n   current width, current"
 & " end style, \n   current joint style, current color, \n   current windi"
 & "ng style, and current \n   font. *)\n\n";

CONST E53 = 
   "; Copyright (C) 1992, Digital Equipment Corporation                    "
 & "     \n; All rights reserved.                                          "
 & "            \n; See the file COPYRIGHT for a full description.         "
 & "                   \n;                                                 "
 & "                          \n; Last modified on Fri Jun 16 18:38:37 PDT "
 & "1995 by heydon                   \n\n(VBox\n  (Insert \"Macros.fv\")\n "
 & " (MyLabelFont)\n  (HBox\n    (Menu (MenuLabel \"View\") (Radio %view =p"
 & "ublic (VBox\n      (LinkMButton (For publicView)\n        (Choice %publ"
 & "ic  CheckMark MenuStyle (TextL \"Public\")))\n      (LinkMButton (For p"
 & "rivateView)\n        (Choice %private  CheckMark MenuStyle (TextL \"Pri"
 & "vate\")))\n    )))\n    Fill\n  )\n  (MyRidge)\n  (TSplit %body Flex (W"
 & "hich firstChild)\n    (Macro EditorW BOA () \'(Width 400 + Inf - 200))\n"
 & "    (Macro EditorH BOA () \'(Height 500 + Inf - 450))\n    (Shape %firs"
 & "tChild (EditorW) (EditorH) (Generic %publicView))\n    (Shape (EditorW)"
 & " (EditorH) (Generic %privateView)))\n)\n";

CONST E54 = 
   "MODULE CharSet;\n\nIMPORT Text, R2, PS, Type, TypeLinesC, TypeLinesR;\n"
 & "\nPRIVATE CONST \n  Rows = 16, \n  Cols = 16, \n  XBorder = 3, \n  YBor"
 & "der = 2;\n\n/* \"Rows\" and \"Cols\" specify the total \n   number of r"
 & "ows and columns of the \n   grid. \"XBorder\" and \"YBorder\" specify \n"
 & "   the amount of horizontal and vertical \n   space, respectively, to l"
 & "eave on each \n   side of the widest/tallest character \n   in the font"
 & ". */\n\nPRIVATE PROC w := MaxCharWidth() IS \n  w := 0; \n  VAR i = 0 I"
 & "N \n    DO \n      i < 256 -> \n        w := \n          MAX(w, \n     "
 & "     PS.StringWidth(Text.FromChar(i))); \n        i := i + 1 \n    OD \n"
 & "  END \nEND;\n\n/* Set \"w\" to the width of the widest \n   character "
 & "in the current font at the \n   current font size. */\n\nPROC Show(p) I"
 & "S \n  SAVE PS IN \n    PS.SetWidth(1); \n    VAR row, col, h, asc, dec,"
 & " w IN \n      w := MaxCharWidth() + 2 * XBorder; \n      asc, dec := PS"
 & ".FontHeight(); \n      h := asc + dec + 2 * YBorder; \n      p := \n   "
 & "     R2.Plus(p, \n                (-w * Rows / 2, \n                 h "
 & "* Cols / 2)); \n      row := 0; \n      DO \n        row < Rows -> \n  "
 & "        col := 0; \n          DO \n            col < Cols -> \n        "
 & "      ShowChar(p, asc, w, h, row, \n                       col); \n    "
 & "          col := col + 1 \n          OD; \n          GridLines(p, w, h,"
 & " row); \n          row := row + 1 \n      OD; \n      GridLines(p, w, h"
 & ", Rows); \n      ShowCodes(p, w, h) \n    END \n  END \nEND;\n\nUI Poin"
 & "tTool(Show);\n\n(* Display a 16 x 16 grid centered at \n   \"p\"; the g"
 & "rid contains the 256 \n   characters of the current font, \n   rendered"
 & " in the current size. *)\n\nPRIVATE PROC \n  ShowChar(p, asc, w, h, row"
 & ", col) IS \n  VAR c, dx, dy IN \n    c := Text.FromChar(col + row * Col"
 & "s); \n    dx := w * (col + 0.5); \n    dy := -(row * h + YBorder + asc)"
 & "; \n    p := R2.Plus(p, (dx, dy)); \n    Type.C(p, c) \n  END \nEND;\n\n"
 & "PRIVATE PROC GridLines(p, w, h, i) IS \n  PS.MoveTo((CAR(p) + i * w, CD"
 & "R(p))); \n  PS.LineTo((CAR(p) + i * w, \n             CDR(p) - h * Rows"
 & ")); \n  PS.MoveTo((CAR(p), CDR(p) - i";

CONST E54_0 = 
   " * h)); \n  PS.LineTo((CAR(p) + w * Cols, \n             CDR(p) - i * h"
 & ")); \n  PS.Stroke() \nEND;\n\nPRIVATE PROC ShowCodes(p, w, h) IS \n  SA"
 & "VE PS IN \n    PS.SetFontFace(\"Helvetica\"); \n    ShowHCodes(p, w); \n"
 & "    ShowVCodes(p, h) \n  END \nEND;\n\nPRIVATE PROC ShowHCodes(p, w) IS"
 & " \n  VAR i = 0, q IN \n    DO \n      i < Cols -> \n        q := \n    "
 & "      R2.Plus(p, (w / 2 + w * i, 0)); \n        TypeLinesC.South(q, Hex"
 & "Char(i)); \n        i := i + 1 \n    OD \n  END \nEND;\n\nPRIVATE PROC "
 & "ShowVCodes(p, h) IS \n  VAR i = 0, q IN \n    DO \n      i < Rows -> \n"
 & "        q := \n          R2.Minus(p, (5, h / 2 + h * i)); \n        Typ"
 & "eLinesR.East(q, HexChar(i)); \n        i := i + 1 \n    OD \n  END \nEN"
 & "D;\n\nPRIVATE VAR \n  Zero := Text.GetChar(\"0\", 0), \n  A := Text.Get"
 & "Char(\"A\", 0);\n\nPRIVATE PROC txt := HexChar(i) IS \n  IF \n    0 <= "
 & "i AND i < 10 -> \n      txt := Text.FromChar(Zero + i) \n  | 10 <= i AN"
 & "D i < 16 -> \n      txt := Text.FromChar(A + (i - 10)) \n  FI \nEND;\n\n"
;

CONST E55 = 
   "MODULE Text;\n\n/* A template for the Text \n   interface to be read in"
 & " Button \n   or Public view only. */\n\n(* The built-in Juno Text modul"
 & "e. A \n   Juno text string is a zero-based \n   sequence of characters."
 & " *)\n\n(* The variables \"t\", \"u\", and \"tu\" \n   are texts; \"i\","
 & " \"n\", and \"ch\" \n   are integers; and \"r\" is an \n   arbitrary nu"
 & "mber. *)\n\nPROC tu := Cat(t, u) IS SKIP END;\n\n(* Returns the concate"
 & "nation of \"t\" \n   and \"u\". *)\n\nPROC n := Length(t) IS SKIP END;\n"
 & "\n(* Returns the number of characters \n   in \"t\". *)\n\nPROC u := Su"
 & "b(t, i, n) IS SKIP END;\n\n(* Returns a subsequence of \"t\" \n   start"
 & "ing at character \"i\" of \n   length at most \"n\". The result \n   is"
 & " empty if \"i >= Length(t)\" or \n   if \"n = 0\"; otherwise, it ranges"
 & " \n   from \"i\" to \"MIN(i+n, \n   Length(t)-1)\". *)\n\nPROC ch := Ge"
 & "tChar(t, n) IS \n  SKIP \nEND;\n\n(* Returns the integer code of \n   c"
 & "haracter \"n\" of \"t\". It is a \n   checked run-time error if \"n < \n"
 & "   0\" or \"n >= Length(t)\". *)\n\nPROC t := FromChar(ch) IS SKIP END;"
 & "\n\n(* Returns a string of length one \n   containing the character wit"
 & "h \n   code \"ch\". It is a checked \n   run-time error if \"ch < 0\" o"
 & "r \n   \"ch > 255\". *)\n\nPROC t := FromNum(r, n) IS SKIP END;\n\n(* R"
 & "eturns the unparsing of the \n   number \"r\" to \"n\" digits of \n   p"
 & "recision. *)\n\nPROC i := FindChar(t, ch) IS \n  SKIP \nEND;\n\n(* Retu"
 & "rns the index of first \n   occurrence of the character \"ch\" in \n   "
 & "the text \"t\", or -1 if \"ch\" does \n   not occur in \"t\". It is a \n"
 & "   checked run-time error if \"ch < \n   0\" or \"ch > 255\". *)\n\nPRO"
 & "C i := FindCharR(t, ch) IS \n  SKIP \nEND;\n\n(* Returns the index of l"
 & "ast \n   occurrence of the character \"ch\" in \n   the text \"t\", or "
 & "-1 if \"ch\" does \n   not occur in \"t\". It is a \n   checked run-tim"
 & "e error if \"ch < \n   0\" or \"ch > 255\". *)\n\n";

CONST E56 = 
   "(CodeFont    (courier bold 10))\n(TextFont    (helvetica bold 10))\n(La"
 & "belFont   (helvetica bold 12))\n(DotSize     2.5)\n(CrossSize   4)\n(Ch"
 & "kptIntv   30)\n(RealPrec    4)\n(PrintCmd    \"/usr/bin/lpr -J $Title\""
 & ")\n(PreviewCmd  \"psview -d $Display -t $Title $Filename\")\n(Origin   "
 & "   center)\n(Orientation portrait)\n";

CONST E57 = 
   "MODULE Offset;\n\nCONST \n  DefaultHor = 0, DefaultVer = 0;\n\nPRIVATE "
 & "VAR \n  hor := DefaultHor, \n  ver := DefaultVer;\n\n(* This module mai"
 & "ntains a current \n   horizontal and vertical offset.\n   The offset va"
 & "lues \n   are used by other modules. *)\n\nPROC h, v := GetHorVer() IS "
 & "\n  h, v := hor, ver \nEND;\n\nPROC h := GetHor() IS h := hor END;\n\nP"
 & "ROC v := GetVer() IS v := ver END;\n\nPROC SetHorVer(h, v) IS \n  hor, "
 & "ver := h, v \nEND;\n\nPROC SetHor(h) IS hor := h END;\n\nPROC SetVer(v)"
 & " IS ver := v END;\n\nUI SetTool(SetHor);\n\nUI SetTool(SetVer);\n\n(* G"
 & "et/set the horizontal and \n   vertical offset values. *)\n\nUI Param(S"
 & "etHor, DefaultHor);\n\nUI Param(SetHor, 0);\n\nUI Param(SetHor, 2);\n\n"
 & "UI Param(SetHor, 4);\n\nUI Param(SetHor, 6);\n\nUI Param(SetHor, 10);\n"
 & "\nUI Param(SetVer, DefaultVer);\n\nUI Param(SetVer, 0);\n\nUI Param(Set"
 & "Ver, 2);\n\nUI Param(SetVer, 4);\n\nUI Param(SetVer, 6);\n\nUI Param(Se"
 & "tVer, 10);\n\nPRIVATE VAR history := NIL;\n\nPROC Save() IS \n  history"
 & " := ((hor, ver), history) \nEND;\n\nPROC Restore() IS \n  VAR head IN \n"
 & "    head := CAR(history); \n    hor, ver := CAR(head), CDR(head); \n   "
 & " history := CDR(history) \n  END \nEND;\n\nUI PointTool(Save);\n\nUI Po"
 & "intTool(Restore);\n\n(* Save/restore the current offset \n   values. *)"
 & "\n\n";

CONST E58 = 
   "P4\n12 12\n\360\360\340p\360\360\271\320\037\200\017\000\017\000\037\200"
 & "\271\320\360\360\340p\360\360";

CONST E59 = 
   "MODULE Angle;\n\nIMPORT Math, R2, Geometry, Rel;\n\n(* Functions and pr"
 & "edicates on \n   angles. Unless stated otherwise, \n   all angles are i"
 & "n radians. *)\n\nCONST Degree = Math.Pi / 180;\n\n(* \"Degree\" is the "
 & "value of one \n   degree in radians. *)\n\nPRED Right(a, b, c) IS \n  R"
 & "2.Dot(R2.Minus(a, b), \n         R2.Minus(c, b)) = 0 \nEND;\n\nUI Point"
 & "Tool(Right);\n\n(* The angle \"abc\" is right. True if \n   \"a = b\" o"
 & "r \"b = c\". *)\n\nFUNC theta = Acute(a, b, c) IS \n  (E v1, v2, l1, l2"
 & " :: \n    v1 = R2.Minus(a, b) AND \n    v2 = R2.Minus(c, b) AND \n    l"
 & "1 = R2.Length(v1) AND \n    l2 = R2.Length(v2) AND \n    theta ~ 1.5 AN"
 & "D \n    COS(theta) * l1 * l2 = \n      R2.Dot(v1, v2)) \nEND;\n\n(* Ret"
 & "urn the angle \"abc\" as an acute \n   angle in the closed interval \"["
 & "0, \n   Pi]\". Requires \"a # b\" and \"b # \n   c\". *)\n\nFUNC theta "
 & "= CC(a, b, c) IS \n  (E p = Rel.Inv(c, b, a) :: \n    theta = ATAN(CDR("
 & "p), CAR(p))) \nEND;\n\n(* Return the angle in the half-open \n   interv"
 & "al \"(-Pi, Pi]\" that the ray \n   \"ba\" forms with the ray \"bc\", \n"
 & "   measured counter-clockwise from \n   \"ba\". Requires \"a # b\" and "
 & "\"b # \n   c\". *)\n\nPRED OnBisector(p, a, b, c) IS \n  (E d ~ c :: \n"
 & "    (d, b) CONG (b, a) AND \n    (d, p) CONG (p, a) AND \n    Geometry."
 & "Colinear(b, d, c)) \nEND;\n\nUI PointTool(OnBisector);\n\n(* The point "
 & "\"p\" is on the line \n   bisecting the acute angle \"abc\". *)\n\nPRED"
 & " Cong(a, b, c, d, e, f) IS \n  (E g ~ d, h ~ f :: \n    Geometry.Coline"
 & "ar(e, d, g) AND \n    Geometry.Colinear(e, f, h) AND \n    (a, b) CONG "
 & "(g, e) AND \n    (h, e) CONG (c, b) AND \n    (c, a) CONG (g, h)) \nEND"
 & ";\n\nUI PointTool(Cong);\n\n(* The angle \"abc\" is congruent to \n   t"
 & "he angle \"def\". *)\n\n";

CONST E60 = 
   "MODULE Random;\n\n(* Random number generator *)\n\nPROC r := Real01() I"
 & "S SKIP END; /* external procedure */\n\n(* Return a uniformly-distribut"
 & "ed real number\n   in the half-open interval \"[0.0, 1.0)\". *)\n\nPROC"
 & " r := Real(lo, hi) IS SKIP END; /* external procedure */\n\n(* Return a"
 & " uniformly-distributed real number\n   in the half-open interval \"[lo,"
 & " hi)\". It is\n   a checked run-time error for \"lo >= hi\". *)\n\nPROC"
 & " r := Int(lo, hi) IS SKIP END; /* external procedure */\n\n(* Return a "
 & "uniformly-distributed integer\n   in the half-open interval \"[lo, hi)\""
 & ". It\n   is a checked run-time error for \"lo\" or\n   \"hi\" not to be"
 & " an integer or for \"lo >= hi\". *)\n";

CONST E61 = 
   "; Copyright (C) 1992, Digital Equipment Corporation                    "
 & "     \n; All rights reserved.                                          "
 & "            \n; See the file COPYRIGHT for a full description.         "
 & "                   \n;                                                 "
 & "                          \n; Last modified on Thu May 26 16:05:47 PDT "
 & "1994 by heydon                   \n\n(Rim (Pen 5)\n  (Macro Gap () \'(G"
 & "lue 5))\n  (BrowserShape\n    (VBox (MyBrowserFont)\n      (DirMenu (Fo"
 & "r saveBrowser))\n      (Gap)\n      (Border\n        (FileBrowser %save"
 & "Browser\n          (BgColor \"White\")\n          (Suffixes \".juno\")\n"
 & "        )\n      )\n      (Gap)\n      (HBox\n        \"File:\"\n      "
 & "  (Glue 2)\n        (Frame Lowered\n          (Helper FirstFocus (BgCol"
 & "or \"White\") (For saveBrowser))\n        )\n      )\n    )\n  )\n)\n";

CONST E62 = 
   "MODULE DiGraph;\n\nIMPORT PS, Circle, Color, R2, Geometry, Arrow, \n   "
 & "    TypeLinesC, Ellipse;\n\n(* A module for drawing directed, labeled, "
 & "graphs. The \n   nodes are drawn as ellipses whose axes are oriented \n"
 & "   squarly with the page. *)\n\nCONST \n  DefaultNodeWE = (35, 1), \n  "
 & "DefaultNodeWH = (CAR(DefaultNodeWE), \n                   CAR(DefaultNo"
 & "deWE));\n\n(* This module maintains a current node size, which is \n   "
 & "initially set so as to draw a circle with radius 35. \n*)\n\nPRIVATE VA"
 & "R \n  width := CAR(DefaultNodeWE), \n  eccentricity := CDR(DefaultNodeW"
 & "E);\n\nPROC SetNodeWE(we) IS \n  IF \n    VAR w, e IN \n      we = (w, "
 & "e) -> width := w; eccentricity := e \n    END \n  FI \nEND;\n\nPROC Set"
 & "NodeWH(wh) IS \n  IF \n    VAR w, h IN \n      wh = (w, h) -> width := "
 & "w; eccentricity := h / w \n    END \n  FI \nEND;\n\nUI SetTool(SetNodeW"
 & "E);\n\nUI SetTool(SetNodeWH);\n\n(* These procedures set the node size."
 & " The argument to \n   each procedure is a pair of real numbers of the f"
 & "orm \n   \"(w, x)\". In both procedures, \"w\" is the horizontal \n   w"
 & "idth of the nodes in points. In \"SetNodeWE\", the \n   second value \""
 & "x\" is the eccentricity of the nodes, \n   namely, the ratio of their v"
 & "ertical height to their \n   horizontal width. In \"SetNodeWH\", the se"
 & "cond value \n   \"x\" is the absolute vertical height of the nodes in \n"
 & "   points. *)\n\nUI Param(SetNodeWE, DefaultNodeWE);\n\nUI Param(SetNod"
 & "eWH, DefaultNodeWH);\n\nPROC we := GetNodeWE() IS \n  we := (width, ecc"
 & "entricity) \nEND;\n\nPROC wh := GetNodeWH() IS \n  wh := (width, width "
 & "* eccentricity) \nEND;\n\n(* Return the current node size. *)\n\nPRIVAT"
 & "E PROC maj := FromCenter(a) IS \n  maj := (CAR(a) + width, CDR(a)) \nEN"
 & "D;\n\nPRIVATE PROC NodePath(a) IS \n  VAR maj IN \n    maj := FromCente"
 & "r(a); \n    IF \n      eccentricity = 1 -> Circle.Draw(a, maj) \n    | "
 & "Ellipse.DrawEcc(a, maj, eccentricity) \n    FI \n  END \nEND;\n\nPROC N"
 & "ode(a) IS NodePath(a); PS.Stroke() END;\n\nUI PointTool(Node);\n\n(* Dr"
 & "aw an ellipse centered at \"a\" with the current node \n   width and he"
 & "ight. *)\n\nPROC Label(p, label) IS TypeL";

CONST E62_0 = 
   "inesC.Center(p, label) END;\n\nUI TextTool(Label);\n\n(* Print the labe"
 & "l \"txt\" inside the node \"p\". *)\n\nPROC p := Intercept(a, b) IS \n "
 & " IF \n    eccentricity = 1 -> \n      VAR c ~ b IN \n        Geometry.C"
 & "olinear(a, c, b) AND \n        width = Geometry.Dist(a, c) -> p := c \n"
 & "      END \n  | VAR maj IN \n      maj := FromCenter(a); \n      IF \n "
 & "       VAR c ~ b IN \n          Geometry.Colinear(a, c, b) AND \n      "
 & "    Ellipse.OnEcc(c, a, maj, eccentricity) -> \n            p := c \n  "
 & "      END \n      FI \n    END \n  FI \nEND;\n\n(* Sets \"p\" to the po"
 & "int along segment \"ab\" and on the \n   ellipse centered at \"a\" draw"
 & "n in the current node \n   size. *)\n\nPROC Straight0(a, b) IS \n  VAR "
 & "ab, ba IN \n    ab := Intercept(a, b); \n    ba := Intercept(b, a); \n "
 & "   PS.MoveTo(ab); \n    PS.LineTo(ba); \n    PS.Stroke() \n  END \nEND;"
 & "\n\nPROC Straight1(a, b) IS \n  VAR ab, ba IN \n    ab := Intercept(a, "
 & "b); \n    ba := Intercept(b, a); \n    Arrow.Straight(ab, ba) \n  END \n"
 & "END;\n\nPROC Straight2(a, b) IS \n  VAR ab, ba IN \n    ab := Intercept"
 & "(a, b); \n    ba := Intercept(b, a); \n    Arrow.DblStraight(ab, ba) \n"
 & "  END \nEND;\n\nUI PointTool(Straight0);\n\nUI PointTool(Straight1);\n\n"
 & "UI PointTool(Straight2);\n\n(* Draw an undirected, singly-directed or \n"
 & "   doubly-directed straight edge, respectively, from the \n   node \"a\""
 & " to the node \"b\". *)\n\nPROC Curved0(a, b, c, d) IS \n  VAR ab, dc IN"
 & " \n    ab := Intercept(a, b); \n    dc := Intercept(d, c); \n    PS.Mov"
 & "eTo(ab); \n    PS.CurveTo(b, c, dc); \n    PS.Stroke() \n  END \nEND;\n"
 & "\nPROC Curved1(a, b, c, d) IS \n  VAR ab, dc IN \n    ab := Intercept(a"
 & ", b); \n    dc := Intercept(d, c); \n    Arrow.Curved(ab, b, c, dc) \n "
 & " END \nEND;\n\nPROC Curved2(a, b, c, d) IS \n  VAR ab, dc IN \n    ab :"
 & "= Intercept(a, b); \n    dc := Intercept(d, c); \n    Arrow.DblCurved(a"
 & "b, b, c, dc) \n  END \nEND;\n\nUI PointTool(Curved0);\n\nUI PointTool(C"
 & "urved1);\n\nUI PointTool(Curved2);\n\n(* Draw an undirected, singly-dir"
 & "ected or \n   doubly-directed curved edge, respectively, from the \n   "
 & "node \"a\" to the node \"d\" with Bezier control points";

CONST E62_1 = 
   " \n   \"b\" and \"c\". *)\n\nCONST DefaultFillColor = Color.White;\n\n("
 & "* This module maintains a current fill color, used by \n   the \"Filled"
 & "Node\" procedure. *)\n\nPRIVATE VAR fillColor := DefaultFillColor;\n\nP"
 & "ROC SetFillColor(c) IS fillColor := c END;\n\nUI SetTool(SetFillColor);"
 & "\n\nUI Param(SetFillColor, DefaultFillColor);\n\n(* Set the current fil"
 & "l color to \"c\". *)\n\nPROC FilledNode(a) IS \n  NodePath(a); \n  SAVE"
 & " PS IN PS.SetColor(fillColor); PS.Fill() END; \n  PS.Stroke() \nEND;\n\n"
 & "UI PointTool(FilledNode);\n\n(* Like \"Node\" above, but the inside of "
 & "the node is \n   filled with the current fill color. *)\n\nPRIVATE VAR "
 & "history := NIL;\n\nPROC Save() IS \n  history := ([width, eccentricity,"
 & " fillColor], history) \nEND;\n\nPROC Restore() IS \n  VAR top IN \n    "
 & "top := CAR(history); \n    width := CAR(top); \n    eccentricity := CAR"
 & "(CDR(top)); \n    fillColor := CAR(CDR(CDR(top))); \n    history := CDR"
 & "(history) \n  END \nEND;\n\nUI PointTool(Save);\n\nUI PointTool(Restore"
 & ");\n\n(* Save/restore the current node size. *)\n\n";

CONST E63 = 
   "MODULE TypeLinesC;\n\n(* The procedures in this module \n   type a bloc"
 & "k of centered text \n   lines relative to a specified \n   point. Each "
 & "procedure takes a \n   reference point and a single \n   text, which is"
 & " converted to a \n   list of texts by the \n   \"TextList.FromText\" pr"
 & "ocedure. \n   One line is displayed in the \n   block per element of th"
 & "is list. \n\n   The lines in each block are \n   separated vertically b"
 & "y the \n   height of the current font plus \n   the current line skip v"
 & "alue \n   (maintained by the \"LineSkip\" \n   module). \n\n   The text"
 & " block is actually \n   translated in the appropriate \n   direction aw"
 & "ay from the \n   reference point by the current \n   horizontal and/or "
 & "vertical \n   offset values (maintained by the \n   \"Offset\" module)."
 & " For example, \n   the \"South\" procedure translates \n   the text blo"
 & "ck up by the current \n   vertical offset, and the \"NE\" \n   procedur"
 & "e translates it down by \n   the current vertical offset and \n   to th"
 & "e left by the current \n   horizontal offset. The \"Center\" \n   proce"
 & "dure ignores the current \n   offset values. *)\n\nIMPORT LineSkip, Off"
 & "set, PS, \n       R2, TextList, Type;\n\nPRIVATE PROC TypeBlockC(p, l) "
 & "IS \n  VAR asc, dec, d IN \n    asc, dec := PS.FontHeight(); \n    d :="
 & " asc + dec + LineSkip.Get(); \n    p := (CAR(p), CDR(p) - asc); \n    D"
 & "O \n      l # NIL -> \n        Type.C(p, CAR(l)); \n        p := (CAR(p"
 & "), CDR(p) - d); \n        l := CDR(l) \n    OD \n  END \nEND;\n\n/* Typ"
 & "e the centered block of text \n   lines \"l\" such that \"p\" is the \n"
 & "   northwest corner of the box\'s \n   bounding-box. */\n\nPROC North(p"
 & ", txt) IS \n  VAR l, dh IN \n    l := TextList.FromText(txt); \n    dh "
 & ":= Offset.GetVer(); \n    TypeBlockC(R2.Plus(p, (0, -dh)), \n          "
 & "     l) \n  END \nEND;\n\nPROC South(p, txt) IS \n  VAR l, w, h, dh IN "
 & "\n    l := TextList.FromText(txt); \n    w, h := TextList.Size(l); \n  "
 & "  dh := Offset.GetVer(); \n    TypeBlockC(R2.Plus(p, \n                "
 & "       (0, h + dh)), \n               l) \n  END \nEND;\n\nPROC East(p,"
 & " txt) IS \n  VAR l, w, h, dw IN \n    l";

CONST E63_0 = 
   " := TextList.FromText(txt); \n    w, h := TextList.Size(l); \n    dw :="
 & " Offset.GetHor(); \n    TypeBlockC(R2.Plus(p, \n                       "
 & "(-w / 2 - dw, \n                        h / 2)), l) \n  END \nEND;\n\nP"
 & "ROC West(p, txt) IS \n  VAR l, w, h, dw IN \n    l := TextList.FromText"
 & "(txt); \n    w, h := TextList.Size(l); \n    dw := Offset.GetHor(); \n "
 & "   TypeBlockC(R2.Plus(p, \n                       (w / 2 + dw, \n      "
 & "                  h / 2)), l) \n  END \nEND;\n\nPROC Center(p, txt) IS "
 & "\n  VAR l, w, h IN \n    l := TextList.FromText(txt); \n    w, h := Tex"
 & "tList.Size(l); \n    TypeBlockC(R2.Plus(p, (0, h / 2)), \n             "
 & "  l) \n  END \nEND;\n\nPROC NW(p, txt) IS \n  VAR l, w, h, dw, dh IN \n"
 & "    l := TextList.FromText(txt); \n    w, h := TextList.Size(l); \n    "
 & "dw, dh := Offset.GetHorVer(); \n    TypeBlockC(R2.Plus(p, \n           "
 & "            (w / 2 + dw, \n                        -dh)), l) \n  END \n"
 & "END;\n\nPROC NE(p, txt) IS \n  VAR l, w, h, dw, dh IN \n    l := TextLi"
 & "st.FromText(txt); \n    w, h := TextList.Size(l); \n    dw, dh := Offse"
 & "t.GetHorVer(); \n    TypeBlockC(R2.Plus(p, \n                       (-w"
 & " / 2 - dw, \n                        -dh)), l) \n  END \nEND;\n\nPROC S"
 & "E(p, txt) IS \n  VAR l, w, h, dw, dh IN \n    l := TextList.FromText(tx"
 & "t); \n    w, h := TextList.Size(l); \n    dw, dh := Offset.GetHorVer();"
 & " \n    TypeBlockC(R2.Plus(p, \n                       (-w / 2 - dw, \n "
 & "                       h + dh)), l) \n  END \nEND;\n\nPROC SW(p, txt) I"
 & "S \n  VAR l, w, h, dw, dh IN \n    l := TextList.FromText(txt); \n    w"
 & ", h := TextList.Size(l); \n    dw, dh := Offset.GetHorVer(); \n    Type"
 & "BlockC(R2.Plus(p, \n                       (w / 2 + dw, \n             "
 & "           h + dh)), l) \n  END \nEND;\n\nUI TextTool(North);\n\nUI Tex"
 & "tTool(South);\n\nUI TextTool(East);\n\nUI TextTool(West);\n\nUI TextToo"
 & "l(Center);\n\nUI TextTool(NW);\n\nUI TextTool(NE);\n\nUI TextTool(SE);\n"
 & "\nUI TextTool(SW);\n\n(* Display the \"\\\"-separated texts \n   in \"t"
 & "\" as a centered block such \n   that \"p\" is at the location of \n   "
 & "the block\'s bounding box named \n   by the";

CONST E63_1 = 
   " procedure. *)\n\n";

CONST E64 = 
   "MODULE Plot;\n\n(* A module for drawing 2D graphs of plotted values. *)"
 & "\n\nIMPORT Text, Color, R2, PS, Arrow, Circle, Type;\n\nPRIVATE FUNC t "
 & "= Map1(v, scrn, grph) IS \n  (E s1, s2, g1, g2, k :: \n    scrn = (s1, "
 & "s2) AND \n    grph = (g1, g2) AND \n    k * (g2 - g1) = (v - g1) AND \n"
 & "    t = s1 + k * (s2 - s1)) \nEND;\n\nPRIVATE FUNC q = Map(g, p) IS \n "
 & " (E px, py, qx, qy, xScrn, yScrn, xGrph, yGrph :: \n    g = [xScrn, ySc"
 & "rn, xGrph, yGrph] AND \n    p = (px, py) AND \n    qx = Map1(px, xScrn,"
 & " xGrph) AND \n    qy = Map1(py, yScrn, yGrph) AND \n    q = (qx, qy)) \n"
 & "END;\n\n/* \"q\" is the point in Juno coordinates of the point \"p\" \n"
 & "   in graph \"g\"-coordinates. */\n\nPRIVATE PROC xInt, yInt := RectInt"
 & "s(c1, c2) IS \n  IF \n    VAR c1x, c1y, c2x, c2y IN \n      c1 = (c1x, "
 & "c1y) AND c2 = (c2x, c2y) -> \n        xInt := (MIN(c1x, c2x), MAX(c1x, "
 & "c2x)); \n        yInt := (MIN(c1y, c2y), MAX(c1y, c2y)) \n    END \n  F"
 & "I \nEND;\n\n/* Set \"xInt\" and \"yInt\" to the intervals in the x- and"
 & " \n   y-axes, respectively, of the rectangle oriented \n   squarely wit"
 & "h the page having \"c1\" and \"c2\" as \n   opposite corners. */\n\nPRO"
 & "C g := New(c1, c2, xGrph, yGrph) IS \n  VAR xScrn, yScrn IN \n    xScrn"
 & ", yScrn := RectInts(c1, c2); \n    g := [xScrn, yScrn, xGrph, yGrph] \n"
 & "  END \nEND;\n\n(* Return a new graph structure to be drawn in the \n  "
 & " bounding box determined by the two corner points \"c1\" \n   and \"c2\""
 & ". The values \"xGrph\" and \"yGrph\" must be \n   pairs of real numbers"
 & "; they represent the range of x- \n   and y-coordinates, respectively, "
 & "covered by the \n   resulting graph. *)\n\nPRIVATE PROC DrawAxes(g) IS "
 & "\n  PS.SetEndStyle(PS.SquareEnds); \n  IF \n    VAR \n      xScrn, yScr"
 & "n, xGrph, yGrph, minX, maxX, minY, maxY \n    IN \n      g = [xScrn, yS"
 & "crn, xGrph, yGrph] AND \n      xGrph = (minX, maxX) AND \n      yGrph ="
 & " (minY, maxY) -> \n        PS.MoveTo(Map(g, (minX, minY))); \n        P"
 & "S.LineTo(Map(g, (minX, maxY))); \n        PS.MoveTo(Map(g, (minX, minY)"
 & ")); \n        PS.LineTo(Map(g, (maxX, minY))); \n        PS.Stroke() \n"
 & "    END \n  FI \nEND;\n\n/* Draw t";

CONST E64_0 = 
   "he axes of \"g\" in the current line width. This \n   procedure does no"
 & "t preserve the PS state. */\n\nPRIVATE PROC DrawTitle(g, txtTitle) IS \n"
 & "  IF \n    VAR xLo, xHi, yLo, yHi, tail IN \n      g = ((xLo, xHi), ((y"
 & "Lo, yHi), tail)) -> \n        Type.C(((xLo + xHi) / 2, yHi + 20), txtTi"
 & "tle) \n    END \n  FI \nEND;\n\n/* Draw \"txtTitle\" centered above \"g"
 & "\" in the current \n   font. */\n\nPROC Draw(g, txtTitle) IS \n  SAVE P"
 & "S IN DrawAxes(g); DrawTitle(g, txtTitle) END \nEND;\n\n(* Draw the grap"
 & "h \"g\" with title \"txtTitle\". The axes \n   are drawn in the current"
 & " line width, and the title is \n   drawn in the current font. *)\n\nPRI"
 & "VATE CONST TickSz = 5;\n\nPRIVATE PROC TickMark(g, p, tickLoc, scale) I"
 & "S \n  VAR q, asc, dec, txt IN \n    q := Map(g, p); \n    asc, dec := P"
 & "S.FontHeight(); \n    PS.MoveTo(q);\n    PS.LineTo(R2.Minus(q, tickLoc)"
 & "); \n    PS.Stroke(); \n    IF \n      CAR(tickLoc) = 0 -> \n        q "
 & ":= R2.Minus(q, R2.Times(2, tickLoc)); \n        txt := Text.FromNum(CAR"
 & "(p) * scale, 3); \n        Type.C(R2.Minus(q, (0, asc)), txt) \n    | q"
 & " := R2.Minus(q, R2.Times(3, tickLoc)); \n      txt := Text.FromNum(CDR("
 & "p) * scale, 3); \n      Type.R(R2.Minus(q, (0, asc / 2)), txt) \n    FI"
 & " \n  END \nEND;\n\nPROC DrawTickMarks(g, cnt) IS \n  DrawScaledTickMark"
 & "s(g, cnt, (1, 1)) \nEND;\n\n(* Draw labeled tick marks on the graph \"g"
 & "\". The \n   argument \"cnt\" should be a pair of reals. The range \n  "
 & " of the visible x- and y-axes are divided into \n   \"CAR(cnt)\" and \""
 & "CDR(cnt)\" sections, respectively. The \n   tick marks are drawn in the"
 & " current line width and \n   end style, and the labels are drawn in the"
 & " current \n   font. *)\n\nPROC DrawScaledTickMarks(g, cnt, scale) IS \n"
 & "  IF \n    VAR \n      xScrn, yScrn, xLo, xHi, yLo, yHi, xCnt, yCnt, \n"
 & "      xScale, yScale \n    IN \n      g = [xScrn, yScrn, (xLo, xHi), (y"
 & "Lo, yHi)] AND \n      cnt = (xCnt, yCnt) AND \n      scale = (xScale, y"
 & "Scale) -> \n        VAR delta, x IN \n          delta := (xHi - xLo) / "
 & "xCnt; \n          x := xLo; \n          DO \n            x < xHi -> \n "
 & "             TickMark(g, (x,";

CONST E64_1 = 
   " yLo), (0, TickSz), xScale); \n              x := x + delta \n         "
 & " OD; \n          TickMark(g, (xHi, yLo), (0, TickSz), xScale) \n       "
 & " END; \n        VAR delta, y IN \n          delta := (yHi - yLo) / yCnt"
 & "; \n          y := yLo; \n          DO \n            y < yHi -> \n     "
 & "         TickMark(g, (xLo, y), (TickSz, 0), yScale); \n              y "
 & ":= y + delta \n          OD; \n          TickMark(g, (xLo, yHi), (TickS"
 & "z, 0), yScale) \n        END \n    END \n  FI \nEND;\n\n(* Draw labeled"
 & " tick marks on the graph \"g\". The \n   arguments \"cnt\" and \"scale\""
 & " should both be pairs of \n   reals. The range of the visible x- and y-"
 & "axes are \n   divided into \"CAR(cnt)\" and \"CDR(cnt)\" sections, \n  "
 & " respectively. The tick marks are drawn in the current \n   line width "
 & "and end style, and the labels are drawn in \n   the current font. The l"
 & "abels along the x- and y-axes \n   are scaled by the factors \"CAR(scal"
 & "e)\" and \n   \"CDR(scale)\", respectively. *)\n\nPROC Line(g, pts) IS "
 & "\n  IF \n    VAR head, tail IN \n      pts = (head, tail) -> \n        "
 & "PS.MoveTo(Map(g, head)); \n        pts := tail; \n        DO \n        "
 & "  VAR head, tail IN \n            pts = (head, tail) -> \n             "
 & " PS.LineTo(Map(g, head)); pts := tail \n          END \n        OD \n  "
 & "  END \n  FI \nEND;\n\n(* Plot the list of points \"pts\" on the graph "
 & "\"g\". \"pts\" \n   should be a list of points \"[p_0, p_1, ..., p_n]\""
 & ". \n   The points are ``plotted\'\' by constructing a path of \n   line"
 & " segments that connect successive pairs of \n   points. *)\n\nPROC Pts("
 & "g, pts, ptCl) IS \n  DO \n    VAR head, tail, p IN \n      pts = (head,"
 & " tail) -> \n        p := Map(g, head); APPLY(ptCl, p); pts := tail \n  "
 & "  END \n  OD \nEND;\n\n(* Plot the list of points \"pts\" on \"g\" usin"
 & "g the \n   closure \"ptCl\" to draw each of the points. The \"ptCl\" \n"
 & "   closure will be applied with a single argument, which \n   is the lo"
 & "cation of the point to draw. The \"DrawDotCl\" \n   procedure can be us"
 & "ed for \"ptCl\". *)\n\nPROC PtsWithErrors(g, pts, ptCl, errorCl) IS \n "
 & " DO \n    VAR tail, p, dyLo, dyHi IN \n      ";

CONST E64_2 = 
   "pts = ((p, (dyLo, dyHi)), tail) -> \n        APPLY(errorCl, Map(g, R2.P"
 & "lusY(p, dyLo)), \n              Map(g, R2.PlusY(p, dyHi))); \n        A"
 & "PPLY(ptCl, Map(g, p)); \n        pts := tail \n    END \n  OD \nEND;\n\n"
 & "(* Plot the list of points \"pts\" with vertical error \n   bars on the"
 & " graph \"g\", using \"ptCl\" to render the \n   points, and \"errorCl\""
 & " to render the error bars. The \n   argument \"pts\" should be a list o"
 & "f pairs of the form \n   \"(p, (dyLo, dyHi))\". Each pair describes a p"
 & "oint to \n   plot \"p\" and the error values in the y-coordinate. \n\n "
 & "  More formally, let \"Map\" denote the mapping from data \n   coordina"
 & "tes to screen coordinates. For each pair in \n   the list \"pts\", this"
 & " procedure invokes \"ptCl(Map(p))\" \n   to draw the point, and \n   \""
 & "errorCl(Map(R2.PlusY(p,dyLo)), \n   Map(R2.PlusY(p,dyHi)))\" to draw th"
 & "e error bars. The \n   bars are drawn before the points in case \"ptCl\""
 & " draws \n   points that are hollow. *)\n\nPRIVATE PROC DrawDot(rad, p) "
 & "IS \n  Circle.Draw(p, R2.PlusX(p, rad)); PS.Fill() \nEND;\n\nPROC cl :="
 & " DrawDotCl(rad) IS \n  cl := CLOSE(DrawDot, rad) \nEND;\n\n(* Returns a"
 & " closure that plots points as round dots \n   with radius \"rad\". *)\n"
 & "\nPRIVATE PROC DrawDiamondPath(p, w) IS \n  PS.MoveTo(R2.PlusX(p, w)); "
 & "\n  PS.LineTo(R2.MinusY(p, w)); \n  PS.LineTo(R2.MinusX(p, w)); \n  PS."
 & "LineTo(R2.PlusY(p, w)); \n  PS.Close() \nEND;\n\nPRIVATE PROC DrawDiamo"
 & "nd(w, p) IS \n  DrawDiamondPath(p, w); PS.Fill() \nEND;\n\nPROC cl := D"
 & "rawDiamondCl(w) IS \n  cl := CLOSE(DrawDiamond, w / 2) \nEND;\n\n(* Ret"
 & "urns a closure that plots points as filled \n   diamonds of width \"w\""
 & ". *)\n\nPRIVATE PROC DrawHollowDiamond(w, p) IS \n  DrawDiamondPath(p, "
 & "w); \n  SAVE PS IN PS.SetColor(Color.White); PS.Fill() END; \n  PS.Stro"
 & "ke() \nEND;\n\nPROC cl := DrawHollowDiamondCl(w) IS \n  cl := CLOSE(Dra"
 & "wHollowDiamond, w / 2) \nEND;\n\n(* Returns a closure that plots points"
 & " as filled \n   diamonds of width \"w\". *)\n\nPRIVATE PROC HLine(p, w)"
 & " IS \n  PS.MoveTo(R2.MinusX(p, w)); PS.LineTo(R2.PlusX(p, w)) \nEND;\n\n"
 & "PRIVATE PROC DrawErrorBar(w, lo, hi) IS ";

CONST E64_3 = 
   "\n  SAVE PS IN \n    PS.SetEndStyle(PS.ButtEnds); \n    HLine(lo, w); \n"
 & "    HLine(hi, w); \n    PS.MoveTo(lo); \n    PS.LineTo(hi); \n    PS.St"
 & "roke() \n  END \nEND;\n\nPROC cl := ErrorBarCl(xWidth) IS \n  cl := CLO"
 & "SE(DrawErrorBar, xWidth / 2) \nEND;\n\n(* Returns a closure that draws "
 & "vertical error bars in \n   the current line width with horizontal endm"
 & "arks of \n   length \"xWidth\". *)\n\n";

CONST E65 = 
   "; Copyright (C) 1992, Digital Equipment Corporation                    "
 & "     \n; All rights reserved.                                          "
 & "            \n; See the file COPYRIGHT for a full description.         "
 & "                   \n;                                                 "
 & "                          \n; Last modified on Mon Jan 27 16:08:07 PST "
 & "1997 by heydon                   \n\n(Shape (Width 600 + Inf - 400) (He"
 & "ight 500 + Inf - 500)\n  (TSplit %tsplit (Which startupScreen)\n    (Ge"
 & "neric %mainChild)\n    (Filter %startupScreen Passive (Cursor \"XC_watc"
 & "h\")\n      (Macro FixedHeight BOA (w) `(Shape (Height + 0 - 0) ,w))\n "
 & "     (VBox (LabelFont (Family \"Times\") (PointSize 180))\n\tFill \n\t("
 & "FixedHeight (Pixmap \"Juno2Logo.ppm\"))\n\t(Glue 10)\n\t(FixedHeight \""
 & "Welcome to Juno-2! Initializing...\")\n\t(Glue 10)\n\t(FixedHeight (Tex"
 & "t %initModule \"\"))\n\tFill\n      )\n    ) ;; Filter\n  ) ;; TSplit\n"
 & ") ;; Shape\n";

CONST E66 = 
   "MODULE BST;\n\n(* A module for creating and searching binary search tre"
 & "es. *)\n\nIMPORT List;\n\nPRIVATE CONST NoChildren = (NIL, NIL);\n\nPRI"
 & "VATE PROC tree := FromList2(l, len) IS \n  IF \n    len = 0 -> tree := "
 & "NIL \n  | len = 1 -> tree := (CAR(l), NoChildren) \n  | VAR mid, suffix"
 & ", left, right IN \n      mid := len DIV 2; \n      suffix := List.Suffi"
 & "xFrom(l, mid); \n      left := FromList2(List.Prefix(l, mid), mid); \n "
 & "     right := FromList2(CDR(suffix), len - mid - 1); \n      tree := (C"
 & "AR(suffix), (left, right)) \n    END \n  FI \nEND;\n\nPROC tree := From"
 & "List(l) IS \n  tree := FromList2(l, List.Length(l)) \nEND;\n\n(* Return"
 & " a balanced binary search tree containing the \n   elements of the list"
 & " \"l\". \"l\" should be a list of \"(key, \n   value)\" pairs such that"
 & " the successive \"key\" values are \n   non-decreasing according to som"
 & "e total order. *)\n\nPROC elt := Find(k, tree, order) IS \n  VAR root, "
 & "cmp IN \n    elt := NIL; \n    DO \n      tree # NIL -> \n        root "
 & ":= CAR(tree); \n        cmp := APPLY(order, k, CAR(root)); \n        IF"
 & " \n          cmp < 0 -> tree := CAR(CDR(tree)) \n        | cmp > 0 -> t"
 & "ree := CDR(CDR(tree)) \n        | elt := root; tree := NIL \n        FI"
 & " \n    OD \n  END \nEND;\n\n(* If there is a pair \"(key, value)\" in \""
 & "tree\" such that \n   \"APPLY(order, k, key) = 0\", return it. Otherwis"
 & "e, return \n   \"NIL\". \n\n   The closure \"order\" should define a to"
 & "tal order \"<\" on \"K \n   x Key\", where \"K\" is the domain of key v"
 & "alues passed as \n   the first argument to the \"Find\" procedure, and "
 & "\"Key\" is \n   the domain of the keys in the \"tree\". The call \n   \""
 & "APPLY(order, k, key)\" should return a value less than, \n   equal to, "
 & "or greater than 0 as \"k\" is less than, equal to, \n   or greater than"
 & " \"key\" according to \"<\". *)\n\nPRIVATE PROC res := NumOrder(k, key)"
 & " IS res := k - key END;\n\nPROC elt := FindNum(k, tree) IS \n  elt := F"
 & "ind(k, tree, NumOrder) \nEND;\n\n(* Call \"Find\" above for the order i"
 & "n which both \"k\" and the \n   keys in the \"tree\" are numbers. *)\n\n"
 & "PRIVATE PROC res := IntervalOrder(k, int) IS \n  IF";

CONST E66_0 = 
   " \n    k < CAR(int) -> res := -1 | k > CAR(CDR(int)) -> res := 1 \n  | "
 & "res := 0 \n  FI \nEND;\n\nPROC elt := FindInterval(k, tree) IS \n  elt "
 & ":= Find(k, tree, IntervalOrder) \nEND;\n\n(* Call \"Find\" above for th"
 & "e order in which \"k\" is a number \n   and the keys in the \"tree\" ar"
 & "e intervals of the form \n   \"[start, end, ...]\", where \"start\" and"
 & " \"end\" are numbers, \n   and the ellipses denote an arbitrary number "
 & "of additional \n   elements (possibly zero). *)\n\n";

CONST E67 = 
   "MODULE ShowLine;\n\n(* The procedures is this module \n   are like the "
 & "procedures in the \n   \"Show\" module of the same name, \n   except th"
 & "at they move the \n   current point down by the total \n   height of th"
 & "e current font plus \n   the current line skip value \n   (maintained b"
 & "y the \"LineSkip\" \n   module). \n\n   All procedures in this module \n"
 & "   require that the current point \n   is defined. *)\n\nIMPORT LineSki"
 & "p, PS, Type;\n\nPRIVATE PROC h := NetFontHeight() IS\n  VAR asc, dec IN"
 & " \n    asc, dec := PS.FontHeight(); \n    h := asc + dec \n  END \nEND;"
 & "\n\n/* Set \"h\" to the total height of\n   the current font. */\n\nPRI"
 & "VATE PROC MoveDown(p) IS \n  VAR d IN \n    d := \n      NetFontHeight("
 & ") + \n      LineSkip.Get(); \n    PS.MoveTo((CAR(p), CDR(p) - d)) \n  E"
 & "ND \nEND;\n\n/* Set the current point to the \n   point a distance of t"
 & "he total \n   current font height plus the \n   current line skip below"
 & " \"p\". */\n\nPROC L(txt) IS \n  VAR p IN \n    p := PS.CurrentPoint();"
 & " \n    PS.Type(p, txt); \n    MoveDown(p) \n  END \nEND;\n\nUI TextTool"
 & "(L);\n\n(* Types \"txt\" left-justified off \n   the current point. *)\n"
 & "\nPROC C(txt) IS \n  VAR p IN \n    p := PS.CurrentPoint(); \n    Type."
 & "C(p, txt); \n    MoveDown(p) \n  END \nEND;\n\nUI TextTool(C);\n\n(* Ty"
 & "pes \"txt\" centered about the \n   current point. *)\n\nPROC R(txt) IS"
 & " \n  VAR p IN \n    p := PS.CurrentPoint(); \n    Type.R(p, txt); \n   "
 & " MoveDown(p) \n  END \nEND;\n\nUI TextTool(R);\n\n(* Types \"txt\" righ"
 & "t-jusified off \n   the current point. *)\n\n";

CONST E68 = 
   "(Rim (Pen 10)\n  (VBox\n    \"Save changes to\"\n    (HBox\n      (Text"
 & " RightAlign (Margin 0) \"\\\"\")\n      (Shape (Width + 0) (Text %saveN"
 & "ame (Margin 0) \"test\"))\n      (Text LeftAlign (Margin 0) \"\\\"?\")\n"
 & "    )\n    (Glue 10)\n    (HBox\n      Fill\n      (Button %saveChanges"
 & " \"Save\")\n      (Glue 20)\n      (Button %discardChanges \"Discard\")"
 & "\n      Fill\n    )\n  )\n)\n";

CONST E69 = 
   "MODULE LineSkip;\n\nCONST DefaultSkip = 0;\n\nPRIVATE VAR lskip := Defa"
 & "ultSkip;\n\n(* This module maintains a current \n   \"line skip\" value"
 & ". The line skip \n   value is used by other modules \n   that display c"
 & "onsecutive lines \n   of text. *)\n\nPROC skip := Get() IS \n  skip := "
 & "lskip \nEND;\n\nPROC Set(skip) IS lskip := skip END;\n\nUI SetTool(Set)"
 & ";\n\n(* Get/set the current line skip \n   value. *)\n\nUI Param(Set, D"
 & "efaultSkip);\n\nUI Param(Set, 1);\n\nUI Param(Set, 2);\n\nUI Param(Set,"
 & " 3);\n\nUI Param(Set, 4);\n\nUI Param(Set, 5);\n\nUI Param(Set, 10);\n\n"
 & "PRIVATE VAR history := NIL;\n\nPROC Save() IS \n  history := (lskip, hi"
 & "story) \nEND;\n\nPROC Restore() IS \n  lskip := CAR(history); \n  histo"
 & "ry := CDR(history) \nEND;\n\nUI PointTool(Save);\n\nUI PointTool(Restor"
 & "e);\n\n(* Save/restore the current line \n   skip value. *)\n\n";

CONST E70 = 
   "MODULE VPrint;\n\nIMPORT Text, R2, Unparse, PS;\n\n(* A module for prin"
 & "ting lines of text to a virtual \n   terminal. *)\n\n(* \\section{Setti"
 & "ng Module State} *)\n\nPRIVATE VAR currPt := NIL;\n\n/* The current poi"
 & "nt at which the next text should be \n   printed. */\n\nPRIVATE VAR lef"
 & "tMargin := NIL;\n\n/* The x-coordinate of the left margin along which t"
 & "ext \n   will be justified. */\n\nPRIVATE VAR lineSep := NIL;\n\n/* The"
 & " current line separation in points. It is a \n   function of the curren"
 & "t font. A value of 0 means the \n   line separation must be computed fr"
 & "om the current \n   font. */\n\nPRIVATE VAR scrollDir := NIL;\n\n/* Eit"
 & "her +1 or -1. \"scrollDir\" specifies whether \n   subsequent lines are"
 & " printed above (+1) or below (-1) \n   the current one. */\n\nPRIVATE V"
 & "AR scrollPending := NIL;\n\n/* Indicates if a scroll is pending. A non-"
 & "NIL value \n   indicates that a scroll is pending, meaning that a \n   "
 & "newline character has just been printed, but that \n   \"currPt\" has n"
 & "ot been adjusted vertically. This will \n   only be the case when \"scr"
 & "ollDir\" is -1, since only \n   when scrolling down is the vertical scr"
 & "oll amount \n   dependent on the *next* line of text to be printed. \n "
 & "  This variable is necessary to correctly handle font \n   changes betw"
 & "een lines. */\n\nCONST \n  DefaultFontFace = \"Courier\", DefaultFontSi"
 & "ze = PS.Small;\n\n(* This module maintains its own font face and font s"
 & "ize, \n   independent of that maintained by the \"PS\" module. *)\n\nPR"
 & "IVATE VAR \n  fontFace := DefaultFontFace, fontSize := DefaultFontSize;"
 & "\n\nPROC SetFontFace(nm) IS \n  fontFace := nm; lineSep := NIL \nEND;\n"
 & "\nUI SetTool(SetFontFace);\n\nUI Param(SetFontFace, DefaultFontFace);\n"
 & "\nUI Param(SetFontFace, \"Times-Roman\");\n\nUI Param(SetFontFace, \"Ti"
 & "mes-Bold\");\n\nUI Param(SetFontFace, \"Times-Italic\");\n\nUI Param(Se"
 & "tFontFace, \"Times-BoldItalic\");\n\nUI Param(SetFontFace, \"Helvetica\""
 & ");\n\nUI Param(SetFontFace, \"Helvetica-Bold\");\n\nUI Param(SetFontFac"
 & "e, \"Helvetica-Oblique\");\n\nUI Param(SetFontFace, \"Helvetica-BoldObl"
 & "ique\");\n\nUI Param(SetFontFace, \"Courier\")";

CONST E70_0 = 
   ";\n\nUI Param(SetFontFace, \"Courier-Bold\");\n\nUI Param(SetFontFace, "
 & "\"Courier-Oblique\");\n\nUI Param(SetFontFace, \"Courier-BoldOblique\")"
 & ";\n\nUI Param(SetFontFace, \"Symbol\");\n\n(* Change the current font f"
 & "ace to the one named \"nm\". \n   The behavior is undefined if this pro"
 & "cedure is called \n   in the middle of an output line. *)\n\nPROC SetFo"
 & "ntSize(sz) IS \n  fontSize := sz; lineSep := NIL \nEND;\n\nUI SetTool(S"
 & "etFontSize);\n\nUI Param(SetFontSize, DefaultFontSize);\n\nUI Param(Set"
 & "FontSize, PS.Tiny);\n\nUI Param(SetFontSize, PS.Small);\n\nUI Param(Set"
 & "FontSize, PS.Medium);\n\nUI Param(SetFontSize, PS.Big);\n\nUI Param(Set"
 & "FontSize, PS.Large);\n\nUI Param(SetFontSize, PS.Huge);\n\n(* Change th"
 & "e current font size to \"sz\". The behavior is \n   undefined if this p"
 & "rocedure is called in the middle of \n   an output line. *)\n\nCONST De"
 & "faultLineSpacing = 1;\n\n(* This module maintains a current line spacin"
 & "g, which is \n   a multiple of the spacing between consecutive lines \n"
 & "   that is designed into each font. A line spacing value less \n   than"
 & " 1 makes the lines closer together, while a value\n   greater than 1 ma"
 & "kes them further apart. For example, \n   to achieve double spacing, us"
 & "e a line spacing of 2. *)\n\nPRIVATE VAR spacing := DefaultLineSpacing;"
 & "\n\n/* The current line spacing. */\n\nPROC SetLineSpacing(spc) IS spac"
 & "ing := spc END;\n\nUI SetTool(SetLineSpacing);\n\nUI Param(SetLineSpaci"
 & "ng, DefaultLineSpacing);\n\nUI Param(SetLineSpacing, 0.5);\n\nUI Param("
 & "SetLineSpacing, 0.75);\n\nUI Param(SetLineSpacing, 1);\n\nUI Param(SetL"
 & "ineSpacing, 1.5);\n\nUI Param(SetLineSpacing, 2);\n\n(* Set the current"
 & " line spacing to \"spc\". The behavior is \n   undefined if this proced"
 & "ure is called in the middle of \n   an output line. *)\n\n(* \\section{"
 & "Initialization} *)\n\nPROC StartNW(p) IS \n  currPt := p; \n  leftMargi"
 & "n := CAR(p); \n  scrollDir := -1; \n  scrollPending := 1 \nEND;\n\nUI P"
 & "ointTool(StartNW);\n\n(* Start a new virtual terminal whose northwest p"
 & "oint is \n   \"p\". Subsequent lines are printed downward. *)\n\nPROC S"
 & "tartSW(p) IS \n  currPt := p; \n  leftMargin ";

CONST E70_1 = 
   ":= CAR(p); \n  scrollDir := 1; \n  scrollPending := NIL \nEND;\n\nUI Po"
 & "intTool(StartSW);\n\n(* Start a new virtual terminal whose southwest po"
 & "int is \n   \"p\". Subsequent lines are printed upward. *)\n\n(* \\sect"
 & "ion{Printing} *)\n\n(* This module maintains a current print position. "
 & "Each of\n   the following procedures prints text at the current print\n"
 & "   position and advances the print position to the end of\n   the text "
 & "just printed. When a newline character is printed,\n   the print positi"
 & "on is moved so as to simulate a carriage\n   return according to the cu"
 & "rrent font, the current line\n   spacing, and the vertical advancement "
 & "direction. *)\n\nPRIVATE PROC SetLineSep() IS \n  IF \n    lineSep = NI"
 & "L -> lineSep := PS.GetFontPtSize() | SKIP \n  FI \nEND;\n\n/* Set \"lin"
 & "eSep\" from the current font if necessary. */\n\nPRIVATE PROC Scroll() "
 & "IS \n  SetLineSep(); \n  currPt := \n    R2.PlusY(currPt, scrollDir * l"
 & "ineSep * spacing) \nEND;\n\nPRIVATE PROC ScrollIfPending() IS \n  IF sc"
 & "rollPending # NIL -> Scroll() | SKIP FI \nEND;\n\n/* If a scroll is pen"
 & "ding, adjust \"currPt\" vertically. */\n\nPRIVATE PROC NonNLString(txt)"
 & " IS \n  ScrollIfPending(); \n  PS.Type(currPt, txt); \n  currPt := R2.P"
 & "lusX(currPt, PS.StringWidth(txt)) \nEND;\n\n/* Print \"txt\" at the cur"
 & "rent point. \"txt\" is assumed not \n   to contain any newline characte"
 & "rs. */\n\nPRIVATE PROC NewLine() IS \n  currPt := (leftMargin, CDR(curr"
 & "Pt)); \n  IF \n    scrollDir < 0 -> scrollPending := 1 \n  | scrollDir "
 & "> 0 -> Scroll() \n  FI \nEND;\n\n/* Handle a newline character. */\n\nP"
 & "RIVATE CONST NL = Text.GetChar(\"\\n\", 0);\n\nPRIVATE PROC String2(txt"
 & ") IS \n  DO \n    txt # \"\" -> \n      VAR nextNL, len IN \n        ne"
 & "xtNL := Text.FindChar(txt, NL); \n        IF \n          nextNL < 0 -> "
 & "len := Text.Length(txt) \n        | len := nextNL \n        FI; \n     "
 & "   IF \n          len > 0 -> NonNLString(Text.Sub(txt, 0, len)) \n     "
 & "   | SKIP \n        FI; \n        IF \n          nextNL >= 0 -> NewLine"
 & "(); len := len + 1 | SKIP \n        FI; \n        txt := Text.Sub(txt, "
 & "len, 1e6) \n      END \n  OD \nEND;\n\n";

CONST E70_2 = 
   "/* Same as \"String\" below, but this procedure assumes the \n   font h"
 & "as already been set correctly according to \n   \"fontFace\" and \"font"
 & "Size\". */\n\nPROC String(txt) IS \n  VAR nm, sz IN \n    nm, sz := PS."
 & "GetFont(); \n    PS.SetFont(fontFace, fontSize); \n    String2(txt); \n"
 & "    PS.SetFont(nm, sz) \n  END \nEND;\n\nPROC StringNL(txt) IS String(t"
 & "xt & \"\\n\") END;\n\n(* \"String\" prints \"txt\" at the current print"
 & " position as described\n   above. \"StringNL\" is like \"String\", but "
 & "it appends a newline character. *)\n\nPROC Point(p) IS String(Unparse.P"
 & "oint(p)) END;\n\nPROC PointNL(p) IS String(Unparse.Point(p) & \"\\n\") "
 & "END;\n\nUI PointTool(Point);\nUI PointTool(PointNL);\n\n(* \"Point\" pr"
 & "ints the point \"p\" as a pair of reals at the current\n   print positi"
 & "on. The precision to which the real numbers are printed\n   is controll"
 & "ed by the \"Unparse\" module. \"PrintNL\" is like \"Point\",\n   but it"
 & " appends a newline character. *) \n\nPROC Value(val) IS String(Unparse."
 & "Value(val)) END;\n\nPROC ValueNL(val) IS Value(val); String(\"\\n\") EN"
 & "D;\n\n(* \"Value\" prints the unparsed representation of \"val\" at the"
 & " current\n   print position. It uses the \"Unparse.Value\" procedure, w"
 & "hich\n   controls the precision to which any numbers in \"val\" are pri"
 & "nted; \n   that procedure may also do some automatic list breaking. \"V"
 & "alueNL\"\n   is like \"Value\", but it appends a newline character. *)\n"
;

CONST E71 = 
   "MODULE PtLoc;\n\n(* Procedures for labelling points \n   with coordinat"
 & "es. *)\n\n(* It is a checked run-time error \n   if any of the procedur"
 & "es in this \n   module are supplied parameters \n   other than points. "
 & "*)\n\nIMPORT Unparse, PS;\n\nPROC Point(p) IS \n  PS.Type(p, Unparse.Po"
 & "int(p)) \nEND;\n\nUI PointTool(Point);\n\n(* Print the coordinate value"
 & " of \n   \"p\" at location \"p\". *)\n\nPROC MoveTo(p) IS \n  PS.MoveTo"
 & "(p); Point(p) \nEND;\n\nPROC LineTo(p) IS \n  PS.LineTo(p); Point(p) \n"
 & "END;\n\nPROC CurveTo(p, q, r) IS \n  PS.CurveTo(p, q, r); \n  Point(p);"
 & " \n  Point(q); \n  Point(r) \nEND;\n\nUI PointTool(MoveTo);\n\nUI Point"
 & "Tool(LineTo);\n\nUI PointTool(CurveTo);\n\n(* Execute the procedure of "
 & "the \n   same name in the \"PS\" module, \n   but print the coordinate "
 & "of each \n   argument point. *)\n\n";

CONST E72 = 
   "; Copyright (C) 1992, Digital Equipment Corporation                    "
 & "     \n; All rights reserved.                                          "
 & "            \n; See the file COPYRIGHT for a full description.         "
 & "                   \n;                                                 "
 & "                          \n; Last modified on Thu Mar 28 17:44:29 PST "
 & "1996 by heydon\n\n(VTile2\n  (Rim (Pen 8)\n    (VBox\n      (FixedHeigh"
 & "t (TextL \"Defaults:\"))\n      (Space)\n      (Shape (Width2 500) (Hei"
 & "ght 190 + Inf - 150)\n        (Border\n          (TextEdit %configDefau"
 & "lt (BgColor \"White\")\n            ReadOnly (From \"DefaultConfig.sx\""
 & "))\n      ))\n  ))\n  (Rim (Pen 8)\n    (VBox\n      (FixedHeight (Text"
 & "L \"Overrides:\"))\n      (Space)\n      (Shape (Width2 500) (Height 10"
 & "0 + Inf - 60)\n        (Frame Lowered\n          (TextEdit %configOverr"
 & "ides (BgColor \"White\"))\n      ))\n      (Glue 8)\n      (HBox Fill ("
 & "Button %configOk \"  OK  \") Fill)\n  ))\n)\n";

CONST E73 = 
   "MODULE Color;\n\n(* Procedures for manipulating and setting colors. *)\n"
 & "\nIMPORT Math;\n\n(* The procedures in this module manipulate color \n "
 & "  values, which are lists of 3 real numbers \n   corresponding to the l"
 & "ocation of the color in the \n   unit RGB cube. *)\n\nCONST \n  Black ="
 & " [0, 0, 0], \n  White = [1, 1, 1], \n  Red = [1, 0, 0], \n  Green = [0,"
 & " 1, 0], \n  Blue = [0, 0, 1], \n  Cyan = [0, 1, 1], \n  Magenta = [1, 0"
 & ", 1], \n  Yellow = [1, 1, 0],\n  Grey25 = FromGrey(1/4),\n  Grey50 = Fr"
 & "omGrey(1/2),\n  Grey75 = FromGrey(3/4);\n\n(* These colors are the vert"
 & "ices of the unit RGB cube. *)\n\nPROC c := FromGrey(v) IS c := [v, v, v"
 & "] END;\n\n(* Make \"c\" the grey color with value \"v\". The value \"v "
 & "= 0\" produces black,\n   and the value \"v = 1\" produces white. *)\n\n"
 & "PROC c := FromRGB(r, g, b) IS c := [r, g, b] END;\n\n(* Make \"c\" the "
 & "color with RGB values \"r\", \"g\", and \"b\". \n*)\n\nCONST\n  RedHue "
 & "= 0,\n  YellowHue = 1/6,\n  GreenHue = 1/3,\n  CyanHue = 1/2,\n  BlueHu"
 & "e = 2/3,\n  MagentaHue = 5/6;\n\n(* A color may also be specified as a "
 & "hue, saturation, \n   and value (HSV) triple. The hue \"h\" determines "
 & "the \n   pure hue or pigment or the color. The hue varies\n   around th"
 & "e color wheel as indicated by the 6 \"Hue\"\n   constants defined above"
 & ".\n\n   The saturation \"s\" is the intensity of the color. The \n   pu"
 & "re colors have \"s = 1\", while the greys have \"s = \n   0\" (in which"
 & " case the hue is irrelevant and the value \n   determines the shade of "
 & "grey). \n\n   The value \"v\" is the brightness of the color. The \n   "
 & "pure colors have \"v = 1\", while black has \"v = 0\" (in \n   which ca"
 & "se the hue and saturation are both \n   irrelevant). *)\n\nPROC c := Fr"
 & "omHSV(h, s, v) IS \n  IF \n    v = 0 -> c := Black | s = 0 -> c := From"
 & "Grey(v) \n  | IF h = 1 -> h := 0 | SKIP FI; \n    VAR i, f, p, q, t IN "
 & "\n      i := FLOOR(h * 6); \n      f := (h * 6) - i; \n      p := v * ("
 & "1 - s); \n      q := v * (1 - (s * f)); \n      t := v * (1 - (s * (1 -"
 & " f))); \n      IF \n        i < 0.5 -> c := [v, t, p] \n      | i < 1.5"
 & " -> c := [q, v, p] \n      | i < 2.5 -> c :=";

CONST E73_0 = 
   " [p, v, t] \n      | i < 3.5 -> c := [p, q, v] \n      | i < 4.5 -> c :"
 & "= [t, p, v] \n      | i < 5.5 -> c := [v, p, q] \n      FI \n    END \n"
 & "  FI \nEND;\n\n(* Make \"c\" the color with HSV values \"h\", \"s\", an"
 & "d \"v\". \n*)\n\nPROC c := HueN(n) IS\n  c := (Math.Phi * n) MOD 1.0\nE"
 & "ND;\n\n(* This function computes a mapping from integers to hue values "
 & "such\n   that the hues corresponding to the integers 1, 2, ..., n are e"
 & "venly\n   distributed around the color wheel, and such that the hues\n "
 & "  corresponding to subsequent integers are sufficiently distinct to\n  "
 & " be easily distinguished. *)\n";

CONST E74 = 
   "MODULE Time;\n\nPROC t := Now() IS SKIP END;\n\n(* Sets \"t\" to the nu"
 & "mber of seconds since some starting\n   point. The starting point may v"
 & "ary from one invocation\n   of the Juno application to another, but it "
 & "will be fixed\n   throughout a single invocation. *)\n";

CONST E75 = 
   "MODULE Path;\n\n(* Procedures related to PostScript paths *)\n\nIMPORT "
 & "BST, List, Color, R2, Geometry, PS, Bezier, \n       Circle;\n\nPRIVATE"
 & " PROC res := TransformPts(pts, xform) IS \n  IF \n    pts = NIL -> res "
 & ":= NIL \n  | IF \n      VAR pt, tail IN \n        pts = (pt, tail) -> \n"
 & "          res := \n            (APPLY(xform, pt), \n             Transf"
 & "ormPts(tail, xform)) \n      END \n    FI \n  FI \nEND;\n\nPROC newPath"
 & " := Transform(path, xform) IS \n  IF \n    path = NIL -> newPath := NIL"
 & " \n  | IF \n      VAR op, args, tail IN \n        path = ((op, args), t"
 & "ail) -> \n          newPath := \n            ((op, TransformPts(args, x"
 & "form)), \n             Transform(tail, xform)) \n      END \n    FI \n "
 & " FI \nEND;\n\n(* Set \"newPath\" to a representation of the path \n   \""
 & "path\" whose points have been transformed \n   according to the closure"
 & " \"xform\". The argument \n   \"path\" and the result \"newPath\" are p"
 & "aths as \n   represented by the result of the \n   \"PS.CurrentPath\" p"
 & "rocedure. The transformation \n   function \"xform\" should be a closur"
 & "e that takes \n   a single point as an IN parameter, and returns \n   a"
 & " single point as an OUT parameter. *)\n\nPRIVATE PROC AnnotatePoint(pt)"
 & " IS \n  SAVE PS IN \n    PS.NewPath(); \n    Circle.DrawR(pt, 3); \n   "
 & " PS.SetColor(Color.Blue); \n    PS.Fill() \n  END \nEND;\n\nPRIVATE PRO"
 & "C AnnotateVector(from, to) IS \n  SAVE PS IN \n    PS.NewPath(); \n    "
 & "Circle.DrawR(to, 3); \n    PS.SetColor(Color.Red); \n    PS.Fill(); \n "
 & "   PS.MoveTo(from); \n    PS.LineTo(to); \n    PS.SetColor(Color.Grey50"
 & "); \n    PS.Stroke() \n  END \nEND;\n\nPROC Annotate() IS \n  VAR p, la"
 & "stP IN \n    p, lastP := PS.CurrentPath(), NIL; \n    DO \n      p # NI"
 & "L -> \n        VAR op, args IN \n          (op, args) = CAR(p) -> \n   "
 & "         IF \n              op = \"MoveTo\" OR op = \"LineTo\" -> \n   "
 & "             lastP := CAR(args); \n                AnnotatePoint(lastP)"
 & " \n            | op = \"Close\" -> lastP := NIL \n            | op = \""
 & "CurveTo\" -> \n                VAR p1, p2, p3 IN \n                  ar"
 & "gs = [p1, p2, p3] -> \n                    ";

CONST E75_0 = 
   "AnnotateVector(lastP, p1); \n                    AnnotatePoint(p3); \n "
 & "                   AnnotateVector(p3, p2); \n                    lastP "
 & ":= p3 \n                END \n            FI \n        END; \n        p"
 & " := CDR(p) \n    OD \n  END \nEND;\n\nUI PointTool(Annotate);\n\n(* Ann"
 & "otates the current path. The points on the \n   path are shown as small"
 & " blue dots, and the \n   control points of any Bezier curves are shown "
 & "\n   as small red dots. Light grey lines are shown \n   between Bezier "
 & "control points and end points. *)\n\nPROC AppendToCurrent(path) IS \n  "
 & "DO \n    path # NIL -> \n      VAR op, args IN \n        (op, args) = C"
 & "AR(path) -> \n          IF \n            op = \"MoveTo\" -> PS.MoveTo(C"
 & "AR(args)) \n          | op = \"LineTo\" -> PS.LineTo(CAR(args)) \n     "
 & "     | op = \"Close\" -> PS.Close() \n          | op = \"CurveTo\" -> \n"
 & "              VAR p1, p2, p3 IN \n                args = [p1, p2, p3] -"
 & "> \n                  PS.CurveTo(p1, p2, p3) \n              END \n    "
 & "      FI \n      END; \n      path := CDR(path) \n  OD \nEND;\n\n(* App"
 & "end the path \"path\" to the current path; \n   \"path\" should be a pa"
 & "th description as returned \n   by the \"PS.CurrentPath()\" procedure. "
 & "*)\n\nPROC segs := ToSegments(p) IS \n  VAR firstP, currP, offset, end,"
 & " len IN \n    segs, offset := NIL, 0; \n    firstP, currP := NIL, NIL; "
 & "\n    DO \n      p # NIL -> \n        VAR op, args IN \n          (op, "
 & "args) = CAR(p) -> \n            IF \n              op = \"MoveTo\" -> \n"
 & "                firstP := CAR(args); \n                currP := firstP "
 & "\n            | op = \"LineTo\" -> \n                len := \n         "
 & "         Geometry.Dist(currP, CAR(args)); \n                end := offs"
 & "et + len; \n                segs, offset, currP := \n                  "
 & "(([offset, end, len], \n                    [\"Straight\", currP, CAR(a"
 & "rgs)]), \n                   segs), end, CAR(args) \n            | op ="
 & " \"CurveTo\" -> \n                VAR p1, p2, p3 IN \n                 "
 & " args = [p1, p2, p3] -> \n                    len := \n                "
 & "      Bezier.Length(currP, p1";

CONST E75_1 = 
   ", p2, \n                                    p3); \n                    "
 & "end := offset + len; \n                    segs, offset, currP := \n   "
 & "                   (([offset, end, len], \n                        [\"C"
 & "urve\", currP, p1, p2, p3]), \n                       segs), end, p3 \n"
 & "                END \n            | op = \"Close\" -> \n               "
 & " len := Geometry.Dist(currP, firstP); \n                end := offset +"
 & " len; \n                segs, offset, firstP, currP := \n              "
 & "    (([offset, end, len], \n                    [\"Straight\", currP, f"
 & "irstP]), \n                   segs), end, NIL, firstP \n            FI "
 & "\n        END; \n        p := CDR(p) \n    OD \n  END; \n  segs := BST."
 & "FromList(List.Reverse(segs)) \nEND;\n\n(* Set \"segs\" to a list of seg"
 & "ments that \n   represents the straight and curved segments of \n   the"
 & " path \"p\", which should be a path as \n   returned by the \"PS.Curren"
 & "tPath()\" procedure. \n   The \"segs\" result can be passed to the \n  "
 & " \"Length\", \"AtT\", and \"TangentAtT\" procedures \n   below. See the"
 & " private view for a description \n   of how \"segs\" is represented. *)"
 & "\n\n/* The \"segs\" result is a binary search tree of \n   the form: \n"
 & "\n|    segs     ::= tree\n|    tree     ::= ( seg, ( tree, tree ) ) | N"
 & "IL\n|    seg      ::= ( interval, value )\n|    interval ::= [ start, e"
 & "nd, len ]\n|    value    ::= [ type, pt, ... ]\n|    type     ::= \"Str"
 & "aight\" | \"Curved\"\n|    pt       ::= ( x, y )\n\n   In each interval"
 & ", \"start + len = end\", and \n   \"len\" is the length of that segment"
 & ". The \n   segments are arranged in a binary search tree: \n   for all "
 & "nodes \"n\", the interval for \"n\" is at \n   least the interval of it"
 & "s left child, and at \n   most the interval of its right child. The \n "
 & "  proceudure \"BST.FromList\" is used to construct \n   \"segs\", and t"
 & "he procedure \"BST.FindInterval\" is \n   used to search for the segmen"
 & "t containing a \n   given time \"t\". \n\n   If the segment\'s \"type\""
 & " is \"Straight\", then \n   \"pts\" is a list of two points, namely, th"
 & "e \n   segment\'s start and end points. If \"type\"";

CONST E75_2 = 
   " is \n   \"Curved\", then \"pts\" is a list of the four \n   points def"
 & "ining the Bezier curve for that \n   segment. */\n\nPROC len := Length("
 & "segs) IS \n  IF \n    segs = NIL -> len := 0 \n  | IF \n      VAR start"
 & ", end, len1, val, l, r IN \n        segs = (([start, end, len1], val), "
 & "(l, r)) -> \n          len := len1 + Length(l) + Length(r) \n      END "
 & "\n    FI \n  FI \nEND;\n\n(* Set \"len\" to the total length of the seg"
 & "ments \n   \"segs\". *)\n\nPROC pt := AtT(segs, t) IS \n  VAR seg IN \n"
 & "    seg := BST.FindInterval(t, segs); \n    IF \n      VAR start, end, "
 & "len, value IN \n        seg = ([start, end, len], value) -> \n         "
 & " IF \n            VAR from, to IN \n              value = [\"Straight\""
 & ", from, to] -> \n                pt := \n                  ((t - start)"
 & " / len, 0) REL \n                  (from, to) \n            END \n     "
 & "     | VAR p0, p1, p2, p3 IN \n              value = [\"Curve\", p0, p1"
 & ", p2, p3] -> \n                pt := \n                  Bezier.AtT(p0,"
 & " p1, p2, p3, \n                             (t - start) / len) \n      "
 & "      END \n          FI \n      END \n    FI \n  END \nEND;\n\n(* Set "
 & "\"pt\" to the point on the path \"segs\" at \n   time \"t\". Requires \""
 & "0 <= t <= Length(segs)\". *)\n\nPROC tangent := TangentAtT(segs, t) IS "
 & "\n  VAR seg IN \n    seg := BST.FindInterval(t, segs); \n    IF \n     "
 & " VAR from, to IN \n        CDR(seg) = [\"Straight\", from, to] -> \n   "
 & "       tangent := R2.Minus(to, from) \n      END \n    | VAR start, end"
 & ", len, p0, p1, p2, p3 IN \n        seg = \n          ([start, end, len]"
 & ", \n           [\"Curve\", p0, p1, p2, p3]) -> \n          tangent := \n"
 & "            Bezier.PrimeAtT(p0, p1, p2, p3, \n                         "
 & "   (t - start) / len) \n      END \n    FI \n  END \nEND;\n\n(* Set \"p"
 & "t\" to the tangent vector to the point on \n   the path \"segs\" at tim"
 & "e \"t\". Requires \"0 <= t \n   <= Length(segs)\". *)\n\n";

CONST E76 = 
   "P4\n11 8\n\000\000\000\000\377\340\177\300?\200\037\000\016\000\004\000"
;

CONST E77 = 
   "MODULE Arc;\n\n(* Procedures for drawing circular \n   arcs. *)\n\nIMPO"
 & "RT Math, PS, Circle, Geometry, Angle;\n\nPRIVATE FUNC d = ArcPoint(a, b"
 & ", c) IS \n  d ~ c AND \n  (a, b) CONG (b, d) AND \n  Geometry.Colinear("
 & "b, d, c) \nEND;\n\nPRIVATE FUNC \n  e = RightIntersect(a, b, d) IS \n  "
 & "e ~ (0.5, 0.5) REL (a, d) AND \n  Angle.Right(b, a, e) AND \n  Angle.Ri"
 & "ght(b, d, e) \nEND;\n\nPRIVATE CONST MaxCurveRatio = 0.05;\n\n/* If the"
 & " ratio of the distance \n   between endpoints to the radius of \n   cur"
 & "vature is at most \n   \"MaxCurveRatio\", then a straight \n   line is "
 & "drawn instead of a curve. */\n\nPRIVATE PROC SmallArc(b, c) IS \n  VAR "
 & "a, d IN \n    a := PS.CurrentPoint(); \n    d := ArcPoint(a, b, c); \n "
 & "   IF \n      Geometry.Dist(a, d) / \n      Geometry.Dist(a, b) < \n   "
 & "     MaxCurveRatio -> PS.LineTo(d) \n    | VAR \n        e = RightInter"
 & "sect(a, b, d), \n        f ~ Geometry.Mid(a, e), \n        g ~ Geometry"
 & ".Mid(d, e) \n      IN \n        VAR \n          h ~ Geometry.Mid(a, f),"
 & " \n          i ~ Geometry.Mid(f, g), \n          j ~ Geometry.Mid(g, d)"
 & ", \n          k ~ Geometry.Mid(h, i), \n          l ~ Geometry.Mid(i, j"
 & "), \n          m ~ Geometry.Mid(k, l) \n        IN \n          h = Geom"
 & "etry.Mid(a, f) AND \n          i = Geometry.Mid(f, g) AND \n          j"
 & " = Geometry.Mid(g, d) AND \n          k = Geometry.Mid(h, i) AND \n    "
 & "      l = Geometry.Mid(i, j) AND \n          m = Geometry.Mid(k, l) AND"
 & " \n          Geometry.Colinear(a, f, e) AND \n          Geometry.Coline"
 & "ar(d, g, e) AND \n          (a, f) CONG (d, g) AND \n          (a, b) C"
 & "ONG (b, m) -> \n            PS.CurveTo(f, g, d) \n        END \n      E"
 & "ND \n    FI\n  END \nEND;\n\nPRIVATE PROC y := PosAngle(x) IS \n  IF \n"
 & "    x < 0 -> y := x + 2 * Math.Pi \n  | y := x \n  FI \nEND;\n\nPRIVATE"
 & " CONST \n  HalfPi = Math.Pi / 2, \n  Epsilon = 0.001, \n  HalfPiEps = H"
 & "alfPi - Epsilon;\n\nPROC Draw(a, b) IS \n  VAR c, theta IN \n    c := P"
 & "S.CurrentPoint(); \n    theta := \n      PosAngle(Angle.CC(b, a, c)); \n"
 & "    DO \n      theta >= HalfPiEps -> \n        Circle.DrawQuarter(a); \n"
 & "        theta := theta - Ha";

CONST E77_0 = 
   "lfPi \n    OD; \n    IF \n      theta > Epsilon -> SmallArc(a, b) \n   "
 & " | SKIP \n    FI \n  END \nEND;\n\nPROC DrawCC(a, b) IS \n  VAR c, thet"
 & "a IN \n    c := PS.CurrentPoint(); \n    theta := \n      PosAngle(Angl"
 & "e.CC(c, a, b)); \n    DO \n      theta >= HalfPiEps -> \n        Circle"
 & ".DrawQuarterCC(a); \n        theta := theta - HalfPi \n    OD; \n    IF"
 & " \n      theta > Epsilon -> SmallArc(a, b) \n    | SKIP \n    FI \n  EN"
 & "D \nEND;\n\nUI PointTool(Draw);\n\nUI PointTool(DrawCC);\n\n(* Add a cl"
 & "ockwise or \n   counter-clockwise circular arc, \n   respectively, to t"
 & "he current path. \n   In each case, the arc starts at the \n   current "
 & "point, has center \"a\", and \n   ends at a point along the ray \"ab\"."
 & " \n*)\n";

CONST E78 = 
   "MODULE Rel;\n\n(* Functions for specifying \n   coordinates relative to"
 & " some \n   other coordinate system. *)\n\nIMPORT R2;\n\nFUNC q = C1(p, "
 & "a) IS \n  q = R2.Plus(p, a) \nEND;\n\nUI PointTool(C1);\n\n(* \"q\" is "
 & "\"a\" shifted by \"p\". *)\n\nFUNC q = C2(p, a, b) IS \n  q = p REL (a,"
 & " b) \nEND;\n\nUI PointTool(C2);\n\n(* For completeness, \"q\" is \"p RE"
 & "L \n   (a, b)\", namely \"q\" is the point \n   \"p\" in the coordinate"
 & " system in \n   which \"a\" is the origin and \"b\" \n   is the tip of "
 & "the unit x-vector. \n*)\n\nFUNC q = C3(p, a, b, c) IS \n  (E xVec, yVec"
 & ", px, py :: \n    p = (px, py) AND \n    xVec = \n      R2.Times(px, R2"
 & ".Minus(b, a)) AND \n    yVec = \n      R2.Times(py, R2.Minus(c, a)) AND"
 & " \n    q = \n      R2.Plus(a, R2.Plus(xVec, yVec))) \nEND;\n\nUI PointT"
 & "ool(C3);\n\n(* \"q\" is the point \"p\" in the \n   skewed coordinate s"
 & "ystem in \n   which \"a\" is the origin, \"b\" is \n   the tip of the u"
 & "nit x-vector, \n   and \"c\" is the tip of the unit \n   y-vector. *)\n"
 & "\nFUNC q = Inv(p, a, b) IS \n  (E ab, ac, ap, abLen, abLen2,\n     qx, "
 & "qy :: \n    ab = R2.Minus(b, a) AND \n    ac = (-CDR(ab), CAR(ab)) AND "
 & "\n    ap = R2.Minus(p, a) AND \n    abLen = R2.Length(ab) AND \n    abL"
 & "en2 = abLen * abLen AND \n    q = (qx, qy) AND \n    qx = R2.Dot(ap, ab"
 & ") / abLen2 AND \n    qy = R2.Dot(ap, ac) / abLen2) \nEND;\n\nUI PointTo"
 & "ol(Inv);\n\n(* This function is equivalent to \n   \"p = q REL (a, b)\""
 & ", but it can \n   be used functionally to \n   establish useful hints i"
 & "f \"p\", \n   \"a\", and \"b\" are already hinted. \n*)\n\nFUNC x = Inv"
 & "X(p, a, b) IS \n  (E ab, ap, abLen2 :: \n    ab = R2.Minus(b, a) AND \n"
 & "    ap = R2.Minus(p, a) AND \n    abLen2 = R2.Length2(ab) AND \n    x ="
 & " R2.Dot(ap, ab) / abLen2) \nEND;\n\n(* This function is equivalent to \n"
 & "   \"(E y :: p = (x, y) REL (a, b))\".\n   It can be used functionally "
 & "to \n   establish useful hints if \"p\", \n   \"a\", and \"b\" are alre"
 & "ady hinted. \n*)\n\nFUNC y = InvY(p, a, b) IS \n  (E abx, aby, ac, ap, "
 & "acLen2 :: \n    (abx, aby) = R2.Minus(b, a) AND \n    ac = (-aby, abx) "
 & "AND \n    ap = R2.Minus(p, a) AND \n    acLen2 = R2.Length2(ac) AND \n "
 & "   y ";

CONST E78_0 = 
   "= R2.Dot(ap, ac) / acLen2) \nEND;\n\n(* This function is equivalent to "
 & "\n   \"(E x :: p = (x, y) REL (a, b))\".\n   It can be used functionall"
 & "y to \n   establish useful hints if \"p\", \n   \"a\", and \"b\" are al"
 & "ready hinted. \n*)\n\nPRED X(p, a, b, x) IS \n  (E y = InvY(p, a, b) ::"
 & " \n    p = (x, y) REL (a, b)) \nEND;\n\nUI PointTool(X);\n\n(* This con"
 & "straint is equivalent to\n   \"(E y :: p = (x, y) REL (a, b))\",\n   ex"
 & "cept that it picks a smart hint\n   for \"y\". *)\n\nPRED Y(p, a, b, y)"
 & " IS \n  (E x = InvX(p, a, b) :: \n    p = (x, y) REL (a, b)) \nEND;\n\n"
 & "UI PointTool(Y);\n\n(* This constraint is equivalent to\n   \"(E x :: p"
 & " = (x, y) REL (a, b))\",\n   except that it picks a smart hint\n   for "
 & "\"x\". *)\n";


BEGIN
END JunoBundle.
