/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.ArrayTrie;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Trie;

public enum HttpVersion {
    HTTP_0_9("HTTP/0.9", 9),
    HTTP_1_0("HTTP/1.0", 10),
    HTTP_1_1("HTTP/1.1", 11),
    HTTP_2("HTTP/2.0", 20);

    public static final Trie<HttpVersion> CACHE;
    private final String _string;
    private final byte[] _bytes;
    private final ByteBuffer _buffer;
    private final int _version;

    public static HttpVersion lookAheadGet(byte[] bytes2, int position, int limit) {
        int length = limit - position;
        if (length < 9) {
            return null;
        }
        if (bytes2[position + 4] == 47 && bytes2[position + 6] == 46 && Character.isWhitespace((char)bytes2[position + 8]) && (bytes2[position] == 72 && bytes2[position + 1] == 84 && bytes2[position + 2] == 84 && bytes2[position + 3] == 80 || bytes2[position] == 104 && bytes2[position + 1] == 116 && bytes2[position + 2] == 116 && bytes2[position + 3] == 112)) {
            switch (bytes2[position + 5]) {
                case 49: {
                    switch (bytes2[position + 7]) {
                        case 48: {
                            return HTTP_1_0;
                        }
                        case 49: {
                            return HTTP_1_1;
                        }
                    }
                    break;
                }
                case 50: {
                    switch (bytes2[position + 7]) {
                        case 48: {
                            return HTTP_2;
                        }
                    }
                }
            }
        }
        return null;
    }

    public static HttpVersion lookAheadGet(ByteBuffer buffer2) {
        if (buffer2.hasArray()) {
            return HttpVersion.lookAheadGet(buffer2.array(), buffer2.arrayOffset() + buffer2.position(), buffer2.arrayOffset() + buffer2.limit());
        }
        return null;
    }

    private HttpVersion(String s2, int version) {
        this._string = s2;
        this._bytes = StringUtil.getBytes(s2);
        this._buffer = ByteBuffer.wrap(this._bytes);
        this._version = version;
    }

    public byte[] toBytes() {
        return this._bytes;
    }

    public ByteBuffer toBuffer() {
        return this._buffer.asReadOnlyBuffer();
    }

    public int getVersion() {
        return this._version;
    }

    public boolean is(String s2) {
        return this._string.equalsIgnoreCase(s2);
    }

    public String asString() {
        return this._string;
    }

    public String toString() {
        return this._string;
    }

    public static HttpVersion fromString(String version) {
        return CACHE.get(version);
    }

    public static HttpVersion fromVersion(int version) {
        switch (version) {
            case 9: {
                return HTTP_0_9;
            }
            case 10: {
                return HTTP_1_0;
            }
            case 11: {
                return HTTP_1_1;
            }
            case 20: {
                return HTTP_2;
            }
        }
        throw new IllegalArgumentException();
    }

    static {
        CACHE = new ArrayTrie<HttpVersion>();
        for (HttpVersion version : HttpVersion.values()) {
            CACHE.put(version.toString(), version);
        }
    }
}

