/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.eclipse.jetty.util.BufferUtil;

public interface ByteBufferPool {
    public ByteBuffer acquire(int var1, boolean var2);

    public void release(ByteBuffer var1);

    default public void remove(ByteBuffer buffer2) {
    }

    default public ByteBuffer newByteBuffer(int capacity, boolean direct) {
        return direct ? BufferUtil.allocateDirect(capacity) : BufferUtil.allocate(capacity);
    }

    public static class Bucket {
        private final Queue<ByteBuffer> _queue = new ConcurrentLinkedQueue<ByteBuffer>();
        private final ByteBufferPool _pool;
        private final int _capacity;
        private final int _maxSize;
        private final AtomicInteger _size;
        private final AtomicLong _lastUpdate = new AtomicLong(System.nanoTime());

        public Bucket(ByteBufferPool pool, int capacity, int maxSize) {
            this._pool = pool;
            this._capacity = capacity;
            this._maxSize = maxSize;
            this._size = maxSize > 0 ? new AtomicInteger() : null;
        }

        public ByteBuffer acquire() {
            ByteBuffer buffer2 = this.queuePoll();
            if (buffer2 == null) {
                return null;
            }
            if (this._size != null) {
                this._size.decrementAndGet();
            }
            return buffer2;
        }

        @Deprecated
        public ByteBuffer acquire(boolean direct) {
            ByteBuffer buffer2 = this.queuePoll();
            if (buffer2 == null) {
                return this._pool.newByteBuffer(this._capacity, direct);
            }
            if (this._size != null) {
                this._size.decrementAndGet();
            }
            return buffer2;
        }

        public void release(ByteBuffer buffer2) {
            this._lastUpdate.lazySet(System.nanoTime());
            BufferUtil.clear(buffer2);
            if (this._size == null) {
                this.queueOffer(buffer2);
            } else if (this._size.incrementAndGet() <= this._maxSize) {
                this.queueOffer(buffer2);
            } else {
                this._size.decrementAndGet();
            }
        }

        public void clear() {
            this.clear(null);
        }

        void clear(Consumer<ByteBuffer> memoryFn) {
            ByteBuffer buffer2;
            int size;
            int n = size = this._size == null ? 0 : this._size.get() - 1;
            while (size >= 0 && (buffer2 = this.queuePoll()) != null) {
                if (memoryFn != null) {
                    memoryFn.accept(buffer2);
                }
                if (this._size == null) continue;
                this._size.decrementAndGet();
                --size;
            }
        }

        private void queueOffer(ByteBuffer buffer2) {
            this._queue.offer(buffer2);
        }

        private ByteBuffer queuePoll() {
            return this._queue.poll();
        }

        boolean isEmpty() {
            return this._queue.isEmpty();
        }

        int size() {
            return this._queue.size();
        }

        long getLastUpdate() {
            return this._lastUpdate.get();
        }

        public String toString() {
            return String.format("%s@%x{%d/%d@%d}", this.getClass().getSimpleName(), this.hashCode(), this.size(), this._maxSize, this._capacity);
        }
    }

    public static class Lease {
        private final ByteBufferPool byteBufferPool;
        private final List<ByteBuffer> buffers;
        private final List<Boolean> recycles;

        public Lease(ByteBufferPool byteBufferPool) {
            this.byteBufferPool = byteBufferPool;
            this.buffers = new ArrayList<ByteBuffer>();
            this.recycles = new ArrayList<Boolean>();
        }

        public ByteBuffer acquire(int capacity, boolean direct) {
            ByteBuffer buffer2 = this.byteBufferPool.acquire(capacity, direct);
            BufferUtil.clearToFill(buffer2);
            return buffer2;
        }

        public void append(ByteBuffer buffer2, boolean recycle) {
            this.buffers.add(buffer2);
            this.recycles.add(recycle);
        }

        public void insert(int index2, ByteBuffer buffer2, boolean recycle) {
            this.buffers.add(index2, buffer2);
            this.recycles.add(index2, recycle);
        }

        public List<ByteBuffer> getByteBuffers() {
            return this.buffers;
        }

        public long getTotalLength() {
            long length = 0L;
            for (ByteBuffer buffer2 : this.buffers) {
                length += (long)buffer2.remaining();
            }
            return length;
        }

        public int getSize() {
            return this.buffers.size();
        }

        public void recycle() {
            for (int i = 0; i < this.buffers.size(); ++i) {
                ByteBuffer buffer2 = this.buffers.get(i);
                if (!this.recycles.get(i).booleanValue()) continue;
                this.release(buffer2);
            }
            this.buffers.clear();
            this.recycles.clear();
        }

        public void release(ByteBuffer buffer2) {
            this.byteBufferPool.release(buffer2);
        }
    }
}

