/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.repository;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;

public final class ChainedWorkspaceReader
implements WorkspaceReader {
    private List<WorkspaceReader> readers = new ArrayList<WorkspaceReader>();
    private WorkspaceRepository repository;

    public ChainedWorkspaceReader(WorkspaceReader ... readers) {
        if (readers != null) {
            Collections.addAll(this.readers, readers);
        }
        StringBuilder buffer = new StringBuilder();
        for (WorkspaceReader reader2 : this.readers) {
            if (buffer.length() > 0) {
                buffer.append('+');
            }
            buffer.append(reader2.getRepository().getContentType());
        }
        this.repository = new WorkspaceRepository(buffer.toString(), new Key(this.readers));
    }

    public static WorkspaceReader newInstance(WorkspaceReader reader1, WorkspaceReader reader2) {
        if (reader1 == null) {
            return reader2;
        }
        if (reader2 == null) {
            return reader1;
        }
        return new ChainedWorkspaceReader(reader1, reader2);
    }

    @Override
    public File findArtifact(Artifact artifact) {
        WorkspaceReader reader2;
        File file2 = null;
        Iterator<WorkspaceReader> iterator = this.readers.iterator();
        while (iterator.hasNext() && (file2 = (reader2 = iterator.next()).findArtifact(artifact)) == null) {
        }
        return file2;
    }

    @Override
    public List<String> findVersions(Artifact artifact) {
        LinkedHashSet<String> versions = new LinkedHashSet<String>();
        for (WorkspaceReader reader2 : this.readers) {
            versions.addAll(reader2.findVersions(artifact));
        }
        return Collections.unmodifiableList(new ArrayList(versions));
    }

    @Override
    public WorkspaceRepository getRepository() {
        Key key2 = new Key(this.readers);
        if (!key2.equals(this.repository.getKey())) {
            this.repository = new WorkspaceRepository(this.repository.getContentType(), key2);
        }
        return this.repository;
    }

    private static class Key {
        private final List<Object> keys = new ArrayList<Object>();

        Key(List<WorkspaceReader> readers) {
            for (WorkspaceReader reader2 : readers) {
                this.keys.add(reader2.getRepository().getKey());
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            return this.keys.equals(((Key)obj).keys);
        }

        public int hashCode() {
            return this.keys.hashCode();
        }
    }
}

