/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import org.eclipse.jgit.util.StringUtils;

class ConfigLine {
    String prefix;
    String section;
    String subsection;
    String name;
    String value;
    String suffix;

    ConfigLine() {
    }

    ConfigLine forValue(String newValue) {
        ConfigLine e2 = new ConfigLine();
        e2.prefix = this.prefix;
        e2.section = this.section;
        e2.subsection = this.subsection;
        e2.name = this.name;
        e2.value = newValue;
        e2.suffix = this.suffix;
        return e2;
    }

    boolean match(String aSection, String aSubsection, String aKey) {
        return ConfigLine.eqIgnoreCase(this.section, aSection) && ConfigLine.eqSameCase(this.subsection, aSubsection) && ConfigLine.eqIgnoreCase(this.name, aKey);
    }

    boolean match(String aSection, String aSubsection) {
        return ConfigLine.eqIgnoreCase(this.section, aSection) && ConfigLine.eqSameCase(this.subsection, aSubsection);
    }

    private static boolean eqIgnoreCase(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return StringUtils.equalsIgnoreCase(a, b);
    }

    private static boolean eqSameCase(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public String toString() {
        if (this.section == null) {
            return "<empty>";
        }
        StringBuilder b = new StringBuilder(this.section);
        if (this.subsection != null) {
            b.append(".").append(this.subsection);
        }
        if (this.name != null) {
            b.append(".").append(this.name);
        }
        if (this.value != null) {
            b.append("=").append(this.value);
        }
        return b.toString();
    }
}

