
//              Copyright Catch2 Authors
// Distributed under the Boost Software License, Version 1.0.
//   (See accompanying file LICENSE.txt or copy at
//        https://www.boost.org/LICENSE_1_0.txt)

// SPDX-License-Identifier: BSL-1.0
#include <catch2/matchers/catch_matchers_exception.hpp>

namespace Catch {
    namespace Matchers {

        bool ExceptionMessageMatcher::match( std::exception const& ex ) const {
            return ex.what() == m_message;
        }

        std::string ExceptionMessageMatcher::describe() const {
            return "exception message matches \"" + m_message + '"';
        }

        ExceptionMessageMatcher Message( std::string const& message ) {
            return ExceptionMessageMatcher( message );
        }

    } // namespace Matchers
} // namespace Catch
