
//              Copyright Catch2 Authors
// Distributed under the Boost Software License, Version 1.0.
//   (See accompanying file LICENSE.txt or copy at
//        https://www.boost.org/LICENSE_1_0.txt)

// SPDX-License-Identifier: BSL-1.0
#include <catch2/internal/catch_enforce.hpp>
#include <catch2/internal/catch_stdstreams.hpp>

#include <stdexcept>

namespace Catch {
#if defined( CATCH_CONFIG_DISABLE_EXCEPTIONS ) && \
    !defined( CATCH_CONFIG_DISABLE_EXCEPTIONS_CUSTOM_HANDLER )
    [[noreturn]] void throw_exception( std::exception const& e ) {
        Catch::cerr()
            << "Catch will terminate because it needed to throw an exception.\n"
            << "The message was: " << e.what() << '\n';
        std::terminate();
    }
#endif

    [[noreturn]] void throw_logic_error( std::string const& msg ) {
        throw_exception( std::logic_error( msg ) );
    }

    [[noreturn]] void throw_domain_error( std::string const& msg ) {
        throw_exception( std::domain_error( msg ) );
    }

    [[noreturn]] void throw_runtime_error( std::string const& msg ) {
        throw_exception( std::runtime_error( msg ) );
    }

} // namespace Catch
