/* term_info.h - A list of terminals and a few capabilities */

/*
 * This file is part of CliFM
 *
 * Copyright (C) 2016-2022, L. Abramovich <johndoe.arch@outlook.com>
 * All rights reserved.

 * CliFM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CliFM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
*/

/* Shell script used to create this list. This list should be recreated
 * for every new release */

//#!/bin/sh
//
//file="/tmp/term_info"
//
//rm -- "$file" 2>/dev/null
//
//for i in /usr/share/terminfo/*/*; do
//	name="$(echo "$i" | cut -d/ -f6)"
//	num_colors="$(tput -T "$name" colors 2>/dev/null)"
//	# CURPOS: Request current cursor position
//	curpos="$(tput -T "$name" u7 2>/dev/null)"
//	# CUP: Set cursor to specified COLUMN and LINE 
//	cup="$(tput -T "$name" cup 2>/dev/null | tr -d '\0')"
//
//	[ -z "$num_colors" ] && num_colors=-1
//
//	if [ "$num_colors" = -1 ] && { [ -z "$curpos" ] || [ -z "$cup" ]; }; then
//		continue
//	fi
//
//	req_curpos=0
//	[ -n "$curpos" ] && [ -n "$cup" ] && req_curpos=1
//
//	echo "{\"$name\", ${#name}, $num_colors, $req_curpos}," >> "$file"
//done
//
//exit 1

#ifndef TERM_INFO_H
#define TERM_INFO_H

struct terms_t {
	char *name; /* Terminal name as found in $TERM and the terminfo database */

	/* Let's hardcode the length of each terminal name to prevent unnecessary
	 * calls to strlen(3): comparing the first byte and this length to those
	 * of the current terminal is 99% of the time enough */
	size_t len;
	int color; /* -1 means no color support */
	int req_curpos; /* is terminal able to get/set cursor position? */
};

const struct terms_t TERM_INFO[] = {
	{"386at", 5, 8, 0},
	{"absolute", 8, 256, 1},
	{"aixterm", 7, 8, 0},
	{"aixterm-16color", 15, 16, 0},
	{"alacritty", 9, 256, 1},
	{"alacritty+common", 16, 8, 1},
	{"alacritty-direct", 16, 16777216, 1},
	{"amiga-vnc", 9, 16, 0},
	{"ansi", 4, 8, 1},
	{"ansi80x25", 9, 8, 0},
	{"ansi80x25-raw", 13, 8, 0},
	{"ansi80x30", 9, 8, 0},
	{"ansi80x43", 9, 8, 0},
	{"ansi80x50", 9, 8, 0},
	{"ansi80x60", 9, 8, 0},
	{"ansi-color-2-emx", 16, 8, 1},
	{"ansi-color-3-emx", 16, 8, 1},
	{"ansi-emx", 8, 8, 1},
	{"ansil", 5, 8, 0},
	{"ansis", 5, 8, 0},
	{"ansi.sys", 8, 8, 1},
	{"ansi.sysk", 9, 8, 1},
	{"ansisysk", 8, 8, 1},
	{"ansi.sys-old", 12, 8, 1},
	{"ansiw", 5, 8, 0},
	{"Apple_Terminal", 14, 256, 1},
	{"arm100", 6, 8, 0},
	{"arm100-am", 9, 8, 0},
	{"arm100-w", 8, 8, 0},
	{"arm100-wam", 10, 8, 0},
	{"at386", 5, 8, 0},
	{"atari-color", 11, 16, 0},
	{"atari_st-color", 14, 16, 0},
	{"at-color", 8, 16, 0},
	{"aterm", 5, 8, 1},
	{"att6386", 7, 8, 0},
	{"beterm", 6, 8, 1},
	{"bsdos-pc", 8, 8, 0},
	{"bsdos-pc-nobold", 15, 8, 0},
	{"bsdos-ppc", 9, 8, 0},
	{"bterm", 5, 8, 0},
	{"cit101e-rv", 10, -1, 1},
	{"color_xterm", 11, 8, 0},
	{"cons25", 6, 8, 0},
	{"cons25-debian", 13, 8, 0},
	{"cons25-iso8859", 14, 8, 0},
	{"cons25-koi8-r", 13, 8, 0},
	{"cons25l1", 8, 8, 0},
	{"cons25r", 7, 8, 0},
	{"cons25w", 7, 8, 0},
	{"cons30", 6, 8, 0},
	{"cons43", 6, 8, 0},
	{"cons50", 6, 8, 0},
	{"cons50-iso8859", 14, 8, 0},
	{"cons50-koi8r", 12, 8, 0},
	{"cons50l1", 8, 8, 0},
	{"cons50r", 7, 8, 0},
	{"cons60", 6, 8, 0},
	{"cons60-iso", 10, 8, 0},
	{"cons60-koi8r", 12, 8, 0},
	{"cons60l1", 8, 8, 0},
	{"cons60r", 7, 8, 0},
	{"crt", 3, 8, 1},
	{"crt-vt220", 9, 8, 1},
	{"ctrm", 4, 8, 0},
	{"cx", 2, 8, 0},
	{"cx100", 5, 8, 0},
	{"cygwin", 6, 8, 1},
	{"cygwinB19", 9, 8, 1},
	{"cygwinDBG", 9, 8, 1},
	{"d220", 4, 8, 0},
	{"d220-7b", 7, 8, 0},
	{"d220-dg", 7, 8, 0},
	{"d230", 4, 8, 0},
	{"d230c", 5, 8, 0},
	{"d230c-dg", 8, 8, 0},
	{"d230-dg", 7, 8, 0},
	{"d430c-dg", 8, 16, 0},
	{"d430c-dg-ccc", 12, 52, 0},
	{"d430c-unix", 10, 16, 0},
	{"d430c-unix-25", 13, 16, 0},
	{"d430c-unix-25-ccc", 17, 52, 0},
	{"d430c-unix-ccc", 14, 52, 0},
	{"d430c-unix-s", 12, 16, 0},
	{"d430c-unix-s-ccc", 16, 52, 0},
	{"d430c-unix-sr", 13, 16, 0},
	{"d430c-unix-sr-ccc", 17, 52, 0},
	{"d430c-unix-w", 12, 16, 0},
	{"d430c-unix-w-ccc", 16, 52, 0},
	{"d430-dg", 7, 16, 0},
	{"d430-dg-ccc", 11, 52, 0},
	{"d430-unix", 9, 16, 0},
	{"d430-unix-25", 12, 16, 0},
	{"d430-unix-25-ccc", 16, 52, 0},
	{"d430-unix-ccc", 13, 52, 0},
	{"d430-unix-s", 11, 16, 0},
	{"d430-unix-s-ccc", 15, 52, 0},
	{"d430-unix-sr", 12, 16, 0},
	{"d430-unix-sr-ccc", 16, 52, 0},
	{"d430-unix-w", 11, 16, 0},
	{"d430-unix-w-ccc", 15, 52, 0},
	{"d470", 4, 16, 0},
	{"d470-7b", 7, 16, 0},
	{"d470c", 5, 16, 0},
	{"d470c-7b", 8, 16, 0},
	{"d470c-dg", 8, 16, 0},
	{"d470-dg", 7, 16, 0},
	{"darwin", 6, 8, 0},
	{"darwin-100x37", 13, 8, 0},
	{"darwin-112x37", 13, 8, 0},
	{"darwin-128x40", 13, 8, 0},
	{"darwin-128x48", 13, 8, 0},
	{"darwin-144x48", 13, 8, 0},
	{"darwin-160x64", 13, 8, 0},
	{"darwin-200x64", 13, 8, 0},
	{"darwin-200x75", 13, 8, 0},
	{"darwin-256x96", 13, 8, 0},
	{"darwin-80x25", 12, 8, 0},
	{"darwin-80x30", 12, 8, 0},
	{"darwin-90x30", 12, 8, 0},
	{"darwin-b", 8, 8, 0},
	{"darwin-f", 8, 8, 0},
	{"darwin-f2", 9, 8, 0},
	{"decansi", 7, 8, 1},
	{"dec-vt220", 9, -1, 1},
	{"dg460-ansi", 10, -1, 1},
	{"dg+ccc", 6, 52, 0},
	{"dg+color", 8, 16, 0},
	{"dg+color8", 9, 8, 0},
	{"dg+fixed", 8, 16, 0},
	{"dgmode+color", 12, 16, 0},
	{"dgmode+color8", 13, 8, 0},
	{"dgunix+ccc", 10, 52, 0},
	{"dgunix+fixed", 12, 16, 0},
	{"djgpp", 5, 8, 0},
	{"djgpp204", 8, 8, 0},
	{"domterm", 7, 256, 1},
	{"dtterm", 6, 8, 0},
	{"dumb-emacs-ansi", 15, 8, 0},
	{"dvtm", 4, 8, 0},
	{"dvtm-256color", 13, 256, 0},
	{"ecma+color", 10, 8, 0},
	{"emots", 5, 8, 0},
	{"emu", 3, 15, 0},
	{"emx-base", 8, 8, 1},
	{"Eterm", 5, 8, 1},
	{"Eterm-256color", 14, 256, 1},
	{"Eterm-88color", 13, 88, 1},
	{"eterm-color", 11, 8, 1},
	{"Eterm-color", 11, 8, 1},
	{"fbterm", 6, 256, 1},
	{"foot", 4, 256, 1},
	{"foot+base", 9, -1, 1},
	{"foot-direct", 11, 16777216, 1},
	{"gnome", 5, 8, 1},
	{"gnome-2007", 10, 8, 1},
	{"gnome-2008", 10, 8, 1},
	{"gnome-2012", 10, 8, 1},
	{"gnome-256color", 14, 256, 1},
	{"gnome-fc5", 9, 8, 1},
	{"gnome-rh62", 10, 8, 1},
	{"gnome-rh72", 10, 8, 1},
	{"gnome-rh80", 10, 8, 1},
	{"gnome-rh90", 10, 8, 1},
	{"gs6300", 6, 8, 0},
	{"hft", 3, 8, 0},
	{"hft-c", 5, 8, 0},
	{"hft-c-old", 9, 8, 0},
	{"hft-old", 7, 8, 0},
	{"hp2397", 6, 16, 0},
	{"hp2397a", 7, 16, 0},
	{"hp98550a-color", 14, 8, 1},
	{"hp98550-color", 13, 8, 1},
	{"hp+color", 8, 16, 0},
	{"hpterm-color", 12, 64, 0},
	{"hpterm-color2", 13, 8, 0},
	{"hterm", 5, 8, 1},
	{"hterm-256color", 14, 256, 1},
	{"hurd", 4, 8, 0},
	{"i3164", 5, 8, 0},
	{"ibm+16color", 11, 16, 0},
	{"ibm3164", 7, 8, 0},
	{"ibm5081", 7, 8, 0},
	{"ibm5154", 7, 8, 0},
	{"ibm6154", 7, 8, 0},
	{"ibm8503", 7, 8, 0},
	{"ibm8507", 7, 8, 0},
	{"ibm8512", 7, 8, 0},
	{"ibm8513", 7, 8, 0},
	{"ibm8514", 7, 8, 0},
	{"ibm8604", 7, 8, 0},
	{"ibm+color", 9, 8, 0},
	{"ibmpc3", 6, 8, 0},
	{"ibmpc3r", 7, 8, 0},
	{"interix", 7, 8, 0},
	{"interix-nti", 11, 8, 0},
	{"iris-color", 10, 8, 1},
	{"iterm", 5, 256, 1},
	{"iterm2", 6, 256, 1},
	{"iTerm2.app", 10, 256, 1},
	{"iterm2-direct", 13, 16777216, 1},
	{"iTerm.app", 9, 256, 1},
	{"jaixterm", 8, 8, 0},
	{"jfbterm", 7, 8, 1},
	{"kitty", 5, 256, 1},
	{"kitty+common", 12, -1, 1},
	{"kitty-direct", 12, 16777216, 1},
	{"klone+color", 11, 8, 0},
	{"kon", 3, 8, 1},
	{"kon2", 4, 8, 1},
	{"konsole", 7, 8, 1},
	{"konsole-16color", 15, 16, 1},
	{"konsole-256color", 16, 256, 1},
	{"konsole-base", 12, 8, 1},
	{"konsole-direct", 14, 16777216, 1},
	{"konsole-linux", 13, 8, 1},
	{"konsole-solaris", 15, 8, 1},
	{"konsole-vt100", 13, 8, 1},
	{"konsole-vt420pc", 15, 8, 1},
	{"konsole-xf3x", 12, 8, 1},
	{"konsole-xf4x", 12, 8, 1},
	{"kterm", 5, 8, 1},
	{"kterm-co", 8, 8, 1},
	{"kterm-color", 11, 8, 1},
	{"kvt", 3, 8, 1},
	{"linux", 5, 8, 1},
	{"linux-16color", 13, 16, 1},
	{"linux2.2", 8, 8, 1},
	{"linux2.6", 8, 8, 1},
	{"linux2.6.26", 11, 8, 1},
	{"linux3.0", 8, 8, 1},
	{"linux-basic", 11, 8, 1},
	{"linux-c", 7, 8, 1},
	{"linux-c-nc", 10, 8, 1},
	{"linux-koi8", 10, 8, 1},
	{"linux-koi8r", 11, 8, 1},
	{"linux-lat", 9, 8, 1},
	{"linux-m", 7, -1, 1},
	{"linux-m1", 8, 8, 1},
	{"linux-m1b", 9, -1, 1},
	{"linux-m2", 8, -1, 1},
	{"linux-nic", 9, 8, 1},
	{"linux-s", 7, 8, 1},
	{"linux-vt", 8, 8, 1},
	{"m2-nam", 6, -1, 1},
	{"mach-color", 10, 8, 0},
	{"mach-gnu-color", 14, 8, 0},
	{"mgt", 3, 8, 1},
	{"mgterm", 6, 8, 0},
	{"minitel", 7, -1, 1},
	{"minitel1", 8, 8, 1},
	{"minitel12-80", 12, -1, 1},
	{"minitel1b", 9, 8, 1},
	{"minitel1b-nb", 12, -1, 1},
	{"minitel1-nb", 11, -1, 1},
	{"minitel-2", 9, -1, 1},
	{"minitel2-80", 11, -1, 1},
	{"minitel-2-nam", 13, -1, 1},
	{"minix", 5, 8, 0},
	{"minix-3.0", 9, 8, 0},
	{"mintty", 6, 256, 1},
	{"mintty+common", 13, 8, 1},
	{"mintty-direct", 13, 16777216, 1},
	{"mlterm", 6, 8, 1},
	{"mlterm2", 7, 8, 1},
	{"mlterm-256color", 15, 256, 1},
	{"mlterm3", 7, 8, 1},
	{"mlterm-direct", 13, 16777216, 1},
	{"mrxvt", 5, 8, 1},
	{"mrxvt-256color", 14, 256, 1},
	{"ms-terminal", 11, 256, 1},
	{"ms-vt100", 8, -1, 1},
	{"ms-vt100+", 9, 8, 1},
	{"ms-vt100-color", 14, 8, 1},
	{"ms-vt-utf8", 10, 8, 1},
	{"mvterm", 6, 8, 0},
	{"nansi.sys", 9, 8, 1},
	{"nansisys", 8, 8, 1},
	{"nansi.sysk", 10, 8, 1},
	{"nansisysk", 9, 8, 1},
	{"ncr260intan", 11, 8, 0},
	{"ncr260intpp", 11, 8, 0},
	{"ncr260intwan", 12, 8, 0},
	{"ncr260intwpp", 12, 8, 0},
	{"ncr260wy325pp", 13, 16, 0},
	{"ncr260wy325wpp", 14, 16, 0},
	{"ncr260wy350pp", 13, 16, 0},
	{"ncr260wy350wpp", 14, 16, 0},
	{"ncsa", 4, 8, 1},
	{"ncsa-m", 6, -1, 1},
	{"ncsa-m-ns", 9, -1, 1},
	{"ncsa-ns", 7, 8, 1},
	{"ncsa-vt220", 10, 8, 1},
	{"ncsa-vt220-8", 12, -1, 1},
	{"netbsd6", 7, 8, 1},
	{"nsterm", 6, 256, 1},
	{"nsterm-16color", 14, 16, 1},
	{"nsterm-256color", 15, 256, 1},
	{"nsterm+7", 8, -1, 1},
	{"nsterm-7", 8, 8, 1},
	{"nsterm-7-c", 10, 16, 1},
	{"nsterm-7-c-s", 12, 16, 1},
	{"nsterm-7-m", 10, -1, 1},
	{"nsterm-7-m-s", 12, -1, 1},
	{"nsterm-7-s", 10, 8, 1},
	{"nsterm+acs", 10, -1, 1},
	{"nsterm-acs", 10, 8, 1},
	{"nsterm-acs-c", 12, 16, 1},
	{"nsterm-acs-c-s", 14, 16, 1},
	{"nsterm-acs-m", 12, -1, 1},
	{"nsterm-acs-m-s", 14, -1, 1},
	{"nsterm-acs-s", 12, 8, 1},
	{"nsterm-bce", 10, 16, 1},
	{"nsterm-build309", 15, 256, 1},
	{"nsterm-build326", 15, 256, 1},
	{"nsterm-build343", 15, 256, 1},
	{"nsterm-build361", 15, 256, 1},
	{"nsterm-build400", 15, 256, 1},
	{"nsterm+c", 8, 16, 0},
	{"nsterm-c", 8, 16, 1},
	{"nsterm+c41", 10, 8, 0},
	{"nsterm-c-7", 10, 16, 1},
	{"nsterm-c-acs", 12, 16, 1},
	{"nsterm-c-s", 10, 16, 1},
	{"nsterm-c-s-7", 12, 16, 1},
	{"nsterm-c-s-acs", 14, 16, 1},
	{"nsterm-direct", 13, 16777216, 1},
	{"nsterm-m", 8, -1, 1},
	{"nsterm-m-7", 10, -1, 1},
	{"nsterm+mac", 10, -1, 1},
	{"nsterm-m-acs", 12, -1, 1},
	{"nsterm-m-s", 10, -1, 1},
	{"nsterm-m-s-7", 12, -1, 1},
	{"nsterm-m-s-acs", 14, -1, 1},
	{"nsterm-old", 10, 8, 1},
	{"nsterm-s", 8, 8, 1},
	{"nsterm-s-7", 10, 8, 1},
	{"nsterm-s-acs", 12, 8, 1},
	{"ntconsole", 9, 8, 0},
	{"ntconsole-100", 13, 8, 0},
	{"ntconsole-100-nti", 17, 8, 0},
	{"ntconsole-25", 12, 8, 0},
	{"ntconsole-25-nti", 16, 8, 0},
	{"ntconsole-25-w", 14, 8, 0},
	{"ntconsole-25-w-vt", 17, 8, 0},
	{"ntconsole-35", 12, 8, 0},
	{"ntconsole-35-nti", 16, 8, 0},
	{"ntconsole-35-w", 14, 8, 0},
	{"ntconsole-50", 12, 8, 0},
	{"ntconsole-50-nti", 16, 8, 0},
	{"ntconsole-50-w", 14, 8, 0},
	{"ntconsole-60", 12, 8, 0},
	{"ntconsole-60-nti", 16, 8, 0},
	{"ntconsole-60-w", 14, 8, 0},
	{"ntconsole-w", 11, 8, 0},
	{"ntconsole-w-vt", 14, 8, 0},
	{"nwp-517", 7, -1, 1},
	{"nwp517", 6, -1, 1},
	{"nwp-517-w", 9, -1, 1},
	{"nwp517-w", 8, -1, 1},
	{"nxterm", 6, 8, 1},
	{"old-st", 6, 8, 0},
	{"opennt", 6, 8, 0},
	{"opennt-100", 10, 8, 0},
	{"opennt-100-nti", 14, 8, 0},
	{"opennt-25", 9, 8, 0},
	{"opennt-25-nti", 13, 8, 0},
	{"opennt-25-w", 11, 8, 0},
	{"opennt-25-w-vt", 14, 8, 0},
	{"opennt-35", 9, 8, 0},
	{"opennt-35-nti", 13, 8, 0},
	{"opennt-35-w", 11, 8, 0},
	{"opennt-50", 9, 8, 0},
	{"opennt-50-nti", 13, 8, 0},
	{"opennt-50-w", 11, 8, 0},
	{"opennt-60", 9, 8, 0},
	{"opennt-60-nti", 13, 8, 0},
	{"opennt-60-w", 11, 8, 0},
	{"opennt-nti", 10, 8, 0},
	{"opennt-w", 8, 8, 0},
	{"opennt-w-vt", 11, 8, 0},
	{"pc3", 3, 8, 0},
	{"pc3-bold", 8, 8, 0},
	{"pc3r", 4, 8, 0},
	{"pcansi", 6, 8, 0},
	{"pcansi-25", 9, 8, 0},
	{"pcansi25", 8, 8, 0},
	{"pcansi-33", 9, 8, 0},
	{"pcansi33", 8, 8, 0},
	{"pcansi-43", 9, 8, 0},
	{"pcansi43", 8, 8, 0},
	{"pccon", 5, 8, 1},
	{"pccon0", 6, 8, 1},
	{"pccon0-m", 8, -1, 1},
	{"pccon+base", 10, -1, 1},
	{"pccon+colors", 12, 8, 0},
	{"pccon-m", 7, -1, 1},
	{"pc-minix", 8, 8, 0},
	{"pcvt25-color", 12, 8, 0},
	{"putty", 5, 8, 1},
	{"putty-256color", 14, 256, 1},
	{"putty-m1", 8, 8, 1},
	{"putty-m1b", 9, -1, 1},
	{"putty-m2", 8, -1, 1},
	{"putty-noapp", 11, 8, 1},
	{"putty-sco", 9, 8, 1},
	{"putty-screen", 12, 8, 1},
	{"putty-vt100", 11, 8, 1},
	{"qansi", 5, 8, 0},
	{"qansi-g", 7, 8, 0},
	{"qansi-m", 7, 8, 0},
	{"qansi-t", 7, 8, 0},
	{"qansi-w", 7, 8, 0},
	{"qnx", 3, 8, 0},
	{"qnx4", 4, 8, 0},
	{"qnxm", 4, 8, 0},
	{"qnxt", 4, 8, 0},
	{"qnxt2", 5, 8, 0},
	{"qnxt4", 5, 8, 0},
	{"qnxw", 4, 8, 0},
	{"rcons-color", 11, 8, 0},
	{"rxvt", 4, 8, 1},
	{"rxvt-16color", 12, 16, 1},
	{"rxvt-256color", 13, 256, 1},
	{"rxvt-88color", 12, 88, 1},
	{"rxvt-basic", 10, -1, 1},
	{"rxvt-color", 10, 8, 1},
	{"rxvt-cygwin", 11, 8, 1},
	{"rxvt-cygwin-native", 18, 8, 1},
	{"rxvt-unicode", 12, 88, 1},
	{"rxvt-unicode-256color", 21, 256, 1},
	{"rxvt-xpm", 8, 8, 1},
	{"scoansi", 7, 8, 0},
	{"scoansi-new", 11, 8, 0},
	{"scoansi-old", 11, 8, 0},
	{"screen", 6, 8, 1},
	{"screen-16color", 14, 16, 1},
	{"screen-16color-bce", 18, 16, 1},
	{"screen-16color-bce-s", 20, 16, 1},
	{"screen-16color-s", 16, 16, 1},
	{"screen-256color", 15, 256, 1},
	{"screen-256color-bce", 19, 256, 1},
	{"screen-256color-bce-s", 21, 256, 1},
	{"screen-256color-s", 17, 256, 1},
	{"screen4", 7, 8, 1},
	{"screen5", 7, 8, 1},
	{"screen-bce", 10, 8, 1},
	{"screen-bce.Eterm", 16, 8, 1},
	{"screen-bce.gnome", 16, 8, 1},
	{"screen-bce.konsole", 18, 8, 1},
	{"screen-bce.linux", 16, 8, 1},
	{"screen-bce.mrxvt", 16, 8, 1},
	{"screen-bce.rxvt", 15, 8, 1},
	{"screen-bce.xterm-new", 20, 8, 1},
	{"screen.Eterm", 12, 8, 1},
	{"screen.gnome", 12, 8, 1},
	{"screen.konsole", 14, 8, 1},
	{"screen.konsole-256color", 23, 256, 1},
	{"screen.linux", 12, 8, 1},
	{"screen.linux-m1", 15, 8, 1},
	{"screen.linux-m1b", 16, -1, 1},
	{"screen.linux-m2", 15, -1, 1},
	{"screen.linux-s", 14, 8, 1},
	{"screen.minitel1", 15, 8, 1},
	{"screen.minitel12-80", 19, -1, 1},
	{"screen.minitel1b", 16, 8, 1},
	{"screen.minitel1b-80", 19, -1, 1},
	{"screen.minitel1b-nb", 19, -1, 1},
	{"screen.minitel1-nb", 18, -1, 1},
	{"screen.minitel2-80", 18, -1, 1},
	{"screen.mlterm", 13, 8, 1},
	{"screen.mlterm-256color", 22, 256, 1},
	{"screen.mrxvt", 12, 8, 1},
	{"screen.putty", 12, 8, 1},
	{"screen.putty-256color", 21, 256, 1},
	{"screen.putty-m1", 15, 8, 1},
	{"screen.putty-m1b", 16, -1, 1},
	{"screen.putty-m2", 15, -1, 1},
	{"screen.rxvt", 11, 8, 1},
	{"screen-s", 8, 8, 1},
	{"screen.teraterm", 15, 8, 1},
	{"screen.vte", 10, 8, 1},
	{"screen.vte-256color", 19, 256, 1},
	{"screen-w", 8, 8, 1},
	{"screen.xterm-256color", 21, 256, 1},
	{"screen.xterm-new", 16, 8, 1},
	{"screen.xterm-r6", 15, -1, 1},
	{"screen.xterm-xfree86", 20, 8, 1},
	{"scrt", 4, 256, 1},
	{"securecrt", 9, 256, 1},
	{"simpleterm", 10, 8, 0},
	{"st", 2, 8, 1},
	{"st-0.6", 6, 8, 1},
	{"st-0.7", 6, 8, 1},
	{"st-0.8", 6, 8, 1},
	{"st-16color", 10, 16, 1},
	{"st-256color", 11, 256, 1},
	{"st52-color", 10, 16, 0},
	{"st-direct", 9, 16777216, 1},
	{"stterm", 6, 8, 1},
	{"stterm-16color", 14, 16, 1},
	{"stterm-256color", 15, 256, 1},
	{"sun-color", 9, 8, 0},
	{"tek4205", 7, 8, 0},
	{"teken", 5, 8, 1},
	{"teraterm", 8, 8, 1},
	{"teraterm2.3", 11, 8, 1},
	{"teraterm-256color", 17, 256, 1},
	{"teraterm4.59", 12, 8, 1},
	{"teraterm4.97", 12, 8, 1},
	{"terminator", 10, 256, 0},
	{"terminology", 11, 256, 1},
	{"terminology-0.6.1", 17, 256, 0},
	{"terminology-1.0.0", 17, 256, 0},
	{"terminology-1.8.1", 17, 256, 1},
	{"termite", 7, 256, 1},
	{"ti916", 5, -1, 1},
	{"ti916-132", 9, -1, 1},
	{"ti916-220-7", 11, -1, 1},
	{"ti916-220-8", 11, -1, 1},
	{"ti916-8", 7, -1, 1},
	{"ti916-8-132", 11, -1, 1},
	{"ti928", 5, 8, 0},
	{"ti928-8", 7, 8, 0},
	{"ti_ansi", 7, 8, 0},
	{"tmux", 4, 8, 1},
	{"tmux-256color", 13, 256, 1},
	{"tmux-direct", 11, 16777216, 1},
	{"tt52", 4, 16, 0},
	{"tvi912b", 7, -1, 1},
	{"tvi912b-2p", 10, -1, 1},
	{"tvi912b-2p-mc", 13, -1, 1},
	{"tvi912b-2p-p", 12, -1, 1},
	{"tvi912b-2p-unk", 14, -1, 1},
	{"tvi912b-mc", 10, -1, 1},
	{"tvi912b-mc-2p", 13, -1, 1},
	{"tvi912b-mc-vb", 13, -1, 1},
	{"tvi912b-p", 9, -1, 1},
	{"tvi912b-p-2p", 12, -1, 1},
	{"tvi912b-p-vb", 12, -1, 1},
	{"tvi912b-unk", 11, -1, 1},
	{"tvi912b-unk-2p", 14, -1, 1},
	{"tvi912b-unk-vb", 14, -1, 1},
	{"tvi912b-vb", 10, -1, 1},
	{"tvi912b-vb-mc", 13, -1, 1},
	{"tvi912b-vb-p", 12, -1, 1},
	{"tvi912b-vb-unk", 14, -1, 1},
	{"tvi912c", 7, -1, 1},
	{"tvi912c-2p", 10, -1, 1},
	{"tvi912c-2p-mc", 13, -1, 1},
	{"tvi912c-2p-p", 12, -1, 1},
	{"tvi912c-2p-unk", 14, -1, 1},
	{"tvi912c-mc", 10, -1, 1},
	{"tvi912c-mc-2p", 13, -1, 1},
	{"tvi912c-mc-vb", 13, -1, 1},
	{"tvi912c-p", 9, -1, 1},
	{"tvi912c-p-2p", 12, -1, 1},
	{"tvi912c-p-vb", 12, -1, 1},
	{"tvi912c-unk", 11, -1, 1},
	{"tvi912c-unk-2p", 14, -1, 1},
	{"tvi912c-unk-vb", 14, -1, 1},
	{"tvi912c-vb", 10, -1, 1},
	{"tvi912c-vb-mc", 13, -1, 1},
	{"tvi912c-vb-p", 12, -1, 1},
	{"tvi912c-vb-unk", 14, -1, 1},
	{"tvi920b", 7, -1, 1},
	{"tvi920b-2p", 10, -1, 1},
	{"tvi920b-2p-mc", 13, -1, 1},
	{"tvi920b-2p-p", 12, -1, 1},
	{"tvi920b-2p-unk", 14, -1, 1},
	{"tvi920b-mc", 10, -1, 1},
	{"tvi920b-mc-2p", 13, -1, 1},
	{"tvi920b-mc-vb", 13, -1, 1},
	{"tvi920b-p", 9, -1, 1},
	{"tvi920b-p-2p", 12, -1, 1},
	{"tvi920b-p-vb", 12, -1, 1},
	{"tvi920b-unk", 11, -1, 1},
	{"tvi920b-unk-2p", 14, -1, 1},
	{"tvi920b-unk-vb", 14, -1, 1},
	{"tvi920b-vb", 10, -1, 1},
	{"tvi920b-vb-mc", 13, -1, 1},
	{"tvi920b-vb-p", 12, -1, 1},
	{"tvi920b-vb-unk", 14, -1, 1},
	{"tvi920c", 7, -1, 1},
	{"tvi920c-2p", 10, -1, 1},
	{"tvi920c-2p-mc", 13, -1, 1},
	{"tvi920c-2p-p", 12, -1, 1},
	{"tvi920c-2p-unk", 14, -1, 1},
	{"tvi920c-mc", 10, -1, 1},
	{"tvi920c-mc-2p", 13, -1, 1},
	{"tvi920c-mc-vb", 13, -1, 1},
	{"tvi920c-p", 9, -1, 1},
	{"tvi920c-p-2p", 12, -1, 1},
	{"tvi920c-p-vb", 12, -1, 1},
	{"tvi920c-unk", 11, -1, 1},
	{"tvi920c-unk-2p", 14, -1, 1},
	{"tvi920c-unk-vb", 14, -1, 1},
	{"tvi920c-vb", 10, -1, 1},
	{"tvi920c-vb-mc", 13, -1, 1},
	{"tvi920c-vb-p", 12, -1, 1},
	{"tvi920c-vb-unk", 14, -1, 1},
	{"tw100", 5, 8, 0},
	{"tw52", 4, 16, 0},
	{"tw52-color", 10, 16, 0},
	{"uniterm", 7, -1, 1},
	{"uniterm49", 9, -1, 1},
	{"uuterm", 6, 8, 1},
	{"uwin", 4, 8, 1},
	{"v200-nam", 8, -1, 1},
	{"v320n", 5, -1, 1},
	{"vs100", 5, -1, 1},
	{"vscode", 6, 256, 1},
	{"vscode-direct", 13, 16777216, 1},
	{"vt100+", 6, 8, 1},
	{"vt200", 5, -1, 1},
	{"vt200-w", 7, -1, 1},
	{"vt220", 5, -1, 1},
	{"vt220-base", 10, -1, 1},
	{"vt220-nam", 9, -1, 1},
	{"vt220-w", 7, -1, 1},
	{"vt300", 5, -1, 1},
	{"vt300-nam", 9, -1, 1},
	{"vt300-w", 7, -1, 1},
	{"vt300-w-nam", 11, -1, 1},
	{"vt320", 5, -1, 1},
	{"vt320-nam", 9, -1, 1},
	{"vt320nam", 8, -1, 1},
	{"vt320-w", 7, -1, 1},
	{"vt320-w-nam", 11, -1, 1},
	{"vt420", 5, -1, 1},
	{"vt420f", 6, -1, 1},
	{"vt420pc", 7, -1, 1},
	{"vt420pcdos", 10, -1, 1},
	{"vt510", 5, -1, 1},
	{"vt510pc", 7, -1, 1},
	{"vt510pcdos", 10, -1, 1},
	{"vt520", 5, -1, 1},
	{"vt520ansi", 9, -1, 1},
	{"vt525", 5, -1, 1},
	{"vte", 3, 8, 1},
	{"vte-2007", 8, 8, 1},
	{"vte-2008", 8, 8, 1},
	{"vte-2012", 8, 8, 1},
	{"vte-2014", 8, 8, 1},
	{"vte-2017", 8, 8, 1},
	{"vte-2018", 8, 8, 1},
	{"vte-256color", 12, 256, 1},
	{"vte-direct", 10, 16777216, 1},
	{"vtnt", 4, 8, 1},
	{"vt-utf8", 7, 8, 1},
	{"vv100", 5, 8, 0},
	{"vwmterm", 7, 8, 0},
	{"wsvt25", 6, 8, 1},
	{"wsvt25m", 7, 8, 1},
	{"wy350", 5, 8, 0},
	{"wy350-vb", 8, 8, 0},
	{"wy350-w", 7, 8, 0},
	{"wy350-wvb", 9, 8, 0},
	{"wy370", 5, 64, 0},
	{"wy370-101k", 10, 64, 0},
	{"wy370-105k", 10, 64, 0},
	{"wy370-EPC", 9, 64, 0},
	{"wy370-nk", 8, 64, 0},
	{"wy370-rv", 8, 64, 0},
	{"wy370-vb", 8, 64, 0},
	{"wy370-w", 7, 64, 0},
	{"wy370-wvb", 9, 64, 0},
	{"wyse350", 7, 8, 0},
	{"wyse350-vb", 10, 8, 0},
	{"wyse350-w", 9, 8, 0},
	{"wyse350-wvb", 11, 8, 0},
	{"wyse370", 7, 64, 0},
	{"x68k", 4, -1, 1},
	{"x68k-ite", 8, -1, 1},
	{"xfce", 4, 8, 1},
	{"X-hpterm-color2", 15, 8, 0},
	{"xiterm", 6, 8, 1},
	{"xnuppc", 6, 8, 0},
	{"xnuppc-100x37", 13, 8, 0},
	{"xnuppc-112x37", 13, 8, 0},
	{"xnuppc-128x40", 13, 8, 0},
	{"xnuppc-128x48", 13, 8, 0},
	{"xnuppc-144x48", 13, 8, 0},
	{"xnuppc-160x64", 13, 8, 0},
	{"xnuppc-200x64", 13, 8, 0},
	{"xnuppc-200x75", 13, 8, 0},
	{"xnuppc-256x96", 13, 8, 0},
	{"xnuppc-80x25", 12, 8, 0},
	{"xnuppc-80x30", 12, 8, 0},
	{"xnuppc-90x30", 12, 8, 0},
	{"xnuppc-b", 8, 8, 0},
	{"xnuppc+c", 8, 8, 0},
	{"xnuppc-f", 8, 8, 0},
	{"xnuppc-f2", 9, 8, 0},
	{"xterm", 5, 8, 1},
	{"xterm1", 6, 8, 1},
	{"xterm-1002", 10, 8, 1},
	{"xterm-1003", 10, 8, 1},
	{"xterm-1005", 10, 8, 1},
	{"xterm-1006", 10, 8, 1},
	{"xterm-16color", 13, 16, 1},
	{"xterm-24", 8, -1, 1},
	{"xterm+256color", 14, 256, 0},
	{"xterm-256color", 14, 256, 1},
	{"xterm+256color2", 15, 256, 0},
	{"xterm+256setaf", 14, 256, 0},
	{"xterm+88color", 13, 88, 0},
	{"xterm-88color", 13, 88, 1},
	{"xterm+88color2", 14, 88, 0},
	{"xterm-8bit", 10, 8, 1},
	{"xterm-basic", 11, 8, 1},
	{"xterm-bold", 10, -1, 1},
	{"xtermc", 6, 8, 0},
	{"xterm-color", 11, 8, 1},
	{"xterm+direct", 12, 16777216, 0},
	{"xterm-direct", 12, 16777216, 1},
	{"xterm+direct16", 14, 16777216, 0},
	{"xterm-direct16", 14, 16777216, 1},
	{"xterm+direct2", 13, 16777216, 0},
	{"xterm-direct2", 13, 16777216, 1},
	{"xterm+direct256", 15, 16777216, 0},
	{"xterm-direct256", 15, 16777216, 1},
	{"xterm-hp", 8, 8, 1},
	{"xterm+indirect", 14, 16777216, 0},
	{"xterm.js", 8, 256, 1},
	{"xterm-kitty", 11, 256, 1},
	{"xterm-mono", 10, -1, 1},
	{"xterm-new", 9, 8, 1},
	{"xterm-nic", 9, 8, 1},
	{"xterm-noapp", 11, 8, 1},
	{"xterm+nofkeys", 13, 8, 1},
	{"xterm-old", 9, -1, 1},
	{"xterm-pcolor", 12, -1, 1},
	{"xterm-r5", 8, -1, 1},
	{"xterm-r6", 8, -1, 1},
	{"xterms", 6, -1, 1},
	{"xterm-sco", 9, 8, 1},
	{"xterms-sun", 10, 8, 1},
	{"xterm-sun", 9, 8, 1},
	{"xterm-utf8", 10, 8, 1},
	{"xterm-vt220", 11, 8, 1},
	{"xterm-x10mouse", 14, 8, 1},
	{"xterm-x11hilite", 15, 8, 1},
	{"xterm-x11mouse", 14, 8, 1},
	{"xterm-xf86-v32", 14, 8, 1},
	{"xterm-xf86-v33", 14, 8, 1},
	{"xterm-xf86-v333", 15, 8, 1},
	{"xterm-xf86-v40", 14, 8, 1},
	{"xterm-xf86-v43", 14, 8, 1},
	{"xterm-xf86-v44", 14, 8, 1},
	{"xterm-xfree86", 13, 8, 1},
	{"xterm-xi", 8, 8, 1},
	{"xwsh", 4, 8, 1},
	{"yaft-256color", 13, 256, 1},
	{"z340", 4, -1, 1},
	{"z340-nam", 8, -1, 1},
	{NULL, 0, 0, 0},
};

#endif /* TERM_INFO_H */
