## CliFM's Contribution Guidelines

1)  The best way to contribute is taking a look at the currently open [issues](https://github.com/leo-arch/clifm/issues) and provide some help, or creating a new one pointing out bugs (make sure to provide enough information to make the bug reproducible) and suggesting missing or wanted features. We'll do our best to fix whatever is broken and to add/improve whatever is missing. Always bear in mind the [bugs](https://github.com/leo-arch/clifm/blob/master/.github/ISSUE_TEMPLATE/bug_report.md) and [feature request](https://github.com/leo-arch/clifm/blob/master/.github/ISSUE_TEMPLATE/feature_request.md) templates, and, in case of sending us some code or patch via a pull request, the [coding guidelines](https://github.com/leo-arch/clifm/blob/master/src/README.md).

2)  If you want to directly contribute to the project adding a feature, there is a simple way that do not involve getting your hands dirty with the source code: write a [plugin](https://github.com/leo-arch/clifm/wiki/Advanced#plugins) (in any language you know) and submit it via a pull request: plugins could be simple, few lines long shell scripts.

3) If you are a designer, or if you just enjoy creating designs, you can develop some nice [colorscheme](https://github.com/leo-arch/clifm/wiki/Customization#colors) (mines are just awful), a [cool prompt](https://github.com/leo-arch/clifm/wiki/Customization#the-prompt) or some nice presentation video for _CliFM_. A few color schemes I made can be found here: https://github.com/leo-arch/clifm-colors

4)  For the time being, _CliFM_ includes only a spanish translation (which is now out dated, by the way). New translations are a nice way to contribute (you can find the .pot file in [here](https://github.com/leo-arch/clifm/tree/master/translations)). We are using [Hosted Weblate](https://hosted.weblate.org/projects/clifm/clifm/) as a translations platform.

5)  Test it on other operating systems (working fine now on Linux, FreeBSD, NetBSD, OpenBSD, MacOS, and Haiku) and other architectures (successfully tested on i386, x86_64, and ARM).

6)  Join our [Gitter discussion room](https://gitter.im/leo-arch/clifm) and let us know your what you think: ideas, observations, comments and questions are always welcome.

7)  Of course, you can also tell your friends about _CliFM_, write a (positive) review of it somewhere on the internet, or you can just create a nice t-shirt with our [logo](https://github.com/leo-arch/clifm/tree/master/images/logo) to tell the world how great _CliFM_ is (just kidding, or not).

8)  Buy me a beer.
