/* term_info.h - A list of terminals and a few capabilities */
/*
 * This file is part of CliFM
 *
 * Copyright (C) 2016-2024, L. Abramovich <leo.clifm@outlook.com>
 * All rights reserved.

 * CliFM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CliFM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
*/

#ifndef TERM_INFO_H
#define TERM_INFO_H

struct terms_t {
	char *name; /* Terminal name as found in $TERM and the terminfo database */
	/* Let's hardcode the length of each terminal name to prevent unnecessary
	 * calls to strlen(3): comparing the first byte and this length to those
	 * of the current terminal is most of the time enough */
	size_t len;
	int color; /* -1 means no color support */
	int cub;   /* Move cursor backward */
	int el;    /* Erase line */
	int ed;    /* Erase display */
	int hide_cursor;
	int del_scrollback;
	int home;
	int req_cur_pos;
};

const struct terms_t TERM_INFO[] = {
	{"386at", 5, 8, 1, 1, 1, 1, 0, 1, 0},
	{"3b1", 3, -1, 1, 1, 1, 1, 0, 1, 0},
	{"5630-24", 7, -1, 1, 1, 1, 0, 0, 1, 1},
	{"5630DMD-24", 10, -1, 1, 1, 1, 0, 0, 1, 1},
	{"630MTG-24", 9, -1, 1, 1, 1, 0, 0, 1, 1},
	{"730MTG-24", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"730MTG-41", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"730MTG-41r", 10, -1, 1, 1, 1, 1, 0, 1, 1},
	{"730MTGr", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"730MTGr-24", 10, -1, 1, 1, 1, 1, 0, 1, 1},
	{"aaa", 3, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-18", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-18-rv", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-20", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-22", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-24", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-24-rv", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-26", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-28", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-30", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-30-ctxt", 11, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-30-rv", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-30-rv-ctxt", 14, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-30-s", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-30-s-ctxt", 13, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-30-s-rv", 11, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-30-s-rv-ct", 14, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-36", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-36-rv", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-40", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-40-rv", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-48", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-48-rv", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-60", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-60-dec-rv", 13, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-60-rv", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-60-s", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-60-s-rv", 11, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-ctxt", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-db", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-rv", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-rv-ctxt", 11, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-s", 5, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-s-ctxt", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-s-rv", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-s-rv-ctxt", 13, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa+unk", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aaa-unk", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"absolute", 8, 256, 1, 1, 1, 1, 1, 1, 1},
	{"adm36", 5, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aixterm", 7, 8, 1, 1, 1, 0, 0, 1, 0},
	{"aixterm-16color", 15, 16, 1, 1, 1, 0, 0, 1, 0},
	{"aixterm-m", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"aixterm-m-old", 13, -1, 1, 1, 1, 0, 0, 1, 0},
	{"alacritty", 9, 256, 1, 1, 1, 1, 1, 1, 1},
	{"alacritty+common", 16, 8, 1, 1, 1, 1, 1, 1, 1},
	{"alacritty-direct", 16, 16777216, 1, 1, 1, 1, 1, 1, 1},
	{"ambas", 5, -1, 1, 1, 1, 0, 0, 1, 0},
	{"ambassador", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"amiga", 5, -1, 1, 1, 1, 1, 0, 1, 0},
	{"amiga-8bit", 10, -1, 1, 1, 1, 1, 0, 1, 0},
	{"amiga-h", 7, -1, 1, 1, 1, 1, 0, 1, 0},
	{"amiga-vnc", 9, 16, 1, 1, 1, 1, 0, 0, 0},
	{"ansi", 4, 8, 1, 1, 1, 0, 0, 1, 1},
	{"ansi80x25", 9, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ansi80x25-mono", 14, -1, 1, 1, 1, 0, 0, 1, 0},
	{"ansi80x25-raw", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ansi80x30", 9, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ansi80x30-mono", 14, -1, 1, 1, 1, 0, 0, 1, 0},
	{"ansi80x43", 9, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ansi80x43-mono", 14, -1, 1, 1, 1, 0, 0, 1, 0},
	{"ansi80x50", 9, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ansi80x50-mono", 14, -1, 1, 1, 1, 0, 0, 1, 0},
	{"ansi80x60", 9, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ansi80x60-mono", 14, -1, 1, 1, 1, 0, 0, 1, 0},
	{"ansi-color-2-emx", 16, 8, 0, 1, 1, 1, 0, 1, 1},
	{"ansi-color-3-emx", 16, 8, 0, 1, 1, 1, 0, 1, 1},
	{"ansi-emx", 8, 8, 0, 1, 1, 1, 0, 1, 1},
	{"ansi-generic", 12, -1, 1, 1, 1, 0, 0, 1, 0},
	{"ansil", 5, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ansil-mono", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"ansi-m", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"ansi-mono", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"ansis", 5, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ansis-mono", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"ansi.sys", 8, 8, 0, 1, 0, 0, 0, 1, 1},
	{"ansi.sysk", 9, 8, 0, 1, 0, 0, 0, 1, 1},
	{"ansisysk", 8, 8, 0, 1, 0, 0, 0, 1, 1},
	{"ansi.sys-old", 12, 8, 0, 1, 0, 0, 0, 1, 1},
	{"ansiterm", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"ansiw", 5, 8, 1, 1, 1, 0, 0, 1, 0},
	{"apollo_15P", 10, -1, 1, 1, 1, 0, 0, 1, 1},
	{"apollo_19L", 10, -1, 1, 1, 1, 0, 0, 1, 1},
	{"apollo_color", 12, -1, 1, 1, 1, 0, 0, 1, 1},
	{"apollo+vt132", 12, -1, 1, 1, 1, 0, 0, 1, 1},
	{"Apple_Terminal", 14, 256, 1, 1, 1, 1, 0, 1, 1},
	{"arm100", 6, 8, 1, 1, 1, 0, 0, 1, 0},
	{"arm100-am", 9, 8, 1, 1, 1, 0, 0, 1, 0},
	{"arm100-w", 8, 8, 1, 1, 1, 0, 0, 1, 0},
	{"arm100-wam", 10, 8, 1, 1, 1, 0, 0, 1, 0},
	{"at386", 5, 8, 1, 1, 1, 1, 0, 1, 0},
	{"atari-color", 11, 16, 0, 1, 1, 1, 0, 1, 0},
	{"atari_st-color", 14, 16, 0, 1, 1, 1, 0, 1, 0},
	{"at-color", 8, 16, 0, 1, 1, 1, 0, 1, 0},
	{"aterm", 5, 8, 1, 1, 1, 1, 0, 1, 1},
	{"att2300", 7, -1, 1, 1, 1, 0, 0, 1, 1},
	{"att2350", 7, -1, 1, 1, 1, 0, 0, 1, 1},
	{"att4415", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"att4415-nl", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"att4415-rv", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"att4415-rv-nl", 13, -1, 1, 1, 1, 0, 0, 1, 0},
	{"att4415-w", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"att4415-w-nl", 12, -1, 1, 1, 1, 0, 0, 1, 0},
	{"att4415-w-rv", 12, -1, 1, 1, 1, 0, 0, 1, 0},
	{"att4415-w-rv-n", 14, -1, 1, 1, 1, 0, 0, 1, 0},
	{"att4418", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"att4418-w", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"att4424", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"att4424-1", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"att4425", 7, -1, 1, 1, 1, 0, 0, 1, 1},
	{"att4425-nl", 10, -1, 1, 1, 1, 0, 0, 1, 1},
	{"att4425-w", 9, -1, 1, 1, 1, 0, 0, 1, 1},
	{"att4426", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"att500", 6, -1, 1, 1, 1, 0, 0, 1, 1},
	{"att505", 6, -1, 1, 1, 1, 0, 0, 1, 1},
	{"att505-22", 9, -1, 1, 1, 1, 0, 0, 1, 1},
	{"att505-24", 9, -1, 1, 1, 1, 0, 0, 1, 1},
	{"att510a", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"att510d", 7, -1, 1, 1, 1, 0, 0, 1, 1},
	{"att513", 6, -1, 1, 1, 1, 0, 0, 1, 1},
	{"att5418", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"att5418-w", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"att5420", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"att5420_2", 9, -1, 1, 1, 1, 0, 0, 1, 1},
	{"att5420_2-w", 11, -1, 1, 1, 1, 0, 0, 1, 1},
	{"att5420-nl", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"att5420-rv", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"att5420-rv-nl", 13, -1, 1, 1, 1, 0, 0, 1, 0},
	{"att5420-w", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"att5420-w-nl", 12, -1, 1, 1, 1, 0, 0, 1, 0},
	{"att5420-w-rv", 12, -1, 1, 1, 1, 0, 0, 1, 0},
	{"att5420-w-rv-n", 14, -1, 1, 1, 1, 0, 0, 1, 0},
	{"att5425", 7, -1, 1, 1, 1, 0, 0, 1, 1},
	{"att5425-nl", 10, -1, 1, 1, 1, 0, 0, 1, 1},
	{"att5425-w", 9, -1, 1, 1, 1, 0, 0, 1, 1},
	{"att5430", 7, -1, 1, 1, 1, 0, 0, 1, 1},
	{"att610", 6, -1, 1, 1, 1, 1, 0, 1, 1},
	{"att610-103k", 11, -1, 1, 1, 1, 1, 0, 1, 1},
	{"att610-103k-w", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"att610-w", 8, -1, 1, 1, 1, 1, 0, 1, 1},
	{"att615", 6, -1, 1, 1, 1, 1, 0, 1, 1},
	{"att615-103k", 11, -1, 1, 1, 1, 1, 0, 1, 1},
	{"att615-103k-w", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"att615-w", 8, -1, 1, 1, 1, 1, 0, 1, 1},
	{"att620", 6, -1, 1, 1, 1, 1, 0, 1, 1},
	{"att620-103k", 11, -1, 1, 1, 1, 1, 0, 1, 1},
	{"att620-103k-w", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"att620-w", 8, -1, 1, 1, 1, 1, 0, 1, 1},
	{"att630", 6, -1, 1, 1, 1, 0, 0, 1, 1},
	{"att630-24", 9, -1, 1, 1, 1, 0, 0, 1, 1},
	{"att6386", 7, 8, 1, 1, 1, 1, 0, 1, 0},
	{"att700", 6, -1, 1, 1, 1, 1, 0, 1, 1},
	{"att730", 6, -1, 1, 1, 1, 1, 0, 1, 1},
	{"att7300", 7, -1, 1, 1, 1, 1, 0, 1, 0},
	{"att730-24", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"att730-41", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"att730r", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"att730r-24", 10, -1, 1, 1, 1, 1, 0, 1, 1},
	{"att730r-41", 10, -1, 1, 1, 1, 1, 0, 1, 1},
	{"avt", 3, -1, 1, 1, 1, 0, 0, 1, 0},
	{"avt-ns", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"avt-rv", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"avt-rv-ns", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"avt-rv-s", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"avt-s", 5, -1, 1, 1, 1, 0, 0, 1, 0},
	{"avt-w", 5, -1, 1, 1, 1, 0, 0, 1, 0},
	{"avt-w-ns", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"avt-w-rv", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"avt-w-rv-ns", 11, -1, 1, 1, 1, 0, 0, 1, 0},
	{"avt-w-rv-s", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"avt-w-s", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"bct510a", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"bct510d", 7, -1, 1, 1, 1, 0, 0, 1, 1},
	{"beterm", 6, 8, 1, 1, 1, 0, 0, 1, 1},
	{"bq300", 5, -1, 1, 1, 1, 1, 0, 1, 1},
	{"bq300-8", 7, -1, 1, 1, 1, 1, 0, 1, 0},
	{"bq300-8-pc", 10, -1, 1, 1, 1, 1, 0, 1, 0},
	{"bq300-8-pc-rv", 13, -1, 1, 1, 1, 1, 0, 1, 0},
	{"bq300-8-pc-w", 12, -1, 1, 1, 1, 1, 0, 1, 0},
	{"bq300-8-pc-w-rv", 15, -1, 1, 1, 1, 1, 0, 1, 0},
	{"bq300-8rv", 9, -1, 1, 1, 1, 1, 0, 1, 0},
	{"bq300-8w", 8, -1, 1, 1, 1, 1, 0, 1, 0},
	{"bq300-pc", 8, -1, 1, 1, 1, 1, 0, 1, 1},
	{"bq300-pc-rv", 11, -1, 1, 1, 1, 1, 0, 1, 1},
	{"bq300-pc-w", 10, -1, 1, 1, 1, 1, 0, 1, 1},
	{"bq300-pc-w-rv", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"bq300-rv", 8, -1, 1, 1, 1, 1, 0, 1, 1},
	{"bq300-w", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"bq300-w-8rv", 11, -1, 1, 1, 1, 1, 0, 1, 0},
	{"bq300-w-rv", 10, -1, 1, 1, 1, 1, 0, 1, 1},
	{"bsdos-pc", 8, 8, 1, 1, 1, 0, 0, 1, 0},
	{"bsdos-pc-m", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"bsdos-pc-mono", 13, -1, 1, 1, 1, 0, 0, 1, 0},
	{"bsdos-pc-nobold", 15, 8, 1, 1, 1, 0, 0, 1, 0},
	{"bsdos-ppc", 9, 8, 1, 1, 1, 0, 0, 1, 0},
	{"bterm", 5, 8, 0, 1, 1, 1, 0, 1, 0},
	{"cit101e-rv", 10, -1, 1, 1, 1, 1, 0, 1, 1},
	{"cit500", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"color_xterm", 11, 8, 1, 1, 1, 0, 0, 1, 1},
	{"concept-avt", 11, -1, 1, 1, 1, 0, 0, 1, 0},
	{"cons25", 6, 8, 1, 1, 1, 0, 0, 1, 0},
	{"cons25-debian", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"cons25-iso8859", 14, 8, 1, 1, 1, 0, 0, 1, 0},
	{"cons25-iso-m", 12, -1, 1, 1, 1, 0, 0, 1, 0},
	{"cons25-koi8-r", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"cons25-koi8r-m", 14, -1, 1, 1, 1, 0, 0, 1, 0},
	{"cons25l1", 8, 8, 1, 1, 1, 0, 0, 1, 0},
	{"cons25l1-m", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"cons25-m", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"cons25r", 7, 8, 1, 1, 1, 0, 0, 1, 0},
	{"cons25r-m", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"cons25w", 7, 8, 1, 1, 1, 0, 0, 1, 0},
	{"cons30", 6, 8, 1, 1, 1, 0, 0, 1, 0},
	{"cons30-m", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"cons43", 6, 8, 1, 1, 1, 0, 0, 1, 0},
	{"cons43-m", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"cons50", 6, 8, 1, 1, 1, 0, 0, 1, 0},
	{"cons50-iso8859", 14, 8, 1, 1, 1, 0, 0, 1, 0},
	{"cons50-iso-m", 12, -1, 1, 1, 1, 0, 0, 1, 0},
	{"cons50-koi8r", 12, 8, 1, 1, 1, 0, 0, 1, 0},
	{"cons50-koi8r-m", 14, -1, 1, 1, 1, 0, 0, 1, 0},
	{"cons50l1", 8, 8, 1, 1, 1, 0, 0, 1, 0},
	{"cons50l1-m", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"cons50-m", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"cons50r", 7, 8, 1, 1, 1, 0, 0, 1, 0},
	{"cons50r-m", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"cons60", 6, 8, 1, 1, 1, 0, 0, 1, 0},
	{"cons60-iso", 10, 8, 1, 1, 1, 0, 0, 1, 0},
	{"cons60-iso-m", 12, -1, 1, 1, 1, 0, 0, 1, 0},
	{"cons60-koi8r", 12, 8, 1, 1, 1, 0, 0, 1, 0},
	{"cons60-koi8r-m", 14, -1, 1, 1, 1, 0, 0, 1, 0},
	{"cons60l1", 8, 8, 1, 1, 1, 0, 0, 1, 0},
	{"cons60l1-m", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"cons60-m", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"cons60r", 7, 8, 1, 1, 1, 0, 0, 1, 0},
	{"cons60r-m", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"contour", 7, 256, 1, 1, 1, 1, 1, 1, 0},
	{"contour-direct", 14, 16777216, 1, 1, 1, 1, 1, 1, 0},
	{"contour-latest", 14, 256, 1, 1, 1, 1, 1, 1, 0},
	{"crt", 3, 8, 1, 1, 1, 0, 0, 1, 1},
	{"crt-vt220", 9, 8, 1, 1, 1, 0, 0, 1, 1},
	{"ctrm", 4, 8, 0, 1, 1, 0, 0, 0, 0},
	{"cx", 2, 8, 1, 1, 1, 0, 0, 1, 1},
	{"cx100", 5, 8, 1, 1, 1, 0, 0, 1, 1},
	{"cygwin", 6, 8, 1, 1, 1, 0, 0, 1, 1},
	{"cygwinB19", 9, 8, 0, 1, 0, 0, 0, 1, 1},
	{"cygwinDBG", 9, 8, 1, 1, 1, 1, 0, 1, 1},
	{"d210", 4, -1, 1, 1, 1, 0, 0, 1, 0},
	{"d211", 4, -1, 1, 1, 1, 0, 0, 1, 0},
	{"d211-7b", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"d214", 4, -1, 1, 1, 1, 0, 0, 1, 0},
	{"d215", 4, -1, 1, 1, 1, 0, 0, 1, 0},
	{"d215-7b", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"d220", 4, 8, 1, 1, 1, 1, 0, 1, 0},
	{"d220-7b", 7, 8, 1, 1, 1, 1, 0, 1, 0},
	{"d220-dg", 7, 8, 0, 1, 1, 1, 0, 0, 0},
	{"d230", 4, 8, 1, 1, 1, 1, 0, 1, 0},
	{"d230c", 5, 8, 1, 1, 1, 1, 0, 1, 0},
	{"d230c-dg", 8, 8, 0, 1, 1, 1, 0, 0, 0},
	{"d230-dg", 7, 8, 0, 1, 1, 1, 0, 0, 0},
	{"d410", 4, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d410-7b", 7, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d410-7b-w", 9, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d410-w", 6, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d411", 4, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d411-7b", 7, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d411-7b-w", 9, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d411-w", 6, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d430c-dg", 8, 16, 0, 1, 1, 1, 0, 1, 0},
	{"d430c-dg-ccc", 12, 52, 0, 1, 1, 1, 0, 1, 0},
	{"d430c-unix", 10, 16, 0, 1, 1, 1, 0, 1, 0},
	{"d430c-unix-25", 13, 16, 0, 1, 1, 1, 0, 1, 0},
	{"d430c-unix-25-ccc", 17, 52, 0, 1, 1, 1, 0, 1, 0},
	{"d430c-unix-ccc", 14, 52, 0, 1, 1, 1, 0, 1, 0},
	{"d430c-unix-s", 12, 16, 0, 1, 1, 1, 0, 1, 0},
	{"d430c-unix-s-ccc", 16, 52, 0, 1, 1, 1, 0, 1, 0},
	{"d430c-unix-sr", 13, 16, 0, 1, 1, 1, 0, 1, 0},
	{"d430c-unix-sr-ccc", 17, 52, 0, 1, 1, 1, 0, 1, 0},
	{"d430c-unix-w", 12, 16, 0, 1, 1, 1, 0, 1, 0},
	{"d430c-unix-w-ccc", 16, 52, 0, 1, 1, 1, 0, 1, 0},
	{"d430-dg", 7, 16, 0, 1, 1, 1, 0, 1, 0},
	{"d430-dg-ccc", 11, 52, 0, 1, 1, 1, 0, 1, 0},
	{"d430-unix", 9, 16, 0, 1, 1, 1, 0, 1, 0},
	{"d430-unix-25", 12, 16, 0, 1, 1, 1, 0, 1, 0},
	{"d430-unix-25-ccc", 16, 52, 0, 1, 1, 1, 0, 1, 0},
	{"d430-unix-ccc", 13, 52, 0, 1, 1, 1, 0, 1, 0},
	{"d430-unix-s", 11, 16, 0, 1, 1, 1, 0, 1, 0},
	{"d430-unix-s-ccc", 15, 52, 0, 1, 1, 1, 0, 1, 0},
	{"d430-unix-sr", 12, 16, 0, 1, 1, 1, 0, 1, 0},
	{"d430-unix-sr-ccc", 16, 52, 0, 1, 1, 1, 0, 1, 0},
	{"d430-unix-w", 11, 16, 0, 1, 1, 1, 0, 1, 0},
	{"d430-unix-w-ccc", 15, 52, 0, 1, 1, 1, 0, 1, 0},
	{"d460", 4, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d460-7b", 7, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d460-7b-w", 9, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d460-w", 6, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d461", 4, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d461-7b", 7, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d461-7b-w", 9, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d461-w", 6, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d470", 4, 16, 1, 1, 1, 1, 0, 1, 0},
	{"d470-7b", 7, 16, 1, 1, 1, 1, 0, 1, 0},
	{"d470c", 5, 16, 1, 1, 1, 1, 0, 1, 0},
	{"d470c-7b", 8, 16, 1, 1, 1, 1, 0, 1, 0},
	{"d470c-dg", 8, 16, 0, 1, 1, 1, 0, 1, 0},
	{"d470-dg", 7, 16, 0, 1, 1, 1, 0, 1, 0},
	{"d555", 4, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d555-7b", 7, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d555-7b-w", 9, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d555-w", 6, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d577", 4, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d577-7b", 7, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d577-7b-w", 9, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d577-w", 6, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d578", 4, -1, 1, 1, 1, 1, 0, 1, 0},
	{"d578-7b", 7, -1, 1, 1, 1, 1, 0, 1, 0},
	{"darwin", 6, 8, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-100x37", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-100x37-m", 15, -1, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-112x37", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-112x37-m", 15, -1, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-128x40", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-128x40-m", 15, -1, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-128x48", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-128x48-m", 15, -1, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-144x48", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-144x48-m", 15, -1, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-160x64", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-160x64-m", 15, -1, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-200x64", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-200x64-m", 15, -1, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-200x75", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-200x75-m", 15, -1, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-256x96", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-256x96-m", 15, -1, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-80x25", 12, 8, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-80x25-m", 14, -1, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-80x30", 12, 8, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-80x30-m", 14, -1, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-90x30", 12, 8, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-90x30-m", 14, -1, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-b", 8, 8, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-f", 8, 8, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-f2", 9, 8, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-m", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-m-b", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-m-f", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"darwin-m-f2", 11, -1, 1, 1, 1, 0, 0, 1, 0},
	{"decansi", 7, 8, 1, 1, 1, 1, 0, 1, 1},
	{"dec-vt100", 9, -1, 1, 1, 1, 0, 0, 1, 1},
	{"dec-vt220", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"dec-vt330", 9, -1, 1, 1, 1, 1, 0, 1, 0},
	{"dec-vt340", 9, -1, 1, 1, 1, 1, 0, 1, 0},
	{"dec-vt400", 9, -1, 1, 1, 1, 1, 0, 1, 0},
	{"dg+ccc", 6, 52, 0, 0, 0, 0, 0, 0, 0},
	{"dg+color", 8, 16, 0, 0, 0, 0, 0, 0, 0},
	{"dg+color8", 9, 8, 0, 0, 0, 0, 0, 0, 0},
	{"dg+fixed", 8, 16, 0, 0, 0, 0, 0, 0, 0},
	{"dgmode+color", 12, 16, 0, 0, 0, 0, 0, 0, 0},
	{"dgmode+color8", 13, 8, 0, 0, 0, 0, 0, 0, 0},
	{"dgunix+ccc", 10, 52, 0, 0, 0, 0, 0, 0, 0},
	{"dgunix+fixed", 12, 16, 0, 0, 0, 0, 0, 0, 0},
	{"djgpp", 5, 8, 1, 1, 1, 1, 0, 1, 0},
	{"djgpp204", 8, 8, 1, 1, 1, 1, 0, 1, 0},
	{"dku7102", 7, -1, 1, 1, 1, 1, 0, 1, 0},
	{"dku7102-old", 11, -1, 1, 1, 1, 1, 0, 1, 0},
	{"dku7102-sna", 11, -1, 1, 1, 1, 1, 0, 1, 0},
	{"dku7103-sna", 11, -1, 1, 1, 1, 1, 0, 1, 0},
	{"dku7202", 7, -1, 1, 1, 1, 1, 0, 1, 0},
	{"dm80", 4, -1, 1, 1, 1, 0, 0, 1, 0},
	{"dm80w", 5, -1, 1, 1, 1, 0, 0, 1, 0},
	{"dmdt80", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"dmdt80w", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"domterm", 7, 256, 1, 1, 1, 1, 1, 1, 1},
	{"dt80", 4, -1, 1, 1, 1, 0, 0, 1, 0},
	{"dt80w", 5, -1, 1, 1, 1, 0, 0, 1, 0},
	{"dtterm", 6, 8, 1, 1, 1, 1, 0, 1, 1},
	{"dumb-emacs-ansi", 15, 8, 0, 0, 0, 0, 0, 0, 0},
	{"dvtm", 4, 8, 1, 1, 1, 1, 0, 1, 0},
	{"dvtm-256color", 13, 256, 1, 1, 1, 1, 0, 1, 0},
	{"ecma+color", 10, 8, 0, 0, 0, 0, 0, 0, 0},
	{"emots", 5, 8, 1, 1, 1, 0, 0, 1, 0},
	{"emu", 3, 15, 1, 1, 1, 1, 0, 1, 0},
	{"emu-220", 7, -1, 1, 1, 1, 1, 0, 1, 0},
	{"emx-base", 8, 8, 0, 1, 0, 0, 0, 1, 1},
	{"env230", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"envision230", 11, -1, 1, 1, 1, 0, 0, 1, 0},
	{"eterm", 5, -1, 1, 1, 1, 0, 0, 1, 1},
	{"Eterm", 5, 8, 1, 1, 1, 1, 0, 1, 1},
	{"Eterm-256color", 14, 256, 1, 1, 1, 1, 0, 1, 1},
	{"Eterm-88color", 13, 88, 1, 1, 1, 1, 0, 1, 1},
	{"eterm-color", 11, 8, 1, 1, 1, 0, 0, 1, 1},
	{"Eterm-color", 11, 8, 1, 1, 1, 1, 0, 1, 1},
	{"excel62", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"excel62-rv", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"excel62-w", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"excel64", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"excel64-rv", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"excel64-w", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"fbterm", 6, 256, 1, 1, 1, 1, 1, 1, 1},
	{"fenix", 5, -1, 1, 1, 1, 0, 0, 1, 0},
	{"fenixw", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"foot", 4, 256, 1, 1, 1, 1, 1, 1, 1},
	{"foot+base", 9, -1, 1, 1, 1, 1, 1, 1, 1},
	{"foot-direct", 11, 16777216, 1, 1, 1, 1, 1, 1, 1},
	{"foot-extra", 10, 256, 1, 1, 1, 1, 1, 1, 1},
	{"foot-extra-direct", 17, 16777216, 1, 1, 1, 1, 1, 1, 1},
	{"gigi", 4, -1, 1, 1, 1, 0, 0, 0, 0},
	{"gnome", 5, 8, 1, 1, 1, 1, 0, 1, 1},
	{"gnome-2007", 10, 8, 1, 1, 1, 1, 0, 1, 1},
	{"gnome-2008", 10, 8, 1, 1, 1, 1, 0, 1, 1},
	{"gnome-2012", 10, 8, 1, 1, 1, 1, 0, 1, 1},
	{"gnome-256color", 14, 256, 1, 1, 1, 1, 0, 1, 1},
	{"gnome-fc5", 9, 8, 1, 1, 1, 1, 0, 1, 1},
	{"gnome-rh62", 10, 8, 1, 1, 1, 0, 0, 1, 1},
	{"gnome-rh72", 10, 8, 1, 1, 1, 1, 0, 1, 1},
	{"gnome-rh80", 10, 8, 1, 1, 1, 1, 0, 1, 1},
	{"gnome-rh90", 10, 8, 1, 1, 1, 1, 0, 1, 1},
	{"graphos", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"graphos-30", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"gs5430", 6, -1, 1, 1, 1, 0, 0, 1, 1},
	{"gs5430-22", 9, -1, 1, 1, 1, 0, 0, 1, 1},
	{"gs5430-24", 9, -1, 1, 1, 1, 0, 0, 1, 1},
	{"gs6300", 6, 8, 1, 1, 1, 0, 0, 1, 0},
	{"guru", 4, -1, 1, 1, 1, 0, 0, 1, 0},
	{"guru-24", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"guru-33", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"guru-33-rv", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"guru-33-s", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"guru-44", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"guru-44-s", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"guru-76", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"guru-76-lp", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"guru-76-s", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"guru-76-w", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"guru-76-wm", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"guru-76-w-s", 11, -1, 1, 1, 1, 0, 0, 1, 0},
	{"guru-lp", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"guru-nctxt", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"guru-rv", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"guru-s", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"guru+unk", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"h29a-kc-bc", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"h29a-kc-uc", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"h29a-nkc-bc", 11, -1, 1, 1, 1, 0, 0, 1, 0},
	{"h29a-nkc-uc", 11, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hds200", 6, -1, 1, 1, 1, 1, 0, 1, 0},
	{"hft", 3, 8, 1, 1, 1, 0, 0, 1, 0},
	{"hft-c", 5, 8, 1, 1, 1, 0, 0, 1, 0},
	{"hft-c-old", 9, 8, 1, 1, 1, 0, 0, 1, 0},
	{"hft-old", 7, 8, 0, 1, 1, 0, 0, 1, 0},
	{"hirez100", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hirez100-w", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp150", 5, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2382", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2382a", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2397", 6, 16, 1, 1, 1, 0, 0, 1, 0},
	{"hp2397a", 7, 16, 1, 1, 1, 0, 0, 1, 0},
	{"hp2622", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2622a", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2623", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2623a", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2624", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2624-10p", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2624a", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2624a-10p", 11, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2624b", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2624b-10p", 11, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2624b-10p-p", 13, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2624b-4p", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2624b-4p-p", 12, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2624b-p", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2626", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2626-12", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2626-12-s", 11, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2626-12x40", 12, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2626a", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2626-ns", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2626p", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2626-s", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp2626-x40", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"hp98550a-color", 14, 8, 0, 1, 1, 0, 0, 1, 1},
	{"hp98550-color", 13, 8, 0, 1, 1, 0, 0, 1, 1},
	{"hp+color", 8, 16, 0, 0, 0, 0, 0, 0, 0},
	{"hpterm-color", 12, 64, 0, 1, 1, 0, 0, 1, 0},
	{"hpterm-color2", 13, 8, 0, 1, 1, 0, 0, 1, 0},
	{"hterm", 5, 8, 1, 1, 1, 1, 1, 1, 1},
	{"hterm-256color", 14, 256, 1, 1, 1, 1, 1, 1, 1},
	{"hurd", 4, 8, 1, 1, 1, 1, 0, 1, 0},
	{"i3164", 5, 8, 0, 1, 1, 0, 0, 1, 0},
	{"ibm+16color", 11, 16, 0, 0, 0, 0, 0, 0, 0},
	{"ibm3164", 7, 8, 0, 1, 1, 0, 0, 1, 0},
	{"ibm5081", 7, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ibm5151", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"ibm5154", 7, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ibm6153", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"ibm6153-40", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"ibm6153-90", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"ibm6154", 7, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ibm6155", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"ibm8503", 7, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ibm8507", 7, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ibm8512", 7, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ibm8513", 7, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ibm8514", 7, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ibm8604", 7, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ibm+color", 9, 8, 0, 0, 0, 0, 0, 0, 0},
	{"ibmpc", 5, -1, 1, 1, 1, 0, 0, 1, 0},
	{"ibmpc3", 6, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ibmpc3r", 7, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ibmpc3r-mono", 12, -1, 1, 1, 1, 0, 0, 1, 0},
	{"interix", 7, 8, 1, 1, 1, 0, 0, 1, 0},
	{"interix-nti", 11, 8, 1, 1, 1, 0, 0, 1, 0},
	{"iris-ansi", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"iris-ansi-ap", 12, -1, 1, 1, 1, 0, 0, 1, 0},
	{"iris-ansi-net", 13, -1, 1, 1, 1, 0, 0, 1, 0},
	{"iris-color", 10, 8, 1, 1, 1, 0, 0, 1, 1},
	{"iterm", 5, 256, 1, 1, 1, 1, 0, 1, 1},
	{"iterm2", 6, 256, 1, 1, 1, 1, 0, 1, 1},
	{"iTerm2.app", 10, 256, 1, 1, 1, 1, 0, 1, 1},
	{"iterm2-direct", 13, 16777216, 1, 1, 1, 1, 0, 1, 1},
	{"iTerm.app", 9, 256, 1, 1, 1, 1, 0, 1, 1},
	{"jaixterm", 8, 8, 1, 1, 1, 0, 0, 1, 0},
	{"jaixterm-m", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"jfbterm", 7, 8, 1, 1, 1, 1, 0, 1, 1},
	{"kitty", 5, 256, 1, 1, 1, 1, 1, 1, 1},
	{"kitty+common", 12, -1, 1, 1, 1, 1, 1, 1, 1},
	{"kitty-direct", 12, 16777216, 1, 1, 1, 1, 1, 1, 1},
	{"klone+color", 11, 8, 0, 0, 0, 0, 0, 0, 0},
	{"kon", 3, 8, 1, 1, 1, 1, 0, 1, 1},
	{"kon2", 4, 8, 1, 1, 1, 1, 0, 1, 1},
	{"konsole", 7, 8, 1, 1, 1, 1, 0, 1, 1},
	{"konsole-16color", 15, 16, 1, 1, 1, 1, 0, 1, 1},
	{"konsole-256color", 16, 256, 1, 1, 1, 1, 0, 1, 1},
	{"konsole-base", 12, 8, 1, 1, 1, 1, 0, 1, 1},
	{"konsole-direct", 14, 16777216, 1, 1, 1, 1, 0, 1, 1},
	{"konsole-linux", 13, 8, 1, 1, 1, 1, 0, 1, 1},
	{"konsole-solaris", 15, 8, 1, 1, 1, 1, 0, 1, 1},
	{"konsole-vt100", 13, 8, 1, 1, 1, 1, 0, 1, 1},
	{"konsole-vt420pc", 15, 8, 1, 1, 1, 1, 0, 1, 1},
	{"konsole-xf3x", 12, 8, 1, 1, 1, 1, 0, 1, 1},
	{"konsole-xf4x", 12, 8, 1, 1, 1, 1, 0, 1, 1},
	{"kterm", 5, 8, 1, 1, 1, 0, 0, 1, 1},
	{"kterm-co", 8, 8, 1, 1, 1, 0, 0, 1, 1},
	{"kterm-color", 11, 8, 1, 1, 1, 0, 0, 1, 1},
	{"kvt", 3, 8, 1, 1, 1, 0, 0, 1, 1},
	{"lft", 3, -1, 1, 1, 1, 0, 0, 1, 0},
	{"lft-pc850", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"LFT-PC850", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"linux", 5, 8, 1, 1, 1, 1, 1, 1, 1},
	{"linux-16color", 13, 16, 1, 1, 1, 1, 1, 1, 1},
	{"linux2.2", 8, 8, 1, 1, 1, 1, 0, 1, 1},
	{"linux2.6", 8, 8, 1, 1, 1, 1, 0, 1, 1},
	{"linux2.6.26", 11, 8, 1, 1, 1, 1, 0, 1, 1},
	{"linux3.0", 8, 8, 1, 1, 1, 1, 1, 1, 1},
	{"linux-basic", 11, 8, 1, 1, 1, 0, 0, 1, 1},
	{"linux-c", 7, 8, 1, 1, 1, 0, 0, 1, 1},
	{"linux-c-nc", 10, 8, 1, 1, 1, 0, 0, 1, 1},
	{"linux-koi8", 10, 8, 1, 1, 1, 1, 1, 1, 1},
	{"linux-koi8r", 11, 8, 1, 1, 1, 1, 1, 1, 1},
	{"linux-lat", 9, 8, 1, 1, 1, 1, 1, 1, 1},
	{"linux-m", 7, -1, 1, 1, 1, 1, 1, 1, 1},
	{"linux-m1", 8, 8, 0, 1, 1, 1, 1, 1, 1},
	{"linux-nic", 9, 8, 1, 1, 1, 1, 1, 1, 1},
	{"linux-s", 7, 8, 1, 1, 0, 1, 1, 1, 1},
	{"linux-vt", 8, 8, 1, 1, 1, 1, 1, 1, 1},
	{"lisaterm", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"lisaterm-w", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"m2-nam", 6, -1, 1, 1, 1, 1, 0, 1, 1},
	{"mach", 4, -1, 1, 1, 1, 0, 0, 1, 0},
	{"mach-bold", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"mach-color", 10, 8, 1, 1, 1, 0, 0, 1, 0},
	{"mach-gnu", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"mach-gnu-color", 14, 8, 1, 1, 1, 0, 0, 1, 0},
	{"memhp", 5, -1, 1, 1, 1, 0, 0, 1, 0},
	{"mgt", 3, 8, 1, 1, 1, 1, 0, 1, 1},
	{"mgterm", 6, 8, 1, 1, 1, 0, 0, 1, 0},
	{"minitel", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"minitel1", 8, 8, 0, 1, 0, 1, 0, 1, 1},
	{"minitel12-80", 12, -1, 1, 1, 1, 1, 0, 1, 1},
	{"minitel1b", 9, 8, 1, 1, 1, 1, 0, 1, 1},
	{"minitel1b-80", 12, -1, 1, 1, 1, 1, 0, 1, 0},
	{"minitel1b-nb", 12, -1, 1, 1, 1, 1, 0, 1, 1},
	{"minitel-2", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"minitel2-80", 11, -1, 1, 1, 1, 1, 0, 1, 1},
	{"minitel-2-nam", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"minix", 5, 8, 1, 1, 1, 0, 0, 1, 0},
	{"minix-1.5", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"minix-1.7", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"minix-3.0", 9, 8, 1, 1, 1, 0, 0, 1, 0},
	{"minix-old", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"minix-old-am", 12, -1, 1, 1, 1, 0, 0, 1, 0},
	{"mintty", 6, 256, 1, 1, 1, 1, 1, 1, 1},
	{"mintty+common", 13, 8, 1, 1, 1, 1, 1, 1, 1},
	{"mintty-direct", 13, 16777216, 1, 1, 1, 1, 1, 1, 1},
	{"mlterm", 6, 8, 1, 1, 1, 1, 0, 1, 1},
	{"mlterm2", 7, 8, 1, 1, 1, 1, 0, 1, 1},
	{"mlterm-256color", 15, 256, 1, 1, 1, 1, 0, 1, 1},
	{"mlterm3", 7, 8, 1, 1, 1, 1, 0, 1, 1},
	{"mlterm-direct", 13, 16777216, 1, 1, 1, 1, 0, 1, 1},
	{"mod24", 5, -1, 1, 1, 1, 0, 0, 1, 0},
	{"modgraph", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"morphos", 7, -1, 1, 1, 1, 1, 0, 1, 0},
	{"mosh", 4, 8, 1, 1, 1, 1, 0, 1, 1},
	{"mosh-256color", 13, 256, 1, 1, 1, 1, 0, 1, 1},
	{"mostlike", 8, -1, 1, 1, 1, 0, 0, 1, 1},
	{"mrxvt", 5, 8, 1, 1, 1, 1, 0, 1, 1},
	{"mrxvt-256color", 14, 256, 1, 1, 1, 1, 0, 1, 1},
	{"ms-terminal", 11, 256, 1, 1, 1, 1, 1, 1, 1},
	{"ms-vt100", 8, -1, 1, 1, 1, 0, 0, 1, 1},
	{"ms-vt100+", 9, 8, 1, 1, 1, 0, 0, 1, 1},
	{"ms-vt100-16color", 16, 16, 1, 1, 1, 1, 0, 1, 1},
	{"ms-vt100-color", 14, 8, 1, 1, 1, 0, 0, 1, 1},
	{"ms-vt-utf8", 10, 8, 1, 1, 1, 0, 0, 1, 1},
	{"mt4520-rv", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"mterm-ansi", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"mvterm", 6, 8, 1, 1, 1, 0, 0, 1, 0},
	{"nansi.sys", 9, 8, 0, 1, 0, 0, 0, 1, 1},
	{"nansisys", 8, 8, 0, 1, 0, 0, 0, 1, 1},
	{"nansi.sysk", 10, 8, 0, 1, 0, 0, 0, 1, 1},
	{"nansisysk", 9, 8, 0, 1, 0, 0, 0, 1, 1},
	{"ncr160vt100an", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr160vt100pp", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr160vt100wan", 14, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr160vt100wpp", 14, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr160vt200an", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr160vt200pp", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr160vt200wan", 14, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr160vt200wpp", 14, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr160vt300an", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr160vt300pp", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr160vt300wan", 14, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr160vt300wpp", 14, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr260intan", 11, 8, 1, 1, 1, 1, 0, 1, 1},
	{"ncr260intpp", 11, 8, 1, 1, 1, 1, 0, 1, 1},
	{"ncr260intwan", 12, 8, 1, 1, 1, 1, 0, 1, 1},
	{"ncr260intwpp", 12, 8, 1, 1, 1, 1, 0, 1, 1},
	{"ncr260vt100an", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr260vt100pp", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr260vt100wan", 14, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr260vt100wpp", 14, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr260vt200an", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr260vt200pp", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr260vt200wan", 14, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr260vt200wpp", 14, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr260vt300an", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr260vt300pp", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr260vt300wan", 14, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr260vt300wpp", 14, -1, 1, 1, 1, 1, 0, 1, 1},
	{"NCR260VT300WPP", 14, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncr260wy325pp", 13, 16, 0, 1, 1, 1, 0, 1, 0},
	{"ncr260wy325wpp", 14, 16, 0, 1, 1, 1, 0, 1, 0},
	{"ncr260wy350pp", 13, 16, 0, 1, 1, 1, 0, 1, 0},
	{"ncr260wy350wpp", 14, 16, 0, 1, 1, 1, 0, 1, 0},
	{"ncrvt100an", 10, -1, 1, 1, 1, 0, 0, 1, 1},
	{"ncrvt100pp", 10, -1, 1, 1, 1, 0, 0, 1, 1},
	{"ncrvt100wan", 11, -1, 1, 1, 1, 0, 0, 1, 1},
	{"ncrvt100wpp", 11, -1, 1, 1, 1, 0, 0, 1, 1},
	{"NCRVT100WPP", 11, -1, 1, 1, 1, 0, 0, 1, 1},
	{"ncsa", 4, 8, 1, 1, 1, 1, 0, 1, 1},
	{"ncsa-m", 6, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncsa-m-ns", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ncsa-ns", 7, 8, 1, 1, 1, 1, 0, 1, 1},
	{"ncsa-vt220", 10, 8, 1, 1, 1, 1, 0, 1, 1},
	{"ncsa-vt220-8", 12, -1, 1, 1, 1, 1, 0, 1, 1},
	{"netbsd6", 7, 8, 1, 1, 1, 1, 0, 1, 1},
	{"nsterm", 6, 256, 1, 1, 1, 1, 0, 1, 1},
	{"nsterm-16color", 14, 16, 1, 1, 1, 1, 0, 1, 1},
	{"nsterm-256color", 15, 256, 1, 1, 1, 1, 0, 1, 1},
	{"nsterm+7", 8, -1, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-7", 8, 8, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-7-c", 10, 16, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-7-c-s", 12, 16, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-7-m", 10, -1, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-7-m-s", 12, -1, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-7-s", 10, 8, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm+acs", 10, -1, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-acs", 10, 8, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-acs-c", 12, 16, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-acs-c-s", 14, 16, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-acs-m", 12, -1, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-acs-m-s", 14, -1, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-acs-s", 12, 8, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-bce", 10, 16, 1, 1, 1, 1, 0, 1, 1},
	{"nsterm-build309", 15, 256, 1, 1, 1, 1, 0, 1, 1},
	{"nsterm-build326", 15, 256, 1, 1, 1, 1, 0, 1, 1},
	{"nsterm-build343", 15, 256, 1, 1, 1, 1, 0, 1, 1},
	{"nsterm-build361", 15, 256, 1, 1, 1, 1, 0, 1, 1},
	{"nsterm-build400", 15, 256, 1, 1, 1, 1, 0, 1, 1},
	{"nsterm-build440", 15, 256, 1, 1, 1, 1, 0, 1, 1},
	{"nsterm+c", 8, 16, 0, 0, 0, 0, 0, 0, 0},
	{"nsterm-c", 8, 16, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm+c41", 10, 8, 0, 0, 0, 0, 0, 0, 0},
	{"nsterm-c-7", 10, 16, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-c-acs", 12, 16, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-c-s", 10, 16, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-c-s-7", 12, 16, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-c-s-acs", 14, 16, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-direct", 13, 16777216, 1, 1, 1, 1, 0, 1, 1},
	{"nsterm-m", 8, -1, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-m-7", 10, -1, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm+mac", 10, -1, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-m-acs", 12, -1, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-m-s", 10, -1, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-m-s-7", 12, -1, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-m-s-acs", 14, -1, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-old", 10, 8, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-s", 8, 8, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-s-7", 10, 8, 1, 1, 1, 0, 0, 1, 1},
	{"nsterm-s-acs", 12, 8, 1, 1, 1, 0, 0, 1, 1},
	{"ntconsole", 9, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ntconsole-100", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ntconsole-100-nti", 17, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ntconsole-25", 12, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ntconsole-25-nti", 16, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ntconsole-25-w", 14, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ntconsole-25-w-vt", 17, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ntconsole-35", 12, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ntconsole-35-nti", 16, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ntconsole-35-w", 14, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ntconsole-50", 12, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ntconsole-50-nti", 16, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ntconsole-50-w", 14, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ntconsole-60", 12, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ntconsole-60-nti", 16, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ntconsole-60-w", 14, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ntconsole-w", 11, 8, 1, 1, 1, 0, 0, 1, 0},
	{"ntconsole-w-vt", 14, 8, 1, 1, 1, 0, 0, 1, 0},
	{"nwp-517", 7, -1, 1, 1, 1, 0, 0, 1, 1},
	{"nwp517", 6, -1, 1, 1, 1, 0, 0, 1, 1},
	{"nwp-517-w", 9, -1, 1, 1, 1, 0, 0, 1, 1},
	{"nwp517-w", 8, -1, 1, 1, 1, 0, 0, 1, 1},
	{"nxterm", 6, 8, 1, 1, 1, 0, 0, 1, 1},
	{"ofcons", 6, -1, 1, 1, 1, 0, 0, 0, 0},
	{"old-st", 6, 8, 0, 1, 1, 1, 0, 1, 0},
	{"opennt", 6, 8, 1, 1, 1, 0, 0, 1, 0},
	{"opennt-100", 10, 8, 1, 1, 1, 0, 0, 1, 0},
	{"opennt-100-nti", 14, 8, 1, 1, 1, 0, 0, 1, 0},
	{"opennt-25", 9, 8, 1, 1, 1, 0, 0, 1, 0},
	{"opennt-25-nti", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"opennt-25-w", 11, 8, 1, 1, 1, 0, 0, 1, 0},
	{"opennt-25-w-vt", 14, 8, 1, 1, 1, 0, 0, 1, 0},
	{"opennt-35", 9, 8, 1, 1, 1, 0, 0, 1, 0},
	{"opennt-35-nti", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"opennt-35-w", 11, 8, 1, 1, 1, 0, 0, 1, 0},
	{"opennt-50", 9, 8, 1, 1, 1, 0, 0, 1, 0},
	{"opennt-50-nti", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"opennt-50-w", 11, 8, 1, 1, 1, 0, 0, 1, 0},
	{"opennt-60", 9, 8, 1, 1, 1, 0, 0, 1, 0},
	{"opennt-60-nti", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"opennt-60-w", 11, 8, 1, 1, 1, 0, 0, 1, 0},
	{"opennt-nti", 10, 8, 1, 1, 1, 0, 0, 1, 0},
	{"opennt-w", 8, 8, 1, 1, 1, 0, 0, 1, 0},
	{"opennt-w-vt", 11, 8, 1, 1, 1, 0, 0, 1, 0},
	{"p12", 3, -1, 1, 1, 1, 1, 0, 1, 0},
	{"P12", 3, -1, 1, 1, 1, 1, 0, 1, 0},
	{"p12-w", 5, -1, 1, 1, 1, 1, 0, 1, 0},
	{"P12-W", 5, -1, 1, 1, 1, 1, 0, 1, 0},
	{"p14", 3, -1, 1, 1, 1, 1, 0, 1, 0},
	{"P14", 3, -1, 1, 1, 1, 1, 0, 1, 0},
	{"p14-w", 5, -1, 1, 1, 1, 1, 0, 1, 0},
	{"P14-W", 5, -1, 1, 1, 1, 1, 0, 1, 0},
	{"p9", 2, -1, 1, 1, 1, 1, 0, 1, 0},
	{"P9", 2, -1, 1, 1, 1, 1, 0, 1, 0},
	{"p9-w", 4, -1, 1, 1, 1, 1, 0, 1, 0},
	{"P9-W", 4, -1, 1, 1, 1, 1, 0, 1, 0},
	{"pc3", 3, 8, 1, 1, 1, 0, 0, 1, 0},
	{"pc3-bold", 8, 8, 1, 1, 1, 0, 0, 1, 0},
	{"pc3r", 4, 8, 1, 1, 1, 0, 0, 1, 0},
	{"pc3r-m", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"pc7300", 6, -1, 1, 1, 1, 1, 0, 1, 0},
	{"pcansi", 6, 8, 0, 1, 1, 0, 0, 1, 0},
	{"pcansi-25", 9, 8, 0, 1, 1, 0, 0, 1, 0},
	{"pcansi25", 8, 8, 0, 1, 1, 0, 0, 1, 0},
	{"pcansi-33", 9, 8, 0, 1, 1, 0, 0, 1, 0},
	{"pcansi33", 8, 8, 0, 1, 1, 0, 0, 1, 0},
	{"pcansi-43", 9, 8, 0, 1, 1, 0, 0, 1, 0},
	{"pcansi43", 8, 8, 0, 1, 1, 0, 0, 1, 0},
	{"pccon", 5, 8, 1, 1, 1, 1, 0, 1, 1},
	{"pccon0", 6, 8, 1, 1, 1, 0, 0, 1, 1},
	{"pccon0-m", 8, -1, 1, 1, 1, 0, 0, 1, 1},
	{"pccon+base", 10, -1, 1, 1, 1, 0, 0, 1, 1},
	{"pccon+colors", 12, 8, 0, 0, 0, 0, 0, 0, 0},
	{"pccon-m", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"pc-minix", 8, 8, 1, 1, 1, 0, 0, 1, 0},
	{"pcplot", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"pcvt25", 6, -1, 1, 1, 1, 1, 0, 1, 1},
	{"pcvt25-color", 12, 8, 1, 1, 1, 1, 0, 1, 1},
	{"pcvt25w", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"pcvt28", 6, -1, 1, 1, 1, 1, 0, 1, 1},
	{"pcvt28w", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"pcvt35", 6, -1, 1, 1, 1, 1, 0, 1, 1},
	{"pcvt35w", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"pcvt40", 6, -1, 1, 1, 1, 1, 0, 1, 1},
	{"pcvt40w", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"pcvt43", 6, -1, 1, 1, 1, 1, 0, 1, 1},
	{"pcvt43w", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"pcvt50", 6, -1, 1, 1, 1, 1, 0, 1, 1},
	{"pcvt50w", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"pcvtXX", 6, -1, 1, 1, 1, 1, 0, 1, 1},
	{"prism12", 7, -1, 1, 1, 1, 1, 0, 1, 0},
	{"prism12-w", 9, -1, 1, 1, 1, 1, 0, 1, 0},
	{"prism14", 7, -1, 1, 1, 1, 1, 0, 1, 0},
	{"prism14-w", 9, -1, 1, 1, 1, 1, 0, 1, 0},
	{"prism9", 6, -1, 1, 1, 1, 1, 0, 1, 0},
	{"prism9-w", 8, -1, 1, 1, 1, 1, 0, 1, 0},
	{"ps300", 5, -1, 1, 1, 1, 0, 0, 1, 0},
	{"pt100", 5, -1, 1, 1, 1, 0, 0, 1, 0},
	{"pt100w", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"pt200", 5, -1, 1, 1, 1, 0, 0, 1, 0},
	{"pt200w", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"pt250", 5, -1, 1, 1, 1, 0, 0, 1, 0},
	{"pt250w", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"pt505", 5, -1, 1, 1, 1, 0, 0, 1, 1},
	{"pt505-22", 8, -1, 1, 1, 1, 0, 0, 1, 1},
	{"pt505-24", 8, -1, 1, 1, 1, 0, 0, 1, 1},
	{"putty", 5, 8, 1, 1, 1, 1, 1, 1, 1},
	{"putty-256color", 14, 256, 1, 1, 1, 1, 1, 1, 1},
	{"putty-m1", 8, 8, 0, 1, 1, 1, 1, 1, 1},
	{"putty-noapp", 11, 8, 1, 1, 1, 1, 1, 1, 1},
	{"putty-sco", 9, 8, 1, 1, 1, 1, 1, 1, 1},
	{"putty-screen", 12, 8, 1, 1, 1, 1, 1, 1, 1},
	{"putty-vt100", 11, 8, 1, 1, 1, 1, 1, 1, 1},
	{"Q306-8-pc", 9, -1, 1, 1, 1, 1, 0, 1, 0},
	{"qansi", 5, 8, 1, 1, 1, 1, 0, 1, 1},
	{"qansi-g", 7, 8, 1, 1, 1, 1, 0, 1, 1},
	{"qansi-m", 7, 8, 1, 1, 1, 1, 0, 1, 1},
	{"qansi-t", 7, 8, 1, 1, 1, 1, 0, 1, 1},
	{"qansi-w", 7, 8, 1, 1, 1, 1, 0, 1, 1},
	{"qnx", 3, 8, 0, 1, 1, 1, 0, 1, 0},
	{"qnx4", 4, 8, 0, 1, 1, 1, 0, 1, 0},
	{"qnxm", 4, 8, 0, 1, 1, 1, 0, 1, 0},
	{"qnxt", 4, 8, 0, 1, 1, 1, 0, 1, 0},
	{"qnxt2", 5, 8, 0, 1, 1, 0, 0, 1, 0},
	{"qnxt4", 5, 8, 0, 1, 1, 1, 0, 1, 0},
	{"qnxw", 4, 8, 0, 1, 1, 1, 0, 1, 0},
	{"qvt103", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"qvt103-w", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"qvt203", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"qvt203+", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"qvt203-25", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"qvt203-25-w", 11, -1, 1, 1, 1, 0, 0, 1, 0},
	{"qvt203-w", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"qvt203-w-am", 11, -1, 1, 1, 1, 0, 0, 1, 0},
	{"rcons-color", 11, 8, 0, 1, 1, 0, 0, 0, 0},
	{"rio", 3, 256, 1, 1, 1, 1, 1, 1, 1},
	{"rio+base", 8, 8, 1, 1, 1, 1, 1, 1, 1},
	{"rio-direct", 10, 16777216, 1, 1, 1, 1, 1, 1, 1},
	{"rt6221", 6, -1, 1, 1, 1, 1, 0, 1, 0},
	{"rt6221-w", 8, -1, 1, 1, 1, 1, 0, 1, 0},
	{"rxvt", 4, 8, 1, 1, 1, 1, 0, 1, 1},
	{"rxvt-16color", 12, 16, 1, 1, 1, 1, 0, 1, 1},
	{"rxvt-256color", 13, 256, 1, 1, 1, 1, 0, 1, 1},
	{"rxvt-88color", 12, 88, 1, 1, 1, 1, 0, 1, 1},
	{"rxvt-basic", 10, -1, 1, 1, 1, 1, 0, 1, 1},
	{"rxvt-color", 10, 8, 1, 1, 1, 1, 0, 1, 1},
	{"rxvt-cygwin", 11, 8, 1, 1, 1, 1, 0, 1, 1},
	{"rxvt-cygwin-native", 18, 8, 1, 1, 1, 1, 0, 1, 1},
	{"rxvt-unicode", 12, 88, 1, 1, 1, 1, 0, 1, 1},
	{"rxvt-unicode-256color", 21, 256, 1, 1, 1, 1, 0, 1, 1},
	{"rxvt-xpm", 8, 8, 1, 1, 1, 1, 0, 1, 1},
	{"s4", 2, -1, 1, 1, 1, 1, 0, 1, 0},
	{"scoansi", 7, 8, 1, 1, 1, 1, 0, 1, 0},
	{"scoansi-new", 11, 8, 1, 1, 1, 1, 0, 1, 0},
	{"scoansi-old", 11, 8, 1, 1, 1, 1, 0, 1, 0},
	{"screen", 6, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen-16color", 14, 16, 1, 1, 1, 1, 0, 1, 1},
	{"screen-16color-bce", 18, 16, 1, 1, 1, 1, 0, 1, 1},
	{"screen-16color-bce-s", 20, 16, 1, 1, 1, 1, 0, 1, 1},
	{"screen-16color-s", 16, 16, 1, 1, 1, 1, 0, 1, 1},
	{"screen2", 7, -1, 1, 1, 1, 0, 0, 0, 0},
	{"screen-256color", 15, 256, 1, 1, 1, 1, 0, 1, 1},
	{"screen-256color-bce", 19, 256, 1, 1, 1, 1, 0, 1, 1},
	{"screen-256color-bce-s", 21, 256, 1, 1, 1, 1, 0, 1, 1},
	{"screen-256color-s", 17, 256, 1, 1, 1, 1, 0, 1, 1},
	{"screen3", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"screen4", 7, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen5", 7, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen-base", 11, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen-bce", 10, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen-bce.Eterm", 16, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen-bce.gnome", 16, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen-bce.konsole", 18, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen-bce.linux", 16, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen-bce.mrxvt", 16, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen-bce.rxvt", 15, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen-bce.xterm-new", 20, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen.Eterm", 12, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen.gnome", 12, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen.konsole", 14, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen.konsole-256color", 23, 256, 1, 1, 1, 1, 0, 1, 1},
	{"screen.linux", 12, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen.linux-m1", 15, 8, 1, 1, 1, 1, 1, 1, 1},
	{"screen.linux-m1b", 16, -1, 1, 1, 1, 1, 1, 1, 1},
	{"screen.linux-m2", 15, -1, 1, 1, 1, 1, 1, 1, 1},
	{"screen.linux-s", 14, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen.minitel1", 15, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen.minitel12-80", 19, -1, 1, 1, 1, 1, 0, 1, 1},
	{"screen.minitel1b", 16, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen.minitel1b-80", 19, -1, 1, 1, 1, 1, 0, 1, 1},
	{"screen.minitel1b-nb", 19, -1, 1, 1, 1, 1, 0, 1, 1},
	{"screen.minitel1-nb", 18, -1, 1, 1, 1, 1, 0, 1, 1},
	{"screen.minitel2-80", 18, -1, 1, 1, 1, 1, 0, 1, 1},
	{"screen.mlterm", 13, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen.mlterm-256color", 22, 256, 1, 1, 1, 1, 0, 1, 1},
	{"screen.mrxvt", 12, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen.putty", 12, 8, 1, 1, 1, 1, 1, 1, 1},
	{"screen.putty-256color", 21, 256, 1, 1, 1, 1, 1, 1, 1},
	{"screen.putty-m1", 15, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen.putty-m1b", 16, -1, 1, 1, 1, 1, 0, 1, 1},
	{"screen.putty-m2", 15, -1, 1, 1, 1, 1, 0, 1, 1},
	{"screen.rxvt", 11, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen-s", 8, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen.teraterm", 15, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen.vte", 10, 8, 1, 1, 1, 1, 1, 1, 1},
	{"screen.vte-256color", 19, 256, 1, 1, 1, 1, 1, 1, 1},
	{"screen-w", 8, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen.xterm-256color", 21, 256, 1, 1, 1, 1, 0, 1, 1},
	{"screen.xterm-new", 16, 8, 1, 1, 1, 1, 0, 1, 1},
	{"screen.xterm-r6", 15, -1, 1, 1, 1, 0, 0, 1, 1},
	{"screen.xterm-xfree86", 20, 8, 1, 1, 1, 1, 0, 1, 1},
	{"scrhp", 5, -1, 1, 1, 1, 0, 0, 1, 0},
	{"scrt", 4, 256, 1, 1, 1, 1, 1, 1, 1},
	{"securecrt", 9, 256, 1, 1, 1, 1, 1, 1, 1},
	{"simpleterm", 10, 8, 0, 1, 1, 1, 0, 1, 0},
	{"st", 2, 8, 1, 1, 1, 1, 0, 1, 1},
	{"st-0.6", 6, 8, 1, 1, 1, 1, 0, 1, 1},
	{"st-0.7", 6, 8, 1, 1, 1, 1, 0, 1, 1},
	{"st-0.8", 6, 8, 1, 1, 1, 1, 0, 1, 1},
	{"st-16color", 10, 16, 1, 1, 1, 1, 0, 1, 1},
	{"st-256color", 11, 256, 1, 1, 1, 1, 0, 1, 1},
	{"st52-color", 10, 16, 0, 1, 1, 1, 0, 1, 0},
	{"st-direct", 9, 16777216, 1, 1, 1, 1, 0, 1, 1},
	{"stterm", 6, 8, 1, 1, 1, 1, 0, 1, 1},
	{"stterm-16color", 14, 16, 1, 1, 1, 1, 0, 1, 1},
	{"stterm-256color", 15, 256, 1, 1, 1, 1, 0, 1, 1},
	{"sun-color", 9, 8, 1, 1, 1, 0, 0, 1, 0},
	{"sv80", 4, -1, 1, 1, 1, 0, 0, 1, 1},
	{"tab", 3, -1, 1, 1, 1, 0, 0, 1, 1},
	{"tab132", 6, -1, 1, 1, 1, 0, 0, 1, 1},
	{"tab132-15", 9, -1, 1, 1, 1, 0, 0, 1, 1},
	{"tab132-rv", 9, -1, 1, 1, 1, 0, 0, 1, 1},
	{"tab132-w", 8, -1, 1, 1, 1, 0, 0, 1, 1},
	{"tab132-w-rv", 11, -1, 1, 1, 1, 0, 0, 1, 1},
	{"tek4105-30", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"tek4105a", 8, -1, 1, 1, 1, 1, 0, 1, 0},
	{"tek4106brl", 10, -1, 1, 1, 1, 1, 0, 1, 0},
	{"tek4107brl", 10, -1, 1, 1, 1, 1, 0, 1, 0},
	{"tek4109brl", 10, -1, 1, 1, 1, 1, 0, 1, 0},
	{"tek4115", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"tek4125", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"tek4205", 7, 8, 1, 1, 1, 0, 0, 1, 0},
	{"teken", 5, 8, 1, 1, 1, 1, 0, 1, 0},
	{"teken-16color", 13, 16, 1, 1, 1, 1, 0, 1, 0},
	{"teken-2018", 10, 8, 1, 1, 1, 1, 0, 1, 0},
	{"teken-2022", 10, 8, 1, 1, 1, 1, 0, 1, 0},
	{"teken-sc", 8, 8, 1, 1, 1, 1, 0, 1, 0},
	{"teken-vt", 8, 8, 1, 1, 1, 1, 0, 1, 0},
	{"teraterm", 8, 8, 1, 1, 1, 1, 0, 1, 1},
	{"teraterm2.3", 11, 8, 1, 1, 1, 1, 0, 1, 1},
	{"teraterm-256color", 17, 256, 1, 1, 1, 1, 0, 1, 1},
	{"teraterm4.59", 12, 8, 1, 1, 1, 1, 0, 1, 1},
	{"teraterm4.97", 12, 8, 1, 1, 1, 1, 0, 1, 1},
	{"terminator", 10, 256, 1, 1, 1, 1, 0, 1, 1},
	{"terminology", 11, 256, 1, 1, 1, 1, 1, 1, 1},
	{"terminology-0.6.1", 17, 256, 1, 0, 0, 0, 0, 1, 1},
	{"terminology-1.0.0", 17, 256, 1, 0, 0, 1, 0, 1, 1},
	{"terminology-1.8.1", 17, 256, 1, 1, 1, 1, 1, 1, 1},
	{"termite", 7, 256, 1, 1, 1, 1, 0, 1, 1},
	{"ti916", 5, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ti916-132", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ti916-220-7", 11, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ti916-220-8", 11, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ti916-8", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ti916-8-132", 11, -1, 1, 1, 1, 1, 0, 1, 1},
	{"ti928", 5, 8, 0, 1, 1, 0, 0, 1, 0},
	{"ti928-8", 7, 8, 0, 1, 1, 0, 0, 1, 0},
	{"ti_ansi", 7, 8, 0, 1, 1, 0, 0, 1, 0},
	{"tmux", 4, 8, 1, 1, 1, 1, 1, 1, 1},
	{"tmux-256color", 13, 256, 1, 1, 1, 1, 1, 1, 1},
	{"tmux-direct", 11, 16777216, 1, 1, 1, 1, 1, 1, 1},
	{"ts100", 5, -1, 1, 1, 1, 0, 0, 1, 1},
	{"ts100-ctxt", 10, -1, 1, 1, 1, 0, 0, 1, 1},
	{"ts100-sp", 8, -1, 1, 1, 1, 0, 0, 1, 1},
	{"tt52", 4, 16, 0, 1, 1, 1, 0, 1, 0},
	{"tty4424", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"tty4424-1", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"tty4426", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"tty5420", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"tty5420-nl", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"tty5420-rv", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"tty5420-rv-nl", 13, -1, 1, 1, 1, 0, 0, 1, 0},
	{"tty5420-w", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"tty5420-w-nl", 12, -1, 1, 1, 1, 0, 0, 1, 0},
	{"tty5420-w-rv", 12, -1, 1, 1, 1, 0, 0, 1, 0},
	{"tty5420-w-rv-n", 14, -1, 1, 1, 1, 0, 0, 1, 0},
	{"tty5425", 7, -1, 1, 1, 1, 0, 0, 1, 1},
	{"tty5425-nl", 10, -1, 1, 1, 1, 0, 0, 1, 1},
	{"tty5425-w", 9, -1, 1, 1, 1, 0, 0, 1, 1},
	{"tvi9065", 7, -1, 1, 1, 1, 1, 0, 1, 0},
	{"tw100", 5, 8, 1, 1, 1, 1, 0, 1, 0},
	{"tw52", 4, 16, 0, 1, 1, 1, 0, 1, 0},
	{"tw52-color", 10, 16, 0, 1, 1, 1, 0, 1, 0},
	{"tws2102-sna", 11, -1, 1, 1, 1, 1, 0, 1, 0},
	{"tws2103", 7, -1, 1, 1, 1, 1, 0, 1, 0},
	{"tws2103-sna", 11, -1, 1, 1, 1, 1, 0, 1, 0},
	{"tws-generic", 11, -1, 1, 1, 1, 1, 0, 1, 0},
	{"uniterm", 7, -1, 1, 1, 1, 0, 0, 1, 1},
	{"uniterm49", 9, -1, 1, 1, 1, 0, 0, 1, 1},
	{"unixpc", 6, -1, 1, 1, 1, 1, 0, 1, 0},
	{"uts30", 5, -1, 1, 1, 1, 1, 0, 1, 0},
	{"uwin", 4, 8, 0, 1, 1, 1, 0, 1, 1},
	{"v200-nam", 8, -1, 1, 1, 1, 1, 0, 1, 1},
	{"v320n", 5, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vi603", 5, -1, 1, 1, 1, 0, 0, 1, 1},
	{"visa50", 6, -1, 1, 1, 1, 0, 0, 1, 0},
	{"visual603", 9, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vk100", 5, -1, 1, 1, 1, 0, 0, 0, 0},
	{"vs100", 5, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vscode", 6, 256, 1, 1, 1, 1, 1, 1, 1},
	{"vscode-direct", 13, 16777216, 1, 1, 1, 1, 1, 1, 1},
	{"vt100", 5, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt100+", 6, 8, 1, 1, 1, 0, 0, 1, 1},
	{"vt100+4bsd", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"vt100-am", 8, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt100-bot-s", 11, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt100-nam", 9, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt100nam", 8, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt100-nam-w", 11, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt100-nav", 9, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt100-nav-w", 11, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt100-putty", 11, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt100-s", 7, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt100-s-bot", 11, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt100-s-top", 11, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt100-top-s", 11, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt100-vb", 8, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt100-w", 7, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt100-w-am", 10, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt100-w-nam", 11, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt100-w-nav", 11, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt102", 5, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt102-nsgr", 10, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt102-w", 7, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt125", 5, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt132", 5, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt200", 5, -1, 1, 1, 1, 1, 0, 1, 1},
	{"vt200-8", 7, -1, 1, 1, 1, 1, 0, 1, 0},
	{"vt200-8bit", 10, -1, 1, 1, 1, 1, 0, 1, 0},
	{"vt200-w", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"vt220", 5, -1, 1, 1, 1, 1, 0, 1, 1},
	{"vt220-8", 7, -1, 1, 1, 1, 1, 0, 1, 0},
	{"vt220-8bit", 10, -1, 1, 1, 1, 1, 0, 1, 0},
	{"vt220-base", 10, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt220-nam", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"vt220-w", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"vt300", 5, -1, 1, 1, 1, 1, 0, 1, 1},
	{"vt300-nam", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"vt300-w", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"vt300-w-nam", 11, -1, 1, 1, 1, 1, 0, 1, 1},
	{"vt320", 5, -1, 1, 1, 1, 1, 0, 1, 1},
	{"vt320-k3", 8, -1, 1, 1, 1, 1, 0, 1, 0},
	{"vt320-k311", 10, -1, 1, 1, 1, 1, 0, 1, 0},
	{"vt320-nam", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"vt320nam", 8, -1, 1, 1, 1, 0, 0, 1, 1},
	{"vt320-w", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"vt320-w-nam", 11, -1, 1, 1, 1, 1, 0, 1, 1},
	{"vt330", 5, -1, 1, 1, 1, 1, 0, 1, 0},
	{"vt340", 5, -1, 1, 1, 1, 1, 0, 1, 0},
	{"vt400", 5, -1, 1, 1, 1, 1, 0, 1, 0},
	{"vt400-24", 8, -1, 1, 1, 1, 1, 0, 1, 0},
	{"vt420", 5, -1, 1, 1, 1, 1, 0, 1, 1},
	{"vt420f", 6, -1, 1, 1, 1, 1, 0, 1, 1},
	{"vt420pc", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"vt420pcdos", 10, -1, 1, 1, 1, 1, 0, 1, 1},
	{"vt510", 5, -1, 1, 1, 1, 1, 0, 1, 1},
	{"vt510pc", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"vt510pcdos", 10, -1, 1, 1, 1, 1, 0, 1, 1},
	{"vt520", 5, -1, 1, 1, 1, 1, 0, 1, 1},
	{"vt520ansi", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"vt525", 5, -1, 1, 1, 1, 1, 0, 1, 1},
	{"vte", 3, 8, 1, 1, 1, 1, 1, 1, 1},
	{"vte-2007", 8, 8, 1, 1, 1, 1, 0, 1, 1},
	{"vte-2008", 8, 8, 1, 1, 1, 1, 0, 1, 1},
	{"vte-2012", 8, 8, 1, 1, 1, 1, 0, 1, 1},
	{"vte-2014", 8, 8, 1, 1, 1, 1, 0, 1, 1},
	{"vte-2017", 8, 8, 1, 1, 1, 1, 1, 1, 1},
	{"vte-2018", 8, 8, 1, 1, 1, 1, 1, 1, 1},
	{"vte-256color", 12, 256, 1, 1, 1, 1, 1, 1, 1},
	{"vte-direct", 10, 16777216, 1, 1, 1, 1, 1, 1, 1},
	{"vtnt", 4, 8, 1, 1, 1, 0, 0, 1, 1},
	{"vt-utf8", 7, 8, 1, 1, 1, 0, 0, 1, 1},
	{"vv100", 5, 8, 1, 1, 1, 0, 0, 1, 0},
	{"vwmterm", 7, 8, 1, 1, 1, 1, 0, 1, 0},
	{"wezterm", 7, 256, 1, 1, 1, 1, 1, 1, 1},
	{"winconsole", 10, 8, 1, 1, 1, 1, 0, 1, 0},
	{"wren", 4, -1, 1, 1, 1, 0, 0, 1, 0},
	{"wrenw", 5, -1, 1, 1, 1, 0, 0, 1, 0},
	{"wsvt25", 6, 8, 1, 1, 1, 1, 0, 1, 1},
	{"wsvt25m", 7, 8, 1, 1, 1, 1, 0, 1, 1},
	{"wy185", 5, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy185-24", 8, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy185-vb", 8, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy185-w", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy185-wvb", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy350", 5, 8, 0, 1, 1, 1, 0, 1, 0},
	{"wy350-vb", 8, 8, 0, 1, 1, 1, 0, 1, 0},
	{"wy350-w", 7, 8, 0, 1, 1, 1, 0, 1, 0},
	{"wy350-wvb", 9, 8, 0, 1, 1, 1, 0, 1, 0},
	{"wy370", 5, 64, 1, 1, 1, 1, 0, 1, 1},
	{"wy370-101k", 10, 64, 1, 1, 1, 1, 0, 1, 1},
	{"wy370-105k", 10, 64, 1, 1, 1, 1, 0, 1, 1},
	{"wy370-EPC", 9, 64, 1, 1, 1, 1, 0, 1, 1},
	{"wy370-nk", 8, 64, 1, 1, 1, 1, 0, 1, 1},
	{"wy370-rv", 8, 64, 1, 1, 1, 1, 0, 1, 1},
	{"wy370-vb", 8, 64, 1, 1, 1, 1, 0, 1, 1},
	{"wy370-w", 7, 64, 1, 1, 1, 1, 0, 1, 1},
	{"wy370-wvb", 9, 64, 1, 1, 1, 1, 0, 1, 1},
	{"wy520", 5, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy520-24", 8, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy520-36", 8, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy520-36pc", 10, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy520-36w", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy520-36wpc", 11, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy520-48", 8, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy520-48pc", 10, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy520-48w", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy520-48wpc", 11, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy520-epc", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy520-epc-24", 12, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy520-epc-vb", 12, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy520-epc-w", 11, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy520-epc-wvb", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy520-vb", 8, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy520-w", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy520-wvb", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy60-AT", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"wy60-PC", 7, -1, 1, 1, 1, 0, 0, 1, 0},
	{"wy75", 4, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy-75ap", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy75ap", 6, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy75-mc", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy75-vb", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy75-w", 6, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy75-wvb", 8, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy85", 4, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy85-8bit", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy85-vb", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy85-w", 6, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy85-wvb", 8, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wy99a-ansi", 10, -1, 1, 1, 1, 1, 0, 1, 0},
	{"wy99-ansi", 9, -1, 1, 1, 1, 1, 0, 1, 0},
	{"wyse185", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse185-24", 10, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse185-vb", 10, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse185-w", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse185-wvb", 11, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse350", 7, 8, 0, 1, 1, 1, 0, 1, 0},
	{"wyse350-vb", 10, 8, 0, 1, 1, 1, 0, 1, 0},
	{"wyse350-w", 9, 8, 0, 1, 1, 1, 0, 1, 0},
	{"wyse350-wvb", 11, 8, 0, 1, 1, 1, 0, 1, 0},
	{"wyse370", 7, 64, 1, 1, 1, 1, 0, 1, 1},
	{"wyse520", 7, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse520-24", 10, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse520-36", 10, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse520-36pc", 12, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse520-36w", 11, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse520-36wpc", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse520-48", 10, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse520-48pc", 12, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse520-48w", 11, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse520-48wpc", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse520-epc", 11, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse520-epc-w", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse520-pc-24", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse520-pc-vb", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse520-p-wvb", 13, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse520-vb", 10, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse520-w", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse520-wvb", 11, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse60-AT", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"wyse60-PC", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"wyse75", 6, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse-75ap", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse75ap", 8, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse75-mc", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse75-vb", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse75-w", 8, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse75-wvb", 10, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse85", 6, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse85-8bit", 11, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse85-vb", 9, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse85-w", 8, -1, 1, 1, 1, 1, 0, 1, 1},
	{"wyse85-wvb", 10, -1, 1, 1, 1, 1, 0, 1, 1},
	{"x68k", 4, -1, 1, 1, 1, 0, 0, 1, 1},
	{"x68k-ite", 8, -1, 1, 1, 1, 0, 0, 1, 1},
	{"xdku", 4, -1, 1, 1, 1, 1, 0, 1, 0},
	{"xfce", 4, 8, 1, 1, 1, 1, 0, 1, 1},
	{"xgterm", 6, -1, 1, 1, 1, 0, 0, 1, 1},
	{"X-hpterm-color2", 15, 8, 0, 1, 1, 0, 0, 1, 0},
	{"xiterm", 6, 8, 1, 1, 1, 0, 0, 1, 1},
	{"xnuppc", 6, 8, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-100x37", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-100x37-m", 15, -1, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-112x37", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-112x37-m", 15, -1, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-128x40", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-128x40-m", 15, -1, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-128x48", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-128x48-m", 15, -1, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-144x48", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-144x48-m", 15, -1, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-160x64", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-160x64-m", 15, -1, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-200x64", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-200x64-m", 15, -1, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-200x75", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-200x75-m", 15, -1, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-256x96", 13, 8, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-256x96-m", 15, -1, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-80x25", 12, 8, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-80x25-m", 14, -1, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-80x30", 12, 8, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-80x30-m", 14, -1, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-90x30", 12, 8, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-90x30-m", 14, -1, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc+b", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-b", 8, 8, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc+basic", 12, -1, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc+c", 8, 8, 0, 0, 0, 0, 0, 0, 0},
	{"xnuppc+f", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-f", 8, 8, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc+f2", 9, -1, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-f2", 9, 8, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-m", 8, -1, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-m-b", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-m-f", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"xnuppc-m-f2", 11, -1, 1, 1, 1, 0, 0, 1, 0},
	{"xtalk", 5, -1, 1, 1, 1, 0, 0, 1, 0},
	{"xterm", 5, 8, 1, 1, 1, 1, 1, 1, 1},
	{"xterm1", 6, 8, 1, 1, 1, 1, 1, 1, 1},
	{"xterm-1002", 10, 8, 1, 1, 1, 1, 1, 1, 1},
	{"xterm-1003", 10, 8, 1, 1, 1, 1, 1, 1, 1},
	{"xterm-1005", 10, 8, 1, 1, 1, 1, 1, 1, 1},
	{"xterm-1006", 10, 8, 1, 1, 1, 1, 1, 1, 1},
	{"xterm-16color", 13, 16, 1, 1, 1, 1, 1, 1, 1},
	{"xterm-24", 8, -1, 1, 1, 1, 0, 0, 1, 1},
	{"xterm+256color", 14, 256, 0, 0, 0, 0, 0, 0, 0},
	{"xterm-256color", 14, 256, 1, 1, 1, 1, 1, 1, 1},
	{"xterm+256color2", 15, 256, 0, 0, 0, 0, 0, 0, 0},
	{"xterm+256setaf", 14, 256, 0, 0, 0, 0, 0, 0, 0},
	{"xterm+88color", 13, 88, 0, 0, 0, 0, 0, 0, 0},
	{"xterm-88color", 13, 88, 1, 1, 1, 1, 1, 1, 1},
	{"xterm+88color2", 14, 88, 0, 0, 0, 0, 0, 0, 0},
	{"xterm-8bit", 10, 8, 1, 1, 1, 1, 0, 1, 1},
	{"xterm-basic", 11, 8, 1, 1, 1, 1, 1, 1, 1},
	{"xterm-bold", 10, -1, 1, 1, 1, 0, 0, 1, 1},
	{"xtermc", 6, 8, 1, 1, 1, 0, 0, 1, 1},
	{"xterm-color", 11, 8, 1, 1, 1, 0, 0, 1, 1},
	{"xterm+direct", 12, 16777216, 0, 0, 0, 0, 0, 0, 0},
	{"xterm-direct", 12, 16777216, 1, 1, 1, 1, 1, 1, 1},
	{"xterm+direct16", 14, 16777216, 0, 0, 0, 0, 0, 0, 0},
	{"xterm-direct16", 14, 16777216, 1, 1, 1, 1, 1, 1, 1},
	{"xterm+direct2", 13, 16777216, 0, 0, 0, 0, 0, 0, 0},
	{"xterm-direct2", 13, 16777216, 1, 1, 1, 1, 1, 1, 1},
	{"xterm+direct256", 15, 16777216, 0, 0, 0, 0, 0, 0, 0},
	{"xterm-direct256", 15, 16777216, 1, 1, 1, 1, 1, 1, 1},
	{"xterm-hp", 8, 8, 1, 1, 1, 1, 1, 1, 1},
	{"xterm+indirect", 14, 16777216, 0, 0, 0, 0, 0, 0, 0},
	{"xterm.js", 8, 256, 1, 1, 1, 1, 1, 1, 1},
	{"xterm-kitty", 11, 256, 1, 1, 1, 1, 1, 1, 1},
	{"xtermm", 6, -1, 1, 1, 1, 0, 0, 1, 1},
	{"xterm-mono", 10, -1, 1, 1, 1, 0, 0, 1, 1},
	{"xterm-new", 9, 8, 1, 1, 1, 1, 1, 1, 1},
	{"xterm-nic", 9, 8, 1, 1, 1, 1, 1, 1, 1},
	{"xterm-noapp", 11, 8, 1, 1, 1, 1, 1, 1, 1},
	{"xterm+nofkeys", 13, 8, 1, 1, 1, 1, 1, 1, 1},
	{"xterm-old", 9, -1, 1, 1, 1, 0, 0, 1, 1},
	{"xterm-p370", 10, 8, 1, 1, 1, 1, 1, 1, 1},
	{"xterm-p371", 10, 8, 1, 1, 1, 1, 1, 1, 1},
	{"xterm-pcolor", 12, -1, 1, 1, 1, 0, 0, 1, 1},
	{"xterm-r5", 8, -1, 1, 1, 1, 0, 0, 1, 1},
	{"xterm-r6", 8, -1, 1, 1, 1, 0, 0, 1, 1},
	{"xterms", 6, -1, 1, 1, 1, 0, 0, 1, 1},
	{"xterm-sco", 9, 8, 1, 1, 1, 1, 1, 1, 1},
	{"xterms-sun", 10, 8, 1, 1, 1, 1, 1, 1, 1},
	{"xterm-sun", 9, 8, 1, 1, 1, 1, 1, 1, 1},
	{"xterm-utf8", 10, 8, 1, 1, 1, 1, 1, 1, 1},
	{"xterm-vt220", 11, 8, 1, 1, 1, 1, 1, 1, 1},
	{"xterm-x10mouse", 14, 8, 1, 1, 1, 1, 1, 1, 1},
	{"xterm-x11hilite", 15, 8, 1, 1, 1, 1, 1, 1, 1},
	{"xterm-x11mouse", 14, 8, 1, 1, 1, 1, 1, 1, 1},
	{"xterm-xf86-v32", 14, 8, 1, 1, 1, 1, 0, 1, 1},
	{"xterm-xf86-v33", 14, 8, 1, 1, 1, 1, 0, 1, 1},
	{"xterm-xf86-v333", 15, 8, 1, 1, 1, 1, 0, 1, 1},
	{"xterm-xf86-v40", 14, 8, 1, 1, 1, 1, 0, 1, 1},
	{"xterm-xf86-v43", 14, 8, 1, 1, 1, 1, 0, 1, 1},
	{"xterm-xf86-v44", 14, 8, 1, 1, 1, 1, 0, 1, 1},
	{"xterm-xfree86", 13, 8, 1, 1, 1, 1, 0, 1, 1},
	{"xterm-xi", 8, 8, 1, 1, 1, 1, 0, 1, 1},
	{"xwsh", 4, 8, 1, 1, 1, 0, 0, 1, 1},
	{"yaft-256color", 13, 256, 1, 1, 1, 1, 0, 1, 1},
	{"z29a", 4, -1, 1, 1, 1, 0, 0, 1, 0},
	{"z29a-kc-bc", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"z29a-kc-uc", 10, -1, 1, 1, 1, 0, 0, 1, 0},
	{"z29a-nkc-bc", 11, -1, 1, 1, 1, 0, 0, 1, 0},
	{"z29a-nkc-uc", 11, -1, 1, 1, 1, 0, 0, 1, 0},
	{"z340", 4, -1, 1, 1, 1, 1, 0, 1, 1},
	{"z340-nam", 8, -1, 1, 1, 1, 1, 0, 1, 1},
	{"z39-a", 5, -1, 1, 1, 1, 1, 0, 1, 0},
	{"z39a", 4, -1, 1, 1, 1, 1, 0, 1, 0},
	{"zenith39-a", 10, -1, 1, 1, 1, 1, 0, 1, 0},
	{"zenith39-ansi", 13, -1, 1, 1, 1, 1, 0, 1, 0},
	{NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

#endif /* TERM_INFO_H */
