#!/bin/bash

# If this script is not run by Xcode, PROJECT_DIR needs to be set
if [ -z "$PROJECT_DIR" ]; then
	PROJECT_DIR=".";
fi

SCRIPTNAME=$(basename "$0")

cd "$PROJECT_DIR/Actions" || exit 1
echo -e "// DO NOT EDIT THIS FILE.\n// This file is written automatically by the script $SCRIPTNAME\n// and is triggered by an Xcode “Run Script” build phase or from the Makefile." > "../ActionClassesMacro.h"
echo "#define ACTION_CLASSES \\" >> "../ActionClassesMacro.h"
find . -name '*Action.m' ! -name '*BaseAction.m' | perl -p -e 's=^\./(.*)\.m$=        @"$1", \\=;' >> "../ActionClassesMacro.h"
echo "        nil" >> "../ActionClassesMacro.h"
