/**
 * @file tests/test_thread_pool_executor.cc
 *
 * Copyright (c) 2021-2025 Bartek Kryza <bkryza@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#define DOCTEST_CONFIG_IMPLEMENT_WITH_MAIN

#include "doctest/doctest.h"

#include "util/thread_pool_executor.h"

TEST_CASE("Test thread_pool_executor")
{
    using clanguml::util::thread_pool_executor;

    thread_pool_executor pool{4};

    std::atomic_int counter{0};

    std::vector<std::future<void>> futs;

    const unsigned int kTaskCount = 1000;

    for (auto i = 0U; i < kTaskCount; i++) {
        futs.emplace_back(pool.add([&counter]() { counter++; }));
    }

    for (auto &f : futs) {
        f.get();
    }

    CHECK(counter == kTaskCount);
}
