# t20030 - Constructor and operator call test case
## Config
```yaml
diagrams:
  t20030_sequence:
    type: sequence
    glob:
      - t20030.cc
    include:
      namespaces:
        - clanguml::t20030
    using_namespace: clanguml::t20030
    from:
      - function: "clanguml::t20030::tmain(int)"
      - function: "clanguml::t20030::tmain(bool,int)"
```
## Source code
File `tests/t20030/t20030.cc`
```cpp
namespace clanguml {
namespace t20030 {

int magic() { return 42; }

class A {
public:
    A() { create(); }

    A(int v) { a_ = v; }

    A &operator=(const A &a)
    {
        set(a.a_);
        return *this;
    }

    A &operator+=(int a)
    {
        add(a);
        return *this;
    }

    int value() const { return a_; }

private:
    void create() { a_ = 0; }

    void add(int a) { a_ += a; }
    void set(int a) { a_ = a; }

    int a_;
};

void tmain(int a)
{
    A an_a{magic()};
    an_a += 1;
}

int tmain(bool f, int a)
{
    auto an_a = A();
    auto an_b = A();
    an_a += 2;
    an_b = an_a;
    return an_b.value();
};

}
}
```
## Generated PlantUML diagrams
![t20030_sequence](./t20030_sequence.svg "Constructor and operator call test case")
## Generated Mermaid diagrams
![t20030_sequence](./t20030_sequence_mermaid.svg "Constructor and operator call test case")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20030_sequence",
  "participants": [
    {
      "display_name": "tmain(int)",
      "full_name": "clanguml::t20030::tmain(int)",
      "id": "10117148495871364237",
      "name": "tmain",
      "namespace": "clanguml::t20030",
      "source_location": {
        "column": 6,
        "file": "t20030.cc",
        "line": 35,
        "translation_unit": "t20030.cc"
      },
      "type": "function"
    },
    {
      "display_name": "magic()",
      "full_name": "clanguml::t20030::magic()",
      "id": "8309924522937711738",
      "name": "magic",
      "namespace": "clanguml::t20030",
      "source_location": {
        "column": 5,
        "file": "t20030.cc",
        "line": 4,
        "translation_unit": "t20030.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "A(int)",
          "full_name": "clanguml::t20030::A::A(int)",
          "id": "17538385349139019117",
          "name": "A",
          "namespace": "clanguml::t20030",
          "source_location": {
            "column": 5,
            "file": "t20030.cc",
            "line": 10,
            "translation_unit": "t20030.cc"
          },
          "type": "method"
        },
        {
          "display_name": "operator+=(int)",
          "full_name": "clanguml::t20030::A::operator+=(int)",
          "id": "16257343976980384640",
          "name": "operator+=",
          "namespace": "clanguml::t20030",
          "source_location": {
            "column": 8,
            "file": "t20030.cc",
            "line": 18,
            "translation_unit": "t20030.cc"
          },
          "type": "method"
        },
        {
          "display_name": "add(int)",
          "full_name": "clanguml::t20030::A::add(int)",
          "id": "17398619456540928995",
          "name": "add",
          "namespace": "clanguml::t20030",
          "source_location": {
            "column": 10,
            "file": "t20030.cc",
            "line": 29,
            "translation_unit": "t20030.cc"
          },
          "type": "method"
        },
        {
          "display_name": "A()",
          "full_name": "clanguml::t20030::A::A()",
          "id": "257479330359087325",
          "name": "A",
          "namespace": "clanguml::t20030",
          "source_location": {
            "column": 5,
            "file": "t20030.cc",
            "line": 8,
            "translation_unit": "t20030.cc"
          },
          "type": "method"
        },
        {
          "display_name": "create()",
          "full_name": "clanguml::t20030::A::create()",
          "id": "7124624800553113510",
          "name": "create",
          "namespace": "clanguml::t20030",
          "source_location": {
            "column": 10,
            "file": "t20030.cc",
            "line": 27,
            "translation_unit": "t20030.cc"
          },
          "type": "method"
        },
        {
          "display_name": "operator=(const A &)",
          "full_name": "clanguml::t20030::A::operator=(const A &)",
          "id": "14370429480709603169",
          "name": "operator=",
          "namespace": "clanguml::t20030",
          "source_location": {
            "column": 8,
            "file": "t20030.cc",
            "line": 12,
            "translation_unit": "t20030.cc"
          },
          "type": "method"
        },
        {
          "display_name": "set(int)",
          "full_name": "clanguml::t20030::A::set(int)",
          "id": "17703828086209787307",
          "name": "set",
          "namespace": "clanguml::t20030",
          "source_location": {
            "column": 10,
            "file": "t20030.cc",
            "line": 30,
            "translation_unit": "t20030.cc"
          },
          "type": "method"
        },
        {
          "display_name": "value() const",
          "full_name": "clanguml::t20030::A::value() const",
          "id": "14039658723010215747",
          "name": "value",
          "namespace": "clanguml::t20030",
          "source_location": {
            "column": 9,
            "file": "t20030.cc",
            "line": 24,
            "translation_unit": "t20030.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A",
      "full_name": "clanguml::t20030::A",
      "id": "8653656918787685622",
      "name": "A",
      "namespace": "clanguml::t20030",
      "source_location": {
        "column": 7,
        "file": "t20030.cc",
        "line": 6,
        "translation_unit": "t20030.cc"
      },
      "type": "class"
    },
    {
      "display_name": "tmain(bool,int)",
      "full_name": "clanguml::t20030::tmain(bool,int)",
      "id": "288724919109363868",
      "name": "tmain",
      "namespace": "clanguml::t20030",
      "source_location": {
        "column": 5,
        "file": "t20030.cc",
        "line": 41,
        "translation_unit": "t20030.cc"
      },
      "type": "function"
    }
  ],
  "sequences": [
    {
      "from": {
        "id": "10117148495871364237",
        "location": "clanguml::t20030::tmain(int)"
      },
      "messages": [
        {
          "from": {
            "activity_id": "10117148495871364237",
            "participant_id": "10117148495871364237"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 12,
            "file": "t20030.cc",
            "line": 37,
            "translation_unit": "t20030.cc"
          },
          "to": {
            "activity_id": "8309924522937711738",
            "participant_id": "8309924522937711738"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "8309924522937711738",
            "participant_id": "8309924522937711738"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 15,
            "file": "t20030.cc",
            "line": 4,
            "translation_unit": "t20030.cc"
          },
          "to": {
            "activity_id": "10117148495871364237",
            "participant_id": "10117148495871364237"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "10117148495871364237",
            "participant_id": "10117148495871364237"
          },
          "name": "A(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 7,
            "file": "t20030.cc",
            "line": 37,
            "translation_unit": "t20030.cc"
          },
          "to": {
            "activity_id": "17538385349139019117",
            "participant_id": "8653656918787685622"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "10117148495871364237",
            "participant_id": "10117148495871364237"
          },
          "name": "operator+=(int)",
          "return_type": "A &",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20030.cc",
            "line": 38,
            "translation_unit": "t20030.cc"
          },
          "to": {
            "activity_id": "16257343976980384640",
            "participant_id": "8653656918787685622"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "16257343976980384640",
            "participant_id": "8653656918787685622"
          },
          "name": "add(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20030.cc",
            "line": 20,
            "translation_unit": "t20030.cc"
          },
          "to": {
            "activity_id": "17398619456540928995",
            "participant_id": "8653656918787685622"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "16257343976980384640",
            "participant_id": "8653656918787685622"
          },
          "name": "",
          "return_type": "A &",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20030.cc",
            "line": 21,
            "translation_unit": "t20030.cc"
          },
          "to": {
            "activity_id": "10117148495871364237",
            "participant_id": "10117148495871364237"
          },
          "type": "return"
        }
      ]
    },
    {
      "from": {
        "id": "288724919109363868",
        "location": "clanguml::t20030::tmain(bool,int)"
      },
      "messages": [
        {
          "from": {
            "activity_id": "288724919109363868",
            "participant_id": "288724919109363868"
          },
          "name": "A()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20030.cc",
            "line": 43,
            "translation_unit": "t20030.cc"
          },
          "to": {
            "activity_id": "257479330359087325",
            "participant_id": "8653656918787685622"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "257479330359087325",
            "participant_id": "8653656918787685622"
          },
          "name": "create()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 11,
            "file": "t20030.cc",
            "line": 8,
            "translation_unit": "t20030.cc"
          },
          "to": {
            "activity_id": "7124624800553113510",
            "participant_id": "8653656918787685622"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "288724919109363868",
            "participant_id": "288724919109363868"
          },
          "name": "A()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20030.cc",
            "line": 44,
            "translation_unit": "t20030.cc"
          },
          "to": {
            "activity_id": "257479330359087325",
            "participant_id": "8653656918787685622"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "257479330359087325",
            "participant_id": "8653656918787685622"
          },
          "name": "create()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 11,
            "file": "t20030.cc",
            "line": 8,
            "translation_unit": "t20030.cc"
          },
          "to": {
            "activity_id": "7124624800553113510",
            "participant_id": "8653656918787685622"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "288724919109363868",
            "participant_id": "288724919109363868"
          },
          "name": "operator+=(int)",
          "return_type": "A &",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20030.cc",
            "line": 45,
            "translation_unit": "t20030.cc"
          },
          "to": {
            "activity_id": "16257343976980384640",
            "participant_id": "8653656918787685622"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "16257343976980384640",
            "participant_id": "8653656918787685622"
          },
          "name": "add(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20030.cc",
            "line": 20,
            "translation_unit": "t20030.cc"
          },
          "to": {
            "activity_id": "17398619456540928995",
            "participant_id": "8653656918787685622"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "16257343976980384640",
            "participant_id": "8653656918787685622"
          },
          "name": "",
          "return_type": "A &",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20030.cc",
            "line": 21,
            "translation_unit": "t20030.cc"
          },
          "to": {
            "activity_id": "288724919109363868",
            "participant_id": "288724919109363868"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "288724919109363868",
            "participant_id": "288724919109363868"
          },
          "name": "operator=(const A &)",
          "return_type": "A &",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20030.cc",
            "line": 46,
            "translation_unit": "t20030.cc"
          },
          "to": {
            "activity_id": "14370429480709603169",
            "participant_id": "8653656918787685622"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "14370429480709603169",
            "participant_id": "8653656918787685622"
          },
          "name": "set(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20030.cc",
            "line": 14,
            "translation_unit": "t20030.cc"
          },
          "to": {
            "activity_id": "17703828086209787307",
            "participant_id": "8653656918787685622"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "14370429480709603169",
            "participant_id": "8653656918787685622"
          },
          "name": "",
          "return_type": "A &",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20030.cc",
            "line": 15,
            "translation_unit": "t20030.cc"
          },
          "to": {
            "activity_id": "288724919109363868",
            "participant_id": "288724919109363868"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "288724919109363868",
            "participant_id": "288724919109363868"
          },
          "name": "value() const",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 12,
            "file": "t20030.cc",
            "line": 47,
            "translation_unit": "t20030.cc"
          },
          "to": {
            "activity_id": "14039658723010215747",
            "participant_id": "8653656918787685622"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "14039658723010215747",
            "participant_id": "8653656918787685622"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 25,
            "file": "t20030.cc",
            "line": 24,
            "translation_unit": "t20030.cc"
          },
          "to": {
            "activity_id": "288724919109363868",
            "participant_id": "288724919109363868"
          },
          "type": "return"
        }
      ]
    }
  ],
  "using_namespace": "clanguml::t20030"
}
```
## Generated GraphML models
