# t20023 - Try/catch statement sequence diagram test case
## Config
```yaml
diagrams:
  t20023_sequence:
    type: sequence
    glob:
      - t20023.cc
    include:
      namespaces:
        - clanguml::t20023
    using_namespace: clanguml::t20023
    from:
      - function: "clanguml::t20023::tmain()"
```
## Source code
File `tests/t20023/t20023.cc`
```cpp
#include <stdexcept>

namespace clanguml {
namespace t20023 {

struct A {
    int a1() { return 1; }
    int a2() { return 2; }
    int a3() { return 3; }
    int a4() { return 3; }

    int a()
    {
        try {
            return a1();
        }
        catch (std::runtime_error &) {
            return a2();
        }
        catch (std::logic_error &) {
            return a3();
        }
        catch (...) {
            return a4();
        }
    }
};

int tmain()
{
    A a;

    int result{};

    result = a.a();

    return result;
}
}
}
```
## Generated PlantUML diagrams
![t20023_sequence](./t20023_sequence.svg "Try/catch statement sequence diagram test case")
## Generated Mermaid diagrams
![t20023_sequence](./t20023_sequence_mermaid.svg "Try/catch statement sequence diagram test case")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20023_sequence",
  "participants": [
    {
      "display_name": "tmain()",
      "full_name": "clanguml::t20023::tmain()",
      "id": "6092418113081260088",
      "name": "tmain",
      "namespace": "clanguml::t20023",
      "source_location": {
        "column": 5,
        "file": "t20023.cc",
        "line": 29,
        "translation_unit": "t20023.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "a()",
          "full_name": "clanguml::t20023::A::a()",
          "id": "4245210562217509581",
          "name": "a",
          "namespace": "clanguml::t20023",
          "source_location": {
            "column": 9,
            "file": "t20023.cc",
            "line": 12,
            "translation_unit": "t20023.cc"
          },
          "type": "method"
        },
        {
          "display_name": "a1()",
          "full_name": "clanguml::t20023::A::a1()",
          "id": "753080911460153665",
          "name": "a1",
          "namespace": "clanguml::t20023",
          "source_location": {
            "column": 9,
            "file": "t20023.cc",
            "line": 7,
            "translation_unit": "t20023.cc"
          },
          "type": "method"
        },
        {
          "display_name": "a2()",
          "full_name": "clanguml::t20023::A::a2()",
          "id": "16483505431192115726",
          "name": "a2",
          "namespace": "clanguml::t20023",
          "source_location": {
            "column": 9,
            "file": "t20023.cc",
            "line": 8,
            "translation_unit": "t20023.cc"
          },
          "type": "method"
        },
        {
          "display_name": "a3()",
          "full_name": "clanguml::t20023::A::a3()",
          "id": "14215418076972824143",
          "name": "a3",
          "namespace": "clanguml::t20023",
          "source_location": {
            "column": 9,
            "file": "t20023.cc",
            "line": 9,
            "translation_unit": "t20023.cc"
          },
          "type": "method"
        },
        {
          "display_name": "a4()",
          "full_name": "clanguml::t20023::A::a4()",
          "id": "8660701586993990509",
          "name": "a4",
          "namespace": "clanguml::t20023",
          "source_location": {
            "column": 9,
            "file": "t20023.cc",
            "line": 10,
            "translation_unit": "t20023.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A",
      "full_name": "clanguml::t20023::A",
      "id": "6005106358402876931",
      "name": "A",
      "namespace": "clanguml::t20023",
      "source_location": {
        "column": 8,
        "file": "t20023.cc",
        "line": 6,
        "translation_unit": "t20023.cc"
      },
      "type": "class"
    }
  ],
  "sequences": [
    {
      "from": {
        "id": "6092418113081260088",
        "location": "clanguml::t20023::tmain()"
      },
      "messages": [
        {
          "from": {
            "activity_id": "6092418113081260088",
            "participant_id": "6092418113081260088"
          },
          "name": "a()",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 14,
            "file": "t20023.cc",
            "line": 35,
            "translation_unit": "t20023.cc"
          },
          "to": {
            "activity_id": "4245210562217509581",
            "participant_id": "6005106358402876931"
          },
          "type": "message"
        },
        {
          "activity_id": "4245210562217509581",
          "branches": [
            {
              "messages": [
                {
                  "from": {
                    "activity_id": "4245210562217509581",
                    "participant_id": "6005106358402876931"
                  },
                  "name": "a1()",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 20,
                    "file": "t20023.cc",
                    "line": 15,
                    "translation_unit": "t20023.cc"
                  },
                  "to": {
                    "activity_id": "753080911460153665",
                    "participant_id": "6005106358402876931"
                  },
                  "type": "message"
                },
                {
                  "from": {
                    "activity_id": "753080911460153665",
                    "participant_id": "6005106358402876931"
                  },
                  "name": "",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 16,
                    "file": "t20023.cc",
                    "line": 7,
                    "translation_unit": "t20023.cc"
                  },
                  "to": {
                    "activity_id": "4245210562217509581",
                    "participant_id": "6005106358402876931"
                  },
                  "type": "return"
                },
                {
                  "from": {
                    "activity_id": "4245210562217509581",
                    "participant_id": "6005106358402876931"
                  },
                  "name": "",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 13,
                    "file": "t20023.cc",
                    "line": 15,
                    "translation_unit": "t20023.cc"
                  },
                  "to": {
                    "activity_id": "6092418113081260088",
                    "participant_id": "6092418113081260088"
                  },
                  "type": "return"
                }
              ],
              "type": "main"
            },
            {
              "messages": [
                {
                  "from": {
                    "activity_id": "4245210562217509581",
                    "participant_id": "6005106358402876931"
                  },
                  "name": "a2()",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 20,
                    "file": "t20023.cc",
                    "line": 18,
                    "translation_unit": "t20023.cc"
                  },
                  "to": {
                    "activity_id": "16483505431192115726",
                    "participant_id": "6005106358402876931"
                  },
                  "type": "message"
                },
                {
                  "from": {
                    "activity_id": "16483505431192115726",
                    "participant_id": "6005106358402876931"
                  },
                  "name": "",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 16,
                    "file": "t20023.cc",
                    "line": 8,
                    "translation_unit": "t20023.cc"
                  },
                  "to": {
                    "activity_id": "4245210562217509581",
                    "participant_id": "6005106358402876931"
                  },
                  "type": "return"
                },
                {
                  "from": {
                    "activity_id": "4245210562217509581",
                    "participant_id": "6005106358402876931"
                  },
                  "name": "",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 13,
                    "file": "t20023.cc",
                    "line": 18,
                    "translation_unit": "t20023.cc"
                  },
                  "to": {
                    "activity_id": "6092418113081260088",
                    "participant_id": "6092418113081260088"
                  },
                  "type": "return"
                }
              ],
              "type": "catch"
            },
            {
              "messages": [
                {
                  "from": {
                    "activity_id": "4245210562217509581",
                    "participant_id": "6005106358402876931"
                  },
                  "name": "a3()",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 20,
                    "file": "t20023.cc",
                    "line": 21,
                    "translation_unit": "t20023.cc"
                  },
                  "to": {
                    "activity_id": "14215418076972824143",
                    "participant_id": "6005106358402876931"
                  },
                  "type": "message"
                },
                {
                  "from": {
                    "activity_id": "14215418076972824143",
                    "participant_id": "6005106358402876931"
                  },
                  "name": "",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 16,
                    "file": "t20023.cc",
                    "line": 9,
                    "translation_unit": "t20023.cc"
                  },
                  "to": {
                    "activity_id": "4245210562217509581",
                    "participant_id": "6005106358402876931"
                  },
                  "type": "return"
                },
                {
                  "from": {
                    "activity_id": "4245210562217509581",
                    "participant_id": "6005106358402876931"
                  },
                  "name": "",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 13,
                    "file": "t20023.cc",
                    "line": 21,
                    "translation_unit": "t20023.cc"
                  },
                  "to": {
                    "activity_id": "6092418113081260088",
                    "participant_id": "6092418113081260088"
                  },
                  "type": "return"
                }
              ],
              "type": "catch"
            },
            {
              "messages": [
                {
                  "from": {
                    "activity_id": "4245210562217509581",
                    "participant_id": "6005106358402876931"
                  },
                  "name": "a4()",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 20,
                    "file": "t20023.cc",
                    "line": 24,
                    "translation_unit": "t20023.cc"
                  },
                  "to": {
                    "activity_id": "8660701586993990509",
                    "participant_id": "6005106358402876931"
                  },
                  "type": "message"
                },
                {
                  "from": {
                    "activity_id": "8660701586993990509",
                    "participant_id": "6005106358402876931"
                  },
                  "name": "",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 16,
                    "file": "t20023.cc",
                    "line": 10,
                    "translation_unit": "t20023.cc"
                  },
                  "to": {
                    "activity_id": "4245210562217509581",
                    "participant_id": "6005106358402876931"
                  },
                  "type": "return"
                },
                {
                  "from": {
                    "activity_id": "4245210562217509581",
                    "participant_id": "6005106358402876931"
                  },
                  "name": "",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 13,
                    "file": "t20023.cc",
                    "line": 24,
                    "translation_unit": "t20023.cc"
                  },
                  "to": {
                    "activity_id": "6092418113081260088",
                    "participant_id": "6092418113081260088"
                  },
                  "type": "return"
                }
              ],
              "type": "catch"
            }
          ],
          "name": "try",
          "type": "break"
        }
      ]
    }
  ],
  "using_namespace": "clanguml::t20023"
}
```
## Generated GraphML models
